<?php

if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

class Kategori extends CI_Controller {
	function __construct() {
		parent::__construct();
		is_logged();
		$this->load->model('Kategori_model');
		$this->load->library('form_validation');
	}

	public function index() {
		$q = urldecode($this->input->get('q', TRUE));
		$start = intval($this->input->get('start'));

		if ($q != '') {
			$config['base_url'] = base_url() . 'kategori/index.html?q=' . urlencode($q);
			$config['first_url'] = base_url() . 'kategori/index.html?q=' . urlencode($q);
		} else {
			$config['base_url'] = base_url() . 'kategori/index.html';
			$config['first_url'] = base_url() . 'kategori/index.html';
		}

		$config['per_page'] = 10;
		$config['page_query_string'] = TRUE;
		$config['total_rows'] = $this->Kategori_model->total_rows($q);
		$kategori = $this->Kategori_model->get_limit_data($config['per_page'], $start, $q);

		$this->load->library('pagination');
		$this->pagination->initialize($config);

		$data = array(
			'kategori_data' => $kategori,
			'q' => $q,
			'pagination' => $this->pagination->create_links(),
			'total_rows' => $config['total_rows'],
			'start' => $start,
			'content' => 'backend/kategori/kategori_list',
		);
		$this->load->view(layout(), $data);
	}

	public function read($id) {
		$row = $this->Kategori_model->get_by_id($id);
		if ($row) {
			$data = array(
				'id_kat' => $row->id_kat,
				'cat_name' => $row->cat_name,
				'note' => $row->note,
				'for_modul' => $row->for_modul, 'content' => 'backend/kategori/kategori_read',
			);
			$this->load->view(
				layout(), $data);
		} else {
			$this->session->set_flashdata('message', 'Record Not Found');
			redirect(site_url('kategori'));
		}
	}

	public function create() {
		$data = array(
			'button' => 'Tambah',
			'action' => site_url('kategori/create_action'),
			'id_kat' => set_value('id_kat'),
			'cat_name' => set_value('cat_name'),
			'note' => set_value('note'),
			'data_for_modul' => ["" => ">> Pilih", "jenis_perangkat" => "Jenis Perangkat", "jenis_lokasi" => "Jenis Lokasi"],
			'for_modul' => set_value('for_modul'),
			'content' => 'backend/kategori/kategori_form',
		);
		$this->load->view(layout(), $data);
	}

	public function create_action() {
		$this->_rules();

		if ($this->form_validation->run() == FALSE) {
			$this->create();
		} else {
			$data = array(
				'cat_name' => $this->input->post('cat_name', TRUE),
				'note' => $this->input->post('note', TRUE),
				'for_modul' => $this->input->post('for_modul', TRUE),
			);

			$this->Kategori_model->insert($data);
			$this->session->set_flashdata('message', 'Create Record Success');
			redirect(site_url('kategori'));
		}
	}

	public function update($id) {
		$row = $this->Kategori_model->get_by_id($id);

		if ($row) {
			$data = array(
				'button' => 'Edit',
				'action' => site_url('kategori/update_action'),
				'id_kat' => set_value('id_kat', $row->id_kat),
				'cat_name' => set_value('cat_name', $row->cat_name),
				'note' => set_value('note', $row->note),
				'data_for_modul' => ["" => ">> Pilih", "jenis_perangkat" => "Jenis Perangkat", "jenis_lokasi" => "Jenis Lokasi"],
				'for_modul' => set_value('for_modul', $row->for_modul),
				'content' => 'backend/kategori/kategori_form',
			);
			$this->load->view(layout(), $data);
		} else {
			$this->session->set_flashdata('message', 'Record Not Found');
			redirect(site_url('kategori'));
		}
	}

	public function update_action() {
		$this->_rules();

		if ($this->form_validation->run() == FALSE) {
			$this->update($this->input->post('id_kat', TRUE));
		} else {
			$data = array(
				'cat_name' => $this->input->post('cat_name', TRUE),
				'note' => $this->input->post('note', TRUE),
				'for_modul' => $this->input->post('for_modul', TRUE),
			);

			$this->Kategori_model->update($this->input->post('id_kat', TRUE), $data);
			$this->session->set_flashdata('message', 'Update Record Success');
			redirect(site_url('kategori'));
		}
	}

	public function delete($id) {
		$row = $this->Kategori_model->get_by_id($id);

		if ($row) {
			$this->Kategori_model->delete($id);
			$this->session->set_flashdata('message', 'Delete Record Success');
			redirect(site_url('kategori'));
		} else {
			$this->session->set_flashdata('message', 'Record Not Found');
			redirect(site_url('kategori'));
		}
	}

	public function _rules() {
		$this->form_validation->set_rules('cat_name', 'cat name', 'trim|required');
		$this->form_validation->set_rules('note', 'note', 'trim');
		$this->form_validation->set_rules('for_modul', 'for modul', 'trim|required');

		$this->form_validation->set_rules('id_kat', 'id_kat', 'trim');
		$this->form_validation->set_error_delimiters('<span class="text-danger">', '</span>');
	}

	public function excel() {
		$this->load->helper('exportexcel');
		$namaFile = "kategori.xls";
		$judul = "kategori";
		$tablehead = 0;
		$tablebody = 1;
		$nourut = 1;
		//penulisan header
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");
		header("Content-Disposition: attachment;filename=" . $namaFile . "");
		header("Content-Transfer-Encoding: binary ");

		xlsBOF();

		$kolomhead = 0;
		xlsWriteLabel($tablehead, $kolomhead++, "No");
		xlsWriteLabel($tablehead, $kolomhead++, "Cat Name");
		xlsWriteLabel($tablehead, $kolomhead++, "Note");
		xlsWriteLabel($tablehead, $kolomhead++, "For Modul");

		foreach ($this->Kategori_model->get_all() as $data) {
			$kolombody = 0;

			//ubah xlsWriteLabel menjadi xlsWriteNumber untuk kolom numeric
			xlsWriteNumber($tablebody, $kolombody++, $nourut);
			xlsWriteLabel($tablebody, $kolombody++, $data->cat_name);
			xlsWriteLabel($tablebody, $kolombody++, $data->note);
			xlsWriteLabel($tablebody, $kolombody++, $data->for_modul);

			$tablebody++;
			$nourut++;
		}

		xlsEOF();
		exit();
	}

}

/* End of file Kategori.php */
/* Location: ./application/controllers/Kategori.php */
/* Please DO NOT modify this information : */
/* Generated by Harviacode Codeigniter CRUD Generator 2018-07-02 10:06:01 */
/* http://harviacode.com */