# fastMRI Examples

This directory contains examples for fastMRI models and data. A brief summary
follows with links to code. We also have code for downloading pretrained models
for the U-Net and VarNet models. See the respective READMEs and folders for
further details.

* **Baseline Models**

  * [Zero-filled examples for saving images for leaderboard submission](zero_filled/)
  * [ESPIRiT—an eigenvalue approach to autocalibrating parallel MRI: where SENSE meets GRAPPA (M. Uecker et al., 2013)](cs/)
  * [U-Net: Convolutional networks for biomedical image segmentation (O. Ronneberger et al., 2015)](unet/)

* **fastMRI Models**

  * [End-to-End Variational Networks for Accelerated MRI Reconstruction ({A. Sriram*, J. Zbontar*} et al., 2020)](varnet/)
  * [On learning adaptive acquisition policies for undersampled multi-coil MRI reconstruction (T. Bakker et al., 2021)](adaptive_varnet/)
  * [Accelerated MRI reconstructions via variational network and feature domain learning (I. Giannakopoulos et al., 2024)](feature_varnet/)
