/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "cachelib/navy/common/Buffer.h"
#include "cachelib/navy/common/Hash.h"
#include "cachelib/navy/common/Types.h"

namespace facebook {
namespace cachelib {
namespace navy {
class AdmissionPolicy {
 public:
  virtual ~AdmissionPolicy() = default;

  // Returns false if insert should be ignored.
  // @param hk   HashedKey to be tested
  // @param value  value to be tested.
  // @param writeSize  estimated write size for device endurance purpose.
  virtual bool accept(HashedKey hk,
                      BufferView value,
                      uint64_t estimatedWriteSize = 0) = 0;

  // Reset policy to the initial state
  virtual void reset() = 0;

  // Get policy specific counters. Calls back @visitor with key name and value.
  virtual void getCounters(const CounterVisitor& visitor) const = 0;
};
} // namespace navy
} // namespace cachelib
} // namespace facebook
