# Contributing to CacheLib
We want to make contributing to this project as easy and transparent as
possible. 

## Code of Conduct
The code of conduct is described in [`CODE_OF_CONDUCT.md`](CODE_OF_CONDUCT.md).

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Contributing improvements to CacheLib

We love seeing CacheLib being widely adopted and useful among the industry and
in other open source projects. If you'd like to leverage CacheLib in your
project and are facing challenges, please reach out to us on any feedback to
enable your adoption. This feedback is useful for us to help shape the future
features of CacheLib. 

If you are leveraging CacheLib in your application, we welcome any bug fixes,
build fixes, documentation improvements 
and feature improvements that you would like to see become part of CacheLib.

We look forward to seeing CacheLib be used to prototype new innovative designs
for cache hueristics and cache storage. When doing so, please open pull
request for the new feature with a good summary describing the change, the
design and how the feature was tested. Additionally, CacheBench offers a
platform to evaluate these prototypes against industry standard workloads.  We
would like to represent significant caching workloads in CacheBench to help
the community understand caching challenges. 


## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. If you haven't already, complete the Contributor License Agreement ("CLA").


## Issues
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.

## License
By contributing to CacheLib, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
