# Generating App & "favicons"

"Favicons" and Android/iOS icons only need to be generated when the art is updated.

They are not included in the repository. You'll only need to build them once.

For more info, see http://realfavicongenerator.net

## First time setup

From the *web* container, install the Node.js [Favicon Generator](https://realfavicongenerator.net/favicon/node_cli)

    $ npm install cli-real-favicon

The following **alias** should be available (cf. docker/php-apache/bash/.bash_aliases):

    alias real-favicon=./node_modules/.bin/real-favicon


## Re-generating icons

Now generate the icons, this will add a bunch of files to `web/favicons/`
```shell
real-favicon generate batch/favicon/faviconDescription.json batch/favicon/faviconData.json web/favicons
```

You can skip this. But in case their tool is updated, we can use the "inject" option to see if our markup is still correct. We create a minimal html file, and manually copy the markup to `apps/koohii/templates/layout.php`.

```shell
real-favicon inject batch/favicon/faviconData.json web/favicons batch/favicon/inject-favicons.html
```

This creates `web/favicons/inject-favicons.html`. We ignore this file since it is part of generated files folder excluded by .gitignore.


## Structure

The favicon resources are in `batch/favicon/`:

    faviconData.json           generated by cli
    faviconDescription.json    copied from the realfavicongenerator.net instructions
    favicon-master.png         our master image (hi res)
    inject-favicons.html       just a html template to inject because we don't want the
                               cli to mess with our templates (which are not html anyway)


