// a grab bag of Koohii specific helpers for now

import { kk_globals_get } from "@app/root-bundle";

/**
 * The site's base url to account for dev/test envs, may have a trailing slash
 * (as generated by Symfony's url_for())
 *
 * Example for local URL: "http://localhost/index_dev.php/"
 * Example for prod URL:  "https://kanji.koohii.com/"
 *
 */
const baseUrlFor = () => {
  return kk_globals_get("BASE_URL") as string;
};

/**
 * The site's base url to account for dev/test envs, NO TRAILING SLASH
 */
export const baseUrl = () => baseUrlFor().replace(/\/$/, "");

/**
 * Return a URL for a kanji study page.
 *
 * @param kanji A single utf8 charactcer
 */
export const urlForStudy = (kanji?: string) =>
  `${baseUrl()}/study` + (kanji ? `/kanji/${kanji}` : "");
