<?php
/**
 * Convert romaji (as string) to kana encoded as utf8 or unicode html entities (&#12345;).
 * 
 * 
 * @author  Fabrice Denis
 */

class romaji
{
  /**
   * Replaces romaji found in ascii string with kana encoded as utf8 characters.
   * 
   * @param  string  romaji text
   * @return string
   */
  static function toUtf8($text)
  {
    $hiragana_double_consonants = [
    '/kk/' => 'っk', '/ss/' => 'っs', '/tt/' => 'っt', '/cch/' => 'っch', '/pp/' => 'っp',
    '/dd/' => 'っd', '/gg/' => 'っg' ];
  
    $hiragana = [
    '/nn/' => 'ん',
    '/fa/' => 'ふぁ', '/fi/' => 'ふぃ', '/fe/' => 'ふぇ', '/fo/' => 'ふぉ',
    '/kya/' => 'きゃ', '/kyu/' => 'きゅ', '/kyo/' => 'きょ',
    '/sha/' => 'しゃ', '/shu/' => 'しゅ', '/sho/' => 'しょ',
    '/cha/' => 'ちゃ', '/chu/' => 'ちゅ', '/cho/' => 'ちょ',
    '/nya/' => 'にゃ', '/nyu/' => 'にゅ', '/nyo/' => 'にょ',
    '/hya/' => 'ひゃ', '/hyu/' => 'ひゅ', '/hyo/' => 'ひょ',
    '/mya/' => 'みゃ', '/myu/' => 'みゅ', '/myo/' => 'みょ',
    '/rya/' => 'りゃ', '/ryu/' => 'りゅ', '/ryo/' => 'りょ',
    '/gya/' => 'ぎゃ', '/gyu/' => 'ぎゅ', '/gyo/' => 'ぎょ',
    '/ja/' => 'じゃ', '/ju/' => 'じゅ', '/jo/' => 'じょ',
    '/dya/' => 'ぢゃ', '/dyu/' => 'ぢゅ', '/dyo/' => 'ぢょ',
    '/bya/' => 'びゃ', '/byu/' => 'びゅ', '/byo/' => 'びょ',
    '/pya/' => 'ぴゃ', '/pyu/' => 'ぴゅ', '/pyo/' => 'ぴょ',
    '/chi/' => 'ち', '/tsu/' => 'つ',
    '/ka/' => 'か', '/ki/' => 'き', '/ku/' => 'く', '/ke/' => 'け', '/ko/' => 'こ',
    '/sa/' => 'さ', '/shi/' => 'し', '/su/' => 'す', '/se/' => 'せ', '/so/' => 'そ',
    '/ta/' => 'た', '/te/' => 'て','/to/' => 'と',
    '/na/' => 'な', '/ni/' => 'に', '/nu/' => 'ぬ', '/ne/' => 'ね', '/no/' => 'の',
    '/ha/' => 'は', '/hi/' => 'ひ', '/fu/' => 'ふ','/he/' => 'へ', '/ho/' => 'ほ',
    '/ma/' => 'ま', '/mi/' => 'み', '/mu/' => 'む', '/me/' => 'め', '/mo/' => 'も',
    '/ya/' => 'や', '/yu/' => 'ゆ','/yo/' => 'よ',
    '/ra/' => 'ら', '/ri/' => 'り', '/ru/' => 'る', '/re/' => 'れ', '/ro/' => 'ろ',
    '/wa/' => 'わ', '/wi/' => 'うぃ', '/we/' => 'うぇ','/wo/' => 'を', '/n/' => 'ん',
    '/ga/' => 'が', '/gi/' => 'ぎ', '/gu/' => 'ぐ', '/ge/' => 'げ', '/go/' => 'ご', '/za/' => 'ざ', '/ji/' => 'じ',
    '/zu/' => 'ず', '/ze/' => 'ぜ', '/zo/' => 'ぞ', '/da/' => 'だ', '/di/' => 'ぢ', '/du/' => 'づ', '/de/' => 'で', '/do/' => 'ど',
    '/ba/' => 'ば', '/bi/' => 'び', '/bu/' => 'ぶ', '/be/' => 'べ', '/bo/' => 'ぼ', '/pa/' => 'ぱ', '/pi/' => 'ぴ', '/pu/' => 'ぷ',
    '/pe/' => 'ぺ', '/po/' => 'ぽ',
    '/a/' => 'あ', '/i/' => 'い', '/u/' => 'う', '/e/' => 'え', '/o/' => 'お' ];
    
    $katakana = [
    '/FA/' => 'ファ', '/FI/' => 'フィ', '/FE/' => 'フェ', '/FO/' => 'フォ',
    '/KYA/' => 'キャ', '/KYU/' => 'キュ', '/KYO/' => 'キョ',
    '/SHA/' => 'シャ', '/SHU/' => 'シュ', '/SHO/' => 'ショ',
    '/CHA/' => 'チャ', '/CHU/' => 'チュ', '/CHO/' => 'チョ',
    '/NYA/' => 'ニャ', '/NYU/' => 'ニュ', '/NYO/' => 'ニョ',
    '/HYA/' => 'ヒャ', '/HYU/' => 'ヒュ', '/HYO/' => 'ヒョ',
    '/MYA/' => 'ミャ', '/MYU/' => 'ミュ', '/MYO/' => 'ミョ',
    '/RYA/' => 'リャ', '/RYU/' => 'リュ', '/RYO/' => 'リョ',
    '/GYA/' => 'ギャ', '/GYU/' => 'ギュ', '/GYO/' => 'ギョ',
    '/JA/' => 'ジャ', '/JU/' => 'ジュ', '/JO/' => 'ジョ',
    '/DYA/' => 'ヂャ', '/DYU/' => 'ヂュ', '/DYO/' => 'ヂョ',
    '/BYA/' => 'ビャ', '/BYU/' => 'ビュ', '/BYO/' => 'ビョ',
    '/PYA/' => 'ピャ', '/PYU/' => 'ピュ', '/PYO/' => 'ピョ',
    
    '/CHI/' => 'チ', '/TSU/' => 'ツ',
    '/KA/' => 'カ', '/KI/' => 'キ', '/KU/' => 'ク', '/KE/' => 'ケ', '/KO/' => 'コ',
    '/SA/' => 'サ', '/SHI/' => 'シ', '/SU/' => 'ス', '/SE/' => 'セ', '/SO/' => 'ソ',
    '/TA/' => 'タ', '/TE/' => 'テ','/TO/' => 'ト',
    '/NA/' => 'ナ', '/NI/' => 'ニ', '/NU/' => 'ヌ', '/NE/' => 'ネ', '/NO/' => 'ノ',
    '/HA/' => 'ハ', '/HI/' => 'ヒ', '/FU/' => 'フ','/HE/' => 'ヘ', '/HO/' => 'ホ',
    '/MA/' => 'マ', '/MI/' => 'ミ', '/MU/' => 'ム', '/ME/' => 'メ', '/MO/' => 'モ',
    '/YA/' => 'ヤ', '/YU/' => 'ユ','/YO/' => 'ヨ',
    '/RA/' => 'ラ', '/RI/' => 'リ', '/RU/' => 'ル', '/RE/' => 'レ', '/RO/' => 'ロ',
    '/WA/' => 'ワ', '/WI/' => 'ウィ', '/WE/' => 'ウェ','/WO/' => 'ヲ', '/N/' => 'ン',
    '/GA/' => 'ガ', '/GI/' => 'ギ', '/GU/' => 'グ', '/GE/' => 'ゲ', '/GO/' => 'ゴ', '/ZA/' => 'ザ', '/JI/' => 'ジ',
    '/ZU/' => 'ズ', '/ZE/' => 'ゼ', '/ZO/' => 'ゾ', '/DA/' => 'ダ', '/DI/' => 'ヂ', '/DU/' => 'ヅ', '/DE/' => 'デ', '/DO/' => 'ド',
    '/BA/' => 'バ', '/BI/' => 'ビ', '/BU/' => 'ブ', '/BE/' => 'ベ', '/BO/' => 'ボ', '/PA/' => 'パ', '/PI/' => 'ピ', '/PU/' => 'プ',
    '/PE/' => 'ペ', '/PO/' => 'ポ',
    '/A/' => 'ア', '/I/' => 'イ', '/U/' => 'ウ', '/E/' => 'エ', '/O/' => 'オ' ];
  
    $k_pos = 0;
    $kana = $text;
  
    $kana = preg_replace(array_keys($hiragana_double_consonants), array_values($hiragana_double_consonants), $kana);
    $kana = preg_replace(array_keys($hiragana), array_values($hiragana), $kana);
    $kana = preg_replace(array_keys($katakana), array_values($katakana), $kana);
  
      return $kana;
  }
  
  /**
   * Replaces romaji found in ascii string with kana encoded as html unicode character references.
   * 
   * @param  string  romaji text
   * @return string
   */
  static function toNCR($text)
  {
    $hiragana_double_consonants = [
    '/kk/' => '&#12387;k', '/ss/' => '&#12387;s', '/tt/' => '&#12387;t', '/tch/' => '&#12387;ch', '/pp/' => '&#12387;p',
    '/dd/' => '&#12387;d', '/gg/' => '&#12387;g',
    /* some special characters */
    '/,/' => '&#12289;', '/\./' => '&#12290;', '/\?/' => '&#65311;', '/`/' => '&#12300;', '/\'/' => '&#12301;'
     ];
    
    $hiragana = [
    '/fa/' => '&#12405;&#12353;', '/fi/' => '&#12405;&#12355;', '/fe/' => '&#12405;&#12359;', '/fo/' => '&#12405;&#12361;',
    '/kya/' => '&#12365;&#12419;', '/kyu/' => '&#12365;&#12421;', '/kyo/' => '&#12365;&#12423;',
    '/sha/' => '&#12375;&#12419;', '/shu/' => '&#12375;&#12421;', '/sho/' => '&#12375;&#12423;',
    '/cha/' => '&#12385;&#12419;', '/chu/' => '&#12385;&#12421;', '/cho/' => '&#12385;&#12423;',
    '/nya/' => '&#12395;&#12419;', '/nyu/' => '&#12395;&#12421;', '/nyo/' => '&#12395;&#12423;',
    '/hya/' => '&#12402;&#12419;', '/hyu/' => '&#12402;&#12421;', '/hyo/' => '&#12402;&#12423;',
    '/mya/' => '&#12415;&#12419;', '/myu/' => '&#12415;&#12421;', '/myo/' => '&#12415;&#12423;',
    '/rya/' => '&#12426;&#12419;', '/ryu/' => '&#12426;&#12421;', '/ryo/' => '&#12426;&#12423;',
    '/gya/' => '&#12366;&#12419;', '/gyu/' => '&#12366;&#12421;', '/gyo/' => '&#12366;&#12423;',
    '/ja/' => '&#12376;&#12419;', '/ju/' => '&#12376;&#12421;', '/jo/' => '&#12376;&#12423;',
    '/dya/' => '&#12386;&#12419;', '/dyu/' => '&#12386;&#12421;', '/dyo/' => '&#12386;&#12423;',
    '/bya/' => '&#12403;&#12419;', '/byu/' => '&#12403;&#12421;', '/byo/' => '&#12403;&#12423;',
    '/pya/' => '&#12404;&#12419;', '/pyu/' => '&#12404;&#12421;', '/pyo/' => '&#12404;&#12423;',
    '/chi/' => '&#12385;', '/tsu/' => '&#12388;',
    '/ka/' => '&#12363;', '/ki/' => '&#12365;', '/ku/' => '&#12367;', '/ke/' => '&#12369;', '/ko/' => '&#12371;',
    '/sa/' => '&#12373;', '/shi/' => '&#12375;', '/su/' => '&#12377;', '/se/' => '&#12379;', '/so/' => '&#12381;',
    '/ta/' => '&#12383;', '/te/' => '&#12390;','/to/' => '&#12392;',
    '/na/' => '&#12394;', '/ni/' => '&#12395;', '/nu/' => '&#12396;', '/ne/' => '&#12397;', '/no/' => '&#12398;',
    '/ha/' => '&#12399;', '/hi/' => '&#12402;', '/fu/' => '&#12405;','/he/' => '&#12408;', '/ho/' => '&#12411;',
    '/ma/' => '&#12414;', '/mi/' => '&#12415;', '/mu/' => '&#12416;', '/me/' => '&#12417;', '/mo/' => '&#12418;',
    '/ya/' => '&#12420;', '/yu/' => '&#12422;','/yo/' => '&#12424;',
    '/ra/' => '&#12425;', '/ri/' => '&#12426;', '/ru/' => '&#12427;', '/re/' => '&#12428;', '/ro/' => '&#12429;',
    '/wa/' => '&#12431;', '/wi/' => '&#12432;', '/we/' => '&#12433;','/wo/' => '&#12434;', '/n/' => '&#12435;',
    '/ga/' => '&#12364;', '/gi/' => '&#12366;', '/gu/' => '&#12368;', '/ge/' => '&#12370;', '/go/' => '&#12372;', '/za/' => '&#12374;', '/ji/' => '&#12376;',
    '/zu/' => '&#12378;', '/ze/' => '&#12380;', '/zo/' => '&#12382;', '/da/' => '&#12384;', '/ji/' => '&#12386;', '/du/' => '&#12389;', '/de/' => '&#12391;', '/do/' => '&#12393;',
    '/ba/' => '&#12400;', '/bi/' => '&#12403;', '/bu/' => '&#12406;', '/be/' => '&#12409;', '/bo/' => '&#12412;', '/pa/' => '&#12401;', '/pi/' => '&#12404;', '/pu/' => '&#12407;',
    '/pe/' => '&#12410;', '/po/' => '&#12413;',
    '/a/' => '&#12354;', '/i/' => '&#12356;', '/u/' => '&#12358;', '/e/' => '&#12360;', '/o/' => '&#12362;' ];
    
    $katakana = [
    '/FA/' => '&#12501;&#12449;', '/FI/' => '&#12501;&#12451;', '/FE/' => '&#12501;&#12455;', '/FO/' => '&#12501;&#12457;',
    '/KYA/' => '&#12461;&#12515;', '/KYU/' => '&#12461;&#12517;', '/KYO/' => '&#12461;&#12519;',
    '/SHA/' => '&#12471;&#12515;', '/SHU/' => '&#12471;&#12517;', '/SHO/' => '&#12471;&#12519;',
    '/CHA/' => '&#12481;&#12515;', '/CHU/' => '&#12481;&#12517;', '/CHO/' => '&#12481;&#12519;',
    '/NYA/' => '&#12491;&#12515;', '/NYU/' => '&#12491;&#12517;', '/NYO/' => '&#12491;&#12519;',
    '/HYA/' => '&#12498;&#12515;', '/HYU/' => '&#12498;&#12517;', '/HYO/' => '&#12498;&#12519;',
    '/MYA/' => '&#12511;&#12515;', '/MYU/' => '&#12511;&#12517;', '/MYO/' => '&#12511;&#12519;',
    '/RYA/' => '&#12522;&#12515;', '/RYU/' => '&#12522;&#12517;', '/RYO/' => '&#12522;&#12519;',
    '/GYA/' => '&#12462;&#12515;', '/GYU/' => '&#12462;&#12517;', '/GYO/' => '&#12462;&#12519;',
    '/JA/' => '&#12472;&#12515;', '/JU/' => '&#12472;&#12517;', '/JO/' => '&#12472;&#12519;',
    '/DYA/' => '&#12482;&#12515;', '/DYU/' => '&#12482;&#12517;', '/DYO/' => '&#12482;&#12519;',
    '/BYA/' => '&#12499;&#12515;', '/BYU/' => '&#12499;&#12517;', '/BYO/' => '&#12499;&#12519;',
    '/PYA/' => '&#12500;&#12515;', '/PYU/' => '&#12500;&#12517;', '/PYO/' => '&#12500;&#12519;',
    '/KA/' => '&#12459;', '/KI/' => '&#12461;', '/KU/' => '&#12463;', '/KE/' => '&#12465;', '/KO/' => '&#12467;',
    '/SA/' => '&#12469;', '/SHI/' => '&#12471;', '/SU/' => '&#12473;', '/SE/' => '&#12475;', '/SO/' => '&#12477;',
    '/TA/' => '&#12479;', '/CHI/' => '&#12481;', '/TSU/' => '&#12484;', '/TE/' => '&#12486;','/TO/' => '&#12488;',
    '/NA/' => '&#12490;', '/NI/' => '&#12491;', '/NU/' => '&#12492;', '/NE/' => '&#12493;', '/NO/' => '&#12494;',
    '/HA/' => '&#12495;', '/HI/' => '&#12402;', '/FU/' => '&#12501;','/HE/' => '&#12504;', '/HO/' => '&#12507;',
    '/MA/' => '&#12510;', '/MI/' => '&#12511;', '/MU/' => '&#12512;', '/ME/' => '&#12513;', '/MO/' => '&#12514;',
    '/YA/' => '&#12516;', '/YU/' => '&#12518;','/YO/' => '&#12520;',
    '/RA/' => '&#12521;', '/RI/' => '&#12522;', '/RU/' => '&#12523;', '/RE/' => '&#12524;', '/RO/' => '&#12525;',
    '/WA/' => '&#12527;', '/WI/' => '&#12528;', '/WE/' => '&#12529;','/WO/' => '&#12530;', '/N/' => '&#12531;',
    '/GA/' => '&#12460;', '/GI/' => '&#12462;', '/GU/' => '&#12464;', '/GE/' => '&#12466;', '/GO/' => '&#12468;', '/ZA/' => '&#12470;', '/JI/' => '&#12472;',
    '/ZU/' => '&#12474;', '/ZE/' => '&#12476;', '/ZO/' => '&#12478;', '/DA/' => '&#12480;', '/JI/' => '&#12472;', '/DU/' => '&#12485;', '/DE/' => '&#12487;', '/DO/' => '&#12489;',
    '/BA/' => '&#12496;', '/BI/' => '&#12499;', '/BU/' => '&#12502;', '/BE/' => '&#12505;', '/BO/' => '&#12508;', '/PA/' => '&#12497;', '/PI/' => '&#12500;', '/PU/' => '&#12503;',
    '/PE/' => '&#12506;', '/PO/' => '&#12509;',
    '/A/' => '&#12450;', '/I/' => '&#12452;', '/U/' => '&#12454;', '/E/' => '&#12456;', '/O/' => '&#12458;' ];
  
    $kana = preg_replace(array_keys($hiragana_double_consonants), array_values($hiragana_double_consonants), $text);
    $kana = preg_replace(array_keys($hiragana), array_values($hiragana), $kana);
    $kana = preg_replace(array_keys($katakana), array_values($katakana), $kana);
      
      return $kana;
  }
}
