# DissectingMalwa.re Lab VMs

This repository contains my download/setup script for the Windows virtual machines I use for Malware Analysis and Software Reverse Engineering. If you are looking for a Linux VM you should check out [Remnux](https://remnux.org/) or [Tsurugi](https://tsurugi-linux.org/).

<p align="center">
  <img src="img/ps1.png">
</p>

## Table of Contents

* [Features](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#features)
* [Screenshots](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#screenshots)
* [Requirements](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#requirements)
* [Installation](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#installation)
* [FAQ](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#faq)
* [Customization](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#customization)
* [Tips & Tricks](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#tips--tricks)
* [Tools and Licensing](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#tools-and-licensing)
* [Contributing](https://github.com/f0wl/MalwareLab_VM-Setup/blob/main/README.md#contributing)

## Features

* The purpose of the script is to download tools, not install them. This leaves the choice of what and where to install it to the user.
* No BoxStarter/Chocolatey trouble!
* Separate Static Code Analysis and Dynamic Analysis VMs. YMMV but this is the approach I prefer!
* Option to skip tools that are not licensed for professional use
* Apply system modifications like: disable ASLR, fix Explorer file/folder views
* Download hypervisor-hiding scripts that match your setup
* Preload debugging symbols for offline use (more on this in the Installation section below)

The tool lists will be updated on a monthly basis!

## Screenshots

### Static Code Analysis VM

<p align="center">
  <img src="img/sca.png">
</p>

### Dynamic Analysis VM

<p align="center">
  <img src="img/da.png">
</p>

## Requirements

* A host machine capable of running both VMs at the same time would be optimal
* 4-8GB+ of RAM and 64GB+ storage per VM
* A hypervisor of your choice
* Windows ISOs (Win 7 SP1, Win 8.1 or Win 10) and matching license keys

## Installation

1. Setup a fresh Windows VM with the Hypervisor you trust or download a [modern.ie VM](https://developer.microsoft.com/en-us/microsoft-edge/tools/vms/) (note that this script is meant to run on x64 VMs). I'm using Windows 7 Ultimate x64 for my VMs, but I also have a secondary debugging VM running Windows 10 Pro to stay up-to-date ;-)

**A few tips for fresh Windows 7 Installs:**

- You might need to install [KB3138612](https://www.microsoft.com/en-us/download/details.aspx?id=51212) to be able to run Windows Update
- Please install [.NET 4.8](https://dotnet.microsoft.com/download/dotnet-framework/thank-you/net48-offline-installer) and afterwards [WMF 5.1](https://www.microsoft.com/en-us/download/details.aspx?id=54616) before running the Powershell script 
- If you want to do yourself a favour: Install a proper Browser right away. Browsing with the old IE is a pain and this install script will open a few Microsoft pages where you will have to click 'Download' :D

2. I'd recommend to create a snapshot or export an .ova/.ovf file of the clean VM.

3. Open a Powershell prompt as an Administrator and run ```Set-ExecutionPolicy Unrestricted``` to allow for Powershell scripts to be run on the system without interference.

4. Download/clone this repository and run ```vm_setup.ps1``` with PowerShell (an elevated prompt is necessary for setting Registry Keys)

Arguments: ```.\vm_setup.ps1 -argument```
* ```-nonCommercial $False``` - skip tools that don't allow commercial use in their licensing terms
* ```-symbols $True``` - this is a post-installation step, make sure to install the "Build Tools for Visual Studio" first. If you just need the most common symbols let it run for a few minutes (< 5-10min) and cancel with Ctrl+C. Going through all the symbols for files present in System32 will take a long time and fill up your drive.

5. Once the script successfully exited you can close the Powershell window and install the downloaded software. By default the files will be saved to a subdirectory called ```downloads``` in the same directory as the ```vm_setup.ps1``` script you executed.

6. Open a new command prompt (Run as Administrator!) and try to upgrade pip first ```py.exe -m pip install --upgrade pip```. Once that is done you can install the Python tools via ```py.exe -m pip install -r python-packages.txt```

7. Once again take a snapshot/backup of the state of the VM with all the tools installed.

## FAQ

### Why not FLARE-VM etc.?

As I mentioned below I am not a big fan of the Boxstarter/Chocolatey install mechanism. Furthermore I prefer to download the tools directly from the developer if possible and choose the e.g. installation path myself. Lastly I like to separate my Static Code Analysis VM from my Dynamic Analysis VM for a couple of reasons: less clutter, faster snapshot restore times, parallel working, to prevent license key theft and so on...

**Nevertheless other VM setup scripts might work better for you, so choose whatever floats your boat and (mis)trust your tools!** 

Here are some great alternatives to my script:
* [Fireeye FLARE-VM](https://github.com/fireeye/flare-vm)
* [SentinelLabs RevCore Tools](https://github.com/SentineLabs/SentinelLabs_RevCore_Tools)

## Customization

Again, there might be one or two tools missing or superfluous for your workflow. Should this be the case you can simply add/remove them to/from the ```.json``` files after cloning the repository to your machine. Feel free to contribute useful tools (see [below](https://github.com/f0wl/MalwareLab_VM-Setup#contributing))!

The tool lists are json files with the following structure:
```{"name": "7Zip", "url": "https://www.7-zip.org/a/7z1900-x64.exe", "nonCommercial": true, "manual": false},```
* ```name``` = Name of the tool
* ```url``` = Download URL
* ```nonCommercial``` = Professional use allowed? Yes -> true, No -> false
* ```manual``` = Requires manual download

## Tips & Tricks

This section will be expanded should there be any Issues while installing or running one of the tools.

<details>
  <summary> Show me! </summary>
  
  <br>
  
  - BinaryNinja is not officially supported on Windows 7 and will produce a graphics driver error when run in VBox/VMware. You can fix this by disabling 3D acceleration. Here is the official [Documentation](https://docs.binary.ninja/guide/troubleshooting.html#virtualbox-and-vmware).
  
</details>

## Tools and Licensing

In the collapsible section below you can find a list of all tools available to download via the script. 

**Warning: Please check the Licenses/Terms and Conditions of the tools before you download any of them! It is the responsiblilty of the user to read, accept and comply with the terms set by the respective developers.**

There are a few commercial tools that do have Trial/Demo versions, but I chose not to include them in this download script. I'll install Microsoft Office, Cerbero Suite, Binary Ninja, VB-Decompiler Pro etc. manually.

<details>
  <summary> 🧰 Click to expand! 🛠️ </summary>
  
### Static Code Analysis
  
| Tool                  | License                                                                                          |
|-----------------------|:------------------------------------------------------------------------------------------------:|
| 010editor             | [Link](https://www.sweetscape.com/010editor/manual/License.htm)                                  |
| 7Zip                  | [Link](https://www.7-zip.org/license.txt)                                                        |
| Amazon Corretto JDK11 | [Link](https://github.com/corretto/corretto-11/blob/develop/LICENSE)                             |
| apktool               | [Link](https://bitbucket.org/iBotPeaches/apktool/src/master/LICENSE)                             |
| AutoIT Extractor      | [Link](https://gitlab.com/x0r19x91/autoit-extractor/-/blob/master/LICENSE)                       |
| Autopsy               | [Link](https://github.com/sleuthkit/autopsy/blob/develop/LICENSE-2.0.txt)                        |
| BiffView              | [Link](http://b2xtranslator.sourceforge.net/#license)                                            |
| Bindiff               | [Link](https://www.zynamics.com/eula.html)                                                       |
| Cryptotester          | n/a (Copyright Demonslay335)                                                                     |
| Cutter                | [Link](https://github.com/rizinorg/cutter/blob/master/COPYING)                                   |
| de4dot-cex            | [Link](https://github.com/ViRb3/de4dot-cex/blob/master/COPYING)                                  |
| DependencyWalker      | [Link](https://www.dependencywalker.com/)                                                        |
| Detect it easy        | [Link](https://github.com/horsicq/DIE-engine/blob/master/LICENSE)                                |
| dnspyEx               | [Link](https://github.com/dnSpyEx/dnSpy/blob/master/dnSpy/dnSpy/LicenseInfo/GPLv3.txt)           |
| dotPeek               | [Link](https://www.jetbrains.com/decompiler/download/license.html)                               |
| Everything            | [Link](https://www.voidtools.com/License.txt)                                                    |
| exiftool              | [Link](https://exiftool.org/#license)                                                            |
| fileinsight           | [Link](https://www.mcafee.com/enterprise/en-us/assets/legal/mcafee-software-free-eula.pdf)       |
| fileinsight-plugins   | [Link](https://github.com/nmantani/FileInsight-plugins/blob/master/LICENSE.txt)                  |
| FLARE capa            | [Link](https://github.com/fireeye/capa/blob/master/LICENSE.txt)                                  |
| FLARE FLOSS           | [Link](https://github.com/fireeye/flare-floss/blob/master/LICENSE.txt)                           |
| Ghidra                | [Link](https://github.com/NationalSecurityAgency/ghidra/blob/master/LICENSE)                     |
| Git for Windows       | [Link](https://github.com/git-for-windows/git/blob/main/COPYING)                                 |
| Golang                | [Link](https://golang.org/LICENSE)                                                               |
| Hashcalc              | [Link](http://www.slavasoft.com/hashcalc/license-agreement.htm)                                  |
| IDA Free              | [Link](https://www.hex-rays.com/products/ida/support/download_freeware/)                         |
| IDR                   | [Link](https://github.com/crypto2011/IDR/blob/master/LICENSE)                                    |
| ILSpy                 | [Link](https://github.com/icsharpcode/ILSpy/blob/master/doc/ILSpyAboutPage.txt)                  |
| ImHex                 | [Link](https://github.com/WerWolv/ImHex/blob/master/LICENSE)                                     |
| innoextract           | [Link](https://github.com/dscharrer/innoextract/blob/master/LICENSE)                             |
| IrfanView             | [Link](https://www.irfanview.com/eula.htm)                                                       |
| IrfanView Plugins     | [Link](https://www.irfanview.com/eula.htm)                                                       |
| jadx                  | [Link](https://github.com/skylot/jadx/blob/master/LICENSE)                                       |
| jd-gui                | [Link](https://github.com/java-decompiler/jd-gui/blob/master/LICENSE)                            |
| lifer                 | [Link](https://github.com/Paul-Tew/lifer/blob/master/LICENSE)                                    |
| LINQPad               | [Link](https://www.linqpad.net/eula.txt)                                                         |
| Manalyze              | [Link](https://github.com/JusticeRage/Manalyze/blob/master/LICENSE.txt)                          |
| NASM                  | [Link](https://www.nasm.us/xdoc/2.15.05/html/nasmdoc1.html#section-1.1.1)                        |
| oledump.py            | [Link](https://blog.didierstevens.com/programs/oledump-py/)                                      |
| PDFStreamDumper       | [Link](http://sandsprite.com/blogs/index.php?uid=7&pid=57)                                       |
| PEBear                | [Link](https://hshrzd.wordpress.com/pe-bear/)                                                    |
| PEid                  | [Link](https://www.softpedia.com/get/Programming/Packers-Crypters-Protectors/PEiD-updated.shtml) |
| PEStudio              | [Link](https://www.winitor.com/features)                                                         |
| PortEx Analyzer       | [Link](https://github.com/katjahahn/PortEx/blob/master/LICENSE)                                  |
| ProcDot               | [Link](https://www.procdot.com/onlinedocumentation.htm)                                          |
| ProcessHacker         | [Link](https://processhacker.sourceforge.io/gpl.php)                                             |
| protectionID          | [Link](https://protectionid.net/)                                                                |
| PyInstaller Extractor | [Link](https://github.com/extremecoders-re/pyinstxtractor/blob/master/LICENSE)                   |
| Python3               | [Link](https://docs.python.org/3/license.html)                                                   |
| qpdf                  | [Link](http://qpdf.sourceforge.net/)                                                             |
| Recaf                 | [Link](https://github.com/Col-E/Recaf/blob/master/LICENSE)                                       |
| Reflexil              | [Link](http://sebastien.lebreton.free.fr/reflexil/#licenseModal)                                 |
| Relyze Desktop        | [Link](https://www.relyze.com/purchase.html)                                                     |
| ResourceHacker        | [Link](http://www.angusj.com/resourcehacker/)                                                    |
| retdec                | [Link](https://github.com/avast/retdec/blob/master/LICENSE)                                      |
| SSView                | [Link](https://www.mitec.cz/ssv.html)                                                            |
| UniExtract2           | [Link](https://github.com/Bioruebe/UniExtract2/blob/master/LICENSE)                              |
| UPX                   | [Link](https://github.com/upx/upx/blob/devel/LICENSE)                                            |
| VBdec                 | [Link](http://sandsprite.com/vbdec/home_edition.html)                                            |
| Volatility            | [Link](https://github.com/volatilityfoundation/volatility/blob/master/LICENSE.txt)               |
| WinSCP                | [Link](https://winscp.net/eng/docs/license)                                                      |
| xorsearch             | [Link](https://blog.didierstevens.com/programs/xorsearch/)                                       |
| Yara                  | [Link](https://github.com/VirusTotal/yara/blob/master/COPYING)                                   |


### Dynamic Analysis

| Tool                    | License                                                                                             |
|-------------------------|:---------------------------------------------------------------------------------------------------:|
| 010editor               | [Link](https://www.sweetscape.com/010editor/manual/License.htm)                                     |
| 7Zip                    | [Link](https://www.7-zip.org/license.txt)                                                           |
| API-Monitor             | [Link](http://www.rohitab.com/apimonitor)                                                           |
| CheatEngine             | [Link](https://github.com/cheat-engine/cheat-engine/blob/master/Cheat%20Engine/release/License.txt) |
| DbgChild                | [Link](https://github.com/David-Reguera-Garcia-Dreg/DbgChild/blob/master/LICENSE)                   |
| ErrorLookup             | [Link](https://github.com/henrypp/errorlookup/blob/master/LICENSE)                                  |
| Everything              | [Link](https://www.voidtools.com/License.txt)                                                       |
| Fake Sandbox Artifacts  | [Link](https://github.com/NavyTitanium/Fake-Sandbox-Artifacts)                                      |
| FileTest                | [Link](https://github.com/ladislav-zezula/FileTest/blob/master/LICENSE)                             |
| HxD                     | [Link](https://mh-nexus.de/en/hxd/license.php)                                                      |
| LordPE                  | [Link](https://www.aldeid.com/wiki/LordPE)                                                          |
| NetworkMiner            | [Link](https://www.netresec.com/?page=NetworkMinerSourceCode)                                       |
| NoVMP                   | [Link](https://github.com/can1357/NoVmp/blob/master/LICENSE)                                        |
| ODbgScriptv2            | [Link](https://sourceforge.net/projects/odbgsrcriptv202/)                                           |
| OllyDbg                 | [Link](http://www.ollydbg.de/download.htm)                                                          |
| OllyDumpEx              | [Link](https://low-priority.appspot.com/ollydumpex/)                                                |
| OllySubScript           | [Link](https://forum.tuts4you.com/files/file/1894-ollysubscript/)                                   | 
| PEBear                  | [Link](https://hshrzd.wordpress.com/pe-bear/)                                                       |  
| PESieve                 | [Link](https://github.com/hasherezade/pe-sieve/blob/master/LICENSE)                                 |
| ProcessHacker           | [Link](https://processhacker.sourceforge.io/gpl.php)                                                | 
| PSDecode                | [Link](https://github.com/R3MRUM/PSDecode)                                                          |
| Python3                 | [Link](https://docs.python.org/3/license.html)                                                      |
| Registry Explorer       | [Link](https://github.com/zodiacon/RegExp/blob/master/LICENSE)                                      |
| Regshot                 | [Link](https://sourceforge.net/projects/regshot/)                                                   |
| scdbg                   | [Link](http://sandsprite.com/blogs/index.php?uid=7&pid=152)                                         |
| Telerik Fiddler Classic | [Link](https://www.telerik.com/purchase/license-agreement/fiddler)                                  |
| ThreadTear              | [Link](https://github.com/GraxCode/threadtear/blob/master/LICENSE)                                  |
| VBoxCloak               | [Link](https://github.com/d4rksystem/VBoxCloak/blob/master/LICENSE)                                 | 
| VMwareCloak             | [Link](https://github.com/d4rksystem/VMwareCloak/blob/main/LICENSE)                                 | 
| WinSCP                  | [Link](https://winscp.net/eng/docs/license)                                                         |
| Wireshark               | [Link](https://www.wireshark.org/faq.html#_how_much_does_wireshark_cost)                            |
| x64dbg                  | [Link](https://github.com/x64dbg/x64dbg/blob/development/LICENSE)                                   |
| xAnalyzer               | [Link](https://github.com/ThunderCls/xAnalyzer/blob/master/LICENSE)                                 |

## Python Tools

| Tool                 | License                                                                            |
|----------------------|:----------------------------------------------------------------------------------:|
| hexdump              | [Link](https://pypi.org/project/hexdump/)                                          |
| malduck              | [Link](https://github.com/CERT-Polska/malduck/blob/master/LICENSE)                 |
| msoffcrypto-tool     | [Link](https://github.com/nolze/msoffcrypto-tool/blob/master/LICENSE.txt)          |
| olefile              | [Link](https://olefile.readthedocs.io/en/latest/License.html)                      |
| oletools             | [Link](https://github.com/decalage2/oletools/blob/master/LICENSE.md)               |
| pefile               | [Link](https://github.com/erocarrera/pefile/blob/master/LICENSE)                   |
| pycryptodome         | [Link](https://github.com/Legrandin/pycryptodome/blob/master/LICENSE.rst)          |
| requests             | [Link](https://github.com/psf/requests/blob/master/LICENSE)                        |
| uncompyle6           | [Link](https://github.com/rocky/python-uncompyle6/blob/master/COPYING)             |
| XLMMacroDeobfuscator | [Link](https://github.com/DissectMalware/XLMMacroDeobfuscator/blob/master/LICENSE) |
| xortool              | [Link](https://github.com/hellman/xortool)                                         |
| yara-python          | [Link](https://github.com/VirusTotal/yara-python/blob/master/LICENSE)              |


## Microsoft Utilities

| Tool                                      | License                                                                                             |
|-------------------------------------------|:---------------------------------------------------------------------------------------------------:|
| Build Tools for Visual Studio 2019        | [Link](https://visualstudio.microsoft.com/downloads/#build-tools-for-visual-studio-2019)            |
| Sysinternals                              | [Link](https://docs.microsoft.com/en-us/sysinternals/)                                              |
| Visual C++ Redistributable 2013           | [Link](https://support.microsoft.com/en-ca/help/2977003/the-latest-supported-visual-c-downloads)    |
| Visual C++ Redistributable 2015,2017,2019 | [Link](https://support.microsoft.com/en-ca/help/2977003/the-latest-supported-visual-c-downloads)    |
| Visual Studio Code                        | [Link](https://code.visualstudio.com/License/)                                                      |
| Windows 10 SDK                            | [Link](https://developer.microsoft.com/en-us/windows/downloads/windows-10-sdk/)                     |

</details>

## Contributing

If you have any suggestions for awesome tools that are missing on these lists and that everyone would profit from or you spot an error somewhere: feel free to open an Issue or send a Pull Request. Same goes for outdated links to packages! Thank you :)

### A few guidelines:

* Directly link to the original download site provided by the developer whenever possible
* Remember to insert the tool and license link into the Readme
* Please stick to the static/dynamic compartmentalization
* Please make sure that Python Tools run on Python3 and are (somewhat) actively maintained
* Be excellent to each other in Issues/PRs 
