-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Host           : 127.0.0.1:3306
-- Database       : c16
-- 
-- Part : #1
-- Version : #v1.6.0
-- Date : 2022-11-16 11:46:06
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='广告表';

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '', 'https://www.baidu.com/', '/uploads/allimg/20200903/1-200Z31F2394D.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '1', '1', '0', 'cn', '1599123781', '1599123781');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', '', 'https://www.baidu.com/', '/uploads/allimg/20200903/1-200Z31F23b30.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '1', '1', '0', 'cn', '1599123781', '1599123781');
INSERT INTO `ey_ad` VALUES ('3', '2', '1', '', '', '/uploads/allimg/20200904/1-200Z41456422O.jpg', '0', '0', '', '', '', '', '0', '', '1', '1', '0', '1', '0', 'cn', '1599202605', '1599202605');
INSERT INTO `ey_ad` VALUES ('4', '2', '1', '', '', '/uploads/allimg/20200904/1-200Z4145642224.jpg', '0', '0', '', '', '', '', '0', '', '1', '2', '0', '1', '0', 'cn', '1599202605', '1599202605');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '广告展示类型，1图片类型，2媒体类型，3HTML代码',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `intro` text NOT NULL COMMENT '广告描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', '首页头部大幻灯', '1', '0', '0', '', '1', 'cn', '1', '0', '1599123781', '1599123781');
INSERT INTO `ey_ad_position` VALUES ('2', '手机端首页头部幻灯', '1', '0', '0', '', '1', 'cn', '1', '0', '1599202605', '1599202605');

-- -----------------------------
-- Table structure for `ey_addon17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_addon17_content`;
CREATE TABLE `ey_addon17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `video` varchar(251) NOT NULL DEFAULT '' COMMENT '视频上传',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_addon17_content`
-- -----------------------------
INSERT INTO `ey_addon17_content` VALUES ('1', '82', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('2', '83', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('3', '84', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('4', '85', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('5', '86', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');
INSERT INTO `ey_addon17_content` VALUES ('6', '87', '1637110204', '1637110204', '/uploads/media/200706/1-200F61RZ5.mp4');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '$2y$11$e6882953e0ecef8598124uzf5BMuHNSECP5mIm3Y4gOb1RnVWMEVG', '', '1668570337', '127.0.0.1', '2', '4e1oclvauhj2mlukjnn77mt8ic', '0', '-1', 'cn', '1', '0', '1668570319', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=115 DEFAULT CHARSET=utf8 COMMENT='管理员操作日志表';

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('114', '1', '后台登录', '127.0.0.1', '/login.php', '1668570337');
INSERT INTO `ey_admin_log` VALUES ('113', '-1', '访问后台', '127.0.0.1', '/login.php', '1668570324');

-- -----------------------------
-- Table structure for `ey_admin_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_menu`;
CREATE TABLE `ey_admin_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT '0',
  `title` varchar(100) DEFAULT '' COMMENT '导航名称',
  `controller_name` varchar(50) DEFAULT '' COMMENT '控制器',
  `action_name` varchar(50) DEFAULT '' COMMENT '方法名',
  `param` varchar(255) DEFAULT '' COMMENT '参数',
  `icon` varchar(50) DEFAULT 'iconfont e-lanmuguanli' COMMENT '图标',
  `is_menu` tinyint(1) DEFAULT '0' COMMENT '是否显示为左侧菜单',
  `is_switch` tinyint(1) DEFAULT '0' COMMENT '是否显示在switch_map页面中',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_id` (`menu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='外挂功能地图菜单表';

-- -----------------------------
-- Records of `ey_admin_menu`
-- -----------------------------
INSERT INTO `ey_admin_menu` VALUES ('1', '1005', '欢迎页', 'Index', 'welcome', '', 'fa fa-user', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('2', '1001', '栏目管理', 'Arctype', 'index', '|mt20|1', 'iconfont e-lanmuguanli', '1', '1', '100', '1', 'cn', '1668570337', '1650263716');
INSERT INTO `ey_admin_menu` VALUES ('3', '1002', '内容管理', 'Archives', 'index', '', 'iconfont e-neirongwendang', '1', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('4', '1004', '待审稿件', 'Archives', 'index_draft', '', 'iconfont e-tougao', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('5', '1003', '广告管理', 'AdPosition', 'index', '', 'iconfont e-guanggao', '1', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('6', '2001', '基本信息', 'System', 'web', '', 'iconfont e-shezhi', '1', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('7', '2002', '可视编辑', 'Uiset', 'ui_index', '', 'iconfont e-keshihuabianji', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('8', '2003', 'SEO模块', 'Seo', 'seo', '', 'iconfont e-seo', '1', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('9', '2004', '功能地图', 'Index', 'switch_map', '', 'iconfont e-caidangongneng', '1', '0', '10000', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('10', '2005', '插件应用', 'Weapp', 'index', '', 'iconfont e-chajian', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('11', '2006', '会员中心', 'Member', 'users_index', '', 'iconfont e-gerenzhongxin', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');
INSERT INTO `ey_admin_menu` VALUES ('12', '2008', '商城中心', 'Shop', 'home', '', 'iconfont e-shangcheng', '1', '1', '100', '1', 'cn', '1668570337', '1668570338');
INSERT INTO `ey_admin_menu` VALUES ('13', '2009', '可视化小程序', 'Diyminipro', 'page_edit', '', 'fa fa-code', '0', '1', '100', '1', 'cn', '1668570337', '1668570337');

-- -----------------------------
-- Table structure for `ey_admin_wxlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_wxlogin`;
CREATE TABLE `ey_admin_wxlogin` (
  `wx_id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=官方公众号，2=微信应用',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(50) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `unionid` varchar(200) NOT NULL DEFAULT '' COMMENT 'unionid',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wx_id`) USING BTREE,
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='后台微信登录记录表';


-- -----------------------------
-- Table structure for `ey_anli_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_anli_content`;
CREATE TABLE `ey_anli_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `xinghao` varchar(200) NOT NULL DEFAULT '' COMMENT '产品型号',
  `body` longtext COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_anli_content`
-- -----------------------------
INSERT INTO `ey_anli_content` VALUES ('1', '3', '1550193208', '1550193208', 'YS-BLM6256', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/713cd23751c0e7fe62bbf1e5191f2152.png&quot; title=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot; alt=&quot;713cd23751c0e7fe62bbf1e5191f2152.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('2', '4', '1550193197', '1550193197', 'YS-BLM5769', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/dee87fce7eb58059bed81a1f7cce81b0.png&quot; title=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot; alt=&quot;dee87fce7eb58059bed81a1f7cce81b0.png&quot;/&gt;&lt;/span&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;span style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('3', '5', '1550193179', '1550193179', 'YS-BLM5616', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/d345a633a2d6f69507e6881fdf20d568.png&quot; title=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot; alt=&quot;d345a633a2d6f69507e6881fdf20d568.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;/p&gt;');
INSERT INTO `ey_anli_content` VALUES ('4', '6', '1550193145', '1550193145', 'YS-BLM8649', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190215/18f42e633e075f417df9b68df41a072f.png&quot; title=&quot;18f42e633e075f417df9b68df41a072f.png&quot; alt=&quot;18f42e633e075f417df9b68df41a072f.png&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;这里是案例展示的内容。&lt;br/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_appletstyle_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_appletstyle_content`;
CREATE TABLE `ey_appletstyle_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `color` enum('red','blue','golden','black') DEFAULT 'red' COMMENT '背景色',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_appletstyle_content`
-- -----------------------------
INSERT INTO `ey_appletstyle_content` VALUES ('1', '110', '1666943946', '1666943946', 'black');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `stypeid` varchar(90) DEFAULT '' COMMENT '副栏目ID集合',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `subtitle` varchar(200) DEFAULT '' COMMENT '副标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '缩略图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `is_litpic` tinyint(1) DEFAULT '0' COMMENT '图片（0=否，1=是）',
  `is_roll` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '滚动（0=否，1=是）',
  `is_slide` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '幻灯（0=否，1=是）',
  `is_diyattr` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '自定义（0=否，1=是）',
  `origin` varchar(30) DEFAULT '' COMMENT '来源',
  `author` varchar(200) DEFAULT '' COMMENT '作者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(255) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `attrlist_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数列表ID',
  `users_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员价',
  `users_free` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否会员免费，默认0不免费，1为免费',
  `old_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品旧价',
  `sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `stock_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品库存量',
  `stock_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '商品库存在产品详情页是否显示，1为显示，0为不显示',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本)',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员ID',
  `arc_level_id` int(10) DEFAULT '0' COMMENT '文档会员权限ID',
  `restric_type` tinyint(1) DEFAULT '0' COMMENT '限制模式，0=免费，1=付费，2=会员专享，3=会员付费',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `joinaid` int(10) DEFAULT '0' COMMENT '关联文档ID',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `appraise` int(10) DEFAULT '0' COMMENT '评价数',
  `collection` int(10) DEFAULT '0' COMMENT '收藏数',
  `htmlfilename` varchar(250) DEFAULT '' COMMENT '自定义文件名',
  `province_id` int(10) DEFAULT '0' COMMENT '省份',
  `city_id` int(10) DEFAULT '0' COMMENT '所在城市',
  `area_id` int(10) DEFAULT '0' COMMENT '所在区域',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `no_vip_pay` tinyint(3) DEFAULT '0' COMMENT 'restric_type = 2 时,会员专享,非会员可付费使用,0-关闭,1-开启',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COMMENT='文档主表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '', '6', '0', '关于我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122497', '1599189692', '0');
INSERT INTO `ey_archives` VALUES ('2', '8', '', '6', '0', '公司简介', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122529', '1599189713', '0');
INSERT INTO `ey_archives` VALUES ('3', '9', '', '6', '0', '加入我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122529', '0', '0');
INSERT INTO `ey_archives` VALUES ('4', '10', '', '6', '0', '销售网络', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122529', '0', '0');
INSERT INTO `ey_archives` VALUES ('5', '7', '', '6', '0', '联系我们', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122671', '1599186365', '0');
INSERT INTO `ey_archives` VALUES ('6', '5', '', '6', '0', '服务流程', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599122676', '1599186335', '0');
INSERT INTO `ey_archives` VALUES ('7', '23', '', '6', '0', '网站导航', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599123232', '1599188646', '0');
INSERT INTO `ey_archives` VALUES ('8', '25', '', '6', '0', '适鱼性强、增产较佳', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599124470', '0', '0');
INSERT INTO `ey_archives` VALUES ('9', '26', '', '6', '0', '结构合理、规格齐全', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599124470', '0', '0');
INSERT INTO `ey_archives` VALUES ('10', '27', '', '6', '0', '网结紧固、尺寸准确', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599124470', '0', '0');
INSERT INTO `ey_archives` VALUES ('11', '28', '', '6', '0', '颜色鲜艳、使用寿命长', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599124470', '0', '0');
INSERT INTO `ey_archives` VALUES ('12', '24', '', '6', '0', '四大产品优势', '', '', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '', '0', '0', '', '0', '', '', '', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599124984', '1599188739', '0');
INSERT INTO `ey_archives` VALUES ('13', '11', '', '2', '0', '产品名称一', '', '/uploads/allimg/20200904/1-200Z4094JT05.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '264', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599184051', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('14', '17', '', '1', '0', '夜钓灯的选用和使用，这几个技巧不起眼，但是很实用', '', '/uploads/allimg/20200904/1-200Z4100U2532.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '127', '0', '', '0', '', '', '野外夜钓，首选组合夜钓灯加头灯，原因很简单，野外地势复杂，夜间视线不好，有夜钓灯照明，观漂、诱鱼两相宜；而辅助的头灯，则能方便我们上饵、起鱼，甚至观察钓位周边的环境，以免一不小心，滑落水中；头灯不值几个钱，也没什么可多讨论的，害怕电量储备不足，可以带', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185327', '1599185327', '0');
INSERT INTO `ey_archives` VALUES ('15', '17', '', '1', '0', '新竿到手先带个套？别着急，先了解防滑套的作用再说', '', '/uploads/allimg/20200904/1-200Z410094G60.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '220', '0', '', '0', '', '', '钓鱼人喜欢买鱼竿，还喜欢给鱼竿带个“套”，不管这竿廉价还是昂贵、不管长尺寸还是短尺寸，也不管用不用、几时用，反正套都是必须带的，有些钓友买来杆子甚至连杆稍绳都还没打结就先把套带上了。我说的套是指防滑套，是套或者缠在手把节处的，这个小物件的名字很多，防', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185361', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('16', '17', '', '1', '0', '失手绳真的该被钓鱼人唾弃吗？其实它是钓友的神器', '', '/uploads/allimg/20200904/1-200Z4101034P1.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '214', '0', '', '0', '', '', '说起钓鱼中的失手绳，可谓是故事良多呀！有的钓友觉得，不应该用失手绳，也有的钓友觉得，应该使用失手绳。那么，今天咱们就从不同的角度来分析，钓鱼中的失手绳在钓鱼中的作用和角色。失手绳的作用想要聊关于钓鱼中失手绳的话题，自然就离不开失手绳自身的作用。在平常', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185429', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('17', '17', '', '1', '0', '选鱼竿，后堵加不加配重，垂钓场合不同', '', '/uploads/allimg/20200904/1-200Z4101105447.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '242', '0', '', '0', '', '', '现在的鱼竿体系，尤其是手竿，基本上全是以台钓竿为主，尤其是碳布为主要材料之后，鱼竿的重量日趋轻量化，为了保证鱼竿竿身坚韧度、抛钓的顺畅性，尤为强调鱼竿竿身的平衡性；这个特性，在实战中意义非凡，在抛投钓组时，大把部分，也就是手持部分，一定重心要稳，越靠', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185454', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('18', '17', '', '1', '0', '浮漂用久了漂尾变暗怎么办？试试这样做，没准还有救', '', '/uploads/allimg/20200904/1-200Z410113cQ.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '216', '0', '', '0', '', '', '咱们日常作钓用的浮漂，大多数漂尾都比较细，而这种细漂尾不知道大家发现没有，用的时间稍微久一点颜色有可能会变暗、变淡甚至直接掉漆，如果你的眼神不是太好，用长点的竿子根本无法看清漂相。尤其是冬季，一方面我们会用长竿去钓一些比较小的鱼，第二方面鱼口又轻，这', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185485', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('19', '17', '', '1', '0', '鱼线品牌哪家强？别看广告看疗效，能锯塑料管未必能钓鱼', '', '/uploads/allimg/20200904/1-200Z4101214G8.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '119', '0', '', '0', '', '', '我朋友圈有很多卖渔具的，每天不管什么时间段，只要一打开就能看到各种各样的广告。我本身不讨厌卖产品、也不反感发广告，但有两种我是十分不爽的，一是疯狂刷屏，二是虚假广告。比如卖小药的说他的小药能一滴爆护、能“闭三边”，然后配个不知道何年何月拍的鱼获照片，', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185529', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('20', '17', '', '1', '0', '鲫鱼竿能钓鲤鱼吗，论鲫竿鲤竿综合竿的区别', '', '/uploads/allimg/20200904/1-200Z4101241938.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '263', '0', '', '0', '', '', '问：为什么鱼竿分鲫鱼竿、鲤鱼竿、综合竿？难道鲫鱼竿就钓不了鲤鱼吗？答：这还用说，商家想尽办法赚钓友的钱呗，以前咱用竹竿哪有那么多讲究，一只竿就能钓所有鱼。这是网上关于钓具常见的“问与答”，大家应该也有看到过，如果你没印象，我再举个类似的例子。问：饵料', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185556', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('21', '17', '', '1', '0', '钓黑坑鱼竿要选对，老钓手都这样挑选，又省钱又实用', '', '/uploads/allimg/20200904/1-200Z4101311Q0.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '274', '0', '', '0', '', '', '这又是一篇关于选竿的文章，其实此类文章比较难写，每个人的想法不一样，在选择时侧重点也就各不相同。但是，鱼竿又是钓友们关注度比较高的一件装备，尤其是新手，面对各种品牌、型号的鱼竿可能一下就蒙圈了，也不知道哪个更适合自己，此时如果有人给点建议会好很多。说', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185586', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('22', '17', '', '1', '0', '自己动手做钓具的快乐，自制竿架和饵料粉碎机出炉', '', '/uploads/allimg/20200904/1-200Z4101355337.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '250', '0', '', '0', '', '', '钓龄够长的那拨人基本都有diy钓鱼用品的经历，我就属于那拨人。回想起来，我做过的最多的当属竿架，虽然看起来土得掉渣，但我认为确实非常好用，它的最大优点是，无论刮多大的风，竿子架在上边都特别稳当。要是不够稳，就再压块儿石头。我做的竿架子通常可以同时架设', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185630', '1599185630', '0');
INSERT INTO `ey_archives` VALUES ('23', '17', '', '1', '0', '用过这些东西做钓具的人，说明你的年龄不小了', '', '/uploads/allimg/20200904/1-200Z4101530U2.jpg', '0', '0', '0', '1', '0', '1', '0', '0', '0', '', '小编', '233', '0', '', '0', '', '', '当下生活条件比较好了，能花钱买的东西，自己基本就不会去动手做了！在很多钓友眼中，自制的东西浪费时间，还不好用倒不如去买！当然怎么选择随钓友自己，本期我们不聊如何钓鱼！而是聊聊早期大家钓鱼使用过的一些东西，如果你之前用过，那么足以说明你的年龄不小了！因', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185716', '1599185799', '0');
INSERT INTO `ey_archives` VALUES ('24', '17', '', '1', '0', '这5种渔具买了就后悔，浪费钱用处不大', '', '/uploads/allimg/20200904/1-200Z4101559130.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '274', '0', '', '0', '', '', '钓鱼当中会用到很多的钓鱼用品，它们可以协助我们更好地去钓鱼。正是因为如此，很多钓友在购买的时候一点也不理智。看到这里大家会问，为何用不理智来形容呢？刚才你都说了，渔具是帮助大家多钓鱼，前后有点矛盾啊！钓友莫急，请听我慢慢说！如果渔具实用，而且是自己需', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599185755', '1599185755', '0');
INSERT INTO `ey_archives` VALUES ('25', '19', '', '1', '0', '案例展示一', '', '/uploads/allimg/20200904/1-200Z410301GA.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '146', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186603', '1599186603', '0');
INSERT INTO `ey_archives` VALUES ('26', '19', '', '1', '0', '案例展示二', '', '/uploads/allimg/20200904/1-200Z4103133492.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '155', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186684', '1599186713', '0');
INSERT INTO `ey_archives` VALUES ('27', '19', '', '1', '0', '案例展示三', '', '/uploads/allimg/20200904/1-200Z4103210316.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '275', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186715', '1599186715', '0');
INSERT INTO `ey_archives` VALUES ('28', '19', '', '1', '0', '案例展示四', '', '/uploads/allimg/20200904/1-200Z4103245U2.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '239', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186742', '1599186742', '0');
INSERT INTO `ey_archives` VALUES ('29', '19', '', '1', '0', '案例展示五', '', '/uploads/allimg/20200904/1-200Z410332IU.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '261', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186780', '1599186780', '0');
INSERT INTO `ey_archives` VALUES ('30', '19', '', '1', '0', '案例展示六', '', '/uploads/allimg/20200904/1-200Z41034023a.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '253', '0', '', '0', '', '', '一般可分为网渔具、钓渔具、其他渔具。按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。', '0', '0.00', '0', '0.00', '0', '0', '1', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599186822', '1599186822', '0');
INSERT INTO `ey_archives` VALUES ('31', '11', '', '2', '0', '产品名称二', '', '/uploads/allimg/20200904/1-200Z4111F4X4.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '286', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189404', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('32', '11', '', '2', '0', '产品名称三', '', '/uploads/allimg/20200904/1-200Z4111J5a4.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '196', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189457', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('33', '11', '', '2', '0', '产品名称', '', '/uploads/allimg/20200904/1-200Z4111PGJ.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '139', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189477', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('34', '11', '', '2', '0', '产品名称五', '', '/uploads/allimg/20200904/1-200Z4111RE05.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '115', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189499', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('35', '11', '', '2', '0', '产品名称六', '', '/uploads/allimg/20200904/1-200Z4111T2103.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '276', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189516', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('36', '11', '', '2', '0', '产品名称七', '', '/uploads/allimg/20200904/1-200Z41119335K.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '196', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189556', '1599189618', '0');
INSERT INTO `ey_archives` VALUES ('37', '11', '', '2', '0', '产品名称八', '', '/uploads/allimg/20200904/1-200Z4111951Y6.jpg', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '小编', '297', '0', '', '0', '', '', '钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。', '0', '0.00', '0', '0.00', '0', '0', '0', '0', '', '1', '100', 'cn', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0', '1599189583', '1599189618', '0');

-- -----------------------------
-- Table structure for `ey_archives_flag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives_flag`;
CREATE TABLE `ey_archives_flag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `flag_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文档属性名称',
  `flag_attr` varchar(10) NOT NULL DEFAULT '' COMMENT '属性值',
  `flag_fieldname` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态， 1---显示， 0---隐藏',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flag_attr` (`flag_attr`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='文档属性配置表';

-- -----------------------------
-- Records of `ey_archives_flag`
-- -----------------------------
INSERT INTO `ey_archives_flag` VALUES ('1', '头条', 'h', 'is_head', '1', '1', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('2', '推荐', 'c', 'is_recom', '1', '2', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('3', '加推', 'a', 'is_special', '1', '3', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('4', '标粗', 'b', 'is_b', '1', '4', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('5', '有图', 'p', 'is_litpic', '1', '5', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('6', '外链', 'j', 'is_jump', '1', '6', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('7', '轮播', 's', 'is_slide', '0', '7', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('8', '滚动', 'r', 'is_roll', '0', '8', 'cn', '1606272350', '1606272350');
INSERT INTO `ey_archives_flag` VALUES ('9', '热文', 'd', 'is_diyattr', '0', '9', 'cn', '1606272350', '1606272350');

-- -----------------------------
-- Table structure for `ey_arcmulti`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcmulti`;
CREATE TABLE `ey_arcmulti` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tagid` varchar(60) NOT NULL DEFAULT '' COMMENT '标签ID',
  `tagname` varchar(60) NOT NULL DEFAULT '' COMMENT '标签名',
  `innertext` text NOT NULL COMMENT '标签模板代码',
  `pagesize` int(10) NOT NULL DEFAULT '0' COMMENT '分页列表',
  `querysql` text NOT NULL COMMENT '完整SQL',
  `ordersql` varchar(200) DEFAULT '' COMMENT '排序SQL',
  `addfieldsSql` varchar(255) DEFAULT '' COMMENT '附加字段SQL',
  `addtableName` varchar(50) DEFAULT '' COMMENT '附加字段的数据表，不包含表前缀',
  `attstr` text COMMENT '属性字符串',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多页标记存储数据表';


-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '1552376880');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '1552376880');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `topid` int(10) DEFAULT '0' COMMENT '顶级栏目ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `diy_dirpath` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `rulelist` varchar(200) DEFAULT '' COMMENT '列表静态文件存放规则',
  `ruleview` varchar(200) DEFAULT '' COMMENT '文档静态文件存放规则',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `del_method` tinyint(1) DEFAULT '0' COMMENT '伪删除状态，1为主动删除，2为跟随上级栏目被动删除',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '栏目是否应用于会员投稿发布，1是，0否',
  `weapp_code` varchar(50) DEFAULT '' COMMENT '插件栏目唯一标识',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `target` tinyint(1) DEFAULT '0' COMMENT '新窗口打开',
  `nofollow` tinyint(1) DEFAULT '0' COMMENT '防抓取',
  `typearcrank` int(10) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='文档栏目表';

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '1', '6', '0', '0', '关于我们', 'guanyuwomen', '/guanyuwomen', '/guanyuwomen', '', '', 'About Us', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('2', '1', '2', '0', '0', '产品中心', 'chanpinzhongxin', '/chanpinzhongxin', '/chanpinzhongxin', '', '', 'PRODUCT', '0', '', '/uploads/allimg/20200904/1-200Z409411TS.jpg', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('3', '1', '1', '0', '0', '新闻动态', 'xinwendongtai', '/xinwendongtai', '/xinwendongtai', '', '', 'News', '0', '', '/uploads/allimg/20200904/1-200Z4095Ab38.jpg', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('4', '1', '1', '0', '0', '工程案例', 'gongchenganli', '/gongchenganli', '/gongchenganli', '', '', 'COOPERATION CASE', '0', '', '/uploads/allimg/20200904/1-200Z4102519454.jpg', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('5', '1', '6', '0', '0', '服务流程', 'fuwuliucheng', '/fuwuliucheng', '/fuwuliucheng', '', '', '', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('6', '1', '8', '0', '0', '在线留言', 'zaixianliuyan', '/zaixianliuyan', '/zaixianliuyan', '', '', '', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_guestbook.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('7', '1', '6', '0', '0', '联系我们', 'lianxiwomen', '/lianxiwomen', '/lianxiwomen', '', '', '', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122491', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('8', '1', '6', '1', '1', '公司简介', 'gongsijianjie', '/guanyuwomen/gongsijianjie', '/guanyuwomen/gongsijianjie', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122529', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('9', '1', '6', '1', '1', '加入我们', 'jiaruwomen', '/guanyuwomen/jiaruwomen', '/guanyuwomen/jiaruwomen', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122529', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('10', '1', '6', '1', '1', '销售网络', 'xiaoshouwangluo', '/guanyuwomen/xiaoshouwangluo', '/guanyuwomen/xiaoshouwangluo', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122529', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('11', '1', '2', '2', '2', '玻璃钢船', 'boligangchuan', '/chanpinzhongxin/boligangchuan', '/chanpinzhongxin/boligangchuan', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('12', '1', '2', '2', '2', '拦网', 'lanwang', '/chanpinzhongxin/lanwang', '/chanpinzhongxin/lanwang', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('13', '1', '2', '2', '2', '无结网', 'wujiewang', '/chanpinzhongxin/wujiewang', '/chanpinzhongxin/wujiewang', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('14', '1', '2', '2', '2', '地笼王', 'dilongwang', '/chanpinzhongxin/dilongwang', '/chanpinzhongxin/dilongwang', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('15', '1', '2', '2', '2', '泡沫浮桶', 'paomofutong', '/chanpinzhongxin/paomofutong', '/chanpinzhongxin/paomofutong', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('16', '1', '2', '2', '2', '网箱', 'wangxiang', '/chanpinzhongxin/wangxiang', '/chanpinzhongxin/wangxiang', '', '', '', '1', '', '', 'lists_product.htm', 'view_product.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122567', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('17', '1', '1', '3', '3', '行业新闻', 'xingyexinwen', '/xinwendongtai/xingyexinwen', '/xinwendongtai/xingyexinwen', '', '', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122596', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('18', '1', '1', '3', '3', '企业新闻', 'qiyexinwen', '/xinwendongtai/qiyexinwen', '/xinwendongtai/qiyexinwen', '', '', '', '1', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122596', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('19', '1', '1', '4', '4', '案例展示一', 'anlizhanshiyi', '/gongchenganli/anlizhanshiyi', '/gongchenganli/anlizhanshiyi', '', '', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122646', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('20', '1', '1', '4', '4', '案例展示二', 'anlizhanshier', '/gongchenganli/anlizhanshier', '/gongchenganli/anlizhanshier', '', '', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122646', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('21', '1', '1', '4', '4', '案例展示三', 'anlizhanshisan', '/gongchenganli/anlizhanshisan', '/gongchenganli/anlizhanshisan', '', '', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122646', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('22', '1', '1', '4', '4', '案例展示四', 'anlizhanshisi', '/gongchenganli/anlizhanshisi', '/gongchenganli/anlizhanshisi', '', '', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599122646', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('23', '6', '6', '0', '0', '网站导航', 'wangzhandaohang', '/wangzhandaohang', '/wangzhandaohang', '', '', '', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_single_daohang.htm', '', '', '', '', '100', '1', '0', '1', '0', '0', '1', '0', '', 'cn', '1599123232', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('24', '1', '6', '0', '0', '四大产品优势', 'sidachanpinyoushi', '/sidachanpinyoushi', '/sidachanpinyoushi', '', '', '', '0', '', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'lists_single.htm', '', '', '', '选择某某渔网，您的品质之选！', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599124406', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('25', '1', '6', '24', '24', '适鱼性强、增产较佳', 'shiyuxingqiang_zengchanjiaojia', '/sidachanpinyoushi/shiyuxingqiang_zengchanjiaojia', '/sidachanpinyoushi/shiyuxingqiang_zengchanjiaojia', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599124470', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('26', '1', '6', '24', '24', '结构合理、规格齐全', 'jiegouheli_guigeqiquan', '/sidachanpinyoushi/jiegouheli_guigeqiquan', '/sidachanpinyoushi/jiegouheli_guigeqiquan', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599124470', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('27', '1', '6', '24', '24', '网结紧固、尺寸准确', 'wangjiejingu_chicunzhunque', '/sidachanpinyoushi/wangjiejingu_chicunzhunque', '/sidachanpinyoushi/wangjiejingu_chicunzhunque', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599124470', '1638408564', '0', '0', '0');
INSERT INTO `ey_arctype` VALUES ('28', '1', '6', '24', '24', '颜色鲜艳、使用寿命长', 'yansexianyan_shiyongshoumingchang', '/sidachanpinyoushi/yansexianyan_shiyongshoumingchang', '/sidachanpinyoushi/yansexianyan_shiyongshoumingchang', '', '', '', '1', '', '', 'lists_single.htm', '', '', '', '', '100', '0', '0', '1', '0', '0', '1', '0', '', 'cn', '1599124470', '1638408564', '0', '0', '0');

-- -----------------------------
-- Table structure for `ey_article17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article17_content`;
CREATE TABLE `ey_article17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '文章内容',
  `vrdz` varchar(251) NOT NULL DEFAULT '' COMMENT '全景地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_article17_content`
-- -----------------------------
INSERT INTO `ey_article17_content` VALUES ('1', '34', '1649299290', '1649299290', '富力湾海南富力湾与夏威夷、加勒比海、巴厘岛这些世界著名的旅游胜地同在一条黄金北纬18&amp;deg;上，是富力集团在海南布局的唯一一个高端热带滨海休闲度假社区，且紧邻亚洲大型海洋主题公园-富力湾海洋欢乐世界，轻松享有休闲惬意的度假生活。', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('2', '35', '1649299290', '1649299290', '合景汀澜海岸凝萃合景泰富17年国际豪宅开发经验而倾力打造的旅游地产新作，抢占国际旅游岛未来高端的珍珠海岸核心区位，荟萃众多奢侈度假配套。更携手大师团队定制一线海幕豪宅，在这里找到如塞舌尔般的私密海岸天堂。', 'https://720yun.com/t/80vkc72wdpe?scene_id=64311939');
INSERT INTO `ey_article17_content` VALUES ('3', '36', '1649299290', '1649299290', '&amp;ldquo;海棠华着&amp;rdquo;位于中国三亚海棠湾-中国国家海岸，三亚海棠湾海棠北路18号（凯宾斯基酒店旁），项目占地面积为29.3万平米，容积率0.4，绿化率62.2%，地上建筑面积约12万平米，一共分为三期开发，一期为174套别墅产品，主力户型为约300-400平米（使用面积）的院落别墅户型，是三亚一线临海别墅群，配建拥有百年历史的华尔道夫酒店，该酒店素有&amp;ldquo;总统行宫&amp;rdquo;的称号。', 'https://720yun.com/t/58vkc72l5iq?scene_id=64260374');
INSERT INTO `ey_article17_content` VALUES ('4', '37', '1649299290', '1649299290', '融创日月湾，拥有目前海南的北纬 18&amp;deg;绝品度假双岛。日月湾旅游度假区总规划面积约3.45万亩，，日月岛合计约 1492 亩，其中日岛约 840亩，总建筑面积约 76 万㎡，建筑密度 16.5%，绿化率高达 52%。从日月湾高速出口至项目1500米路程，途经滨海大道，可以一览日月湾迷人的滨海风光。经过与陆地连接的日岛跨海大桥，可以领略别样的海岛风情。&amp;nbsp;', 'https://720yun.com/t/83vkuwrw01w?scene_id=40544503');
INSERT INTO `ey_article17_content` VALUES ('5', '38', '1649299290', '1649299290', '臻园一期&amp;bull;洋房概况：前期共推出108套洋房，总高6层，一梯两户，建筑面积75平，2房2厅一厨一卫两阳台，得房率高，性价比高。板楼设计，通透户型，双阳台设计，带品质精装，满足你的度假、投资的双重需求。海南第一个温泉度假区，东南亚异域风情小镇，侨乡之城，享受成熟的商业配套和淳朴的小镇风情。', 'https://720yun.com/t/3fvkumqh5ib?scene_id=42183767');
INSERT INTO `ey_article17_content` VALUES ('6', '39', '1649299290', '1649299290', '万科海上大都会左岸项目位于三亚市城央湾区三亚湾，南临20公里椰梦长廊，步行200米即可畅享沙滩大海。三亚湾路和新城路围绕在项目南北两侧，与三亚市核心干道凤凰路、规划核心干道三横路毗邻。导航距离凤凰机场约6公里，导航距离三亚动车站约8公里。周边有多条公交及旅游线路，直达海棠湾免税城，亚龙湾，大小洞天，城市乐园等，交通四通八达，非常便利。', 'https://720yun.com/t/2fvkc7phzr9?scene_id=64241384');
INSERT INTO `ey_article17_content` VALUES ('7', '40', '1649299290', '1649299290', '梦幻不夜城，蜈支洲岛，南田温泉，水稻国家公园，海中海高尔夫，亚特兰蒂斯水上乐园等。', 'https://720yun.com/t/05vku72b7ql?scene_id=40965268');
INSERT INTO `ey_article17_content` VALUES ('8', '41', '1649299290', '1649299290', '龙栖海岸位于海南&amp;middot;大三亚&amp;middot;龙栖湾，龙栖湾滨海旅游度假区，由海南中城投开发建设。北纬18&amp;deg;以南，307亩观海大城，南北通透两梯两户。56㎡海豚大阳台，拥16公里龙栖湾首栖霞海岸，观海阅山，不负盛景。邻南中国海上文旅基地、南繁基地、万豪酒店。项目釆用两梯两户纯板式洋房设计，户型设计合理，全明格局，公摊少、采光足、南北通透，电梯入户。', 'https://720yun.com/t/5bvkcy1ygdl?scene_id=62651738');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('1', '14', '&lt;p&gt;野外夜钓，首选组合夜钓灯加头灯，原因很简单，野外地势复杂，夜间视线不好，有夜钓灯照明，观漂、诱鱼两相宜；而辅助的头灯，则能方便我们上饵、起鱼，甚至观察钓位周边的环境，以免一不小心，滑落水中；&lt;/p&gt;&lt;p&gt;头灯不值几个钱，也没什么可多讨论的，害怕电量储备不足，可以带2~3个头灯，辅以充电宝，别说一夜，两三晚使用也足够了，但是夜钓灯的选用，就很值得说道了；便宜点的，几十元一个，贵一点的，上千也不稀罕，但是夜钓灯这个玩意，不是说越贵越好，可是如何挑选合用的，其实倒也不难；&lt;/p&gt;&lt;p&gt;关于夜钓灯的选用，很多大师或者大咖，往往会从灯源数量、穿透力等角度去介绍，但罕见从实用的选、用两个角度来介绍，所以很多新人，甚至不少老鸟，在选择夜钓灯的时候，也是一脸懵逼，只好秉着一分价钱一分货，尽量买贵的，在选用夜钓灯上，其实我们要从实用角度，即实战、使用两个层面去选择，其实并不难挑：&lt;/p&gt;&lt;p&gt;夜钓灯，其实说白了和手电筒的原理也没什么区别，无非是灯的电池的电量储备、光源的数量、灯光的亮度，这三个参数值不同，电量储备越大，光源数量越多，灯光的亮度越强，夜钓灯的价格越贵；但是，在实战的时候，我们并不需要光源数量多、亮度高；那么，我们应遵循什么样的标准来选用呢？&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915a0.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;一、根据垂钓的水域情况，选择夜钓灯光源、容量&lt;/h2&gt;&lt;p&gt;所谓垂钓水域情况，其实钓点的深浅、以及水面的大小，如果水面大，水比较浅，我们并不需要灯源亮度太高的夜钓灯，亮度太高也是浪费；如果水面大，钓点水位比较深，就需要光源的强度比较大，一方面，照射到浮漂的时候比较清晰，另一方面，灯光射到水底，也有比较好的诱聚效果；&lt;/p&gt;&lt;p&gt;其次就是灯源的数量，常见夜钓灯都是双光源，也就是提供两种色谱照明源，如白黄光源，白蓝光源，以此引申，有三光源、四光源不同种类，我们在实战的时候，其实很难用到四个光源都用，更多的时候，都是黄黄光诱聚、蓝光照漂；&lt;/p&gt;&lt;p&gt;小结：如果我们野外夜钓的次数不多，选购双光源的夜钓灯就足够了，着重注意的，就是夜钓灯的电池容量，是否达标、是否虚标，只要不虚标的夜钓灯，其实使用效果都还算不差，但是就实战情况而言，还可以通过一个小技巧来判断夜钓灯的质量如何；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915136.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;二、通过使用夜钓灯，来判断夜钓灯的质量好坏&lt;/h2&gt;&lt;p&gt;夜钓灯的质量好坏，电池是否耐久，其实只是其中一个参照，除此之外，还有一个使用细节，其实比电池容量是否虚标、是否耐久更重要；&lt;/p&gt;&lt;p&gt;做起来很简单，我们不限场合，将夜钓灯直接固定，对准某一个照明区域，连续照明4个小时以后，观察一下照射区域，光源是否稳定，区域是否变化，灯光不能飘忽、不能抖动；&lt;/p&gt;&lt;p&gt;很多劣质夜钓灯，照射时长超过4个小时，灯珠就烧掉了，亦或者超过4小时以上的照明，电池电量严重不足，灯光开始变弱，而灯源更会发生飘忽、照明区域缩小、亮度变弱，这些都属于硬性质量问题；&lt;/p&gt;&lt;p&gt;通过以上两个技巧，我们可以选购出物美价廉的夜钓灯，那么在使用的时候，就一定能有好效果么？当然不是，夜钓灯的使用，并不是灯源照射到浮漂、照射到钓点就可以了，还是需要使用技巧的；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915F2.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;技巧一、蓝光照射为主，亮度越弱越好&lt;/h2&gt;&lt;p&gt;鱼是趋光动物，但是鱼的视力很糟糕，明流太高，也就是亮度太强，反而会惊吓受灯光吸引的鱼群，所以我们不管是黄白光诱鱼，还是蓝光照射钓点观漂，都不建议用太强的亮度；&lt;/p&gt;&lt;p&gt;如果是诱鱼为主，我们能看清光线照射水面以下即可，不需要光线照射到水底，那样光照强度就太大了；如果是观漂，那么我们能看到浮漂就可以，不需要亮度调整的太高；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915217.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;技巧二、钓远光圈调小，钓近光圈调大&lt;/h2&gt;&lt;p&gt;大多数夜钓可通过调焦来改变照射区域大小，如果钓距比较远，我们可以将光圈调的小一些，这样光线相对集中，就算视距远，也能看的比较清楚；&lt;/p&gt;&lt;p&gt;如果用的是短竿，因为钓距比较近，就算是折射率比较差的蓝光、紫光，如果照射光圈太小，光源太集中，亮度也很强，反而容易惊吓进窝鱼；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915633.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;技巧三、能平射尽量不要直射，光源要照射在窝点前方&lt;/h2&gt;&lt;p&gt;光是直线传播的，但是空气和水的密度不同，光线在进入水中后有折射，简单点说，如果我们照射窝点，除非是垂直照射窝点，负责光源必然会落到窝点后方一些的距离；&lt;/p&gt;&lt;p&gt;这也是很多钓友觉得夜钓灯照射窝子聚鱼，效果并不理想的原因，所以我们在夜钓灯照射窝点的时候，进行小角度平射，光源照射在窝点前方，这样既能看清浮漂，光线折射到水底之后，刚好照到窝点；&lt;/p&gt;&lt;p&gt;如果三脚架放的太高，很容易折射角度太远，这样光线倒是折射到窝点了，因为没有照射到钓点，也看不到浮漂在哪里，这就失去夜钓灯的意义了；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100915b8.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;总结&lt;/h2&gt;&lt;p&gt;以上就是夜钓灯的选用和使用技巧，虽然都不起眼，但是还算实用，至少对新手来说，不会走太多的弯路，也不会浪费，免得被商家收智商税；&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185360', '1599185360');
INSERT INTO `ey_article_content` VALUES ('2', '15', '&lt;p&gt;钓鱼人喜欢买鱼竿，还喜欢给鱼竿带个“套”，不管这竿廉价还是昂贵、不管长尺寸还是短尺寸，也不管用不用、几时用，反正套都是必须带的，有些钓友买来杆子甚至连杆稍绳都还没打结就先把套带上了。&lt;/p&gt;&lt;p&gt;我说的套是指防滑套，是套或者缠在手把节处的，这个小物件的名字很多，防滑套只是其中一个，还有叫吸汗带、缠把带等等的，反正大家知道意思就行。&lt;/p&gt;&lt;p&gt;防滑套的作用一部分其实已经体现在它的名字上了，比如防滑、比如吸汗，还有是增加舒适度、美观度以及防电（防电我觉得是扯淡）。&lt;/p&gt;&lt;p&gt;别看这个物件小、价格也不高，但用的人却非常多，那咱们今天就来聊聊鱼竿是否有必要装这个套子，如果要装那又该如何去挑选，毕竟在市面上这类防滑套种类太多了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100942418.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;要不要给心爱的鱼竿带个套？首先你需要了解防滑套的作用，然后再问自己需不需要&lt;/h2&gt;&lt;p&gt;有些商家在打广告的时候会说防滑套防滑又防电，但这个防电我个人觉得是扯淡，防什么电呢？静电倒差不多，要说防雷电、防高压电，那纯粹胡扯，在绝对实力面前，这些东西都只是摆设而已，所以莫轻信。&lt;/p&gt;&lt;p&gt;防滑：&lt;/p&gt;&lt;p&gt;这个作用是有的，但得看情况，因为有的时候我们根本不需要防滑。比如说短杆，一般指3.9及3.9以下的杆子，这类竿由于尺寸短、不会很重，所以我们在抛竿、起杆时手都是握在竿子尾部的，杆堵顶着手心、五指包裹在竿柄四周，这样是不会打滑的。&lt;/p&gt;&lt;p&gt;4.5米的杆子比较尴尬，如果是鲫鱼竿、或者是高碳材质的，那么也不会重，你仍然可以用握短杆的那种方式去握，一样不会打滑。&lt;/p&gt;&lt;p&gt;而且市面上很多杆子现在本身就有防滑处理，有些是磨砂处理，有些则是凹凸不平的花纹。大家可以看下图，这是我一根3.6的杆子，整个手把都是凹凸不平的花纹，一点都不会打滑。&lt;/p&gt;&lt;p&gt;4.5米以上的杆子，主要是因为比较重，我们起杆刺鱼要把竿柄顶在小臂上才行，这样的话如果杆把很光滑或者有汗水，有可能就会打滑，才需要装防滑套。&lt;/p&gt;&lt;p&gt;如果鱼竿特别长或者特别重，重到你顶着小臂都难刺鱼，那防滑套又失去了意义，比如钓黑坑青鱼、鲟鱼的那种巨物竿，咱们起杆都得是双手，这样有没有防滑套我感觉没大差别。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100942Z0.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;美观度：&lt;/p&gt;&lt;p&gt;现在的防滑套有各种颜色、各种花纹，有些看上去是挺不错的，钓友们认为装一个会让鱼竿更漂亮。这倒是个仁者见仁的问题，我不作太多评价，但就我的感受来说，看到有些人缠防滑套不仅不好看，反倒给鱼竿减分，比如说颜色不搭，明明鱼竿是个红色的，他偏缠个绿色的套子。&lt;/p&gt;&lt;p&gt;防滑套有两种，一种是直接套上去的，另一种是缠绕式的，套上去的还好，但缠绕式的如果你缠的不好，就会很丑，甚至手握上去都不舒服。&lt;/p&gt;&lt;p&gt;另外再补充一点：有些鱼竿是防竹设计，杆子的颜色如枯竹一般，看上去十分漂亮、就像真的竹子，这种我个人认为也不适合缠防滑套，感觉不搭，破坏了鱼竿本身的美。美观度问题就不多说了，反正自己喜欢就好。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41009424F.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;防滑套并不是百利而无一害，有的时候装了反而会损伤鱼竿&lt;/h2&gt;&lt;p&gt;很多人并不注意这个问题，他就觉得鱼竿装个套子有很多作用，就算这些作用我一个都用不到，但装了反正也没坏处。&lt;/p&gt;&lt;p&gt;我告诉你还真的有坏处，比如说有些钓友鱼竿多，每个杆子都装一个套子的话成本就很高，因此他可能就会买一些廉价的产品。&lt;/p&gt;&lt;p&gt;而这些廉价的产品，不透气、不防滑不说，还会掉色，平常你感觉不出来，哪天下雨了，把鱼竿淋湿了，我想很少有人会那么细心，把防滑套去吹干或者等天晴了拿出来晒一晒吧。如果你不做这些处理，时间长了防滑套就会掉色、发霉、甚至烂出来，然后竿体就被弄花了，洗都洗不掉。&lt;/p&gt;&lt;p&gt;下图这根杆子就是最好的证明，我一直给它缠着防滑套，然后也一直丢在房间没用，有一天我突然想用了，拿出来一看外面的套子已经发霉，拿掉以后就发现杆身上特别脏，吸了几遍都洗不掉。大家可以把图片放大，看一下手把位置，应该能看见。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100942959.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;不止是廉价的防滑套会掉色，贵的也一样（硅胶的不会），下面这根鱼竿是钓鱼王的魁拔战，尺寸是3.9米，花了我八百块。&lt;/p&gt;&lt;p&gt;这个杆子手把节本身就有防滑处理，摸上去手感也不错就像橡胶一样有些弹性，加上尺寸短、不重头，所以理论上不需要再带防滑套。但我偏要作，硬是装了一个，而且还不便宜，花了我25块大洋。&lt;/p&gt;&lt;p&gt;结果和上面那只竿是一样的甚至更惨，主要是每次被雨淋湿我也不处理，时间久了就发霉。我看防滑套发霉了太难看，就想拿掉的，结果一拆才发现，鱼竿手柄上的皮都烂了，真是得不偿失。（下面这个杆子就是）&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41009423H.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;防滑套有很多，我们应该如何选择&lt;/h2&gt;&lt;p&gt;短杆、比较轻的竿、本身就有防滑设计的竿，这类不需要装防滑套，那对于需要装的，或者你一定想装的，我们在选择上也是有注意的地方。&lt;/p&gt;&lt;p&gt;首先防滑套有很多种类，一种是热塑管，套上去以后用吹风机吹、火烤或者拿热水一浇它就会收缩成型。一种是硅胶套，它也是套在杆子上，只不过和前者不一样的地方在于，这种防滑套内部有根塑料条，只要将防滑套套入鱼竿后把管内的塑料条拉出即可。&lt;/p&gt;&lt;p&gt;还有一种是“缠绕式”的，即一圈一圈缠绕在鱼竿上，安装稍微麻烦点，但这种最常见、用的人也最多，以pu材质为主。&lt;/p&gt;&lt;p&gt;以上三种理论上是第二种硅胶材质的最好，安装方便、而且也不用担心褪色发霉，但我不喜欢，因为我觉得它太丑了。我喜欢用第三种缠绕式的，在缠绕式中又喜欢有龙骨设计的，这种握上去比较有感觉，舒适度更好。&lt;/p&gt;&lt;p&gt;在具体的选择上，如果你要求比较高，注重舒适度、美观度，那么尽量买好一点，价格在15~30之间的，推荐龙骨缠把；如果要求没那没高，三五块的当然也能用，只是摸上去的感觉、防滑透气方面肯定没贵的那种好。&lt;/p&gt;&lt;p&gt;注意，不管是贵的还是便宜的，如果你在使用中把它弄湿了，还是尽量风干比较好，鱼竿长时间不用可以把防滑套取下来，防止发霉腐烂。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100943958.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;防滑套的长度及用法&lt;/h2&gt;&lt;p&gt;这个主要是根据鱼竿长度和粗度来选择，像鲫鱼竿比较细，有些是葫芦把，那防滑套买最短的那种即可。综合竿、鲤竿，手把是渐细的那种，防滑套可以买1.5米，如果杆把较细，或者鱼竿是短尺寸、不重，那1.1米也够了。大物杆，手把节很粗，可以买1.8米、2米的防滑套。&lt;/p&gt;&lt;p&gt;安装方法这块，我觉得大家最好是找视频看，一是比较直观、二是看着做也方便。&lt;/p&gt;&lt;p&gt;关于缠绕式的防滑套，我提个小建议，大家可以坐在地上或床上，然后把杆子倒过来，手拿着杆把，另一端则别让它悬空，一定要接触地面这样缠起来才方便（记住装上前堵）。&lt;/p&gt;&lt;p&gt;在绕的时候，有龙骨的那种比较方便，每一圈贴着龙骨缠绕即可，一只手转动杆子，另一只手缠绕，务必缠紧，缠完后用赠送的防水胶带固定，如果你觉得不平整或者固定不牢，自己买卷防水黑胶带再缠个几圈。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4100943629.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;写在最后&lt;/h2&gt;&lt;p&gt;不要觉得鱼竿必须装防滑套，一定先要了解这个套子的作用，然后再看自己到底需不需要这些作用。装了套子以后如果天天用倒也不必太讲究，但要是鱼竿太多，每只竿的出场率不是那么高，那就要小心了，隔段时间去看一下，看到套子发霉要及时取下来。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185389', '1599185389');
INSERT INTO `ey_article_content` VALUES ('3', '16', '&lt;p&gt;说起钓鱼中的失手绳，可谓是故事良多呀！有的钓友觉得，不应该用失手绳，也有的钓友觉得，应该使用失手绳。那么，今天咱们就从不同的角度来分析，钓鱼中的失手绳在钓鱼中的作用和角色。&lt;/p&gt;&lt;h2&gt;失手绳的作用&lt;/h2&gt;&lt;p&gt;想要聊关于钓鱼中失手绳的话题，自然就离不开失手绳自身的作用。在平常的垂钓当中，钓鱼人自然少不了各种各样的活动，比如说吃饭和上厕所。如果这时浮漂出现信号，鱼拖动鱼竿后没有失手绳的牵连，钓竿就很容易被拖入水中。并且，近些因为下水捞竿而亡命的钓鱼人也不在少数！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101051939.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;失手绳的另外一个作用，在钓中大鱼时，考虑到钓竿和钓线的拉力，不足以抵抗鱼的拉力时，就可以通过放失手绳的方式，来化解鱼的冲击，从而更容易的钓获大鱼。&lt;/p&gt;&lt;h2&gt;失手绳的影响&lt;/h2&gt;&lt;p&gt;说起失手绳来，就会有钓鱼人觉得，使用失手绳去钓大鱼，那完全是为了鱼，而不是因为体验垂钓乐趣才去的，所以就很少会用失手绳。&lt;/p&gt;&lt;p&gt;但也有的钓友说，使用失手绳一方面是为了钓获更大的鱼，一方面是为了保护自己的钓具财产。因为自己的钓竿被大鱼拉断后，不会有人负责买单。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101051359.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;对失手绳的理智看待&lt;/h2&gt;&lt;p&gt;其实，我个人觉得失手绳和钓线，浮漂，钓箱是一样的，同样都属于钓具类的产品，目的是为了完成钓鱼人的目的。大可不必将这么一根小小的绳子，上升到价值观这样的高度，只要完成了自己的垂钓目的，无论是用多长的失手绳，那都是可以的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185452', '1599185452');
INSERT INTO `ey_article_content` VALUES ('4', '17', '&lt;p&gt;现在的鱼竿体系，尤其是手竿，基本上全是以台钓竿为主，尤其是碳布为主要材料之后，鱼竿的重量日趋轻量化，为了保证鱼竿竿身坚韧度、抛钓的顺畅性，尤为强调鱼竿竿身的平衡性；&lt;/p&gt;&lt;p&gt;这个特性，在实战中意义非凡，在抛投钓组时，大把部分，也就是手持部分，一定重心要稳，越靠近竿稍部分，越轻，这样就能有效利用杠杆原理，将钓组甩的精准、到位；&lt;/p&gt;&lt;p&gt;如果大把部分的重心靠前，钓组抛出去飘忽不定，很难做到精准抛投，如果竿身长一些，抓不稳都有可能，所以，现在的碳素手竿，非常强调竿身平衡，以及竿身的重心稳定；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101119512.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;但是，并不是所有的鱼竿，在设计的时候，都会从结构力学的角度来设计整体平衡性，后堵的配重，就应运而生，简单的说，就是在制作后堵时，通过增加重量，从而让大把重心后移，依次达到竿身平衡的作用；&lt;/p&gt;&lt;p&gt;咋一看，这种设计算是个神来之笔，竿身也稳定了，重心也靠后了，在抛投钓组的时候，也能提升钓组稳定性，无非就是厚度增加了些许重量，但是，在实战中，这是有隐忧的；&lt;/p&gt;&lt;p&gt;如果是休闲野钓，因为水域面积大，水域内鱼的密度稀疏，就算坐上一天，累计提竿的频次也没有多少，所以，休闲野钓时，这种厚度加配重的竿子，影响其实并不算大；&lt;/p&gt;&lt;p&gt;但是，如果是黑坑、竞技钓的时候，因为起竿、扬竿的频率非常高，这个时候，增加的配重越多，对大臂的影响就越明显，而现在的鱼竿参数，大多只报裸重、素材重，也就是鱼竿的竿壁净重，对厚度增重，基本上是不提供数据的；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41011191V.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;这样我们在选鱼竿的时候，往往就会忽略这个细节，事实上，大多数一线品牌鱼竿，因为在设计鱼竿时，会特地将竿身的平衡、重心、稳定，按一体化的思路来设计，也就是说，主要是通过大把的重量和长度，以及各个竿节的长度、重量，来均衡竿身；&lt;/p&gt;&lt;p&gt;因为在设计的时候，大把、竿身、竿稍的各节重量非常科学，竿稍不点头，稳定性又好，就算频繁抛、投、起，都不会影响大臂、小臂、手腕发力；&lt;/p&gt;&lt;p&gt;当关于这一点，黑坑、竞技钓选手，也称之为持握感，也就是持握竿稍的舒适度，这种持握感舒适度越强的鱼竿，对手腕、小臂的消耗越小，但是，之所以这种说法没有流传，也是有客观原因的；&lt;/p&gt;&lt;p&gt;原因倒也不复杂，就是每个钓手，因为体能、身高等诸多自身条件不同，如身高1.7米的钓友，和身高1.8米的钓友，体重120斤的钓友，和体重150斤的钓友，手持同一根鱼竿，持竿舒适度，是有明显不同的；&lt;/p&gt;&lt;p&gt;在野钓时，这种因素的影响，近乎于无，尤其使用的鱼竿越长，这种影响就越低，毕竟也没什么人会用长竿打频率，但是，如果在使用短竿，或者黑坑、野钓打频率时，这个影响，一下就出来了；&lt;/p&gt;&lt;p&gt;那么，我们在选竿的时候，怎么挑选持握舒适度较高的鱼竿呢？倒是也有技巧的，具体做法如下：&lt;/p&gt;&lt;p&gt;1、将竿身顺次抽开；&lt;/p&gt;&lt;p&gt;2、惯持竿手的手掌抵住后堵，掌心朝上抓住后堵；&lt;/p&gt;&lt;p&gt;3、轻抖手腕，感受竿身抖动时，手腕的负担；&lt;/p&gt;&lt;p&gt;4、同时对比长度相同的鱼竿，手腕负担最小的，就是持握舒适度较合适的鱼竿；&lt;/p&gt;&lt;p&gt;正常情况下，身高较高、体重较重的钓友，在竿长一致时，较重的竿身，持握舒适度会较高，而身高低一些，体重较轻的钓友，在竿长一致时，较轻的竿身，持握舒适度会更高一些；&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101119325.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;最后，关于持竿舒适度，其实没有什么标准而言，毕竟每个人的身高、体重、骨骼生长发育程度都有诸多不同，所以这也仅仅是竞技钓、黑坑老鸟们口口相传的一个说法，虽不怎么流传，但确实是有非常重要的实战意义。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185480', '1599185480');
INSERT INTO `ey_article_content` VALUES ('5', '18', '&lt;p&gt;咱们日常作钓用的浮漂，大多数漂尾都比较细，而这种细漂尾不知道大家发现没有，用的时间稍微久一点颜色有可能会变暗、变淡甚至直接掉漆，如果你的眼神不是太好，用长点的竿子根本无法看清漂相。&lt;/p&gt;&lt;p&gt;尤其是冬季，一方面我们会用长竿去钓一些比较小的鱼，第二方面鱼口又轻，这样一来漂尾颜色不鲜明，无形中就会错失很多鱼口。&lt;/p&gt;&lt;p&gt;时间久、漂尾颜色掉漆、变暗，有这么几种情况：如果是掉漆，一块块脱落的那种，除了人为的磕碰之外，那基本就是漂本身的质量不行。&lt;/p&gt;&lt;p&gt;而变暗、变淡，很多钓友觉得也是质量问题，是漆水不好。不排除这个可能，但我自己的经历是买那种一两百的也会这样，漂尾越细越容易淡。其实有一个重要原因是和你垂钓水域的水质、以及平常的保养有关。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41011493W.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;浮漂用久了漂尾变暗？预防比补救更重要，真遇到了也别急，可以试试这样做&lt;/h2&gt;&lt;p&gt;首先，浮漂变暗的很大一个原因是漂尾脏，是因为你垂钓的地方水质不太好，并且平常钓完鱼也没有及时清理、保养，一次两次没关系，时间久了污垢堆积，浮漂不但越来越暗，而且还难以清洗。&lt;/p&gt;&lt;p&gt;不清洗不保养浮漂容易变暗，但过度保养或者保养不当也不是好事。比如有的人特别爱惜自己的装备，一天擦三遍，就拿浮漂来讲，他可能也预料到污垢会堆积，于是每次钓完就玩命擦，恨不得擦出反光来，要么干脆带回家抹点牙膏，反复地撸。&lt;/p&gt;&lt;p&gt;这么玩，脏东西肯定是没有了，但漂尾颜色也越来越淡，有些漂尾比牙签还细，上面能有多厚的油漆，你三天两头撸，肯定得撸坏啊。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101149494.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;不保养不行，过度保养也不行，有些钓友脾气一下上来了：不就是根破漂吗，用得着这么讲究，老子从来不管这些，坏了就扔，直接买新的。&lt;/p&gt;&lt;p&gt;你要是这么想，那倒好办了，解决起来很轻松。如果既不想丢，又不想漂变淡变暗，每次用完不管浮漂脏不脏，都建议用湿润的软毛巾，轻轻擦两遍，要是一眼看上去就很脏，弄点饵料裹在漂尾上轻轻地撸几下，再用水洗干净。&lt;/p&gt;&lt;p&gt;从来不保养，漂尾已经变暗怎么办？可以先泡下水，或者用湿纸巾擦一擦，然后稍微抹点牙膏，用手指“按摩”几下，再用清水冲掉即可。&lt;/p&gt;&lt;p&gt;网上有钓友说可以用白酒+清水来清洁，这个办法我没试过，所以不敢保证有效。但牙膏是可以的，之所以平常不建议大家用，是因为牙膏里面有研磨剂，老是用或者很用力去摩擦，漂尾就不亮了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101150362.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;颜色变淡、掉漆等情况怎么办？最好不要自己去刷漆&lt;/h2&gt;&lt;p&gt;上面是解决漂尾变暗的问题，说白了就是清洗掉外表的污垢，而掉漆、颜色变淡，这种已经属于浮漂漂尾损伤了，简单的方法根本无法修复，想解决只能重新刷漆。&lt;/p&gt;&lt;p&gt;网上有很多给浮漂上漆的视频教程，看着是很简单，但我劝大家如果以前没有做过千万不要模仿，因为很多时候我们都是“眼睛看会了，脑子想明白了，但一上手就轻松搞砸了”。&lt;/p&gt;&lt;p&gt;旧浮漂上新漆，基本有两种办法，第一种比较简单，直接涂；第二种比较麻烦，得先打磨，把原漆磨掉再上新漆。&lt;/p&gt;&lt;p&gt;要想效果好，肯定选择后者，操作到位，浮漂就会想新的一样，但就怕你操作不到位。本来浮漂只是颜色变淡，勉强还能用，你瞎搞弄不好直接给毁了，专业的事还是交给专业的人来办。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101150229.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;最后说一说咱们在选漂时的注意事项&lt;/h2&gt;&lt;p&gt;一般来说，价格贵的浮漂肯定要比价格便宜的浮漂好些，这个好体现在哪？咱们先不说灵敏度，就做工、漆水、品控等方面那肯定也是贵的更出色。便宜的漂最明显一点就是次品率很高，大家都有网购的经验，比如你买个9.9包邮的漂，远看没毛病，近看就一大堆毛病，其中就不乏漆水不匀、暗淡无光泽等问题。&lt;/p&gt;&lt;p&gt;当然，我说这话绝不是说便宜的漂不能用，能用，而且要论性价比，远比一两百一只的更高，咱们只是就事论事。&lt;/p&gt;&lt;p&gt;平常玩野钓，不需要买太高档的，但我认为三五十还是可以考虑下。如果去实体店买，确定价位以后，尽量挑漂尾颜色较深、最好看上去有点发亮的，然后若不是冬天钓个体很小的鱼，不要买特别漂尾细的浮漂。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185511', '1599185511');
INSERT INTO `ey_article_content` VALUES ('6', '19', '&lt;p&gt;我朋友圈有很多卖渔具的，每天不管什么时间段，只要一打开就能看到各种各样的广告。我本身不讨厌卖产品、也不反感发广告，但有两种我是十分不爽的，一是疯狂刷屏，二是虚假广告。&lt;/p&gt;&lt;p&gt;比如卖小药的说他的小药能一滴爆护、能“闭三边”，然后配个不知道何年何月拍的鱼获照片，点开一看模糊的像打了马赛克。&lt;/p&gt;&lt;p&gt;比如卖鱼竿喜欢拍小视频，把竿子甩来甩去、还时不时钓个煤气罐，不知道的以为在杂耍。&lt;/p&gt;&lt;p&gt;还有卖鱼线的，这个也很多，卖鱼线的基本套路就是吊几瓶矿泉水、锯个塑料管，要么把线放水杯里展示一下“切水性”。&lt;/p&gt;&lt;p&gt;只要看到这种广告，我是肯定不会买的，而且还会建议其他人也不要买，至少对我的朋友、关注我的钓友，我会这么说。并且我一直坚信一个道理：广告做的越狠，东西往往越烂。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122Y12.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;说鱼线：某些鱼线能钓矿泉水、能锯塑料管，但未必适合钓鱼&lt;/h2&gt;&lt;p&gt;偶尔也有钓友会让我推荐鱼线，但从两三年前开始到现在，我推荐的鱼线基本也就是那么几种，瓦力瓦斯说的最多，其次就是美人鱼、中西、风行老鬼，想高端点就岩太郎。&lt;/p&gt;&lt;p&gt;鱼线虽然很重要，但我并没有特别关注，因为我个人比较懒，线组基本靠买，去渔具店老板问多少价位的，我就说2块钱一副的那种就行了（子线），也不知道他用的什么线，好用继续买，不好用就不去了。&lt;/p&gt;&lt;p&gt;以前在杭州去我朋友的店，我知道他是用瓦力瓦斯，我用了几年感觉还不错，所以也给大家这么推荐。&lt;/p&gt;&lt;p&gt;注：主线和子线的牌子最好一样，这样能避免某一种线涨号严重，拉力过渡不匀的情况。&lt;/p&gt;&lt;p&gt;朋友圈有很多卖鱼线的，看广告是很厉害，吊几瓶矿泉水、锯个塑料管一点问题都没有，但咱们钓鱼看的不是广告是“疗效”，这种线基本一实战就原型毕露。如果你觉得实战也还行，很结实，建议检查下是否涨号。&lt;/p&gt;&lt;p&gt;吊矿泉水是为了展现拉力值，锯塑料管是为了说明耐磨性好，但实际真的是这样吗？你可以用手上其他品牌的鱼线试试，会发现也能锯断，要是锯不断那就换粗一点再锯一次。&lt;/p&gt;&lt;p&gt;而且鱼线有很多的参数，某项性能好根本代表不了什么，最主要是你得明白自己所应对的鱼情，需要突出鱼线的什么性能。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122V95.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;买鱼线和买鱼竿一样，适合鱼情才最重要，所以只看“能钓几瓶矿泉水”毫无意义&lt;/h2&gt;&lt;p&gt;鱼线吊矿泉水、鱼竿钓煤气罐，商家的目的都是为了展现拉力值，但这玩意儿你觉得多靠谱？首先，它们成功吊起的那个竿子、那个鱼线，和你买到手的未必一样。其次，钓起来了又如何，如果仅仅是为了大钓重、钓到大鱼不断，弄个钢筋加麻绳就行了。&lt;/p&gt;&lt;p&gt;拿鱼竿来说，大钓重的鱼竿不少，市面上那些针对青鱼、鲟鱼设计的巨物竿，钓重可以轻松达到七八千克甚至十几千克，但这种杆子野钓实用吗？白给你用你都未必吃得消用，最关键是哪里这么多大物啊。&lt;/p&gt;&lt;p&gt;鱼线也是一样，同样是1.0的线，你别看人家做广告的钓了好几瓶矿泉水，显得比其他品牌甚至一些一百多的线还结实，但你不知道的是他这个线涨了几个号、有多硬。&lt;/p&gt;&lt;p&gt;买鱼线，不仅要看拉力值，还要看耐磨性、结节强度、延展性、回弹性、切水性、抗卷曲性以及是否涨号等等。&lt;/p&gt;&lt;p&gt;如果一款线，拉力特别强，但是它不耐磨、无弹性、爱打结，甚至影响入口性或者信号的传递，那它啥也不是。如果这些你都不在意，只想买拉力强的，那不如直接大力马，肯定靠谱。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122R36.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;鱼线的参数太多，找一个综合性出色的太难，我们究竟该怎么选&lt;/h2&gt;&lt;p&gt;上面说了鱼线的很多参数，而市面上的鱼线，每一种线的特点其实都是不相同的，比如说有些鱼线拉力很强，但延展性略差；有些鱼线延展性很好，但拉长后回不去了，你要想每方面都很出色，不太现实。&lt;/p&gt;&lt;p&gt;这就和鱼竿一样，有的牌子注重涂装，有的注重调性，需要钓鱼人根据自己的喜好或面对的鱼情去挑选。下面我举几个例子，帮助大家去挑选鱼线。&lt;/p&gt;&lt;p&gt;•野钓，以钓小鱼为主&lt;/p&gt;&lt;p&gt;钓小鱼，基本配置是短竿+细线+小钩，那这种情况下别老想着搞大物，否则很可能导致大物钓不到、小鱼也没钓好。&lt;/p&gt;&lt;p&gt;钓小鱼不要考虑拉力值有多强，关键在于第一线号尽量要标准，第二要柔软一些，第三扛卷曲性要稍微好点（因为要频繁抛投）。&lt;/p&gt;&lt;p&gt;•野钓，以钓中小体型的鱼为主&lt;/p&gt;&lt;p&gt;所谓中小体型的鱼，意思就是很多钓友口中的“通杀”。这个时候鱼线的拉力值能高就高点，但前提是不过分涨号，然后鱼线的回弹性要好，所谓回弹性是指能延展又能恢复原状，如果你的线钓了几次以后长了十几公分，回不去了，那就是“垃圾线”。这种线用来钓小鱼还好，想搏大鱼是不靠谱的，更别在黑坑使用。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122T94.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;•野钓，以钓大鱼为主&lt;/p&gt;&lt;p&gt;钓大鱼最重要的不是涨不涨号，也不是拉力值多强，我个人认为是耐磨性要好些，因为大鱼冲力大，很有可能控不住，万一钻草里或者磨到石头，你的线耐磨性差的话很容易断。&lt;/p&gt;&lt;p&gt;除了耐磨性，结节力度也要强，不管什么鱼线，在打了结以后，拉力值都会下降，很多时候断线就断在结节处，所以我们钓大鱼要求的是结越少越好，打结的方式、手法也要靠谱，只说鱼线的话，结节拉力肯定越强越好。&lt;/p&gt;&lt;p&gt;至于拉力值，并不是说不重要，而是钓大鱼一般情况下也都是粗钩大线，你的鱼线再好拉力再强，我用大你一二号的线，肯定就比你强了。&lt;/p&gt;&lt;p&gt;至于线的软硬度，理论上来说，同种类的线，线越粗肯定越硬，如果两款线价格相仿、拉力值、耐磨性、结节强度等几个重要参数也都差不多，那软的那个我认为更合适，钓什么鱼都一样。&lt;/p&gt;&lt;p&gt;补充：黑坑作钓该用什么线&lt;/p&gt;&lt;p&gt;玩黑坑，正钓抢鱼时线可以硬一点、涨点号也能接受，但延展性不能太好，尤其不能要那种只延展不回弹的垃圾线。黑坑偷驴可以参照野钓小鱼，线要软一点、细一点，其实这时候你直接用野钓线也没关系，偷驴口慢，追求的不是速度，是成功率。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122U47.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;鱼线品牌哪家强？什么价位才合适&lt;/h2&gt;&lt;p&gt;很多钓友都喜欢买东丽鱼线，说如何如何好，但实际上你们买到了，也无法辨认真假吧，也许说东丽线好的人，其实用的一直是国产线。买任何产品，当我们没有使用无法辨别其好坏的时候，只有两种选择方法：一是选一些知名度较高、口碑较好的品牌；二如果是小众品牌，从来没听过的，那你得先了解卖产品的人，卖家人品好，那他的产品一般不会差到哪去。&lt;/p&gt;&lt;p&gt;至于价格，主要由两点决定，一是你的经济能力，二是你的出钓率。前者就不多解释了，说后者，如果你的出钓率很高可以买稍微好点的线，如果出钓率低，一年钓不了几次，鱼线买的贵也是浪费，放久了肯定老化，甚至我都不建议卖一大堆线，还不如渔具店买点成品实在。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410122V05.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;最后补充一点是鱼资源及换线率&lt;/h2&gt;&lt;p&gt;就拿我自己来说，我老家这边鱼资源并不好，大鱼咬钩几率很小，平常以钓鲫鱼、餐条、小鯝鱼为主。于是去年我就买了个便宜线，12块钱3卷，一卷200米，这个价格我根本不奢求什么，反正钓小鱼是没问题，抗卷曲线、回弹性差也无所谓，钓两次感觉不好了就换，很安逸。要是大鱼很多，或者你一副线准备用很久，那还是买好点或者用的粗一点。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185550', '1599185550');
INSERT INTO `ey_article_content` VALUES ('7', '20', '&lt;p&gt;问：为什么鱼竿分鲫鱼竿、鲤鱼竿、综合竿？难道鲫鱼竿就钓不了鲤鱼吗？&lt;/p&gt;&lt;p&gt;答：这还用说，商家想尽办法赚钓友的钱呗，以前咱用竹竿哪有那么多讲究，一只竿就能钓所有鱼。&lt;/p&gt;&lt;p&gt;这是网上关于钓具常见的“问与答”，大家应该也有看到过，如果你没印象，我再举个类似的例子。&lt;/p&gt;&lt;p&gt;问：饵料为什么分基础饵、主攻饵、状态饵，为什么有那么多味型，另一方面商家又给这样那样的配方，难道不能在出厂时全配好吗？&lt;/p&gt;&lt;p&gt;答：这还用说，商家想尽办法赚钓友的钱呗，以前咱用蚯蚓、面粉哪有那么多讲究，现在流行商品饵，我也是一包蓝鲫就能全搞定，别迷信什么配方，水里有鱼，挂什么都吃。&lt;/p&gt;&lt;p&gt;有些钓友，对于自己回答不上来的问题总习惯把矛头对准渔具商家，如果出现某些情况与自己的垂钓理念不符，那也是商家的锅。&lt;/p&gt;&lt;p&gt;如果你比较偏激、或者铁定觉得自己是对的，那谁都无法叫醒你；如果你认为自己是理智的，只想弄清答案，可以继续往下看。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101254F3.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;鱼竿为什么要分类，鲫鱼竿鲤鱼竿综合竿究竟有什么区别？&lt;/h2&gt;&lt;p&gt;虽然鱼竿分为鲫竿鲤竿综合竿，但每种竿之间的界限是比较模糊的，反正我不知道有什么绝对的标准去衡量，而且目前国内鱼竿市场又很乱，能找到不虚表参数、不夸大效果的产品就已经很不错了。&lt;/p&gt;&lt;p&gt;我平常一般建议大家买竿选大品牌，大品牌相对来说各方面都要靠谱些，像一些小作坊出来的竿子，可能你看他标注是鲫竿，实际拿到手就是根“烧火棍”。&lt;/p&gt;&lt;p&gt;注：下面我仅站在一个钓鱼人的角度来分析鱼竿种类，请勿当做标准或认为这就是正确答案。&lt;/p&gt;&lt;p&gt;鲫鱼竿：&lt;/p&gt;&lt;p&gt;特点是竿子整体较细，锥度小，克重轻，竿壁相对薄，调性常见46调、37调，尺寸多为5.4及以下。当然也有一些长尺寸的鲫竿，但多数还是以短尺寸为主。&lt;/p&gt;&lt;p&gt;鲫竿并非只为鲫鱼设计，它是针对一些小体型的鱼，主要在一两斤以下，我手上的鲫鱼竿5.4米基本重100克左右，3.6米重五六十克。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101254a2.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;鲤鱼竿：&lt;/p&gt;&lt;p&gt;特点是竿子整体较粗，锥度相对较大，克重大，竿壁厚实，调性常见28、19，也有一些37、46调的，比如老款的龙纹鲤，那个是典型的鲤竿，但调性却很靠后。&lt;/p&gt;&lt;p&gt;鲤鱼竿主要是针对一些大体型鱼种，但目前市面上你也能看到克重小、锥度小且比较竿体较细的“鲤竿”，有一些是轻量鲤竿，有些则是偏向综合性的，所以我前面说了，每种竿子之间的界限很模糊。&lt;/p&gt;&lt;p&gt;我自己手上的竿子，能符合我对鲤鱼竿定义的（指钓十几二十斤大鱼比较靠谱的），5.4基本在150克左右，6.3在200克左右，当然了如果是价格比较贵的“高碳竿”可能会轻点。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101254S2.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;综合竿：&lt;/p&gt;&lt;p&gt;顾名思义性能比较综合，可理解为钓的目标鱼种个体介于鲫竿和理竿中间的竿子。这类竿子软硬度也比较适中，调性在37～28调，尺寸3.9～5.4比较多，目标鱼个体根据鱼竿的尺寸，可以在几两至十几斤之间。&lt;/p&gt;&lt;p&gt;这类竿子市面上最多见，因为很符合野钓的鱼情，也符合钓鱼人想一杆钓所有鱼的要求，但是这种杆子和轻量鲤鱼竿、轻量大物竿不太好区分。&lt;/p&gt;&lt;p&gt;我个人的区分办法很土，如果是大品牌口碑比较好的厂家，它要标的是综合竿我就信了。要是不靠谱的品牌或是杂牌，那我就看粗细、竿壁厚度及重量。&lt;/p&gt;&lt;p&gt;前面说5.4的鲫鱼竿一般100克左右，比较靠谱的鲤鱼竿5.4重量在150克左右，那么一百二三十克的，差不多就是综合竿或者轻量鲤鱼竿了。当然只看重量也不能完全定义，因为参数可以虚表，碳布的吨位也有影响。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101254F1.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;“看，我又用鲫竿钓了个大鲤鱼”，难怪你的鱼竿越用越软！&lt;/h2&gt;&lt;p&gt;鲫鱼竿能钓鲤鱼吗？能钓，但最好别钓。上面简单说了几种竿子的区别，大家也应该知道了，钓小鱼的竿子轻薄且较软，这样设计的目的不仅仅是为了手感更好，主要是长时间抛投、垂钓不会累。&lt;/p&gt;&lt;p&gt;钓大鱼的竿子比较强力，这样你在和大鱼较量时就不用担心，卯足劲和它干就是了，钓大鱼的竿子是比较重，但大鱼多为守钓，不需要经常起竿换饵。&lt;/p&gt;&lt;p&gt;拿鲤鱼竿可以钓鲫鱼、白条吗？这个大家都知道，行肯定是行，只不过有点杀鸡用牛刀的感觉，最主要是太累了，玩一天胳膊得废。&lt;/p&gt;&lt;p&gt;鲫鱼竿钓大鱼也不是不可以，但由于它比较轻薄、钓力值较低，故断竿的风险就上升了。&lt;/p&gt;&lt;p&gt;我打个比喻，鲫鱼竿就像是一个柔弱的女子，你如果让他去干大老爷们干的粗活，那小身板肯定吃不消，说不定哪天就累倒了。&lt;/p&gt;&lt;p&gt;另外还有两个问题不容易被发现：&lt;/p&gt;&lt;p&gt;1、鲫鱼竿本身就不硬，大鱼冲击力强，就算没有达到竿子的极限，没有造成断裂，但你老是在挑战它的极限，越用越软是必然的，而且会很快变软，到后面可能一二两的小鲫鱼都得遛很久了。&lt;/p&gt;&lt;p&gt;2、又由于鲫鱼竿不硬，所以你在操控时要很小心，准确地来说大鱼如果拼命往外冲，你拉也拉不住，因为鱼竿的硬度、腰力都跟不上。如果钓点环境复杂，有乱石、有树桩，那么跑鱼的概率是很高的。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101254934.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;有一种观点：鲫鱼竿软，配合小钩细线，在刺中大鱼时，大鱼没什么感觉，所以冲击力度不强&lt;/h2&gt;&lt;p&gt;这个观点我是比较认同的，鱼竿越硬、线组越粗、鱼钩越大、你起竿越狠，那么鱼感受就越强烈，会拼死一搏。&lt;/p&gt;&lt;p&gt;反之，用小钩细线加上轻柔地起竿，鱼就感受不到很强烈的拉扯感，也就不觉得很危险，所以挣扎力度会小很多，这也是大家小钩细线中大鱼的主要原因。&lt;/p&gt;&lt;p&gt;但这里面还是有个概率的问题，就像前面说的，你用鲫竿配合小钩细线去钓大鱼，肯定不敢硬刚，鱼如果乖点不乱游还好，如果它要走你根本留不住。咱们就不说那种猛烈的冲击了，就算它缓缓往深水或左右游动，你也拉不住，万一碰上障碍物，断的更快。&lt;/p&gt;&lt;p&gt;例：有年秋季，我和朋友去一个河道钓鲫鱼，我朋友用的是一根4.5的综合竿，钓着钓着中了个鲤鱼，他当然明白不能硬刚，所以只能迁就着鱼。然后那条鲤鱼就一直往右边游，我朋友就跟着往右走，走了大概十多米，被石头磨断了线，另一钩挂了个鱼鳞上来。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101255O2.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;野钓的时候你用鲫鱼竿+小钩细线，遇到大鱼，把鱼遛上岸了值得开心，但不能因此说鲫鱼竿就可以钓大鱼了，可以主动去这么干。&lt;/p&gt;&lt;p&gt;偶然遇上是没办法，只能背水一战，主动去找大鱼钓，那是“毁竿子”的做法。而且鲫鱼竿也不能上太粗的线组，2+1差不多也是极限了，再粗的线，那真是要妥妥地断竿子了。&lt;/p&gt;&lt;p&gt;注：很对人觉得自己的鲫鱼竿很牛，2+1、3+2随便上，那可能是竿子比较便宜所以不心疼，如果你不是土豪，整个一两千的竿子这样试试，配个几次节就会心疼了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101255110.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;最后：野钓什么样的鱼竿最好用&lt;/h2&gt;&lt;p&gt;我个人觉得用途最广的当然是综合竿了，因为就目前的鱼资源来看，野钓主要以钓小鱼为主，偶尔会碰上几斤的鲤鱼草鱼，用4.5、5.4的综合竿比较实用，遇上三五斤的鲤鱼也不至于一点底气都没有。&lt;/p&gt;&lt;p&gt;如果资源差，你偏爱钓小鱼，那就买短尺寸的鲫鱼竿，遇上两三斤的鲤鱼操作得当能上来，再大的全看运气。如果资源很好，大鱼特别多，你可以买一只强力的鲤竿，或者干脆上“大物竿”。大物竿是更粗、更重、钓力值更高的一种竿子，可以生拉硬拽，和大鱼硬刚。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185576', '1599185576');
INSERT INTO `ey_article_content` VALUES ('8', '21', '&lt;p&gt;这又是一篇关于选竿的文章，其实此类文章比较难写，每个人的想法不一样，在选择时侧重点也就各不相同。但是，鱼竿又是钓友们关注度比较高的一件装备，尤其是新手，面对各种品牌、型号的鱼竿可能一下就蒙圈了，也不知道哪个更适合自己，此时如果有人给点建议会好很多。&lt;/p&gt;&lt;p&gt;说回鱼竿的问题，野钓和黑坑虽然都是钓鱼，但就竿子选择而言完全不一样。野河鱼种杂、个头大小不一，所以很多人想买那种“钓小鱼不累、钓大鱼又不易断”的鱼竿，而黑坑作钓节奏比较快、大家都在拼速度、抢鱼，所以对鱼竿硬度的要求会比较高。&lt;/p&gt;&lt;p&gt;本文我就针对黑坑作钓，谈谈自己对鱼竿选择的看法，文章适合新手、初入黑坑的钓友观看，老钓友们可以直接划到底部留言，分享一下你的经验。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410132E45.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;个人对鱼竿选择的看法：野钓追求手感、黑坑追求性价比&lt;/h2&gt;&lt;p&gt;我竿子比较多，从一两百到一两千各个价位都有，但根据自己的作钓经验，总结以后我得出的结论就是野钓的竿子买好些、黑坑的竿子买差些（应该说更注重性价比）。&lt;/p&gt;&lt;p&gt;这里补充两点：1、这只是我个人看法；2、对于土豪来说没有必要分作钓场景及用途，在不差钱的情况下，肯定是贵的好用。&lt;/p&gt;&lt;p&gt;我这么说，一定有人会不同意，像我以前写鱼竿类的文章，也总有很多钓友评论，比如：我就用拼夕夕上买的9.9包邮的鱼竿，一样用的很好，钓十几斤的鱼也没断过。再比如：水里有鱼竹竿都能钓到，水里没鱼几千的鱼竿还是空军。再比如：野钓休闲娱乐为主，竿子没必要用太好。诸如此类的话还有很多，就不一一举例了。&lt;/p&gt;&lt;p&gt;那玩黑坑的钓友可能也会有疑虑：黑坑花钱钓，几百块塘费都付了，还不买个好竿子嘛？万一钓一半断竿了，不是要悔死？&lt;/p&gt;&lt;p&gt;每个人都有每个人的道理，我也不想强行去说服你们，就像文章开头说的那样个人想法不同，在选竿时侧重点也不同，总之自己玩的开心就好，这个没毛病。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41013261a.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;说说我自己的想法吧&lt;/h2&gt;&lt;p&gt;野钓大多数时候以钓小鱼或中小型鱼为主，虽然看似抽竿频率没黑坑那么高，但由于作钓时间长，甩个一天怎么也得上百竿了。用稍微好点的竿子，抛投上会比较舒服，中鱼、遛鱼时，手感也很清晰，更能感受垂钓的乐趣。咱们玩野钓鱼竿的尺寸基本在3.6、4.5、5.4这三种，3.6还好，但4.5和5.4来说，好竿和差竿的手感还是有很大区别的。&lt;/p&gt;&lt;p&gt;而黑坑，抽竿频率是很高，但作钓时间比较短，总共就4～6个小时，正钓的话“狂口期”也就半小时到一小时，另外钓黑坑鱼竿不会很长，通常在4.5以下比较多见，结合这两点来看，鱼竿手感就并不重要。&lt;/p&gt;&lt;p&gt;再补充一点，黑坑鱼口不好时，想必你也没心情去体验作钓的快乐了；如果狂口，那就更不在乎手感了，就想着尽快把鱼弄上岸，抓紧多钓几条。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410132A42.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;黑坑作钓节奏快，鱼竿是否越硬越好&lt;/h2&gt;&lt;p&gt;答案当然是否定的，黑坑确实要抢时间、抢鱼，理论上鱼竿越硬回鱼就越快，甚至都不用遛，可直接进行飞磕、飞抄。&lt;/p&gt;&lt;p&gt;但这里有两个问题：&lt;/p&gt;&lt;p&gt;1、你要知道你在多少票的黑坑作钓，一两百块钱的黑坑，完全不用想着鱼情多快，不空军就谢天谢地了。&lt;/p&gt;&lt;p&gt;2、鱼竿越硬、基本功不扎实，就越容易切线跑鱼，你用软竿1分钟钓2条，但两条全能拿上来，但用硬竿虽然1分钟可以钓4条，但钓两条跑一条，这样一算还不如用软竿，至少不用担心炸窝。&lt;/p&gt;&lt;p&gt;我们这边鲫鱼坑比较多，票价在100～200不等（正钓价格），所以我用的鱼竿，正钓一般5H、6H左右，偷驴最多用个4H或者直接用野钓那种软竿。当然，每个鱼竿品牌的硬度标准是不一样的，这里只是给个大概参考。&lt;/p&gt;&lt;p&gt;如果钓鲤鱼，鲤鱼的个头比鲫鱼大些，在硬度方面可能也要更强一点，但鱼情要不是特别快，还是建议别用太硬。&lt;/p&gt;&lt;p&gt;我看有些人都已经干到9H、10H了，然后二三斤的鲤鱼也不遛，直接飞抄，这样作钓，时间久了胳膊就废了，千万要注意。实际上市面上有些竿，已经标明了是“黑坑鲤竿”，这种硬度不会太低，6H、7H可能也已经比较硬了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41013264G.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;玩黑坑到底买什么样的竿子&lt;/h2&gt;&lt;p&gt;正钓：建议尺寸3.6、3.9，硬度6H～8H（主要看鱼种类和大小），价格可以便宜点，一二百或者二三百就行了。&lt;/p&gt;&lt;p&gt;廉价竿碳布等级不会高，统一特点就是竿体整体的锥度很大（手把节很粗），然后竿壁比较厚，有些超硬的竿子，竿稍都快赶上软竿的小二节那么粗了。而且这种竿哪怕是短尺你拿在手上都会感觉“份量”很足，可能需要顶着小臂才能起竿。&lt;/p&gt;&lt;p&gt;这种竿在很多人眼里就是“辣鸡竿”，但实际上我个人认为性价比还是比较高的，正钓开口期也就那么点时间，上鱼又都很暴力，全是生拉硬拽，竿子好坏基本没差别，何况黑坑很多时候鱼种单一、个头大小又都一样。&lt;/p&gt;&lt;p&gt;偷驴：建议3.9以上，我一般会用4.5，如果钓的人比较多、鱼口又不太好（有很多回锅鱼、受伤的鱼），那么能用多长用多长，甚至采用一些“流氓钓法”想尽办法钓远。&lt;/p&gt;&lt;p&gt;偷驴的时候竿子选择大有讲究，有些黑坑出鱼率不错，老板放鱼也够多（或者票价很高），那鱼竿依然可以用的硬一些，4H、5H也是可以的，没有那么多的回锅鱼，竿子也就不需要很长了。&lt;/p&gt;&lt;p&gt;但如果鱼少、口少、并且老鱼的力气还比较大，那么鱼竿不能用太硬，这种鱼情下如果你有好竿子就可以拿出来用，哪怕它很软。因为这种鱼情下会用到细线+糗鱼，我们需要把每一条鱼都钓好，一旦咬钩就让他跑不掉，而好竿子的腰力肯定比廉价竿更足一些，软一点又会护线，能够帮你钓到更多鱼。&lt;/p&gt;&lt;p&gt;前面说了我野钓的竿子会用的比较好，那这种竿我就能拿来偷驴使用，如果你要买可以买个五六百以上的，不管是否达到这个价格，都建议买软一点。&lt;/p&gt;&lt;p&gt;混养：混养即啥鱼都有，好比是一个缩小版的野钓，这种鱼情我觉得比较难钓，主要是对钓者心理的考验，如果你目标明确就想钓小鱼或就想钓大鱼那倒还好，就怕是想大小通杀，这就很尴尬了。如果想通杀，我建议鱼竿还是长点，选综合竿，硬度不要太高、价格也在五六百左右，就和你偷驴用的竿子差不多。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410132N19.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;黑坑钓大鱼该用什么竿？&lt;/h2&gt;&lt;p&gt;价格便宜、又粗又厚，能够经得起生拉硬拽就行，如果某个钓场生意比较差，作钓人数少，竿子软一点就行，如果生意好钓鱼人多，那不管偷驴还是正钓竿子还是得硬点，否则你一个鱼遛半天、偶尔还遛到人家窝子里转一转，那估计会被喷死。&lt;/p&gt;&lt;p&gt;说到大物竿，可能很多钓友会想到金泉，比如说金泉的劲龙鲤还算比较出名。金泉做大物竿确实还不错，我之前也有推荐过不少，但他的竿子算不上很便宜吧，就拿劲龙鲤来说得上千了。论便宜实惠的话，我觉得汉鼎还不错，像螺纹钢、战舞鲤这些都行，要么光威战青、战鲟。&lt;/p&gt;&lt;p&gt;这俩牌子大家应该是耳熟能详了，不需要我做过多介绍，反正你要在黑坑钓大物就买皮实厚重的竿子，如果它顶钓值是实标，那肯定越大越好。不像野钓大物，由于鱼少、个头普遍也不大，我们就需要考虑手感。&lt;/p&gt;&lt;p&gt;像宝飞龙、名伦、开沃精工这类名气较大的品牌也有很多大物竿，靠谱吗？好是好，就怕价格吃不消，而且这类竿拿到黑坑去生拉硬拽反正我是觉得有点可惜，而且也还不如几百元的用着踏实。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410132LP.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;h2&gt;关于黑坑选竿的品牌补充&lt;/h2&gt;&lt;p&gt;大物竿已经说了，汉鼎、光威就不错，加点钱就买金泉，像其他一些专门针对大青或鲟鱼的竿子，你要觉得品牌靠谱也可以买。&lt;/p&gt;&lt;p&gt;正钓的话，鱼竿品牌不需要讲究，只要尺寸与硬度合适就行，哪怕杂牌都可以，只是买的时候务必看下评论，有的竿介绍说很硬，拿到手上软的要死，这种竿就无用了，野钓玩着也不会爽。&lt;/p&gt;&lt;p&gt;偷驴的竿子可以适当买好点，像宝飞龙、名伦、迪佳、化氏这类品牌名气不错，价格也有便宜的，或者像钓鱼王、怡隆也可以。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185608', '1599185608');
INSERT INTO `ey_article_content` VALUES ('9', '22', '&lt;p&gt;钓龄够长的那拨人基本都有diy钓鱼用品的经历，我就属于那拨人。&lt;/p&gt;&lt;p&gt;回想起来，我做过的最多的当属竿架，虽然看起来土得掉渣，但我认为确实非常好用，它的最大优点是，无论刮多大的风，竿子架在上边都特别稳当。要是不够稳，就再压块儿石头。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101503161.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;我做的竿架子通常可以同时架设三到四支鱼竿，当然了，大多数时候只架设一两支就够用了，但是它有三四个凹槽，也就是说可以随时调换鱼竿位置，鱼不咬钩的话，我可以让竿子左边挪右边、右边挪左边地去搜索。&lt;/p&gt;&lt;p&gt;这种竿架的前后凹槽的开档距离不一样，前面的宽，后面的窄，架设两支以上鱼竿的时候呈扇形，不至于相互干扰，扇形角度的大小也是可调的，两个凹槽离得越近，扇形角度越大，反之则小。&lt;/p&gt;&lt;p&gt;这小竿架重量轻、体积小，功能还不差，在几十年前那个注重实用性的年代里挺闪耀的。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41015033X.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;不过，随着时代的发展，各种渔具用品越来越丰富，不但价廉实用还美观，于是自己也就无需亲自动手制作了，现在的人谁还在乎那几个小钱？不过，我一直没停止过折腾。毕竟，自己做出来的东西才是自己最需要的。&lt;/p&gt;&lt;p&gt;若干年前，当渔具店里出现颗粒饵的时候，我就琢磨着把颗粒这种固态钓饵变成面状可雾化钓饵，没等琢磨明白呢，市场上就有卖颗粒粉的了，这个想法就搁浅了。&lt;/p&gt;&lt;p&gt;再后来，突然有那么一天，我寻思把酒米之类的变成粉状物用来钓鱼岂不是很好？嗯，那时候家里有了一种叫破壁机的东西，还有一种叫豆浆机的家用电器，用它们打米粉，好极了。&lt;/p&gt;&lt;p&gt;可是问题也来了，家里做食物的工具要是和鱼饵联系起来恐怕会不卫生，毕竟鱼饵里啥怪味都有，咋办呢？终于有一天，我没忍住，蹑手蹑脚地拎着袋麝香米，试图偷用一下豆浆机……反正那次作案未遂，被家里首长逮了个现行，但是这个念头却愈发强烈起来。&lt;/p&gt;&lt;p&gt;不行，我还得自己做。有了自己做的机器，我想打什么粉就打什么粉，酸的、臭的、腥的……我想咋折腾就咋折腾。&lt;/p&gt;&lt;p&gt;怎么做？首先，我需要一个电机，体积不要大，功率不能太小。嘿嘿，我的工作室就有角磨机。动力确定了，其他的问题就好解决了。关键是两个部分，一个是刀头，另一个是粉碎罐。&lt;/p&gt;&lt;p&gt;做一个刀头对我来说不是什么难事，热处理之类的活计完全是轻车熟路，需要费一点心思的是，这个刀要多大，是否和角磨机的电机动力相匹配，也就是该给电机这匹小马配多大的车。&lt;/p&gt;&lt;p&gt;我估算了一下，小电机带动80毫米的刀头绰绰有余，反正我也不批量加工，能做二三百克鱼饵就够了，所以这么大的刀头没问题（成品刀头见下图）。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101503H2.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;另一个关键部分就是粉碎罐了，做这个罐子很省事，去两元店买一个直径100毫米的白钢茶缸即可，或者大小差不多的铁皮罐头盒、茶叶罐等皆可。&lt;/p&gt;&lt;p&gt;不过，喜欢折腾的我更乐于自己动手，于是叮叮当当又是一顿锤子，把一块铁板砸成一个罐子，用电焊封个底，就完活了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101503G7.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;电机加刀头&lt;/p&gt;&lt;p&gt;其实，做到这一步，这个粉碎机已经可以上岗了，但貌似它自己还站不稳，它高转数挺高的，可别二两米粉没打完就自己跑到邻居家串门去了，所以，做个小支架吧！再加上几个胶皮小脚丫，是不是还能减震降噪？那就加（见下图）。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101504240.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;大功告成，见证奇迹的时刻到了，我没来得及洗手，搓了两穗老玉米，做个&amp;quot;开光&amp;quot;试验，结果超满意，因为太激动，忘了计时。第一次试验，经验偏少，我就打一会儿停一下，看看面粉的状态，再接着打，直到满意为止。这面粉用手一捻，有细末，也有相对粗一些的小颗粒，我认为做鱼饵这个状态就可以了。&lt;/p&gt;&lt;p&gt;再往下要做的就是把那个粉碎罐精加工一下，这个DIY就圆满了。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101504a7.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;“开光”试验圆满成功&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101504P8.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;状态刚刚好，正适合做鱼饵&lt;/p&gt;&lt;p&gt;我要是把这个又黑又憨的家伙拿到家里，领导会翻我白眼不？可我想好了，我就说我要自己打辣椒面、做十三香！嘿嘿，又添了件家用电器！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101504C5.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;欢迎这又憨又笨的家电新成员&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185705', '1599185705');
INSERT INTO `ey_article_content` VALUES ('10', '23', '&lt;p&gt;当下生活条件比较好了，能花钱买的东西，自己基本就不会去动手做了！在很多钓友眼中，自制的东西浪费时间，还不好用倒不如去买！当然怎么选择随钓友自己，本期我们不聊如何钓鱼！&lt;/p&gt;&lt;p&gt;&lt;img title=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图1)&quot; alt=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图1)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z410153G28.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;而是聊聊早期大家钓鱼使用过的一些东西，如果你之前用过，那么足以说明你的年龄不小了！因为现在没人会用，包括我自己在内！虽然我喜欢自制，但现在钓鱼我从来不用这些做钓具了！&lt;/p&gt;&lt;p&gt;竹竿：记得之前钓鱼的时候，根本就不知道什么碳素杆，玻璃钢鱼竿！什么碳布几节这些都没考虑过，家里有种菜支架的竹竿，找来一个比值点的！然后绑上鱼线就可以拿来钓鱼，虽然放到现在看着很low，但之前钓半斤多的鱼，一点毛病都没有！&lt;/p&gt;&lt;p&gt;&lt;img title=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图2)&quot; alt=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图2)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z410153NW.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;图钉做鱼钩&lt;/p&gt;&lt;p&gt;长图钉：想钓住鱼，自然得想办法刺住鱼。当然根本不知道什么碳素钩子，什么钩型就是在电视看到过，参照那个样子。拿来那种比值的图钉，然后用钳子掰弯，为了更圆滑，同时还用蜡烛烤着点，而且图钉末端有帽，根本不担心脱钩！&lt;/p&gt;&lt;p&gt;缝纫线：这种线至于什么材质我也说不上来，入水的时候起初会浮在水面，当然随着浸泡湿润以后就可以入水了。就是早期缝衣服那种白线，记得那个时候奶奶还用它纳鞋底子！根本不像现在这样，讲究这个讲究那个，就是一根线用到底！&lt;/p&gt;&lt;p&gt;&lt;img title=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图3)&quot; alt=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图3)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z410153M39.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;高粱杆&lt;/p&gt;&lt;p&gt;高粱杆：鱼在水下什么时候咬钩子，这个我们不清楚，自然是需要浮漂的，当然那个时候有浮漂，但是根本买不起！但是庄稼地里面有一种东西，它入水比较清，那就是高粱杆！入水可以站立，拿个彩笔涂几个点，照样拿来钓鱼！&lt;/p&gt;&lt;p&gt;保险丝：起初根本就不知道什么铅皮，但是知道什么比较重。早期家里电闸都是用保险丝，它是铅制品，重量是比较把东西拉到水底的。当然那个时候这个东西比较金贵，往往拿来钓鱼之后，被发现少不了挨收拾！&lt;/p&gt;&lt;p&gt;&lt;img title=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图4)&quot; alt=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图4)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z410153NJ.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;篮子做鱼护&lt;/p&gt;&lt;p&gt;篮子：起初根本没鱼护一说，钓到的鱼不可能直接放掉。因为还要拿回去吃掉，当然想着把鱼拿走得先把鱼存放到一起！这个时候就用到了篮子，它可以在水中浸泡，鱼还跑不掉！当然那种篮子现在已经不见了，起初都是用那种塑料条编织的！&lt;/p&gt;&lt;p&gt;树杈：钓鱼时间长了，一直握着还是比较累的。那个时候根本没有钓箱支架，当然这个根本难不倒俺们，找个树杈那种枝条比较长的，往水中一插竹竿往上一放，这个支架就做好了，那种回忆真是美滋滋！&lt;/p&gt;&lt;p&gt;&lt;img title=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图5)&quot; alt=&quot;用过这些东西做钓具的人，说明你的年龄不小了(图5)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z410153KE.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;从接触钓鱼到爱上钓鱼，这一路走来，如果说最开心的时刻，那么非上述回忆是最好的了！起初没有那么多的弯弯绕，钓鱼不在乎什么味型什么状态，甚至是打窝。只要有鱼挂上蚯蚓就能钓到，而且个头都不小。说着自己都要流口水了，可惜现在没有了那样的鱼情了！各位钓友，看完此文，你有没有过类似这样的经历呢？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185741', '1599185741');
INSERT INTO `ey_article_content` VALUES ('11', '24', '&lt;p&gt;钓鱼当中会用到很多的钓鱼用品，它们可以协助我们更好地去钓鱼。正是因为如此，很多钓友在购买的时候一点也不理智。看到这里大家会问，为何用不理智来形容呢？刚才你都说了，渔具是帮助大家多钓鱼，前后有点矛盾啊！&lt;/p&gt;&lt;p&gt;钓友莫急，请听我慢慢说！如果渔具实用，而且是自己需要的，那么这对钓鱼帮助很大。如果不实用，也不是自己需要的，那么这些东西买了就浪费钱！当然有人会说，既然不需要了为何还要买呢？其实很多钓鱼人都有这样的毛病，那就是喜欢跟风！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101610511.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;见别人买什么自己也会去买，至于用不用得到，这些就两说了！见别人有自己也有，最后渔具买了一大堆，用到的没有几个。它们的归宿就是放到仓库，扔起来和尘土在一起。所以为了让大家不再浪费钱，本期我来给大家分享一些不实用的渔具让钓友参考，其二就是起到抛砖引玉的作用。&lt;/p&gt;&lt;p&gt;毕竟现在赚钱也不容易，能省电是点。钱用到正经地方，买的渔具能发挥到最大的作用。好了，长话短说了，大家往下看吧。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101610648.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;档针&lt;/p&gt;&lt;p&gt;档针、很多钓友在看别人视频的时候，经常会看到这个东西。大家觉得它很好，卸鱼的时候比较方便。往鱼护边上一挂。其实这个东西根本没啥用，首先它对钓鱼人的钓技要求比较高，其次鱼情得跟得上，往往是看着好看，用起来很差劲，在野钓当中简直就是鸡肋！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101610259.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;绑钩器&lt;/p&gt;&lt;p&gt;虽然很多人都说自己绑钩，但手绑起来比较麻烦，干脆自己买个绑钩器好了。起初觉得这样很方便，以后解放了双手了。等自己买了以后，发现绑出来的不如手绑得好，不是这里有问题就是那里有问题。所幸，这个东西还是不用了。要么就是去渔具店买钩子让老板给绑，要么就是直接买成品的，自己都不够麻烦的！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101610141.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;子线盒&lt;/p&gt;&lt;p&gt;钓鱼需要用到不同规格的子线，为了方便存放鱼线，自然就会买上子线盒，觉得这样好打理！但实际当中，在野钓的时候，根本用不到什么细子线。起初想象的很好，但实际用处一点也不大，所以最后也是扔到一边去！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4101610I6.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;钓箱&lt;/p&gt;&lt;p&gt;钓箱可以当作椅子，还可以装很多的东西。所以，在很多钓鱼人眼中，觉得它很实用，所以也会花钱去购买。其实我想说，这个东西根本就不实用。钓鱼就是越简单越好，东西搞一大堆鱼还钓不到几条，然后每次钓鱼都得背着它。这是钓鱼呢，还是伺候它呢？野钓的时候，钓位不平整还得休整，用它都不够麻烦的！&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41016105W.jpg&quot; style=&quot;border: 0px; margin: 0px auto; padding: 0px; outline: 0px; display: block; vertical-align: middle;&quot;/&gt;&lt;/p&gt;&lt;p&gt;电子浮漂&lt;/p&gt;&lt;p&gt;电子变色漂&lt;/p&gt;&lt;p&gt;夜钓的时候光线比较差，所以为了省点事。都会选择一些可视度高的东西，就比如变色浮漂。这种浮漂号称，上鱼就变色。听起很高大上，但实际用起来效果很差劲！本人之前用过几次，用了之后一条鱼没钓到，同样的水域同样的钓法同样的饵料，但更换了浮漂之后，渔获不是一般的多！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599185772', '1599185772');
INSERT INTO `ey_article_content` VALUES ('12', '25', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41030214G.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z41030214G.jpg&quot;/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186659', '1599186659');
INSERT INTO `ey_article_content` VALUES ('13', '26', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4103139202.jpg&quot; title=&quot;案例展示二(图1)&quot; alt=&quot;案例展示二(图1)&quot;/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br style=&quot;white-space: normal;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186713', '1599186713');
INSERT INTO `ey_article_content` VALUES ('14', '27', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z410321MY.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z410321MY.jpg&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/p&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186740', '1599186740');
INSERT INTO `ey_article_content` VALUES ('15', '28', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z41032509B.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z41032509B.jpg&quot;/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186779', '1599186779');
INSERT INTO `ey_article_content` VALUES ('16', '29', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4103331936.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z4103331936.jpg&quot;/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186817', '1599186817');
INSERT INTO `ey_article_content` VALUES ('17', '30', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4103406127.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z4103406127.jpg&quot;/&gt;&lt;/p&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;一般可分为网渔具、钓渔具、其他渔具。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;按中国国家标准，可分为刺网、拖网、围网、地拉网、张网、敷网、抄网、掩罩、陷阱、钓具、耙刺、笼壶等12类。&lt;/div&gt;&lt;div label-module=&quot;para&quot; style=&quot;white-space: normal;&quot;&gt;有的还包括利用声、光、电、气泡幕等装置在捕捞过程中起辅助作用的工具。&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599186851', '1599186851');

-- -----------------------------
-- Table structure for `ey_article_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_order`;
CREATE TABLE `ey_article_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章订单表';


-- -----------------------------
-- Table structure for `ey_article_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_pay`;
CREATE TABLE `ey_article_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) DEFAULT '0',
  `part_free` tinyint(1) DEFAULT '0' COMMENT '是否试看 0-否 1-是',
  `size` float(10,2) DEFAULT '1.00' COMMENT 'KB',
  `free_content` longtext COMMENT '试看内容',
  `add_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章付费预览表';


-- -----------------------------
-- Table structure for `ey_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask`;
CREATE TABLE `ey_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(200) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '悬赏金额',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer`;
CREATE TABLE `ey_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-删除',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_answer_like`;
CREATE TABLE `ey_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `like_source` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '点赞来源，1=点赞提问(ask_id)，2=点赞评论(answer_id)，3=点赞回复(answer_id)，默认值为2，兼容以前的那些评论数据',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_ask_score_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_score_level`;
CREATE TABLE `ey_ask_score_level` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) DEFAULT '',
  `min` mediumint(8) DEFAULT '0',
  `max` mediumint(8) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='积分等级表';

-- -----------------------------
-- Records of `ey_ask_score_level`
-- -----------------------------
INSERT INTO `ey_ask_score_level` VALUES ('1', '青铜', '0', '1000');
INSERT INTO `ey_ask_score_level` VALUES ('2', '白银', '1001', '5000');
INSERT INTO `ey_ask_score_level` VALUES ('3', '黄金', '5001', '20000');
INSERT INTO `ey_ask_score_level` VALUES ('4', '王者', '20001', '0');

-- -----------------------------
-- Table structure for `ey_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ask_type`;
CREATE TABLE `ey_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_ask_type`
-- -----------------------------
INSERT INTO `ey_ask_type` VALUES ('1', '问题求助', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('2', '功能建议', '0', '', '', '', '100', '1565770890', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('3', 'BUG反馈', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('4', '其他问题', '1', '', '', '', '100', '1565771021', '1611910466');
INSERT INTO `ey_ask_type` VALUES ('5', '业务咨询', '0', '', '', '', '100', '1611910466', '1611910466');

-- -----------------------------
-- Table structure for `ey_auth_access`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_access`;
CREATE TABLE `ey_auth_access` (
  `role_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '角色ID',
  `rule_id` int(11) NOT NULL DEFAULT '0' COMMENT '权限ID',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `rule_id` (`rule_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限授权表';

-- -----------------------------
-- Records of `ey_auth_access`
-- -----------------------------
INSERT INTO `ey_auth_access` VALUES ('12', '176');
INSERT INTO `ey_auth_access` VALUES ('12', '177');
INSERT INTO `ey_auth_access` VALUES ('12', '178');
INSERT INTO `ey_auth_access` VALUES ('12', '179');
INSERT INTO `ey_auth_access` VALUES ('12', '180');
INSERT INTO `ey_auth_access` VALUES ('12', '181');
INSERT INTO `ey_auth_access` VALUES ('12', '182');
INSERT INTO `ey_auth_access` VALUES ('12', '183');
INSERT INTO `ey_auth_access` VALUES ('12', '184');
INSERT INTO `ey_auth_access` VALUES ('12', '185');
INSERT INTO `ey_auth_access` VALUES ('12', '186');
INSERT INTO `ey_auth_access` VALUES ('12', '187');
INSERT INTO `ey_auth_access` VALUES ('12', '188');
INSERT INTO `ey_auth_access` VALUES ('12', '189');
INSERT INTO `ey_auth_access` VALUES ('12', '190');
INSERT INTO `ey_auth_access` VALUES ('12', '191');
INSERT INTO `ey_auth_access` VALUES ('12', '192');
INSERT INTO `ey_auth_access` VALUES ('12', '193');
INSERT INTO `ey_auth_access` VALUES ('12', '194');
INSERT INTO `ey_auth_access` VALUES ('12', '195');
INSERT INTO `ey_auth_access` VALUES ('12', '196');
INSERT INTO `ey_auth_access` VALUES ('12', '197');
INSERT INTO `ey_auth_access` VALUES ('12', '198');
INSERT INTO `ey_auth_access` VALUES ('12', '81');
INSERT INTO `ey_auth_access` VALUES ('12', '62');
INSERT INTO `ey_auth_access` VALUES ('12', '61');
INSERT INTO `ey_auth_access` VALUES ('12', '8');
INSERT INTO `ey_auth_access` VALUES ('12', '70');
INSERT INTO `ey_auth_access` VALUES ('12', '71');
INSERT INTO `ey_auth_access` VALUES ('12', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '176');
INSERT INTO `ey_auth_access` VALUES ('11', '177');
INSERT INTO `ey_auth_access` VALUES ('11', '178');
INSERT INTO `ey_auth_access` VALUES ('11', '179');
INSERT INTO `ey_auth_access` VALUES ('11', '180');
INSERT INTO `ey_auth_access` VALUES ('11', '181');
INSERT INTO `ey_auth_access` VALUES ('11', '182');
INSERT INTO `ey_auth_access` VALUES ('11', '184');
INSERT INTO `ey_auth_access` VALUES ('11', '185');
INSERT INTO `ey_auth_access` VALUES ('11', '186');
INSERT INTO `ey_auth_access` VALUES ('11', '187');
INSERT INTO `ey_auth_access` VALUES ('11', '188');
INSERT INTO `ey_auth_access` VALUES ('11', '189');
INSERT INTO `ey_auth_access` VALUES ('11', '191');
INSERT INTO `ey_auth_access` VALUES ('11', '192');
INSERT INTO `ey_auth_access` VALUES ('11', '193');
INSERT INTO `ey_auth_access` VALUES ('11', '194');
INSERT INTO `ey_auth_access` VALUES ('11', '195');
INSERT INTO `ey_auth_access` VALUES ('11', '196');
INSERT INTO `ey_auth_access` VALUES ('11', '197');
INSERT INTO `ey_auth_access` VALUES ('11', '198');
INSERT INTO `ey_auth_access` VALUES ('11', '199');
INSERT INTO `ey_auth_access` VALUES ('11', '200');
INSERT INTO `ey_auth_access` VALUES ('11', '201');
INSERT INTO `ey_auth_access` VALUES ('11', '202');
INSERT INTO `ey_auth_access` VALUES ('11', '203');
INSERT INTO `ey_auth_access` VALUES ('11', '204');
INSERT INTO `ey_auth_access` VALUES ('11', '205');
INSERT INTO `ey_auth_access` VALUES ('11', '206');
INSERT INTO `ey_auth_access` VALUES ('11', '207');
INSERT INTO `ey_auth_access` VALUES ('11', '208');
INSERT INTO `ey_auth_access` VALUES ('11', '209');
INSERT INTO `ey_auth_access` VALUES ('11', '210');
INSERT INTO `ey_auth_access` VALUES ('11', '211');
INSERT INTO `ey_auth_access` VALUES ('11', '125');
INSERT INTO `ey_auth_access` VALUES ('11', '126');
INSERT INTO `ey_auth_access` VALUES ('11', '127');
INSERT INTO `ey_auth_access` VALUES ('11', '62');
INSERT INTO `ey_auth_access` VALUES ('11', '136');
INSERT INTO `ey_auth_access` VALUES ('11', '137');
INSERT INTO `ey_auth_access` VALUES ('11', '138');
INSERT INTO `ey_auth_access` VALUES ('11', '139');
INSERT INTO `ey_auth_access` VALUES ('11', '140');
INSERT INTO `ey_auth_access` VALUES ('11', '141');
INSERT INTO `ey_auth_access` VALUES ('11', '142');
INSERT INTO `ey_auth_access` VALUES ('11', '143');
INSERT INTO `ey_auth_access` VALUES ('11', '61');
INSERT INTO `ey_auth_access` VALUES ('11', '212');
INSERT INTO `ey_auth_access` VALUES ('11', '8');
INSERT INTO `ey_auth_access` VALUES ('11', '70');
INSERT INTO `ey_auth_access` VALUES ('11', '71');
INSERT INTO `ey_auth_access` VALUES ('11', '72');
INSERT INTO `ey_auth_access` VALUES ('11', '9');
INSERT INTO `ey_auth_access` VALUES ('11', '77');
INSERT INTO `ey_auth_access` VALUES ('11', '78');
INSERT INTO `ey_auth_access` VALUES ('11', '79');
INSERT INTO `ey_auth_access` VALUES ('11', '148');
INSERT INTO `ey_auth_access` VALUES ('11', '149');
INSERT INTO `ey_auth_access` VALUES ('11', '150');
INSERT INTO `ey_auth_access` VALUES ('11', '151');
INSERT INTO `ey_auth_access` VALUES ('11', '144');
INSERT INTO `ey_auth_access` VALUES ('11', '145');
INSERT INTO `ey_auth_access` VALUES ('11', '146');
INSERT INTO `ey_auth_access` VALUES ('11', '147');
INSERT INTO `ey_auth_access` VALUES ('11', '155');
INSERT INTO `ey_auth_access` VALUES ('11', '156');
INSERT INTO `ey_auth_access` VALUES ('11', '157');
INSERT INTO `ey_auth_access` VALUES ('11', '158');
INSERT INTO `ey_auth_access` VALUES ('11', '159');

-- -----------------------------
-- Table structure for `ey_auth_modular`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_modular`;
CREATE TABLE `ey_auth_modular` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0' COMMENT '父级ID',
  `name` varchar(50) DEFAULT '' COMMENT '名称',
  `controller` varchar(50) DEFAULT '' COMMENT '控制器',
  `action` varchar(50) DEFAULT '' COMMENT '操作名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '级别',
  `url` varchar(200) DEFAULT '' COMMENT '链接',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '显示菜单(1=是，0=否)',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=515 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_auth_modular`
-- -----------------------------
INSERT INTO `ey_auth_modular` VALUES ('513', '481', 'SEO优化', 'Seo', 'index', '2', '', '100', '1', '1', '1524208193', '0');
INSERT INTO `ey_auth_modular` VALUES ('9', '514', '高级选项', '', '', '1', '', '0', '1', '1', '1503301507', '1527306955');
INSERT INTO `ey_auth_modular` VALUES ('12', '514', '基本信息', 'System', 'index', '1', '', '1', '1', '1', '0', '1527306913');
INSERT INTO `ey_auth_modular` VALUES ('13', '9', '修改密码', 'Admin', 'admin_pwd', '2', '', '3', '1', '1', '1503301723', '0');
INSERT INTO `ey_auth_modular` VALUES ('14', '9', '管理员列表', 'Admin', 'index', '2', '', '0', '1', '1', '1503301765', '1527306984');
INSERT INTO `ey_auth_modular` VALUES ('15', '9', '角色列表', 'Admin', 'role', '2', '', '0', '1', '1', '1503301781', '1527307009');
INSERT INTO `ey_auth_modular` VALUES ('16', '9', '模块列表', 'Admin', 'modular', '2', '', '0', '1', '1', '1503301793', '1527307006');
INSERT INTO `ey_auth_modular` VALUES ('17', '9', '权限列表', 'Admin', 'rule', '2', '', '0', '1', '1', '1503301805', '1527307004');
INSERT INTO `ey_auth_modular` VALUES ('18', '9', '日志列表', 'Admin', 'log', '2', '', '0', '1', '1', '1503301840', '1527306999');
INSERT INTO `ey_auth_modular` VALUES ('19', '9', '数据备份', 'Tools', 'index', '2', '', '0', '1', '1', '1503301857', '1527307033');
INSERT INTO `ey_auth_modular` VALUES ('21', '9', '数据还原', 'Tools', 'restore', '2', '', '0', '1', '1', '1503302091', '1527307044');
INSERT INTO `ey_auth_modular` VALUES ('22', '9', '地区列表', 'System', 'region', '2', '', '2', '0', '1', '1505441023', '0');
INSERT INTO `ey_auth_modular` VALUES ('23', '0', '常规', '', '', '0', '', '0', '1', '1', '1503308630', '1503367345');
INSERT INTO `ey_auth_modular` VALUES ('27', '514', '调试外观', '', '', '1', '', '1', '1', '1', '0', '1527306927');
INSERT INTO `ey_auth_modular` VALUES ('28', '27', '电脑版', 'Uiset', 'pc', '2', '/index.php/home/Index/index.html?ui_set=on', '0', '1', '1', '1503368313', '1523432343');
INSERT INTO `ey_auth_modular` VALUES ('30', '27', '手机版', 'Uiset', 'mobile', '2', '', '0', '1', '1', '1503368589', '1509093563');
INSERT INTO `ey_auth_modular` VALUES ('35', '9', '清除缓存', 'System', 'clearCache', '2', '', '20', '1', '1', '1503655673', '0');
INSERT INTO `ey_auth_modular` VALUES ('41', '23', '设置栏目', 'Arctype', 'index', '1', '', '0', '1', '1', '1503999661', '1527307162');
INSERT INTO `ey_auth_modular` VALUES ('62', '9', '邮件模板', 'EmailTemplate', 'index', '2', '', '5', '1', '1', '1505204834', '1509090070');
INSERT INTO `ey_auth_modular` VALUES ('64', '9', '短信模板', 'SmsTemplate', 'index', '2', '', '4', '1', '1', '1505204889', '1509086592');
INSERT INTO `ey_auth_modular` VALUES ('470', '23', '发布文档', 'Channeltype', 'index', '1', '', '0', '1', '1', '1505726990', '1527307178');
INSERT INTO `ey_auth_modular` VALUES ('480', '481', '友情链接', 'Links', 'index', '2', '', '7', '1', '1', '1505803829', '1522996913');
INSERT INTO `ey_auth_modular` VALUES ('481', '514', '营销设置', '', '', '1', '', '0', '1', '1', '1505873468', '1527306945');
INSERT INTO `ey_auth_modular` VALUES ('482', '481', '广告列表', 'Ad', 'index', '2', '', '0', '1', '1', '1505873498', '0');
INSERT INTO `ey_auth_modular` VALUES ('483', '481', '广告位置', 'AdPosition', 'index', '2', '', '0', '1', '1', '1505873675', '0');
INSERT INTO `ey_auth_modular` VALUES ('514', '0', '设置', '', '', '0', '', '100', '1', '1', '1527306892', '0');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `check_oneself` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '发布文档自动通过审核，1--是，0--否',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` longtext COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', '', '0', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:55:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:1:\"2\";i:29;s:1:\"3\";i:30;s:1:\"4\";i:31;s:1:\"5\";i:32;s:1:\"6\";i:33;s:1:\"7\";i:34;s:1:\"8\";i:35;s:1:\"9\";i:36;s:2:\"10\";i:37;s:2:\"11\";i:38;s:2:\"12\";i:39;s:2:\"13\";i:40;s:2:\"14\";i:41;s:2:\"15\";i:42;s:2:\"16\";i:43;s:2:\"17\";i:44;s:2:\"18\";i:45;s:2:\"19\";i:46;s:2:\"20\";i:47;s:2:\"21\";i:48;s:2:\"22\";i:49;s:2:\"23\";i:50;s:2:\"24\";i:51;s:2:\"25\";i:52;s:2:\"26\";i:53;s:2:\"27\";i:54;s:2:\"28\";}}', '1', '100', '1', '0', '1541058693', '1541058693');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', '', '0', '1', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:55:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:1:\"8\";i:10;s:2:\"32\";i:11;s:1:\"9\";i:12;s:2:\"30\";i:13;s:2:\"31\";i:14;s:2:\"11\";i:15;s:2:\"12\";i:16;s:2:\"13\";i:17;s:2:\"23\";i:18;s:2:\"20\";i:19;s:2:\"24\";i:20;s:2:\"25\";i:21;s:2:\"21\";i:22;s:2:\"26\";i:23;s:2:\"22\";i:24;s:2:\"27\";i:25;s:2:\"28\";i:26;s:2:\"29\";i:27;s:1:\"1\";i:28;s:1:\"2\";i:29;s:1:\"3\";i:30;s:1:\"4\";i:31;s:1:\"5\";i:32;s:1:\"6\";i:33;s:1:\"7\";i:34;s:1:\"8\";i:35;s:1:\"9\";i:36;s:2:\"10\";i:37;s:2:\"11\";i:38;s:2:\"12\";i:39;s:2:\"13\";i:40;s:2:\"14\";i:41;s:2:\"15\";i:42;s:2:\"16\";i:43;s:2:\"17\";i:44;s:2:\"18\";i:45;s:2:\"19\";i:46;s:2:\"20\";i:47;s:2:\"21\";i:48;s:2:\"22\";i:49;s:2:\"23\";i:50;s:2:\"24\";i:51;s:2:\"25\";i:52;s:2:\"26\";i:53;s:2:\"27\";i:54;s:2:\"28\";}}', '1', '100', '1', '0', '1541059290', '1541059290');

-- -----------------------------
-- Table structure for `ey_auth_role_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role_admin`;
CREATE TABLE `ey_auth_role_admin` (
  `role_id` int(11) DEFAULT '0' COMMENT '角色 id',
  `admin_id` int(11) DEFAULT '0' COMMENT '用户id',
  KEY `role_id` (`role_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户角色对应表';

-- -----------------------------
-- Records of `ey_auth_role_admin`
-- -----------------------------
INSERT INTO `ey_auth_role_admin` VALUES ('-1', '1');
INSERT INTO `ey_auth_role_admin` VALUES ('11', '22');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '17');
INSERT INTO `ey_auth_role_admin` VALUES ('12', '16');

-- -----------------------------
-- Table structure for `ey_auth_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_rule`;
CREATE TABLE `ey_auth_rule` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `modular_id` int(11) DEFAULT '0' COMMENT '所属模块',
  `name` varchar(50) DEFAULT '' COMMENT '权限名字',
  `right` text COMMENT '权限码(控制器+操作)',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除状态 1删除,0正常',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `is_menu` tinyint(1) DEFAULT '1' COMMENT '是否为菜单(1=是，0=否)',
  `group` varchar(20) DEFAULT '' COMMENT '应用名称app',
  `status` tinyint(1) DEFAULT '1' COMMENT '显示(1=正常，0=屏蔽)',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=213 DEFAULT CHARSET=utf8 COMMENT='后台权限菜单表';

-- -----------------------------
-- Records of `ey_auth_rule`
-- -----------------------------
INSERT INTO `ey_auth_rule` VALUES ('6', '17', '权限列表', 'Admin@rule', '', '0', '0', '1503390907', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('8', '14', '管理员列表', 'Admin@index', '', '0', '0', '1503392270', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('9', '15', '角色列表', 'Admin@role', '', '0', '0', '1503392666', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('38', '19', '数据备份列表', 'Tools@index', '', '0', '0', '1504515434', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('39', '21', '数据还原列表', 'Tools@restore', '', '0', '0', '1504515452', '0', '1', 'tools', '1');
INSERT INTO `ey_auth_rule` VALUES ('49', '18', '管理员日志', 'Admin@log', '', '0', '0', '1504485820', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('61', '35', '清除页面缓存', 'System@clearCache,System@clearHtmlCache', '', '0', '0', '1519357846', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('62', '13', '修改管理员密码', 'Admin@admin_pwd', '', '0', '0', '1504485678', '0', '1', 'system', '1');
INSERT INTO `ey_auth_rule` VALUES ('65', '17', '新增权限', 'Admin@rule_add', '', '0', '1503390930', '1503391981', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('66', '17', '编辑权限', 'Admin@rule_edit,Index@changeTableVal', '', '0', '1503390947', '1503392474', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('67', '17', '删除权限', 'Admin@rule_del', '', '0', '1503390965', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('70', '14', '新增管理员', 'Admin@admin_add', '', '0', '1503392290', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('71', '14', '编辑管理员', 'Admin@admin_edit,Index@changeTableVal', '', '0', '1503392302', '1517986419', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('72', '14', '删除管理员', 'Admin@admin_del', '', '0', '1503392315', '1504578385', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('73', '16', '模块列表', 'Admin@modular', '', '0', '1503392570', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('74', '16', '新增模块', 'Admin@modular_add', '', '0', '1503392591', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('75', '16', '编辑模块', 'Admin@modular_edit,Index@changeTableVal', '', '0', '1503392610', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('76', '16', '删除模块', 'Admin@modular_del', '', '0', '1503392626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('77', '15', '新增角色', 'Admin@role_add', '', '0', '1503392691', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('78', '15', '编辑角色', 'Admin@role_edit,Index@changeTableVal', '', '0', '1503392718', '1517986448', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('79', '15', '删除角色', 'Admin@role_del', '', '0', '1503392736', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('81', '12', '平台设置', 'System@index,System@handle', '', '0', '1504486050', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('117', '19', '备份数据', 'Tools@export', '', '0', '1504514716', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('118', '19', '优化数据', 'Tools@optimize', '', '0', '1504514788', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('119', '19', '修复数据', 'Tools@repair', '', '0', '1504514809', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('120', '21', '导入sql文件', 'Tools@restoreUpload', '', '0', '1504515139', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('121', '21', '恢复数据 ', 'Tools@import', '', '0', '1504515184', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('122', '21', '下载数据', 'Tools@downFile', '', '0', '1504515311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('123', '21', '删除数据', 'Tools@del', '', '0', '1504515399', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('128', '64', '短信模板列表', 'SmsTemplate@index', '', '0', '1517987270', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('129', '64', '新增短信模板', 'SmsTemplate@add', '', '0', '1517987289', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('130', '64', '编辑短信模板', 'SmsTemplate@edit,Index@changeTableVal', '', '0', '1517987336', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('131', '64', '删除短信模板', 'SmsTemplate@del', '', '0', '1517987359', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('132', '62', '邮件模板列表', 'EmailTemplate@index', '', '0', '1517987387', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('133', '62', '新增邮件模板', 'EmailTemplate@add', '', '0', '1517994951', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('134', '62', '编辑邮件模板', 'EmailTemplate@edit,Index@changeTableVal', '', '0', '1517994976', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('135', '62', '删除邮件模板', 'EmailTemplate@del', '', '0', '1517995005', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('140', '480', '友情链接列表', 'Links@index', '', '0', '1517995297', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('141', '480', '新增友情链接', 'Links@add', '', '0', '1517995311', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('142', '480', '编辑友情链接', 'Links@edit,Index@changeTableVal', '', '0', '1517995329', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('143', '480', '删除友情链接', 'Links@del', '', '0', '1517995344', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('144', '483', '广告位列表', 'AdPosition@index', '', '0', '1517995508', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('145', '483', '新增广告位', 'AdPosition@add', '', '0', '1517995525', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('146', '483', '编辑广告位', 'AdPosition@edit,Index@changeTableVal', '', '0', '1517995544', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('147', '483', '删除广告位', 'AdPosition@del', '', '0', '1517995556', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('148', '482', '广告列表', 'Ad@index', '', '0', '1517995581', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('149', '482', '新增广告', 'Ad@add', '', '0', '1517995595', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('150', '482', '编辑广告', 'Ad@edit,Index@changeTableVal', '', '0', '1517995612', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('151', '482', '删除广告', 'Ad@del', '', '0', '1517995626', '0', '0', '1', '', '1');
INSERT INTO `ey_auth_rule` VALUES ('212', '35', '清除数据缓存', 'System@clearCache,System@clearSystemCache,System@fastClearCache', '', '0', '1519357889', '0', '0', '1', '', '1');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` text NOT NULL COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_screening` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `is_release` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否应用于会员投稿发布',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `ifcontrol` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态，控制该条数据是否允许被控制，1为不允许控制，0为允许控制',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=239 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091575', '1533091575');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091601', '1533091601');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091624', '1533091624');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092214', '1533092214');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092246', '1533092246');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092381', '1533092381');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092398', '1533092398');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092439', '1533092439');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092454', '1533092454');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092468', '1533092468');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092484', '1533092484');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '作者', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092498', '1533092498');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092512', '1533092512');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092534', '1533092534');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092553', '1533092553');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092698', '1533092698');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092713', '1533092713');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092725', '1533092725');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092739', '1533092739');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092753', '1533092753');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092766', '1533092766');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359739', '1533359739');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1533464713');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('52', 'del_method', '-99', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('53', 'is_del', '0', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('54', 'del_method', '0', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('55', 'admin_id', '0', '管理员ID', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('56', 'lang', '0', '语言标识', 'text', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('57', 'prom_type', '0', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('58', 'users_price', '0', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '0', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('59', 'prom_type', '2', '产品类型：0普通产品，1虚拟产品', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('60', 'users_price', '2', '价格', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '0', '0', '1', '1', '0', '100', '1', '1557042574', '1599184114');
INSERT INTO `ey_channelfield` VALUES ('61', 'users_id', '0', '会员ID', 'int', 'int(11)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('62', 'arc_level_id', '0', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('63', 'arc_level_id', '4', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('64', 'weapp_code', '-99', '插件栏目唯一标识', 'text', 'varchar(200)', '200', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('65', 'is_release', '-99', '栏目是否应用于会员投稿发布，1是，0否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('66', 'old_price', '0', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('67', 'stock_count', '0', '商品库存量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('68', 'stock_show', '0', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('69', 'joinaid', '0', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('70', 'downcount', '0', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('71', 'downcount', '4', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('72', 'htmlfilename', '0', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('73', 'htmlfilename', '1', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('74', 'htmlfilename', '2', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('75', 'htmlfilename', '3', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('76', 'htmlfilename', '4', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('77', 'htmlfilename', '6', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1557042574');
INSERT INTO `ey_channelfield` VALUES ('78', 'attrlist_id', '0', '参数列表ID', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('79', 'sales_num', '0', '销售量', 'int', 'int(10) unsigned', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('80', 'update_time', '2', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('81', 'add_time', '2', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('82', 'downcount', '2', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('83', 'joinaid', '2', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('84', 'del_method', '2', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('85', 'is_del', '2', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('86', 'arc_level_id', '2', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('87', 'users_id', '2', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('88', 'admin_id', '2', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('89', 'lang', '2', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('90', 'sort_order', '2', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('91', 'status', '2', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('92', 'tempview', '2', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('93', 'stock_show', '2', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('94', 'stock_count', '2', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('95', 'sales_num', '2', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('96', 'old_price', '2', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('97', 'users_free', '2', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('98', 'attrlist_id', '2', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('99', 'seo_description', '2', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('100', 'seo_keywords', '2', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('101', 'seo_title', '2', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('102', 'ismake', '2', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('103', 'jumplinks', '2', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('104', 'arcrank', '2', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('105', 'click', '2', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('106', 'author', '2', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('107', 'is_litpic', '2', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('108', 'is_jump', '2', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('109', 'is_recom', '2', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('110', 'is_top', '2', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('111', 'is_special', '2', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('112', 'is_head', '2', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('113', 'litpic', '2', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('114', 'title', '2', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('115', 'is_b', '2', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('116', 'channel', '2', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('117', 'typeid', '2', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('118', 'aid', '2', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1599184112', '1599184112');
INSERT INTO `ey_channelfield` VALUES ('120', 'topid', '-99', '顶级栏目ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1557042574', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('121', 'is_slide', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('122', 'is_roll', '0', '是否幻灯', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('123', 'is_diyattr', '0', '是否自定义', 'switch', 'tinyint(1)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('124', 'update_time', '7', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('125', 'add_time', '7', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('126', 'htmlfilename', '7', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('127', 'downcount', '7', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('128', 'joinaid', '7', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('129', 'del_method', '7', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('130', 'is_del', '7', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('131', 'arc_level_id', '7', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('132', 'users_id', '7', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('133', 'admin_id', '7', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('134', 'lang', '7', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('135', 'sort_order', '7', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('136', 'status', '7', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('137', 'tempview', '7', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('138', 'prom_type', '7', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('139', 'stock_show', '7', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('140', 'stock_count', '7', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('141', 'sales_num', '7', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('142', 'old_price', '7', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('143', 'users_free', '7', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('144', 'users_price', '7', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('145', 'attrlist_id', '7', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('146', 'seo_description', '7', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('147', 'seo_keywords', '7', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('148', 'seo_title', '7', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('149', 'ismake', '7', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('150', 'jumplinks', '7', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('151', 'arcrank', '7', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('152', 'click', '7', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('153', 'author', '7', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('154', 'is_diyattr', '7', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('155', 'is_slide', '7', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('156', 'is_roll', '7', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('157', 'is_litpic', '7', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('158', 'is_jump', '7', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('159', 'is_recom', '7', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('160', 'is_top', '7', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('161', 'is_special', '7', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('162', 'is_head', '7', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('163', 'litpic', '7', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('164', 'title', '7', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('165', 'is_b', '7', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('166', 'channel', '7', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('167', 'typeid', '7', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('168', 'aid', '7', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('169', 'content', '7', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1614656192', '1614656192');
INSERT INTO `ey_channelfield` VALUES ('170', 'update_time', '5', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('171', 'add_time', '5', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('172', 'htmlfilename', '5', '自定义文件名', 'text', 'varchar(50)', '50', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('173', 'downcount', '5', '下载次数', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('174', 'joinaid', '5', '关联文档ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('175', 'del_method', '5', '伪删除状态，1为主动删除，2为跟随上级栏目被动删除', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('176', 'is_del', '5', '伪删除，1=是，0=否', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('177', 'arc_level_id', '5', '文档会员权限ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('178', 'users_id', '5', '会员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('179', 'admin_id', '5', '管理员ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('180', 'lang', '5', '语言标识', 'text', 'varchar(50)', '50', 'cn', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('181', 'sort_order', '5', '排序号', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('182', 'status', '5', '状态(0=屏蔽，1=正常)', 'switch', 'tinyint(1)', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('183', 'tempview', '5', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('184', 'prom_type', '5', '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('185', 'stock_show', '5', '商品库存在产品详情页是否显示，1为显示，0为不显示', 'switch', 'tinyint(1) unsigned', '1', '1', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('186', 'stock_count', '5', '商品库存量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('187', 'sales_num', '5', '销售量', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('188', 'old_price', '5', '产品旧价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('189', 'users_free', '5', '是否会员免费，默认0不免费，1为免费', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('190', 'users_price', '5', '会员价', 'decimal', 'decimal(10,2)', '10', '0.00', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('191', 'attrlist_id', '5', '参数列表ID', 'int', 'int(10) unsigned', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('192', 'seo_description', '5', 'SEO描述', 'multitext', 'text', '0', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('193', 'seo_keywords', '5', 'SEO关键词', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('194', 'seo_title', '5', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('195', 'ismake', '5', '是否静态页面（0=动态，1=静态）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('196', 'jumplinks', '5', '外链跳转', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('197', 'arcrank', '5', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('198', 'click', '5', '浏览量', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('199', 'author', '5', '作者', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('200', 'is_diyattr', '5', '自定义（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('201', 'is_slide', '5', '幻灯（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('202', 'is_roll', '5', '滚动（0=否，1=是）', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('203', 'is_litpic', '5', '图片（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('204', 'is_jump', '5', '跳转链接（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('205', 'is_recom', '5', '推荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('206', 'is_top', '5', '置顶（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('207', 'is_special', '5', '特荐（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('208', 'is_head', '5', '头条（0=否，1=是）', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('209', 'litpic', '5', '缩略图', 'img', 'varchar(250)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('210', 'title', '5', '标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('211', 'is_b', '5', '加粗', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('212', 'channel', '5', '模型ID', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('213', 'typeid', '5', '当前栏目', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('214', 'aid', '5', 'aid', 'int', 'int(10)', '10', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('215', 'content', '5', '内容详情', 'htmltext', 'longtext', '0', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('216', 'courseware', '5', '课件地址', 'text', 'varchar(200)', '200', '', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('217', 'courseware_free', '5', '课件收费', 'select', 'enum(\'免费\',\'收费\')', '0', '免费,收费', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('218', 'total_duration', '5', '视频总时长', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('219', 'total_video', '5', '视频数', 'int', 'int(10)', '10', '0', '', '', '0', '1', '0', '0', '1', '0', '1', '100', '1', '1638408526', '1638408526');
INSERT INTO `ey_channelfield` VALUES ('220', 'appraise', '0', '评价数', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('221', 'collection', '0', '收藏数', 'int', 'int(10)', '250', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('222', 'restric_type', '0', '限制模式，0=免费，1=付费，2=会员专享，3=会员付费', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1616293251', '1616293251');
INSERT INTO `ey_channelfield` VALUES ('223', 'diy_dirpath', '-99', '自定义HTML保存路径', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('224', 'rulelist', '-99', '列表静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('225', 'ruleview', '-99', '文档静态文件存放规则', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('226', 'subtitle', '0', '副标题', 'text', 'varchar(200)', '200', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535');
INSERT INTO `ey_channelfield` VALUES ('227', 'origin', '0', '来源', 'text', 'varchar(30)', '30', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535');
INSERT INTO `ey_channelfield` VALUES ('228', 'stypeid', '0', '副栏目', 'text', 'varchar(90)', '90', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1636338535', '1636338535');
INSERT INTO `ey_channelfield` VALUES ('229', 'target', '-99', '新窗口打开', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('230', 'nofollow', '-99', '防抓取', 'switch', 'tinyint(1)', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');
INSERT INTO `ey_channelfield` VALUES ('231', 'content_ey_m', '1', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464713', '1623047123');
INSERT INTO `ey_channelfield` VALUES ('232', 'content_ey_m', '2', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1645086030', '1645086039');
INSERT INTO `ey_channelfield` VALUES ('233', 'content_ey_m', '3', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359588', '1533359588');
INSERT INTO `ey_channelfield` VALUES ('234', 'content_ey_m', '4', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533359752', '1533359752');
INSERT INTO `ey_channelfield` VALUES ('235', 'content_ey_m', '5', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1591957363', '1591957363');
INSERT INTO `ey_channelfield` VALUES ('236', 'content_ey_m', '6', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1533464715', '1533464715');
INSERT INTO `ey_channelfield` VALUES ('237', 'content_ey_m', '7', '手机端内容详情', 'htmltext', 'longtext', '250', '', '', '', '0', '1', '1', '0', '1', '0', '0', '100', '1', '1602320145', '1602320145');
INSERT INTO `ey_channelfield` VALUES ('238', 'typearcrank', '-99', '阅读权限：0=开放浏览，-1=待审核稿件', 'int', 'int(10)', '10', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1547890773', '1547890773');

-- -----------------------------
-- Table structure for `ey_channelfield_bind`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_bind`;
CREATE TABLE `ey_channelfield_bind` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `field_id` int(10) DEFAULT '0' COMMENT '自定义字段ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='栏目与自定义字段绑定表';

-- -----------------------------
-- Records of `ey_channelfield_bind`
-- -----------------------------
INSERT INTO `ey_channelfield_bind` VALUES ('1', '0', '24', '1599184112', '1599184112');
INSERT INTO `ey_channelfield_bind` VALUES ('2', '0', '25', '1599184112', '1599184112');
INSERT INTO `ey_channelfield_bind` VALUES ('3', '0', '26', '1599184112', '1599184112');
INSERT INTO `ey_channelfield_bind` VALUES ('4', '0', '27', '1599184112', '1599184112');
INSERT INTO `ey_channelfield_bind` VALUES ('5', '0', '29', '1599184112', '1599184112');
INSERT INTO `ey_channelfield_bind` VALUES ('6', '0', '169', '1614656192', '1614656192');
INSERT INTO `ey_channelfield_bind` VALUES ('7', '0', '215', '1638408526', '1638408526');
INSERT INTO `ey_channelfield_bind` VALUES ('8', '0', '216', '1638408526', '1638408526');
INSERT INTO `ey_channelfield_bind` VALUES ('9', '0', '217', '1638408526', '1638408526');
INSERT INTO `ey_channelfield_bind` VALUES ('10', '0', '218', '1638408526', '1638408526');
INSERT INTO `ey_channelfield_bind` VALUES ('11', '0', '219', '1638408526', '1638408526');

-- -----------------------------
-- Table structure for `ey_channelfield_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield_log`;
CREATE TABLE `ey_channelfield_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) DEFAULT '0' COMMENT '模型ID',
  `dtype` varchar(32) DEFAULT '' COMMENT '字段类型',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='自定义字段日志表';


-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `ifsystem` tinyint(1) DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `is_repeat_title` tinyint(1) DEFAULT '1' COMMENT '文档标题重复，1=允许，0=不允许',
  `is_release` tinyint(1) DEFAULT '0' COMMENT '模型是否允许应用于会员投稿发布，1是，0否',
  `is_litpic_users_release` tinyint(1) DEFAULT '1' COMMENT '缩略图是否应用于会员投稿，1=允许，0=不允许',
  `data` text COMMENT '额外序列化存储数据',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8 COMMENT='系统模型表';

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '1', '1', '1', '', '0', '1', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '1', '1', '1', '1', '1', '', '0', '4', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '1', '1', '1', '1', '1', '', '0', '2', '0', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '1', '1', '1', '1', '', '0', '8', '1509197711', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '1', '1', '1', '1', '', '0', '6', '1523091961', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '1', '1', '1', '1', '1', '', '0', '3', '1523929121', '1531800410');
INSERT INTO `ey_channeltype` VALUES ('5', 'media', '视频模型', '视频', 'media', 'Media', '0', '1', '1', '1', '1', '', '0', '5', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('7', 'special', '专题模型', '专题', 'special', 'Special', '0', '1', '1', '1', '1', '', '0', '7', '1509197711', '1564532747');
INSERT INTO `ey_channeltype` VALUES ('51', 'ask', '问答模型', '问答', 'ask', 'Ask', '0', '1', '1', '1', '1', '', '1', '9', '1509197711', '1668570338');

-- -----------------------------
-- Table structure for `ey_citysite`
-- -----------------------------
DROP TABLE IF EXISTS `ey_citysite`;
CREATE TABLE `ey_citysite` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '二级域名',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '二级域名开启状态，0=否，1=是',
  `seoset` tinyint(1) DEFAULT '0' COMMENT 'SEO设置，0=使用主站，1=自定义',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`) USING BTREE,
  KEY `level` (`level`,`status`) USING BTREE,
  KEY `initial` (`initial`,`sort_order`,`id`) USING BTREE,
  KEY `parent_id` (`parent_id`,`status`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='城市分站表';


-- -----------------------------
-- Table structure for `ey_common_pic`
-- -----------------------------
DROP TABLE IF EXISTS `ey_common_pic`;
CREATE TABLE `ey_common_pic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '常用图片ID',
  `pic_path` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='常用图片';

-- -----------------------------
-- Records of `ey_common_pic`
-- -----------------------------
INSERT INTO `ey_common_pic` VALUES ('5', '/uploads/allimg/20200904/1-200Z4102533534.jpg', 'cn', '1599189648', '1599189648');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=177 DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('1', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('2', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('3', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('4', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('5', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('6', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('7', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('8', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('9', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('10', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('11', 'file_size', '100', 'basic', '', 'cn', '0', '1614656166');
INSERT INTO `ey_config` VALUES ('12', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('13', 'file_type', 'zip|gz|rar|doc|docx|xls|ppt|wps|pdf|txt', 'basic', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('14', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('15', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'smtp_port', '465', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('21', 'smtp_user', 'xxxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('22', 'smtp_pwd', 'xxxxxxxxxxx', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('23', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('24', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('25', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('26', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('27', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'web_name', '某某公司', 'web', '', 'cn', '0', '1599208222');
INSERT INTO `ey_config` VALUES ('29', 'web_logo', '/uploads/allimg/20200903/1-200Z31AI9204.png', 'web', '', 'cn', '0', '1599123461');
INSERT INTO `ey_config` VALUES ('30', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('31', 'web_basehost', 'http://127.0.0.16', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('32', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('79', 'web_recordnum', '琼ICP备xxxxxxxx号', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('33', 'web_copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'web', '', 'cn', '0', '1599208222');
INSERT INTO `ey_config` VALUES ('34', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('35', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('39', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('40', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('41', 'list_symbol', '&gt;', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('42', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('43', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('44', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('45', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('46', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('47', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('48', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('55', 'web_title', '渔具批发钓具装备网站模板', 'web', '', 'cn', '0', '1599208222');
INSERT INTO `ey_config` VALUES ('56', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('57', 'web_authortoken', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('64', 'web_sqldatapath', '/data/sqldata_C7iJHejlegbiFcpwJuCp', 'web', '', 'cn', '0', '1668570339');
INSERT INTO `ey_config` VALUES ('65', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('66', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('67', 'web_templeturl', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('68', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('69', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('70', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('78', '_cmscopyright', 'jdFbzvsEHAAzE6PfTTropP7s', 'php', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('76', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('77', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('80', 'web_is_authortoken', '-1', 'web', '', 'cn', '0', '1668570366');
INSERT INTO `ey_config` VALUES ('81', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('82', 'seo_rewrite_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('83', 'web_cmsmode', '2', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('84', 'web_htmlcache_expires_in', '0', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('85', 'web_show_popup_upgrade', '1', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('86', 'web_weapp_switch', '-1', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('88', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('89', 'system_sql_mode', 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '1650869756');
INSERT INTO `ey_config` VALUES ('90', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('91', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('92', 'web_attr_1', '您好，欢迎访问这里是您的网站名称官网！', 'web', '', 'cn', '0', '1599123108');
INSERT INTO `ey_config` VALUES ('93', 'web_attr_2', '400-123-4567', 'web', '', 'cn', '0', '1599123443');
INSERT INTO `ey_config` VALUES ('94', 'web_attr_3', '1234567890', 'web', '', 'cn', '0', '1599125034');
INSERT INTO `ey_config` VALUES ('95', 'web_attr_4', '/uploads/allimg/20200903/1-200Z31PJ9520.jpg', 'web', '', 'cn', '0', '1599127671');
INSERT INTO `ey_config` VALUES ('96', 'web_attr_5', 'admin@youweb.com', 'web', '', 'cn', '0', '1599127715');
INSERT INTO `ey_config` VALUES ('97', 'web_attr_6', '13800000000', 'web', '', 'cn', '0', '1599127715');
INSERT INTO `ey_config` VALUES ('98', 'web_attr_7', '广东省广州市天河区88号', 'web', '', 'cn', '0', '1599127886');
INSERT INTO `ey_config` VALUES ('99', 'php_eyou_blacklist', '', 'php', '', 'cn', '0', '1599180455');
INSERT INTO `ey_config` VALUES ('100', 'php_weapp_plugin_open', '1', 'php', '', 'cn', '0', '1668570366');
INSERT INTO `ey_config` VALUES ('101', 'system_auth_code', '$2y$11$e6882953e0ecef859812480', 'system', '', 'cn', '0', '1599182042');
INSERT INTO `ey_config` VALUES ('102', 'system_smtp_tpl_5', '1', 'system', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('103', 'syn_gb_attribute_showlist', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('104', 'syn_admin_logic_sms_template', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('105', 'syn_admin_logic_unlink', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('106', 'syn_admin_logic_update_basic', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('107', 'syn_admin_logic_update_tag', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('108', 'syn_admin_logic_update_arctype', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('109', 'syn_admin_logic_video_addfields', '5', 'syn', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('110', 'syn_admin_logic_add_tag', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('111', 'syn_admin_logic_users_parameter', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('112', 'syn_admin_logic_users_download', '1', 'syn', '', 'cn', '0', '1599182043');
INSERT INTO `ey_config` VALUES ('113', 'smtp_syn_weapp', '1', 'smtp', '', 'cn', '0', '1599182045');
INSERT INTO `ey_config` VALUES ('114', 'web_attr_8', '/uploads/allimg/20200904/1-200Z4144405T6.png', 'web', '', 'cn', '0', '1599201861');
INSERT INTO `ey_config` VALUES ('115', 'web_attr_9', 'weixin888', 'web', '', 'cn', '0', '1599204574');
INSERT INTO `ey_config` VALUES ('116', 'system_upgrade_filelist', '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', 'system', '', 'cn', '0', '1668570339');
INSERT INTO `ey_config` VALUES ('140', 'php_servicemeal', '0', 'php', '', 'cn', '0', '1668570324');
INSERT INTO `ey_config` VALUES ('141', 'web_adminlogo', '', 'web', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('142', 'web_loginlogo', '', 'web', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('143', 'syn_admin_logic_1608884981', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('144', 'syn_admin_logic_arctype_topid', '2', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('145', 'syn_admin_logic_balance_pay', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('146', 'syn_admin_logic_1614829120', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('147', 'syn_admin_logic_1614829121', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('148', 'syn_admin_logic_1616123192', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('149', 'syn_admin_logic_ask_answer_like', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('150', 'syn_admin_logic_archives_1618279798', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('151', 'syn_admin_logic_1623036205', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('152', 'admin_logic_1623055490', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('153', 'system_use_language', '0', 'system', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('154', 'admin_logic_1623133485', '1', 'syn', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('155', 'other_pcwapjs', '0', 'other', '', 'cn', '0', '1638408558');
INSERT INTO `ey_config` VALUES ('156', 'system_correctarctypedirpath', '1', 'system', '', 'cn', '0', '1638408564');
INSERT INTO `ey_config` VALUES ('117', 'system_version', 'v1.6.0', 'system', '', 'cn', '0', '1668570362');
INSERT INTO `ey_config` VALUES ('118', 'php_serviceinfo', 'a121AwhUBQhWAgFUBwReUAMDB1JVUVsIVFUBWAQZR1pdAlYRAkYXFERFVAVHETkWX0QFD188VkAAXxMDBk5HWEcSW1xKAlxUA19CAxVbRDpGCQAABj9MBVcCAWVCVwcACjpGBF5RBGQTBlRUVT0TXlUGBjpEV1wBVm1EDVJTBGVHUQEHADhADlUKCThCV1FSAG0XUARbDmwQBVRfAT4QX1RWAhEURlRNElpeFloSAVcRC0A6RFtbVVBtRAwFWwNlR14DVVw4QAwDUQQ4QlhQUwNtF1MEVw9sEAVUCFY+EA8BXgtvTVICDFVuRFEABQA6RgRWVlU/TFYDAQAbG0AETEYOXEFVF1IKRAgTOEJZBAMGbRdTA1pfbBAJAV9TPhANVwUGb01dAw1WbkRQUlBVOkYFB1dQP0wHVwUJZUJUVgEKOkYFD1AGZBMHBgBRPRNTBwEGOkQFXwBUEx0bVhcRUV0UXkBfVRsNRAgTOEJZBAMGbRdTA1pfbBAJAV9TPhANVwUGb01dAw1WbkRQUlBVOkYFB1dQP0wHVwUJZUJUVgEKOkYFD1AGZBMHBgBRPRNTBwEGOkQFXwBUE0w', 'php', '', 'cn', '0', '1668570366');
INSERT INTO `ey_config` VALUES ('163', 'web_citysite_open', '0', 'web', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('164', 'admin_logic_1_1648775669', '1', 'syn', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('165', 'seo_uphtml_after_home', '0', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('166', 'seo_uphtml_after_channel', '1', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('167', 'seo_uphtml_after_pernext', '1', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('168', 'seo_html_templet', 'index.htm', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('169', 'seo_html_position', '../index.html', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('119', 'php_servicecode', '', 'php', '', 'cn', '0', '1668570324');
INSERT INTO `ey_config` VALUES ('120', 'syn_admin_logic_special_addfields', '5', 'syn', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('121', 'syn_admin_logic_session_conf', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('122', 'syn_admin_logic_arctype_topid2', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('123', 'syn_admin_logic_check_oneself', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('124', 'syn_admin_logic_links_group', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('125', 'sms_type', '1', 'sms', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('126', 'syn_admin_logic_1608189503', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('127', 'download_select_servername', 'a:6:{i:0;s:12:\"立即下载\";i:1;s:15:\"本地服务器\";i:2;s:15:\"远程服务器\";i:3;s:12:\"百度网盘\";i:4;s:15:\"七牛云存储\";i:5;s:12:\"腾讯网盘\";}', 'download', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('128', 'syn_admin_logic_1608191377', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('129', 'system_paginate_pagesize', '20', 'system', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('130', 'web_theme_color', '#3398cc', 'web', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('131', 'web_assist_color', '#2189be', 'web', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('132', 'web_loginbgimg', '', 'web', '', 'cn', '0', '1638408557');
INSERT INTO `ey_config` VALUES ('133', 'syn_admin_logic_1609039608', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('134', 'syn_admin_logic_1609291091', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('135', 'admin_logic_1610086647', '1', 'syn', '', 'cn', '0', '1614656192');
INSERT INTO `ey_config` VALUES ('136', 'syn_admin_logic_video_addfields_2', '1', 'syn', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('137', 'syn_admin_logic_1608884981_2', '1', 'syn', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('138', 'basic_img_style_wh', '0', 'basic', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('139', 'syn_admin_logic_1610086648', '1', 'syn', '', 'cn', '0', '1638408526');
INSERT INTO `ey_config` VALUES ('157', 'web_mobile_domain_open', '0', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('158', 'web_is_https', '0', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('159', 'recycle_switch', '0', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('160', 'web_login_expiretime', '3600', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('161', 'web_tpl_theme', '', 'web', '', 'cn', '0', '1650869769');
INSERT INTO `ey_config` VALUES ('162', 'system_crypt_auth_code', '$2y$11$e6882953e0ecef859812480', 'system', '', 'cn', '0', '1668570319');
INSERT INTO `ey_config` VALUES ('170', 'seo_showmod', '1', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('171', 'seo_maxpagesize', '50', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('172', 'seo_upnext', '1', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('173', 'seo_pagesize', '20', 'seo', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('174', 'basic_img_auto_wh', '0', 'basic', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('175', 'basic_img_alt', '0', 'basic', '', 'cn', '0', '1668570338');
INSERT INTO `ey_config` VALUES ('176', 'basic_img_title', '0', 'basic', '', 'cn', '0', '1668570338');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `type_id` int(11) unsigned DEFAULT '1',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='自定义变量表';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('1', 'web', '1', '网站头部广告语', 'web_attr_1', '0', 'cn', '1599123103', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '1', '公司电话', 'web_attr_2', '0', 'cn', '1599123438', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', '1', 'QQ', 'web_attr_3', '0', 'cn', '1599125021', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '1', '网站二维码', 'web_attr_4', '3', 'cn', '1599127659', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('5', 'web', '1', '电子邮箱', 'web_attr_5', '0', 'cn', '1599127706', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('6', 'web', '1', '手机', 'web_attr_6', '0', 'cn', '1599127706', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('7', 'web', '1', '公司地址', 'web_attr_7', '2', 'cn', '1599127866', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('8', 'web', '1', '手机端LOGO', 'web_attr_8', '3', 'cn', '1599201803', '1599204564');
INSERT INTO `ey_config_attribute` VALUES ('9', 'web', '1', '微信号', 'web_attr_9', '0', 'cn', '1599204564', '1599204564');

-- -----------------------------
-- Table structure for `ey_config_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_type`;
CREATE TABLE `ey_config_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(255) DEFAULT '' COMMENT '分组名称',
  `status` tinyint(1) DEFAULT '1',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `sort_order` int(11) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义变量分组表';

-- -----------------------------
-- Records of `ey_config_type`
-- -----------------------------
INSERT INTO `ey_config_type` VALUES ('1', '默认分组', '1', 'cn', '1650271499', '1650271499', '100');

-- -----------------------------
-- Table structure for `ey_cp_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cp_content`;
CREATE TABLE `ey_cp_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `content` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cp_content`
-- -----------------------------
INSERT INTO `ey_cp_content` VALUES ('1', '15', '1555053555', '1555053555', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/bcd617212957c9dc6a5412c58c7446d5.jpg&quot; title=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot; alt=&quot;bcd617212957c9dc6a5412c58c7446d5.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('2', '16', '1555053579', '1555053579', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; title=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot; alt=&quot;85ff99bfd9efbd4e1ae17dc2ead76035.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('3', '17', '1555053594', '1555053594', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; title=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot; alt=&quot;1c763a29611a28b4b5f9f000b3481a0c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('4', '18', '1555053608', '1555053608', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/98763fb03fa81c201889ea0c26e7490e.jpg&quot; title=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot; alt=&quot;98763fb03fa81c201889ea0c26e7490e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('5', '19', '1555053624', '1555053624', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ee4dff6a00936118779ae001f252725e.jpg&quot; title=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot; alt=&quot;ee4dff6a00936118779ae001f252725e.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('6', '20', '1555053639', '1555053639', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/6d8a523e021f2229eee481b33e1bf54c.jpg&quot; title=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot; alt=&quot;6d8a523e021f2229eee481b33e1bf54c.jpg&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('7', '21', '1555053764', '1555053764', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/261db2db709dc3c012a18d88c6844159.png&quot; title=&quot;261db2db709dc3c012a18d88c6844159.png&quot; alt=&quot;261db2db709dc3c012a18d88c6844159.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('8', '22', '1555053778', '1555053778', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/ae58acdec7b6e9585ee2beba5d14a652.png&quot; title=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot; alt=&quot;ae58acdec7b6e9585ee2beba5d14a652.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('9', '23', '1555053794', '1555053794', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/82eb83d1842cfbed36c1c1700faf3b68.png&quot; title=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot; alt=&quot;82eb83d1842cfbed36c1c1700faf3b68.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('10', '24', '1555053920', '1555053920', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/19f0405d149bcd41ec20b2dbb089f004.png&quot; title=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot; alt=&quot;19f0405d149bcd41ec20b2dbb089f004.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('11', '25', '1555053934', '1555053934', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a6c87d8626dc0763ec0a29e886957442.png&quot; title=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot; alt=&quot;a6c87d8626dc0763ec0a29e886957442.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('12', '26', '1555053950', '1555053950', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; title=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot; alt=&quot;df517acf1c9cc0c7ce64cf4d4acd6007.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('13', '27', '1555054000', '1555054000', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/d3db198cedafd09ff66d32f7a021c3d9.png&quot; title=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot; alt=&quot;d3db198cedafd09ff66d32f7a021c3d9.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('14', '28', '1555054012', '1555054012', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/2ee2205244719343d6e10ed6d0ee347f.png&quot; title=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot; alt=&quot;2ee2205244719343d6e10ed6d0ee347f.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('15', '29', '1555054025', '1555054025', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/316a0cd9a5a644cc9a4eff69291c065c.png&quot; title=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot; alt=&quot;316a0cd9a5a644cc9a4eff69291c065c.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('16', '30', '1555054039', '1555054039', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/132289025f8a3c3e156605143b2d81d7.png&quot; title=&quot;132289025f8a3c3e156605143b2d81d7.png&quot; alt=&quot;132289025f8a3c3e156605143b2d81d7.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('17', '31', '1555054204', '1555054204', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/a9a301b263d459d02328394d11762573.png&quot; title=&quot;a9a301b263d459d02328394d11762573.png&quot; alt=&quot;a9a301b263d459d02328394d11762573.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ey_cp_content` VALUES ('18', '32', '1555054216', '1555054216', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/uploads/ueditor/20190412/65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; title=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot; alt=&quot;65137ee3f9b70f15fa3b11cfaac0da5a.png&quot;/&gt;&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_cs_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_cs_content`;
CREATE TABLE `ey_cs_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `wzwz` varchar(200) NOT NULL DEFAULT '' COMMENT '网址',
  `ico` varchar(250) NOT NULL DEFAULT '' COMMENT '图标',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_cs_content`
-- -----------------------------
INSERT INTO `ey_cs_content` VALUES ('1', '27', '1614155119', '1614155119', 'https://www.bt.cn/', '/uploads/allimg/20190228/339b80f3d43d9a348a98746c502e28a1.jpg');

-- -----------------------------
-- Table structure for `ey_custom_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_custom_content`;
CREATE TABLE `ey_custom_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `miaoshu` text COMMENT '文章描述',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_custom_content`
-- -----------------------------
INSERT INTO `ey_custom_content` VALUES ('1', '6', '1551752806', '1551752806', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('2', '7', '1551752824', '1551752824', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('3', '8', '1551752838', '1551752838', '适用于大型、中型、小型以及快速成长型企业的解决方案');
INSERT INTO `ey_custom_content` VALUES ('4', '9', '1551752853', '1551752853', '适用于大型、中型、小型以及快速成长型企业的解决方案');

-- -----------------------------
-- Table structure for `ey_ddos_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ddos_log`;
CREATE TABLE `ey_ddos_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5key` varchar(50) DEFAULT '' COMMENT 'md5值',
  `file_name` varchar(500) DEFAULT '' COMMENT '文件名',
  `file_num` int(10) DEFAULT '0' COMMENT '已扫描数',
  `file_total` int(10) DEFAULT '0' COMMENT '总文件数',
  `file_num_ky` int(10) DEFAULT '0' COMMENT '可疑恶意文件数',
  `is_suspicious` tinyint(1) DEFAULT '0' COMMENT '是否可疑',
  `html` text,
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ddos查杀进度记录表';


-- -----------------------------
-- Table structure for `ey_discount_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active`;
CREATE TABLE `ey_discount_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_name` varchar(255) DEFAULT '' COMMENT '活动名称',
  `start_date` int(11) unsigned DEFAULT '0' COMMENT '活动开始时间',
  `end_date` int(11) DEFAULT '0' COMMENT '活动结束时间',
  `limit_type` tinyint(3) unsigned DEFAULT '1' COMMENT '限购类型 1-不限购,2-活动期内每人最多购买n件,3-活动期内每人每天最多购买n件',
  `limit` int(11) unsigned DEFAULT '0' COMMENT '限购数量',
  `preheat` tinyint(3) DEFAULT '0' COMMENT '是否开启预热 0-关闭 1-开启',
  `preheat_time` int(11) DEFAULT '0' COMMENT '预热时间,不能大于开启时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场表';


-- -----------------------------
-- Table structure for `ey_discount_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_active_goods`;
CREATE TABLE `ey_discount_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `discount_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_discount_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_discount_goods`;
CREATE TABLE `ey_discount_goods` (
  `discount_gid` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '限时折扣商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `discount_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限时折扣商品库存总量',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`discount_gid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='限时折扣-商品表';


-- -----------------------------
-- Table structure for `ey_diyminipro`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro`;
CREATE TABLE `ey_diyminipro` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';


-- -----------------------------
-- Table structure for `ey_diyminipro_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_page`;
CREATE TABLE `ey_diyminipro_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';


-- -----------------------------
-- Table structure for `ey_diyminipro_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_diyminipro_setting`;
CREATE TABLE `ey_diyminipro_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';


-- -----------------------------
-- Table structure for `ey_download_attr_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_attr_field`;
CREATE TABLE `ey_download_attr_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `field_name` varchar(32) DEFAULT '' COMMENT '字段名称',
  `field_title` varchar(32) DEFAULT '' COMMENT '字段标题',
  `field_use` tinyint(1) DEFAULT '0' COMMENT '字段是否使用，0未使用，1为使用',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='上传文件属性表';

-- -----------------------------
-- Records of `ey_download_attr_field`
-- -----------------------------
INSERT INTO `ey_download_attr_field` VALUES ('1', 'extract_code', '提取码', '1', '1', 'cn', '1561001807', '1561024954');
INSERT INTO `ey_download_attr_field` VALUES ('2', 'server_name', '服务器名称', '1', '2', 'cn', '1561001807', '1561078673');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `extract_code` varchar(20) DEFAULT '' COMMENT '文件提取码',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `server_name` varchar(200) DEFAULT '' COMMENT '服务器名称',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `is_remote` tinyint(1) DEFAULT '0' COMMENT '是否远程',
  `downcount` int(10) DEFAULT '0' COMMENT '下载次数',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载附件表';


-- -----------------------------
-- Table structure for `ey_download_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_log`;
CREATE TABLE `ey_download_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '附件ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='下载记录表';


-- -----------------------------
-- Table structure for `ey_download_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_order`;
CREATE TABLE `ey_download_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_email_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_email_template`;
CREATE TABLE `ey_email_template` (
  `tpl_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_title` varchar(100) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` varchar(100) DEFAULT '' COMMENT '邮件发送场景',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_email_template`
-- -----------------------------
INSERT INTO `ey_email_template` VALUES ('1', '您有新的邮件，请注意查收！', '<p>亲爱的会员：</p><p>${content}</p>', '1', '1509268284', '1509281095');

-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('region', '区域类型', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('file', '附件类型', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('media', '多媒体类型', '0', '11', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_form`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form`;
CREATE TABLE `ey_form` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增表单ID',
  `form_name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `intro` text NOT NULL COMMENT '表单描述，预留',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '表单状态，0关闭，1开启',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单管理表';


-- -----------------------------
-- Table structure for `ey_form_field`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_field`;
CREATE TABLE `ey_form_field` (
  `field_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `form_id` int(11) unsigned DEFAULT '0' COMMENT '表单管理表ID',
  `field_name` varchar(60) DEFAULT '' COMMENT '字段名称',
  `field_type` varchar(32) DEFAULT '' COMMENT '字段类型',
  `field_value` text COMMENT '可选值列表',
  `is_fill` tinyint(1) unsigned DEFAULT '0' COMMENT '是否必填字段，0非必填，1必填，预留',
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否默认字段，0非默认，1默认，预留',
  `sort_order` int(11) unsigned DEFAULT '100' COMMENT '字段排序，预留',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`field_id`),
  KEY `form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单字段表';


-- -----------------------------
-- Table structure for `ey_form_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_list`;
CREATE TABLE `ey_form_list` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `form_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单管理ID',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `city` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP所在城市',
  `come_from` varchar(100) NOT NULL DEFAULT '' COMMENT '来源页面标题',
  `come_url` varchar(500) NOT NULL DEFAULT '' COMMENT '来源页面链接',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，预留',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `aid` int(11) NOT NULL DEFAULT '0',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  PRIMARY KEY (`list_id`),
  KEY `form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单数据主表';


-- -----------------------------
-- Table structure for `ey_form_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_form_value`;
CREATE TABLE `ey_form_value` (
  `value_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增字段ID',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单数据主表ID',
  `form_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单管理ID',
  `field_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单字段表ID',
  `field_value` text NOT NULL COMMENT '表单数据内容表字段值',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`value_id`),
  KEY `list_id` (`list_id`) USING BTREE,
  KEY `form_id` (`form_id`) USING BTREE,
  KEY `field_id` (`field_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='表单数据内容表';


-- -----------------------------
-- Table structure for `ey_fuwu_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_fuwu_content`;
CREATE TABLE `ey_fuwu_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附加表';


-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `md5data` varchar(50) DEFAULT '' COMMENT '数据序列化之后的MD5加密，提交内容的唯一性',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `is_read` tinyint(1) DEFAULT '0' COMMENT '0=未读，1=已读',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='留言主表';

-- -----------------------------
-- Records of `ey_guestbook`
-- -----------------------------
INSERT INTO `ey_guestbook` VALUES ('1', '6', '8', '0', 'd4a3dabc48ab5b5eb4cf61e1b6c1f199', '127.0.0.1', '0', 'cn', '1599187291', '1599187291');

-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';

-- -----------------------------
-- Records of `ey_guestbook_attr`
-- -----------------------------
INSERT INTO `ey_guestbook_attr` VALUES ('1', '1', '1', '张生', 'cn', '1599187291', '1599187291');
INSERT INTO `ey_guestbook_attr` VALUES ('2', '1', '2', '13800000000', 'cn', '1599187291', '1599187291');
INSERT INTO `ey_guestbook_attr` VALUES ('3', '1', '3', '测试', 'cn', '1599187291', '1599187291');

-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `is_showlist` tinyint(1) DEFAULT '0' COMMENT '在列表显示 0=隐藏，1=显示',
  `required` tinyint(1) DEFAULT '0' COMMENT '必填 0=否，1=是',
  `validate_type` smallint(5) DEFAULT '0' COMMENT '验证格式，0=不验证，1=手机，2=Email',
  `real_validate` tinyint(1) unsigned DEFAULT '0' COMMENT '是否进行真实验证，0=不验证，1=真实验证',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_guestbook_attribute`
-- -----------------------------
INSERT INTO `ey_guestbook_attribute` VALUES ('1', '姓名', '6', '0', '', '0', '1', '0', '0', '100', 'cn', '0', '1599186997', '1599187001');
INSERT INTO `ey_guestbook_attribute` VALUES ('2', '电话', '6', '6', '', '0', '1', '6', '0', '100', 'cn', '0', '1599187010', '1599187010');
INSERT INTO `ey_guestbook_attribute` VALUES ('3', '留言内容', '6', '2', '', '0', '0', '0', '0', '100', 'cn', '0', '1599187023', '1599187023');

-- -----------------------------
-- Table structure for `ey_guwen_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guwen_content`;
CREATE TABLE `ey_guwen_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `diy_cyjy` varchar(200) NOT NULL DEFAULT '' COMMENT '从业经验',
  `diy_cgal` varchar(200) NOT NULL DEFAULT '' COMMENT '成功案例',
  `diy_dh` varchar(200) NOT NULL DEFAULT '' COMMENT '电话',
  `content` longtext COMMENT '详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_guwen_content`
-- -----------------------------
INSERT INTO `ey_guwen_content` VALUES ('1', '101', '1622787976', '1622787976', '4', '56', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('3', '103', '1622788158', '1622788158', '5', '76', '13812345678', '&lt;p&gt;做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('2', '102', '1622787971', '1622787971', '3', '58', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('4', '104', '1622788475', '1622788475', '6', '67', '13812345678', '&lt;p&gt;生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('5', '105', '1622788225', '1622788225', '5', '86', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('6', '106', '1622788253', '1622788253', '5', '58', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('7', '107', '1622788281', '1622788281', '4', '46', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('8', '108', '1622788320', '1622788320', '6', '72', '13812345678', '&lt;p&gt;公司经营范围为股权投资、债权投资、项目投资、资产管理、企业并购重组、投资管理及咨询和理财信息咨询。 金融作为联想控股成员企业，把为中小企业融资融智，推动实体经济发展。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('9', '109', '1622788354', '1622788354', '6', '113', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('10', '110', '1622788394', '1622788394', '6', '164', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('11', '111', '1622788422', '1622788422', '4', '76', '13812345678', '&lt;p&gt;工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('12', '112', '1622788459', '1622788459', '5', '96', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节.&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('13', '113', '1622788664', '1622788664', '6', '135', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('14', '114', '1622788722', '1622788722', '3', '76', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('15', '115', '1622788750', '1622788750', '9', '352', '13812345678', '&lt;p&gt;优秀的人，无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('16', '116', '1622788814', '1622788814', '5', '287', '13812345678', '&lt;p&gt;无论生活和工作给他人展示的总是一个态度，即做事踏实和用心。不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');
INSERT INTO `ey_guwen_content` VALUES ('17', '117', '1622788851', '1622788851', '6', '276', '13812345678', '&lt;p&gt;不论做什么工作，都要重视小事、关注细节，把小事做细、做透，揭示了“细中见精”、“小中见大”、“伟大与平凡”的真理。&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_hezuo_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hezuo_content`;
CREATE TABLE `ey_hezuo_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_hezuo_content`
-- -----------------------------
INSERT INTO `ey_hezuo_content` VALUES ('1', '66', '1599636856', '1599636856');
INSERT INTO `ey_hezuo_content` VALUES ('2', '67', '1599636870', '1599636870');
INSERT INTO `ey_hezuo_content` VALUES ('3', '68', '1599636881', '1599636881');
INSERT INTO `ey_hezuo_content` VALUES ('4', '69', '1599636893', '1599636893');
INSERT INTO `ey_hezuo_content` VALUES ('5', '70', '1599636904', '1599636904');
INSERT INTO `ey_hezuo_content` VALUES ('6', '71', '1599636918', '1599636918');
INSERT INTO `ey_hezuo_content` VALUES ('7', '72', '1599636930', '1599636930');
INSERT INTO `ey_hezuo_content` VALUES ('8', '73', '1599636943', '1599636943');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images17_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images17_content`;
CREATE TABLE `ey_images17_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images17_content`
-- -----------------------------
INSERT INTO `ey_images17_content` VALUES ('1', '1', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A107.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01A112.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('2', '2', '1636426759', '1636426759', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G441.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G443.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G445.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01G447.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('3', '3', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H912.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01H914.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('4', '4', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I011.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I013.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('5', '5', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I059.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I101.jpg\";s:5:\"intro\";s:0:\"\";}}', '');
INSERT INTO `ey_images17_content` VALUES ('6', '6', '1636426759', '1636426759', 'a:2:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I206.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200730/1-200I01I208.jpg\";s:5:\"intro\";s:0:\"\";}}', '');

-- -----------------------------
-- Table structure for `ey_images18_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images18_content`;
CREATE TABLE `ey_images18_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `imgurls` text COMMENT '图片集合|10001',
  `content` longtext COMMENT '图集内容',
  `dizhi` varchar(251) NOT NULL DEFAULT '' COMMENT '地址',
  `jingdu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图经度',
  `weidu` varchar(251) NOT NULL DEFAULT '' COMMENT '地图维度',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_images18_content`
-- -----------------------------
INSERT INTO `ey_images18_content` VALUES ('1', '18', '1637133079', '1637133079', 'a:4:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q134.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q135.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q136.jpg\";s:5:\"intro\";s:0:\"\";}i:3;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031Q138.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　10、发灰员：严格按照发灰手续办理，凭火化证发放骨灰。尊重逝者，双手递送，杜绝差错。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　11、骨灰堂服务员：填写卡片字迹清楚，准确无误；陪同家属到达存骨灰堂室。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务时限：1、全天候二十四小时提供殡仪服务。2、按照丧家要求准时到达接运遗体地点。3、以遗体进入火化车间为准，四小时内取灰。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　向社会各界郑重承诺：&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、加强廉政建设，纠正行业不正之风，严格遵守职业道德规范，不得接受丧家馈增的烟、酒、钱、物。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、坚持优质服务，文明用语，礼貌待人，主动热情，严格按照殡仪服务规范进行工作。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、严格执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、实行面对全市各区县和国内、国际的二十四小时全天候&amp;ldquo;一条龙&amp;rdquo;服务，并保证灵车随叫随到接运遗体（四小时之内）。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、火化遗体保证文明操作，一炉一尸，保证当天取灰（四小时）之内。&lt;/p&gt;\r\n', '北京市石景山区石景山路9号', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('2', '19', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS0.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS3.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:39:\"/uploads/allimg/200603/1-2006031SS6.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('3', '20', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S923.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S926.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031S929.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');
INSERT INTO `ey_images18_content` VALUES ('4', '21', '1637133079', '1637133079', 'a:3:{i:0;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T021.jpg\";s:5:\"intro\";s:0:\"\";}i:1;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T024.jpg\";s:5:\"intro\";s:0:\"\";}i:2;a:2:{s:9:\"image_url\";s:40:\"/uploads/allimg/200603/1-2006031T027.jpg\";s:5:\"intro\";s:0:\"\";}}', '&lt;p&gt;\r\n	北京市八宝山殡仪馆是全市规模最大、设施齐全的殡仪服务单位，承担着本市城近郊区市民、已故党和国家领导人、海外侨胞、国际友人的殡仪服务业务。每年承办告别活动6000余场，接待来宾近百万人次，年火化量2万多具。本馆坚持&amp;ldquo;服务第一，丧家至上&amp;rdquo;的宗旨，不断推行科学管理，提高服务质量，受到社会好评，连续多次被评为&amp;ldquo;首都精神文明单位&amp;rdquo;、&amp;ldquo;全国殡葬改革先进单位&amp;rdquo;、&amp;ldquo;北京市花园市单位&amp;rdquo;，2004年被国家民政部评为全国民政基层行风建设先进集体。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　八宝山殡仪馆始建于1958年，是北京历史上较早的殡仪馆之一。多年来，几经大规模建设改造，已经形成一整套独特的建设风格和服务体系，&amp;ldquo;八宝山&amp;rdquo;因此而成为中国殡葬业的代名词。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　服务标准：殡仪服务人员要统一着装，仪表端庄，语言文明，挂牌服务；各岗位职责明确，规范服务；遵守职业道德，拒收馈赠，杜绝索取财物。执行国家物价部门规定的收费标准。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　1、&amp;ldquo;一条龙&amp;rdquo;车辆调度室服务员：使用文明用语，服务态度热情，耐心解答询问，准确叮嘱家属等车时间、地点、注意事项。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　2、灵车司机：服从调度室安排，准时到达接运遗体地点；文明驾驶，保证车辆平稳不颠簸，转弯和过路口时照顾家属车辆，不甩车。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　3、引导服务员（接尸工）：接运遗体轻抬轻放；尊重亡者，脱穿衣文明；主动服务，满足要求；排忧解难，耐心周到。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　4、整容工：一般整容化妆着色均匀、自然、神态安祥、衣着整齐。特殊整容力求恢复原貌达到亡者家属满意。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　5、告别室服务员：尊重家属要求，协助布置会场；提供必要服务。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　6、火化工：遵守操作规程，保证骨灰质量。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　7、售盒服务员：服务态度和蔼，熟悉商品特点，主动介绍商品，满足不同层次的需要。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　8、刻字工：按要求逐字刻印，字迹清楚，准确无误。&lt;/p&gt;\r\n&lt;p&gt;\r\n	　　9、收银员：认真审核收费项目，填写标据字迹清楚，收款时唱收唱付。&lt;/p&gt;\r\n', '广州市平谷区西峪水库东岸', '113.269251', '23.201809');

-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图集图片表';


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';

-- -----------------------------
-- Records of `ey_language_attr`
-- -----------------------------
INSERT INTO `ey_language_attr` VALUES ('1', 'tid1', '1', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('2', 'tid2', '2', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('3', 'tid3', '3', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('4', 'tid4', '4', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('5', 'tid5', '5', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('6', 'tid6', '6', 'arctype', 'cn', '1599122491', '1599122491');
INSERT INTO `ey_language_attr` VALUES ('7', 'tid7', '7', 'arctype', 'cn', '1599122491', '1599122491');

-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';

-- -----------------------------
-- Records of `ey_language_attribute`
-- -----------------------------
INSERT INTO `ey_language_attribute` VALUES ('1', '关于我们', 'tid1', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('2', '产品中心', 'tid2', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('3', '新闻动态', 'tid3', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('4', '工程案例', 'tid4', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('5', '服务流程', 'tid5', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('6', '在线留言', 'tid6', 'arctype', '0', '1599122491', '1599122491');
INSERT INTO `ey_language_attribute` VALUES ('7', '联系我们', 'tid7', 'arctype', '0', '1599122491', '1599122491');

-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `groupid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '分组id， 默认分组值为1',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `nofollow` tinyint(1) DEFAULT '0',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('1', '1', '1', '百度', 'http://www.baidu.com', '', '100', '1', '0', '', '', '1', 'cn', '0', '1524975826', '1614656192');
INSERT INTO `ey_links` VALUES ('2', '1', '1', '腾讯', 'http://www.qq.com', '', '100', '1', '0', '', '', '1', 'cn', '0', '1524976095', '1614656192');
INSERT INTO `ey_links` VALUES ('3', '1', '1', '新浪', 'http://www.sina.com.cn', '', '100', '1', '0', '', '', '1', 'cn', '0', '1532414285', '1614656192');
INSERT INTO `ey_links` VALUES ('4', '1', '1', '淘宝', 'http://www.taobao.com', '', '100', '1', '0', '', '', '1', 'cn', '0', '1532414529', '1614656192');
INSERT INTO `ey_links` VALUES ('5', '1', '1', '微博', 'http://www.weibo.com', '', '100', '1', '0', '', '', '1', 'cn', '0', '1532414726', '1614656192');

-- -----------------------------
-- Table structure for `ey_links_group`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links_group`;
CREATE TABLE `ey_links_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '' COMMENT '分组名称',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='友情链接分组';

-- -----------------------------
-- Records of `ey_links_group`
-- -----------------------------
INSERT INTO `ey_links_group` VALUES ('1', '默认分组', '1', '100', 'cn', '1614656192', '1614656192');

-- -----------------------------
-- Table structure for `ey_media_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_content`;
CREATE TABLE `ey_media_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `courseware` varchar(200) NOT NULL DEFAULT '' COMMENT '课件地址',
  `courseware_free` enum('免费','收费') NOT NULL DEFAULT '免费' COMMENT '课件收费',
  `total_duration` int(10) NOT NULL DEFAULT '0' COMMENT '视频总时长',
  `total_video` int(10) NOT NULL DEFAULT '0' COMMENT '视频数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附加表';


-- -----------------------------
-- Table structure for `ey_media_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_file`;
CREATE TABLE `ey_media_file` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '视频模型文件表',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '文档标题',
  `file_name` varchar(200) NOT NULL DEFAULT '' COMMENT '文件名称',
  `file_title` varchar(200) NOT NULL DEFAULT '' COMMENT '选集标题',
  `file_url` text NOT NULL COMMENT '存储路径',
  `file_time` int(8) NOT NULL DEFAULT '0' COMMENT '文件时长',
  `file_ext` varchar(50) NOT NULL DEFAULT '' COMMENT '文件后缀名',
  `file_size` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `file_mime` varchar(200) NOT NULL DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) NOT NULL DEFAULT '' COMMENT '自定义的一种加密方式，用于视频播放的权限验证',
  `md5file` varchar(200) NOT NULL DEFAULT '' COMMENT 'md5_file加密，可以检测上传/播放的视频文件是否损坏',
  `is_remote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否远程 1-远程',
  `playcount` int(10) NOT NULL DEFAULT '0' COMMENT '播放次数',
  `gratis` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否试看，0不试看，1试看',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`file_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频附件表';


-- -----------------------------
-- Table structure for `ey_media_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_log`;
CREATE TABLE `ey_media_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `file_id` int(10) DEFAULT '0' COMMENT '视频ID',
  `ip` varchar(20) DEFAULT '' COMMENT 'ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '编辑时间',
  PRIMARY KEY (`log_id`),
  KEY `file_id` (`file_id`,`aid`,`users_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频日志表';


-- -----------------------------
-- Table structure for `ey_media_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_order`;
CREATE TABLE `ey_media_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '媒体订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '媒体订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款，1已付款',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单应付总金额',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '视频文档ID',
  `product_name` varchar(100) DEFAULT '' COMMENT '视频文档名称',
  `product_litpic` varchar(500) DEFAULT '' COMMENT '视频文档封面图片',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频订单表';


-- -----------------------------
-- Table structure for `ey_media_play_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_media_play_record`;
CREATE TABLE `ey_media_play_record` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `aid` int(10) DEFAULT '0' COMMENT '课程id',
  `file_id` int(10) DEFAULT '0' COMMENT '文件id',
  `play_time` int(10) DEFAULT '0' COMMENT '播放时间',
  `add_time` int(10) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='视频播放时长表';


-- -----------------------------
-- Table structure for `ey_memgift`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgift`;
CREATE TABLE `ey_memgift` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '礼品列表',
  `type` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1-实物,2-会员产品',
  `type_id` int(10) DEFAULT '0' COMMENT '类型为会员产品时的会员产品类型(users_type_manage)type_id',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所需积分',
  `litpic` varchar(250) NOT NULL DEFAULT '',
  `giftname` varchar(60) NOT NULL DEFAULT '',
  `num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '兑换次数',
  `content` longtext COMMENT '礼品详情',
  `stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存总数',
  `is_del` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0-正常,1-删除',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '礼品状态：1=显示，0=隐藏',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`gift_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_memgiftget`
-- -----------------------------
DROP TABLE IF EXISTS `ey_memgiftget`;
CREATE TABLE `ey_memgiftget` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `giftname` char(60) NOT NULL DEFAULT '',
  `gift_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '礼品ID',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `users_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态,0-待发货,1-已发货,2-退回,3-重发',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `mobile` varchar(55) NOT NULL DEFAULT '' COMMENT '手机',
  `address` varchar(255) NOT NULL DEFAULT '' COMMENT '地址',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `type_id` int(11) DEFAULT '0' COMMENT '兑换会员产品时,会员产品套餐(表::users_type_manage)type_id',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_nav_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_list`;
CREATE TABLE `ey_nav_list` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '导航ID',
  `nav_name` varchar(200) NOT NULL DEFAULT '' COMMENT '导航名称',
  `parent_id` int(10) NOT NULL DEFAULT '0' COMMENT '上级菜单id',
  `topid` int(10) NOT NULL DEFAULT '0' COMMENT '顶级菜单id',
  `en_name` varchar(200) NOT NULL DEFAULT '' COMMENT '英文名称',
  `nav_url` varchar(200) NOT NULL DEFAULT '' COMMENT '导航链接',
  `position_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '导航位置',
  `arctype_sync` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否与栏目同步',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '同步栏目的ID',
  `nav_pic` varchar(255) NOT NULL DEFAULT '' COMMENT '导航图片',
  `is_remote` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否远程图片',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否打开新窗口，1=是，0=否',
  `nofollow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用nofollow，1=是，0=否',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '启用 (1=正常，0=停用)',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nav_id`) USING BTREE,
  KEY `position_id` (`position_id`) USING BTREE,
  KEY `type_id` (`type_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导航列表';


-- -----------------------------
-- Table structure for `ey_nav_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nav_position`;
CREATE TABLE `ey_nav_position` (
  `position_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '导航列表ID',
  `position_name` varchar(200) DEFAULT '' COMMENT '导航列表名称',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`position_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='导航位置表';

-- -----------------------------
-- Records of `ey_nav_position`
-- -----------------------------
INSERT INTO `ey_nav_position` VALUES ('1', 'PC端主导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('2', 'PC端顶部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('3', 'PC端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('4', 'PC端底部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('5', '移动端中部导航', '100', '0', '0', '1624861478');
INSERT INTO `ey_nav_position` VALUES ('6', '移动端底部导航', '100', '0', '0', '1624861478');

-- -----------------------------
-- Table structure for `ey_nzsm_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_nzsm_content`;
CREATE TABLE `ey_nzsm_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zdy` varchar(200) NOT NULL DEFAULT '' COMMENT '字段一',
  `zde` varchar(200) NOT NULL DEFAULT '' COMMENT '字段二',
  `zdsa` varchar(200) NOT NULL DEFAULT '' COMMENT '字段三',
  `zdsi` varchar(200) NOT NULL DEFAULT '' COMMENT '字段四',
  `zdw` varchar(200) NOT NULL DEFAULT '' COMMENT '字段五',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_nzsm_content`
-- -----------------------------
INSERT INTO `ey_nzsm_content` VALUES ('1', '8', '1589159107', '1589159107', '短信接口', '企业邮局', '云服务器', '主机租用', '域名注册');
INSERT INTO `ey_nzsm_content` VALUES ('2', '9', '1589159121', '1589159121', '', '手机商城', '小程序商城', '微商城', 'B2C商城');
INSERT INTO `ey_nzsm_content` VALUES ('3', '10', '1589159131', '1589159131', '', 'APP开发', '微信公众平台开发', '手机网站', '小程序开发');
INSERT INTO `ey_nzsm_content` VALUES ('4', '11', '1589159145', '1589159145', 'B2C商城网站建设', '新闻门户网站建设', '营销网站建设', '品牌网站建设', '企业网站建设');

-- -----------------------------
-- Table structure for `ey_pay_api_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_pay_api_config`;
CREATE TABLE `ey_pay_api_config` (
  `pay_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '支付接口配置ID，自增',
  `pay_name` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置名称，微信支付，支付宝支付...',
  `pay_mark` varchar(64) NOT NULL DEFAULT '' COMMENT '支付接口配置标识，wechat，alipay...',
  `pay_info` text NOT NULL COMMENT '支付接口配置信息，数组以序列化存储',
  `pay_terminal` varchar(100) NOT NULL DEFAULT '' COMMENT '支付时的终端，暂时预留',
  `system_built` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否属于系统内置，0否，1是',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=关闭，1=开启)',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='支付接口配置表';

-- -----------------------------
-- Records of `ey_pay_api_config`
-- -----------------------------
INSERT INTO `ey_pay_api_config` VALUES ('1', '微信支付', 'wechat', '', 'a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}', '1', '1', 'cn', '1590111253', '1590661409');
INSERT INTO `ey_pay_api_config` VALUES ('2', '支付宝支付', 'alipay', '', 'a:4:{s:8:\"computer\";i:0;s:6:\"c_mark\";i:0;s:6:\"mobile\";i:0;s:6:\"m_mark\";i:0;}', '1', '1', 'cn', '1590111253', '1638408557');

-- -----------------------------
-- Table structure for `ey_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_plugin`;
CREATE TABLE `ey_plugin` (
  `code` varchar(13) DEFAULT NULL COMMENT '插件编码',
  `name` varchar(55) DEFAULT NULL COMMENT '中文名字',
  `version` varchar(255) DEFAULT NULL COMMENT '插件的版本',
  `author` varchar(30) DEFAULT NULL COMMENT '插件作者',
  `config` text COMMENT '配置信息',
  `config_value` text COMMENT '配置值信息',
  `desc` varchar(255) DEFAULT NULL COMMENT '插件描述',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `type` varchar(50) DEFAULT NULL COMMENT '插件类型 payment支付 login 登陆 shipping物流',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `bank_code` text COMMENT '网银配置信息',
  `scene` tinyint(1) DEFAULT '0' COMMENT '使用场景 0PC+手机 1手机 2PC 3APP 4小程序',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_plugin`
-- -----------------------------
INSERT INTO `ey_plugin` VALUES ('alipayMobile', '手机网站支付宝', '1.0', '宇宙人', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', '手机端网站支付宝 ', '0', 'payment', 'logo.jpg', 'N;', '1', '0');
INSERT INTO `ey_plugin` VALUES ('cod', '到货付款', '1.0', 'IT宇宙人', 'a:1:{i:0;a:4:{s:4:\"name\";s:9:\"code_desc\";s:5:\"label\";s:12:\"配送描述\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '货到付款插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('miniAppPay', '微信小程序支付', '1.0', 'lhb', 'a:4:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:15:\"小程序secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信小程序支付信息', '0', 'payment', 'logo.jpg', 'N;', '4', '0');
INSERT INTO `ey_plugin` VALUES ('appWeixinPay', 'App微信支付', '1.0', 'wangqh', 'a:3:{i:0;a:5:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";s:4:\"hint\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', '微信开放平台支付信息', '0', 'payment', 'logo.jpg', 'N;', '3', '0');
INSERT INTO `ey_plugin` VALUES ('tenpay', 'PC端财付通', '1.0', 'IT宇宙人', 'a:2:{i:0;a:4:{s:4:\"name\";s:7:\"partner\";s:5:\"label\";s:7:\"partner\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:3:\"key\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端财付通插件 ', '0', 'payment', 'logo.jpg', 'N;', '2', '0');
INSERT INTO `ey_plugin` VALUES ('alipay', 'PC端支付宝', '1.0', 'jy_pwn', 'a:6:{i:0;a:4:{s:4:\"name\";s:14:\"alipay_account\";s:5:\"label\";s:15:\"支付宝帐户\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"alipay_key\";s:5:\"label\";s:21:\"交易安全校验码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:14:\"alipay_partner\";s:5:\"label\";s:17:\"合作者身份ID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:18:\"alipay_private_key\";s:5:\"label\";s:6:\"秘钥\";s:4:\"type\";s:8:\"textarea\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:17:\"alipay_pay_method\";s:5:\"label\";s:19:\" 选择接口类型\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:24:\"使用担保交易接口\";i:1;s:30:\"使用即时到帐交易接口\";}}i:5;a:4:{s:4:\"name\";s:7:\"is_bank\";s:5:\"label\";s:18:\"是否开通网银\";s:4:\"type\";s:6:\"select\";s:6:\"option\";a:2:{i:0;s:3:\"否\";i:1;s:3:\"是\";}}}', '', 'PC端支付宝插件 ', '0', 'payment', 'logo.jpg', 'a:8:{s:12:\"招商银行\";s:9:\"CMB-DEBIT\";s:18:\"中国工商银行\";s:10:\"ICBC-DEBIT\";s:12:\"交通银行\";s:10:\"COMM-DEBIT\";s:18:\"中国建设银行\";s:9:\"CCB-DEBIT\";s:18:\"中国民生银行\";s:4:\"CMBC\";s:12:\"中国银行\";s:9:\"BOC-DEBIT\";s:18:\"中国农业银行\";s:3:\"ABC\";s:12:\"上海银行\";s:6:\"SHBANK\";}', '2', '0');
INSERT INTO `ey_plugin` VALUES ('unionpay', '银联在线支付', '1.0', '奇闻科技', 'a:4:{i:0;a:4:{s:4:\"name\";s:12:\"unionpay_mid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:15:\"777290058130619\";}i:1;a:4:{s:4:\"name\";s:21:\"unionpay_cer_password\";s:5:\"label\";s:25:\" 商户私钥证书密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"000000\";}i:2;a:4:{s:4:\"name\";s:13:\"unionpay_user\";s:5:\"label\";s:19:\" 企业网银账号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:12:\"123456789001\";}i:3;a:4:{s:4:\"name\";s:17:\"unionpay_password\";s:5:\"label\";s:19:\" 企业网银密码\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:6:\"789001\";}}', '', '银联在线支付插件 ', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信支付', '1.0', 'IT宇宙人', 'a:5:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:20:\"绑定支付的APPID\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:5:\"mchid\";s:5:\"label\";s:9:\"商户号\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:3:\"key\";s:5:\"label\";s:18:\"商户支付密钥\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:3;a:4:{s:4:\"name\";s:9:\"appsecret\";s:5:\"label\";s:57:\"公众帐号secert（仅JSAPI支付的时候需要配置)\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:4;a:4:{s:4:\"name\";s:6:\"smchid\";s:5:\"label\";s:48:\"服务商商户号，企业在线付款需用到\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'PC端+微信公众号支付', '0', 'payment', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('helloworld', 'HelloWorld插件', 'v2.0.5,v2.0.7', '惹妹子生气了', '', '', '适合v2.0.5 , v2.0.7', '0', 'function', 'logo.jpg', 'N;', '0', '0');
INSERT INTO `ey_plugin` VALUES ('weixin', '微信登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:5:\"appid\";s:5:\"label\";s:17:\"开放平台appid\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:6:\"secret\";s:5:\"label\";s:18:\"开放平台secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', 'a:3:{s:5:\"appid\";s:18:\"wx0f0ff39efd386c42\";s:6:\"secret\";s:32:\"fc878c9641346adc9b7d7e299572ba42\";s:10:\"return_url\";s:67:\"http://www.lvxing1788.com/index/LoginApi/callback/oauth/weixin.html\";}', '微信扫码登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '1513556648');
INSERT INTO `ey_plugin` VALUES ('qq', 'QQ登录', '1.0', '彭老师', 'a:3:{i:0;a:4:{s:4:\"name\";s:6:\"app_id\";s:5:\"label\";s:6:\"app_id\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:1;a:4:{s:4:\"name\";s:10:\"app_secret\";s:5:\"label\";s:10:\"app_secret\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}i:2;a:4:{s:4:\"name\";s:10:\"return_url\";s:5:\"label\";s:9:\"回调URL\";s:4:\"type\";s:4:\"text\";s:5:\"value\";s:0:\"\";}}', '', 'QQ登录插件 ', '1', 'login', 'logo.jpg', 'N;', '0', '0');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性值';


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品表单属性表';


-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_product_content`
-- -----------------------------
INSERT INTO `ey_product_content` VALUES ('1', '13', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599184107', '1599184107');
INSERT INTO `ey_product_content` VALUES ('2', '31', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189455', '1599189455');
INSERT INTO `ey_product_content` VALUES ('3', '32', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189475', '1599189475');
INSERT INTO `ey_product_content` VALUES ('4', '33', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189497', '1599189497');
INSERT INTO `ey_product_content` VALUES ('5', '34', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189515', '1599189515');
INSERT INTO `ey_product_content` VALUES ('6', '35', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189532', '1599189532');
INSERT INTO `ey_product_content` VALUES ('7', '36', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189581', '1599189581');
INSERT INTO `ey_product_content` VALUES ('8', '37', '&lt;p&gt;钓鱼的杆止一般在手杆的尾部堵头向前20cm左右，正好是手杆杆把与杆身的搭接处，从拔出鱼杆堵塞那头沾少许肥皂水撸至杆把处（由细向粗套），在钓杆架（俗称炮台）上防止鱼杆向前滑入水中。&lt;/p&gt;', '', '1599189600', '1599189600');

-- -----------------------------
-- Table structure for `ey_product_custom_param`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_custom_param`;
CREATE TABLE `ey_product_custom_param` (
  `param_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '参数ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `param_name` varchar(60) NOT NULL DEFAULT '' COMMENT '参数名称',
  `param_value` varchar(200) NOT NULL DEFAULT '' COMMENT '参数值',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`param_id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(2000) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='产品图片表';

-- -----------------------------
-- Records of `ey_product_img`
-- -----------------------------
INSERT INTO `ey_product_img` VALUES ('1', '13', '产品名称一', '/uploads/allimg/20200904/1-200Z4094QN49.jpg', '', '600', '450', '44171', 'image/jpeg', '1', '1599184107', '0');
INSERT INTO `ey_product_img` VALUES ('2', '13', '产品名称一', '/uploads/allimg/20200904/1-200Z4094Q6364.jpg', '', '600', '450', '26868', 'image/jpeg', '2', '1599184107', '0');
INSERT INTO `ey_product_img` VALUES ('3', '13', '产品名称一', '/uploads/allimg/20200904/1-200Z4094Q62Y.jpg', '', '600', '450', '36373', 'image/jpeg', '3', '1599184107', '0');
INSERT INTO `ey_product_img` VALUES ('4', '13', '产品名称一', '/uploads/allimg/20200904/1-200Z4094QAO.jpg', '', '600', '450', '46069', 'image/jpeg', '4', '1599184107', '0');
INSERT INTO `ey_product_img` VALUES ('5', '31', '产品名称二', '/uploads/allimg/20200904/1-200Z4111G0I6.jpg', '', '600', '450', '46002', 'image/jpeg', '1', '1599189455', '0');
INSERT INTO `ey_product_img` VALUES ('6', '31', '产品名称二', '/uploads/allimg/20200904/1-200Z4111Fa92.jpg', '', '600', '450', '44785', 'image/jpeg', '2', '1599189455', '0');
INSERT INTO `ey_product_img` VALUES ('7', '32', '产品名称三', '/uploads/allimg/20200904/1-200Z4111K2K4.jpg', '', '600', '450', '46002', 'image/jpeg', '1', '1599189475', '0');
INSERT INTO `ey_product_img` VALUES ('8', '32', '产品名称三', '/uploads/allimg/20200904/1-200Z4111K2a0.jpg', '', '600', '450', '44785', 'image/jpeg', '2', '1599189475', '0');
INSERT INTO `ey_product_img` VALUES ('9', '33', '产品名称', '/uploads/allimg/20200904/1-200Z4111Q4303.jpg', '', '600', '450', '26868', 'image/jpeg', '1', '1599189497', '0');
INSERT INTO `ey_product_img` VALUES ('10', '33', '产品名称', '/uploads/allimg/20200904/1-200Z4111Q44L.jpg', '', '600', '450', '44171', 'image/jpeg', '2', '1599189497', '0');
INSERT INTO `ey_product_img` VALUES ('11', '34', '产品名称五', '/uploads/allimg/20200904/1-200Z4111S2I9.jpg', '', '600', '450', '36373', 'image/jpeg', '1', '1599189515', '0');
INSERT INTO `ey_product_img` VALUES ('12', '34', '产品名称五', '/uploads/allimg/20200904/1-200Z4111S2954.jpg', '', '600', '450', '46069', 'image/jpeg', '2', '1599189515', '0');
INSERT INTO `ey_product_img` VALUES ('13', '35', '产品名称六', '/uploads/allimg/20200904/1-200Z4111T9252.jpg', '', '600', '450', '44171', 'image/jpeg', '1', '1599189532', '0');
INSERT INTO `ey_product_img` VALUES ('14', '35', '产品名称六', '/uploads/allimg/20200904/1-200Z4111TS46.jpg', '', '600', '450', '26868', 'image/jpeg', '2', '1599189532', '0');
INSERT INTO `ey_product_img` VALUES ('15', '35', '产品名称六', '/uploads/allimg/20200904/1-200Z4111TR93.jpg', '', '600', '450', '36373', 'image/jpeg', '3', '1599189532', '0');
INSERT INTO `ey_product_img` VALUES ('16', '35', '产品名称六', '/uploads/allimg/20200904/1-200Z4111TT55.jpg', '', '600', '450', '46069', 'image/jpeg', '4', '1599189532', '0');
INSERT INTO `ey_product_img` VALUES ('17', '36', '产品名称七', '/uploads/allimg/20200904/1-200Z4111939326.jpg', '', '600', '450', '32301', 'image/jpeg', '1', '1599189581', '0');
INSERT INTO `ey_product_img` VALUES ('18', '36', '产品名称七', '/uploads/allimg/20200904/1-200Z411193T12.jpg', '', '600', '450', '37138', 'image/jpeg', '2', '1599189581', '0');
INSERT INTO `ey_product_img` VALUES ('19', '36', '产品名称七', '/uploads/allimg/20200904/1-200Z411193S22.jpg', '', '600', '450', '41103', 'image/jpeg', '3', '1599189581', '0');
INSERT INTO `ey_product_img` VALUES ('20', '37', '产品名称八', '/uploads/allimg/20200904/1-200Z411195W12.jpg', '', '600', '450', '32301', 'image/jpeg', '1', '1599189600', '0');
INSERT INTO `ey_product_img` VALUES ('21', '37', '产品名称八', '/uploads/allimg/20200904/1-200Z411195L50.jpg', '', '600', '450', '37138', 'image/jpeg', '2', '1599189600', '0');
INSERT INTO `ey_product_img` VALUES ('22', '37', '产品名称八', '/uploads/allimg/20200904/1-200Z411195Ia.jpg', '', '600', '450', '41103', 'image/jpeg', '3', '1599189600', '0');

-- -----------------------------
-- Table structure for `ey_product_netdisk`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_netdisk`;
CREATE TABLE `ey_product_netdisk` (
  `nd_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '网盘商品id',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `netdisk_url` varchar(255) NOT NULL DEFAULT '' COMMENT '网盘地址',
  `netdisk_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '提取码',
  `unzip_pwd` varchar(50) NOT NULL DEFAULT '' COMMENT '解压密码',
  `text_content` text NOT NULL COMMENT '文本内容',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`nd_id`) USING BTREE,
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品虚拟表';


-- -----------------------------
-- Table structure for `ey_product_spec_data`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data`;
CREATE TABLE `ey_product_spec_data` (
  `spec_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) DEFAULT '0' COMMENT '产品ID',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '规格标记ID',
  `spec_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '规格值ID',
  `spec_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '是否选中（0=否，1=是）',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`spec_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_data_handle`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_data_handle`;
CREATE TABLE `ey_product_spec_data_handle` (
  `spec_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `aid` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_mark_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_name` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_value_id` int(10) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `spec_value` varchar(100) DEFAULT '' COMMENT '对应 product_spec_data 数据表',
  `spec_is_select` tinyint(1) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_data 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_data 数据表'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品规格表(product_spec_data)预处理规格数据表';


-- -----------------------------
-- Table structure for `ey_product_spec_preset`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_preset`;
CREATE TABLE `ey_product_spec_preset` (
  `preset_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `preset_mark_id` int(10) DEFAULT '0' COMMENT '预设参数标记ID',
  `preset_name` varchar(100) DEFAULT '' COMMENT '规格名称',
  `preset_value` varchar(100) DEFAULT '' COMMENT '规格值',
  `spec_sync` tinyint(1) unsigned DEFAULT '0' COMMENT '是否同步到已发布的商品规格：0否，1是。',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `merchant_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '多商家ID',
  `product_add` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否在商品添加或编辑页添加的规格信息，0否，1是，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='产品规格预设表';

-- -----------------------------
-- Records of `ey_product_spec_preset`
-- -----------------------------
INSERT INTO `ey_product_spec_preset` VALUES ('1', '1', '产品颜色', '红', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('2', '1', '产品颜色', '蓝', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');
INSERT INTO `ey_product_spec_preset` VALUES ('3', '1', '产品颜色', '黄', '0', '100', '0', '0', 'cn', '1565752372', '1565752623');

-- -----------------------------
-- Table structure for `ey_product_spec_value`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_spec_value`;
CREATE TABLE `ey_product_spec_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值ID',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '规格价格',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '规格库存',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '销售量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀库存(独立库存，与spec_stock/限时折扣库存不同步)',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '秒杀销售量',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-秒杀',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '限时折扣价格',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣库存(独立库存，与spec_stock/秒杀库存不同步)',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '限时折扣销售量',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-普通 1-限时折扣',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品多规格组装表';


-- -----------------------------
-- Table structure for `ey_quickentry`
-- -----------------------------
DROP TABLE IF EXISTS `ey_quickentry`;
CREATE TABLE `ey_quickentry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '' COMMENT '名称',
  `laytext` varchar(50) DEFAULT '' COMMENT '完整标题',
  `type` smallint(5) DEFAULT '0' COMMENT '归类，1=快捷入口，2=内容统计',
  `controller` varchar(20) DEFAULT '' COMMENT '控制器名',
  `action` varchar(20) DEFAULT '' COMMENT '操作名',
  `vars` varchar(100) DEFAULT '' COMMENT 'URL参数字符串',
  `groups` smallint(5) DEFAULT '0' COMMENT '分组，1=模型',
  `checked` tinyint(4) DEFAULT '0' COMMENT '选中，0=否，1=是',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=有效，0=无效',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8 COMMENT='快捷入口表';

-- -----------------------------
-- Records of `ey_quickentry`
-- -----------------------------
INSERT INTO `ey_quickentry` VALUES ('1', '产品', '产品列表', '1', 'Product', 'index', 'channel=2', '1', '0', '1', '3', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('2', '下载', '下载列表', '1', 'Download', 'index', 'channel=4', '1', '0', '1', '4', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('3', '文章', '文章列表', '1', 'Article', 'index', 'channel=1', '1', '0', '1', '6', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('4', '图集', '图集列表', '1', 'Images', 'index', 'channel=3', '1', '0', '1', '7', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('5', '内容管理', '内容列表', '1', 'Archives', 'index', '', '0', '0', '1', '13', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('7', '回收站', '回收站', '1', 'RecycleBin', 'archives_index', '', '0', '1', '1', '4', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('8', '栏目管理', '栏目管理', '1', 'Arctype', 'index', '', '0', '0', '1', '5', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('9', '留言', '留言列表', '1', 'Guestbook', 'index', 'channel=8', '1', '0', '1', '6', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('10', '网站信息', '网站信息', '1', 'System', 'web', '', '0', '0', '1', '7', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('11', '水印配置', '水印配置', '1', 'System', 'water', '', '0', '1', '1', '8', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('12', '缩略图配置', '缩略图配置', '1', 'System', 'thumb', '', '0', '1', '1', '9', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('13', '数据备份', '数据备份', '1', 'Tools', 'index', '', '0', '0', '1', '11', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('14', 'URL配置', 'URL配置', '1', 'Seo', 'seo', '', '0', '1', '1', '1', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('15', '模板管理', '模板管理', '1', 'Filemanager', 'index', '', '0', '1', '1', '6', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('16', 'SiteMap', 'SiteMap', '1', 'Sitemap', 'index', '', '0', '1', '1', '12', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('17', '频道模型', '频道模型', '1', 'Channeltype', 'index', '', '0', '1', '1', '2', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('18', '广告管理', '广告管理', '1', 'AdPosition', 'index', '', '0', '0', '1', '3', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('19', '友情链接', '友情链接', '1', 'Links', 'index', '', '0', '0', '1', '10', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('20', 'Tags管理', 'Tags管理', '1', 'Tags', 'index', '', '0', '1', '1', '14', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('21', '管理员管理', '管理员管理', '1', 'Admin', 'index', '', '0', '0', '1', '15', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('22', '接口配置', '接口配置', '1', 'System', 'api_conf', '', '0', '1', '1', '16', '1569232484', '1571893529');
INSERT INTO `ey_quickentry` VALUES ('23', '文章', '文章列表', '2', 'Article', 'index', 'channel=1', '1', '1', '1', '1', '1569310798', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('24', '产品', '产品列表', '2', 'Product', 'index', 'channel=2', '1', '0', '1', '2', '1569310798', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('25', '下载', '下载列表', '2', 'Download', 'index', 'channel=4', '1', '0', '1', '4', '1569310798', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('26', '图集', '图集列表', '2', 'Images', 'index', 'channel=3', '1', '0', '1', '3', '1569310798', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('27', '留言', '留言列表', '2', 'Guestbook', 'index', 'channel=8', '1', '0', '1', '5', '1569310798', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('28', '广告', '广告管理', '2', 'AdPosition', 'index', '', '0', '1', '1', '8', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('29', '友情链接', '友情链接', '2', 'Links', 'index', '', '0', '1', '1', '9', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('30', 'Tags标签', 'Tags管理', '2', 'Tags', 'index', '', '0', '1', '1', '10', '1569232484', '1571898872');
INSERT INTO `ey_quickentry` VALUES ('31', '会员', '会员管理', '2', 'Member', 'users_index', '', '0', '0', '0', '7', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('32', '插件应用', '插件应用', '1', 'Weapp', 'index', '', '0', '0', '0', '17', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('33', '会员中心', '会员中心', '1', 'Member', 'users_index', '', '0', '0', '0', '18', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('34', '商城中心', '商城中心', '1', 'Shop', 'index', '', '0', '0', '0', '19', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('35', '订单', '订单管理', '2', 'Shop', 'index', '', '0', '0', '0', '6', '1569232484', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('37', '专题', '专题列表', '2', 'Special', 'index', 'channel=7', '1', '0', '0', '7', '1600078966', '1668570338');
INSERT INTO `ey_quickentry` VALUES ('39', '视频', '视频列表', '2', 'Media', 'index', 'channel=5', '1', '0', '0', '4', '1569310798', '1668570338');

-- -----------------------------
-- Table structure for `ey_recruit_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_recruit_content`;
CREATE TABLE `ey_recruit_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `gzdd` varchar(200) NOT NULL DEFAULT '' COMMENT '工作地点',
  `xlyq` varchar(200) NOT NULL DEFAULT '' COMMENT '学历要求',
  `xzdy` varchar(200) NOT NULL DEFAULT '' COMMENT '薪资待遇',
  `gzxz` varchar(200) NOT NULL DEFAULT '' COMMENT '工作性质',
  `gznx` varchar(200) NOT NULL DEFAULT '' COMMENT '工作年限',
  `zprs` varchar(200) NOT NULL DEFAULT '' COMMENT '招聘人数',
  `nnxq` longtext COMMENT '内容详情',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_recruit_content`
-- -----------------------------
INSERT INTO `ey_recruit_content` VALUES ('1', '82', '1563528211', '1563528211', '广州市', '中专以上学历', '5000-10000元', '全职', '1年以上', '若干', '&lt;p&gt;工作内容：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1、负责公司手机游戏产品的在线推广；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2、做好每天的推广统计，定制有效的投放策略并执行；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3、完成每天的业绩要求，只要你努力，月入过万不是梦&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;职位要求：&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;1学历不限，欢迎优秀应届生（优秀者可放宽）；男女不限，19~24岁&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;2.亲和力强、沟通流畅、重点突出；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;3.个性开朗、反应敏捷，有较强的服务意识和责任心；&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;4.能熟练运用QQ及微信聊天软件，懂得电脑的基本操作，打字速度不限&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;我们期待怀揣梦想的你加入我们！&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;5、有经验者优先考虑！！！！！&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('2', '83', '1563528292', '1563528292', '广州市', '中专以上学历', '5000-8000元', '全职', '2年以上', '2位', '&lt;p&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;岗位职责：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、负责网站相关栏目、信息的搜集、编辑、发布等工作。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、完成信息内容的策划和日常信息的更新与维护。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、编写网站宣传资料及相关产品信息。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、配合部门编辑策划推广活动。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、部门总监下发的其他任务。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;任职资格：&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;1、编辑、新闻、中文等相关专业优先，大专及以上学历。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;2、有编辑或从事相关工作经验优先。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;3、熟练使用网页制作软件和网络搜索工具，了解网站运行、维护相关知识。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;4、良好的文字功底，信息采编能力。&lt;/span&gt;&lt;br style=&quot;outline: 0px; text-size-adjust: none; -webkit-tap-highlight-color: rgba(0, 0, 0, 0.05); color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; white-space: normal; background-color: rgb(255, 255, 255);&quot;/&gt;&lt;span style=&quot;color: rgb(46, 52, 59); font-family: &amp;quot;Microsoft YaHei&amp;quot;, &amp;quot;Hiragino Sans GB&amp;quot;, 微软雅黑, arial, Tahoma, SimSun, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;5、欢迎应届毕业生来应聘。&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('3', '94', '1565225547', '1565225547', '广州市', '专科以上学历', '5000-8000元', '全职', '2年以上', '若干', '&lt;p&gt;1、负责客户开发、提供客户服务、公司服务的推广、建立与维护客户关系；&lt;/p&gt;&lt;p&gt;2、根据市场营销计划和个人销售目标，完成各阶段销售目标；&lt;/p&gt;&lt;p&gt;3、进行市场调研，确定目标市场，收集分析竞争对象信息，制订、执行销售对策；&lt;/p&gt;&lt;p&gt;4、与内部相关部门建立并维持良好的协作关系，以客户和市场为导向，协调各方面关系，确保合同的顺利执行。&lt;/p&gt;&lt;p&gt;【岗位要求】&lt;/p&gt;&lt;p&gt;1、专科学历，有一定客户服务工作经验或销售经验，有一定的客户服务知识和能力。&lt;/p&gt;&lt;p&gt;2、计算机操作熟练，office办公软件使用熟练，有一定的网络基础知识，熟练使用Photoshop等制图工具着优先考虑。&lt;/p&gt;&lt;p&gt;3、要求一定要有“客户优先”的服务精神，一切从帮助客户、满足客户角度出发。&lt;/p&gt;&lt;p&gt;4、性格要求沉稳、隐忍，善于倾听，有同理心，乐观、积极。普通话标准、流利，反应灵敏。&lt;/p&gt;&lt;p&gt;5、热爱工作，敬业、勤恳、乐于思考，具有自我发展的主观的主题愿望和自我学习能力。可适当加班者优先。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('4', '95', '1565225608', '1565225608', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;岗位职责：1、利用网络进行公司产品的销售及推广2、了解网络销售，有信心和良好的学习能力3、完成团队目标4、通过网络进行渠道开发和业务拓展5、熟悉互联网络，熟练使用网络交流工具和各种办公软件6、有较强的沟通能力&lt;/p&gt;&lt;p&gt;任职要求：1、年龄18～25之间，有空杯心态者优先2、性格开朗，喜欢与人沟通，表达流畅，普通话标准3、具备一定的客户服务精神，准确把握客户需求4、认真细致，能接受挑战性任务5、有无销售经验均可，欢迎应届毕业生应聘&lt;/p&gt;&lt;p&gt;薪资待遇：底薪+高抽成+奖金+年底双薪+生日聚餐，不定期的聚会和旅游等&lt;/p&gt;&lt;p&gt;晋升空间：业务基础—精英业务员—销售组长—销售主管—核心主管&lt;/p&gt;&lt;p&gt;销售激励：礼品奖励、现金奖金、出单奖励、周业绩奖励、月销售前三奖励。依法享受法定节假日（带薪旅游、带薪年假、婚假。、产假、员工生日庆祝）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('5', '96', '1565225638', '1565225638', '广州市', '专科以上学历', '5000-10000元', '全职', '2年以上', '若干', '&lt;p&gt;任职要求： 1、年龄25-35岁，本科及以上学历，网络安全相关专业，持网络安全证书，2年以上同岗位工作经验； 2、熟知防火墙、入侵检测、网络流量识别控制等信息安全产品相关技术；熟悉网络协议、网络编程及相关网络产品开发技术； 3、具备良好的安全意识能力、语言表达能力、逻辑思维能力、执行力、责任心、团队协作能力。 岗位职责： 1、安全设备的日常监控与维护，及时进行安全设备策略的变更与调整；安全运维的结果文档、技术资料、设备日志，配置信息等相关资料的管理及维护； 2、定期关注安全设备系统的升级补丁，合适准确性后及时更新补丁，完成安全设备系统升级； 3、安全设备的健康检查、健康检查表、基线统计、流量统计、特殊事件报告、日报、周报等日常工作； 4、参与信息安全事件的分析工作和应急处理工作；定期安全评估、扫描和加固，协助进行安全加固； 5、协助制定网络安全规范与方案，优化现有网络安全架构，定期评估网络安全风险，负责针对运行故障、安全事件开展分析和总结，定期开展运行维护、故障处理及安全事件分析； 6、完成上级领导交办的其他任务，并做好与其他部门的协调配合工作。&lt;/p&gt;');
INSERT INTO `ey_recruit_content` VALUES ('6', '97', '1565225697', '1565225697', '广州市', '专科以上学历', '5000-8000元', '全职', '1年以上', '2位', '&lt;p&gt;岗位职责1、组织参与重要项目的创意构思、文案及客户提案, 给予前期提案、设计创意说明及后期结案报告等服务；2、执行并监督所负责项目的创意构思和文案；3、稿件思路清晰，能够完成稿件写作思路规划；4、协助领导进行创意提案，保证工作的顺利推进；5、独立撰写各类稿件（新闻稿、综述稿、评论稿、专访稿等）、策划方案、报告等任职资格1、大专及以上学历；2、一年以上市场策划及文案工作经验；3、能够准确捕捉产品亮点，具备恰如其分的文字表现能力；4、熟悉专业创意方法，思维敏捷，洞察力强，文字功底扎实，语言表达能力强；福利待遇：1.公司为员工提供以市场标杆，以能力、绩效为标准，具有市场竞争力的薪资待遇；2.为员工缴纳社会保险和办理住房公积金、带薪年假、法定节假日、小暑假；3.员工享有专业持续的提升培训机制、不定期的拓展福利、稳健的晋升机制；4.生日福利、传统节日福利、年终奖、年终分红等多种特色福利；试用期工资3500职能类别：网站&lt;/p&gt;');

-- -----------------------------
-- Table structure for `ey_region`
-- -----------------------------
DROP TABLE IF EXISTS `ey_region`;
CREATE TABLE `ey_region` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `initial` varchar(5) DEFAULT '' COMMENT '首字母',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `initial` (`initial`)
) ENGINE=MyISAM AUTO_INCREMENT=47964 DEFAULT CHARSET=utf8 COMMENT='区域表';

-- -----------------------------
-- Records of `ey_region`
-- -----------------------------
INSERT INTO `ey_region` VALUES ('1', '北京市', '1', '0', 'B');
INSERT INTO `ey_region` VALUES ('2', '北京市', '2', '1', 'B');
INSERT INTO `ey_region` VALUES ('3', '东城区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('14', '西城区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('22', '崇文区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('30', '宣武区', '3', '2', 'X');
INSERT INTO `ey_region` VALUES ('39', '朝阳区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('83', '丰台区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('105', '石景山区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('115', '海淀区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('145', '门头沟区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('159', '房山区', '3', '2', 'F');
INSERT INTO `ey_region` VALUES ('188', '通州区', '3', '2', 'T');
INSERT INTO `ey_region` VALUES ('204', '顺义区', '3', '2', 'S');
INSERT INTO `ey_region` VALUES ('227', '昌平区', '3', '2', 'C');
INSERT INTO `ey_region` VALUES ('245', '大兴区', '3', '2', 'D');
INSERT INTO `ey_region` VALUES ('264', '怀柔区', '3', '2', 'H');
INSERT INTO `ey_region` VALUES ('281', '平谷区', '3', '2', 'P');
INSERT INTO `ey_region` VALUES ('301', '密云区', '3', '2', 'M');
INSERT INTO `ey_region` VALUES ('322', '延庆区', '3', '2', 'Y');
INSERT INTO `ey_region` VALUES ('338', '天津市', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('339', '天津市', '2', '338', 'T');
INSERT INTO `ey_region` VALUES ('340', '和平区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('347', '河东区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('361', '河西区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('375', '南开区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('388', '河北区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('399', '红桥区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('410', '塘沽区', '3', '339', 'T');
INSERT INTO `ey_region` VALUES ('425', '汉沽区', '3', '339', 'H');
INSERT INTO `ey_region` VALUES ('435', '大港区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('445', '东丽区', '3', '339', 'D');
INSERT INTO `ey_region` VALUES ('460', '西青区', '3', '339', 'X');
INSERT INTO `ey_region` VALUES ('473', '津南区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('488', '北辰区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('504', '武清区', '3', '339', 'W');
INSERT INTO `ey_region` VALUES ('538', '宝坻区', '3', '339', 'B');
INSERT INTO `ey_region` VALUES ('570', '宁河区', '3', '339', 'N');
INSERT INTO `ey_region` VALUES ('586', '静海区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('608', '蓟州区', '3', '339', 'J');
INSERT INTO `ey_region` VALUES ('636', '河北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('637', '石家庄市', '2', '636', 'S');
INSERT INTO `ey_region` VALUES ('638', '市辖区', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('639', '长安区', '3', '637', 'C');
INSERT INTO `ey_region` VALUES ('651', '桥东区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('662', '桥西区', '3', '637', 'Q');
INSERT INTO `ey_region` VALUES ('675', '新华区', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('691', '井陉矿区', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('697', '裕华区', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('708', '井陉县', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('726', '正定县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('736', '栾城县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('745', '行唐县', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('761', '灵寿县', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('777', '高邑县', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('783', '深泽县', '3', '637', 'S');
INSERT INTO `ey_region` VALUES ('790', '赞皇县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('802', '无极县', '3', '637', 'W');
INSERT INTO `ey_region` VALUES ('814', '平山县', '3', '637', 'P');
INSERT INTO `ey_region` VALUES ('838', '元氏县', '3', '637', 'Y');
INSERT INTO `ey_region` VALUES ('854', '赵县', '3', '637', 'Z');
INSERT INTO `ey_region` VALUES ('866', '辛集市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('882', '藁城市', '3', '637', 'G');
INSERT INTO `ey_region` VALUES ('898', '晋州市', '3', '637', 'J');
INSERT INTO `ey_region` VALUES ('909', '新乐市', '3', '637', 'X');
INSERT INTO `ey_region` VALUES ('922', '鹿泉市', '3', '637', 'L');
INSERT INTO `ey_region` VALUES ('936', '唐山市', '2', '636', 'T');
INSERT INTO `ey_region` VALUES ('937', '市辖区', '3', '936', 'S');
INSERT INTO `ey_region` VALUES ('938', '路南区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('952', '路北区', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('965', '古冶区', '3', '936', 'G');
INSERT INTO `ey_region` VALUES ('977', '开平区', '3', '936', 'K');
INSERT INTO `ey_region` VALUES ('989', '丰南区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1007', '丰润区', '3', '936', 'F');
INSERT INTO `ey_region` VALUES ('1034', '滦县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1048', '滦南县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1067', '乐亭县', '3', '936', 'L');
INSERT INTO `ey_region` VALUES ('1085', '迁西县', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1104', '玉田县', '3', '936', 'Y');
INSERT INTO `ey_region` VALUES ('1125', '唐海县', '3', '936', 'T');
INSERT INTO `ey_region` VALUES ('1140', '遵化市', '3', '936', 'Z');
INSERT INTO `ey_region` VALUES ('1168', '迁安市', '3', '936', 'Q');
INSERT INTO `ey_region` VALUES ('1188', '秦皇岛市', '2', '636', 'Q');
INSERT INTO `ey_region` VALUES ('1189', '市辖区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1190', '海港区', '3', '1188', 'H');
INSERT INTO `ey_region` VALUES ('1208', '山海关区', '3', '1188', 'S');
INSERT INTO `ey_region` VALUES ('1218', '北戴河区', '3', '1188', 'B');
INSERT INTO `ey_region` VALUES ('1223', '青龙县', '3', '1188', 'Q');
INSERT INTO `ey_region` VALUES ('1249', '昌黎县', '3', '1188', 'C');
INSERT INTO `ey_region` VALUES ('1266', '抚宁县', '3', '1188', 'F');
INSERT INTO `ey_region` VALUES ('1278', '卢龙县', '3', '1188', 'L');
INSERT INTO `ey_region` VALUES ('1291', '邯郸市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('1292', '市辖区', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1293', '邯山区', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1307', '丛台区', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1319', '复兴区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1329', '峰峰矿区', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1339', '邯郸县', '3', '1291', 'H');
INSERT INTO `ey_region` VALUES ('1350', '临漳县', '3', '1291', 'L');
INSERT INTO `ey_region` VALUES ('1365', '成安县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1375', '大名县', '3', '1291', 'D');
INSERT INTO `ey_region` VALUES ('1396', '涉县', '3', '1291', 'S');
INSERT INTO `ey_region` VALUES ('1414', '磁县', '3', '1291', 'C');
INSERT INTO `ey_region` VALUES ('1434', '肥乡县', '3', '1291', 'F');
INSERT INTO `ey_region` VALUES ('1444', '永年县', '3', '1291', 'Y');
INSERT INTO `ey_region` VALUES ('1465', '邱县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1473', '鸡泽县', '3', '1291', 'J');
INSERT INTO `ey_region` VALUES ('1481', '广平县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1489', '馆陶县', '3', '1291', 'G');
INSERT INTO `ey_region` VALUES ('1498', '魏县', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1520', '曲周县', '3', '1291', 'Q');
INSERT INTO `ey_region` VALUES ('1531', '武安市', '3', '1291', 'W');
INSERT INTO `ey_region` VALUES ('1554', '邢台市', '2', '636', 'X');
INSERT INTO `ey_region` VALUES ('1555', '市辖区', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1556', '桥东区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1564', '桥西区', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1572', '邢台县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1593', '临城县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1602', '内邱县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1612', '柏乡县', '3', '1554', 'B');
INSERT INTO `ey_region` VALUES ('1619', '隆尧县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1633', '任县', '3', '1554', 'R');
INSERT INTO `ey_region` VALUES ('1642', '南和县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1651', '宁晋县', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1669', '巨鹿县', '3', '1554', 'J');
INSERT INTO `ey_region` VALUES ('1680', '新河县', '3', '1554', 'X');
INSERT INTO `ey_region` VALUES ('1687', '广宗县', '3', '1554', 'G');
INSERT INTO `ey_region` VALUES ('1696', '平乡县', '3', '1554', 'P');
INSERT INTO `ey_region` VALUES ('1704', '威县', '3', '1554', 'W');
INSERT INTO `ey_region` VALUES ('1721', '清河县', '3', '1554', 'Q');
INSERT INTO `ey_region` VALUES ('1728', '临西县', '3', '1554', 'L');
INSERT INTO `ey_region` VALUES ('1738', '南宫市', '3', '1554', 'N');
INSERT INTO `ey_region` VALUES ('1754', '沙河市', '3', '1554', 'S');
INSERT INTO `ey_region` VALUES ('1772', '保定市', '2', '636', 'B');
INSERT INTO `ey_region` VALUES ('1773', '市辖区', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('1774', '新市区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1787', '北市区', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('1796', '南市区', '3', '1772', 'N');
INSERT INTO `ey_region` VALUES ('1806', '满城区', '3', '1772', 'M');
INSERT INTO `ey_region` VALUES ('1820', '清苑区', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('1839', '涞水县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1856', '阜平县', '3', '1772', 'F');
INSERT INTO `ey_region` VALUES ('1870', '徐水区', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('1885', '定兴县', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('1902', '唐县', '3', '1772', 'T');
INSERT INTO `ey_region` VALUES ('1923', '高阳县', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('1933', '容城县', '3', '1772', 'R');
INSERT INTO `ey_region` VALUES ('1942', '涞源县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('1960', '望都县', '3', '1772', 'W');
INSERT INTO `ey_region` VALUES ('1969', '安新县', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('1982', '易县', '3', '1772', 'Y');
INSERT INTO `ey_region` VALUES ('2010', '曲阳县', '3', '1772', 'Q');
INSERT INTO `ey_region` VALUES ('2029', '蠡县', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('2043', '顺平县', '3', '1772', 'S');
INSERT INTO `ey_region` VALUES ('2054', '博野县', '3', '1772', 'B');
INSERT INTO `ey_region` VALUES ('2062', '雄县', '3', '1772', 'X');
INSERT INTO `ey_region` VALUES ('2072', '涿州市', '3', '1772', 'Z');
INSERT INTO `ey_region` VALUES ('2088', '定州市', '3', '1772', 'D');
INSERT INTO `ey_region` VALUES ('2114', '安国市', '3', '1772', 'A');
INSERT INTO `ey_region` VALUES ('2126', '高碑店市', '3', '1772', 'G');
INSERT INTO `ey_region` VALUES ('2142', '张家口市', '2', '636', 'Z');
INSERT INTO `ey_region` VALUES ('2143', '市辖区', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2144', '桥东区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2154', '桥西区', '3', '2142', 'Q');
INSERT INTO `ey_region` VALUES ('2164', '宣化区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2176', '下花园区', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2183', '宣化县', '3', '2142', 'X');
INSERT INTO `ey_region` VALUES ('2198', '张北县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2220', '康保县', '3', '2142', 'K');
INSERT INTO `ey_region` VALUES ('2237', '沽源县', '3', '2142', 'G');
INSERT INTO `ey_region` VALUES ('2256', '尚义县', '3', '2142', 'S');
INSERT INTO `ey_region` VALUES ('2271', '蔚县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2294', '阳原县', '3', '2142', 'Y');
INSERT INTO `ey_region` VALUES ('2309', '怀安县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2321', '万全县', '3', '2142', 'W');
INSERT INTO `ey_region` VALUES ('2333', '怀来县', '3', '2142', 'H');
INSERT INTO `ey_region` VALUES ('2351', '涿鹿县', '3', '2142', 'Z');
INSERT INTO `ey_region` VALUES ('2369', '赤城县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2388', '崇礼县', '3', '2142', 'C');
INSERT INTO `ey_region` VALUES ('2400', '承德市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2401', '市辖区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2402', '双桥区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2415', '双滦区', '3', '2400', 'S');
INSERT INTO `ey_region` VALUES ('2422', '鹰手营子矿区', '3', '2400', 'Y');
INSERT INTO `ey_region` VALUES ('2427', '承德县', '3', '2400', 'C');
INSERT INTO `ey_region` VALUES ('2453', '兴隆县', '3', '2400', 'X');
INSERT INTO `ey_region` VALUES ('2474', '平泉县', '3', '2400', 'P');
INSERT INTO `ey_region` VALUES ('2494', '滦平县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2517', '隆化县', '3', '2400', 'L');
INSERT INTO `ey_region` VALUES ('2543', '丰宁县', '3', '2400', 'F');
INSERT INTO `ey_region` VALUES ('2570', '宽城县', '3', '2400', 'K');
INSERT INTO `ey_region` VALUES ('2589', '围场县', '3', '2400', 'W');
INSERT INTO `ey_region` VALUES ('2629', '沧州市', '2', '636', 'C');
INSERT INTO `ey_region` VALUES ('2630', '市辖区', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2631', '新华区', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2639', '运河区', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2648', '沧县', '3', '2629', 'C');
INSERT INTO `ey_region` VALUES ('2668', '青县', '3', '2629', 'Q');
INSERT INTO `ey_region` VALUES ('2680', '东光县', '3', '2629', 'D');
INSERT INTO `ey_region` VALUES ('2690', '海兴县', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2701', '盐山县', '3', '2629', 'Y');
INSERT INTO `ey_region` VALUES ('2714', '肃宁县', '3', '2629', 'S');
INSERT INTO `ey_region` VALUES ('2724', '南皮县', '3', '2629', 'N');
INSERT INTO `ey_region` VALUES ('2734', '吴桥县', '3', '2629', 'W');
INSERT INTO `ey_region` VALUES ('2745', '献县', '3', '2629', 'X');
INSERT INTO `ey_region` VALUES ('2765', '孟村县', '3', '2629', 'M');
INSERT INTO `ey_region` VALUES ('2772', '泊头市', '3', '2629', 'B');
INSERT INTO `ey_region` VALUES ('2788', '任邱市', '3', '2629', 'R');
INSERT INTO `ey_region` VALUES ('2809', '黄骅市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2828', '河间市', '3', '2629', 'H');
INSERT INTO `ey_region` VALUES ('2849', '廊坊市', '2', '636', 'L');
INSERT INTO `ey_region` VALUES ('2850', '市辖区', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2851', '安次区', '3', '2849', 'A');
INSERT INTO `ey_region` VALUES ('2862', '广阳区', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2873', '固安县', '3', '2849', 'G');
INSERT INTO `ey_region` VALUES ('2883', '永清县', '3', '2849', 'Y');
INSERT INTO `ey_region` VALUES ('2895', '香河县', '3', '2849', 'X');
INSERT INTO `ey_region` VALUES ('2906', '大城县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2918', '文安县', '3', '2849', 'W');
INSERT INTO `ey_region` VALUES ('2932', '大厂县', '3', '2849', 'D');
INSERT INTO `ey_region` VALUES ('2939', '霸州市', '3', '2849', 'B');
INSERT INTO `ey_region` VALUES ('2953', '三河市', '3', '2849', 'S');
INSERT INTO `ey_region` VALUES ('2968', '衡水市', '2', '636', 'H');
INSERT INTO `ey_region` VALUES ('2969', '市辖区', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('2970', '桃城区', '3', '2968', 'T');
INSERT INTO `ey_region` VALUES ('2983', '枣强县', '3', '2968', 'Z');
INSERT INTO `ey_region` VALUES ('2995', '武邑县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3005', '武强县', '3', '2968', 'W');
INSERT INTO `ey_region` VALUES ('3012', '饶阳县', '3', '2968', 'R');
INSERT INTO `ey_region` VALUES ('3020', '安平县', '3', '2968', 'A');
INSERT INTO `ey_region` VALUES ('3029', '故城县', '3', '2968', 'G');
INSERT INTO `ey_region` VALUES ('3043', '景县', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3060', '阜城县', '3', '2968', 'F');
INSERT INTO `ey_region` VALUES ('3071', '冀州市', '3', '2968', 'J');
INSERT INTO `ey_region` VALUES ('3083', '深州市', '3', '2968', 'S');
INSERT INTO `ey_region` VALUES ('3102', '山西', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('3103', '太原市', '2', '3102', 'T');
INSERT INTO `ey_region` VALUES ('3104', '市辖区', '3', '3103', 'S');
INSERT INTO `ey_region` VALUES ('3105', '小店区(人口含高新经济区)', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3117', '迎泽区', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3126', '杏花岭区', '3', '3103', 'X');
INSERT INTO `ey_region` VALUES ('3140', '尖草坪区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3155', '万柏林区', '3', '3103', 'W');
INSERT INTO `ey_region` VALUES ('3171', '晋源区', '3', '3103', 'J');
INSERT INTO `ey_region` VALUES ('3178', '清徐县', '3', '3103', 'Q');
INSERT INTO `ey_region` VALUES ('3188', '阳曲县', '3', '3103', 'Y');
INSERT INTO `ey_region` VALUES ('3200', '娄烦县', '3', '3103', 'L');
INSERT INTO `ey_region` VALUES ('3209', '古交市', '3', '3103', 'G');
INSERT INTO `ey_region` VALUES ('3224', '大同市', '2', '3102', 'D');
INSERT INTO `ey_region` VALUES ('3225', '市辖区', '3', '3224', 'S');
INSERT INTO `ey_region` VALUES ('3226', '大同市城区', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3241', '矿区', '3', '3224', 'K');
INSERT INTO `ey_region` VALUES ('3266', '南郊区', '3', '3224', 'N');
INSERT INTO `ey_region` VALUES ('3277', '新荣区', '3', '3224', 'X');
INSERT INTO `ey_region` VALUES ('3286', '阳高县', '3', '3224', 'Y');
INSERT INTO `ey_region` VALUES ('3300', '天镇县', '3', '3224', 'T');
INSERT INTO `ey_region` VALUES ('3312', '广灵县', '3', '3224', 'G');
INSERT INTO `ey_region` VALUES ('3322', '灵丘县', '3', '3224', 'L');
INSERT INTO `ey_region` VALUES ('3335', '浑源县', '3', '3224', 'H');
INSERT INTO `ey_region` VALUES ('3354', '左云县', '3', '3224', 'Z');
INSERT INTO `ey_region` VALUES ('3364', '大同县', '3', '3224', 'D');
INSERT INTO `ey_region` VALUES ('3379', '阳泉市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3380', '市辖区', '3', '3379', 'S');
INSERT INTO `ey_region` VALUES ('3381', '城区', '3', '3379', 'C');
INSERT INTO `ey_region` VALUES ('3388', '矿区', '3', '3379', 'K');
INSERT INTO `ey_region` VALUES ('3395', '郊区', '3', '3379', 'J');
INSERT INTO `ey_region` VALUES ('3405', '平定县', '3', '3379', 'P');
INSERT INTO `ey_region` VALUES ('3416', '盂县', '3', '3379', 'Y');
INSERT INTO `ey_region` VALUES ('3431', '长治市', '2', '3102', 'C');
INSERT INTO `ey_region` VALUES ('3432', '市辖区', '3', '3431', 'S');
INSERT INTO `ey_region` VALUES ('3433', '长治市城区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3445', '长治市郊区', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3454', '长治县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3466', '襄垣县', '3', '3431', 'X');
INSERT INTO `ey_region` VALUES ('3478', '屯留县', '3', '3431', 'T');
INSERT INTO `ey_region` VALUES ('3493', '平顺县', '3', '3431', 'P');
INSERT INTO `ey_region` VALUES ('3506', '黎城县', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3516', '壶关县', '3', '3431', 'H');
INSERT INTO `ey_region` VALUES ('3530', '长子县', '3', '3431', 'C');
INSERT INTO `ey_region` VALUES ('3543', '武乡县', '3', '3431', 'W');
INSERT INTO `ey_region` VALUES ('3558', '沁县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3572', '沁源县', '3', '3431', 'Q');
INSERT INTO `ey_region` VALUES ('3587', '潞城市', '3', '3431', 'L');
INSERT INTO `ey_region` VALUES ('3597', '晋城市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3598', '市辖区', '3', '3597', 'S');
INSERT INTO `ey_region` VALUES ('3599', '晋城市城区', '3', '3597', 'J');
INSERT INTO `ey_region` VALUES ('3608', '沁水县', '3', '3597', 'Q');
INSERT INTO `ey_region` VALUES ('3623', '阳城县', '3', '3597', 'Y');
INSERT INTO `ey_region` VALUES ('3642', '陵川县', '3', '3597', 'L');
INSERT INTO `ey_region` VALUES ('3655', '泽州县', '3', '3597', 'Z');
INSERT INTO `ey_region` VALUES ('3673', '高平市', '3', '3597', 'G');
INSERT INTO `ey_region` VALUES ('3690', '朔州市', '2', '3102', 'S');
INSERT INTO `ey_region` VALUES ('3691', '市辖区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3692', '朔城区', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3709', '平鲁区', '3', '3690', 'P');
INSERT INTO `ey_region` VALUES ('3723', '山阴县', '3', '3690', 'S');
INSERT INTO `ey_region` VALUES ('3739', '应县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3752', '右玉县', '3', '3690', 'Y');
INSERT INTO `ey_region` VALUES ('3763', '怀仁县', '3', '3690', 'H');
INSERT INTO `ey_region` VALUES ('3776', '晋中市', '2', '3102', 'J');
INSERT INTO `ey_region` VALUES ('3777', '市辖区', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3778', '榆次区', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3799', '榆社县', '3', '3776', 'Y');
INSERT INTO `ey_region` VALUES ('3810', '左权县', '3', '3776', 'Z');
INSERT INTO `ey_region` VALUES ('3822', '和顺县', '3', '3776', 'H');
INSERT INTO `ey_region` VALUES ('3833', '昔阳县', '3', '3776', 'X');
INSERT INTO `ey_region` VALUES ('3846', '寿阳县', '3', '3776', 'S');
INSERT INTO `ey_region` VALUES ('3861', '太谷县', '3', '3776', 'T');
INSERT INTO `ey_region` VALUES ('3871', '祁县', '3', '3776', 'Q');
INSERT INTO `ey_region` VALUES ('3880', '平遥县', '3', '3776', 'P');
INSERT INTO `ey_region` VALUES ('3895', '灵石县', '3', '3776', 'L');
INSERT INTO `ey_region` VALUES ('3908', '介休市', '3', '3776', 'J');
INSERT INTO `ey_region` VALUES ('3925', '运城市', '2', '3102', 'Y');
INSERT INTO `ey_region` VALUES ('3926', '市辖区', '3', '3925', 'S');
INSERT INTO `ey_region` VALUES ('3927', '盐湖区', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('3950', '临猗县', '3', '3925', 'L');
INSERT INTO `ey_region` VALUES ('3967', '万荣县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3982', '闻喜县', '3', '3925', 'W');
INSERT INTO `ey_region` VALUES ('3996', '稷山县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4004', '新绛县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4013', '绛县', '3', '3925', 'J');
INSERT INTO `ey_region` VALUES ('4024', '垣曲县', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4036', '夏县', '3', '3925', 'X');
INSERT INTO `ey_region` VALUES ('4048', '平陆县', '3', '3925', 'P');
INSERT INTO `ey_region` VALUES ('4059', '芮城县', '3', '3925', 'R');
INSERT INTO `ey_region` VALUES ('4070', '永济市', '3', '3925', 'Y');
INSERT INTO `ey_region` VALUES ('4082', '河津市', '3', '3925', 'H');
INSERT INTO `ey_region` VALUES ('4093', '忻州市', '2', '3102', 'X');
INSERT INTO `ey_region` VALUES ('4094', '市辖区', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4095', '忻府区', '3', '4093', 'X');
INSERT INTO `ey_region` VALUES ('4116', '定襄县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4126', '五台县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4146', '代县', '3', '4093', 'D');
INSERT INTO `ey_region` VALUES ('4158', '繁峙县', '3', '4093', 'F');
INSERT INTO `ey_region` VALUES ('4172', '宁武县', '3', '4093', 'N');
INSERT INTO `ey_region` VALUES ('4189', '静乐县', '3', '4093', 'J');
INSERT INTO `ey_region` VALUES ('4204', '神池县', '3', '4093', 'S');
INSERT INTO `ey_region` VALUES ('4215', '五寨县', '3', '4093', 'W');
INSERT INTO `ey_region` VALUES ('4228', '岢岚县', '3', '4093', 'K');
INSERT INTO `ey_region` VALUES ('4241', '河曲县', '3', '4093', 'H');
INSERT INTO `ey_region` VALUES ('4255', '保德县', '3', '4093', 'B');
INSERT INTO `ey_region` VALUES ('4269', '偏关县', '3', '4093', 'P');
INSERT INTO `ey_region` VALUES ('4280', '原平市', '3', '4093', 'Y');
INSERT INTO `ey_region` VALUES ('4304', '临汾市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4305', '市辖区', '3', '4304', 'S');
INSERT INTO `ey_region` VALUES ('4306', '尧都区', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4333', '曲沃县', '3', '4304', 'Q');
INSERT INTO `ey_region` VALUES ('4341', '翼城县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4352', '襄汾县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4366', '洪洞县', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4383', '古县', '3', '4304', 'G');
INSERT INTO `ey_region` VALUES ('4391', '安泽县', '3', '4304', 'A');
INSERT INTO `ey_region` VALUES ('4399', '浮山县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4409', '吉县', '3', '4304', 'J');
INSERT INTO `ey_region` VALUES ('4418', '乡宁县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4429', '大宁县', '3', '4304', 'D');
INSERT INTO `ey_region` VALUES ('4436', '隰县', '3', '4304', 'X');
INSERT INTO `ey_region` VALUES ('4445', '永和县', '3', '4304', 'Y');
INSERT INTO `ey_region` VALUES ('4453', '蒲县', '3', '4304', 'P');
INSERT INTO `ey_region` VALUES ('4463', '汾西县', '3', '4304', 'F');
INSERT INTO `ey_region` VALUES ('4472', '侯马市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4481', '霍州市', '3', '4304', 'H');
INSERT INTO `ey_region` VALUES ('4494', '吕梁市', '2', '3102', 'L');
INSERT INTO `ey_region` VALUES ('4495', '市辖区', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4496', '离石区', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4509', '文水县', '3', '4494', 'W');
INSERT INTO `ey_region` VALUES ('4522', '交城县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4533', '兴县', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4551', '临县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4575', '柳林县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4591', '石楼县', '3', '4494', 'S');
INSERT INTO `ey_region` VALUES ('4601', '岚县', '3', '4494', 'L');
INSERT INTO `ey_region` VALUES ('4614', '方山县', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4622', '中阳县', '3', '4494', 'Z');
INSERT INTO `ey_region` VALUES ('4630', '交口县', '3', '4494', 'J');
INSERT INTO `ey_region` VALUES ('4638', '孝义市', '3', '4494', 'X');
INSERT INTO `ey_region` VALUES ('4655', '汾阳市', '3', '4494', 'F');
INSERT INTO `ey_region` VALUES ('4670', '内蒙古', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('4671', '呼和浩特市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('4672', '市辖区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4673', '新城区', '3', '4671', 'X');
INSERT INTO `ey_region` VALUES ('4684', '回民区', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4693', '玉泉区', '3', '4671', 'Y');
INSERT INTO `ey_region` VALUES ('4702', '赛罕区', '3', '4671', 'S');
INSERT INTO `ey_region` VALUES ('4715', '土左旗', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4727', '托克托县', '3', '4671', 'T');
INSERT INTO `ey_region` VALUES ('4733', '和林格尔县', '3', '4671', 'H');
INSERT INTO `ey_region` VALUES ('4742', '清水河县', '3', '4671', 'Q');
INSERT INTO `ey_region` VALUES ('4749', '武川县', '3', '4671', 'W');
INSERT INTO `ey_region` VALUES ('4759', '包头市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('4760', '市辖区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4761', '东河区', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4775', '昆都仑区', '3', '4759', 'K');
INSERT INTO `ey_region` VALUES ('4791', '青山区', '3', '4759', 'Q');
INSERT INTO `ey_region` VALUES ('4803', '石拐区', '3', '4759', 'S');
INSERT INTO `ey_region` VALUES ('4810', '白云鄂博矿区', '3', '4759', 'B');
INSERT INTO `ey_region` VALUES ('4813', '九原区', '3', '4759', 'J');
INSERT INTO `ey_region` VALUES ('4823', '土默特右旗', '3', '4759', 'T');
INSERT INTO `ey_region` VALUES ('4833', '固阳县', '3', '4759', 'G');
INSERT INTO `ey_region` VALUES ('4840', '达茂联合旗', '3', '4759', 'D');
INSERT INTO `ey_region` VALUES ('4849', '乌海市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('4850', '乌海市辖区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4851', '海勃湾区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4859', '海南区', '3', '4849', 'H');
INSERT INTO `ey_region` VALUES ('4865', '乌达区', '3', '4849', 'W');
INSERT INTO `ey_region` VALUES ('4874', '赤峰市', '2', '4670', 'C');
INSERT INTO `ey_region` VALUES ('4875', '市辖区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4876', '红山区', '3', '4874', 'H');
INSERT INTO `ey_region` VALUES ('4888', '元宝山区', '3', '4874', 'Y');
INSERT INTO `ey_region` VALUES ('4896', '松山区', '3', '4874', 'S');
INSERT INTO `ey_region` VALUES ('4919', '阿鲁科尔沁旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('4932', '巴林左旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4944', '巴林右旗', '3', '4874', 'B');
INSERT INTO `ey_region` VALUES ('4953', '林西县', '3', '4874', 'L');
INSERT INTO `ey_region` VALUES ('4963', '克什克腾旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4975', '翁牛特旗', '3', '4874', 'W');
INSERT INTO `ey_region` VALUES ('4988', '喀喇沁旗', '3', '4874', 'K');
INSERT INTO `ey_region` VALUES ('4999', '宁城县', '3', '4874', 'N');
INSERT INTO `ey_region` VALUES ('5013', '敖汉旗', '3', '4874', 'A');
INSERT INTO `ey_region` VALUES ('5029', '通辽市', '2', '4670', 'T');
INSERT INTO `ey_region` VALUES ('5030', '市辖区', '3', '5029', 'S');
INSERT INTO `ey_region` VALUES ('5031', '科尔沁区', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5062', '科尔沁左翼中旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5079', '科左后旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5104', '开鲁县', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5118', '库伦旗', '3', '5029', 'K');
INSERT INTO `ey_region` VALUES ('5125', '奈曼旗', '3', '5029', 'N');
INSERT INTO `ey_region` VALUES ('5139', '扎鲁特旗', '3', '5029', 'Z');
INSERT INTO `ey_region` VALUES ('5155', '霍林郭勒市', '3', '5029', 'H');
INSERT INTO `ey_region` VALUES ('5162', '鄂尔多斯市', '2', '4670', 'E');
INSERT INTO `ey_region` VALUES ('5163', '东胜区', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5176', '达拉特旗', '3', '5162', 'D');
INSERT INTO `ey_region` VALUES ('5185', '准格尔旗', '3', '5162', 'Z');
INSERT INTO `ey_region` VALUES ('5195', '鄂托克前旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5201', '鄂托克旗', '3', '5162', 'E');
INSERT INTO `ey_region` VALUES ('5210', '杭锦旗', '3', '5162', 'H');
INSERT INTO `ey_region` VALUES ('5219', '乌审旗', '3', '5162', 'W');
INSERT INTO `ey_region` VALUES ('5228', '伊金霍洛旗', '3', '5162', 'Y');
INSERT INTO `ey_region` VALUES ('5236', '呼伦贝尔市', '2', '4670', 'H');
INSERT INTO `ey_region` VALUES ('5237', '市辖区', '3', '5236', 'S');
INSERT INTO `ey_region` VALUES ('5238', '海拉尔区', '3', '5236', 'H');
INSERT INTO `ey_region` VALUES ('5249', '阿荣旗', '3', '5236', 'A');
INSERT INTO `ey_region` VALUES ('5262', '莫力达瓦旗', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5277', '鄂伦春旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5303', '鄂温旗', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5314', '陈巴尔虎旗镇', '3', '5236', 'C');
INSERT INTO `ey_region` VALUES ('5323', '新巴尔虎左旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5330', '新巴尔虎右旗', '3', '5236', 'X');
INSERT INTO `ey_region` VALUES ('5337', '满洲里市', '3', '5236', 'M');
INSERT INTO `ey_region` VALUES ('5354', '牙克石市', '3', '5236', 'Y');
INSERT INTO `ey_region` VALUES ('5371', '扎兰屯市', '3', '5236', 'Z');
INSERT INTO `ey_region` VALUES ('5397', '额尔古纳市', '3', '5236', 'E');
INSERT INTO `ey_region` VALUES ('5410', '根河市', '3', '5236', 'G');
INSERT INTO `ey_region` VALUES ('5418', '巴彦淖尔市', '2', '4670', 'B');
INSERT INTO `ey_region` VALUES ('5419', '市辖区', '3', '5418', 'S');
INSERT INTO `ey_region` VALUES ('5420', '临河区', '3', '5418', 'L');
INSERT INTO `ey_region` VALUES ('5440', '五原县', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5450', '磴口县', '3', '5418', 'D');
INSERT INTO `ey_region` VALUES ('5461', '乌拉特前旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5477', '乌拉特中旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5489', '乌拉特后旗', '3', '5418', 'W');
INSERT INTO `ey_region` VALUES ('5495', '杭锦后旗', '3', '5418', 'H');
INSERT INTO `ey_region` VALUES ('5505', '乌兰察布市', '2', '4670', 'W');
INSERT INTO `ey_region` VALUES ('5506', '市辖区', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5507', '集宁区', '3', '5505', 'J');
INSERT INTO `ey_region` VALUES ('5518', '卓资县', '3', '5505', 'Z');
INSERT INTO `ey_region` VALUES ('5526', '化德县', '3', '5505', 'H');
INSERT INTO `ey_region` VALUES ('5532', '商都县', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5542', '兴和县', '3', '5505', 'X');
INSERT INTO `ey_region` VALUES ('5551', '凉城县', '3', '5505', 'L');
INSERT INTO `ey_region` VALUES ('5562', '察哈尔右翼前旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5571', '察右中旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5582', '察哈尔右翼后旗', '3', '5505', 'C');
INSERT INTO `ey_region` VALUES ('5590', '四子王旗', '3', '5505', 'S');
INSERT INTO `ey_region` VALUES ('5603', '丰镇市', '3', '5505', 'F');
INSERT INTO `ey_region` VALUES ('5616', '兴安盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5617', '乌兰浩特市', '3', '5616', 'W');
INSERT INTO `ey_region` VALUES ('5629', '阿尔山市', '3', '5616', 'A');
INSERT INTO `ey_region` VALUES ('5636', '科右前旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5655', '科右中旗', '3', '5616', 'K');
INSERT INTO `ey_region` VALUES ('5677', '扎赉特旗', '3', '5616', 'Z');
INSERT INTO `ey_region` VALUES ('5692', '突泉县', '3', '5616', 'T');
INSERT INTO `ey_region` VALUES ('5702', '锡林郭勒盟', '2', '4670', 'X');
INSERT INTO `ey_region` VALUES ('5703', '二连浩特市', '3', '5702', 'E');
INSERT INTO `ey_region` VALUES ('5709', '锡林浩特市', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5723', '阿巴嘎旗', '3', '5702', 'A');
INSERT INTO `ey_region` VALUES ('5731', '苏尼特左旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5738', '苏尼特右旗', '3', '5702', 'S');
INSERT INTO `ey_region` VALUES ('5745', '东乌珠穆沁旗', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5758', '西乌珠穆沁旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5766', '太仆寺旗', '3', '5702', 'T');
INSERT INTO `ey_region` VALUES ('5774', '镶黄旗', '3', '5702', 'X');
INSERT INTO `ey_region` VALUES ('5778', '正镶白旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5785', '正蓝旗', '3', '5702', 'Z');
INSERT INTO `ey_region` VALUES ('5794', '多伦县', '3', '5702', 'D');
INSERT INTO `ey_region` VALUES ('5799', '阿拉善盟', '2', '4670', 'A');
INSERT INTO `ey_region` VALUES ('5800', '阿拉善左旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5814', '阿拉善右旗', '3', '5799', 'A');
INSERT INTO `ey_region` VALUES ('5820', '额济纳旗', '3', '5799', 'E');
INSERT INTO `ey_region` VALUES ('5827', '辽宁省', '1', '0', 'L');
INSERT INTO `ey_region` VALUES ('5828', '沈阳市', '2', '5827', 'S');
INSERT INTO `ey_region` VALUES ('5829', '市辖区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5830', '和平区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5848', '沈河区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5859', '大东区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5873', '皇姑区', '3', '5828', 'H');
INSERT INTO `ey_region` VALUES ('5894', '铁西区', '3', '5828', 'T');
INSERT INTO `ey_region` VALUES ('5909', '苏家屯区', '3', '5828', 'S');
INSERT INTO `ey_region` VALUES ('5934', '东陵区', '3', '5828', 'D');
INSERT INTO `ey_region` VALUES ('5954', '新城子区', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('5975', '于洪区', '3', '5828', 'Y');
INSERT INTO `ey_region` VALUES ('5998', '辽中县', '3', '5828', 'L');
INSERT INTO `ey_region` VALUES ('6020', '康平县', '3', '5828', 'K');
INSERT INTO `ey_region` VALUES ('6038', '法库县', '3', '5828', 'F');
INSERT INTO `ey_region` VALUES ('6058', '新民市', '3', '5828', 'X');
INSERT INTO `ey_region` VALUES ('6088', '大连市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6089', '市辖区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6090', '中山区', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6099', '西岗区', '3', '6088', 'X');
INSERT INTO `ey_region` VALUES ('6107', '沙河口区', '3', '6088', 'S');
INSERT INTO `ey_region` VALUES ('6117', '甘井子区', '3', '6088', 'G');
INSERT INTO `ey_region` VALUES ('6137', '旅顺口区', '3', '6088', 'L');
INSERT INTO `ey_region` VALUES ('6153', '金州区', '3', '6088', 'J');
INSERT INTO `ey_region` VALUES ('6178', '长海县', '3', '6088', 'C');
INSERT INTO `ey_region` VALUES ('6184', '瓦房店市', '3', '6088', 'W');
INSERT INTO `ey_region` VALUES ('6217', '普兰店市', '3', '6088', 'P');
INSERT INTO `ey_region` VALUES ('6239', '庄河市', '3', '6088', 'Z');
INSERT INTO `ey_region` VALUES ('6266', '鞍山市', '2', '5827', 'A');
INSERT INTO `ey_region` VALUES ('6267', '市辖区', '3', '6266', 'S');
INSERT INTO `ey_region` VALUES ('6268', '铁东区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6282', '铁西区', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6293', '立山区', '3', '6266', 'L');
INSERT INTO `ey_region` VALUES ('6303', '千山区', '3', '6266', 'Q');
INSERT INTO `ey_region` VALUES ('6316', '台安县', '3', '6266', 'T');
INSERT INTO `ey_region` VALUES ('6331', '岫岩县', '3', '6266', 'X');
INSERT INTO `ey_region` VALUES ('6354', '海城市', '3', '6266', 'H');
INSERT INTO `ey_region` VALUES ('6384', '抚顺市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6385', '市辖区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6386', '新抚区', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6395', '东洲区', '3', '6384', 'D');
INSERT INTO `ey_region` VALUES ('6409', '望花区', '3', '6384', 'W');
INSERT INTO `ey_region` VALUES ('6422', '顺城区', '3', '6384', 'S');
INSERT INTO `ey_region` VALUES ('6432', '抚顺县', '3', '6384', 'F');
INSERT INTO `ey_region` VALUES ('6445', '新宾县', '3', '6384', 'X');
INSERT INTO `ey_region` VALUES ('6461', '清原县', '3', '6384', 'Q');
INSERT INTO `ey_region` VALUES ('6476', '本溪市', '2', '5827', 'B');
INSERT INTO `ey_region` VALUES ('6477', '市辖区', '3', '6476', 'S');
INSERT INTO `ey_region` VALUES ('6478', '平山区', '3', '6476', 'P');
INSERT INTO `ey_region` VALUES ('6488', '溪湖区', '3', '6476', 'X');
INSERT INTO `ey_region` VALUES ('6499', '明山区', '3', '6476', 'M');
INSERT INTO `ey_region` VALUES ('6509', '南芬区', '3', '6476', 'N');
INSERT INTO `ey_region` VALUES ('6515', '本溪县', '3', '6476', 'B');
INSERT INTO `ey_region` VALUES ('6528', '桓仁县', '3', '6476', 'H');
INSERT INTO `ey_region` VALUES ('6542', '丹东市', '2', '5827', 'D');
INSERT INTO `ey_region` VALUES ('6543', '市辖区', '3', '6542', 'S');
INSERT INTO `ey_region` VALUES ('6544', '元宝区', '3', '6542', 'Y');
INSERT INTO `ey_region` VALUES ('6552', '振兴区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6563', '振安区', '3', '6542', 'Z');
INSERT INTO `ey_region` VALUES ('6573', '宽甸县', '3', '6542', 'K');
INSERT INTO `ey_region` VALUES ('6596', '东港市', '3', '6542', 'D');
INSERT INTO `ey_region` VALUES ('6621', '凤城市', '3', '6542', 'F');
INSERT INTO `ey_region` VALUES ('6643', '锦州市', '2', '5827', 'J');
INSERT INTO `ey_region` VALUES ('6644', '市辖区', '3', '6643', 'S');
INSERT INTO `ey_region` VALUES ('6645', '古塔区', '3', '6643', 'G');
INSERT INTO `ey_region` VALUES ('6655', '凌河区', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6668', '太和区', '3', '6643', 'T');
INSERT INTO `ey_region` VALUES ('6683', '黑山县', '3', '6643', 'H');
INSERT INTO `ey_region` VALUES ('6706', '义县', '3', '6643', 'Y');
INSERT INTO `ey_region` VALUES ('6725', '凌海市', '3', '6643', 'L');
INSERT INTO `ey_region` VALUES ('6750', '北镇市', '3', '6643', 'B');
INSERT INTO `ey_region` VALUES ('6771', '营口市', '2', '5827', 'Y');
INSERT INTO `ey_region` VALUES ('6772', '市辖区', '3', '6771', 'S');
INSERT INTO `ey_region` VALUES ('6773', '站前区', '3', '6771', 'Z');
INSERT INTO `ey_region` VALUES ('6781', '西市区', '3', '6771', 'X');
INSERT INTO `ey_region` VALUES ('6789', '鲅鱼圈区', '3', '6771', 'B');
INSERT INTO `ey_region` VALUES ('6797', '老边区', '3', '6771', 'L');
INSERT INTO `ey_region` VALUES ('6804', '盖州市', '3', '6771', 'G');
INSERT INTO `ey_region` VALUES ('6832', '大石桥市', '3', '6771', 'D');
INSERT INTO `ey_region` VALUES ('6851', '阜新市', '2', '5827', 'F');
INSERT INTO `ey_region` VALUES ('6852', '市辖区', '3', '6851', 'S');
INSERT INTO `ey_region` VALUES ('6853', '海州区', '3', '6851', 'H');
INSERT INTO `ey_region` VALUES ('6865', '新邱区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6871', '太平区', '3', '6851', 'T');
INSERT INTO `ey_region` VALUES ('6878', '清河门区', '3', '6851', 'Q');
INSERT INTO `ey_region` VALUES ('6885', '细河区', '3', '6851', 'X');
INSERT INTO `ey_region` VALUES ('6893', '阜新县', '3', '6851', 'F');
INSERT INTO `ey_region` VALUES ('6930', '彰武县', '3', '6851', 'Z');
INSERT INTO `ey_region` VALUES ('6955', '辽阳市', '2', '5827', 'L');
INSERT INTO `ey_region` VALUES ('6956', '市辖区', '3', '6955', 'S');
INSERT INTO `ey_region` VALUES ('6957', '白塔区', '3', '6955', 'B');
INSERT INTO `ey_region` VALUES ('6964', '文圣区', '3', '6955', 'W');
INSERT INTO `ey_region` VALUES ('6971', '宏伟区', '3', '6955', 'H');
INSERT INTO `ey_region` VALUES ('6977', '弓长岭区', '3', '6955', 'G');
INSERT INTO `ey_region` VALUES ('6983', '太子河区', '3', '6955', 'T');
INSERT INTO `ey_region` VALUES ('6989', '辽阳县', '3', '6955', 'L');
INSERT INTO `ey_region` VALUES ('7007', '灯塔市', '3', '6955', 'D');
INSERT INTO `ey_region` VALUES ('7024', '盘锦市', '2', '5827', 'P');
INSERT INTO `ey_region` VALUES ('7025', '市辖区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7026', '双台子区', '3', '7024', 'S');
INSERT INTO `ey_region` VALUES ('7036', '兴隆台区', '3', '7024', 'X');
INSERT INTO `ey_region` VALUES ('7055', '大洼县', '3', '7024', 'D');
INSERT INTO `ey_region` VALUES ('7072', '盘山县', '3', '7024', 'P');
INSERT INTO `ey_region` VALUES ('7088', '铁岭市', '2', '5827', 'T');
INSERT INTO `ey_region` VALUES ('7089', '市辖区', '3', '7088', 'S');
INSERT INTO `ey_region` VALUES ('7090', '银州区', '3', '7088', 'Y');
INSERT INTO `ey_region` VALUES ('7099', '清河区', '3', '7088', 'Q');
INSERT INTO `ey_region` VALUES ('7105', '铁岭县', '3', '7088', 'T');
INSERT INTO `ey_region` VALUES ('7121', '西丰县', '3', '7088', 'X');
INSERT INTO `ey_region` VALUES ('7140', '昌图县', '3', '7088', 'C');
INSERT INTO `ey_region` VALUES ('7180', '调兵山市', '3', '7088', 'D');
INSERT INTO `ey_region` VALUES ('7186', '开原市', '3', '7088', 'K');
INSERT INTO `ey_region` VALUES ('7208', '朝阳市', '2', '5827', 'C');
INSERT INTO `ey_region` VALUES ('7209', '市辖区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7210', '双塔区', '3', '7208', 'S');
INSERT INTO `ey_region` VALUES ('7225', '龙城区', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7238', '朝阳县', '3', '7208', 'C');
INSERT INTO `ey_region` VALUES ('7267', '建平县', '3', '7208', 'J');
INSERT INTO `ey_region` VALUES ('7299', '喀喇沁左翼县', '3', '7208', 'K');
INSERT INTO `ey_region` VALUES ('7322', '北票市', '3', '7208', 'B');
INSERT INTO `ey_region` VALUES ('7360', '凌源市', '3', '7208', 'L');
INSERT INTO `ey_region` VALUES ('7391', '葫芦岛市', '2', '5827', 'H');
INSERT INTO `ey_region` VALUES ('7392', '市辖区', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7393', '连山区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7419', '龙港区', '3', '7391', 'L');
INSERT INTO `ey_region` VALUES ('7433', '南票区', '3', '7391', 'N');
INSERT INTO `ey_region` VALUES ('7446', '绥中县', '3', '7391', 'S');
INSERT INTO `ey_region` VALUES ('7474', '建昌县', '3', '7391', 'J');
INSERT INTO `ey_region` VALUES ('7503', '兴城市', '3', '7391', 'X');
INSERT INTO `ey_region` VALUES ('7531', '吉林省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('7532', '长春市', '2', '7531', 'C');
INSERT INTO `ey_region` VALUES ('7533', '长春市辖区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7534', '南关区', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7552', '宽城区', '3', '7532', 'K');
INSERT INTO `ey_region` VALUES ('7569', '朝阳区', '3', '7532', 'C');
INSERT INTO `ey_region` VALUES ('7582', '二道区', '3', '7532', 'E');
INSERT INTO `ey_region` VALUES ('7597', '绿园区', '3', '7532', 'L');
INSERT INTO `ey_region` VALUES ('7610', '双阳区', '3', '7532', 'S');
INSERT INTO `ey_region` VALUES ('7619', '农安县', '3', '7532', 'N');
INSERT INTO `ey_region` VALUES ('7642', '九台市', '3', '7532', 'J');
INSERT INTO `ey_region` VALUES ('7658', '榆树市', '3', '7532', 'Y');
INSERT INTO `ey_region` VALUES ('7687', '德惠市', '3', '7532', 'D');
INSERT INTO `ey_region` VALUES ('7706', '吉林市', '2', '7531', 'J');
INSERT INTO `ey_region` VALUES ('7707', '吉林市辖区', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7708', '昌邑区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7731', '龙潭区', '3', '7706', 'L');
INSERT INTO `ey_region` VALUES ('7752', '船营区', '3', '7706', 'C');
INSERT INTO `ey_region` VALUES ('7768', '丰满区', '3', '7706', 'F');
INSERT INTO `ey_region` VALUES ('7781', '永吉县', '3', '7706', 'Y');
INSERT INTO `ey_region` VALUES ('7792', '蛟河市', '3', '7706', 'J');
INSERT INTO `ey_region` VALUES ('7810', '桦甸市', '3', '7706', 'H');
INSERT INTO `ey_region` VALUES ('7828', '舒兰市', '3', '7706', 'S');
INSERT INTO `ey_region` VALUES ('7849', '磐石市', '3', '7706', 'P');
INSERT INTO `ey_region` VALUES ('7868', '四平市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('7869', '四平市辖区', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7870', '铁西区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7878', '铁东区', '3', '7868', 'T');
INSERT INTO `ey_region` VALUES ('7892', '梨树县', '3', '7868', 'L');
INSERT INTO `ey_region` VALUES ('7916', '伊通县', '3', '7868', 'Y');
INSERT INTO `ey_region` VALUES ('7933', '公主岭市', '3', '7868', 'G');
INSERT INTO `ey_region` VALUES ('7964', '双辽市', '3', '7868', 'S');
INSERT INTO `ey_region` VALUES ('7986', '辽源市', '2', '7531', 'L');
INSERT INTO `ey_region` VALUES ('7987', '辽源市辖区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('7988', '龙山区', '3', '7986', 'L');
INSERT INTO `ey_region` VALUES ('8000', '西安区', '3', '7986', 'X');
INSERT INTO `ey_region` VALUES ('8008', '东丰县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8023', '东辽县', '3', '7986', 'D');
INSERT INTO `ey_region` VALUES ('8037', '通化市', '2', '7531', 'T');
INSERT INTO `ey_region` VALUES ('8038', '通化市辖区', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8039', '东昌区', '3', '8037', 'D');
INSERT INTO `ey_region` VALUES ('8051', '二道江区', '3', '8037', 'E');
INSERT INTO `ey_region` VALUES ('8058', '通化县', '3', '8037', 'T');
INSERT INTO `ey_region` VALUES ('8076', '辉南县', '3', '8037', 'H');
INSERT INTO `ey_region` VALUES ('8088', '柳河县', '3', '8037', 'L');
INSERT INTO `ey_region` VALUES ('8104', '梅河口市', '3', '8037', 'M');
INSERT INTO `ey_region` VALUES ('8129', '集安市', '3', '8037', 'J');
INSERT INTO `ey_region` VALUES ('8144', '白山市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8145', '白山市辖区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8146', '八道江区', '3', '8144', 'B');
INSERT INTO `ey_region` VALUES ('8159', '江源区', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8168', '抚松县', '3', '8144', 'F');
INSERT INTO `ey_region` VALUES ('8183', '靖宇县', '3', '8144', 'J');
INSERT INTO `ey_region` VALUES ('8192', '长白县', '3', '8144', 'C');
INSERT INTO `ey_region` VALUES ('8202', '临江市', '3', '8144', 'L');
INSERT INTO `ey_region` VALUES ('8216', '松原市', '2', '7531', 'S');
INSERT INTO `ey_region` VALUES ('8217', '松原市辖区', '3', '8216', 'S');
INSERT INTO `ey_region` VALUES ('8218', '宁江区', '3', '8216', 'N');
INSERT INTO `ey_region` VALUES ('8239', '前郭县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8266', '长岭县', '3', '8216', 'C');
INSERT INTO `ey_region` VALUES ('8300', '乾安县', '3', '8216', 'Q');
INSERT INTO `ey_region` VALUES ('8311', '扶余县', '3', '8216', 'F');
INSERT INTO `ey_region` VALUES ('8333', '白城市', '2', '7531', 'B');
INSERT INTO `ey_region` VALUES ('8334', '白城市辖区', '3', '8333', 'B');
INSERT INTO `ey_region` VALUES ('8335', '洮北区', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8362', '镇赉县', '3', '8333', 'Z');
INSERT INTO `ey_region` VALUES ('8375', '通榆县', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8393', '洮南市', '3', '8333', 'T');
INSERT INTO `ey_region` VALUES ('8420', '大安市', '3', '8333', 'D');
INSERT INTO `ey_region` VALUES ('8445', '延边州', '2', '7531', 'Y');
INSERT INTO `ey_region` VALUES ('8446', '延吉市', '3', '8445', 'Y');
INSERT INTO `ey_region` VALUES ('8456', '图们市', '3', '8445', 'T');
INSERT INTO `ey_region` VALUES ('8464', '敦化市', '3', '8445', 'D');
INSERT INTO `ey_region` VALUES ('8489', '珲春市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8504', '龙井市', '3', '8445', 'L');
INSERT INTO `ey_region` VALUES ('8515', '和龙市', '3', '8445', 'H');
INSERT INTO `ey_region` VALUES ('8530', '汪清县', '3', '8445', 'W');
INSERT INTO `ey_region` VALUES ('8545', '安图县', '3', '8445', 'A');
INSERT INTO `ey_region` VALUES ('8558', '黑龙江省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('8559', '哈尔滨市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('8560', '市辖区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8561', '道里区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8585', '南岗区', '3', '8559', 'N');
INSERT INTO `ey_region` VALUES ('8606', '道外区', '3', '8559', 'D');
INSERT INTO `ey_region` VALUES ('8633', '平房区', '3', '8559', 'P');
INSERT INTO `ey_region` VALUES ('8642', '松北区', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8650', '香坊区', '3', '8559', 'X');
INSERT INTO `ey_region` VALUES ('8676', '呼兰区', '3', '8559', 'H');
INSERT INTO `ey_region` VALUES ('8694', '阿城区', '3', '8559', 'A');
INSERT INTO `ey_region` VALUES ('8714', '依兰县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8729', '方正县', '3', '8559', 'F');
INSERT INTO `ey_region` VALUES ('8740', '宾县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8758', '巴彦县', '3', '8559', 'B');
INSERT INTO `ey_region` VALUES ('8778', '木兰县', '3', '8559', 'M');
INSERT INTO `ey_region` VALUES ('8788', '通河县', '3', '8559', 'T');
INSERT INTO `ey_region` VALUES ('8800', '延寿县', '3', '8559', 'Y');
INSERT INTO `ey_region` VALUES ('8812', '双城市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8838', '尚志市', '3', '8559', 'S');
INSERT INTO `ey_region` VALUES ('8858', '五常市', '3', '8559', 'W');
INSERT INTO `ey_region` VALUES ('8884', '齐齐哈尔市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('8885', '市辖区', '3', '8884', 'S');
INSERT INTO `ey_region` VALUES ('8886', '龙沙区', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8894', '建华区', '3', '8884', 'J');
INSERT INTO `ey_region` VALUES ('8901', '铁锋区', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8911', '昂昂溪区', '3', '8884', 'A');
INSERT INTO `ey_region` VALUES ('8918', '富拉尔基区', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('8928', '碾子山区', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('8934', '梅里斯达斡尔族区', '3', '8884', 'M');
INSERT INTO `ey_region` VALUES ('8943', '龙江县', '3', '8884', 'L');
INSERT INTO `ey_region` VALUES ('8958', '依安县', '3', '8884', 'Y');
INSERT INTO `ey_region` VALUES ('8976', '泰来县', '3', '8884', 'T');
INSERT INTO `ey_region` VALUES ('8998', '甘南县', '3', '8884', 'G');
INSERT INTO `ey_region` VALUES ('9011', '富裕县', '3', '8884', 'F');
INSERT INTO `ey_region` VALUES ('9024', '克山县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9048', '克东县', '3', '8884', 'K');
INSERT INTO `ey_region` VALUES ('9067', '拜泉县', '3', '8884', 'B');
INSERT INTO `ey_region` VALUES ('9084', '讷河市', '3', '8884', 'N');
INSERT INTO `ey_region` VALUES ('9117', '鸡西市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9118', '市辖区', '3', '9117', 'S');
INSERT INTO `ey_region` VALUES ('9119', '鸡冠区', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9129', '恒山区', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9139', '滴道区', '3', '9117', 'D');
INSERT INTO `ey_region` VALUES ('9146', '梨树区', '3', '9117', 'L');
INSERT INTO `ey_region` VALUES ('9153', '城子河区', '3', '9117', 'C');
INSERT INTO `ey_region` VALUES ('9161', '麻山区', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9164', '鸡东县', '3', '9117', 'J');
INSERT INTO `ey_region` VALUES ('9178', '虎林市', '3', '9117', 'H');
INSERT INTO `ey_region` VALUES ('9199', '密山市', '3', '9117', 'M');
INSERT INTO `ey_region` VALUES ('9222', '鹤岗市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('9223', '市辖区', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9224', '向阳区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9230', '工农区', '3', '9222', 'G');
INSERT INTO `ey_region` VALUES ('9237', '南山区', '3', '9222', 'N');
INSERT INTO `ey_region` VALUES ('9244', '兴安区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9250', '东山区', '3', '9222', 'D');
INSERT INTO `ey_region` VALUES ('9261', '兴山区', '3', '9222', 'X');
INSERT INTO `ey_region` VALUES ('9266', '萝北县', '3', '9222', 'L');
INSERT INTO `ey_region` VALUES ('9283', '绥滨县', '3', '9222', 'S');
INSERT INTO `ey_region` VALUES ('9296', '双鸭山市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('9297', '市辖区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9298', '尖山区', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9307', '岭东区', '3', '9296', 'L');
INSERT INTO `ey_region` VALUES ('9317', '四方台区', '3', '9296', 'S');
INSERT INTO `ey_region` VALUES ('9323', '宝山区', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9335', '集贤县', '3', '9296', 'J');
INSERT INTO `ey_region` VALUES ('9356', '友谊县', '3', '9296', 'Y');
INSERT INTO `ey_region` VALUES ('9370', '宝清县', '3', '9296', 'B');
INSERT INTO `ey_region` VALUES ('9393', '饶河县', '3', '9296', 'R');
INSERT INTO `ey_region` VALUES ('9419', '大庆市', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('9420', '市辖区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9421', '萨尔图区', '3', '9419', 'S');
INSERT INTO `ey_region` VALUES ('9431', '龙凤区', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9440', '让胡路区', '3', '9419', 'R');
INSERT INTO `ey_region` VALUES ('9451', '红岗区', '3', '9419', 'H');
INSERT INTO `ey_region` VALUES ('9458', '大同区', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9474', '肇州县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9489', '肇源县', '3', '9419', 'Z');
INSERT INTO `ey_region` VALUES ('9514', '林甸县', '3', '9419', 'L');
INSERT INTO `ey_region` VALUES ('9527', '杜尔伯特县', '3', '9419', 'D');
INSERT INTO `ey_region` VALUES ('9553', '伊春市', '2', '8558', 'Y');
INSERT INTO `ey_region` VALUES ('9554', '市辖区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9555', '伊春区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9561', '南岔区', '3', '9553', 'N');
INSERT INTO `ey_region` VALUES ('9581', '友好区', '3', '9553', 'Y');
INSERT INTO `ey_region` VALUES ('9599', '西林区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9603', '翠峦区', '3', '9553', 'C');
INSERT INTO `ey_region` VALUES ('9614', '新青区', '3', '9553', 'X');
INSERT INTO `ey_region` VALUES ('9631', '美溪区', '3', '9553', 'M');
INSERT INTO `ey_region` VALUES ('9647', '金山屯区', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9660', '五营区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9671', '乌马河区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9685', '汤旺河区', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9702', '带岭区', '3', '9553', 'D');
INSERT INTO `ey_region` VALUES ('9715', '乌伊岭区', '3', '9553', 'W');
INSERT INTO `ey_region` VALUES ('9729', '红星区', '3', '9553', 'H');
INSERT INTO `ey_region` VALUES ('9742', '上甘岭区', '3', '9553', 'S');
INSERT INTO `ey_region` VALUES ('9756', '嘉荫县', '3', '9553', 'J');
INSERT INTO `ey_region` VALUES ('9772', '铁力市', '3', '9553', 'T');
INSERT INTO `ey_region` VALUES ('9785', '佳木斯市', '2', '8558', 'J');
INSERT INTO `ey_region` VALUES ('9786', '市辖区', '3', '9785', 'S');
INSERT INTO `ey_region` VALUES ('9787', '向阳区', '3', '9785', 'X');
INSERT INTO `ey_region` VALUES ('9795', '前进区', '3', '9785', 'Q');
INSERT INTO `ey_region` VALUES ('9802', '东风区', '3', '9785', 'D');
INSERT INTO `ey_region` VALUES ('9810', '郊区', '3', '9785', 'J');
INSERT INTO `ey_region` VALUES ('9825', '桦南县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9839', '桦川县', '3', '9785', 'H');
INSERT INTO `ey_region` VALUES ('9851', '汤原县', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9866', '抚远县', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9879', '同江市', '3', '9785', 'T');
INSERT INTO `ey_region` VALUES ('9907', '富锦市', '3', '9785', 'F');
INSERT INTO `ey_region` VALUES ('9930', '七台河市', '2', '8558', 'Q');
INSERT INTO `ey_region` VALUES ('9931', '市辖区', '3', '9930', 'S');
INSERT INTO `ey_region` VALUES ('9932', '新兴区', '3', '9930', 'X');
INSERT INTO `ey_region` VALUES ('9944', '桃山区', '3', '9930', 'T');
INSERT INTO `ey_region` VALUES ('9952', '茄子河区', '3', '9930', 'Q');
INSERT INTO `ey_region` VALUES ('9962', '勃利县', '3', '9930', 'B');
INSERT INTO `ey_region` VALUES ('9981', '牡丹江市', '2', '8558', 'M');
INSERT INTO `ey_region` VALUES ('9982', '市辖区', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('9983', '东安区', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('9989', '阳明区', '3', '9981', 'Y');
INSERT INTO `ey_region` VALUES ('9996', '爱民区', '3', '9981', 'A');
INSERT INTO `ey_region` VALUES ('10005', '西安区', '3', '9981', 'X');
INSERT INTO `ey_region` VALUES ('10014', '东宁县', '3', '9981', 'D');
INSERT INTO `ey_region` VALUES ('10022', '林口县', '3', '9981', 'L');
INSERT INTO `ey_region` VALUES ('10036', '绥芬河市', '3', '9981', 'S');
INSERT INTO `ey_region` VALUES ('10039', '海林市', '3', '9981', 'H');
INSERT INTO `ey_region` VALUES ('10056', '宁安市', '3', '9981', 'N');
INSERT INTO `ey_region` VALUES ('10072', '穆棱市', '3', '9981', 'M');
INSERT INTO `ey_region` VALUES ('10084', '黑河市', '2', '8558', 'H');
INSERT INTO `ey_region` VALUES ('10085', '市辖区', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10086', '爱辉区', '3', '10084', 'A');
INSERT INTO `ey_region` VALUES ('10122', '嫩江县', '3', '10084', 'N');
INSERT INTO `ey_region` VALUES ('10150', '逊克县', '3', '10084', 'X');
INSERT INTO `ey_region` VALUES ('10168', '孙吴县', '3', '10084', 'S');
INSERT INTO `ey_region` VALUES ('10192', '北安市', '3', '10084', 'B');
INSERT INTO `ey_region` VALUES ('10214', '五大连池市', '3', '10084', 'W');
INSERT INTO `ey_region` VALUES ('10252', '绥化市', '2', '8558', 'S');
INSERT INTO `ey_region` VALUES ('10253', '市辖区', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10254', '北林区', '3', '10252', 'B');
INSERT INTO `ey_region` VALUES ('10281', '望奎县', '3', '10252', 'W');
INSERT INTO `ey_region` VALUES ('10301', '兰西县', '3', '10252', 'L');
INSERT INTO `ey_region` VALUES ('10320', '青冈县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10342', '庆安县', '3', '10252', 'Q');
INSERT INTO `ey_region` VALUES ('10360', '明水县', '3', '10252', 'M');
INSERT INTO `ey_region` VALUES ('10380', '绥棱县', '3', '10252', 'S');
INSERT INTO `ey_region` VALUES ('10401', '安达市', '3', '10252', 'A');
INSERT INTO `ey_region` VALUES ('10425', '肇东市', '3', '10252', 'Z');
INSERT INTO `ey_region` VALUES ('10452', '海伦市', '3', '10252', 'H');
INSERT INTO `ey_region` VALUES ('10483', '大兴安岭地区', '2', '8558', 'D');
INSERT INTO `ey_region` VALUES ('10484', '加格达奇区', '3', '10483', 'J');
INSERT INTO `ey_region` VALUES ('10495', '松岭区', '3', '10483', 'S');
INSERT INTO `ey_region` VALUES ('10500', '新林区', '3', '10483', 'X');
INSERT INTO `ey_region` VALUES ('10509', '呼中区', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10515', '呼玛县', '3', '10483', 'H');
INSERT INTO `ey_region` VALUES ('10525', '塔河县', '3', '10483', 'T');
INSERT INTO `ey_region` VALUES ('10534', '漠河县', '3', '10483', 'M');
INSERT INTO `ey_region` VALUES ('10543', '上海市', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('10544', '上海市', '2', '10543', 'S');
INSERT INTO `ey_region` VALUES ('10545', '黄浦区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10555', '卢湾区', '3', '10544', 'L');
INSERT INTO `ey_region` VALUES ('10560', '徐汇区', '3', '10544', 'X');
INSERT INTO `ey_region` VALUES ('10575', '长宁区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10586', '静安区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10592', '普陀区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10602', '闸北区', '3', '10544', 'Z');
INSERT INTO `ey_region` VALUES ('10612', '虹口区', '3', '10544', 'H');
INSERT INTO `ey_region` VALUES ('10623', '杨浦区', '3', '10544', 'Y');
INSERT INTO `ey_region` VALUES ('10636', '闵行区', '3', '10544', 'M');
INSERT INTO `ey_region` VALUES ('10650', '宝山区', '3', '10544', 'B');
INSERT INTO `ey_region` VALUES ('10664', '嘉定区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10678', '浦东新区', '3', '10544', 'P');
INSERT INTO `ey_region` VALUES ('10704', '金山区', '3', '10544', 'J');
INSERT INTO `ey_region` VALUES ('10715', '松江区', '3', '10544', 'S');
INSERT INTO `ey_region` VALUES ('10735', '青浦区', '3', '10544', 'Q');
INSERT INTO `ey_region` VALUES ('10747', '南汇区', '3', '10544', 'N');
INSERT INTO `ey_region` VALUES ('10765', '奉贤区', '3', '10544', 'F');
INSERT INTO `ey_region` VALUES ('10780', '崇明区', '3', '10544', 'C');
INSERT INTO `ey_region` VALUES ('10808', '江苏省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('10809', '南京市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('10810', '市辖区', '3', '10809', 'S');
INSERT INTO `ey_region` VALUES ('10811', '玄武区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10820', '白下区', '3', '10809', 'B');
INSERT INTO `ey_region` VALUES ('10831', '秦淮区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10837', '建邺区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10845', '鼓楼区', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10853', '下关区', '3', '10809', 'X');
INSERT INTO `ey_region` VALUES ('10860', '浦口区', '3', '10809', 'P');
INSERT INTO `ey_region` VALUES ('10876', '栖霞区', '3', '10809', 'Q');
INSERT INTO `ey_region` VALUES ('10894', '雨花台区', '3', '10809', 'Y');
INSERT INTO `ey_region` VALUES ('10903', '江宁区', '3', '10809', 'J');
INSERT INTO `ey_region` VALUES ('10916', '六合区', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10937', '溧水县', '3', '10809', 'L');
INSERT INTO `ey_region` VALUES ('10947', '高淳县', '3', '10809', 'G');
INSERT INTO `ey_region` VALUES ('10960', '无锡市', '2', '10808', 'W');
INSERT INTO `ey_region` VALUES ('10961', '市辖区', '3', '10960', 'S');
INSERT INTO `ey_region` VALUES ('10962', '崇安区', '3', '10960', 'C');
INSERT INTO `ey_region` VALUES ('10969', '南长区', '3', '10960', 'N');
INSERT INTO `ey_region` VALUES ('10976', '北塘区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('10981', '锡山区', '3', '10960', 'X');
INSERT INTO `ey_region` VALUES ('10990', '惠山区', '3', '10960', 'H');
INSERT INTO `ey_region` VALUES ('10999', '滨湖区', '3', '10960', 'B');
INSERT INTO `ey_region` VALUES ('11018', '江阴市', '3', '10960', 'J');
INSERT INTO `ey_region` VALUES ('11039', '宜兴市', '3', '10960', 'Y');
INSERT INTO `ey_region` VALUES ('11067', '徐州市', '2', '10808', 'X');
INSERT INTO `ey_region` VALUES ('11068', '市辖区', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11069', '鼓楼区', '3', '11067', 'G');
INSERT INTO `ey_region` VALUES ('11081', '云龙区', '3', '11067', 'Y');
INSERT INTO `ey_region` VALUES ('11089', '九里区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11103', '贾汪区', '3', '11067', 'J');
INSERT INTO `ey_region` VALUES ('11115', '泉山区', '3', '11067', 'Q');
INSERT INTO `ey_region` VALUES ('11126', '丰县', '3', '11067', 'F');
INSERT INTO `ey_region` VALUES ('11142', '沛县', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11160', '铜山县', '3', '11067', 'T');
INSERT INTO `ey_region` VALUES ('11182', '睢宁县', '3', '11067', 'S');
INSERT INTO `ey_region` VALUES ('11200', '新沂市', '3', '11067', 'X');
INSERT INTO `ey_region` VALUES ('11218', '邳州市', '3', '11067', 'P');
INSERT INTO `ey_region` VALUES ('11245', '常州市', '2', '10808', 'C');
INSERT INTO `ey_region` VALUES ('11246', '常州市区', '3', '11245', 'C');
INSERT INTO `ey_region` VALUES ('11247', '天宁区', '3', '11245', 'T');
INSERT INTO `ey_region` VALUES ('11254', '钟楼区', '3', '11245', 'Z');
INSERT INTO `ey_region` VALUES ('11262', '戚墅堰区', '3', '11245', 'Q');
INSERT INTO `ey_region` VALUES ('11266', '新北区', '3', '11245', 'X');
INSERT INTO `ey_region` VALUES ('11276', '武进区', '3', '11245', 'W');
INSERT INTO `ey_region` VALUES ('11311', '溧阳市', '3', '11245', 'L');
INSERT INTO `ey_region` VALUES ('11331', '金坛市', '3', '11245', 'J');
INSERT INTO `ey_region` VALUES ('11348', '苏州市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('11349', '市辖区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11350', '沧浪区', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11357', '平江区', '3', '11348', 'P');
INSERT INTO `ey_region` VALUES ('11368', '金阊区', '3', '11348', 'J');
INSERT INTO `ey_region` VALUES ('11374', '苏州高新区虎丘区', '3', '11348', 'S');
INSERT INTO `ey_region` VALUES ('11387', '吴中区', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11409', '相城区', '3', '11348', 'X');
INSERT INTO `ey_region` VALUES ('11419', '常熟市', '3', '11348', 'C');
INSERT INTO `ey_region` VALUES ('11433', '张家港市', '3', '11348', 'Z');
INSERT INTO `ey_region` VALUES ('11448', '昆山市', '3', '11348', 'K');
INSERT INTO `ey_region` VALUES ('11460', '吴江市', '3', '11348', 'W');
INSERT INTO `ey_region` VALUES ('11472', '太仓市', '3', '11348', 'T');
INSERT INTO `ey_region` VALUES ('11482', '南通市', '2', '10808', 'N');
INSERT INTO `ey_region` VALUES ('11483', '市辖区', '3', '11482', 'S');
INSERT INTO `ey_region` VALUES ('11484', '崇川区', '3', '11482', 'C');
INSERT INTO `ey_region` VALUES ('11502', '港闸区', '3', '11482', 'G');
INSERT INTO `ey_region` VALUES ('11510', '海安县', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11526', '如东', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11542', '启东市', '3', '11482', 'Q');
INSERT INTO `ey_region` VALUES ('11568', '如皋市', '3', '11482', 'R');
INSERT INTO `ey_region` VALUES ('11600', '通州市', '3', '11482', 'T');
INSERT INTO `ey_region` VALUES ('11627', '海门市', '3', '11482', 'H');
INSERT INTO `ey_region` VALUES ('11663', '连云港市', '2', '10808', 'L');
INSERT INTO `ey_region` VALUES ('11664', '市辖区', '3', '11663', 'S');
INSERT INTO `ey_region` VALUES ('11665', '连云区', '3', '11663', 'L');
INSERT INTO `ey_region` VALUES ('11678', '新浦区', '3', '11663', 'X');
INSERT INTO `ey_region` VALUES ('11692', '海州区', '3', '11663', 'H');
INSERT INTO `ey_region` VALUES ('11699', '赣榆县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11722', '东海县', '3', '11663', 'D');
INSERT INTO `ey_region` VALUES ('11747', '灌云县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11771', '灌南县', '3', '11663', 'G');
INSERT INTO `ey_region` VALUES ('11786', '淮安市', '2', '10808', 'H');
INSERT INTO `ey_region` VALUES ('11787', '市辖区', '3', '11786', 'S');
INSERT INTO `ey_region` VALUES ('11788', '清河区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11801', '楚州区', '3', '11786', 'C');
INSERT INTO `ey_region` VALUES ('11830', '淮阴区', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11853', '清浦区', '3', '11786', 'Q');
INSERT INTO `ey_region` VALUES ('11863', '涟水县', '3', '11786', 'L');
INSERT INTO `ey_region` VALUES ('11896', '洪泽县', '3', '11786', 'H');
INSERT INTO `ey_region` VALUES ('11909', '盱眙县', '3', '11786', 'X');
INSERT INTO `ey_region` VALUES ('11931', '金湖县', '3', '11786', 'J');
INSERT INTO `ey_region` VALUES ('11947', '盐城市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('11948', '市辖区', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('11949', '亭湖区', '3', '11947', 'T');
INSERT INTO `ey_region` VALUES ('11967', '盐都区', '3', '11947', 'Y');
INSERT INTO `ey_region` VALUES ('11982', '响水县', '3', '11947', 'X');
INSERT INTO `ey_region` VALUES ('11998', '滨海县', '3', '11947', 'B');
INSERT INTO `ey_region` VALUES ('12017', '阜宁县', '3', '11947', 'F');
INSERT INTO `ey_region` VALUES ('12040', '射阳县', '3', '11947', 'S');
INSERT INTO `ey_region` VALUES ('12066', '建湖县', '3', '11947', 'J');
INSERT INTO `ey_region` VALUES ('12083', '东台市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12117', '大丰市', '3', '11947', 'D');
INSERT INTO `ey_region` VALUES ('12135', '扬州市', '2', '10808', 'Y');
INSERT INTO `ey_region` VALUES ('12136', '市辖区', '3', '12135', 'S');
INSERT INTO `ey_region` VALUES ('12137', '广陵区', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12144', '邗江区', '3', '12135', 'H');
INSERT INTO `ey_region` VALUES ('12160', '维扬区', '3', '12135', 'W');
INSERT INTO `ey_region` VALUES ('12175', '宝应县', '3', '12135', 'B');
INSERT INTO `ey_region` VALUES ('12191', '仪征市', '3', '12135', 'Y');
INSERT INTO `ey_region` VALUES ('12212', '高邮市', '3', '12135', 'G');
INSERT INTO `ey_region` VALUES ('12235', '江都市', '3', '12135', 'J');
INSERT INTO `ey_region` VALUES ('12249', '镇江市', '2', '10808', 'Z');
INSERT INTO `ey_region` VALUES ('12250', '市区', '3', '12249', 'S');
INSERT INTO `ey_region` VALUES ('12251', '京口区', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12265', '润州区', '3', '12249', 'R');
INSERT INTO `ey_region` VALUES ('12273', '丹徒区', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12282', '丹阳市', '3', '12249', 'D');
INSERT INTO `ey_region` VALUES ('12300', '扬中市', '3', '12249', 'Y');
INSERT INTO `ey_region` VALUES ('12312', '句容市', '3', '12249', 'J');
INSERT INTO `ey_region` VALUES ('12343', '泰州市', '2', '10808', 'T');
INSERT INTO `ey_region` VALUES ('12344', '市辖区', '3', '12343', 'S');
INSERT INTO `ey_region` VALUES ('12345', '海陵区', '3', '12343', 'H');
INSERT INTO `ey_region` VALUES ('12362', '高港区', '3', '12343', 'G');
INSERT INTO `ey_region` VALUES ('12370', '兴化市', '3', '12343', 'X');
INSERT INTO `ey_region` VALUES ('12407', '靖江市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12423', '泰兴市', '3', '12343', 'T');
INSERT INTO `ey_region` VALUES ('12450', '姜堰市', '3', '12343', 'J');
INSERT INTO `ey_region` VALUES ('12475', '宿迁市', '2', '10808', 'S');
INSERT INTO `ey_region` VALUES ('12476', '市辖区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12477', '宿城区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12496', '宿豫区', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12515', '沭阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12551', '泗阳县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12570', '泗洪县', '3', '12475', 'S');
INSERT INTO `ey_region` VALUES ('12596', '浙江省', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('12597', '杭州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('12598', '市辖区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12599', '上城区', '3', '12597', 'S');
INSERT INTO `ey_region` VALUES ('12606', '下城区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12615', '江干区', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12626', '拱墅区', '3', '12597', 'G');
INSERT INTO `ey_region` VALUES ('12637', '西湖区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12652', '滨江区', '3', '12597', 'B');
INSERT INTO `ey_region` VALUES ('12656', '萧山区', '3', '12597', 'X');
INSERT INTO `ey_region` VALUES ('12685', '余杭区', '3', '12597', 'Y');
INSERT INTO `ey_region` VALUES ('12705', '桐庐县', '3', '12597', 'T');
INSERT INTO `ey_region` VALUES ('12719', '淳安县', '3', '12597', 'C');
INSERT INTO `ey_region` VALUES ('12743', '建德市', '3', '12597', 'J');
INSERT INTO `ey_region` VALUES ('12760', '富阳市', '3', '12597', 'F');
INSERT INTO `ey_region` VALUES ('12786', '临安市', '3', '12597', 'L');
INSERT INTO `ey_region` VALUES ('12813', '宁波市', '2', '12596', 'N');
INSERT INTO `ey_region` VALUES ('12814', '市辖区', '3', '12813', 'S');
INSERT INTO `ey_region` VALUES ('12815', '海曙区', '3', '12813', 'H');
INSERT INTO `ey_region` VALUES ('12824', '江东区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12832', '江北区', '3', '12813', 'J');
INSERT INTO `ey_region` VALUES ('12841', '北仑区', '3', '12813', 'B');
INSERT INTO `ey_region` VALUES ('12851', '镇海区', '3', '12813', 'Z');
INSERT INTO `ey_region` VALUES ('12858', '鄞州区', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12881', '象山县', '3', '12813', 'X');
INSERT INTO `ey_region` VALUES ('12900', '宁海县', '3', '12813', 'N');
INSERT INTO `ey_region` VALUES ('12919', '余姚市', '3', '12813', 'Y');
INSERT INTO `ey_region` VALUES ('12941', '慈溪市', '3', '12813', 'C');
INSERT INTO `ey_region` VALUES ('12962', '奉化市', '3', '12813', 'F');
INSERT INTO `ey_region` VALUES ('12974', '温州市', '2', '12596', 'W');
INSERT INTO `ey_region` VALUES ('12975', '市辖区', '3', '12974', 'S');
INSERT INTO `ey_region` VALUES ('12976', '鹿城区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('12998', '龙湾区', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13009', '瓯海区', '3', '12974', 'O');
INSERT INTO `ey_region` VALUES ('13023', '洞头县', '3', '12974', 'D');
INSERT INTO `ey_region` VALUES ('13030', '永嘉县', '3', '12974', 'Y');
INSERT INTO `ey_region` VALUES ('13069', '平阳县', '3', '12974', 'P');
INSERT INTO `ey_region` VALUES ('13101', '苍南县', '3', '12974', 'C');
INSERT INTO `ey_region` VALUES ('13138', '文成县', '3', '12974', 'W');
INSERT INTO `ey_region` VALUES ('13172', '泰顺县', '3', '12974', 'T');
INSERT INTO `ey_region` VALUES ('13209', '瑞安市', '3', '12974', 'R');
INSERT INTO `ey_region` VALUES ('13248', '乐清市', '3', '12974', 'L');
INSERT INTO `ey_region` VALUES ('13280', '嘉兴市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13281', '市辖区', '3', '13280', 'S');
INSERT INTO `ey_region` VALUES ('13282', '南湖区', '3', '13280', 'N');
INSERT INTO `ey_region` VALUES ('13295', '秀洲区', '3', '13280', 'X');
INSERT INTO `ey_region` VALUES ('13304', '嘉善县', '3', '13280', 'J');
INSERT INTO `ey_region` VALUES ('13316', '海盐县', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13325', '海宁市', '3', '13280', 'H');
INSERT INTO `ey_region` VALUES ('13339', '平湖市', '3', '13280', 'P');
INSERT INTO `ey_region` VALUES ('13350', '桐乡市', '3', '13280', 'T');
INSERT INTO `ey_region` VALUES ('13364', '湖州市', '2', '12596', 'H');
INSERT INTO `ey_region` VALUES ('13365', '市辖区', '3', '13364', 'S');
INSERT INTO `ey_region` VALUES ('13366', '吴兴区', '3', '13364', 'W');
INSERT INTO `ey_region` VALUES ('13382', '南浔区', '3', '13364', 'N');
INSERT INTO `ey_region` VALUES ('13392', '德清县', '3', '13364', 'D');
INSERT INTO `ey_region` VALUES ('13404', '长兴县', '3', '13364', 'C');
INSERT INTO `ey_region` VALUES ('13421', '安吉县', '3', '13364', 'A');
INSERT INTO `ey_region` VALUES ('13437', '绍兴市', '2', '12596', 'S');
INSERT INTO `ey_region` VALUES ('13438', '市辖区', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13439', '越城区', '3', '13437', 'Y');
INSERT INTO `ey_region` VALUES ('13453', '绍兴县', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13473', '新昌县', '3', '13437', 'X');
INSERT INTO `ey_region` VALUES ('13490', '诸暨市', '3', '13437', 'Z');
INSERT INTO `ey_region` VALUES ('13518', '上虞市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13542', '嵊州市', '3', '13437', 'S');
INSERT INTO `ey_region` VALUES ('13564', '金华市', '2', '12596', 'J');
INSERT INTO `ey_region` VALUES ('13565', '市辖区', '3', '13564', 'S');
INSERT INTO `ey_region` VALUES ('13566', '婺城区', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13594', '金东区', '3', '13564', 'J');
INSERT INTO `ey_region` VALUES ('13606', '武义县', '3', '13564', 'W');
INSERT INTO `ey_region` VALUES ('13625', '浦江县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13641', '磐安县', '3', '13564', 'P');
INSERT INTO `ey_region` VALUES ('13662', '兰溪市', '3', '13564', 'L');
INSERT INTO `ey_region` VALUES ('13678', '义乌市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13692', '东阳市', '3', '13564', 'D');
INSERT INTO `ey_region` VALUES ('13711', '永康市', '3', '13564', 'Y');
INSERT INTO `ey_region` VALUES ('13726', '衢州市', '2', '12596', 'Q');
INSERT INTO `ey_region` VALUES ('13727', '市辖区', '3', '13726', 'S');
INSERT INTO `ey_region` VALUES ('13728', '柯城区', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13746', '衢江区', '3', '13726', 'Q');
INSERT INTO `ey_region` VALUES ('13768', '常山县', '3', '13726', 'C');
INSERT INTO `ey_region` VALUES ('13783', '开化县', '3', '13726', 'K');
INSERT INTO `ey_region` VALUES ('13802', '龙游县', '3', '13726', 'L');
INSERT INTO `ey_region` VALUES ('13818', '江山市', '3', '13726', 'J');
INSERT INTO `ey_region` VALUES ('13840', '舟山市', '2', '12596', 'Z');
INSERT INTO `ey_region` VALUES ('13841', '市辖区', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13842', '定海区', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13859', '普陀区', '3', '13840', 'P');
INSERT INTO `ey_region` VALUES ('13874', '岱山县', '3', '13840', 'D');
INSERT INTO `ey_region` VALUES ('13882', '嵊泗县', '3', '13840', 'S');
INSERT INTO `ey_region` VALUES ('13890', '台州市', '2', '12596', 'T');
INSERT INTO `ey_region` VALUES ('13891', '市辖区', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13892', '椒江区', '3', '13890', 'J');
INSERT INTO `ey_region` VALUES ('13903', '黄岩区', '3', '13890', 'H');
INSERT INTO `ey_region` VALUES ('13923', '路桥区', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('13934', '玉环县', '3', '13890', 'Y');
INSERT INTO `ey_region` VALUES ('13944', '三门县', '3', '13890', 'S');
INSERT INTO `ey_region` VALUES ('13959', '天台县', '3', '13890', 'T');
INSERT INTO `ey_region` VALUES ('13975', '仙居县', '3', '13890', 'X');
INSERT INTO `ey_region` VALUES ('13996', '温岭市', '3', '13890', 'W');
INSERT INTO `ey_region` VALUES ('14013', '临海市', '3', '13890', 'L');
INSERT INTO `ey_region` VALUES ('14033', '丽水市', '2', '12596', 'L');
INSERT INTO `ey_region` VALUES ('14034', '市辖区', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14035', '莲都区', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14054', '青田县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14086', '缙云县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14111', '遂昌县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14132', '松阳县', '3', '14033', 'S');
INSERT INTO `ey_region` VALUES ('14153', '云和县', '3', '14033', 'Y');
INSERT INTO `ey_region` VALUES ('14168', '庆元县', '3', '14033', 'Q');
INSERT INTO `ey_region` VALUES ('14189', '景宁县', '3', '14033', 'J');
INSERT INTO `ey_region` VALUES ('14214', '龙泉市', '3', '14033', 'L');
INSERT INTO `ey_region` VALUES ('14234', '安徽省', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('14235', '合肥市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14236', '市辖区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14237', '瑶海区', '3', '14235', 'Y');
INSERT INTO `ey_region` VALUES ('14254', '庐阳区', '3', '14235', 'L');
INSERT INTO `ey_region` VALUES ('14269', '蜀山区', '3', '14235', 'S');
INSERT INTO `ey_region` VALUES ('14286', '包河区', '3', '14235', 'B');
INSERT INTO `ey_region` VALUES ('14297', '长丰县', '3', '14235', 'C');
INSERT INTO `ey_region` VALUES ('14314', '肥东县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14334', '肥西县', '3', '14235', 'F');
INSERT INTO `ey_region` VALUES ('14351', '芜湖市', '2', '14234', 'W');
INSERT INTO `ey_region` VALUES ('14352', '市辖区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14353', '镜湖区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14366', '弋江区', '3', '14351', 'Y');
INSERT INTO `ey_region` VALUES ('14374', '鸠江区', '3', '14351', 'J');
INSERT INTO `ey_region` VALUES ('14382', '三山区', '3', '14351', 'S');
INSERT INTO `ey_region` VALUES ('14387', '芜湖县', '3', '14351', 'W');
INSERT INTO `ey_region` VALUES ('14394', '繁昌县', '3', '14351', 'F');
INSERT INTO `ey_region` VALUES ('14401', '南陵县', '3', '14351', 'N');
INSERT INTO `ey_region` VALUES ('14410', '蚌埠市', '2', '14234', 'B');
INSERT INTO `ey_region` VALUES ('14411', '市辖区', '3', '14410', 'S');
INSERT INTO `ey_region` VALUES ('14412', '龙子湖区', '3', '14410', 'L');
INSERT INTO `ey_region` VALUES ('14422', '蚌山区', '3', '14410', 'B');
INSERT INTO `ey_region` VALUES ('14434', '禹会区', '3', '14410', 'Y');
INSERT INTO `ey_region` VALUES ('14443', '淮上区', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14449', '怀远县', '3', '14410', 'H');
INSERT INTO `ey_region` VALUES ('14471', '五河县', '3', '14410', 'W');
INSERT INTO `ey_region` VALUES ('14487', '固镇县', '3', '14410', 'G');
INSERT INTO `ey_region` VALUES ('14500', '淮南市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14501', '市辖区', '3', '14500', 'S');
INSERT INTO `ey_region` VALUES ('14502', '大通区', '3', '14500', 'D');
INSERT INTO `ey_region` VALUES ('14508', '田家庵区', '3', '14500', 'T');
INSERT INTO `ey_region` VALUES ('14523', '谢家集区', '3', '14500', 'X');
INSERT INTO `ey_region` VALUES ('14535', '八公山区', '3', '14500', 'B');
INSERT INTO `ey_region` VALUES ('14542', '潘集区', '3', '14500', 'P');
INSERT INTO `ey_region` VALUES ('14554', '凤台县', '3', '14500', 'F');
INSERT INTO `ey_region` VALUES ('14575', '马鞍山市', '2', '14234', 'M');
INSERT INTO `ey_region` VALUES ('14576', '市辖区', '3', '14575', 'S');
INSERT INTO `ey_region` VALUES ('14577', '金家庄区', '3', '14575', 'J');
INSERT INTO `ey_region` VALUES ('14583', '花山区', '3', '14575', 'H');
INSERT INTO `ey_region` VALUES ('14589', '雨山区', '3', '14575', 'Y');
INSERT INTO `ey_region` VALUES ('14597', '当涂县', '3', '14575', 'D');
INSERT INTO `ey_region` VALUES ('14612', '淮北市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14613', '市辖区', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14614', '杜集区', '3', '14612', 'D');
INSERT INTO `ey_region` VALUES ('14620', '相山区', '3', '14612', 'X');
INSERT INTO `ey_region` VALUES ('14632', '烈山区', '3', '14612', 'L');
INSERT INTO `ey_region` VALUES ('14641', '濉溪县', '3', '14612', 'S');
INSERT INTO `ey_region` VALUES ('14653', '铜陵市', '2', '14234', 'T');
INSERT INTO `ey_region` VALUES ('14654', '市辖区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14655', '铜官山区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14663', '狮子山区', '3', '14653', 'S');
INSERT INTO `ey_region` VALUES ('14671', '铜陵市郊区', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14678', '铜陵县', '3', '14653', 'T');
INSERT INTO `ey_region` VALUES ('14687', '安庆市', '2', '14234', 'A');
INSERT INTO `ey_region` VALUES ('14688', '市辖区', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14689', '迎江区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14700', '大观区', '3', '14687', 'D');
INSERT INTO `ey_region` VALUES ('14712', '宜秀区', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14720', '怀宁县', '3', '14687', 'H');
INSERT INTO `ey_region` VALUES ('14741', '枞阳县', '3', '14687', 'C');
INSERT INTO `ey_region` VALUES ('14764', '潜山县', '3', '14687', 'Q');
INSERT INTO `ey_region` VALUES ('14782', '太湖县', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14798', '宿松县', '3', '14687', 'S');
INSERT INTO `ey_region` VALUES ('14823', '望江县', '3', '14687', 'W');
INSERT INTO `ey_region` VALUES ('14834', '岳西县', '3', '14687', 'Y');
INSERT INTO `ey_region` VALUES ('14859', '桐城市', '3', '14687', 'T');
INSERT INTO `ey_region` VALUES ('14887', '黄山市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('14888', '市辖区', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14889', '屯溪区', '3', '14887', 'T');
INSERT INTO `ey_region` VALUES ('14900', '黄山区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14917', '徽州区', '3', '14887', 'H');
INSERT INTO `ey_region` VALUES ('14926', '歙县', '3', '14887', 'S');
INSERT INTO `ey_region` VALUES ('14955', '休宁县', '3', '14887', 'X');
INSERT INTO `ey_region` VALUES ('14977', '黟县', '3', '14887', 'Y');
INSERT INTO `ey_region` VALUES ('14986', '祁门县', '3', '14887', 'Q');
INSERT INTO `ey_region` VALUES ('15005', '滁州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15006', '市辖区', '3', '15005', 'S');
INSERT INTO `ey_region` VALUES ('15007', '琅琊区', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15016', '南谯区', '3', '15005', 'N');
INSERT INTO `ey_region` VALUES ('15034', '来安县', '3', '15005', 'L');
INSERT INTO `ey_region` VALUES ('15053', '全椒县', '3', '15005', 'Q');
INSERT INTO `ey_region` VALUES ('15071', '定远县', '3', '15005', 'D');
INSERT INTO `ey_region` VALUES ('15109', '凤阳县', '3', '15005', 'F');
INSERT INTO `ey_region` VALUES ('15136', '天长市', '3', '15005', 'T');
INSERT INTO `ey_region` VALUES ('15166', '明光市', '3', '15005', 'M');
INSERT INTO `ey_region` VALUES ('15194', '阜阳市', '2', '14234', 'F');
INSERT INTO `ey_region` VALUES ('15195', '市辖区', '3', '15194', 'S');
INSERT INTO `ey_region` VALUES ('15196', '颍州区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15211', '颍东区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15224', '颍泉区', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15231', '临泉县', '3', '15194', 'L');
INSERT INTO `ey_region` VALUES ('15264', '太和县', '3', '15194', 'T');
INSERT INTO `ey_region` VALUES ('15296', '阜南县', '3', '15194', 'F');
INSERT INTO `ey_region` VALUES ('15328', '颍上县', '3', '15194', 'Y');
INSERT INTO `ey_region` VALUES ('15359', '界首市', '3', '15194', 'J');
INSERT INTO `ey_region` VALUES ('15378', '宿州市', '2', '14234', 'S');
INSERT INTO `ey_region` VALUES ('15379', '市辖区', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15380', '墉桥区', '3', '15378', 'Y');
INSERT INTO `ey_region` VALUES ('15417', '砀山县', '3', '15378', 'D');
INSERT INTO `ey_region` VALUES ('15437', '萧县', '3', '15378', 'X');
INSERT INTO `ey_region` VALUES ('15461', '灵璧县', '3', '15378', 'L');
INSERT INTO `ey_region` VALUES ('15482', '泗县', '3', '15378', 'S');
INSERT INTO `ey_region` VALUES ('15499', '巢湖市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15500', '市辖区', '3', '15499', 'S');
INSERT INTO `ey_region` VALUES ('15501', '居巢区', '3', '15499', 'J');
INSERT INTO `ey_region` VALUES ('15520', '庐江县', '3', '15499', 'L');
INSERT INTO `ey_region` VALUES ('15542', '无为县', '3', '15499', 'W');
INSERT INTO `ey_region` VALUES ('15566', '含山县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15575', '和县', '3', '15499', 'H');
INSERT INTO `ey_region` VALUES ('15586', '六安市', '2', '14234', 'L');
INSERT INTO `ey_region` VALUES ('15587', '市辖区', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15588', '金安区', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15612', '裕安区', '3', '15586', 'Y');
INSERT INTO `ey_region` VALUES ('15635', '寿县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15662', '霍邱县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15698', '舒城县', '3', '15586', 'S');
INSERT INTO `ey_region` VALUES ('15720', '金寨县', '3', '15586', 'J');
INSERT INTO `ey_region` VALUES ('15747', '霍山县', '3', '15586', 'H');
INSERT INTO `ey_region` VALUES ('15764', '亳州市', '2', '14234', 'H');
INSERT INTO `ey_region` VALUES ('15765', '市辖区', '3', '15764', 'S');
INSERT INTO `ey_region` VALUES ('15766', '谯城区', '3', '15764', 'Q');
INSERT INTO `ey_region` VALUES ('15795', '涡阳县', '3', '15764', 'W');
INSERT INTO `ey_region` VALUES ('15823', '蒙城县', '3', '15764', 'M');
INSERT INTO `ey_region` VALUES ('15843', '利辛县', '3', '15764', 'L');
INSERT INTO `ey_region` VALUES ('15871', '池州市', '2', '14234', 'C');
INSERT INTO `ey_region` VALUES ('15872', '市辖区', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15873', '贵池区', '3', '15871', 'G');
INSERT INTO `ey_region` VALUES ('15900', '东至县', '3', '15871', 'D');
INSERT INTO `ey_region` VALUES ('15930', '石台县', '3', '15871', 'S');
INSERT INTO `ey_region` VALUES ('15944', '青阳县', '3', '15871', 'Q');
INSERT INTO `ey_region` VALUES ('15958', '宣城市', '2', '14234', 'X');
INSERT INTO `ey_region` VALUES ('15959', '市辖区', '3', '15958', 'S');
INSERT INTO `ey_region` VALUES ('15960', '宣州区', '3', '15958', 'X');
INSERT INTO `ey_region` VALUES ('15987', '郎溪县', '3', '15958', 'L');
INSERT INTO `ey_region` VALUES ('16001', '广德县', '3', '15958', 'G');
INSERT INTO `ey_region` VALUES ('16013', '泾县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16025', '绩溪县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16037', '旌德县', '3', '15958', 'J');
INSERT INTO `ey_region` VALUES ('16048', '宁国市', '3', '15958', 'N');
INSERT INTO `ey_region` VALUES ('16068', '福建省', '1', '0', 'F');
INSERT INTO `ey_region` VALUES ('16069', '福州市', '2', '16068', 'F');
INSERT INTO `ey_region` VALUES ('16070', '市辖区', '3', '16069', 'S');
INSERT INTO `ey_region` VALUES ('16071', '鼓楼区', '3', '16069', 'G');
INSERT INTO `ey_region` VALUES ('16082', '台江区', '3', '16069', 'T');
INSERT INTO `ey_region` VALUES ('16093', '仓山区', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16108', '马尾区', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16113', '晋安区', '3', '16069', 'J');
INSERT INTO `ey_region` VALUES ('16123', '闽侯县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16140', '连江县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16164', '罗源县', '3', '16069', 'L');
INSERT INTO `ey_region` VALUES ('16177', '闽清县', '3', '16069', 'M');
INSERT INTO `ey_region` VALUES ('16194', '永泰县', '3', '16069', 'Y');
INSERT INTO `ey_region` VALUES ('16216', '平潭县', '3', '16069', 'P');
INSERT INTO `ey_region` VALUES ('16232', '福清市', '3', '16069', 'F');
INSERT INTO `ey_region` VALUES ('16259', '长乐市', '3', '16069', 'C');
INSERT INTO `ey_region` VALUES ('16278', '厦门市', '2', '16068', 'X');
INSERT INTO `ey_region` VALUES ('16279', '市辖区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16280', '思明区', '3', '16278', 'S');
INSERT INTO `ey_region` VALUES ('16294', '海沧区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16303', '湖里区', '3', '16278', 'H');
INSERT INTO `ey_region` VALUES ('16315', '集美区', '3', '16278', 'J');
INSERT INTO `ey_region` VALUES ('16326', '同安区', '3', '16278', 'T');
INSERT INTO `ey_region` VALUES ('16341', '翔安区', '3', '16278', 'X');
INSERT INTO `ey_region` VALUES ('16348', '莆田市', '2', '16068', 'P');
INSERT INTO `ey_region` VALUES ('16349', '市辖区', '3', '16348', 'S');
INSERT INTO `ey_region` VALUES ('16350', '城厢区', '3', '16348', 'C');
INSERT INTO `ey_region` VALUES ('16358', '涵江区', '3', '16348', 'H');
INSERT INTO `ey_region` VALUES ('16372', '荔城区', '3', '16348', 'L');
INSERT INTO `ey_region` VALUES ('16379', '秀屿区', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16393', '仙游县', '3', '16348', 'X');
INSERT INTO `ey_region` VALUES ('16412', '三明市', '2', '16068', 'S');
INSERT INTO `ey_region` VALUES ('16413', '市辖区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16414', '梅列区', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16421', '三元区', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16430', '明溪县', '3', '16412', 'M');
INSERT INTO `ey_region` VALUES ('16440', '清流县', '3', '16412', 'Q');
INSERT INTO `ey_region` VALUES ('16455', '宁化县', '3', '16412', 'N');
INSERT INTO `ey_region` VALUES ('16472', '大田县', '3', '16412', 'D');
INSERT INTO `ey_region` VALUES ('16492', '尤溪县', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16508', '沙县', '3', '16412', 'S');
INSERT INTO `ey_region` VALUES ('16521', '将乐县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16535', '泰宁县', '3', '16412', 'T');
INSERT INTO `ey_region` VALUES ('16545', '建宁县', '3', '16412', 'J');
INSERT INTO `ey_region` VALUES ('16556', '永安市', '3', '16412', 'Y');
INSERT INTO `ey_region` VALUES ('16572', '泉州市', '2', '16068', 'Q');
INSERT INTO `ey_region` VALUES ('16573', '市辖区', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16574', '鲤城区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16584', '丰泽区', '3', '16572', 'F');
INSERT INTO `ey_region` VALUES ('16593', '洛江区', '3', '16572', 'L');
INSERT INTO `ey_region` VALUES ('16600', '泉港区', '3', '16572', 'Q');
INSERT INTO `ey_region` VALUES ('16608', '惠安县', '3', '16572', 'H');
INSERT INTO `ey_region` VALUES ('16625', '安溪县', '3', '16572', 'A');
INSERT INTO `ey_region` VALUES ('16650', '永春县', '3', '16572', 'Y');
INSERT INTO `ey_region` VALUES ('16673', '德化县', '3', '16572', 'D');
INSERT INTO `ey_region` VALUES ('16692', '金门县', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16693', '石狮市', '3', '16572', 'S');
INSERT INTO `ey_region` VALUES ('16703', '晋江市', '3', '16572', 'J');
INSERT INTO `ey_region` VALUES ('16726', '南安市', '3', '16572', 'N');
INSERT INTO `ey_region` VALUES ('16754', '漳州市', '2', '16068', 'Z');
INSERT INTO `ey_region` VALUES ('16755', '市辖区', '3', '16754', 'S');
INSERT INTO `ey_region` VALUES ('16756', '芗城区', '3', '16754', 'X');
INSERT INTO `ey_region` VALUES ('16772', '龙文区', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16778', '云霄县', '3', '16754', 'Y');
INSERT INTO `ey_region` VALUES ('16790', '漳浦县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16821', '诏安县', '3', '16754', 'Z');
INSERT INTO `ey_region` VALUES ('16842', '长泰县', '3', '16754', 'C');
INSERT INTO `ey_region` VALUES ('16852', '东山县', '3', '16754', 'D');
INSERT INTO `ey_region` VALUES ('16860', '南靖县', '3', '16754', 'N');
INSERT INTO `ey_region` VALUES ('16872', '平和县', '3', '16754', 'P');
INSERT INTO `ey_region` VALUES ('16889', '华安县', '3', '16754', 'H');
INSERT INTO `ey_region` VALUES ('16899', '龙海市', '3', '16754', 'L');
INSERT INTO `ey_region` VALUES ('16924', '南平市', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('16925', '市辖区', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16926', '延平区', '3', '16924', 'Y');
INSERT INTO `ey_region` VALUES ('16948', '顺昌县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('16961', '浦城县', '3', '16924', 'P');
INSERT INTO `ey_region` VALUES ('16982', '光泽县', '3', '16924', 'G');
INSERT INTO `ey_region` VALUES ('16991', '松溪县', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17001', '政和县', '3', '16924', 'Z');
INSERT INTO `ey_region` VALUES ('17012', '邵武市', '3', '16924', 'S');
INSERT INTO `ey_region` VALUES ('17033', '武夷山市', '3', '16924', 'W');
INSERT INTO `ey_region` VALUES ('17044', '建瓯市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17063', '建阳市', '3', '16924', 'J');
INSERT INTO `ey_region` VALUES ('17077', '龙岩市', '2', '16068', 'L');
INSERT INTO `ey_region` VALUES ('17078', '市辖区', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17079', '新罗区', '3', '17077', 'X');
INSERT INTO `ey_region` VALUES ('17099', '长汀县', '3', '17077', 'C');
INSERT INTO `ey_region` VALUES ('17118', '永定县', '3', '17077', 'Y');
INSERT INTO `ey_region` VALUES ('17143', '上杭县', '3', '17077', 'S');
INSERT INTO `ey_region` VALUES ('17166', '武平县', '3', '17077', 'W');
INSERT INTO `ey_region` VALUES ('17184', '连城县', '3', '17077', 'L');
INSERT INTO `ey_region` VALUES ('17202', '漳平市', '3', '17077', 'Z');
INSERT INTO `ey_region` VALUES ('17219', '宁德市　', '2', '16068', 'N');
INSERT INTO `ey_region` VALUES ('17220', '市辖区', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17221', '蕉城区', '3', '17219', 'J');
INSERT INTO `ey_region` VALUES ('17239', '霞浦县', '3', '17219', 'X');
INSERT INTO `ey_region` VALUES ('17254', '古田县', '3', '17219', 'G');
INSERT INTO `ey_region` VALUES ('17269', '屏南县', '3', '17219', 'P');
INSERT INTO `ey_region` VALUES ('17281', '寿宁县', '3', '17219', 'S');
INSERT INTO `ey_region` VALUES ('17296', '周宁县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17306', '柘荣县', '3', '17219', 'Z');
INSERT INTO `ey_region` VALUES ('17316', '福安市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17341', '福鼎市', '3', '17219', 'F');
INSERT INTO `ey_region` VALUES ('17359', '江西省', '1', '0', 'J');
INSERT INTO `ey_region` VALUES ('17360', '南昌市', '2', '17359', 'N');
INSERT INTO `ey_region` VALUES ('17361', '市辖区', '3', '17360', 'S');
INSERT INTO `ey_region` VALUES ('17362', '东湖区', '3', '17360', 'D');
INSERT INTO `ey_region` VALUES ('17374', '西湖区', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17387', '青云谱区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17395', '湾里区', '3', '17360', 'W');
INSERT INTO `ey_region` VALUES ('17402', '青山湖区', '3', '17360', 'Q');
INSERT INTO `ey_region` VALUES ('17420', '南昌县', '3', '17360', 'N');
INSERT INTO `ey_region` VALUES ('17443', '新建县', '3', '17360', 'X');
INSERT INTO `ey_region` VALUES ('17471', '安义县', '3', '17360', 'A');
INSERT INTO `ey_region` VALUES ('17485', '进贤县', '3', '17360', 'J');
INSERT INTO `ey_region` VALUES ('17508', '景德镇市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17509', '市辖区', '3', '17508', 'S');
INSERT INTO `ey_region` VALUES ('17510', '昌江区', '3', '17508', 'C');
INSERT INTO `ey_region` VALUES ('17534', '珠山区', '3', '17508', 'Z');
INSERT INTO `ey_region` VALUES ('17545', '浮梁县', '3', '17508', 'F');
INSERT INTO `ey_region` VALUES ('17568', '乐平市', '3', '17508', 'L');
INSERT INTO `ey_region` VALUES ('17589', '萍乡市', '2', '17359', 'P');
INSERT INTO `ey_region` VALUES ('17590', '市辖区', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17591', '安源区', '3', '17589', 'A');
INSERT INTO `ey_region` VALUES ('17604', '湘东区', '3', '17589', 'X');
INSERT INTO `ey_region` VALUES ('17616', '莲花县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17630', '上栗县', '3', '17589', 'S');
INSERT INTO `ey_region` VALUES ('17640', '芦溪县', '3', '17589', 'L');
INSERT INTO `ey_region` VALUES ('17651', '九江市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('17652', '市辖区', '3', '17651', 'S');
INSERT INTO `ey_region` VALUES ('17653', '庐山区', '3', '17651', 'L');
INSERT INTO `ey_region` VALUES ('17667', '浔阳区', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17676', '九江县', '3', '17651', 'J');
INSERT INTO `ey_region` VALUES ('17693', '武宁县', '3', '17651', 'W');
INSERT INTO `ey_region` VALUES ('17714', '修水县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17751', '永修县', '3', '17651', 'Y');
INSERT INTO `ey_region` VALUES ('17773', '德安县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17792', '星子县', '3', '17651', 'X');
INSERT INTO `ey_region` VALUES ('17807', '都昌县', '3', '17651', 'D');
INSERT INTO `ey_region` VALUES ('17834', '湖口县', '3', '17651', 'H');
INSERT INTO `ey_region` VALUES ('17849', '彭泽县', '3', '17651', 'P');
INSERT INTO `ey_region` VALUES ('17872', '瑞昌市', '3', '17651', 'R');
INSERT INTO `ey_region` VALUES ('17894', '新余市', '2', '17359', 'X');
INSERT INTO `ey_region` VALUES ('17895', '市辖区', '3', '17894', 'S');
INSERT INTO `ey_region` VALUES ('17896', '渝水区', '3', '17894', 'Y');
INSERT INTO `ey_region` VALUES ('17917', '分宜县', '3', '17894', 'F');
INSERT INTO `ey_region` VALUES ('17934', '鹰潭市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('17935', '市辖区', '3', '17934', 'S');
INSERT INTO `ey_region` VALUES ('17936', '月湖区', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17945', '余江县', '3', '17934', 'Y');
INSERT INTO `ey_region` VALUES ('17966', '贵溪市', '3', '17934', 'G');
INSERT INTO `ey_region` VALUES ('17999', '赣州市', '2', '17359', 'G');
INSERT INTO `ey_region` VALUES ('18000', '市辖区', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18001', '章贡区', '3', '17999', 'Z');
INSERT INTO `ey_region` VALUES ('18016', '赣县', '3', '17999', 'G');
INSERT INTO `ey_region` VALUES ('18037', '信丰县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18055', '大余县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18068', '上犹县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18084', '崇义县', '3', '17999', 'C');
INSERT INTO `ey_region` VALUES ('18102', '安远县', '3', '17999', 'A');
INSERT INTO `ey_region` VALUES ('18122', '龙南县', '3', '17999', 'L');
INSERT INTO `ey_region` VALUES ('18139', '定南县', '3', '17999', 'D');
INSERT INTO `ey_region` VALUES ('18148', '全南县', '3', '17999', 'Q');
INSERT INTO `ey_region` VALUES ('18161', '宁都县', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18187', '于都县', '3', '17999', 'Y');
INSERT INTO `ey_region` VALUES ('18212', '兴国县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18239', '会昌县', '3', '17999', 'H');
INSERT INTO `ey_region` VALUES ('18260', '寻乌县', '3', '17999', 'X');
INSERT INTO `ey_region` VALUES ('18276', '石城县', '3', '17999', 'S');
INSERT INTO `ey_region` VALUES ('18287', '瑞金市', '3', '17999', 'R');
INSERT INTO `ey_region` VALUES ('18306', '南康市', '3', '17999', 'N');
INSERT INTO `ey_region` VALUES ('18330', '吉安市', '2', '17359', 'J');
INSERT INTO `ey_region` VALUES ('18331', '市辖区', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18332', '吉州区', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18345', '青原区', '3', '18330', 'Q');
INSERT INTO `ey_region` VALUES ('18356', '吉安县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18378', '吉水县', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18398', '峡江县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18411', '新干县', '3', '18330', 'X');
INSERT INTO `ey_region` VALUES ('18429', '永丰县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18454', '泰和县', '3', '18330', 'T');
INSERT INTO `ey_region` VALUES ('18483', '遂川县', '3', '18330', 'S');
INSERT INTO `ey_region` VALUES ('18510', '万安县', '3', '18330', 'W');
INSERT INTO `ey_region` VALUES ('18529', '安福县', '3', '18330', 'A');
INSERT INTO `ey_region` VALUES ('18550', '永新县', '3', '18330', 'Y');
INSERT INTO `ey_region` VALUES ('18575', '井冈山市', '3', '18330', 'J');
INSERT INTO `ey_region` VALUES ('18598', '宜春市', '2', '17359', 'Y');
INSERT INTO `ey_region` VALUES ('18599', '市辖区', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18600', '袁州区', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18639', '奉新县', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18659', '万载县', '3', '18598', 'W');
INSERT INTO `ey_region` VALUES ('18678', '上高县', '3', '18598', 'S');
INSERT INTO `ey_region` VALUES ('18696', '宜丰县', '3', '18598', 'Y');
INSERT INTO `ey_region` VALUES ('18714', '靖安县', '3', '18598', 'J');
INSERT INTO `ey_region` VALUES ('18727', '铜鼓县', '3', '18598', 'T');
INSERT INTO `ey_region` VALUES ('18741', '丰城市', '3', '18598', 'F');
INSERT INTO `ey_region` VALUES ('18777', '樟树市', '3', '18598', 'Z');
INSERT INTO `ey_region` VALUES ('18799', '高安市', '3', '18598', 'G');
INSERT INTO `ey_region` VALUES ('18829', '抚州市', '2', '17359', 'F');
INSERT INTO `ey_region` VALUES ('18830', '市辖区', '3', '18829', 'S');
INSERT INTO `ey_region` VALUES ('18831', '临川区', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18869', '南城县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18882', '黎川县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18900', '南丰县', '3', '18829', 'N');
INSERT INTO `ey_region` VALUES ('18915', '崇仁县', '3', '18829', 'C');
INSERT INTO `ey_region` VALUES ('18931', '乐安县', '3', '18829', 'L');
INSERT INTO `ey_region` VALUES ('18949', '宜黄县', '3', '18829', 'Y');
INSERT INTO `ey_region` VALUES ('18965', '金溪县', '3', '18829', 'J');
INSERT INTO `ey_region` VALUES ('18980', '资溪县', '3', '18829', 'Z');
INSERT INTO `ey_region` VALUES ('18988', '东乡县', '3', '18829', 'D');
INSERT INTO `ey_region` VALUES ('19010', '广昌县', '3', '18829', 'G');
INSERT INTO `ey_region` VALUES ('19024', '上饶市', '2', '17359', 'S');
INSERT INTO `ey_region` VALUES ('19025', '市辖区', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19026', '信州区', '3', '19024', 'X');
INSERT INTO `ey_region` VALUES ('19038', '上饶县', '3', '19024', 'S');
INSERT INTO `ey_region` VALUES ('19062', '广丰县', '3', '19024', 'G');
INSERT INTO `ey_region` VALUES ('19088', '玉山县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19108', '铅山县', '3', '19024', 'Q');
INSERT INTO `ey_region` VALUES ('19136', '横峰县', '3', '19024', 'H');
INSERT INTO `ey_region` VALUES ('19151', '弋阳县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19171', '余干县', '3', '19024', 'Y');
INSERT INTO `ey_region` VALUES ('19202', '鄱阳县', '3', '19024', 'P');
INSERT INTO `ey_region` VALUES ('19234', '万年县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19248', '婺源县', '3', '19024', 'W');
INSERT INTO `ey_region` VALUES ('19265', '德兴市', '3', '19024', 'D');
INSERT INTO `ey_region` VALUES ('19280', '山东省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('19281', '济南市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('19282', '市辖区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19283', '历下区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19295', '市中区', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19311', '槐荫区', '3', '19281', 'H');
INSERT INTO `ey_region` VALUES ('19326', '天桥区', '3', '19281', 'T');
INSERT INTO `ey_region` VALUES ('19342', '历城区', '3', '19281', 'L');
INSERT INTO `ey_region` VALUES ('19359', '长清区', '3', '19281', 'C');
INSERT INTO `ey_region` VALUES ('19370', '平阴县', '3', '19281', 'P');
INSERT INTO `ey_region` VALUES ('19378', '济阳县', '3', '19281', 'J');
INSERT INTO `ey_region` VALUES ('19387', '商河县', '3', '19281', 'S');
INSERT INTO `ey_region` VALUES ('19400', '章丘市', '3', '19281', 'Z');
INSERT INTO `ey_region` VALUES ('19421', '青岛市', '2', '19280', 'Q');
INSERT INTO `ey_region` VALUES ('19422', '市辖区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19423', '市南区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19438', '市北区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19456', '四方区', '3', '19421', 'S');
INSERT INTO `ey_region` VALUES ('19464', '黄岛区', '3', '19421', 'H');
INSERT INTO `ey_region` VALUES ('19471', '崂山区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19476', '李沧区', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19488', '城阳区', '3', '19421', 'C');
INSERT INTO `ey_region` VALUES ('19497', '胶州市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19516', '即墨市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19540', '平度市', '3', '19421', 'P');
INSERT INTO `ey_region` VALUES ('19572', '胶南市', '3', '19421', 'J');
INSERT INTO `ey_region` VALUES ('19590', '莱西市', '3', '19421', 'L');
INSERT INTO `ey_region` VALUES ('19608', '淄博市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19609', '市辖区', '3', '19608', 'S');
INSERT INTO `ey_region` VALUES ('19610', '淄川区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19632', '张店区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19649', '博山区', '3', '19608', 'B');
INSERT INTO `ey_region` VALUES ('19663', '临淄区', '3', '19608', 'L');
INSERT INTO `ey_region` VALUES ('19678', '周村区', '3', '19608', 'Z');
INSERT INTO `ey_region` VALUES ('19688', '桓台县', '3', '19608', 'H');
INSERT INTO `ey_region` VALUES ('19700', '高青县', '3', '19608', 'G');
INSERT INTO `ey_region` VALUES ('19710', '沂源县', '3', '19608', 'Y');
INSERT INTO `ey_region` VALUES ('19724', '枣庄市', '2', '19280', 'Z');
INSERT INTO `ey_region` VALUES ('19725', '市辖区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19726', '市中区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19738', '薛城区', '3', '19724', 'X');
INSERT INTO `ey_region` VALUES ('19748', '峄城区', '3', '19724', 'Y');
INSERT INTO `ey_region` VALUES ('19756', '台儿庄区', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19763', '山亭区', '3', '19724', 'S');
INSERT INTO `ey_region` VALUES ('19774', '滕州市', '3', '19724', 'T');
INSERT INTO `ey_region` VALUES ('19796', '东营市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('19797', '市辖区', '3', '19796', 'S');
INSERT INTO `ey_region` VALUES ('19798', '东营区', '3', '19796', 'D');
INSERT INTO `ey_region` VALUES ('19809', '河口区', '3', '19796', 'H');
INSERT INTO `ey_region` VALUES ('19817', '垦利县', '3', '19796', 'K');
INSERT INTO `ey_region` VALUES ('19825', '利津县', '3', '19796', 'L');
INSERT INTO `ey_region` VALUES ('19835', '广饶县', '3', '19796', 'G');
INSERT INTO `ey_region` VALUES ('19846', '烟台市', '2', '19280', 'Y');
INSERT INTO `ey_region` VALUES ('19847', '市辖区', '3', '19846', 'S');
INSERT INTO `ey_region` VALUES ('19848', '芝罘区', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19861', '福山区', '3', '19846', 'F');
INSERT INTO `ey_region` VALUES ('19873', '牟平区', '3', '19846', 'M');
INSERT INTO `ey_region` VALUES ('19887', '莱山区', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19893', '长岛县', '3', '19846', 'C');
INSERT INTO `ey_region` VALUES ('19902', '龙口市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19916', '莱阳市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19935', '莱州市', '3', '19846', 'L');
INSERT INTO `ey_region` VALUES ('19952', '蓬莱市', '3', '19846', 'P');
INSERT INTO `ey_region` VALUES ('19965', '招远市', '3', '19846', 'Z');
INSERT INTO `ey_region` VALUES ('19980', '栖霞市', '3', '19846', 'Q');
INSERT INTO `ey_region` VALUES ('19996', '海阳市', '3', '19846', 'H');
INSERT INTO `ey_region` VALUES ('20012', '潍坊市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20013', '市辖区', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20014', '潍城区', '3', '20012', 'W');
INSERT INTO `ey_region` VALUES ('20023', '寒亭区', '3', '20012', 'H');
INSERT INTO `ey_region` VALUES ('20034', '坊子区', '3', '20012', 'F');
INSERT INTO `ey_region` VALUES ('20043', '奎文区', '3', '20012', 'K');
INSERT INTO `ey_region` VALUES ('20055', '临朐县', '3', '20012', 'L');
INSERT INTO `ey_region` VALUES ('20074', '昌乐县', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20091', '青州市', '3', '20012', 'Q');
INSERT INTO `ey_region` VALUES ('20113', '诸城市', '3', '20012', 'Z');
INSERT INTO `ey_region` VALUES ('20137', '寿光市', '3', '20012', 'S');
INSERT INTO `ey_region` VALUES ('20155', '安丘市', '3', '20012', 'A');
INSERT INTO `ey_region` VALUES ('20179', '高密市', '3', '20012', 'G');
INSERT INTO `ey_region` VALUES ('20200', '昌邑市', '3', '20012', 'C');
INSERT INTO `ey_region` VALUES ('20216', '济宁市', '2', '19280', 'J');
INSERT INTO `ey_region` VALUES ('20217', '市辖区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20218', '市中区', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20227', '任城区', '3', '20216', 'R');
INSERT INTO `ey_region` VALUES ('20257', '鱼台县', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20268', '金乡县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20282', '嘉祥县', '3', '20216', 'J');
INSERT INTO `ey_region` VALUES ('20298', '汶上县', '3', '20216', 'W');
INSERT INTO `ey_region` VALUES ('20313', '泗水县', '3', '20216', 'S');
INSERT INTO `ey_region` VALUES ('20327', '梁山县', '3', '20216', 'L');
INSERT INTO `ey_region` VALUES ('20342', '曲阜市', '3', '20216', 'Q');
INSERT INTO `ey_region` VALUES ('20355', '兖州市', '3', '20216', 'Y');
INSERT INTO `ey_region` VALUES ('20368', '邹城市', '3', '20216', 'Z');
INSERT INTO `ey_region` VALUES ('20386', '泰安市', '2', '19280', 'T');
INSERT INTO `ey_region` VALUES ('20387', '市辖区', '3', '20386', 'S');
INSERT INTO `ey_region` VALUES ('20388', '泰山区', '3', '20386', 'T');
INSERT INTO `ey_region` VALUES ('20397', '岱岳区', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20416', '宁阳县', '3', '20386', 'N');
INSERT INTO `ey_region` VALUES ('20429', '东平县', '3', '20386', 'D');
INSERT INTO `ey_region` VALUES ('20444', '新泰市', '3', '20386', 'X');
INSERT INTO `ey_region` VALUES ('20465', '肥城市', '3', '20386', 'F');
INSERT INTO `ey_region` VALUES ('20480', '威海市', '2', '19280', 'W');
INSERT INTO `ey_region` VALUES ('20481', '市辖区', '3', '20480', 'S');
INSERT INTO `ey_region` VALUES ('20482', '环翠区', '3', '20480', 'H');
INSERT INTO `ey_region` VALUES ('20500', '文登市', '3', '20480', 'W');
INSERT INTO `ey_region` VALUES ('20519', '荣成市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20542', '乳山市', '3', '20480', 'R');
INSERT INTO `ey_region` VALUES ('20558', '日照市', '2', '19280', 'R');
INSERT INTO `ey_region` VALUES ('20559', '市辖区', '3', '20558', 'S');
INSERT INTO `ey_region` VALUES ('20560', '东港区', '3', '20558', 'D');
INSERT INTO `ey_region` VALUES ('20573', '岚山区', '3', '20558', 'L');
INSERT INTO `ey_region` VALUES ('20583', '五莲县', '3', '20558', 'W');
INSERT INTO `ey_region` VALUES ('20596', '莒县', '3', '20558', 'J');
INSERT INTO `ey_region` VALUES ('20618', '莱芜市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20619', '市辖区', '3', '20618', 'S');
INSERT INTO `ey_region` VALUES ('20620', '莱城区', '3', '20618', 'L');
INSERT INTO `ey_region` VALUES ('20636', '钢城区', '3', '20618', 'G');
INSERT INTO `ey_region` VALUES ('20642', '临沂市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20643', '临沂市辖区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20644', '兰山区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20656', '罗庄区', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20665', '河东区', '3', '20642', 'H');
INSERT INTO `ey_region` VALUES ('20678', '沂南县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20696', '郯城县', '3', '20642', 'T');
INSERT INTO `ey_region` VALUES ('20714', '沂水县', '3', '20642', 'Y');
INSERT INTO `ey_region` VALUES ('20734', '苍山县', '3', '20642', 'C');
INSERT INTO `ey_region` VALUES ('20756', '费县', '3', '20642', 'F');
INSERT INTO `ey_region` VALUES ('20775', '平邑县', '3', '20642', 'P');
INSERT INTO `ey_region` VALUES ('20792', '莒南县', '3', '20642', 'J');
INSERT INTO `ey_region` VALUES ('20811', '蒙阴县', '3', '20642', 'M');
INSERT INTO `ey_region` VALUES ('20823', '临沭县', '3', '20642', 'L');
INSERT INTO `ey_region` VALUES ('20836', '德州市', '2', '19280', 'D');
INSERT INTO `ey_region` VALUES ('20837', '市辖区', '3', '20836', 'S');
INSERT INTO `ey_region` VALUES ('20838', '德城区', '3', '20836', 'D');
INSERT INTO `ey_region` VALUES ('20850', '陵县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20864', '宁津县', '3', '20836', 'N');
INSERT INTO `ey_region` VALUES ('20876', '庆云县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20886', '临邑县', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20899', '齐河县', '3', '20836', 'Q');
INSERT INTO `ey_region` VALUES ('20914', '平原县', '3', '20836', 'P');
INSERT INTO `ey_region` VALUES ('20927', '夏津县', '3', '20836', 'X');
INSERT INTO `ey_region` VALUES ('20942', '武城县', '3', '20836', 'W');
INSERT INTO `ey_region` VALUES ('20952', '乐陵市', '3', '20836', 'L');
INSERT INTO `ey_region` VALUES ('20969', '禹城市', '3', '20836', 'Y');
INSERT INTO `ey_region` VALUES ('20981', '聊城市', '2', '19280', 'L');
INSERT INTO `ey_region` VALUES ('20982', '市辖区', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('20983', '东昌府区', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21004', '阳谷县', '3', '20981', 'Y');
INSERT INTO `ey_region` VALUES ('21023', '莘县', '3', '20981', 'S');
INSERT INTO `ey_region` VALUES ('21046', '茌平县', '3', '20981', 'C');
INSERT INTO `ey_region` VALUES ('21063', '东阿县', '3', '20981', 'D');
INSERT INTO `ey_region` VALUES ('21075', '冠县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21093', '高唐县', '3', '20981', 'G');
INSERT INTO `ey_region` VALUES ('21106', '临清市', '3', '20981', 'L');
INSERT INTO `ey_region` VALUES ('21123', '滨州市', '2', '19280', 'B');
INSERT INTO `ey_region` VALUES ('21124', '市辖区', '3', '21123', 'S');
INSERT INTO `ey_region` VALUES ('21125', '滨城区', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21141', '惠民县', '3', '21123', 'H');
INSERT INTO `ey_region` VALUES ('21156', '阳信县', '3', '21123', 'Y');
INSERT INTO `ey_region` VALUES ('21166', '无棣县', '3', '21123', 'W');
INSERT INTO `ey_region` VALUES ('21178', '沾化县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21190', '博兴县', '3', '21123', 'B');
INSERT INTO `ey_region` VALUES ('21201', '邹平县', '3', '21123', 'Z');
INSERT INTO `ey_region` VALUES ('21218', '菏泽市', '2', '19280', 'H');
INSERT INTO `ey_region` VALUES ('21219', '市辖区', '3', '21218', 'S');
INSERT INTO `ey_region` VALUES ('21220', '牡丹区', '3', '21218', 'M');
INSERT INTO `ey_region` VALUES ('21245', '曹县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21271', '单县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21292', '成武县', '3', '21218', 'C');
INSERT INTO `ey_region` VALUES ('21305', '巨野县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21322', '郓城县', '3', '21218', 'Y');
INSERT INTO `ey_region` VALUES ('21344', '鄄城县', '3', '21218', 'J');
INSERT INTO `ey_region` VALUES ('21361', '定陶县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21373', '东明县', '3', '21218', 'D');
INSERT INTO `ey_region` VALUES ('21387', '河南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('21388', '郑州市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('21389', '市辖区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21390', '中原区', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21404', '二七区', '3', '21388', 'E');
INSERT INTO `ey_region` VALUES ('21420', '管城回族区', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21435', '金水区', '3', '21388', 'J');
INSERT INTO `ey_region` VALUES ('21453', '上街区', '3', '21388', 'S');
INSERT INTO `ey_region` VALUES ('21460', '惠济区', '3', '21388', 'H');
INSERT INTO `ey_region` VALUES ('21469', '中牟县', '3', '21388', 'Z');
INSERT INTO `ey_region` VALUES ('21487', '巩义市', '3', '21388', 'G');
INSERT INTO `ey_region` VALUES ('21508', '荥阳市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21523', '新密市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21542', '新郑市', '3', '21388', 'X');
INSERT INTO `ey_region` VALUES ('21558', '登封市', '3', '21388', 'D');
INSERT INTO `ey_region` VALUES ('21575', '开封市', '2', '21387', 'K');
INSERT INTO `ey_region` VALUES ('21576', '市辖区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21577', '龙亭区', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21584', '顺河区', '3', '21575', 'S');
INSERT INTO `ey_region` VALUES ('21593', '鼓楼区', '3', '21575', 'G');
INSERT INTO `ey_region` VALUES ('21602', '禹王台区', '3', '21575', 'Y');
INSERT INTO `ey_region` VALUES ('21610', '金明区', '3', '21575', 'J');
INSERT INTO `ey_region` VALUES ('21618', '杞县', '3', '21575', 'Q');
INSERT INTO `ey_region` VALUES ('21640', '通许县', '3', '21575', 'T');
INSERT INTO `ey_region` VALUES ('21653', '尉氏县', '3', '21575', 'W');
INSERT INTO `ey_region` VALUES ('21671', '开封县', '3', '21575', 'K');
INSERT INTO `ey_region` VALUES ('21687', '兰考县', '3', '21575', 'L');
INSERT INTO `ey_region` VALUES ('21711', '洛阳市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('21712', '市辖区', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21713', '老城区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21722', '西工区', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21733', '廛河回族区', '3', '21711', 'C');
INSERT INTO `ey_region` VALUES ('21742', '涧西区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21758', '吉利区', '3', '21711', 'J');
INSERT INTO `ey_region` VALUES ('21761', '洛龙区', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21770', '孟津县', '3', '21711', 'M');
INSERT INTO `ey_region` VALUES ('21781', '新安县', '3', '21711', 'X');
INSERT INTO `ey_region` VALUES ('21794', '栾川县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21809', '嵩县', '3', '21711', 'S');
INSERT INTO `ey_region` VALUES ('21829', '汝阳县', '3', '21711', 'R');
INSERT INTO `ey_region` VALUES ('21844', '宜阳县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21862', '洛宁县', '3', '21711', 'L');
INSERT INTO `ey_region` VALUES ('21881', '伊川县', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21896', '偃师市', '3', '21711', 'Y');
INSERT INTO `ey_region` VALUES ('21913', '平顶山市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('21914', '市辖区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21915', '新华区', '3', '21913', 'X');
INSERT INTO `ey_region` VALUES ('21928', '卫东区', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('21940', '石龙区', '3', '21913', 'S');
INSERT INTO `ey_region` VALUES ('21945', '湛河区', '3', '21913', 'Z');
INSERT INTO `ey_region` VALUES ('21954', '宝丰县', '3', '21913', 'B');
INSERT INTO `ey_region` VALUES ('21968', '叶  县', '3', '21913', 'Y');
INSERT INTO `ey_region` VALUES ('21987', '鲁山县', '3', '21913', 'L');
INSERT INTO `ey_region` VALUES ('22009', '郏  县', '3', '21913', 'J');
INSERT INTO `ey_region` VALUES ('22024', '舞钢市', '3', '21913', 'W');
INSERT INTO `ey_region` VALUES ('22037', '汝州市', '3', '21913', 'R');
INSERT INTO `ey_region` VALUES ('22058', '安阳市', '2', '21387', 'A');
INSERT INTO `ey_region` VALUES ('22059', '市辖区', '3', '22058', 'S');
INSERT INTO `ey_region` VALUES ('22060', '文峰区', '3', '22058', 'W');
INSERT INTO `ey_region` VALUES ('22080', '北关区', '3', '22058', 'B');
INSERT INTO `ey_region` VALUES ('22090', '殷都区', '3', '22058', 'Y');
INSERT INTO `ey_region` VALUES ('22101', '龙安区', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22111', '安阳县', '3', '22058', 'A');
INSERT INTO `ey_region` VALUES ('22133', '汤阴县', '3', '22058', 'T');
INSERT INTO `ey_region` VALUES ('22144', '滑县', '3', '22058', 'H');
INSERT INTO `ey_region` VALUES ('22167', '内黄县', '3', '22058', 'N');
INSERT INTO `ey_region` VALUES ('22185', '林州市', '3', '22058', 'L');
INSERT INTO `ey_region` VALUES ('22206', '鹤壁市', '2', '21387', 'H');
INSERT INTO `ey_region` VALUES ('22207', '市辖区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22208', '鹤山区', '3', '22206', 'H');
INSERT INTO `ey_region` VALUES ('22216', '山城区', '3', '22206', 'S');
INSERT INTO `ey_region` VALUES ('22224', '淇滨区', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22232', '浚县', '3', '22206', 'J');
INSERT INTO `ey_region` VALUES ('22243', '淇县', '3', '22206', 'Q');
INSERT INTO `ey_region` VALUES ('22251', '新乡市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22252', '市辖区', '3', '22251', 'S');
INSERT INTO `ey_region` VALUES ('22253', '红旗区', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22264', '卫滨区', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22273', '凤泉区', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22279', '牧野区', '3', '22251', 'M');
INSERT INTO `ey_region` VALUES ('22290', '新乡县', '3', '22251', 'X');
INSERT INTO `ey_region` VALUES ('22299', '获嘉县', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22312', '原阳县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22330', '延津县', '3', '22251', 'Y');
INSERT INTO `ey_region` VALUES ('22347', '封丘县', '3', '22251', 'F');
INSERT INTO `ey_region` VALUES ('22367', '长垣县', '3', '22251', 'C');
INSERT INTO `ey_region` VALUES ('22386', '卫辉市', '3', '22251', 'W');
INSERT INTO `ey_region` VALUES ('22400', '辉县市', '3', '22251', 'H');
INSERT INTO `ey_region` VALUES ('22423', '焦作市', '2', '21387', 'J');
INSERT INTO `ey_region` VALUES ('22424', '市辖区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22425', '解放区', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22435', '中站区', '3', '22423', 'Z');
INSERT INTO `ey_region` VALUES ('22446', '马村区', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22454', '山阳区', '3', '22423', 'S');
INSERT INTO `ey_region` VALUES ('22465', '修武县', '3', '22423', 'X');
INSERT INTO `ey_region` VALUES ('22475', '博爱县', '3', '22423', 'B');
INSERT INTO `ey_region` VALUES ('22487', '武陟县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22503', '温县', '3', '22423', 'W');
INSERT INTO `ey_region` VALUES ('22515', '济源市', '3', '22423', 'J');
INSERT INTO `ey_region` VALUES ('22532', '沁阳市', '3', '22423', 'Q');
INSERT INTO `ey_region` VALUES ('22546', '孟州市', '3', '22423', 'M');
INSERT INTO `ey_region` VALUES ('22558', '濮阳市', '2', '21387', 'P');
INSERT INTO `ey_region` VALUES ('22559', '市辖区', '3', '22558', 'S');
INSERT INTO `ey_region` VALUES ('22560', '华龙区', '3', '22558', 'H');
INSERT INTO `ey_region` VALUES ('22578', '清丰县', '3', '22558', 'Q');
INSERT INTO `ey_region` VALUES ('22596', '南乐县', '3', '22558', 'N');
INSERT INTO `ey_region` VALUES ('22609', '范县', '3', '22558', 'F');
INSERT INTO `ey_region` VALUES ('22622', '台前县', '3', '22558', 'T');
INSERT INTO `ey_region` VALUES ('22632', '濮阳县', '3', '22558', 'P');
INSERT INTO `ey_region` VALUES ('22655', '许昌市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('22656', '市辖区', '3', '22655', 'S');
INSERT INTO `ey_region` VALUES ('22657', '魏都区', '3', '22655', 'W');
INSERT INTO `ey_region` VALUES ('22671', '许昌县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22688', '鄢陵县', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22701', '襄城县', '3', '22655', 'X');
INSERT INTO `ey_region` VALUES ('22718', '禹州市', '3', '22655', 'Y');
INSERT INTO `ey_region` VALUES ('22745', '长葛市', '3', '22655', 'C');
INSERT INTO `ey_region` VALUES ('22762', '漯河市', '2', '21387', 'L');
INSERT INTO `ey_region` VALUES ('22763', '市辖区', '3', '22762', 'S');
INSERT INTO `ey_region` VALUES ('22764', '源汇区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22773', '郾城区', '3', '22762', 'Y');
INSERT INTO `ey_region` VALUES ('22783', '召陵区', '3', '22762', 'Z');
INSERT INTO `ey_region` VALUES ('22793', '舞阳县', '3', '22762', 'W');
INSERT INTO `ey_region` VALUES ('22808', '临颖县', '3', '22762', 'L');
INSERT INTO `ey_region` VALUES ('22824', '三门峡市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('22825', '市辖区', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22826', '湖滨区', '3', '22824', 'H');
INSERT INTO `ey_region` VALUES ('22838', '渑池县', '3', '22824', 'M');
INSERT INTO `ey_region` VALUES ('22851', '陕县', '3', '22824', 'S');
INSERT INTO `ey_region` VALUES ('22865', '卢氏县', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22885', '义马市', '3', '22824', 'Y');
INSERT INTO `ey_region` VALUES ('22893', '灵宝市', '3', '22824', 'L');
INSERT INTO `ey_region` VALUES ('22910', '南阳市', '2', '21387', 'N');
INSERT INTO `ey_region` VALUES ('22911', '市辖区', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('22912', '宛城区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22930', '卧龙区', '3', '22910', 'W');
INSERT INTO `ey_region` VALUES ('22951', '南召县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('22973', '方城县', '3', '22910', 'F');
INSERT INTO `ey_region` VALUES ('22992', '西峡县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23013', '镇平县', '3', '22910', 'Z');
INSERT INTO `ey_region` VALUES ('23036', '内乡县', '3', '22910', 'N');
INSERT INTO `ey_region` VALUES ('23053', '淅川县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23071', '社旗县', '3', '22910', 'S');
INSERT INTO `ey_region` VALUES ('23087', '唐河县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23108', '新野县', '3', '22910', 'X');
INSERT INTO `ey_region` VALUES ('23123', '桐柏县', '3', '22910', 'T');
INSERT INTO `ey_region` VALUES ('23140', '邓州市', '3', '22910', 'D');
INSERT INTO `ey_region` VALUES ('23170', '商丘市', '2', '21387', 'S');
INSERT INTO `ey_region` VALUES ('23171', '市辖区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23172', '梁园区', '3', '23170', 'L');
INSERT INTO `ey_region` VALUES ('23192', '睢阳区', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23211', '民权县', '3', '23170', 'M');
INSERT INTO `ey_region` VALUES ('23232', '睢县', '3', '23170', 'S');
INSERT INTO `ey_region` VALUES ('23253', '宁陵县', '3', '23170', 'N');
INSERT INTO `ey_region` VALUES ('23268', '柘城县', '3', '23170', 'Z');
INSERT INTO `ey_region` VALUES ('23290', '虞城县', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23317', '夏邑县', '3', '23170', 'X');
INSERT INTO `ey_region` VALUES ('23342', '永城市', '3', '23170', 'Y');
INSERT INTO `ey_region` VALUES ('23372', '信阳市', '2', '21387', 'X');
INSERT INTO `ey_region` VALUES ('23373', '市辖区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23374', '浉河区', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23393', '平桥区', '3', '23372', 'P');
INSERT INTO `ey_region` VALUES ('23414', '罗山县', '3', '23372', 'L');
INSERT INTO `ey_region` VALUES ('23435', '光山县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23455', '新县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23471', '商城县', '3', '23372', 'S');
INSERT INTO `ey_region` VALUES ('23492', '固始县', '3', '23372', 'G');
INSERT INTO `ey_region` VALUES ('23525', '潢川县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23549', '淮滨县', '3', '23372', 'H');
INSERT INTO `ey_region` VALUES ('23567', '息县', '3', '23372', 'X');
INSERT INTO `ey_region` VALUES ('23589', '周口市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23590', '市辖区', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23591', '川汇区', '3', '23589', 'C');
INSERT INTO `ey_region` VALUES ('23604', '扶沟县', '3', '23589', 'F');
INSERT INTO `ey_region` VALUES ('23621', '西华县', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23647', '商水县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23672', '沈丘县', '3', '23589', 'S');
INSERT INTO `ey_region` VALUES ('23695', '郸城县', '3', '23589', 'D');
INSERT INTO `ey_region` VALUES ('23716', '淮阳县', '3', '23589', 'H');
INSERT INTO `ey_region` VALUES ('23736', '太康县', '3', '23589', 'T');
INSERT INTO `ey_region` VALUES ('23766', '鹿邑县', '3', '23589', 'L');
INSERT INTO `ey_region` VALUES ('23796', '项城市', '3', '23589', 'X');
INSERT INTO `ey_region` VALUES ('23818', '驻马店市', '2', '21387', 'Z');
INSERT INTO `ey_region` VALUES ('23819', '市辖区', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23820', '驿城区', '3', '23818', 'Y');
INSERT INTO `ey_region` VALUES ('23840', '西平县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('23861', '上蔡县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23886', '平舆县', '3', '23818', 'P');
INSERT INTO `ey_region` VALUES ('23905', '正阳县', '3', '23818', 'Z');
INSERT INTO `ey_region` VALUES ('23926', '确山县', '3', '23818', 'Q');
INSERT INTO `ey_region` VALUES ('23940', '泌阳县', '3', '23818', 'M');
INSERT INTO `ey_region` VALUES ('23965', '汝南县', '3', '23818', 'R');
INSERT INTO `ey_region` VALUES ('23983', '遂平县', '3', '23818', 'S');
INSERT INTO `ey_region` VALUES ('23999', '新蔡县', '3', '23818', 'X');
INSERT INTO `ey_region` VALUES ('24022', '湖北省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('24023', '武汉市', '2', '24022', 'W');
INSERT INTO `ey_region` VALUES ('24024', '市辖区', '3', '24023', 'S');
INSERT INTO `ey_region` VALUES ('24025', '江岸区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24043', '江汉区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24057', '硚口区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24069', '汉阳区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24082', '武昌区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24098', '青山区', '3', '24023', 'Q');
INSERT INTO `ey_region` VALUES ('24111', '洪山区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24129', '东西湖区', '3', '24023', 'D');
INSERT INTO `ey_region` VALUES ('24142', '汉南区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24150', '蔡甸区', '3', '24023', 'C');
INSERT INTO `ey_region` VALUES ('24165', '江夏区', '3', '24023', 'J');
INSERT INTO `ey_region` VALUES ('24185', '黄陂区', '3', '24023', 'H');
INSERT INTO `ey_region` VALUES ('24205', '武汉市新洲区', '3', '24023', 'W');
INSERT INTO `ey_region` VALUES ('24224', '黄石市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('24225', '市辖区', '3', '24224', 'S');
INSERT INTO `ey_region` VALUES ('24226', '黄石港区', '3', '24224', 'H');
INSERT INTO `ey_region` VALUES ('24233', '西塞山区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24242', '下陆区', '3', '24224', 'X');
INSERT INTO `ey_region` VALUES ('24247', '铁山区', '3', '24224', 'T');
INSERT INTO `ey_region` VALUES ('24250', '阳新县', '3', '24224', 'Y');
INSERT INTO `ey_region` VALUES ('24273', '大冶市', '3', '24224', 'D');
INSERT INTO `ey_region` VALUES ('24291', '十堰市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('24292', '市辖区', '3', '24291', 'S');
INSERT INTO `ey_region` VALUES ('24293', '茅箭区', '3', '24291', 'M');
INSERT INTO `ey_region` VALUES ('24302', '张湾区', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24314', '郧县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24335', '郧西县', '3', '24291', 'Y');
INSERT INTO `ey_region` VALUES ('24354', '竹山县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24374', '竹溪县', '3', '24291', 'Z');
INSERT INTO `ey_region` VALUES ('24405', '房县', '3', '24291', 'F');
INSERT INTO `ey_region` VALUES ('24435', '丹江口市', '3', '24291', 'D');
INSERT INTO `ey_region` VALUES ('24453', '宜昌市', '2', '24022', 'Y');
INSERT INTO `ey_region` VALUES ('24454', '市辖区', '3', '24453', 'S');
INSERT INTO `ey_region` VALUES ('24455', '西陵区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24465', '伍家岗区', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24471', '点军区', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24477', '猇亭区', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24481', '夷陵区', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24495', '远安县', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24503', '兴山县', '3', '24453', 'X');
INSERT INTO `ey_region` VALUES ('24512', '秭归县', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24525', '长阳县', '3', '24453', 'C');
INSERT INTO `ey_region` VALUES ('24537', '五峰县', '3', '24453', 'W');
INSERT INTO `ey_region` VALUES ('24546', '宜都市', '3', '24453', 'Y');
INSERT INTO `ey_region` VALUES ('24559', '当阳市', '3', '24453', 'D');
INSERT INTO `ey_region` VALUES ('24570', '枝江市', '3', '24453', 'Z');
INSERT INTO `ey_region` VALUES ('24580', '襄樊市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24581', '市辖区', '3', '24580', 'S');
INSERT INTO `ey_region` VALUES ('24582', '襄城区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24591', '樊城区', '3', '24580', 'F');
INSERT INTO `ey_region` VALUES ('24608', '襄阳区', '3', '24580', 'X');
INSERT INTO `ey_region` VALUES ('24623', '南漳县', '3', '24580', 'N');
INSERT INTO `ey_region` VALUES ('24635', '谷城县', '3', '24580', 'G');
INSERT INTO `ey_region` VALUES ('24647', '保康县', '3', '24580', 'B');
INSERT INTO `ey_region` VALUES ('24659', '老河口市', '3', '24580', 'L');
INSERT INTO `ey_region` VALUES ('24674', '枣阳市', '3', '24580', 'Z');
INSERT INTO `ey_region` VALUES ('24692', '宜城市', '3', '24580', 'Y');
INSERT INTO `ey_region` VALUES ('24706', '鄂州市', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('24707', '市辖区', '3', '24706', 'S');
INSERT INTO `ey_region` VALUES ('24708', '粱子湖区', '3', '24706', 'L');
INSERT INTO `ey_region` VALUES ('24714', '华容区', '3', '24706', 'H');
INSERT INTO `ey_region` VALUES ('24722', '鄂城区', '3', '24706', 'E');
INSERT INTO `ey_region` VALUES ('24737', '荆门市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24738', '市辖区', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24739', '东宝区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24749', '掇刀区', '3', '24737', 'D');
INSERT INTO `ey_region` VALUES ('24755', '京山县', '3', '24737', 'J');
INSERT INTO `ey_region` VALUES ('24778', '沙洋县', '3', '24737', 'S');
INSERT INTO `ey_region` VALUES ('24794', '钟祥市', '3', '24737', 'Z');
INSERT INTO `ey_region` VALUES ('24816', '孝感市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('24817', '市辖区', '3', '24816', 'S');
INSERT INTO `ey_region` VALUES ('24818', '孝南区', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24838', '孝昌县', '3', '24816', 'X');
INSERT INTO `ey_region` VALUES ('24853', '大悟县', '3', '24816', 'D');
INSERT INTO `ey_region` VALUES ('24871', '云梦县', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24885', '应城市', '3', '24816', 'Y');
INSERT INTO `ey_region` VALUES ('24903', '安陆市', '3', '24816', 'A');
INSERT INTO `ey_region` VALUES ('24920', '汉川市', '3', '24816', 'H');
INSERT INTO `ey_region` VALUES ('24949', '荆州市', '2', '24022', 'J');
INSERT INTO `ey_region` VALUES ('24950', '市辖区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24951', '沙市区', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('24965', '荆州区', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('24978', '公安县', '3', '24949', 'G');
INSERT INTO `ey_region` VALUES ('24995', '监利县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25019', '江陵县', '3', '24949', 'J');
INSERT INTO `ey_region` VALUES ('25032', '石首市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25048', '洪湖市', '3', '24949', 'H');
INSERT INTO `ey_region` VALUES ('25069', '松滋市', '3', '24949', 'S');
INSERT INTO `ey_region` VALUES ('25086', '黄冈市', '2', '24022', 'H');
INSERT INTO `ey_region` VALUES ('25087', '市辖区', '3', '25086', 'S');
INSERT INTO `ey_region` VALUES ('25088', '黄州区', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25099', '团风县', '3', '25086', 'T');
INSERT INTO `ey_region` VALUES ('25112', '红安县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25126', '罗田县', '3', '25086', 'L');
INSERT INTO `ey_region` VALUES ('25143', '英山县', '3', '25086', 'Y');
INSERT INTO `ey_region` VALUES ('25158', '浠水县', '3', '25086', 'X');
INSERT INTO `ey_region` VALUES ('25175', '蕲春县', '3', '25086', 'Q');
INSERT INTO `ey_region` VALUES ('25192', '黄梅县', '3', '25086', 'H');
INSERT INTO `ey_region` VALUES ('25211', '麻城市', '3', '25086', 'M');
INSERT INTO `ey_region` VALUES ('25235', '武穴市', '3', '25086', 'W');
INSERT INTO `ey_region` VALUES ('25249', '咸宁市', '2', '24022', 'X');
INSERT INTO `ey_region` VALUES ('25250', '市辖区', '3', '25249', 'S');
INSERT INTO `ey_region` VALUES ('25251', '咸安区', '3', '25249', 'X');
INSERT INTO `ey_region` VALUES ('25266', '嘉鱼县', '3', '25249', 'J');
INSERT INTO `ey_region` VALUES ('25276', '通城县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25290', '崇阳县', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25303', '通山县', '3', '25249', 'T');
INSERT INTO `ey_region` VALUES ('25317', '赤壁市', '3', '25249', 'C');
INSERT INTO `ey_region` VALUES ('25335', '随州市', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25336', '市辖区', '3', '25335', 'S');
INSERT INTO `ey_region` VALUES ('25337', '曾都区', '3', '25335', 'Z');
INSERT INTO `ey_region` VALUES ('25367', '广水市', '3', '25335', 'G');
INSERT INTO `ey_region` VALUES ('25388', '恩施州', '2', '24022', 'E');
INSERT INTO `ey_region` VALUES ('25389', '恩施市', '3', '25388', 'E');
INSERT INTO `ey_region` VALUES ('25406', '利川市', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25422', '建始县', '3', '25388', 'J');
INSERT INTO `ey_region` VALUES ('25433', '巴东县', '3', '25388', 'B');
INSERT INTO `ey_region` VALUES ('25446', '宣恩县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25456', '咸丰县', '3', '25388', 'X');
INSERT INTO `ey_region` VALUES ('25467', '来凤县', '3', '25388', 'L');
INSERT INTO `ey_region` VALUES ('25476', '鹤峰县', '3', '25388', 'H');
INSERT INTO `ey_region` VALUES ('25487', '省直辖行政单位', '2', '24022', 'S');
INSERT INTO `ey_region` VALUES ('25488', '仙桃市', '3', '25487', 'X');
INSERT INTO `ey_region` VALUES ('25516', '潜江市', '3', '25487', 'Q');
INSERT INTO `ey_region` VALUES ('25541', '天门市', '3', '25487', 'T');
INSERT INTO `ey_region` VALUES ('25570', '神农架林区', '3', '25487', 'S');
INSERT INTO `ey_region` VALUES ('25579', '湖南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('25580', '长沙市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('25581', '市辖区', '3', '25580', 'S');
INSERT INTO `ey_region` VALUES ('25582', '芙蓉区', '3', '25580', 'F');
INSERT INTO `ey_region` VALUES ('25596', '天心区', '3', '25580', 'T');
INSERT INTO `ey_region` VALUES ('25607', '岳麓区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25620', '开福区', '3', '25580', 'K');
INSERT INTO `ey_region` VALUES ('25634', '雨花区', '3', '25580', 'Y');
INSERT INTO `ey_region` VALUES ('25645', '长沙县', '3', '25580', 'C');
INSERT INTO `ey_region` VALUES ('25666', '望城县', '3', '25580', 'W');
INSERT INTO `ey_region` VALUES ('25686', '宁乡县', '3', '25580', 'N');
INSERT INTO `ey_region` VALUES ('25720', '浏阳市', '3', '25580', 'L');
INSERT INTO `ey_region` VALUES ('25758', '株洲市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('25759', '市辖区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25760', '荷塘区', '3', '25758', 'H');
INSERT INTO `ey_region` VALUES ('25768', '芦淞区', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25777', '石峰区', '3', '25758', 'S');
INSERT INTO `ey_region` VALUES ('25785', '天元区', '3', '25758', 'T');
INSERT INTO `ey_region` VALUES ('25791', '株洲县', '3', '25758', 'Z');
INSERT INTO `ey_region` VALUES ('25810', '攸县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25836', '茶陵县', '3', '25758', 'C');
INSERT INTO `ey_region` VALUES ('25863', '炎陵县', '3', '25758', 'Y');
INSERT INTO `ey_region` VALUES ('25881', '醴陵市', '3', '25758', 'L');
INSERT INTO `ey_region` VALUES ('25912', '湘潭市', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('25913', '市辖区', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('25914', '雨湖区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25929', '岳塘区', '3', '25912', 'Y');
INSERT INTO `ey_region` VALUES ('25947', '湘潭县', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25970', '湘乡市', '3', '25912', 'X');
INSERT INTO `ey_region` VALUES ('25993', '韶山市', '3', '25912', 'S');
INSERT INTO `ey_region` VALUES ('26001', '衡阳市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('26002', '市辖区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26003', '珠晖区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26019', '雁峰区', '3', '26001', 'Y');
INSERT INTO `ey_region` VALUES ('26028', '石鼓区', '3', '26001', 'S');
INSERT INTO `ey_region` VALUES ('26037', '蒸湘区', '3', '26001', 'Z');
INSERT INTO `ey_region` VALUES ('26045', '南岳区', '3', '26001', 'N');
INSERT INTO `ey_region` VALUES ('26051', '衡阳县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26080', '衡南县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26112', '衡山县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26130', '衡东县', '3', '26001', 'H');
INSERT INTO `ey_region` VALUES ('26155', '祁东县', '3', '26001', 'Q');
INSERT INTO `ey_region` VALUES ('26179', '耒阳市', '3', '26001', 'L');
INSERT INTO `ey_region` VALUES ('26215', '常宁市', '3', '26001', 'C');
INSERT INTO `ey_region` VALUES ('26242', '邵阳市', '2', '25579', 'S');
INSERT INTO `ey_region` VALUES ('26243', '市辖区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26244', '双清区', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26257', '大祥区', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26272', '北塔区', '3', '26242', 'B');
INSERT INTO `ey_region` VALUES ('26279', '邵东县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26306', '新邵县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26322', '邵阳县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26348', '隆回县', '3', '26242', 'L');
INSERT INTO `ey_region` VALUES ('26375', '洞口县', '3', '26242', 'D');
INSERT INTO `ey_region` VALUES ('26399', '绥宁县', '3', '26242', 'S');
INSERT INTO `ey_region` VALUES ('26425', '新宁县', '3', '26242', 'X');
INSERT INTO `ey_region` VALUES ('26444', '城步县', '3', '26242', 'C');
INSERT INTO `ey_region` VALUES ('26465', '武冈市', '3', '26242', 'W');
INSERT INTO `ey_region` VALUES ('26485', '岳阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('26486', '市辖区', '3', '26485', 'S');
INSERT INTO `ey_region` VALUES ('26487', '岳阳楼区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26511', '云溪区', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26521', '君山区', '3', '26485', 'J');
INSERT INTO `ey_region` VALUES ('26529', '岳阳县', '3', '26485', 'Y');
INSERT INTO `ey_region` VALUES ('26551', '华容县', '3', '26485', 'H');
INSERT INTO `ey_region` VALUES ('26572', '湘阴县', '3', '26485', 'X');
INSERT INTO `ey_region` VALUES ('26592', '平江县', '3', '26485', 'P');
INSERT INTO `ey_region` VALUES ('26620', '汩罗市', '3', '26485', 'G');
INSERT INTO `ey_region` VALUES ('26657', '临湘市', '3', '26485', 'L');
INSERT INTO `ey_region` VALUES ('26683', '常德市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('26684', '市辖区', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26685', '武陵区', '3', '26683', 'W');
INSERT INTO `ey_region` VALUES ('26702', '鼎城区', '3', '26683', 'D');
INSERT INTO `ey_region` VALUES ('26741', '安乡县', '3', '26683', 'A');
INSERT INTO `ey_region` VALUES ('26762', '汉寿县', '3', '26683', 'H');
INSERT INTO `ey_region` VALUES ('26793', '澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26826', '临澧县', '3', '26683', 'L');
INSERT INTO `ey_region` VALUES ('26844', '桃源县', '3', '26683', 'T');
INSERT INTO `ey_region` VALUES ('26885', '石门县', '3', '26683', 'S');
INSERT INTO `ey_region` VALUES ('26912', '津市市', '3', '26683', 'J');
INSERT INTO `ey_region` VALUES ('26925', '张家界市', '2', '25579', 'Z');
INSERT INTO `ey_region` VALUES ('26926', '市辖区', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('26927', '永定区', '3', '26925', 'Y');
INSERT INTO `ey_region` VALUES ('26959', '武陵源区', '3', '26925', 'W');
INSERT INTO `ey_region` VALUES ('26966', '慈利县', '3', '26925', 'C');
INSERT INTO `ey_region` VALUES ('26998', '桑植县', '3', '26925', 'S');
INSERT INTO `ey_region` VALUES ('27038', '益阳市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27039', '市辖区', '3', '27038', 'S');
INSERT INTO `ey_region` VALUES ('27040', '资阳区', '3', '27038', 'Z');
INSERT INTO `ey_region` VALUES ('27049', '赫山区', '3', '27038', 'H');
INSERT INTO `ey_region` VALUES ('27069', '南县', '3', '27038', 'N');
INSERT INTO `ey_region` VALUES ('27087', '桃江县', '3', '27038', 'T');
INSERT INTO `ey_region` VALUES ('27106', '安化县', '3', '27038', 'A');
INSERT INTO `ey_region` VALUES ('27130', '沅江市', '3', '27038', 'Y');
INSERT INTO `ey_region` VALUES ('27147', '郴州市', '2', '25579', 'C');
INSERT INTO `ey_region` VALUES ('27148', '市辖区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27149', '北湖区', '3', '27147', 'B');
INSERT INTO `ey_region` VALUES ('27168', '苏仙区', '3', '27147', 'S');
INSERT INTO `ey_region` VALUES ('27188', '桂阳县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27228', '宜章县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27256', '永兴县', '3', '27147', 'Y');
INSERT INTO `ey_region` VALUES ('27282', '嘉禾县', '3', '27147', 'J');
INSERT INTO `ey_region` VALUES ('27300', '临武县', '3', '27147', 'L');
INSERT INTO `ey_region` VALUES ('27323', '汝城县', '3', '27147', 'R');
INSERT INTO `ey_region` VALUES ('27347', '桂东县', '3', '27147', 'G');
INSERT INTO `ey_region` VALUES ('27367', '安仁县', '3', '27147', 'A');
INSERT INTO `ey_region` VALUES ('27389', '资兴市', '3', '27147', 'Z');
INSERT INTO `ey_region` VALUES ('27418', '永州市', '2', '25579', 'Y');
INSERT INTO `ey_region` VALUES ('27419', '市辖区', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27420', '零陵区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27437', '冷水滩区', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27459', '祁阳县', '3', '27418', 'Q');
INSERT INTO `ey_region` VALUES ('27492', '东安县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27511', '双牌县', '3', '27418', 'S');
INSERT INTO `ey_region` VALUES ('27527', '道县', '3', '27418', 'D');
INSERT INTO `ey_region` VALUES ('27554', '江永县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27567', '宁远县', '3', '27418', 'N');
INSERT INTO `ey_region` VALUES ('27585', '蓝山县', '3', '27418', 'L');
INSERT INTO `ey_region` VALUES ('27606', '新田县', '3', '27418', 'X');
INSERT INTO `ey_region` VALUES ('27626', '江华县', '3', '27418', 'J');
INSERT INTO `ey_region` VALUES ('27650', '怀化市', '2', '25579', 'H');
INSERT INTO `ey_region` VALUES ('27651', '市辖区', '3', '27650', 'S');
INSERT INTO `ey_region` VALUES ('27652', '鹤城区', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27667', '中方县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27690', '沅陵县', '3', '27650', 'Y');
INSERT INTO `ey_region` VALUES ('27714', '辰溪县', '3', '27650', 'C');
INSERT INTO `ey_region` VALUES ('27745', '溆浦县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27789', '会同县', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27815', '麻阳县', '3', '27650', 'M');
INSERT INTO `ey_region` VALUES ('27839', '新晃县', '3', '27650', 'X');
INSERT INTO `ey_region` VALUES ('27863', '芷江县', '3', '27650', 'Z');
INSERT INTO `ey_region` VALUES ('27892', '靖州苗族侗族县', '3', '27650', 'J');
INSERT INTO `ey_region` VALUES ('27906', '通道县', '3', '27650', 'T');
INSERT INTO `ey_region` VALUES ('27930', '洪江市', '3', '27650', 'H');
INSERT INTO `ey_region` VALUES ('27963', '娄底市', '2', '25579', 'L');
INSERT INTO `ey_region` VALUES ('27964', '市辖区', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27965', '娄星区', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('27980', '双峰县', '3', '27963', 'S');
INSERT INTO `ey_region` VALUES ('27997', '新化县', '3', '27963', 'X');
INSERT INTO `ey_region` VALUES ('28027', '冷水江市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28044', '涟源市', '3', '27963', 'L');
INSERT INTO `ey_region` VALUES ('28065', '湘西州', '2', '25579', 'X');
INSERT INTO `ey_region` VALUES ('28066', '吉首市', '3', '28065', 'J');
INSERT INTO `ey_region` VALUES ('28082', '泸溪县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28099', '凤凰县', '3', '28065', 'F');
INSERT INTO `ey_region` VALUES ('28124', '花垣县', '3', '28065', 'H');
INSERT INTO `ey_region` VALUES ('28143', '保靖县', '3', '28065', 'B');
INSERT INTO `ey_region` VALUES ('28161', '古丈县', '3', '28065', 'G');
INSERT INTO `ey_region` VALUES ('28174', '永顺县', '3', '28065', 'Y');
INSERT INTO `ey_region` VALUES ('28205', '龙山县', '3', '28065', 'L');
INSERT INTO `ey_region` VALUES ('28240', '广东省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('28241', '广州市', '2', '28240', 'G');
INSERT INTO `ey_region` VALUES ('28242', '市辖区', '3', '28241', 'S');
INSERT INTO `ey_region` VALUES ('28243', '荔湾区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28266', '越秀区', '3', '28241', 'Y');
INSERT INTO `ey_region` VALUES ('28289', '海珠区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28308', '天河区', '3', '28241', 'T');
INSERT INTO `ey_region` VALUES ('28330', '白云区', '3', '28241', 'B');
INSERT INTO `ey_region` VALUES ('28349', '黄埔区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28359', '番禺区', '3', '28241', 'F');
INSERT INTO `ey_region` VALUES ('28377', '花都区', '3', '28241', 'H');
INSERT INTO `ey_region` VALUES ('28386', '南沙区', '3', '28241', 'N');
INSERT INTO `ey_region` VALUES ('28392', '萝岗区', '3', '28241', 'L');
INSERT INTO `ey_region` VALUES ('28399', '增城市', '3', '28241', 'Z');
INSERT INTO `ey_region` VALUES ('28409', '从化市', '3', '28241', 'C');
INSERT INTO `ey_region` VALUES ('28421', '韶关市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28422', '市辖区', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28423', '武江区', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28431', '浈江区', '3', '28421', 'Z');
INSERT INTO `ey_region` VALUES ('28448', '曲江区', '3', '28421', 'Q');
INSERT INTO `ey_region` VALUES ('28463', '始兴县', '3', '28421', 'S');
INSERT INTO `ey_region` VALUES ('28475', '仁化县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28488', '翁源县', '3', '28421', 'W');
INSERT INTO `ey_region` VALUES ('28497', '乳源县', '3', '28421', 'R');
INSERT INTO `ey_region` VALUES ('28509', '新丰县', '3', '28421', 'X');
INSERT INTO `ey_region` VALUES ('28517', '乐昌市', '3', '28421', 'L');
INSERT INTO `ey_region` VALUES ('28539', '南雄市', '3', '28421', 'N');
INSERT INTO `ey_region` VALUES ('28558', '深圳市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28559', '市辖区', '3', '28558', 'S');
INSERT INTO `ey_region` VALUES ('28560', '罗湖区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28571', '福田区', '3', '28558', 'F');
INSERT INTO `ey_region` VALUES ('28581', '南山区', '3', '28558', 'N');
INSERT INTO `ey_region` VALUES ('28590', '宝安区', '3', '28558', 'B');
INSERT INTO `ey_region` VALUES ('28604', '龙岗区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('28619', '盐田区', '3', '28558', 'Y');
INSERT INTO `ey_region` VALUES ('28626', '珠海市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28627', '市辖区', '3', '28626', 'S');
INSERT INTO `ey_region` VALUES ('28628', '香洲区', '3', '28626', 'X');
INSERT INTO `ey_region` VALUES ('28646', '斗门区', '3', '28626', 'D');
INSERT INTO `ey_region` VALUES ('28654', '金湾区', '3', '28626', 'J');
INSERT INTO `ey_region` VALUES ('28659', '汕头市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('28660', '市辖区', '3', '28659', 'S');
INSERT INTO `ey_region` VALUES ('28661', '龙湖区', '3', '28659', 'L');
INSERT INTO `ey_region` VALUES ('28669', '金平区', '3', '28659', 'J');
INSERT INTO `ey_region` VALUES ('28687', '濠江区', '3', '28659', 'H');
INSERT INTO `ey_region` VALUES ('28695', '潮阳区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28709', '潮南区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28721', '澄海区', '3', '28659', 'C');
INSERT INTO `ey_region` VALUES ('28733', '南澳县', '3', '28659', 'N');
INSERT INTO `ey_region` VALUES ('28737', '佛山市', '2', '28240', 'F');
INSERT INTO `ey_region` VALUES ('28738', '市辖区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28739', '禅城区', '3', '28737', 'C');
INSERT INTO `ey_region` VALUES ('28744', '南海区', '3', '28737', 'N');
INSERT INTO `ey_region` VALUES ('28753', '顺德区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28764', '三水区', '3', '28737', 'S');
INSERT INTO `ey_region` VALUES ('28776', '高明区', '3', '28737', 'G');
INSERT INTO `ey_region` VALUES ('28785', '江门市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('28786', '市辖区', '3', '28785', 'S');
INSERT INTO `ey_region` VALUES ('28787', '蓬江区', '3', '28785', 'P');
INSERT INTO `ey_region` VALUES ('28797', '江海区', '3', '28785', 'J');
INSERT INTO `ey_region` VALUES ('28803', '新会区', '3', '28785', 'X');
INSERT INTO `ey_region` VALUES ('28818', '台山市', '3', '28785', 'T');
INSERT INTO `ey_region` VALUES ('28837', '开平市', '3', '28785', 'K');
INSERT INTO `ey_region` VALUES ('28853', '鹤山市', '3', '28785', 'H');
INSERT INTO `ey_region` VALUES ('28867', '恩平市', '3', '28785', 'E');
INSERT INTO `ey_region` VALUES ('28880', '湛江市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('28881', '市辖区', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28882', '湛江市赤坎区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28891', '湛江市霞山区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28904', '湛江市坡头区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28914', '湛江市麻章区', '3', '28880', 'Z');
INSERT INTO `ey_region` VALUES ('28923', '遂溪县', '3', '28880', 'S');
INSERT INTO `ey_region` VALUES ('28941', '徐闻县', '3', '28880', 'X');
INSERT INTO `ey_region` VALUES ('28962', '廉江市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('28984', '雷州市', '3', '28880', 'L');
INSERT INTO `ey_region` VALUES ('29010', '吴川市', '3', '28880', 'W');
INSERT INTO `ey_region` VALUES ('29026', '茂名市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29027', '市辖区', '3', '29026', 'S');
INSERT INTO `ey_region` VALUES ('29028', '茂南区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29045', '茂港区', '3', '29026', 'M');
INSERT INTO `ey_region` VALUES ('29053', '电白县', '3', '29026', 'D');
INSERT INTO `ey_region` VALUES ('29075', '高州市', '3', '29026', 'G');
INSERT INTO `ey_region` VALUES ('29107', '化州市', '3', '29026', 'H');
INSERT INTO `ey_region` VALUES ('29138', '信宜市', '3', '29026', 'X');
INSERT INTO `ey_region` VALUES ('29159', '肇庆市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29160', '市辖区', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29161', '端州区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29169', '鼎湖区', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29178', '广宁县', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29196', '怀集县', '3', '29159', 'H');
INSERT INTO `ey_region` VALUES ('29217', '封开县', '3', '29159', 'F');
INSERT INTO `ey_region` VALUES ('29234', '德庆县', '3', '29159', 'D');
INSERT INTO `ey_region` VALUES ('29248', '高要市', '3', '29159', 'G');
INSERT INTO `ey_region` VALUES ('29266', '四会市', '3', '29159', 'S');
INSERT INTO `ey_region` VALUES ('29282', '惠州市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29283', '市辖区', '3', '29282', 'S');
INSERT INTO `ey_region` VALUES ('29284', '惠城区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29304', '惠阳区', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29317', '博罗县', '3', '29282', 'B');
INSERT INTO `ey_region` VALUES ('29335', '惠东县', '3', '29282', 'H');
INSERT INTO `ey_region` VALUES ('29355', '龙门县', '3', '29282', 'L');
INSERT INTO `ey_region` VALUES ('29371', '梅州市', '2', '28240', 'M');
INSERT INTO `ey_region` VALUES ('29372', '市辖区', '3', '29371', 'S');
INSERT INTO `ey_region` VALUES ('29373', '梅江区', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29380', '梅县', '3', '29371', 'M');
INSERT INTO `ey_region` VALUES ('29400', '大埔县', '3', '29371', 'D');
INSERT INTO `ey_region` VALUES ('29418', '丰顺县', '3', '29371', 'F');
INSERT INTO `ey_region` VALUES ('29436', '五华县', '3', '29371', 'W');
INSERT INTO `ey_region` VALUES ('29453', '平远县', '3', '29371', 'P');
INSERT INTO `ey_region` VALUES ('29466', '蕉岭县', '3', '29371', 'J');
INSERT INTO `ey_region` VALUES ('29477', '兴宁市', '3', '29371', 'X');
INSERT INTO `ey_region` VALUES ('29498', '汕尾市', '2', '28240', 'S');
INSERT INTO `ey_region` VALUES ('29499', '市辖区', '3', '29498', 'S');
INSERT INTO `ey_region` VALUES ('29500', '城区', '3', '29498', 'C');
INSERT INTO `ey_region` VALUES ('29511', '海丰县', '3', '29498', 'H');
INSERT INTO `ey_region` VALUES ('29529', '陆河县', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29538', '陆丰市', '3', '29498', 'L');
INSERT INTO `ey_region` VALUES ('29568', '河源市', '2', '28240', 'H');
INSERT INTO `ey_region` VALUES ('29569', '市辖区', '3', '29568', 'S');
INSERT INTO `ey_region` VALUES ('29570', '源城区', '3', '29568', 'Y');
INSERT INTO `ey_region` VALUES ('29578', '紫金县', '3', '29568', 'Z');
INSERT INTO `ey_region` VALUES ('29599', '龙川县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29625', '连平县', '3', '29568', 'L');
INSERT INTO `ey_region` VALUES ('29639', '和平县', '3', '29568', 'H');
INSERT INTO `ey_region` VALUES ('29657', '东源县', '3', '29568', 'D');
INSERT INTO `ey_region` VALUES ('29679', '阳江市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('29680', '市辖区', '3', '29679', 'S');
INSERT INTO `ey_region` VALUES ('29681', '江城区', '3', '29679', 'J');
INSERT INTO `ey_region` VALUES ('29698', '阳西县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29709', '阳东县', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29729', '阳春市', '3', '29679', 'Y');
INSERT INTO `ey_region` VALUES ('29755', '清远市', '2', '28240', 'Q');
INSERT INTO `ey_region` VALUES ('29756', '市辖区', '3', '29755', 'S');
INSERT INTO `ey_region` VALUES ('29757', '清城区', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29766', '佛冈县', '3', '29755', 'F');
INSERT INTO `ey_region` VALUES ('29773', '阳山县', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29787', '连山县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29797', '连南县', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29805', '清新县', '3', '29755', 'Q');
INSERT INTO `ey_region` VALUES ('29816', '英德市', '3', '29755', 'Y');
INSERT INTO `ey_region` VALUES ('29842', '连州市', '3', '29755', 'L');
INSERT INTO `ey_region` VALUES ('29855', '东莞市', '2', '28240', 'D');
INSERT INTO `ey_region` VALUES ('29890', '中山市', '2', '28240', 'Z');
INSERT INTO `ey_region` VALUES ('29915', '潮州市', '2', '28240', 'C');
INSERT INTO `ey_region` VALUES ('29916', '市辖区', '3', '29915', 'S');
INSERT INTO `ey_region` VALUES ('29917', '潮州市湘桥区', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29930', '潮州市潮安县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29954', '潮州市饶平县', '3', '29915', 'C');
INSERT INTO `ey_region` VALUES ('29977', '揭阳市', '2', '28240', 'J');
INSERT INTO `ey_region` VALUES ('29978', '市辖区', '3', '29977', 'S');
INSERT INTO `ey_region` VALUES ('29979', '榕城区', '3', '29977', 'R');
INSERT INTO `ey_region` VALUES ('29990', '揭东县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30008', '揭西县', '3', '29977', 'J');
INSERT INTO `ey_region` VALUES ('30032', '惠来县', '3', '29977', 'H');
INSERT INTO `ey_region` VALUES ('30054', '普宁市', '3', '29977', 'P');
INSERT INTO `ey_region` VALUES ('30086', '云浮市', '2', '28240', 'Y');
INSERT INTO `ey_region` VALUES ('30087', '市辖区', '3', '30086', 'S');
INSERT INTO `ey_region` VALUES ('30088', '云城区', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30096', '新兴县', '3', '30086', 'X');
INSERT INTO `ey_region` VALUES ('30112', '郁南县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30132', '云安县', '3', '30086', 'Y');
INSERT INTO `ey_region` VALUES ('30141', '罗定市', '3', '30086', 'L');
INSERT INTO `ey_region` VALUES ('30164', '广西', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('30165', '南宁市', '2', '30164', 'N');
INSERT INTO `ey_region` VALUES ('30166', '市辖区', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30167', '兴宁区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30174', '青秀区', '3', '30165', 'Q');
INSERT INTO `ey_region` VALUES ('30186', '江南区', '3', '30165', 'J');
INSERT INTO `ey_region` VALUES ('30196', '西乡塘区', '3', '30165', 'X');
INSERT INTO `ey_region` VALUES ('30214', '良庆区', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30222', '邕宁区', '3', '30165', 'Y');
INSERT INTO `ey_region` VALUES ('30228', '武鸣县', '3', '30165', 'W');
INSERT INTO `ey_region` VALUES ('30245', '隆安县', '3', '30165', 'L');
INSERT INTO `ey_region` VALUES ('30257', '马山县', '3', '30165', 'M');
INSERT INTO `ey_region` VALUES ('30270', '上林县', '3', '30165', 'S');
INSERT INTO `ey_region` VALUES ('30282', '宾阳县', '3', '30165', 'B');
INSERT INTO `ey_region` VALUES ('30300', '横县', '3', '30165', 'H');
INSERT INTO `ey_region` VALUES ('30319', '柳州市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('30320', '市辖区', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30321', '城中区', '3', '30319', 'C');
INSERT INTO `ey_region` VALUES ('30329', '鱼峰区', '3', '30319', 'Y');
INSERT INTO `ey_region` VALUES ('30338', '柳南区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30348', '柳北区', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30361', '柳江县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30374', '柳城县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30387', '鹿寨县', '3', '30319', 'L');
INSERT INTO `ey_region` VALUES ('30398', '融安县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30411', '融水县', '3', '30319', 'R');
INSERT INTO `ey_region` VALUES ('30432', '三江县', '3', '30319', 'S');
INSERT INTO `ey_region` VALUES ('30448', '桂林市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30449', '市辖区', '3', '30448', 'S');
INSERT INTO `ey_region` VALUES ('30450', '秀峰区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30454', '叠彩区', '3', '30448', 'D');
INSERT INTO `ey_region` VALUES ('30458', '象山区', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30463', '七星区', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30469', '雁山区', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30475', '阳朔县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30485', '临桂县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30497', '灵川县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30509', '全州县', '3', '30448', 'Q');
INSERT INTO `ey_region` VALUES ('30528', '兴安县', '3', '30448', 'X');
INSERT INTO `ey_region` VALUES ('30539', '永福县', '3', '30448', 'Y');
INSERT INTO `ey_region` VALUES ('30549', '灌阳县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30559', '龙胜县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30570', '资源县', '3', '30448', 'Z');
INSERT INTO `ey_region` VALUES ('30578', '平乐县', '3', '30448', 'P');
INSERT INTO `ey_region` VALUES ('30589', '荔浦县', '3', '30448', 'L');
INSERT INTO `ey_region` VALUES ('30603', '恭城县', '3', '30448', 'G');
INSERT INTO `ey_region` VALUES ('30613', '梧州市', '2', '30164', 'W');
INSERT INTO `ey_region` VALUES ('30614', '市辖区', '3', '30613', 'S');
INSERT INTO `ey_region` VALUES ('30615', '万秀区', '3', '30613', 'W');
INSERT INTO `ey_region` VALUES ('30622', '蝶山区', '3', '30613', 'D');
INSERT INTO `ey_region` VALUES ('30628', '长洲区', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30633', '苍梧县', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30646', '藤县', '3', '30613', 'T');
INSERT INTO `ey_region` VALUES ('30663', '蒙山县', '3', '30613', 'M');
INSERT INTO `ey_region` VALUES ('30673', '岑溪市', '3', '30613', 'C');
INSERT INTO `ey_region` VALUES ('30688', '北海市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('30689', '市辖区', '3', '30688', 'S');
INSERT INTO `ey_region` VALUES ('30690', '海城区', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30699', '银海区', '3', '30688', 'Y');
INSERT INTO `ey_region` VALUES ('30704', '铁山港区', '3', '30688', 'T');
INSERT INTO `ey_region` VALUES ('30708', '合浦县', '3', '30688', 'H');
INSERT INTO `ey_region` VALUES ('30724', '防城港市', '2', '30164', 'F');
INSERT INTO `ey_region` VALUES ('30725', '市辖区', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30726', '港口区', '3', '30724', 'G');
INSERT INTO `ey_region` VALUES ('30732', '防城区', '3', '30724', 'F');
INSERT INTO `ey_region` VALUES ('30748', '上思县', '3', '30724', 'S');
INSERT INTO `ey_region` VALUES ('30758', '东兴市', '3', '30724', 'D');
INSERT INTO `ey_region` VALUES ('30762', '钦州市', '2', '30164', 'Q');
INSERT INTO `ey_region` VALUES ('30763', '市辖区', '3', '30762', 'S');
INSERT INTO `ey_region` VALUES ('30764', '钦南区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30783', '钦北区', '3', '30762', 'Q');
INSERT INTO `ey_region` VALUES ('30796', '灵山县', '3', '30762', 'L');
INSERT INTO `ey_region` VALUES ('30817', '浦北县', '3', '30762', 'P');
INSERT INTO `ey_region` VALUES ('30834', '贵港市', '2', '30164', 'G');
INSERT INTO `ey_region` VALUES ('30835', '市辖区', '3', '30834', 'S');
INSERT INTO `ey_region` VALUES ('30836', '港北区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30845', '港南区', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30855', '覃塘区', '3', '30834', 'Q');
INSERT INTO `ey_region` VALUES ('30866', '平南县', '3', '30834', 'P');
INSERT INTO `ey_region` VALUES ('30888', '桂平市', '3', '30834', 'G');
INSERT INTO `ey_region` VALUES ('30915', '玉林市', '2', '30164', 'Y');
INSERT INTO `ey_region` VALUES ('30916', '市辖区', '3', '30915', 'S');
INSERT INTO `ey_region` VALUES ('30917', '玉州区', '3', '30915', 'Y');
INSERT INTO `ey_region` VALUES ('30933', '容县', '3', '30915', 'R');
INSERT INTO `ey_region` VALUES ('30949', '陆川县', '3', '30915', 'L');
INSERT INTO `ey_region` VALUES ('30964', '博白县', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('30993', '兴业县', '3', '30915', 'X');
INSERT INTO `ey_region` VALUES ('31007', '北流市', '3', '30915', 'B');
INSERT INTO `ey_region` VALUES ('31033', '百色市', '2', '30164', 'B');
INSERT INTO `ey_region` VALUES ('31034', '市辖区', '3', '31033', 'S');
INSERT INTO `ey_region` VALUES ('31035', '右江区', '3', '31033', 'Y');
INSERT INTO `ey_region` VALUES ('31045', '田阳县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31056', '田东县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31067', '平果县', '3', '31033', 'P');
INSERT INTO `ey_region` VALUES ('31081', '德保县', '3', '31033', 'D');
INSERT INTO `ey_region` VALUES ('31095', '靖西县', '3', '31033', 'J');
INSERT INTO `ey_region` VALUES ('31115', '那坡县', '3', '31033', 'N');
INSERT INTO `ey_region` VALUES ('31125', '凌云县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31134', '乐业县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31143', '田林县', '3', '31033', 'T');
INSERT INTO `ey_region` VALUES ('31158', '西林县', '3', '31033', 'X');
INSERT INTO `ey_region` VALUES ('31167', '隆林县', '3', '31033', 'L');
INSERT INTO `ey_region` VALUES ('31184', '贺州市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31185', '市辖区', '3', '31184', 'S');
INSERT INTO `ey_region` VALUES ('31186', '八步区', '3', '31184', 'B');
INSERT INTO `ey_region` VALUES ('31208', '昭平县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31221', '钟山县', '3', '31184', 'Z');
INSERT INTO `ey_region` VALUES ('31236', '富川县', '3', '31184', 'F');
INSERT INTO `ey_region` VALUES ('31249', '河池市', '2', '30164', 'H');
INSERT INTO `ey_region` VALUES ('31250', '市辖区', '3', '31249', 'S');
INSERT INTO `ey_region` VALUES ('31251', '金城江区', '3', '31249', 'J');
INSERT INTO `ey_region` VALUES ('31264', '南丹县', '3', '31249', 'N');
INSERT INTO `ey_region` VALUES ('31276', '天峨县', '3', '31249', 'T');
INSERT INTO `ey_region` VALUES ('31286', '凤山县', '3', '31249', 'F');
INSERT INTO `ey_region` VALUES ('31296', '东兰县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31311', '罗城县', '3', '31249', 'L');
INSERT INTO `ey_region` VALUES ('31323', '环江县', '3', '31249', 'H');
INSERT INTO `ey_region` VALUES ('31336', '巴马县', '3', '31249', 'B');
INSERT INTO `ey_region` VALUES ('31347', '都安县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31367', '大化县', '3', '31249', 'D');
INSERT INTO `ey_region` VALUES ('31384', '宜州市', '3', '31249', 'Y');
INSERT INTO `ey_region` VALUES ('31401', '来宾市', '2', '30164', 'L');
INSERT INTO `ey_region` VALUES ('31402', '市辖区', '3', '31401', 'S');
INSERT INTO `ey_region` VALUES ('31403', '兴宾区', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31427', '忻城县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31440', '象州县', '3', '31401', 'X');
INSERT INTO `ey_region` VALUES ('31452', '武宣县', '3', '31401', 'W');
INSERT INTO `ey_region` VALUES ('31463', '金秀县', '3', '31401', 'J');
INSERT INTO `ey_region` VALUES ('31474', '合山市', '3', '31401', 'H');
INSERT INTO `ey_region` VALUES ('31478', '崇左市', '2', '30164', 'C');
INSERT INTO `ey_region` VALUES ('31479', '市辖区', '3', '31478', 'S');
INSERT INTO `ey_region` VALUES ('31480', '江州区', '3', '31478', 'J');
INSERT INTO `ey_region` VALUES ('31490', '扶绥县', '3', '31478', 'F');
INSERT INTO `ey_region` VALUES ('31502', '宁明县', '3', '31478', 'N');
INSERT INTO `ey_region` VALUES ('31516', '龙州县', '3', '31478', 'L');
INSERT INTO `ey_region` VALUES ('31529', '大新县', '3', '31478', 'D');
INSERT INTO `ey_region` VALUES ('31544', '天等县', '3', '31478', 'T');
INSERT INTO `ey_region` VALUES ('31558', '凭祥市', '3', '31478', 'P');
INSERT INTO `ey_region` VALUES ('31563', '海南省', '1', '0', 'H');
INSERT INTO `ey_region` VALUES ('31564', '海口市', '2', '31563', 'H');
INSERT INTO `ey_region` VALUES ('31565', '市辖区', '3', '31564', 'S');
INSERT INTO `ey_region` VALUES ('31566', '秀英区', '3', '31564', 'X');
INSERT INTO `ey_region` VALUES ('31575', '龙华区', '3', '31564', 'L');
INSERT INTO `ey_region` VALUES ('31587', '琼山区', '3', '31564', 'Q');
INSERT INTO `ey_region` VALUES ('31601', '美兰区', '3', '31564', 'M');
INSERT INTO `ey_region` VALUES ('31618', '三亚市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31619', '市辖区', '3', '31618', 'S');
INSERT INTO `ey_region` VALUES ('31634', '五指山市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31635', '冲山镇', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31636', '南圣镇', '3', '31634', 'N');
INSERT INTO `ey_region` VALUES ('31637', '毛阳镇', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31638', '番阳镇', '3', '31634', 'F');
INSERT INTO `ey_region` VALUES ('31639', '畅好乡', '3', '31634', 'C');
INSERT INTO `ey_region` VALUES ('31640', '毛道乡', '3', '31634', 'M');
INSERT INTO `ey_region` VALUES ('31641', '水满乡', '3', '31634', 'S');
INSERT INTO `ey_region` VALUES ('31642', '国营畅好农场', '3', '31634', 'G');
INSERT INTO `ey_region` VALUES ('31643', '琼海市', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31644', '嘉积镇', '3', '31643', 'J');
INSERT INTO `ey_region` VALUES ('31645', '万泉镇', '3', '31643', 'W');
INSERT INTO `ey_region` VALUES ('31646', '石壁镇', '3', '31643', 'S');
INSERT INTO `ey_region` VALUES ('31647', '中原镇', '3', '31643', 'Z');
INSERT INTO `ey_region` VALUES ('31648', '博敖镇', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31649', '阳江镇', '3', '31643', 'Y');
INSERT INTO `ey_region` VALUES ('31650', '龙江镇', '3', '31643', 'L');
INSERT INTO `ey_region` VALUES ('31651', '潭门镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31652', '塔洋镇', '3', '31643', 'T');
INSERT INTO `ey_region` VALUES ('31653', '长坡镇', '3', '31643', 'C');
INSERT INTO `ey_region` VALUES ('31654', '大路镇', '3', '31643', 'D');
INSERT INTO `ey_region` VALUES ('31655', '会山镇', '3', '31643', 'H');
INSERT INTO `ey_region` VALUES ('31656', '国营东太农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31657', '国营东平农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31658', '国营东红农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31659', '国营东升农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31660', '国营南俸农场', '3', '31643', 'G');
INSERT INTO `ey_region` VALUES ('31661', '彬村山华侨农场', '3', '31643', 'B');
INSERT INTO `ey_region` VALUES ('31662', '儋州市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31663', '那大镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31664', '和庆镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31665', '南丰镇', '3', '31662', 'N');
INSERT INTO `ey_region` VALUES ('31666', '大成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31667', '雅星镇', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31668', '兰洋镇', '3', '31662', 'L');
INSERT INTO `ey_region` VALUES ('31669', '光村镇', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31670', '木棠镇', '3', '31662', 'M');
INSERT INTO `ey_region` VALUES ('31671', '海头镇', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31672', '峨蔓镇', '3', '31662', 'E');
INSERT INTO `ey_region` VALUES ('31673', '三都镇', '3', '31662', 'S');
INSERT INTO `ey_region` VALUES ('31674', '王五镇', '3', '31662', 'W');
INSERT INTO `ey_region` VALUES ('31675', '白马井镇', '3', '31662', 'B');
INSERT INTO `ey_region` VALUES ('31676', '中和镇', '3', '31662', 'Z');
INSERT INTO `ey_region` VALUES ('31677', '排浦镇', '3', '31662', 'P');
INSERT INTO `ey_region` VALUES ('31678', '东成镇', '3', '31662', 'D');
INSERT INTO `ey_region` VALUES ('31679', '新州镇', '3', '31662', 'X');
INSERT INTO `ey_region` VALUES ('31680', '国营西培农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31681', '国营西华农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31682', '国营西庆农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31683', '国营西流农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31684', '国营西联农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31685', '国营蓝洋农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31686', '国营新盈农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31687', '国营八一农场东山分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31688', '国营八一农场金川分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31689', '国营八一农场长岭分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31690', '国营八一农场英岛分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31691', '国营八一农场春江分场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31692', '国营八一农场强打管区', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31693', '国营龙山农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31694', '国营红岭农场', '3', '31662', 'G');
INSERT INTO `ey_region` VALUES ('31695', '洋浦经济开发区', '3', '31662', 'Y');
INSERT INTO `ey_region` VALUES ('31696', '华南热作学院', '3', '31662', 'H');
INSERT INTO `ey_region` VALUES ('31697', '文昌市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31698', '文城镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31699', '重兴镇', '3', '31697', 'Z');
INSERT INTO `ey_region` VALUES ('31700', '蓬莱镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31701', '会文镇', '3', '31697', 'H');
INSERT INTO `ey_region` VALUES ('31702', '东路镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31703', '潭牛镇', '3', '31697', 'T');
INSERT INTO `ey_region` VALUES ('31704', '东阁镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31705', '文教镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31706', '东郊镇', '3', '31697', 'D');
INSERT INTO `ey_region` VALUES ('31707', '龙楼镇', '3', '31697', 'L');
INSERT INTO `ey_region` VALUES ('31708', '昌洒镇', '3', '31697', 'C');
INSERT INTO `ey_region` VALUES ('31709', '翁田镇', '3', '31697', 'W');
INSERT INTO `ey_region` VALUES ('31710', '抱罗镇', '3', '31697', 'B');
INSERT INTO `ey_region` VALUES ('31711', '冯坡镇', '3', '31697', 'F');
INSERT INTO `ey_region` VALUES ('31712', '锦山镇', '3', '31697', 'J');
INSERT INTO `ey_region` VALUES ('31713', '铺前镇', '3', '31697', 'P');
INSERT INTO `ey_region` VALUES ('31714', '国营东路农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31715', '国营南阳农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31716', '国营罗豆农场', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31717', '国营文昌橡胶研究所', '3', '31697', 'G');
INSERT INTO `ey_region` VALUES ('31718', '万宁市', '2', '31563', 'W');
INSERT INTO `ey_region` VALUES ('31719', '万城镇', '3', '31718', 'W');
INSERT INTO `ey_region` VALUES ('31720', '龙滚镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31721', '和乐镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31722', '后安镇', '3', '31718', 'H');
INSERT INTO `ey_region` VALUES ('31723', '大茂镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31724', '东澳镇', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31725', '礼纪镇', '3', '31718', 'L');
INSERT INTO `ey_region` VALUES ('31726', '长丰镇', '3', '31718', 'C');
INSERT INTO `ey_region` VALUES ('31727', '山根镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31728', '北大镇', '3', '31718', 'B');
INSERT INTO `ey_region` VALUES ('31729', '南桥镇', '3', '31718', 'N');
INSERT INTO `ey_region` VALUES ('31730', '三更罗镇', '3', '31718', 'S');
INSERT INTO `ey_region` VALUES ('31731', '国营东兴农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31732', '国营东和农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31733', '国营东岭农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31734', '国营南林农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31735', '国营新中农场', '3', '31718', 'G');
INSERT INTO `ey_region` VALUES ('31736', '兴隆华侨农场', '3', '31718', 'X');
INSERT INTO `ey_region` VALUES ('31737', '地方国营六连林场', '3', '31718', 'D');
INSERT INTO `ey_region` VALUES ('31738', '东方市', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31739', '八所镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31740', '东河镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31741', '大田镇', '3', '31738', 'D');
INSERT INTO `ey_region` VALUES ('31742', '感城镇', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31743', '板桥镇', '3', '31738', 'B');
INSERT INTO `ey_region` VALUES ('31744', '三家镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31745', '四更镇', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31746', '新龙镇', '3', '31738', 'X');
INSERT INTO `ey_region` VALUES ('31747', '天安乡', '3', '31738', 'T');
INSERT INTO `ey_region` VALUES ('31748', '江边乡', '3', '31738', 'J');
INSERT INTO `ey_region` VALUES ('31749', '国营广坝农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31750', '国营公爱农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31751', '国营红泉农场', '3', '31738', 'G');
INSERT INTO `ey_region` VALUES ('31752', '省国营东方华侨农场', '3', '31738', 'S');
INSERT INTO `ey_region` VALUES ('31753', '定安县', '2', '31563', 'D');
INSERT INTO `ey_region` VALUES ('31754', '定城镇', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31755', '新竹镇', '3', '31753', 'X');
INSERT INTO `ey_region` VALUES ('31756', '龙湖镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31757', '黄竹镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31758', '雷鸣镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31759', '龙门镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31760', '龙河镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31761', '岭口镇', '3', '31753', 'L');
INSERT INTO `ey_region` VALUES ('31762', '翰林镇', '3', '31753', 'H');
INSERT INTO `ey_region` VALUES ('31763', '富文镇', '3', '31753', 'F');
INSERT INTO `ey_region` VALUES ('31764', '国营中瑞农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31765', '国营南海农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31766', '国营金鸡岭农场', '3', '31753', 'G');
INSERT INTO `ey_region` VALUES ('31767', '定安热作研究所', '3', '31753', 'D');
INSERT INTO `ey_region` VALUES ('31768', '屯昌县', '2', '31563', 'T');
INSERT INTO `ey_region` VALUES ('31769', '屯城镇', '3', '31768', 'T');
INSERT INTO `ey_region` VALUES ('31770', '新兴镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31771', '枫木镇', '3', '31768', 'F');
INSERT INTO `ey_region` VALUES ('31772', '乌坡镇', '3', '31768', 'W');
INSERT INTO `ey_region` VALUES ('31773', '南吕镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31774', '南坤镇', '3', '31768', 'N');
INSERT INTO `ey_region` VALUES ('31775', '坡心镇', '3', '31768', 'P');
INSERT INTO `ey_region` VALUES ('31776', '西昌镇', '3', '31768', 'X');
INSERT INTO `ey_region` VALUES ('31777', '国营中建农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31778', '国营中坤农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31779', '国营黄岭农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31780', '国营南吕农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31781', '国营广青农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31782', '国营晨星农场', '3', '31768', 'G');
INSERT INTO `ey_region` VALUES ('31783', '澄迈县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31784', '金江镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31785', '老城镇', '3', '31783', 'L');
INSERT INTO `ey_region` VALUES ('31786', '瑞溪镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31787', '永发镇', '3', '31783', 'Y');
INSERT INTO `ey_region` VALUES ('31788', '加乐镇', '3', '31783', 'J');
INSERT INTO `ey_region` VALUES ('31789', '文儒镇', '3', '31783', 'W');
INSERT INTO `ey_region` VALUES ('31790', '中兴镇', '3', '31783', 'Z');
INSERT INTO `ey_region` VALUES ('31791', '仁兴镇', '3', '31783', 'R');
INSERT INTO `ey_region` VALUES ('31792', '福山镇', '3', '31783', 'F');
INSERT INTO `ey_region` VALUES ('31793', '桥头镇', '3', '31783', 'Q');
INSERT INTO `ey_region` VALUES ('31794', '国营红光农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31795', '国营红岗农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31796', '国营西达农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31797', '国营昆仑农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31798', '国营和岭农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31799', '国营金安农场', '3', '31783', 'G');
INSERT INTO `ey_region` VALUES ('31800', '澄迈县华侨农场', '3', '31783', 'C');
INSERT INTO `ey_region` VALUES ('31801', '临高县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31802', '临城镇', '3', '31801', 'L');
INSERT INTO `ey_region` VALUES ('31803', '波莲镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31804', '东英镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31805', '博厚镇', '3', '31801', 'B');
INSERT INTO `ey_region` VALUES ('31806', '皇桐镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31807', '多文镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31808', '和舍镇', '3', '31801', 'H');
INSERT INTO `ey_region` VALUES ('31809', '南宝镇', '3', '31801', 'N');
INSERT INTO `ey_region` VALUES ('31810', '新盈镇', '3', '31801', 'X');
INSERT INTO `ey_region` VALUES ('31811', '调楼镇', '3', '31801', 'D');
INSERT INTO `ey_region` VALUES ('31812', '国营红华农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31813', '国营加来农场', '3', '31801', 'G');
INSERT INTO `ey_region` VALUES ('31814', '白沙县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31815', '牙叉镇', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31816', '七坊镇', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31817', '邦溪镇', '3', '31814', 'B');
INSERT INTO `ey_region` VALUES ('31818', '打安镇', '3', '31814', 'D');
INSERT INTO `ey_region` VALUES ('31819', '细水乡', '3', '31814', 'X');
INSERT INTO `ey_region` VALUES ('31820', '元门乡', '3', '31814', 'Y');
INSERT INTO `ey_region` VALUES ('31821', '南开乡', '3', '31814', 'N');
INSERT INTO `ey_region` VALUES ('31822', '阜龙乡', '3', '31814', 'F');
INSERT INTO `ey_region` VALUES ('31823', '青松乡', '3', '31814', 'Q');
INSERT INTO `ey_region` VALUES ('31824', '金波乡', '3', '31814', 'J');
INSERT INTO `ey_region` VALUES ('31825', '荣邦乡', '3', '31814', 'R');
INSERT INTO `ey_region` VALUES ('31826', '国营金波农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31827', '国营白沙农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31828', '国营牙叉农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31829', '国营卫星农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31830', '国营龙江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31831', '国营珠碧江农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31832', '国营芙蓉田农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31833', '国营大岭农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31834', '国营邦溪农场', '3', '31814', 'G');
INSERT INTO `ey_region` VALUES ('31835', '昌江县', '2', '31563', 'C');
INSERT INTO `ey_region` VALUES ('31836', '石碌镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31837', '叉河镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31838', '十月田镇', '3', '31835', 'S');
INSERT INTO `ey_region` VALUES ('31839', '乌烈镇', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31840', '昌化镇', '3', '31835', 'C');
INSERT INTO `ey_region` VALUES ('31841', '海尾镇', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31842', '七叉镇', '3', '31835', 'Q');
INSERT INTO `ey_region` VALUES ('31843', '王下乡', '3', '31835', 'W');
INSERT INTO `ey_region` VALUES ('31844', '国营红田农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31845', '国营红林农场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31846', '国营坝王岭林场', '3', '31835', 'G');
INSERT INTO `ey_region` VALUES ('31847', '海南钢铁公司', '3', '31835', 'H');
INSERT INTO `ey_region` VALUES ('31848', '乐东县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31849', '抱由镇', '3', '31848', 'B');
INSERT INTO `ey_region` VALUES ('31850', '万冲镇', '3', '31848', 'W');
INSERT INTO `ey_region` VALUES ('31851', '大安镇', '3', '31848', 'D');
INSERT INTO `ey_region` VALUES ('31852', '志仲镇', '3', '31848', 'Z');
INSERT INTO `ey_region` VALUES ('31853', '千家镇', '3', '31848', 'Q');
INSERT INTO `ey_region` VALUES ('31854', '九所镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31855', '利国镇', '3', '31848', 'L');
INSERT INTO `ey_region` VALUES ('31856', '黄流镇', '3', '31848', 'H');
INSERT INTO `ey_region` VALUES ('31857', '佛罗镇', '3', '31848', 'F');
INSERT INTO `ey_region` VALUES ('31858', '尖峰镇', '3', '31848', 'J');
INSERT INTO `ey_region` VALUES ('31859', '莺歌海镇', '3', '31848', 'Y');
INSERT INTO `ey_region` VALUES ('31860', '国营乐中农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31861', '国营山荣农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31862', '国营乐光农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31863', '国营报伦农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31864', '国营福报农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31865', '国营保国农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31866', '国营保显农场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31867', '国营尖峰岭林业公司', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31868', '国营莺歌海盐场', '3', '31848', 'G');
INSERT INTO `ey_region` VALUES ('31869', '陵水县', '2', '31563', 'L');
INSERT INTO `ey_region` VALUES ('31870', '椰林镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31871', '光坡镇', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31872', '三才镇', '3', '31869', 'S');
INSERT INTO `ey_region` VALUES ('31873', '英州镇', '3', '31869', 'Y');
INSERT INTO `ey_region` VALUES ('31874', '隆广镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31875', '文罗镇', '3', '31869', 'W');
INSERT INTO `ey_region` VALUES ('31876', '本号镇', '3', '31869', 'B');
INSERT INTO `ey_region` VALUES ('31877', '新村镇', '3', '31869', 'X');
INSERT INTO `ey_region` VALUES ('31878', '黎安镇', '3', '31869', 'L');
INSERT INTO `ey_region` VALUES ('31879', '提蒙乡', '3', '31869', 'T');
INSERT INTO `ey_region` VALUES ('31880', '群英乡', '3', '31869', 'Q');
INSERT INTO `ey_region` VALUES ('31881', '国营岭门农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31882', '国营南平农场', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31883', '国营吊罗山林业公司', '3', '31869', 'G');
INSERT INTO `ey_region` VALUES ('31884', '保亭县', '2', '31563', 'B');
INSERT INTO `ey_region` VALUES ('31885', '保城镇', '3', '31884', 'B');
INSERT INTO `ey_region` VALUES ('31886', '什玲镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31887', '加茂镇', '3', '31884', 'J');
INSERT INTO `ey_region` VALUES ('31888', '响水镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31889', '新政镇', '3', '31884', 'X');
INSERT INTO `ey_region` VALUES ('31890', '三道镇', '3', '31884', 'S');
INSERT INTO `ey_region` VALUES ('31891', '六弓乡', '3', '31884', 'L');
INSERT INTO `ey_region` VALUES ('31892', '南林乡', '3', '31884', 'N');
INSERT INTO `ey_region` VALUES ('31893', '毛感乡', '3', '31884', 'M');
INSERT INTO `ey_region` VALUES ('31894', '国营五指山茶场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31895', '国营新星农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31896', '国营保亭热作所', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31897', '国营金江农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31898', '国营南茂农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31899', '国营三道农场', '3', '31884', 'G');
INSERT INTO `ey_region` VALUES ('31900', '琼中县', '2', '31563', 'Q');
INSERT INTO `ey_region` VALUES ('31901', '营根镇', '3', '31900', 'Y');
INSERT INTO `ey_region` VALUES ('31902', '湾岭镇', '3', '31900', 'W');
INSERT INTO `ey_region` VALUES ('31903', '黎母山镇', '3', '31900', 'L');
INSERT INTO `ey_region` VALUES ('31904', '和平镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31905', '长征镇', '3', '31900', 'C');
INSERT INTO `ey_region` VALUES ('31906', '红毛镇', '3', '31900', 'H');
INSERT INTO `ey_region` VALUES ('31907', '中平镇', '3', '31900', 'Z');
INSERT INTO `ey_region` VALUES ('31908', '吊罗山乡', '3', '31900', 'D');
INSERT INTO `ey_region` VALUES ('31909', '上安乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31910', '什运乡', '3', '31900', 'S');
INSERT INTO `ey_region` VALUES ('31911', '国营新进农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31912', '国营大丰农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31913', '国营阳江农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31914', '国营乌石农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31915', '国营南方农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31916', '国营岭头农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31917', '国营加钗农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31918', '国营长征农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31919', '国营乘坡农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31920', '国营太平农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31921', '国营新伟农场', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31922', '国营黎母山林业公司', '3', '31900', 'G');
INSERT INTO `ey_region` VALUES ('31923', '西沙群岛', '3', '31924', 'X');
INSERT INTO `ey_region` VALUES ('31924', '三沙市', '2', '31563', 'S');
INSERT INTO `ey_region` VALUES ('31925', '南沙群岛', '3', '31924', 'N');
INSERT INTO `ey_region` VALUES ('47499', '香港岛', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('31927', '中沙群岛的岛礁及其海域', '3', '31924', 'Z');
INSERT INTO `ey_region` VALUES ('47498', '九龙', '2', '47494', 'J');
INSERT INTO `ey_region` VALUES ('31929', '重庆市', '1', '0', 'Z');
INSERT INTO `ey_region` VALUES ('31930', '重庆市', '2', '31929', 'C');
INSERT INTO `ey_region` VALUES ('31931', '万州区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('31984', '涪陵区', '3', '31930', 'F');
INSERT INTO `ey_region` VALUES ('32031', '渝中区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32044', '大渡口区', '3', '31930', 'D');
INSERT INTO `ey_region` VALUES ('32053', '江北区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32066', '沙坪坝区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32093', '九龙坡区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32112', '南岸区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32127', '北碚区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32145', '万盛区', '3', '31930', 'W');
INSERT INTO `ey_region` VALUES ('32156', '双桥区', '3', '31930', 'S');
INSERT INTO `ey_region` VALUES ('32160', '渝北区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32191', '巴南区', '3', '31930', 'B');
INSERT INTO `ey_region` VALUES ('32213', '黔江区', '3', '31930', 'Q');
INSERT INTO `ey_region` VALUES ('32244', '长寿区', '3', '31930', 'C');
INSERT INTO `ey_region` VALUES ('32263', '江津区', '3', '31930', 'J');
INSERT INTO `ey_region` VALUES ('32291', '合川区', '3', '31930', 'H');
INSERT INTO `ey_region` VALUES ('32322', '永川区', '3', '31930', 'Y');
INSERT INTO `ey_region` VALUES ('32345', '南川区', '3', '31930', 'N');
INSERT INTO `ey_region` VALUES ('32380', '县', '2', '31929', 'X');
INSERT INTO `ey_region` VALUES ('32381', '綦江县', '3', '32380', 'Q');
INSERT INTO `ey_region` VALUES ('32401', '潼南县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32424', '铜梁县', '3', '32380', 'T');
INSERT INTO `ey_region` VALUES ('32453', '大足县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32478', '荣昌县', '3', '32380', 'R');
INSERT INTO `ey_region` VALUES ('32499', '璧山县', '3', '32380', 'B');
INSERT INTO `ey_region` VALUES ('32513', '梁平县', '3', '32380', 'L');
INSERT INTO `ey_region` VALUES ('32549', '城口县', '3', '32380', 'C');
INSERT INTO `ey_region` VALUES ('32574', '丰都县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32606', '垫江县', '3', '32380', 'D');
INSERT INTO `ey_region` VALUES ('32632', '武隆县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32659', '忠县', '3', '32380', 'Z');
INSERT INTO `ey_region` VALUES ('32688', '开县', '3', '32380', 'K');
INSERT INTO `ey_region` VALUES ('32727', '云阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32771', '奉节县', '3', '32380', 'F');
INSERT INTO `ey_region` VALUES ('32802', '巫山县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32829', '巫溪县', '3', '32380', 'W');
INSERT INTO `ey_region` VALUES ('32861', '石柱县', '3', '32380', 'S');
INSERT INTO `ey_region` VALUES ('32894', '秀山县', '3', '32380', 'X');
INSERT INTO `ey_region` VALUES ('32927', '酉阳县', '3', '32380', 'Y');
INSERT INTO `ey_region` VALUES ('32967', '彭水县', '3', '32380', 'P');
INSERT INTO `ey_region` VALUES ('33007', '四川省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('33008', '成都市', '2', '33007', 'C');
INSERT INTO `ey_region` VALUES ('33009', '市辖区', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33010', '锦江区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33027', '青羊区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33042', '金牛区', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33058', '武侯区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33076', '成华区', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33091', '龙泉驿区', '3', '33008', 'L');
INSERT INTO `ey_region` VALUES ('33104', '青白江区', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33116', '新都区', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33130', '温江区', '3', '33008', 'W');
INSERT INTO `ey_region` VALUES ('33141', '金堂县', '3', '33008', 'J');
INSERT INTO `ey_region` VALUES ('33163', '双流县', '3', '33008', 'S');
INSERT INTO `ey_region` VALUES ('33189', '郫县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33205', '大邑县', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33226', '蒲江县', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33239', '新津县', '3', '33008', 'X');
INSERT INTO `ey_region` VALUES ('33252', '都江堰市', '3', '33008', 'D');
INSERT INTO `ey_region` VALUES ('33272', '彭州市', '3', '33008', 'P');
INSERT INTO `ey_region` VALUES ('33293', '邛崃市', '3', '33008', 'Q');
INSERT INTO `ey_region` VALUES ('33318', '崇州市', '3', '33008', 'C');
INSERT INTO `ey_region` VALUES ('33344', '自贡市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('33345', '市辖区', '3', '33344', 'S');
INSERT INTO `ey_region` VALUES ('33346', '自流井区', '3', '33344', 'Z');
INSERT INTO `ey_region` VALUES ('33360', '贡井区', '3', '33344', 'G');
INSERT INTO `ey_region` VALUES ('33374', '大安区', '3', '33344', 'D');
INSERT INTO `ey_region` VALUES ('33391', '沿滩区', '3', '33344', 'Y');
INSERT INTO `ey_region` VALUES ('33405', '荣县', '3', '33344', 'R');
INSERT INTO `ey_region` VALUES ('33433', '富顺县', '3', '33344', 'F');
INSERT INTO `ey_region` VALUES ('33460', '攀枝花市', '2', '33007', 'P');
INSERT INTO `ey_region` VALUES ('33461', '市辖区', '3', '33460', 'S');
INSERT INTO `ey_region` VALUES ('33462', '攀枝花东区', '3', '33460', 'P');
INSERT INTO `ey_region` VALUES ('33473', '西区', '3', '33460', 'X');
INSERT INTO `ey_region` VALUES ('33481', '仁和区', '3', '33460', 'R');
INSERT INTO `ey_region` VALUES ('33497', '米易县', '3', '33460', 'M');
INSERT INTO `ey_region` VALUES ('33511', '盐边县', '3', '33460', 'Y');
INSERT INTO `ey_region` VALUES ('33528', '泸州市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('33529', '市辖区', '3', '33528', 'S');
INSERT INTO `ey_region` VALUES ('33530', '江阳区', '3', '33528', 'J');
INSERT INTO `ey_region` VALUES ('33548', '纳溪区', '3', '33528', 'N');
INSERT INTO `ey_region` VALUES ('33563', '龙马潭区', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33577', '泸县', '3', '33528', 'L');
INSERT INTO `ey_region` VALUES ('33597', '合江县', '3', '33528', 'H');
INSERT INTO `ey_region` VALUES ('33625', '叙永县', '3', '33528', 'X');
INSERT INTO `ey_region` VALUES ('33654', '古蔺县', '3', '33528', 'G');
INSERT INTO `ey_region` VALUES ('33681', '德阳市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('33682', '市辖区', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33683', '旌阳区', '3', '33681', 'J');
INSERT INTO `ey_region` VALUES ('33701', '中江县', '3', '33681', 'Z');
INSERT INTO `ey_region` VALUES ('33747', '罗江县', '3', '33681', 'L');
INSERT INTO `ey_region` VALUES ('33758', '广汉市', '3', '33681', 'G');
INSERT INTO `ey_region` VALUES ('33778', '什邡市', '3', '33681', 'S');
INSERT INTO `ey_region` VALUES ('33795', '绵竹市', '3', '33681', 'M');
INSERT INTO `ey_region` VALUES ('33817', '绵阳市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('33818', '市辖区', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33819', '涪城区', '3', '33817', 'F');
INSERT INTO `ey_region` VALUES ('33844', '游仙区', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33873', '三台县', '3', '33817', 'S');
INSERT INTO `ey_region` VALUES ('33937', '盐亭县', '3', '33817', 'Y');
INSERT INTO `ey_region` VALUES ('33974', '安县', '3', '33817', 'A');
INSERT INTO `ey_region` VALUES ('33995', '梓潼县', '3', '33817', 'Z');
INSERT INTO `ey_region` VALUES ('34028', '北川县', '3', '33817', 'B');
INSERT INTO `ey_region` VALUES ('34049', '平武县', '3', '33817', 'P');
INSERT INTO `ey_region` VALUES ('34075', '江油市', '3', '33817', 'J');
INSERT INTO `ey_region` VALUES ('34120', '广元市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('34121', '市辖区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34122', '市中区', '3', '34120', 'S');
INSERT INTO `ey_region` VALUES ('34143', '元坝区', '3', '34120', 'Y');
INSERT INTO `ey_region` VALUES ('34173', '朝天区', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34199', '旺苍县', '3', '34120', 'W');
INSERT INTO `ey_region` VALUES ('34238', '青川县', '3', '34120', 'Q');
INSERT INTO `ey_region` VALUES ('34276', '剑阁县', '3', '34120', 'J');
INSERT INTO `ey_region` VALUES ('34334', '苍溪县', '3', '34120', 'C');
INSERT INTO `ey_region` VALUES ('34376', '遂宁市', '2', '33007', 'S');
INSERT INTO `ey_region` VALUES ('34377', '市辖区', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34378', '船山区', '3', '34376', 'C');
INSERT INTO `ey_region` VALUES ('34404', '安居区', '3', '34376', 'A');
INSERT INTO `ey_region` VALUES ('34426', '蓬溪县', '3', '34376', 'P');
INSERT INTO `ey_region` VALUES ('34458', '射洪县', '3', '34376', 'S');
INSERT INTO `ey_region` VALUES ('34489', '大英县', '3', '34376', 'D');
INSERT INTO `ey_region` VALUES ('34501', '内江市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34502', '市辖区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34503', '市中区', '3', '34501', 'S');
INSERT INTO `ey_region` VALUES ('34524', '东兴区', '3', '34501', 'D');
INSERT INTO `ey_region` VALUES ('34554', '威远县', '3', '34501', 'W');
INSERT INTO `ey_region` VALUES ('34575', '资中县', '3', '34501', 'Z');
INSERT INTO `ey_region` VALUES ('34609', '隆昌县', '3', '34501', 'L');
INSERT INTO `ey_region` VALUES ('34628', '乐山市', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('34629', '市辖区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34630', '市中区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34661', '沙湾区', '3', '34628', 'S');
INSERT INTO `ey_region` VALUES ('34676', '五通桥区', '3', '34628', 'W');
INSERT INTO `ey_region` VALUES ('34689', '金口河区', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34696', '犍为县', '3', '34628', 'Q');
INSERT INTO `ey_region` VALUES ('34727', '井研县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34755', '夹江县', '3', '34628', 'J');
INSERT INTO `ey_region` VALUES ('34778', '沐川县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34799', '峨边县', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34819', '马边县', '3', '34628', 'M');
INSERT INTO `ey_region` VALUES ('34840', '峨眉山市', '3', '34628', 'E');
INSERT INTO `ey_region` VALUES ('34859', '南充市', '2', '33007', 'N');
INSERT INTO `ey_region` VALUES ('34860', '市辖区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34861', '顺庆区', '3', '34859', 'S');
INSERT INTO `ey_region` VALUES ('34890', '高坪区', '3', '34859', 'G');
INSERT INTO `ey_region` VALUES ('34923', '嘉陵区', '3', '34859', 'J');
INSERT INTO `ey_region` VALUES ('34967', '南部县', '3', '34859', 'N');
INSERT INTO `ey_region` VALUES ('35040', '营山县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35094', '蓬安县', '3', '34859', 'P');
INSERT INTO `ey_region` VALUES ('35134', '仪陇县', '3', '34859', 'Y');
INSERT INTO `ey_region` VALUES ('35193', '西充县', '3', '34859', 'X');
INSERT INTO `ey_region` VALUES ('35238', '阆中市', '3', '34859', 'L');
INSERT INTO `ey_region` VALUES ('35288', '眉山市', '2', '33007', 'M');
INSERT INTO `ey_region` VALUES ('35289', '市辖区', '3', '35288', 'S');
INSERT INTO `ey_region` VALUES ('35290', '东坡区', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35317', '仁寿县', '3', '35288', 'R');
INSERT INTO `ey_region` VALUES ('35378', '彭山县', '3', '35288', 'P');
INSERT INTO `ey_region` VALUES ('35392', '洪雅县', '3', '35288', 'H');
INSERT INTO `ey_region` VALUES ('35408', '丹棱县', '3', '35288', 'D');
INSERT INTO `ey_region` VALUES ('35416', '青神县', '3', '35288', 'Q');
INSERT INTO `ey_region` VALUES ('35427', '宜宾市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('35428', '市辖区', '3', '35427', 'S');
INSERT INTO `ey_region` VALUES ('35429', '翠屏区', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35454', '宜宾县', '3', '35427', 'Y');
INSERT INTO `ey_region` VALUES ('35481', '南溪县', '3', '35427', 'N');
INSERT INTO `ey_region` VALUES ('35497', '江安县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35516', '长宁县', '3', '35427', 'C');
INSERT INTO `ey_region` VALUES ('35535', '高县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35555', '珙县', '3', '35427', 'G');
INSERT INTO `ey_region` VALUES ('35573', '筠连县', '3', '35427', 'J');
INSERT INTO `ey_region` VALUES ('35592', '兴文县', '3', '35427', 'X');
INSERT INTO `ey_region` VALUES ('35608', '屏山县', '3', '35427', 'P');
INSERT INTO `ey_region` VALUES ('35625', '广安市', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('35626', '市辖区', '3', '35625', 'S');
INSERT INTO `ey_region` VALUES ('35627', '广安区', '3', '35625', 'G');
INSERT INTO `ey_region` VALUES ('35677', '岳池县', '3', '35625', 'Y');
INSERT INTO `ey_region` VALUES ('35721', '武胜县', '3', '35625', 'W');
INSERT INTO `ey_region` VALUES ('35753', '邻水县', '3', '35625', 'L');
INSERT INTO `ey_region` VALUES ('35799', '华蓥市', '3', '35625', 'H');
INSERT INTO `ey_region` VALUES ('35813', '达州市', '2', '33007', 'D');
INSERT INTO `ey_region` VALUES ('35814', '市辖区', '3', '35813', 'S');
INSERT INTO `ey_region` VALUES ('35815', '通川区', '3', '35813', 'T');
INSERT INTO `ey_region` VALUES ('35829', '达县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('35894', '宣汉县', '3', '35813', 'X');
INSERT INTO `ey_region` VALUES ('35949', '开江县', '3', '35813', 'K');
INSERT INTO `ey_region` VALUES ('35970', '大竹县', '3', '35813', 'D');
INSERT INTO `ey_region` VALUES ('36021', '渠县', '3', '35813', 'Q');
INSERT INTO `ey_region` VALUES ('36082', '万源市', '3', '35813', 'W');
INSERT INTO `ey_region` VALUES ('36136', '雅安市', '2', '33007', 'Y');
INSERT INTO `ey_region` VALUES ('36137', '市辖区', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36138', '雨城区', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36161', '名山县', '3', '36136', 'M');
INSERT INTO `ey_region` VALUES ('36182', '荥经县', '3', '36136', 'Y');
INSERT INTO `ey_region` VALUES ('36204', '汉源县', '3', '36136', 'H');
INSERT INTO `ey_region` VALUES ('36245', '石棉县', '3', '36136', 'S');
INSERT INTO `ey_region` VALUES ('36263', '天全县', '3', '36136', 'T');
INSERT INTO `ey_region` VALUES ('36279', '芦山县', '3', '36136', 'L');
INSERT INTO `ey_region` VALUES ('36289', '宝兴县', '3', '36136', 'B');
INSERT INTO `ey_region` VALUES ('36299', '巴中市', '2', '33007', 'B');
INSERT INTO `ey_region` VALUES ('36300', '市辖区', '3', '36299', 'S');
INSERT INTO `ey_region` VALUES ('36301', '巴州区', '3', '36299', 'B');
INSERT INTO `ey_region` VALUES ('36354', '通江县', '3', '36299', 'T');
INSERT INTO `ey_region` VALUES ('36404', '南江县', '3', '36299', 'N');
INSERT INTO `ey_region` VALUES ('36453', '平昌县', '3', '36299', 'P');
INSERT INTO `ey_region` VALUES ('36497', '资阳市', '2', '33007', 'Z');
INSERT INTO `ey_region` VALUES ('36498', '市辖区', '3', '36497', 'S');
INSERT INTO `ey_region` VALUES ('36499', '雁江区', '3', '36497', 'Y');
INSERT INTO `ey_region` VALUES ('36527', '安岳县', '3', '36497', 'A');
INSERT INTO `ey_region` VALUES ('36597', '乐至县', '3', '36497', 'L');
INSERT INTO `ey_region` VALUES ('36623', '简阳市', '3', '36497', 'J');
INSERT INTO `ey_region` VALUES ('36679', '阿坝州', '2', '33007', 'A');
INSERT INTO `ey_region` VALUES ('36680', '汶川县', '3', '36679', 'W');
INSERT INTO `ey_region` VALUES ('36694', '理县', '3', '36679', 'L');
INSERT INTO `ey_region` VALUES ('36708', '茂县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36731', '松潘县', '3', '36679', 'S');
INSERT INTO `ey_region` VALUES ('36759', '九寨沟县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36778', '金川县', '3', '36679', 'J');
INSERT INTO `ey_region` VALUES ('36802', '小金县', '3', '36679', 'X');
INSERT INTO `ey_region` VALUES ('36824', '黑水县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36842', '马尔康县', '3', '36679', 'M');
INSERT INTO `ey_region` VALUES ('36858', '壤塘县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36871', '阿坝县', '3', '36679', 'A');
INSERT INTO `ey_region` VALUES ('36893', '若尔盖县', '3', '36679', 'R');
INSERT INTO `ey_region` VALUES ('36914', '红原县', '3', '36679', 'H');
INSERT INTO `ey_region` VALUES ('36926', '甘孜州', '2', '33007', 'G');
INSERT INTO `ey_region` VALUES ('36927', '康定县', '3', '36926', 'K');
INSERT INTO `ey_region` VALUES ('36949', '泸定县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('36962', '丹巴县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('36978', '九龙县', '3', '36926', 'J');
INSERT INTO `ey_region` VALUES ('36997', '雅江县', '3', '36926', 'Y');
INSERT INTO `ey_region` VALUES ('37015', '道孚县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37038', '炉霍县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37055', '甘孜县', '3', '36926', 'G');
INSERT INTO `ey_region` VALUES ('37078', '新龙县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37098', '德格县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37125', '白玉县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37143', '石渠县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37166', '色达县', '3', '36926', 'S');
INSERT INTO `ey_region` VALUES ('37184', '理塘县', '3', '36926', 'L');
INSERT INTO `ey_region` VALUES ('37209', '巴塘县', '3', '36926', 'B');
INSERT INTO `ey_region` VALUES ('37229', '乡城县', '3', '36926', 'X');
INSERT INTO `ey_region` VALUES ('37242', '稻城县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37257', '得荣县', '3', '36926', 'D');
INSERT INTO `ey_region` VALUES ('37270', '凉山州', '2', '33007', 'L');
INSERT INTO `ey_region` VALUES ('37271', '西昌市', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37315', '木里县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37345', '盐源县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37380', '德昌', '3', '37270', 'D');
INSERT INTO `ey_region` VALUES ('37404', '会理县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37455', '会东县', '3', '37270', 'H');
INSERT INTO `ey_region` VALUES ('37509', '宁南县', '3', '37270', 'N');
INSERT INTO `ey_region` VALUES ('37535', '普格县', '3', '37270', 'P');
INSERT INTO `ey_region` VALUES ('37570', '布拖县', '3', '37270', 'B');
INSERT INTO `ey_region` VALUES ('37601', '金阳县', '3', '37270', 'J');
INSERT INTO `ey_region` VALUES ('37636', '昭觉县', '3', '37270', 'Z');
INSERT INTO `ey_region` VALUES ('37684', '喜德县', '3', '37270', 'X');
INSERT INTO `ey_region` VALUES ('37709', '冕宁县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37748', '越西县', '3', '37270', 'Y');
INSERT INTO `ey_region` VALUES ('37790', '甘洛县', '3', '37270', 'G');
INSERT INTO `ey_region` VALUES ('37819', '美姑县', '3', '37270', 'M');
INSERT INTO `ey_region` VALUES ('37856', '雷波县', '3', '37270', 'L');
INSERT INTO `ey_region` VALUES ('37906', '贵州省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('37907', '贵阳市', '2', '37906', 'G');
INSERT INTO `ey_region` VALUES ('37908', '市辖区', '3', '37907', 'S');
INSERT INTO `ey_region` VALUES ('37909', '南明区', '3', '37907', 'N');
INSERT INTO `ey_region` VALUES ('37927', '云岩区', '3', '37907', 'Y');
INSERT INTO `ey_region` VALUES ('37944', '花溪区', '3', '37907', 'H');
INSERT INTO `ey_region` VALUES ('37961', '乌当区', '3', '37907', 'W');
INSERT INTO `ey_region` VALUES ('37977', '白云区', '3', '37907', 'B');
INSERT INTO `ey_region` VALUES ('37987', '小河区', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('37991', '开阳县', '3', '37907', 'K');
INSERT INTO `ey_region` VALUES ('38008', '息烽县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38019', '修文县', '3', '37907', 'X');
INSERT INTO `ey_region` VALUES ('38030', '清镇市', '3', '37907', 'Q');
INSERT INTO `ey_region` VALUES ('38042', '六盘水市', '2', '37906', 'L');
INSERT INTO `ey_region` VALUES ('38043', '钟山区', '3', '38042', 'Z');
INSERT INTO `ey_region` VALUES ('38053', '六枝特区', '3', '38042', 'L');
INSERT INTO `ey_region` VALUES ('38073', '水城县', '3', '38042', 'S');
INSERT INTO `ey_region` VALUES ('38107', '盘县', '3', '38042', 'P');
INSERT INTO `ey_region` VALUES ('38145', '遵义市', '2', '37906', 'Z');
INSERT INTO `ey_region` VALUES ('38146', '市辖区', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38147', '红花岗区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38164', '汇川区', '3', '38145', 'H');
INSERT INTO `ey_region` VALUES ('38174', '遵义县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38206', '桐梓县', '3', '38145', 'T');
INSERT INTO `ey_region` VALUES ('38231', '绥阳县', '3', '38145', 'S');
INSERT INTO `ey_region` VALUES ('38247', '正安县', '3', '38145', 'Z');
INSERT INTO `ey_region` VALUES ('38267', '道真县', '3', '38145', 'D');
INSERT INTO `ey_region` VALUES ('38282', '务川县', '3', '38145', 'W');
INSERT INTO `ey_region` VALUES ('38298', '凤冈县', '3', '38145', 'F');
INSERT INTO `ey_region` VALUES ('38313', '湄潭县', '3', '38145', 'M');
INSERT INTO `ey_region` VALUES ('38329', '余庆县', '3', '38145', 'Y');
INSERT INTO `ey_region` VALUES ('38340', '习水县', '3', '38145', 'X');
INSERT INTO `ey_region` VALUES ('38364', '赤水市', '3', '38145', 'C');
INSERT INTO `ey_region` VALUES ('38382', '仁怀市', '3', '38145', 'R');
INSERT INTO `ey_region` VALUES ('38402', '安顺市', '2', '37906', 'A');
INSERT INTO `ey_region` VALUES ('38403', '市辖区', '3', '38402', 'S');
INSERT INTO `ey_region` VALUES ('38404', '西秀区', '3', '38402', 'X');
INSERT INTO `ey_region` VALUES ('38429', '平坝县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38440', '普定县', '3', '38402', 'P');
INSERT INTO `ey_region` VALUES ('38452', '镇宁县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38469', '关岭县', '3', '38402', 'G');
INSERT INTO `ey_region` VALUES ('38484', '紫云县', '3', '38402', 'Z');
INSERT INTO `ey_region` VALUES ('38497', '铜仁地区', '2', '37906', 'T');
INSERT INTO `ey_region` VALUES ('38498', '铜仁市', '3', '38497', 'T');
INSERT INTO `ey_region` VALUES ('38516', '江口县', '3', '38497', 'J');
INSERT INTO `ey_region` VALUES ('38526', '玉屏县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38533', '石阡县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38552', '思南县　', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38580', '印江县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38598', '德江县', '3', '38497', 'D');
INSERT INTO `ey_region` VALUES ('38619', '沿河县', '3', '38497', 'Y');
INSERT INTO `ey_region` VALUES ('38642', '松桃县', '3', '38497', 'S');
INSERT INTO `ey_region` VALUES ('38671', '万山特区', '3', '38497', 'W');
INSERT INTO `ey_region` VALUES ('38677', '黔西南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('38678', '兴义市', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38705', '兴仁县', '3', '38677', 'X');
INSERT INTO `ey_region` VALUES ('38722', '普安县', '3', '38677', 'P');
INSERT INTO `ey_region` VALUES ('38737', '晴隆县', '3', '38677', 'Q');
INSERT INTO `ey_region` VALUES ('38752', '贞丰县', '3', '38677', 'Z');
INSERT INTO `ey_region` VALUES ('38766', '望谟县', '3', '38677', 'W');
INSERT INTO `ey_region` VALUES ('38784', '册亨县', '3', '38677', 'C');
INSERT INTO `ey_region` VALUES ('38799', '安龙县', '3', '38677', 'A');
INSERT INTO `ey_region` VALUES ('38816', '毕节地区', '2', '37906', 'B');
INSERT INTO `ey_region` VALUES ('38817', '毕节市', '3', '38816', 'B');
INSERT INTO `ey_region` VALUES ('38859', '大方县', '3', '38816', 'D');
INSERT INTO `ey_region` VALUES ('38896', '黔西县', '3', '38816', 'Q');
INSERT INTO `ey_region` VALUES ('38925', '金沙县', '3', '38816', 'J');
INSERT INTO `ey_region` VALUES ('38952', '织金县', '3', '38816', 'Z');
INSERT INTO `ey_region` VALUES ('38985', '纳雍县', '3', '38816', 'N');
INSERT INTO `ey_region` VALUES ('39011', '威宁县', '3', '38816', 'W');
INSERT INTO `ey_region` VALUES ('39047', '赫章县', '3', '38816', 'H');
INSERT INTO `ey_region` VALUES ('39075', '黔东南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39076', '凯里市', '3', '39075', 'K');
INSERT INTO `ey_region` VALUES ('39092', '黄平县', '3', '39075', 'H');
INSERT INTO `ey_region` VALUES ('39107', '施秉县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39116', '三穗县', '3', '39075', 'S');
INSERT INTO `ey_region` VALUES ('39126', '镇远县', '3', '39075', 'Z');
INSERT INTO `ey_region` VALUES ('39139', '岑巩县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39151', '天柱县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39168', '锦屏县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39184', '剑河县', '3', '39075', 'J');
INSERT INTO `ey_region` VALUES ('39197', '台江县', '3', '39075', 'T');
INSERT INTO `ey_region` VALUES ('39206', '黎平县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39232', '榕江县', '3', '39075', 'R');
INSERT INTO `ey_region` VALUES ('39252', '从江县', '3', '39075', 'C');
INSERT INTO `ey_region` VALUES ('39274', '雷山县', '3', '39075', 'L');
INSERT INTO `ey_region` VALUES ('39284', '麻江县', '3', '39075', 'M');
INSERT INTO `ey_region` VALUES ('39294', '丹寨县', '3', '39075', 'D');
INSERT INTO `ey_region` VALUES ('39302', '黔南州', '2', '37906', 'Q');
INSERT INTO `ey_region` VALUES ('39303', '都匀市', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39327', '福泉市', '3', '39302', 'F');
INSERT INTO `ey_region` VALUES ('39345', '荔波县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39363', '贵定县', '3', '39302', 'G');
INSERT INTO `ey_region` VALUES ('39384', '瓮安县', '3', '39302', 'W');
INSERT INTO `ey_region` VALUES ('39408', '独山县', '3', '39302', 'D');
INSERT INTO `ey_region` VALUES ('39427', '平塘县', '3', '39302', 'P');
INSERT INTO `ey_region` VALUES ('39447', '罗甸县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39474', '长顺县', '3', '39302', 'C');
INSERT INTO `ey_region` VALUES ('39493', '龙里县', '3', '39302', 'L');
INSERT INTO `ey_region` VALUES ('39508', '惠水县', '3', '39302', 'H');
INSERT INTO `ey_region` VALUES ('39534', '三都县', '3', '39302', 'S');
INSERT INTO `ey_region` VALUES ('39556', '云南省', '1', '0', 'Y');
INSERT INTO `ey_region` VALUES ('39557', '昆明市', '2', '39556', 'K');
INSERT INTO `ey_region` VALUES ('39558', '市辖区', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39559', '五华区', '3', '39557', 'W');
INSERT INTO `ey_region` VALUES ('39571', '盘龙区', '3', '39557', 'P');
INSERT INTO `ey_region` VALUES ('39582', '官渡区', '3', '39557', 'G');
INSERT INTO `ey_region` VALUES ('39594', '西山区', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39605', '东川区', '3', '39557', 'D');
INSERT INTO `ey_region` VALUES ('39614', '呈贡县', '3', '39557', 'C');
INSERT INTO `ey_region` VALUES ('39622', '晋宁县', '3', '39557', 'J');
INSERT INTO `ey_region` VALUES ('39632', '富民县', '3', '39557', 'F');
INSERT INTO `ey_region` VALUES ('39640', '宜良县', '3', '39557', 'Y');
INSERT INTO `ey_region` VALUES ('39650', '石林县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39659', '嵩明县', '3', '39557', 'S');
INSERT INTO `ey_region` VALUES ('39667', '禄劝县', '3', '39557', 'L');
INSERT INTO `ey_region` VALUES ('39684', '寻甸县', '3', '39557', 'X');
INSERT INTO `ey_region` VALUES ('39701', '安宁市', '3', '39557', 'A');
INSERT INTO `ey_region` VALUES ('39710', '曲靖市', '2', '39556', 'Q');
INSERT INTO `ey_region` VALUES ('39711', '市辖区', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39712', '麒麟区', '3', '39710', 'Q');
INSERT INTO `ey_region` VALUES ('39724', '马龙县', '3', '39710', 'M');
INSERT INTO `ey_region` VALUES ('39733', '陆良县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39744', '师宗县', '3', '39710', 'S');
INSERT INTO `ey_region` VALUES ('39753', '罗平县', '3', '39710', 'L');
INSERT INTO `ey_region` VALUES ('39766', '富源县', '3', '39710', 'F');
INSERT INTO `ey_region` VALUES ('39778', '会泽县', '3', '39710', 'H');
INSERT INTO `ey_region` VALUES ('39800', '沾益县', '3', '39710', 'Z');
INSERT INTO `ey_region` VALUES ('39809', '宣威市', '3', '39710', 'X');
INSERT INTO `ey_region` VALUES ('39836', '玉溪市', '2', '39556', 'Y');
INSERT INTO `ey_region` VALUES ('39837', '市辖区', '3', '39836', 'S');
INSERT INTO `ey_region` VALUES ('39838', '红塔区', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39850', '江川县', '3', '39836', 'J');
INSERT INTO `ey_region` VALUES ('39858', '澄江县', '3', '39836', 'C');
INSERT INTO `ey_region` VALUES ('39865', '通海县', '3', '39836', 'T');
INSERT INTO `ey_region` VALUES ('39875', '华宁县', '3', '39836', 'H');
INSERT INTO `ey_region` VALUES ('39881', '易门县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39889', '峨山县', '3', '39836', 'E');
INSERT INTO `ey_region` VALUES ('39899', '新平县', '3', '39836', 'X');
INSERT INTO `ey_region` VALUES ('39912', '元江县', '3', '39836', 'Y');
INSERT INTO `ey_region` VALUES ('39923', '保山市', '2', '39556', 'B');
INSERT INTO `ey_region` VALUES ('39924', '市辖区', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39925', '隆阳区', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39946', '施甸县', '3', '39923', 'S');
INSERT INTO `ey_region` VALUES ('39960', '腾冲县', '3', '39923', 'T');
INSERT INTO `ey_region` VALUES ('39979', '龙陵县', '3', '39923', 'L');
INSERT INTO `ey_region` VALUES ('39990', '昌宁县', '3', '39923', 'C');
INSERT INTO `ey_region` VALUES ('40004', '昭通市', '2', '39556', 'Z');
INSERT INTO `ey_region` VALUES ('40005', '市辖区', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40006', '昭阳区', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40027', '鲁甸县', '3', '40004', 'L');
INSERT INTO `ey_region` VALUES ('40040', '巧家县', '3', '40004', 'Q');
INSERT INTO `ey_region` VALUES ('40057', '盐津县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40068', '大关县', '3', '40004', 'D');
INSERT INTO `ey_region` VALUES ('40078', '永善县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40094', '绥江县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40100', '镇雄县', '3', '40004', 'Z');
INSERT INTO `ey_region` VALUES ('40129', '彝良县', '3', '40004', 'Y');
INSERT INTO `ey_region` VALUES ('40145', '威信县', '3', '40004', 'W');
INSERT INTO `ey_region` VALUES ('40156', '水富县', '3', '40004', 'S');
INSERT INTO `ey_region` VALUES ('40160', '丽江市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40161', '市辖区', '3', '40160', 'S');
INSERT INTO `ey_region` VALUES ('40162', '古城区', '3', '40160', 'G');
INSERT INTO `ey_region` VALUES ('40172', '玉龙县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40189', '永胜县', '3', '40160', 'Y');
INSERT INTO `ey_region` VALUES ('40205', '华坪县', '3', '40160', 'H');
INSERT INTO `ey_region` VALUES ('40214', '宁蒗县', '3', '40160', 'N');
INSERT INTO `ey_region` VALUES ('40230', '思茅市', '2', '39556', 'S');
INSERT INTO `ey_region` VALUES ('40231', '市辖区', '3', '40230', 'S');
INSERT INTO `ey_region` VALUES ('40232', '翠云区', '3', '40230', 'C');
INSERT INTO `ey_region` VALUES ('40240', '普洱县', '3', '40230', 'P');
INSERT INTO `ey_region` VALUES ('40250', '墨江县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40266', '景东县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40280', '景谷县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40291', '镇沅县', '3', '40230', 'Z');
INSERT INTO `ey_region` VALUES ('40301', '江城县', '3', '40230', 'J');
INSERT INTO `ey_region` VALUES ('40310', '孟连县', '3', '40230', 'M');
INSERT INTO `ey_region` VALUES ('40318', '澜沧县', '3', '40230', 'L');
INSERT INTO `ey_region` VALUES ('40340', '西盟县', '3', '40230', 'X');
INSERT INTO `ey_region` VALUES ('40348', '临沧市', '2', '39556', 'L');
INSERT INTO `ey_region` VALUES ('40349', '市辖区', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40350', '临翔区', '3', '40348', 'L');
INSERT INTO `ey_region` VALUES ('40361', '凤庆县', '3', '40348', 'F');
INSERT INTO `ey_region` VALUES ('40375', '云县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40388', '永德县', '3', '40348', 'Y');
INSERT INTO `ey_region` VALUES ('40400', '镇康县', '3', '40348', 'Z');
INSERT INTO `ey_region` VALUES ('40408', '双江县', '3', '40348', 'S');
INSERT INTO `ey_region` VALUES ('40417', '耿马县', '3', '40348', 'G');
INSERT INTO `ey_region` VALUES ('40429', '沧源县', '3', '40348', 'C');
INSERT INTO `ey_region` VALUES ('40441', '楚雄州', '2', '39556', 'C');
INSERT INTO `ey_region` VALUES ('40442', '楚雄市', '3', '40441', 'C');
INSERT INTO `ey_region` VALUES ('40458', '双柏县', '3', '40441', 'S');
INSERT INTO `ey_region` VALUES ('40467', '牟定县', '3', '40441', 'M');
INSERT INTO `ey_region` VALUES ('40475', '南华县', '3', '40441', 'N');
INSERT INTO `ey_region` VALUES ('40486', '姚安县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40496', '大姚县', '3', '40441', 'D');
INSERT INTO `ey_region` VALUES ('40509', '永仁县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40517', '元谋县', '3', '40441', 'Y');
INSERT INTO `ey_region` VALUES ('40528', '武定县', '3', '40441', 'W');
INSERT INTO `ey_region` VALUES ('40540', '禄丰县', '3', '40441', 'L');
INSERT INTO `ey_region` VALUES ('40555', '红河州', '2', '39556', 'H');
INSERT INTO `ey_region` VALUES ('40556', '个旧市', '3', '40555', 'G');
INSERT INTO `ey_region` VALUES ('40567', '开远市', '3', '40555', 'K');
INSERT INTO `ey_region` VALUES ('40576', '蒙自县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40588', '屏边县', '3', '40555', 'P');
INSERT INTO `ey_region` VALUES ('40596', '建水县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40611', '石屏县', '3', '40555', 'S');
INSERT INTO `ey_region` VALUES ('40621', '弥勒县', '3', '40555', 'M');
INSERT INTO `ey_region` VALUES ('40635', '泸西县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40644', '元阳县', '3', '40555', 'Y');
INSERT INTO `ey_region` VALUES ('40659', '红河县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40673', '金平县', '3', '40555', 'J');
INSERT INTO `ey_region` VALUES ('40688', '绿春县', '3', '40555', 'L');
INSERT INTO `ey_region` VALUES ('40698', '河口县', '3', '40555', 'H');
INSERT INTO `ey_region` VALUES ('40705', '文山州', '2', '39556', 'W');
INSERT INTO `ey_region` VALUES ('40706', '文山县', '3', '40705', 'W');
INSERT INTO `ey_region` VALUES ('40722', '砚山县', '3', '40705', 'Y');
INSERT INTO `ey_region` VALUES ('40734', '西畴县', '3', '40705', 'X');
INSERT INTO `ey_region` VALUES ('40744', '麻栗坡县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40756', '马关县', '3', '40705', 'M');
INSERT INTO `ey_region` VALUES ('40770', '丘北县', '3', '40705', 'Q');
INSERT INTO `ey_region` VALUES ('40783', '广南县', '3', '40705', 'G');
INSERT INTO `ey_region` VALUES ('40802', '富宁县', '3', '40705', 'F');
INSERT INTO `ey_region` VALUES ('40816', '西双版纳州', '2', '39556', 'X');
INSERT INTO `ey_region` VALUES ('40817', '景洪市', '3', '40816', 'J');
INSERT INTO `ey_region` VALUES ('40829', '勐海县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40841', '勐腊县', '3', '40816', 'M');
INSERT INTO `ey_region` VALUES ('40852', '大理州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40853', '大理市', '3', '40852', 'D');
INSERT INTO `ey_region` VALUES ('40866', '漾濞县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40876', '祥云县', '3', '40852', 'X');
INSERT INTO `ey_region` VALUES ('40887', '宾川县', '3', '40852', 'B');
INSERT INTO `ey_region` VALUES ('40901', '弥渡县', '3', '40852', 'M');
INSERT INTO `ey_region` VALUES ('40910', '南涧县', '3', '40852', 'N');
INSERT INTO `ey_region` VALUES ('40919', '巍山县', '3', '40852', 'W');
INSERT INTO `ey_region` VALUES ('40930', '永平县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40938', '云龙县', '3', '40852', 'Y');
INSERT INTO `ey_region` VALUES ('40950', '洱源县', '3', '40852', 'E');
INSERT INTO `ey_region` VALUES ('40960', '剑川县', '3', '40852', 'J');
INSERT INTO `ey_region` VALUES ('40969', '鹤庆县', '3', '40852', 'H');
INSERT INTO `ey_region` VALUES ('40979', '德宏州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('40980', '瑞丽市', '3', '40979', 'R');
INSERT INTO `ey_region` VALUES ('40988', '潞西市', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41000', '梁河县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41010', '盈江县', '3', '40979', 'Y');
INSERT INTO `ey_region` VALUES ('41026', '陇川县', '3', '40979', 'L');
INSERT INTO `ey_region` VALUES ('41036', '怒江州', '2', '39556', 'N');
INSERT INTO `ey_region` VALUES ('41037', '泸水县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41047', '福贡县', '3', '41036', 'F');
INSERT INTO `ey_region` VALUES ('41055', '贡山县', '3', '41036', 'G');
INSERT INTO `ey_region` VALUES ('41061', '兰坪县', '3', '41036', 'L');
INSERT INTO `ey_region` VALUES ('41070', '迪庆州', '2', '39556', 'D');
INSERT INTO `ey_region` VALUES ('41071', '香格里拉县', '3', '41070', 'X');
INSERT INTO `ey_region` VALUES ('41083', '德钦县', '3', '41070', 'D');
INSERT INTO `ey_region` VALUES ('41092', '维西县', '3', '41070', 'W');
INSERT INTO `ey_region` VALUES ('41103', '西藏', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('41104', '拉萨市', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41105', '市辖区', '3', '41104', 'S');
INSERT INTO `ey_region` VALUES ('41106', '城关区', '3', '41104', 'C');
INSERT INTO `ey_region` VALUES ('41118', '林周县', '3', '41104', 'L');
INSERT INTO `ey_region` VALUES ('41129', '当雄县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41138', '尼木县', '3', '41104', 'N');
INSERT INTO `ey_region` VALUES ('41147', '曲水县', '3', '41104', 'Q');
INSERT INTO `ey_region` VALUES ('41154', '堆龙德庆', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41162', '达孜县', '3', '41104', 'D');
INSERT INTO `ey_region` VALUES ('41169', '墨竹工卡县', '3', '41104', 'M');
INSERT INTO `ey_region` VALUES ('41178', '昌都地区', '2', '41103', 'C');
INSERT INTO `ey_region` VALUES ('41179', '昌都县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41195', '江达县', '3', '41178', 'J');
INSERT INTO `ey_region` VALUES ('41209', '贡觉县', '3', '41178', 'G');
INSERT INTO `ey_region` VALUES ('41222', '类乌齐县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41233', '丁青县', '3', '41178', 'D');
INSERT INTO `ey_region` VALUES ('41247', '察亚县', '3', '41178', 'C');
INSERT INTO `ey_region` VALUES ('41261', '八宿县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41276', '左贡县', '3', '41178', 'Z');
INSERT INTO `ey_region` VALUES ('41287', '芒康县', '3', '41178', 'M');
INSERT INTO `ey_region` VALUES ('41304', '洛隆县', '3', '41178', 'L');
INSERT INTO `ey_region` VALUES ('41316', '边坝县', '3', '41178', 'B');
INSERT INTO `ey_region` VALUES ('41328', '山南地区', '2', '41103', 'S');
INSERT INTO `ey_region` VALUES ('41329', '乃东县', '3', '41328', 'N');
INSERT INTO `ey_region` VALUES ('41337', '扎囊县', '3', '41328', 'Z');
INSERT INTO `ey_region` VALUES ('41343', '贡嘎县', '3', '41328', 'G');
INSERT INTO `ey_region` VALUES ('41352', '桑日县', '3', '41328', 'S');
INSERT INTO `ey_region` VALUES ('41357', '琼结县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41362', '曲松县', '3', '41328', 'Q');
INSERT INTO `ey_region` VALUES ('41368', '措美县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41373', '洛扎县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41381', '加查县', '3', '41328', 'J');
INSERT INTO `ey_region` VALUES ('41389', '隆子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41401', '错那县', '3', '41328', 'C');
INSERT INTO `ey_region` VALUES ('41412', '浪卡子县', '3', '41328', 'L');
INSERT INTO `ey_region` VALUES ('41423', '日喀则地区', '2', '41103', 'R');
INSERT INTO `ey_region` VALUES ('41424', '日喀则市', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41437', '南木林县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41455', '江孜县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41475', '定日县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41489', '萨迦县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41501', '拉孜县', '3', '41423', 'L');
INSERT INTO `ey_region` VALUES ('41513', '昂仁县', '3', '41423', 'A');
INSERT INTO `ey_region` VALUES ('41531', '谢通门县', '3', '41423', 'X');
INSERT INTO `ey_region` VALUES ('41551', '白朗县', '3', '41423', 'B');
INSERT INTO `ey_region` VALUES ('41563', '仁布县', '3', '41423', 'R');
INSERT INTO `ey_region` VALUES ('41573', '康马县', '3', '41423', 'K');
INSERT INTO `ey_region` VALUES ('41583', '定结县', '3', '41423', 'D');
INSERT INTO `ey_region` VALUES ('41594', '仲巴县', '3', '41423', 'Z');
INSERT INTO `ey_region` VALUES ('41608', '亚东县', '3', '41423', 'Y');
INSERT INTO `ey_region` VALUES ('41616', '吉隆县', '3', '41423', 'J');
INSERT INTO `ey_region` VALUES ('41622', '聂拉木县', '3', '41423', 'N');
INSERT INTO `ey_region` VALUES ('41630', '萨嘎县', '3', '41423', 'S');
INSERT INTO `ey_region` VALUES ('41639', '岗巴县', '3', '41423', 'G');
INSERT INTO `ey_region` VALUES ('41645', '那曲地区', '2', '41103', 'N');
INSERT INTO `ey_region` VALUES ('41646', '那曲县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41659', '嘉黎县', '3', '41645', 'J');
INSERT INTO `ey_region` VALUES ('41670', '比如县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41681', '聂荣县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41692', '安多县', '3', '41645', 'A');
INSERT INTO `ey_region` VALUES ('41706', '申扎县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41715', '索县', '3', '41645', 'S');
INSERT INTO `ey_region` VALUES ('41726', '班戈县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41737', '巴青县', '3', '41645', 'B');
INSERT INTO `ey_region` VALUES ('41748', '尼玛县', '3', '41645', 'N');
INSERT INTO `ey_region` VALUES ('41770', '阿里地区', '2', '41103', 'A');
INSERT INTO `ey_region` VALUES ('41771', '普兰县', '3', '41770', 'P');
INSERT INTO `ey_region` VALUES ('41775', '札达县', '3', '41770', 'Z');
INSERT INTO `ey_region` VALUES ('41782', '噶尔县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41788', '日土县', '3', '41770', 'R');
INSERT INTO `ey_region` VALUES ('41794', '革吉县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41800', '改则县', '3', '41770', 'G');
INSERT INTO `ey_region` VALUES ('41808', '措勤县', '3', '41770', 'C');
INSERT INTO `ey_region` VALUES ('41814', '林芝地区', '2', '41103', 'L');
INSERT INTO `ey_region` VALUES ('41815', '林芝县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41823', '工布江达县', '3', '41814', 'G');
INSERT INTO `ey_region` VALUES ('41833', '米林县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41842', '墨脱县', '3', '41814', 'M');
INSERT INTO `ey_region` VALUES ('41851', '波密县', '3', '41814', 'B');
INSERT INTO `ey_region` VALUES ('41863', '察隅县', '3', '41814', 'C');
INSERT INTO `ey_region` VALUES ('41870', '朗县', '3', '41814', 'L');
INSERT INTO `ey_region` VALUES ('41877', '陕西省', '1', '0', 'S');
INSERT INTO `ey_region` VALUES ('41878', '西安市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('41879', '市辖区', '3', '41878', 'S');
INSERT INTO `ey_region` VALUES ('41880', '新城区', '3', '41878', 'X');
INSERT INTO `ey_region` VALUES ('41890', '碑林区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41899', '莲湖区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41909', '灞桥区', '3', '41878', 'B');
INSERT INTO `ey_region` VALUES ('41919', '未央区', '3', '41878', 'W');
INSERT INTO `ey_region` VALUES ('41930', '雁塔区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41939', '阎良区', '3', '41878', 'Y');
INSERT INTO `ey_region` VALUES ('41947', '临潼区', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('41971', '长安区', '3', '41878', 'C');
INSERT INTO `ey_region` VALUES ('41997', '蓝田县', '3', '41878', 'L');
INSERT INTO `ey_region` VALUES ('42020', '周至县', '3', '41878', 'Z');
INSERT INTO `ey_region` VALUES ('42043', '户县', '3', '41878', 'H');
INSERT INTO `ey_region` VALUES ('42060', '高陵县', '3', '41878', 'G');
INSERT INTO `ey_region` VALUES ('42069', '铜川市', '2', '41877', 'T');
INSERT INTO `ey_region` VALUES ('42070', '市辖区', '3', '42069', 'S');
INSERT INTO `ey_region` VALUES ('42071', '王益区', '3', '42069', 'W');
INSERT INTO `ey_region` VALUES ('42079', '印台区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42091', '耀州区', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42108', '宜君县', '3', '42069', 'Y');
INSERT INTO `ey_region` VALUES ('42119', '宝鸡市', '2', '41877', 'B');
INSERT INTO `ey_region` VALUES ('42120', '市辖区', '3', '42119', 'S');
INSERT INTO `ey_region` VALUES ('42121', '渭滨区', '3', '42119', 'W');
INSERT INTO `ey_region` VALUES ('42133', '金台区', '3', '42119', 'J');
INSERT INTO `ey_region` VALUES ('42146', '陈仓区', '3', '42119', 'C');
INSERT INTO `ey_region` VALUES ('42165', '凤翔县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42183', '岐山县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42198', '扶风县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42211', '眉县', '3', '42119', 'M');
INSERT INTO `ey_region` VALUES ('42224', '陇县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42240', '千阳县', '3', '42119', 'Q');
INSERT INTO `ey_region` VALUES ('42252', '麟游县', '3', '42119', 'L');
INSERT INTO `ey_region` VALUES ('42263', '凤县', '3', '42119', 'F');
INSERT INTO `ey_region` VALUES ('42278', '太白县', '3', '42119', 'T');
INSERT INTO `ey_region` VALUES ('42287', '咸阳市', '2', '41877', 'X');
INSERT INTO `ey_region` VALUES ('42288', '市辖区', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42289', '秦都区', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42302', '杨凌区', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42308', '渭城区', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42319', '三原县', '3', '42287', 'S');
INSERT INTO `ey_region` VALUES ('42334', '泾阳县', '3', '42287', 'J');
INSERT INTO `ey_region` VALUES ('42351', '乾县', '3', '42287', 'Q');
INSERT INTO `ey_region` VALUES ('42372', '礼泉县', '3', '42287', 'L');
INSERT INTO `ey_region` VALUES ('42388', '永寿县', '3', '42287', 'Y');
INSERT INTO `ey_region` VALUES ('42402', '彬县', '3', '42287', 'B');
INSERT INTO `ey_region` VALUES ('42419', '长武县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42431', '旬邑县', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42446', '淳化县', '3', '42287', 'C');
INSERT INTO `ey_region` VALUES ('42462', '武功县', '3', '42287', 'W');
INSERT INTO `ey_region` VALUES ('42475', '兴平市', '3', '42287', 'X');
INSERT INTO `ey_region` VALUES ('42490', '渭南市', '2', '41877', 'W');
INSERT INTO `ey_region` VALUES ('42491', '市辖区', '3', '42490', 'S');
INSERT INTO `ey_region` VALUES ('42492', '临渭区', '3', '42490', 'L');
INSERT INTO `ey_region` VALUES ('42523', '华县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42538', '潼关县', '3', '42490', 'T');
INSERT INTO `ey_region` VALUES ('42547', '大荔县', '3', '42490', 'D');
INSERT INTO `ey_region` VALUES ('42577', '合阳县', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42594', '澄城县', '3', '42490', 'C');
INSERT INTO `ey_region` VALUES ('42609', '蒲城县', '3', '42490', 'P');
INSERT INTO `ey_region` VALUES ('42634', '白水县', '3', '42490', 'B');
INSERT INTO `ey_region` VALUES ('42649', '富平县', '3', '42490', 'F');
INSERT INTO `ey_region` VALUES ('42674', '韩城市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42691', '华阴市', '3', '42490', 'H');
INSERT INTO `ey_region` VALUES ('42703', '延安市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('42704', '市辖区', '3', '42703', 'S');
INSERT INTO `ey_region` VALUES ('42705', '宝塔区', '3', '42703', 'B');
INSERT INTO `ey_region` VALUES ('42729', '延长县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42742', '延川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42757', '子长县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42771', '安塞县', '3', '42703', 'A');
INSERT INTO `ey_region` VALUES ('42784', '志丹县', '3', '42703', 'Z');
INSERT INTO `ey_region` VALUES ('42796', '吴起县', '3', '42703', 'W');
INSERT INTO `ey_region` VALUES ('42809', '甘泉县', '3', '42703', 'G');
INSERT INTO `ey_region` VALUES ('42818', '富县', '3', '42703', 'F');
INSERT INTO `ey_region` VALUES ('42833', '洛川县', '3', '42703', 'L');
INSERT INTO `ey_region` VALUES ('42850', '宜川县', '3', '42703', 'Y');
INSERT INTO `ey_region` VALUES ('42863', '黄龙县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42874', '黄陵县', '3', '42703', 'H');
INSERT INTO `ey_region` VALUES ('42888', '汉中市', '2', '41877', 'H');
INSERT INTO `ey_region` VALUES ('42889', '市辖区', '3', '42888', 'S');
INSERT INTO `ey_region` VALUES ('42890', '汉台区', '3', '42888', 'H');
INSERT INTO `ey_region` VALUES ('42908', '南郑县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('42939', '城固县', '3', '42888', 'C');
INSERT INTO `ey_region` VALUES ('42965', '洋县', '3', '42888', 'Y');
INSERT INTO `ey_region` VALUES ('42992', '西乡县', '3', '42888', 'X');
INSERT INTO `ey_region` VALUES ('43016', '勉县', '3', '42888', 'M');
INSERT INTO `ey_region` VALUES ('43042', '宁强县', '3', '42888', 'N');
INSERT INTO `ey_region` VALUES ('43069', '略阳县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43091', '镇巴县', '3', '42888', 'Z');
INSERT INTO `ey_region` VALUES ('43116', '留坝县', '3', '42888', 'L');
INSERT INTO `ey_region` VALUES ('43126', '佛坪县', '3', '42888', 'F');
INSERT INTO `ey_region` VALUES ('43136', '榆林市', '2', '41877', 'Y');
INSERT INTO `ey_region` VALUES ('43137', '市辖区', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43138', '榆阳区', '3', '43136', 'Y');
INSERT INTO `ey_region` VALUES ('43170', '神木县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43190', '府谷县', '3', '43136', 'F');
INSERT INTO `ey_region` VALUES ('43211', '横山县', '3', '43136', 'H');
INSERT INTO `ey_region` VALUES ('43230', '靖边县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43253', '定边县', '3', '43136', 'D');
INSERT INTO `ey_region` VALUES ('43279', '绥德县', '3', '43136', 'S');
INSERT INTO `ey_region` VALUES ('43300', '米脂县', '3', '43136', 'M');
INSERT INTO `ey_region` VALUES ('43314', '佳县', '3', '43136', 'J');
INSERT INTO `ey_region` VALUES ('43335', '吴堡县', '3', '43136', 'W');
INSERT INTO `ey_region` VALUES ('43344', '清涧县', '3', '43136', 'Q');
INSERT INTO `ey_region` VALUES ('43360', '子洲县', '3', '43136', 'Z');
INSERT INTO `ey_region` VALUES ('43379', '安康市', '2', '41877', 'A');
INSERT INTO `ey_region` VALUES ('43380', '市辖区', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43381', '汉滨区', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43428', '汉阴县', '3', '43379', 'H');
INSERT INTO `ey_region` VALUES ('43447', '石泉县', '3', '43379', 'S');
INSERT INTO `ey_region` VALUES ('43463', '宁陕县', '3', '43379', 'N');
INSERT INTO `ey_region` VALUES ('43478', '紫阳县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43504', '岚皋县', '3', '43379', 'L');
INSERT INTO `ey_region` VALUES ('43522', '平利县', '3', '43379', 'P');
INSERT INTO `ey_region` VALUES ('43535', '镇坪县', '3', '43379', 'Z');
INSERT INTO `ey_region` VALUES ('43546', '旬阳县', '3', '43379', 'X');
INSERT INTO `ey_region` VALUES ('43575', '白河县', '3', '43379', 'B');
INSERT INTO `ey_region` VALUES ('43592', '商洛市', '2', '41877', 'S');
INSERT INTO `ey_region` VALUES ('43593', '市辖区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43594', '商州区', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43628', '洛南县', '3', '43592', 'L');
INSERT INTO `ey_region` VALUES ('43654', '丹凤县', '3', '43592', 'D');
INSERT INTO `ey_region` VALUES ('43676', '商南县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43699', '山阳县', '3', '43592', 'S');
INSERT INTO `ey_region` VALUES ('43730', '镇安县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43759', '柞水县', '3', '43592', 'Z');
INSERT INTO `ey_region` VALUES ('43776', '甘肃省', '1', '0', 'G');
INSERT INTO `ey_region` VALUES ('43777', '兰州市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('43778', '市辖区', '3', '43777', 'S');
INSERT INTO `ey_region` VALUES ('43779', '城关区', '3', '43777', 'C');
INSERT INTO `ey_region` VALUES ('43804', '七里河区', '3', '43777', 'Q');
INSERT INTO `ey_region` VALUES ('43820', '兰州市西固区', '3', '43777', 'L');
INSERT INTO `ey_region` VALUES ('43836', '安宁区', '3', '43777', 'A');
INSERT INTO `ey_region` VALUES ('43845', '红古区', '3', '43777', 'H');
INSERT INTO `ey_region` VALUES ('43853', '永登县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43872', '皋兰县', '3', '43777', 'G');
INSERT INTO `ey_region` VALUES ('43880', '榆中县', '3', '43777', 'Y');
INSERT INTO `ey_region` VALUES ('43904', '嘉峪关市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43905', '市辖', '3', '43904', 'S');
INSERT INTO `ey_region` VALUES ('43914', '金昌市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('43915', '市辖区', '3', '43914', 'S');
INSERT INTO `ey_region` VALUES ('43916', '金川区', '3', '43914', 'J');
INSERT INTO `ey_region` VALUES ('43925', '永昌县', '3', '43914', 'Y');
INSERT INTO `ey_region` VALUES ('43936', '白银市', '2', '43776', 'B');
INSERT INTO `ey_region` VALUES ('43937', '市辖区', '3', '43936', 'S');
INSERT INTO `ey_region` VALUES ('43938', '白银区', '3', '43936', 'B');
INSERT INTO `ey_region` VALUES ('43949', '平川区', '3', '43936', 'P');
INSERT INTO `ey_region` VALUES ('43961', '靖远县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('43980', '会宁县', '3', '43936', 'H');
INSERT INTO `ey_region` VALUES ('44009', '景泰县', '3', '43936', 'J');
INSERT INTO `ey_region` VALUES ('44022', '天水市', '2', '43776', 'T');
INSERT INTO `ey_region` VALUES ('44023', '市辖区', '3', '44022', 'S');
INSERT INTO `ey_region` VALUES ('44024', '秦州区', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44048', '麦积区', '3', '44022', 'M');
INSERT INTO `ey_region` VALUES ('44069', '清水县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44088', '秦安县', '3', '44022', 'Q');
INSERT INTO `ey_region` VALUES ('44106', '甘谷县', '3', '44022', 'G');
INSERT INTO `ey_region` VALUES ('44122', '武山县', '3', '44022', 'W');
INSERT INTO `ey_region` VALUES ('44138', '张家川县', '3', '44022', 'Z');
INSERT INTO `ey_region` VALUES ('44154', '武威市', '2', '43776', 'W');
INSERT INTO `ey_region` VALUES ('44155', '市辖区', '3', '44154', 'S');
INSERT INTO `ey_region` VALUES ('44156', '凉州区', '3', '44154', 'L');
INSERT INTO `ey_region` VALUES ('44202', '民勤县', '3', '44154', 'M');
INSERT INTO `ey_region` VALUES ('44221', '古浪县', '3', '44154', 'G');
INSERT INTO `ey_region` VALUES ('44242', '天祝县', '3', '44154', 'T');
INSERT INTO `ey_region` VALUES ('44265', '张掖市', '2', '43776', 'Z');
INSERT INTO `ey_region` VALUES ('44266', '市辖区', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44267', '甘州区', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44294', '肃南县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44305', '民乐县', '3', '44265', 'M');
INSERT INTO `ey_region` VALUES ('44317', '临泽县', '3', '44265', 'L');
INSERT INTO `ey_region` VALUES ('44331', '高台县', '3', '44265', 'G');
INSERT INTO `ey_region` VALUES ('44341', '山丹县', '3', '44265', 'S');
INSERT INTO `ey_region` VALUES ('44352', '平凉市', '2', '43776', 'P');
INSERT INTO `ey_region` VALUES ('44353', '市辖区', '3', '44352', 'S');
INSERT INTO `ey_region` VALUES ('44354', '崆峒区', '3', '44352', 'K');
INSERT INTO `ey_region` VALUES ('44375', '泾川县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44392', '灵台县', '3', '44352', 'L');
INSERT INTO `ey_region` VALUES ('44408', '崇信县', '3', '44352', 'C');
INSERT INTO `ey_region` VALUES ('44418', '华亭县', '3', '44352', 'H');
INSERT INTO `ey_region` VALUES ('44431', '庄浪县', '3', '44352', 'Z');
INSERT INTO `ey_region` VALUES ('44451', '静宁县', '3', '44352', 'J');
INSERT INTO `ey_region` VALUES ('44477', '酒泉市', '2', '43776', 'J');
INSERT INTO `ey_region` VALUES ('44478', '市辖区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44479', '肃州区', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44504', '金塔县', '3', '44477', 'J');
INSERT INTO `ey_region` VALUES ('44516', '瓜州县', '3', '44477', 'G');
INSERT INTO `ey_region` VALUES ('44531', '肃北县', '3', '44477', 'S');
INSERT INTO `ey_region` VALUES ('44535', '阿克塞县', '3', '44477', 'A');
INSERT INTO `ey_region` VALUES ('44539', '玉门市', '3', '44477', 'Y');
INSERT INTO `ey_region` VALUES ('44557', '敦煌市', '3', '44477', 'D');
INSERT INTO `ey_region` VALUES ('44569', '庆阳市', '2', '43776', 'Q');
INSERT INTO `ey_region` VALUES ('44570', '市辖区', '3', '44569', 'S');
INSERT INTO `ey_region` VALUES ('44571', '西峰区', '3', '44569', 'X');
INSERT INTO `ey_region` VALUES ('44582', '庆城县', '3', '44569', 'Q');
INSERT INTO `ey_region` VALUES ('44598', '环县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44620', '华池县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44636', '合水县', '3', '44569', 'H');
INSERT INTO `ey_region` VALUES ('44649', '正宁县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44660', '宁县', '3', '44569', 'N');
INSERT INTO `ey_region` VALUES ('44679', '镇原县', '3', '44569', 'Z');
INSERT INTO `ey_region` VALUES ('44699', '定西市', '2', '43776', 'D');
INSERT INTO `ey_region` VALUES ('44700', '市辖区', '3', '44699', 'S');
INSERT INTO `ey_region` VALUES ('44701', '安定区', '3', '44699', 'A');
INSERT INTO `ey_region` VALUES ('44723', '通渭县', '3', '44699', 'T');
INSERT INTO `ey_region` VALUES ('44742', '陇西县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44760', '渭源县', '3', '44699', 'W');
INSERT INTO `ey_region` VALUES ('44777', '临洮县', '3', '44699', 'L');
INSERT INTO `ey_region` VALUES ('44796', '漳县', '3', '44699', 'Z');
INSERT INTO `ey_region` VALUES ('44810', '岷县', '3', '44699', 'M');
INSERT INTO `ey_region` VALUES ('44829', '陇南市', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('44830', '市辖区', '3', '44829', 'S');
INSERT INTO `ey_region` VALUES ('44831', '武都区', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44868', '成县', '3', '44829', 'C');
INSERT INTO `ey_region` VALUES ('44886', '文县', '3', '44829', 'W');
INSERT INTO `ey_region` VALUES ('44907', '宕昌县', '3', '44829', 'D');
INSERT INTO `ey_region` VALUES ('44933', '康县', '3', '44829', 'K');
INSERT INTO `ey_region` VALUES ('44955', '西和县', '3', '44829', 'X');
INSERT INTO `ey_region` VALUES ('44976', '礼县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45006', '徽县', '3', '44829', 'H');
INSERT INTO `ey_region` VALUES ('45022', '两当县', '3', '44829', 'L');
INSERT INTO `ey_region` VALUES ('45035', '临夏州', '2', '43776', 'L');
INSERT INTO `ey_region` VALUES ('45036', '临夏市', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45047', '临夏县', '3', '45035', 'L');
INSERT INTO `ey_region` VALUES ('45073', '康乐县', '3', '45035', 'K');
INSERT INTO `ey_region` VALUES ('45089', '永靖县', '3', '45035', 'Y');
INSERT INTO `ey_region` VALUES ('45107', '广河县', '3', '45035', 'G');
INSERT INTO `ey_region` VALUES ('45117', '和政县', '3', '45035', 'H');
INSERT INTO `ey_region` VALUES ('45131', '东乡县', '3', '45035', 'D');
INSERT INTO `ey_region` VALUES ('45156', '积石山县', '3', '45035', 'J');
INSERT INTO `ey_region` VALUES ('45174', '甘南州', '2', '43776', 'G');
INSERT INTO `ey_region` VALUES ('45175', '合作市', '3', '45174', 'H');
INSERT INTO `ey_region` VALUES ('45186', '临潭县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45203', '卓尼县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45219', '舟曲县', '3', '45174', 'Z');
INSERT INTO `ey_region` VALUES ('45239', '迭部县', '3', '45174', 'D');
INSERT INTO `ey_region` VALUES ('45251', '玛曲县', '3', '45174', 'M');
INSERT INTO `ey_region` VALUES ('45263', '碌曲县', '3', '45174', 'L');
INSERT INTO `ey_region` VALUES ('45272', '夏河县', '3', '45174', 'X');
INSERT INTO `ey_region` VALUES ('45286', '青海省', '1', '0', 'Q');
INSERT INTO `ey_region` VALUES ('45287', '西宁市', '2', '45286', 'X');
INSERT INTO `ey_region` VALUES ('45288', '市辖区', '3', '45287', 'S');
INSERT INTO `ey_region` VALUES ('45289', '城东区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45299', '城中区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45306', '城西区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45314', '城北区', '3', '45287', 'C');
INSERT INTO `ey_region` VALUES ('45320', '大通县', '3', '45287', 'D');
INSERT INTO `ey_region` VALUES ('45341', '湟中县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45358', '湟源县', '3', '45287', 'H');
INSERT INTO `ey_region` VALUES ('45368', '海东地区', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45369', '平安县', '3', '45368', 'P');
INSERT INTO `ey_region` VALUES ('45378', '民和县', '3', '45368', 'M');
INSERT INTO `ey_region` VALUES ('45401', '乐都县', '3', '45368', 'L');
INSERT INTO `ey_region` VALUES ('45421', '互助县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45441', '化隆县', '3', '45368', 'H');
INSERT INTO `ey_region` VALUES ('45461', '循化县', '3', '45368', 'X');
INSERT INTO `ey_region` VALUES ('45471', '海北州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45472', '门源县', '3', '45471', 'M');
INSERT INTO `ey_region` VALUES ('45487', '祁连县', '3', '45471', 'Q');
INSERT INTO `ey_region` VALUES ('45495', '海晏县', '3', '45471', 'H');
INSERT INTO `ey_region` VALUES ('45502', '刚察县', '3', '45471', 'G');
INSERT INTO `ey_region` VALUES ('45510', '黄南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45511', '同仁县', '3', '45510', 'T');
INSERT INTO `ey_region` VALUES ('45523', '尖扎县', '3', '45510', 'J');
INSERT INTO `ey_region` VALUES ('45533', '泽库县', '3', '45510', 'Z');
INSERT INTO `ey_region` VALUES ('45542', '河南县', '3', '45510', 'H');
INSERT INTO `ey_region` VALUES ('45548', '海南州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45549', '共和县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45566', '同德县', '3', '45548', 'T');
INSERT INTO `ey_region` VALUES ('45573', '贵德县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45581', '兴海县', '3', '45548', 'X');
INSERT INTO `ey_region` VALUES ('45589', '贵南县', '3', '45548', 'G');
INSERT INTO `ey_region` VALUES ('45597', '果洛州', '2', '45286', 'G');
INSERT INTO `ey_region` VALUES ('45598', '玛沁县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45607', '班玛县', '3', '45597', 'B');
INSERT INTO `ey_region` VALUES ('45617', '甘德县', '3', '45597', 'G');
INSERT INTO `ey_region` VALUES ('45625', '达日县', '3', '45597', 'D');
INSERT INTO `ey_region` VALUES ('45636', '久治县', '3', '45597', 'J');
INSERT INTO `ey_region` VALUES ('45643', '玛多县', '3', '45597', 'M');
INSERT INTO `ey_region` VALUES ('45648', '玉树州', '2', '45286', 'Y');
INSERT INTO `ey_region` VALUES ('45649', '玉树县', '3', '45648', 'Y');
INSERT INTO `ey_region` VALUES ('45659', '杂多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45668', '称多县', '3', '45648', 'C');
INSERT INTO `ey_region` VALUES ('45676', '治多县', '3', '45648', 'Z');
INSERT INTO `ey_region` VALUES ('45683', '囊谦县', '3', '45648', 'N');
INSERT INTO `ey_region` VALUES ('45694', '曲麻莱县', '3', '45648', 'Q');
INSERT INTO `ey_region` VALUES ('45701', '海西州', '2', '45286', 'H');
INSERT INTO `ey_region` VALUES ('45702', '格尔木市', '3', '45701', 'G');
INSERT INTO `ey_region` VALUES ('45714', '德令哈市', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45727', '乌兰县', '3', '45701', 'W');
INSERT INTO `ey_region` VALUES ('45733', '都兰县', '3', '45701', 'D');
INSERT INTO `ey_region` VALUES ('45742', '天峻县', '3', '45701', 'T');
INSERT INTO `ey_region` VALUES ('45753', '宁夏', '1', '0', 'N');
INSERT INTO `ey_region` VALUES ('45754', '银川市', '2', '45753', 'Y');
INSERT INTO `ey_region` VALUES ('45755', '市辖区', '3', '45754', 'S');
INSERT INTO `ey_region` VALUES ('45756', '兴庆区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45772', '西夏区', '3', '45754', 'X');
INSERT INTO `ey_region` VALUES ('45784', '金凤区', '3', '45754', 'J');
INSERT INTO `ey_region` VALUES ('45794', '永宁县', '3', '45754', 'Y');
INSERT INTO `ey_region` VALUES ('45803', '贺兰县', '3', '45754', 'H');
INSERT INTO `ey_region` VALUES ('45813', '灵武市', '3', '45754', 'L');
INSERT INTO `ey_region` VALUES ('45825', '石嘴山市', '2', '45753', 'S');
INSERT INTO `ey_region` VALUES ('45826', '市辖区', '3', '45825', 'S');
INSERT INTO `ey_region` VALUES ('45827', '大武口区', '3', '45825', 'D');
INSERT INTO `ey_region` VALUES ('45839', '惠农区', '3', '45825', 'H');
INSERT INTO `ey_region` VALUES ('45856', '平罗县', '3', '45825', 'P');
INSERT INTO `ey_region` VALUES ('45871', '吴忠市', '2', '45753', 'W');
INSERT INTO `ey_region` VALUES ('45872', '市辖区', '3', '45871', 'S');
INSERT INTO `ey_region` VALUES ('45877', '利通区', '3', '45871', 'L');
INSERT INTO `ey_region` VALUES ('45892', '盐池县', '3', '45871', 'Y');
INSERT INTO `ey_region` VALUES ('45903', '同心县', '3', '45871', 'T');
INSERT INTO `ey_region` VALUES ('45914', '青铜峡市', '3', '45871', 'Q');
INSERT INTO `ey_region` VALUES ('45926', '固原市', '2', '45753', 'G');
INSERT INTO `ey_region` VALUES ('45927', '市辖区', '3', '45926', 'S');
INSERT INTO `ey_region` VALUES ('45928', '原州区', '3', '45926', 'Y');
INSERT INTO `ey_region` VALUES ('45944', '西吉县', '3', '45926', 'X');
INSERT INTO `ey_region` VALUES ('45964', '隆德县', '3', '45926', 'L');
INSERT INTO `ey_region` VALUES ('45978', '泾源县', '3', '45926', 'J');
INSERT INTO `ey_region` VALUES ('45986', '彭阳县', '3', '45926', 'P');
INSERT INTO `ey_region` VALUES ('45999', '中卫市', '2', '45753', 'Z');
INSERT INTO `ey_region` VALUES ('46000', '市辖区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46012', '沙坡头区', '3', '45999', 'S');
INSERT INTO `ey_region` VALUES ('46013', '中宁县', '3', '45999', 'Z');
INSERT INTO `ey_region` VALUES ('46026', '海原县', '3', '45999', 'H');
INSERT INTO `ey_region` VALUES ('46047', '新疆', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('46048', '乌鲁木齐市', '2', '46047', 'W');
INSERT INTO `ey_region` VALUES ('46049', '市辖区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46050', '天山区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46065', '沙依巴克区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46079', '新市区', '3', '46048', 'X');
INSERT INTO `ey_region` VALUES ('46095', '水磨沟区', '3', '46048', 'S');
INSERT INTO `ey_region` VALUES ('46104', '头屯河区', '3', '46048', 'T');
INSERT INTO `ey_region` VALUES ('46114', '达坂城区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46123', '东山区', '3', '46048', 'D');
INSERT INTO `ey_region` VALUES ('46128', '乌鲁木齐县', '3', '46048', 'W');
INSERT INTO `ey_region` VALUES ('46138', '克拉玛依市', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46139', '市辖区', '3', '46138', 'S');
INSERT INTO `ey_region` VALUES ('46140', '独山子区', '3', '46138', 'D');
INSERT INTO `ey_region` VALUES ('46144', '克拉玛依区', '3', '46138', 'K');
INSERT INTO `ey_region` VALUES ('46155', '白碱滩区', '3', '46138', 'B');
INSERT INTO `ey_region` VALUES ('46158', '乌尔禾区', '3', '46138', 'W');
INSERT INTO `ey_region` VALUES ('46162', '吐鲁番地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('46163', '吐鲁番市', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46178', '鄯善县', '3', '46162', 'S');
INSERT INTO `ey_region` VALUES ('46189', '托克逊县', '3', '46162', 'T');
INSERT INTO `ey_region` VALUES ('46197', '哈密地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46198', '哈密市', '3', '46197', 'H');
INSERT INTO `ey_region` VALUES ('46230', '巴里坤县', '3', '46197', 'B');
INSERT INTO `ey_region` VALUES ('46246', '伊吾县', '3', '46197', 'Y');
INSERT INTO `ey_region` VALUES ('46255', '昌吉州', '2', '46047', 'C');
INSERT INTO `ey_region` VALUES ('46256', '昌吉市', '3', '46255', 'C');
INSERT INTO `ey_region` VALUES ('46275', '阜康市', '3', '46255', 'F');
INSERT INTO `ey_region` VALUES ('46289', '米泉市', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46299', '呼图壁县', '3', '46255', 'H');
INSERT INTO `ey_region` VALUES ('46316', '玛纳斯', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46337', '奇台县', '3', '46255', 'Q');
INSERT INTO `ey_region` VALUES ('46355', '吉木萨尔县', '3', '46255', 'J');
INSERT INTO `ey_region` VALUES ('46366', '木垒县', '3', '46255', 'M');
INSERT INTO `ey_region` VALUES ('46380', '博州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46381', '博乐市', '3', '46380', 'B');
INSERT INTO `ey_region` VALUES ('46399', '精河县', '3', '46380', 'J');
INSERT INTO `ey_region` VALUES ('46410', '温泉县', '3', '46380', 'W');
INSERT INTO `ey_region` VALUES ('46422', '巴州', '2', '46047', 'B');
INSERT INTO `ey_region` VALUES ('46423', '库尔勒市', '3', '46422', 'K');
INSERT INTO `ey_region` VALUES ('46451', '轮台县', '3', '46422', 'L');
INSERT INTO `ey_region` VALUES ('46463', '尉犁县', '3', '46422', 'W');
INSERT INTO `ey_region` VALUES ('46476', '若羌县', '3', '46422', 'R');
INSERT INTO `ey_region` VALUES ('46486', '且末县', '3', '46422', 'Q');
INSERT INTO `ey_region` VALUES ('46500', '焉耆县', '3', '46422', 'Y');
INSERT INTO `ey_region` VALUES ('46512', '和静县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46531', '和硕县', '3', '46422', 'H');
INSERT INTO `ey_region` VALUES ('46542', '博湖县', '3', '46422', 'B');
INSERT INTO `ey_region` VALUES ('46551', '阿克苏地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('46552', '阿克苏市', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46571', '温宿县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46592', '库车县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46617', '沙雅县', '3', '46551', 'S');
INSERT INTO `ey_region` VALUES ('46630', '新和县', '3', '46551', 'X');
INSERT INTO `ey_region` VALUES ('46640', '拜城县', '3', '46551', 'B');
INSERT INTO `ey_region` VALUES ('46657', '乌什县', '3', '46551', 'W');
INSERT INTO `ey_region` VALUES ('46668', '阿瓦提县', '3', '46551', 'A');
INSERT INTO `ey_region` VALUES ('46682', '柯坪县', '3', '46551', 'K');
INSERT INTO `ey_region` VALUES ('46688', '克州', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46689', '阿图什市', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46704', '阿克陶县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46723', '阿合奇县', '3', '46688', 'A');
INSERT INTO `ey_region` VALUES ('46733', '乌恰县', '3', '46688', 'W');
INSERT INTO `ey_region` VALUES ('46747', '喀什地区', '2', '46047', 'K');
INSERT INTO `ey_region` VALUES ('46748', '喀什市', '3', '46747', 'K');
INSERT INTO `ey_region` VALUES ('46761', '疏附县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46780', '疏勒县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46797', '英吉沙县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46813', '泽普县', '3', '46747', 'Z');
INSERT INTO `ey_region` VALUES ('46830', '莎车县', '3', '46747', 'S');
INSERT INTO `ey_region` VALUES ('46863', '叶城县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46885', '麦盖提县', '3', '46747', 'M');
INSERT INTO `ey_region` VALUES ('46902', '岳普湖县', '3', '46747', 'Y');
INSERT INTO `ey_region` VALUES ('46913', '伽师县', '3', '46747', 'Q');
INSERT INTO `ey_region` VALUES ('46928', '巴楚县', '3', '46747', 'B');
INSERT INTO `ey_region` VALUES ('46942', '塔什库尔干县', '3', '46747', 'T');
INSERT INTO `ey_region` VALUES ('46957', '和田地区', '2', '46047', 'H');
INSERT INTO `ey_region` VALUES ('46958', '和田市', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46971', '和田县', '3', '46957', 'H');
INSERT INTO `ey_region` VALUES ('46983', '墨玉县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47002', '皮山县', '3', '46957', 'P');
INSERT INTO `ey_region` VALUES ('47020', '洛浦县', '3', '46957', 'L');
INSERT INTO `ey_region` VALUES ('47032', '策勒县', '3', '46957', 'C');
INSERT INTO `ey_region` VALUES ('47042', '于田县', '3', '46957', 'Y');
INSERT INTO `ey_region` VALUES ('47061', '民丰县', '3', '46957', 'M');
INSERT INTO `ey_region` VALUES ('47069', '伊犁州', '2', '46047', 'Y');
INSERT INTO `ey_region` VALUES ('47070', '伊宁市', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47091', '奎屯市', '3', '47069', 'K');
INSERT INTO `ey_region` VALUES ('47099', '伊宁县', '3', '47069', 'Y');
INSERT INTO `ey_region` VALUES ('47121', '察布查尔县', '3', '47069', 'C');
INSERT INTO `ey_region` VALUES ('47143', '霍城县', '3', '47069', 'H');
INSERT INTO `ey_region` VALUES ('47164', '巩留县', '3', '47069', 'G');
INSERT INTO `ey_region` VALUES ('47180', '新源县', '3', '47069', 'X');
INSERT INTO `ey_region` VALUES ('47196', '昭苏县', '3', '47069', 'Z');
INSERT INTO `ey_region` VALUES ('47214', '特克斯县', '3', '47069', 'T');
INSERT INTO `ey_region` VALUES ('47226', '尼勒克县', '3', '47069', 'N');
INSERT INTO `ey_region` VALUES ('47241', '塔城地区', '2', '46047', 'T');
INSERT INTO `ey_region` VALUES ('47242', '塔城市', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47258', '乌苏市', '3', '47241', 'W');
INSERT INTO `ey_region` VALUES ('47291', '额敏县', '3', '47241', 'E');
INSERT INTO `ey_region` VALUES ('47315', '沙湾县', '3', '47241', 'S');
INSERT INTO `ey_region` VALUES ('47338', '托里县', '3', '47241', 'T');
INSERT INTO `ey_region` VALUES ('47351', '裕民县', '3', '47241', 'Y');
INSERT INTO `ey_region` VALUES ('47360', '和布县', '3', '47241', 'H');
INSERT INTO `ey_region` VALUES ('47374', '阿勒泰地区', '2', '46047', 'A');
INSERT INTO `ey_region` VALUES ('47375', '阿勒泰市', '3', '47374', 'A');
INSERT INTO `ey_region` VALUES ('47393', '布尔津县', '3', '47374', 'B');
INSERT INTO `ey_region` VALUES ('47401', '富蕴县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47411', '福海县', '3', '47374', 'F');
INSERT INTO `ey_region` VALUES ('47424', '哈巴河县', '3', '47374', 'H');
INSERT INTO `ey_region` VALUES ('47433', '青河县', '3', '47374', 'Q');
INSERT INTO `ey_region` VALUES ('47441', '吉木乃县', '3', '47374', 'J');
INSERT INTO `ey_region` VALUES ('47450', '省直辖行政单位', '2', '46047', 'S');
INSERT INTO `ey_region` VALUES ('47451', '石河子市', '3', '47450', 'S');
INSERT INTO `ey_region` VALUES ('47460', '阿拉尔市', '3', '47450', 'A');
INSERT INTO `ey_region` VALUES ('47477', '图木舒克市', '3', '47450', 'T');
INSERT INTO `ey_region` VALUES ('47486', '五家渠市', '3', '47450', 'W');
INSERT INTO `ey_region` VALUES ('47493', '台湾', '1', '0', 'T');
INSERT INTO `ey_region` VALUES ('47494', '香港', '1', '0', 'X');
INSERT INTO `ey_region` VALUES ('47495', '澳门', '1', '0', 'A');
INSERT INTO `ey_region` VALUES ('47496', '龙华新区', '3', '28558', 'L');
INSERT INTO `ey_region` VALUES ('47497', '光明新区', '3', '28558', 'G');
INSERT INTO `ey_region` VALUES ('47500', '新界', '2', '47494', 'X');
INSERT INTO `ey_region` VALUES ('47501', '观塘区', '3', '47498', 'G');
INSERT INTO `ey_region` VALUES ('47502', '黄大仙区', '3', '47498', 'H');
INSERT INTO `ey_region` VALUES ('47503', '九龙城区', '3', '47498', 'J');
INSERT INTO `ey_region` VALUES ('47504', '深水埗区', '3', '47498', 'S');
INSERT INTO `ey_region` VALUES ('47505', '油尖旺区', '3', '47498', 'Y');
INSERT INTO `ey_region` VALUES ('47506', '东区', '3', '47499', 'D');
INSERT INTO `ey_region` VALUES ('47507', '南区', '3', '47499', 'N');
INSERT INTO `ey_region` VALUES ('47508', '湾仔', '3', '47499', 'W');
INSERT INTO `ey_region` VALUES ('47509', '中西区', '3', '47499', 'Z');
INSERT INTO `ey_region` VALUES ('47510', '北区', '3', '47500', 'B');
INSERT INTO `ey_region` VALUES ('47511', '大埔区', '3', '47500', 'D');
INSERT INTO `ey_region` VALUES ('47512', '葵青区', '3', '47500', 'K');
INSERT INTO `ey_region` VALUES ('47513', '离岛区', '3', '47500', 'L');
INSERT INTO `ey_region` VALUES ('47514', '荃湾区', '3', '47500', 'Q');
INSERT INTO `ey_region` VALUES ('47515', '沙田区', '3', '47500', 'S');
INSERT INTO `ey_region` VALUES ('47516', '屯门区', '3', '47500', 'T');
INSERT INTO `ey_region` VALUES ('47517', '西贡区', '3', '47500', 'X');
INSERT INTO `ey_region` VALUES ('47518', '元朗区', '3', '47500', 'Y');
INSERT INTO `ey_region` VALUES ('47519', '澳门半岛', '2', '47495', 'A');
INSERT INTO `ey_region` VALUES ('47520', '离岛', '2', '47495', 'L');
INSERT INTO `ey_region` VALUES ('47521', '大堂区', '3', '47519', 'D');
INSERT INTO `ey_region` VALUES ('47522', '风顺堂区', '3', '47519', 'F');
INSERT INTO `ey_region` VALUES ('47523', '花地玛堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47524', '花王堂区', '3', '47519', 'H');
INSERT INTO `ey_region` VALUES ('47525', '望德堂区', '3', '47519', 'W');
INSERT INTO `ey_region` VALUES ('47526', '嘉模堂区', '3', '47520', 'J');
INSERT INTO `ey_region` VALUES ('47527', '路氹填海区', '3', '47520', 'L');
INSERT INTO `ey_region` VALUES ('47528', '圣方济各堂区', '3', '47520', 'S');
INSERT INTO `ey_region` VALUES ('47529', '高雄市', '2', '47493', 'G');
INSERT INTO `ey_region` VALUES ('47530', '花莲县', '2', '47493', 'H');
INSERT INTO `ey_region` VALUES ('47531', '基隆市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47532', '嘉义市', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47533', '嘉义县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47534', '金门县', '2', '47493', 'J');
INSERT INTO `ey_region` VALUES ('47535', '连江县', '2', '47493', 'L');
INSERT INTO `ey_region` VALUES ('47536', '苗栗县', '2', '47493', 'M');
INSERT INTO `ey_region` VALUES ('47537', '南投县', '2', '47493', 'N');
INSERT INTO `ey_region` VALUES ('47538', '澎湖县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47539', '屏东县', '2', '47493', 'P');
INSERT INTO `ey_region` VALUES ('47540', '台北市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47541', '台东县', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47542', '台南市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47543', '台中市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47544', '桃园市', '2', '47493', 'T');
INSERT INTO `ey_region` VALUES ('47545', '新北市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47546', '新竹市', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47547', '新竹县', '2', '47493', 'X');
INSERT INTO `ey_region` VALUES ('47548', '宜兰县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47549', '云林县', '2', '47493', 'Y');
INSERT INTO `ey_region` VALUES ('47550', '彰化县', '2', '47493', 'Z');
INSERT INTO `ey_region` VALUES ('47551', '阿莲区', '3', '47529', 'A');
INSERT INTO `ey_region` VALUES ('47552', '大寮区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47553', '大社区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47554', '大树区', '3', '47529', 'D');
INSERT INTO `ey_region` VALUES ('47555', '凤山区', '3', '47529', 'F');
INSERT INTO `ey_region` VALUES ('47556', '冈山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47557', '鼓山区', '3', '47529', 'G');
INSERT INTO `ey_region` VALUES ('47558', '湖内区', '3', '47529', 'H');
INSERT INTO `ey_region` VALUES ('47559', '甲仙区', '3', '47529', 'J');
INSERT INTO `ey_region` VALUES ('47560', '林园区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47561', '苓雅区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47562', '六龟区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47563', '路竹区', '3', '47529', 'L');
INSERT INTO `ey_region` VALUES ('47564', '茂林区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47565', '美浓区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47566', '弥陀区', '3', '47529', 'M');
INSERT INTO `ey_region` VALUES ('47567', '楠梓区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47568', '那玛夏区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47569', '内门区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47570', '鸟松区', '3', '47529', 'N');
INSERT INTO `ey_region` VALUES ('47571', '旗津区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47572', '旗门区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47573', '其它区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47574', '前金区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47575', '前镇区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47576', '桥头区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47577', '茄萣区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47578', '芩雅区', '3', '47529', 'Q');
INSERT INTO `ey_region` VALUES ('47579', '仁武区', '3', '47529', 'R');
INSERT INTO `ey_region` VALUES ('47580', '三民区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47581', '杉林区', '3', '47529', 'S');
INSERT INTO `ey_region` VALUES ('47582', '桃源区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47583', '田寮区', '3', '47529', 'T');
INSERT INTO `ey_region` VALUES ('47584', '小港区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47585', '新兴区', '3', '47529', 'X');
INSERT INTO `ey_region` VALUES ('47586', '燕巢区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47587', '盐埕区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47588', '永安区', '3', '47529', 'Y');
INSERT INTO `ey_region` VALUES ('47589', '梓官区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47590', '左营区', '3', '47529', 'Z');
INSERT INTO `ey_region` VALUES ('47591', '丰滨乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47592', '凤林镇', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47593', '富里乡', '3', '47530', 'F');
INSERT INTO `ey_region` VALUES ('47594', '光复乡', '3', '47530', 'G');
INSERT INTO `ey_region` VALUES ('47595', '花莲市', '3', '47530', 'H');
INSERT INTO `ey_region` VALUES ('47596', '吉安乡', '3', '47530', 'J');
INSERT INTO `ey_region` VALUES ('47597', '瑞穗乡', '3', '47530', 'R');
INSERT INTO `ey_region` VALUES ('47598', '寿丰乡', '3', '47530', 'S');
INSERT INTO `ey_region` VALUES ('47599', '太鲁阁', '3', '47530', 'T');
INSERT INTO `ey_region` VALUES ('47600', '万荣乡', '3', '47530', 'W');
INSERT INTO `ey_region` VALUES ('47601', '新城乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47602', '秀林乡', '3', '47530', 'X');
INSERT INTO `ey_region` VALUES ('47603', '玉里镇', '3', '47530', 'Y');
INSERT INTO `ey_region` VALUES ('47604', '卓溪乡', '3', '47530', 'Z');
INSERT INTO `ey_region` VALUES ('47605', '安乐区', '3', '47531', 'A');
INSERT INTO `ey_region` VALUES ('47606', '暖暖区', '3', '47531', 'N');
INSERT INTO `ey_region` VALUES ('47607', '七堵区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47608', '其它区', '3', '47531', 'Q');
INSERT INTO `ey_region` VALUES ('47609', '仁爱区', '3', '47531', 'R');
INSERT INTO `ey_region` VALUES ('47610', '信义区', '3', '47531', 'X');
INSERT INTO `ey_region` VALUES ('47611', '中山区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47612', '中正区', '3', '47531', 'Z');
INSERT INTO `ey_region` VALUES ('47613', '东区', '3', '47532', 'D');
INSERT INTO `ey_region` VALUES ('47614', '西区', '3', '47532', 'X');
INSERT INTO `ey_region` VALUES ('47615', '其它区', '3', '47532', 'Q');
INSERT INTO `ey_region` VALUES ('47616', '阿里山乡', '3', '47533', 'A');
INSERT INTO `ey_region` VALUES ('47617', '布袋镇', '3', '47533', 'B');
INSERT INTO `ey_region` VALUES ('47618', '大林镇', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47619', '大埔乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47620', '东石乡', '3', '47533', 'D');
INSERT INTO `ey_region` VALUES ('47621', '番路乡', '3', '47533', 'F');
INSERT INTO `ey_region` VALUES ('47622', '六脚乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47623', '鹿草乡', '3', '47533', 'L');
INSERT INTO `ey_region` VALUES ('47624', '梅山乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47625', '民雄乡', '3', '47533', 'M');
INSERT INTO `ey_region` VALUES ('47626', '朴子市', '3', '47533', 'P');
INSERT INTO `ey_region` VALUES ('47627', '水上乡', '3', '47533', 'S');
INSERT INTO `ey_region` VALUES ('47628', '太保市', '3', '47533', 'T');
INSERT INTO `ey_region` VALUES ('47629', '溪口乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47630', '新港乡', '3', '47533', 'X');
INSERT INTO `ey_region` VALUES ('47631', '义竹乡', '3', '47533', 'Y');
INSERT INTO `ey_region` VALUES ('47632', '中埔乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47633', '竹崎乡', '3', '47533', 'Z');
INSERT INTO `ey_region` VALUES ('47634', '金城镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47635', '金湖镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47636', '金宁乡', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47637', '金沙镇', '3', '47534', 'J');
INSERT INTO `ey_region` VALUES ('47638', '烈屿乡', '3', '47534', 'L');
INSERT INTO `ey_region` VALUES ('47639', '乌邱乡', '3', '47534', 'W');
INSERT INTO `ey_region` VALUES ('47640', '北竿乡', '3', '47535', 'B');
INSERT INTO `ey_region` VALUES ('47641', '东引乡', '3', '47535', 'D');
INSERT INTO `ey_region` VALUES ('47642', '莒光乡', '3', '47535', 'J');
INSERT INTO `ey_region` VALUES ('47643', '南竿乡', '3', '47535', 'N');
INSERT INTO `ey_region` VALUES ('47644', '大湖乡', '3', '47536', 'D');
INSERT INTO `ey_region` VALUES ('47645', '公馆乡', '3', '47536', 'G');
INSERT INTO `ey_region` VALUES ('47646', '后龙镇', '3', '47536', 'H');
INSERT INTO `ey_region` VALUES ('47647', '苗栗市', '3', '47536', 'M');
INSERT INTO `ey_region` VALUES ('47648', '南庄乡', '3', '47536', 'N');
INSERT INTO `ey_region` VALUES ('47649', '三湾乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47650', '三义乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47651', '狮潭乡', '3', '47536', 'S');
INSERT INTO `ey_region` VALUES ('47652', '泰安乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47653', '铜锣乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47654', '通宵镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47655', '头份镇', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47656', '头屋乡', '3', '47536', 'T');
INSERT INTO `ey_region` VALUES ('47657', '西湖乡', '3', '47536', 'X');
INSERT INTO `ey_region` VALUES ('47658', '苑里镇', '3', '47536', 'Y');
INSERT INTO `ey_region` VALUES ('47659', '造桥乡', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47660', '竹南镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47661', '卓兰镇', '3', '47536', 'Z');
INSERT INTO `ey_region` VALUES ('47662', '草屯镇', '3', '47537', 'C');
INSERT INTO `ey_region` VALUES ('47663', '国姓乡', '3', '47537', 'G');
INSERT INTO `ey_region` VALUES ('47664', '集集镇', '3', '47537', 'J');
INSERT INTO `ey_region` VALUES ('47665', '鹿谷乡', '3', '47537', 'L');
INSERT INTO `ey_region` VALUES ('47666', '名间乡', '3', '47537', 'M');
INSERT INTO `ey_region` VALUES ('47667', '南投市', '3', '47537', 'N');
INSERT INTO `ey_region` VALUES ('47668', '埔里镇', '3', '47537', 'P');
INSERT INTO `ey_region` VALUES ('47669', '仁爱乡', '3', '47537', 'R');
INSERT INTO `ey_region` VALUES ('47670', '水里乡', '3', '47537', 'S');
INSERT INTO `ey_region` VALUES ('47671', '信义乡', '3', '47537', 'X');
INSERT INTO `ey_region` VALUES ('47672', '鱼池乡', '3', '47537', 'Y');
INSERT INTO `ey_region` VALUES ('47673', '中寮乡', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47674', '竹山镇', '3', '47537', 'Z');
INSERT INTO `ey_region` VALUES ('47675', '白沙乡', '3', '47538', 'B');
INSERT INTO `ey_region` VALUES ('47676', '湖西乡', '3', '47538', 'H');
INSERT INTO `ey_region` VALUES ('47677', '马公市', '3', '47538', 'M');
INSERT INTO `ey_region` VALUES ('47678', '七美乡', '3', '47538', 'Q');
INSERT INTO `ey_region` VALUES ('47679', '望安乡', '3', '47538', 'W');
INSERT INTO `ey_region` VALUES ('47680', '西屿乡', '3', '47538', 'X');
INSERT INTO `ey_region` VALUES ('47681', '长治乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47682', '潮州镇', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47683', '车城乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47684', '春日乡', '3', '47539', 'C');
INSERT INTO `ey_region` VALUES ('47685', '东港镇', '3', '47539', 'D');
INSERT INTO `ey_region` VALUES ('47686', '枋寮乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47687', '枋山乡', '3', '47539', 'F');
INSERT INTO `ey_region` VALUES ('47688', '高树乡', '3', '47539', 'G');
INSERT INTO `ey_region` VALUES ('47689', '恒春镇', '3', '47539', 'H');
INSERT INTO `ey_region` VALUES ('47690', '佳冬乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47691', '九如乡', '3', '47539', 'J');
INSERT INTO `ey_region` VALUES ('47692', '崁顶乡', '3', '47539', 'K');
INSERT INTO `ey_region` VALUES ('47693', '来义乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47694', '里港乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47695', '林边乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47696', '麟洛乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47697', '琉球乡', '3', '47539', 'L');
INSERT INTO `ey_region` VALUES ('47698', '玛家乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47699', '满州乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47700', '牡丹乡', '3', '47539', 'M');
INSERT INTO `ey_region` VALUES ('47701', '南州乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47702', '内埔乡', '3', '47539', 'N');
INSERT INTO `ey_region` VALUES ('47703', '屏东市', '3', '47539', 'P');
INSERT INTO `ey_region` VALUES ('47704', '三地门乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47705', '狮子乡', '3', '47539', 'S');
INSERT INTO `ey_region` VALUES ('47706', '泰武乡', '3', '47539', 'T');
INSERT INTO `ey_region` VALUES ('47707', '万丹乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47708', '万峦乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47709', '雾台乡', '3', '47539', 'W');
INSERT INTO `ey_region` VALUES ('47710', '新埤乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47711', '新园乡', '3', '47539', 'X');
INSERT INTO `ey_region` VALUES ('47712', '盐埔乡', '3', '47539', 'Y');
INSERT INTO `ey_region` VALUES ('47713', '竹田乡', '3', '47539', 'Z');
INSERT INTO `ey_region` VALUES ('47714', '北投区', '3', '47540', 'B');
INSERT INTO `ey_region` VALUES ('47715', '大安区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47716', '大同区', '3', '47540', 'D');
INSERT INTO `ey_region` VALUES ('47717', '南港区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47718', '内湖区', '3', '47540', 'N');
INSERT INTO `ey_region` VALUES ('47719', '士林区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47720', '松山区', '3', '47540', 'S');
INSERT INTO `ey_region` VALUES ('47721', '万华区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47722', '文山区', '3', '47540', 'W');
INSERT INTO `ey_region` VALUES ('47723', '信义区', '3', '47540', 'X');
INSERT INTO `ey_region` VALUES ('47724', '中山区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47725', '中正区', '3', '47540', 'Z');
INSERT INTO `ey_region` VALUES ('47726', '其它区', '3', '47540', 'Q');
INSERT INTO `ey_region` VALUES ('47727', '卑南乡', '3', '47541', 'B');
INSERT INTO `ey_region` VALUES ('47728', '长滨乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47729', '成功镇', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47730', '池上乡', '3', '47541', 'C');
INSERT INTO `ey_region` VALUES ('47731', '达仁乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47732', '大武乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47733', '东河乡', '3', '47541', 'D');
INSERT INTO `ey_region` VALUES ('47734', '关山镇', '3', '47541', 'G');
INSERT INTO `ey_region` VALUES ('47735', '海端乡', '3', '47541', 'H');
INSERT INTO `ey_region` VALUES ('47736', '金峰乡', '3', '47541', 'J');
INSERT INTO `ey_region` VALUES ('47737', '兰屿乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47738', '鹿野乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47739', '绿岛乡', '3', '47541', 'L');
INSERT INTO `ey_region` VALUES ('47740', '台东市', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47741', '太麻里乡', '3', '47541', 'T');
INSERT INTO `ey_region` VALUES ('47742', '延平乡', '3', '47541', 'Y');
INSERT INTO `ey_region` VALUES ('47743', '中西区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47744', '东区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47745', '南区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47746', '北区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47747', '安平区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47748', '安南区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47749', '其它区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47750', '永康区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47751', '归仁区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47752', '新化区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47753', '左镇区', '3', '47542', 'Z');
INSERT INTO `ey_region` VALUES ('47754', '玉井区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47755', '楠西区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47756', '南化区', '3', '47542', 'N');
INSERT INTO `ey_region` VALUES ('47757', '仁德区', '3', '47542', 'R');
INSERT INTO `ey_region` VALUES ('47758', '关庙区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47759', '龙崎区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47760', '官田区', '3', '47542', 'G');
INSERT INTO `ey_region` VALUES ('47761', '麻豆区', '3', '47542', 'M');
INSERT INTO `ey_region` VALUES ('47762', '佳里区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47763', '西港区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47764', '七股区', '3', '47542', 'Q');
INSERT INTO `ey_region` VALUES ('47765', '将军区', '3', '47542', 'J');
INSERT INTO `ey_region` VALUES ('47766', '学甲区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47767', '北门区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47768', '新营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47769', '后壁区', '3', '47542', 'H');
INSERT INTO `ey_region` VALUES ('47770', '白河区', '3', '47542', 'B');
INSERT INTO `ey_region` VALUES ('47771', '东山区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47772', '六甲区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47773', '下营区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47774', '柳营区', '3', '47542', 'L');
INSERT INTO `ey_region` VALUES ('47775', '盐水区', '3', '47542', 'Y');
INSERT INTO `ey_region` VALUES ('47776', '善化区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47777', '大内区', '3', '47542', 'D');
INSERT INTO `ey_region` VALUES ('47778', '山上区', '3', '47542', 'S');
INSERT INTO `ey_region` VALUES ('47779', '新市区', '3', '47542', 'X');
INSERT INTO `ey_region` VALUES ('47780', '安定区', '3', '47542', 'A');
INSERT INTO `ey_region` VALUES ('47781', '中区', '3', '47543', 'Z');
INSERT INTO `ey_region` VALUES ('47782', '东区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47783', '南区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47784', '西区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47785', '北区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47786', '北屯区', '3', '47543', 'B');
INSERT INTO `ey_region` VALUES ('47787', '西屯区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47788', '南屯区', '3', '47543', 'N');
INSERT INTO `ey_region` VALUES ('47789', '其它区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47790', '太平区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47791', '大里区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47792', '雾峰区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47793', '乌日区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47794', '丰原区', '3', '47543', 'F');
INSERT INTO `ey_region` VALUES ('47795', '后里区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47796', '石冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47797', '东势区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47798', '和平区', '3', '47543', 'H');
INSERT INTO `ey_region` VALUES ('47799', '新社区', '3', '47543', 'X');
INSERT INTO `ey_region` VALUES ('47800', '潭子区', '3', '47543', 'T');
INSERT INTO `ey_region` VALUES ('47801', '大雅区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47802', '神冈区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47803', '大肚区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47804', '沙鹿区', '3', '47543', 'S');
INSERT INTO `ey_region` VALUES ('47805', '龙井区', '3', '47543', 'L');
INSERT INTO `ey_region` VALUES ('47806', '梧栖区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47807', '清水区', '3', '47543', 'Q');
INSERT INTO `ey_region` VALUES ('47808', '大甲区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47809', '外埔区', '3', '47543', 'W');
INSERT INTO `ey_region` VALUES ('47810', '大安区', '3', '47543', 'D');
INSERT INTO `ey_region` VALUES ('47811', '中坜区', '3', '47544', 'Z');
INSERT INTO `ey_region` VALUES ('47812', '平镇区', '3', '47544', 'P');
INSERT INTO `ey_region` VALUES ('47813', '龙潭区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47814', '杨梅区', '3', '47544', 'Y');
INSERT INTO `ey_region` VALUES ('47815', '新屋区', '3', '47544', 'X');
INSERT INTO `ey_region` VALUES ('47816', '观音区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47817', '桃园区', '3', '47544', 'T');
INSERT INTO `ey_region` VALUES ('47818', '龟山区', '3', '47544', 'G');
INSERT INTO `ey_region` VALUES ('47819', '八德区', '3', '47544', 'B');
INSERT INTO `ey_region` VALUES ('47820', '大溪区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47821', '复兴区', '3', '47544', 'F');
INSERT INTO `ey_region` VALUES ('47822', '大园区', '3', '47544', 'D');
INSERT INTO `ey_region` VALUES ('47823', '芦竹区', '3', '47544', 'L');
INSERT INTO `ey_region` VALUES ('47824', '万里区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47825', '金山区', '3', '47545', 'J');
INSERT INTO `ey_region` VALUES ('47826', '板桥区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47827', '汐止区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47828', '深坑区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47829', '石碇区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47830', '瑞芳区', '3', '47545', 'R');
INSERT INTO `ey_region` VALUES ('47831', '平溪区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47832', '双溪区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47833', '贡寮区', '3', '47545', 'G');
INSERT INTO `ey_region` VALUES ('47834', '新店区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47835', '坪林区', '3', '47545', 'P');
INSERT INTO `ey_region` VALUES ('47836', '乌来区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47837', '永和区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47838', '中和区', '3', '47545', 'Z');
INSERT INTO `ey_region` VALUES ('47839', '土城区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47840', '三峡区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47841', '树林区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47842', '莺歌区', '3', '47545', 'Y');
INSERT INTO `ey_region` VALUES ('47843', '三重区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47844', '新庄区', '3', '47545', 'X');
INSERT INTO `ey_region` VALUES ('47845', '泰山区', '3', '47545', 'T');
INSERT INTO `ey_region` VALUES ('47846', '林口区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47847', '芦洲区', '3', '47545', 'L');
INSERT INTO `ey_region` VALUES ('47848', '五股区', '3', '47545', 'W');
INSERT INTO `ey_region` VALUES ('47849', '八里区', '3', '47545', 'B');
INSERT INTO `ey_region` VALUES ('47850', '淡水区', '3', '47545', 'D');
INSERT INTO `ey_region` VALUES ('47851', '三芝区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47852', '石门区', '3', '47545', 'S');
INSERT INTO `ey_region` VALUES ('47853', '东区', '3', '47546', 'D');
INSERT INTO `ey_region` VALUES ('47854', '北区', '3', '47546', 'B');
INSERT INTO `ey_region` VALUES ('47855', '香山区', '3', '47546', 'X');
INSERT INTO `ey_region` VALUES ('47856', '其它区', '3', '47546', 'Q');
INSERT INTO `ey_region` VALUES ('47857', '竹北市', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47858', '湖口乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47859', '新丰乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47860', '新埔镇', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47861', '关西镇', '3', '47547', 'G');
INSERT INTO `ey_region` VALUES ('47862', '芎林乡', '3', '47547', 'X');
INSERT INTO `ey_region` VALUES ('47863', '宝山乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47864', '竹东镇', '3', '47547', 'Z');
INSERT INTO `ey_region` VALUES ('47865', '五峰乡', '3', '47547', 'W');
INSERT INTO `ey_region` VALUES ('47866', '横山乡', '3', '47547', 'H');
INSERT INTO `ey_region` VALUES ('47867', '尖石乡', '3', '47547', 'J');
INSERT INTO `ey_region` VALUES ('47868', '北埔乡', '3', '47547', 'B');
INSERT INTO `ey_region` VALUES ('47869', '峨眉乡', '3', '47547', 'E');
INSERT INTO `ey_region` VALUES ('47870', '宜兰市', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47871', '头城镇', '3', '47548', 'T');
INSERT INTO `ey_region` VALUES ('47872', '礁溪乡', '3', '47548', 'J');
INSERT INTO `ey_region` VALUES ('47873', '壮围乡', '3', '47548', 'Z');
INSERT INTO `ey_region` VALUES ('47874', '员山乡', '3', '47548', 'Y');
INSERT INTO `ey_region` VALUES ('47875', '罗东镇', '3', '47548', 'L');
INSERT INTO `ey_region` VALUES ('47876', '三星乡', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47877', '大同乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47878', '五结乡', '3', '47548', 'W');
INSERT INTO `ey_region` VALUES ('47879', '冬山乡', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47880', '苏澳镇', '3', '47548', 'S');
INSERT INTO `ey_region` VALUES ('47881', '南澳乡', '3', '47548', 'N');
INSERT INTO `ey_region` VALUES ('47882', '钓鱼台', '3', '47548', 'D');
INSERT INTO `ey_region` VALUES ('47883', '斗南镇', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47884', '大埤乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47885', '虎尾镇', '3', '47549', 'H');
INSERT INTO `ey_region` VALUES ('47886', '土库镇', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47887', '褒忠乡', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47888', '东势乡', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47889', '台西乡', '3', '47549', 'T');
INSERT INTO `ey_region` VALUES ('47890', '仑背乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47891', '麦寮乡', '3', '47549', 'M');
INSERT INTO `ey_region` VALUES ('47892', '斗六市', '3', '47549', 'D');
INSERT INTO `ey_region` VALUES ('47893', '林内乡', '3', '47549', 'L');
INSERT INTO `ey_region` VALUES ('47894', '古坑乡', '3', '47549', 'G');
INSERT INTO `ey_region` VALUES ('47895', '莿桐乡', '3', '47549', 'C');
INSERT INTO `ey_region` VALUES ('47896', '西螺镇', '3', '47549', 'X');
INSERT INTO `ey_region` VALUES ('47897', '二仑乡', '3', '47549', 'E');
INSERT INTO `ey_region` VALUES ('47898', '北港镇', '3', '47549', 'B');
INSERT INTO `ey_region` VALUES ('47899', '水林乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47900', '口湖乡', '3', '47549', 'K');
INSERT INTO `ey_region` VALUES ('47901', '四湖乡', '3', '47549', 'S');
INSERT INTO `ey_region` VALUES ('47902', '元长乡', '3', '47549', 'Y');
INSERT INTO `ey_region` VALUES ('47903', '彰化市', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47904', '芬园乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47905', '花坛乡', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47906', '秀水乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47907', '鹿港镇', '3', '47550', 'L');
INSERT INTO `ey_region` VALUES ('47908', '福兴乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47909', '线西乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47910', '和美镇', '3', '47550', 'H');
INSERT INTO `ey_region` VALUES ('47911', '伸港乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47912', '员林镇', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47913', '社头乡', '3', '47550', 'S');
INSERT INTO `ey_region` VALUES ('47914', '永靖乡', '3', '47550', 'Y');
INSERT INTO `ey_region` VALUES ('47915', '埔心乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47916', '溪湖镇', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47917', '大村乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47918', '埔盐乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47919', '田中镇', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47920', '北斗镇', '3', '47550', 'B');
INSERT INTO `ey_region` VALUES ('47921', '田尾乡', '3', '47550', 'T');
INSERT INTO `ey_region` VALUES ('47922', '埤头乡', '3', '47550', 'P');
INSERT INTO `ey_region` VALUES ('47923', '溪州乡', '3', '47550', 'X');
INSERT INTO `ey_region` VALUES ('47924', '竹塘乡', '3', '47550', 'Z');
INSERT INTO `ey_region` VALUES ('47925', '二林镇', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47926', '大城乡', '3', '47550', 'D');
INSERT INTO `ey_region` VALUES ('47927', '芳苑乡', '3', '47550', 'F');
INSERT INTO `ey_region` VALUES ('47928', '二水乡', '3', '47550', 'E');
INSERT INTO `ey_region` VALUES ('47929', '莲池区', '3', '1772', 'L');
INSERT INTO `ey_region` VALUES ('47930', '竞秀区', '3', '1772', 'J');
INSERT INTO `ey_region` VALUES ('47931', '常平镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47932', '茶山镇', '3', '29855', 'C');
INSERT INTO `ey_region` VALUES ('47933', '大朗镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47934', '大岭山镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47935', '道滘镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47936', '东城街道', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47937', '东坑镇', '3', '29855', 'D');
INSERT INTO `ey_region` VALUES ('47938', '凤岗镇', '3', '29855', 'F');
INSERT INTO `ey_region` VALUES ('47939', '高埗镇', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47940', '莞城街道', '3', '29855', 'G');
INSERT INTO `ey_region` VALUES ('47941', '横沥镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47942', '洪梅镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47943', '厚街镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47944', '黄江镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47945', '虎门镇', '3', '29855', 'H');
INSERT INTO `ey_region` VALUES ('47946', '寮步镇', '3', '29855', 'L');
INSERT INTO `ey_region` VALUES ('47947', '麻涌镇', '3', '29855', 'M');
INSERT INTO `ey_region` VALUES ('47948', '南城街道', '3', '29855', 'N');
INSERT INTO `ey_region` VALUES ('47949', '桥头镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47950', '清溪镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47951', '企石镇', '3', '29855', 'Q');
INSERT INTO `ey_region` VALUES ('47952', '沙田镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47953', '石碣镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47954', '石龙镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47955', '石排镇', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47956', '松山湖管委会', '3', '29855', 'S');
INSERT INTO `ey_region` VALUES ('47957', '塘厦镇', '3', '29855', 'T');
INSERT INTO `ey_region` VALUES ('47958', '望牛墩镇', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47959', '万江街道', '3', '29855', 'W');
INSERT INTO `ey_region` VALUES ('47960', '谢岗镇', '3', '29855', 'X');
INSERT INTO `ey_region` VALUES ('47961', '长安镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47962', '樟木头镇', '3', '29855', 'Z');
INSERT INTO `ey_region` VALUES ('47963', '中堂镇', '3', '29855', 'Z');

-- -----------------------------
-- Table structure for `ey_search_word`
-- -----------------------------
DROP TABLE IF EXISTS `ey_search_word`;
CREATE TABLE `ey_search_word` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(255) DEFAULT '' COMMENT '关键词',
  `searchNum` int(10) DEFAULT '1' COMMENT '搜索次数',
  `resultNum` int(10) DEFAULT '0' COMMENT '搜索结果数量',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `word` (`word`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='搜索词统计表';

-- -----------------------------
-- Records of `ey_search_word`
-- -----------------------------
INSERT INTO `ey_search_word` VALUES ('1', '钓具', '7', '0', '100', 'cn', '1599188959', '1599207400');

-- -----------------------------
-- Table structure for `ey_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_setting`;
CREATE TABLE `ey_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `inc_type` (`inc_type`,`lang`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COMMENT='系统非全局配置表';

-- -----------------------------
-- Records of `ey_setting`
-- -----------------------------
INSERT INTO `ey_setting` VALUES ('1', 'ask_ques_steps', '1、写问题标题，描述具体现象。杜绝 “求救，大佬，小白…” 等和问题无关的词汇。\r\n2、选择问题的分类，选择正确的内容分类，能更快的得到其他人的回复。\r\n3、遇到的问题比较急需解决，可以给问题悬赏一定的金额报酬，能让更多同行参与进来出谋策划，从中选择自己心仪的答案。\r\n4、写问题内容详细描述你碰到的困难，写清楚你尝试了什么方法，错误代码，软件的版本等，更容易得到答案。\r\n5、点击发布。', 'ask', 'cn', '1638408557');
INSERT INTO `ey_setting` VALUES ('2', 'system_old_product_attr', '0', 'system', 'cn', '1638408557');
INSERT INTO `ey_setting` VALUES ('3', 'syn_admin_logic_1623377269', '1', 'syn', 'cn', '1638408557');
INSERT INTO `ey_setting` VALUES ('4', 'syn_admin_logic_1625725290', '1', 'syn', 'cn', '1638408557');
INSERT INTO `ey_setting` VALUES ('5', 'syn_admin_logic_1629252424', '1', 'syn', 'cn', '1638408557');
INSERT INTO `ey_setting` VALUES ('6', 'admin_logic_1634204189', '1', 'syn', 'cn', '1638408558');
INSERT INTO `ey_setting` VALUES ('7', 'admin_logic_1634280892', '1', 'syn', 'cn', '1638408558');
INSERT INTO `ey_setting` VALUES ('8', 'admin_logic_1635326854', '1', 'syn', 'cn', '1638408558');
INSERT INTO `ey_setting` VALUES ('9', 'admin_logic_1635389623', '1', 'syn', 'cn', '1638408558');
INSERT INTO `ey_setting` VALUES ('10', 'recycle_switch', '0', 'recycle', 'cn', '1650869769');
INSERT INTO `ey_setting` VALUES ('11', 'adminlogin_427d1aac31a93d744edd637f1fbbf00c', '0', 'adminlogin', 'cn', '1668570337');
INSERT INTO `ey_setting` VALUES ('12', 'adminlogin_a62896d354440964bb1db242596917b1', '0', 'adminlogin', 'cn', '1668570337');
INSERT INTO `ey_setting` VALUES ('13', 'adminlogin_99ae1cc546e0ed202a83693c75f1afe0', '0', 'adminlogin', 'cn', '1668570337');
INSERT INTO `ey_setting` VALUES ('14', 'admin_logic_1649299958', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('15', 'admin_logic_1636875693', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('16', 'admin_logic_1637033990', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('17', 'admin_logic_1640918327', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('18', 'admin_logic_1638857408', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('19', 'admin_logic_1643352860', '2', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('20', 'admin_logic_1643352862', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('21', 'admin_logic_1643352863', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('22', 'security_askanswer_list', '[\"\\u60a8\\u5e38\\u7528\\u7684\\u624b\\u673a\\u53f7\\u7801\\u662f\\uff1f\",\"\\u60a8\\u5e38\\u7528\\u7684\\u7535\\u5b50\\u90ae\\u7bb1\\u662f\\uff1f\",\"\\u60a8\\u771f\\u5b9e\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u5b66\\u6821\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u51fa\\u751f\\u5730\\u540d\\u662f\\uff1f\",\"\\u60a8\\u914d\\u5076\\u7684\\u59d3\\u540d\\u662f\\uff1f\",\"\\u60a8\\u7684\\u8eab\\u4efd\\u8bc1\\u53f7\\u540e\\u516b\\u4f4d\\u662f\\uff1f\",\"\\u60a8\\u9ad8\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u521d\\u4e2d\\u73ed\\u4e3b\\u4efb\\u7684\\u540d\\u5b57\\u662f\\uff1f\",\"\\u60a8\\u6700\\u559c\\u6b22\\u7684\\u660e\\u661f\\u540d\\u5b57\\u662f\\uff1f\",\"\\u5bf9\\u60a8\\u5f71\\u54cd\\u6700\\u5927\\u7684\\u4eba\\u540d\\u5b57\\u662f\\uff1f\"]', 'security', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('23', 'admin_logic_1643352864', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('24', 'admin_logic_1647918733', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('25', 'system_originlist', '[\"\\u7f51\\u7edc\"]', 'system', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('26', 'admin_logic_1648435161', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('27', 'admin_logic_1648882158', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('28', 'admin_logic_1649399344', '1', 'syn', 'cn', '1668570338');
INSERT INTO `ey_setting` VALUES ('29', 'syn_admin_logic_1616123194', '1', 'syn', 'cn', '1668570338');

-- -----------------------------
-- Table structure for `ey_sharp_active`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active`;
CREATE TABLE `ey_sharp_active` (
  `active_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '活动会场ID',
  `active_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动日期',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场表';


-- -----------------------------
-- Table structure for `ey_sharp_active_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_goods`;
CREATE TABLE `ey_sharp_active_goods` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动场次ID',
  `aid` int(11) NOT NULL DEFAULT '0' COMMENT '文档id',
  `sharp_goods_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品ID',
  `sales_actual` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '实际销量',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场与商品关联表';


-- -----------------------------
-- Table structure for `ey_sharp_active_time`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_active_time`;
CREATE TABLE `ey_sharp_active_time` (
  `active_time_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '场次ID',
  `active_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '活动会场ID',
  `active_time` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '场次时间(0点-23点)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '活动状态(0禁用 1启用)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`active_time_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-活动会场场次表';


-- -----------------------------
-- Table structure for `ey_sharp_goods`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_goods`;
CREATE TABLE `ey_sharp_goods` (
  `sharp_goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '秒杀商品ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID->aid',
  `limit` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '限购数量',
  `seckill_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '秒杀商品库存总量',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '秒杀价格',
  `sales` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '累积销量',
  `virtual_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '商品排序(数字越小越靠前)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '商品状态(0下架 1上架)',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_sku` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1-多规格商品',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`sharp_goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀-商品表';


-- -----------------------------
-- Table structure for `ey_sharp_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sharp_setting`;
CREATE TABLE `ey_sharp_setting` (
  `key` varchar(30) NOT NULL DEFAULT '' COMMENT '设置项标示',
  `describe` varchar(255) NOT NULL DEFAULT '' COMMENT '设置项描述',
  `values` mediumtext NOT NULL COMMENT '设置内容(json格式)',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  UNIQUE KEY `unique_key` (`key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='整点秒杀设置表';


-- -----------------------------
-- Table structure for `ey_shop_address`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_address`;
CREATE TABLE `ey_shop_address` (
  `addr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '地址id',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL DEFAULT '' COMMENT '收货人',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '详细地址',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '邮政编码',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `is_default` tinyint(1) DEFAULT '0' COMMENT '是否默认，0否，1是。',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`addr_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='收货地址表';


-- -----------------------------
-- Table structure for `ey_shop_cart`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_cart`;
CREATE TABLE `ey_shop_cart` (
  `cart_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '购物车表',
  `users_id` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned DEFAULT '0' COMMENT '产品id',
  `product_num` int(10) unsigned DEFAULT '0' COMMENT '购买数量',
  `spec_value_id` varchar(100) DEFAULT '' COMMENT '规格值ID',
  `selected` tinyint(1) DEFAULT '1' COMMENT '购物车选中状态：0未选中，1选中',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '加入购物车的时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `discount_active_id` int(11) DEFAULT '0' COMMENT '限时折扣ID,用来区分购物车的商品哪些是限时折扣活动的',
  PRIMARY KEY (`cart_id`),
  KEY `users_id` (`users_id`,`product_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车表';


-- -----------------------------
-- Table structure for `ey_shop_coupon`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon`;
CREATE TABLE `ey_shop_coupon` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `coupon_name` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券名称',
  `coupon_color` varchar(25) NOT NULL DEFAULT '' COMMENT '优惠券颜色',
  `coupon_form` tinyint(1) NOT NULL DEFAULT '1' COMMENT '优惠券类型 1-满减券',
  `coupon_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '可使用商品(1全站通用，2指定商品，3指定商品分类)',
  `product_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品ID，在coupon_type=2时使用',
  `arctype_id` varchar(255) NOT NULL DEFAULT '' COMMENT '指定商品分类ID，在coupon_type=3时使用',
  `coupon_price` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券金额，例如10',
  `conditions_use` decimal(10,0) NOT NULL DEFAULT '0' COMMENT '优惠券使用条件，例如300',
  `coupon_stock` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券库存，例如100',
  `redeem_points` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '兑换优惠券所需积分，为0则表示免费兑换',
  `redeem_authority` varchar(10) NOT NULL DEFAULT '' COMMENT '兑换权限，存入多个会员等级组ID',
  `valid_days` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '有效天数，例如30',
  `start_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券开放领取时间',
  `end_date` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券结束领取时间',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '规格排序号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券状态(0=关闭，1=开启)',
  `use_type` int(1) NOT NULL DEFAULT '1' COMMENT '使用期限 \r\n1-固定日期\r\n 2-领取后当天开始N(valid_days)天内有效\r\n 2-领取后次日开始N(valid_days)天内有效',
  `use_start_time` int(11) NOT NULL COMMENT '使用期限开始时间',
  `use_end_time` int(11) NOT NULL COMMENT '使用期限结束时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '0-未删除 1-已删除',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`coupon_id`),
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `arctype_id` (`arctype_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券主表';


-- -----------------------------
-- Table structure for `ey_shop_coupon_use`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_coupon_use`;
CREATE TABLE `ey_shop_coupon_use` (
  `use_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券ID',
  `coupon_code` varchar(100) NOT NULL DEFAULT '' COMMENT '优惠券编号',
  `get_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '领取时的IP地址',
  `get_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券领取时的时间',
  `use_status` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '优惠券使用状态(0未使用，1已使用，2已过期，3已冻结)',
  `use_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券使用时的时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '优惠券有效结束时间',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`use_id`),
  KEY `coupon_id` (`coupon_id`) USING BTREE,
  KEY `coupon_code` (`coupon_code`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='优惠券-领取记录表';


-- -----------------------------
-- Table structure for `ey_shop_express`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_express`;
CREATE TABLE `ey_shop_express` (
  `express_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `express_code` varchar(32) NOT NULL DEFAULT '' COMMENT '物流code',
  `express_name` varchar(32) NOT NULL DEFAULT '' COMMENT '物流名称',
  `express_lnitials` varchar(5) NOT NULL DEFAULT '' COMMENT '首字母',
  `is_choose` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '快递公司是否选中(0=否，1=是)',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`express_id`)
) ENGINE=MyISAM AUTO_INCREMENT=599 DEFAULT CHARSET=utf8 COMMENT='快递公司表';

-- -----------------------------
-- Records of `ey_shop_express`
-- -----------------------------
INSERT INTO `ey_shop_express` VALUES ('1', 'yuantong', '圆通快递', 'Y', '1', '97', '1553911076', '1554974797');
INSERT INTO `ey_shop_express` VALUES ('2', 'shentong', '申通快递', 'S', '1', '98', '1553911076', '1554974707');
INSERT INTO `ey_shop_express` VALUES ('3', 'shunfeng', '顺丰快递', 'S', '1', '98', '1553911076', '1554974710');
INSERT INTO `ey_shop_express` VALUES ('4', 'yunda', '韵达快递', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('5', 'debangwuliu', '德邦快递', 'D', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('6', 'zhongtong', '中通快递', 'Z', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('7', 'huitongkuaidi', '百世快递', 'B', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('8', 'youzhengguonei', '邮政包裹', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('9', 'ems', 'EMS', 'E', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('10', 'youzhengguoji', '邮政国际', 'Y', '1', '99', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('11', 'aolau', 'AOL澳通速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('12', 'a2u', 'A2U速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('13', 'aae', 'AAE快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('14', 'annengwuliu', '安能物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('15', 'anxl', '安迅物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('16', 'auexpress', '澳邮中国快运', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('17', 'exfresh', '安鲜达', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('18', 'anjie88', '安捷物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('19', 'adodoxm', '澳多多国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('20', 'ariesfar', '艾瑞斯远', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('21', 'qdants', 'ANTS EXPRESS', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('22', 'astexpress', '安世通快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('23', 'gda', '安的快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('24', 'ausexpress', '澳世速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('25', 'ibuy8', '爱拜物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('26', 'aplusex', 'Aplus物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('27', 'adapost', '安达速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('28', 'adiexpress', '安达易国际速递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('29', 'maxeedexpress', '澳洲迈速快递', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('30', 'onway', '昂威物流', 'A', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('31', 'bcwelt', 'BCWELT', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('32', 'balunzhi', '巴伦支快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('33', 'xiaohongmao', '北青小红帽', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('34', 'bfdf', '百福东方物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('35', 'bangsongwuliu', '邦送物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('36', 'lbbk', '宝凯物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('37', 'bqcwl', '百千诚物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('38', 'idada', '百成大达物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('39', 'baishiwuliu', '百世快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('40', 'baitengwuliu', '百腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('41', 'birdex', '笨鸟海淘', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('42', 'bsht', '百事亨通', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('43', 'benteng', '奔腾物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('44', 'cuckooexpess', '布谷鸟速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('45', 'bgky100', '邦工快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('46', 'bosind', '堡昕德速递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('47', 'banma', '斑马物联网', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('48', 'polarisexpress', '北极星快运', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('49', 'beijingfengyue', '北京丰越供应链', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('50', 'europe8', '败欧洲', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('51', 'bmlchina', '标杆物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('52', 'comexpress', '邦通国际', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('53', 'baotongkd', '宝通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('54', 'beckygo', '佰麒快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('55', 'boyol', '贝业物流', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('56', 'bdatong', '八达通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('57', 'bangbangpost', '帮帮发', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('58', 'baoxianda', '报通快递', 'B', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('59', 'coe', '中国东方(COE)', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('60', 'cloudexpress', 'CE易欧通国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('61', 'city100', '城市100', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('62', 'chuanxiwuliu', '传喜物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('63', 'chengjisudi', '城际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('64', 'lijisong', '立即送', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('65', 'chukou1', '出口易', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('66', 'nanjingshengbang', '晟邦物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('67', 'flyway', '程光快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('68', 'cbo56', '钏博物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('69', 'cex', '城铁速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('70', 'cnup', 'CNUP 中联邮', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('71', 'clsp', 'CL日中速运', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('72', 'cnair', 'CNAIR', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('73', 'cangspeed', '仓鼠快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('74', 'spring56', '春风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('75', 'cunto', '村通快递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('76', 'longvast', '长风物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('77', 'changjiang', '长江国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('78', 'cncexp', 'C&C国际速递', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('79', 'parcelchina', '诚一物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('80', 'chengtong', '城通物流', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('81', 'otpexpress', '承诺达', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('82', 'sfpost', '曹操到', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('83', 'changwooair', '昌宇国际', 'C', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('84', 'dhl', 'DHL快递（中国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('85', 'dhlen', 'DHL（国际件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('86', 'dhlde', 'DHL（德国件）', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('87', 'dtwl', '大田物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('88', 'disifang', '递四方', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('89', 'dayangwuliu', '大洋物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('90', 'dechuangwuliu', '德创物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('91', 'dskd', 'D速物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('92', 'donghanwl', '东瀚物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('93', 'dfpost', '达方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('94', 'dongjun', '东骏快捷物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('95', 'dindon', '叮咚澳洲转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('96', 'dazhong', '大众佐川急便', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('97', 'ahdf', '德方物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('98', 'dehaoyi', '德豪驿', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('99', 'dhlpaket', 'DHL Paket', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('100', 'ubuy', '德国优拜物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('101', 'adlerlogi', '德国雄鹰速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('102', 'yunexpress', '德国云快递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('103', 'di5pll', '递五方云仓', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('104', 'deguo8elog', '德国八易转运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('105', 'camekong', '到了港', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('106', 'dbstation', 'db-station', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('107', 'dadaoex', '大道物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('108', 'dekuncn', '德坤物流', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('109', 'twkd56', '缔惠盛合', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('110', 'gslexpress', '德尚国际速递', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('111', 'eucpost', '德国 EUC POST', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('112', 'est365', '东方汇', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('113', 'ecotransite', '东西E全运', 'D', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('114', 'euexpress', 'EU-EXPRESS', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('115', 'emsguoji', 'EMS国际快递查询', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('116', 'eshunda', '俄顺达', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('117', 'ewe', 'EWE全球快递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('118', 'easyexpress', 'EASYEXPRESS国际速递', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('119', 'edtexpress', 'e直运', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('120', 'ecallturn', 'E跨通', 'E', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('121', 'fedex', 'FedEx快递查询', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('122', 'fedexus', 'FedEx（美国）', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('123', 'fox', 'FOX国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('124', 'rufengda', '如风达快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('125', 'fkd', '飞康达物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('126', 'feibaokuaidi', '飞豹快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('127', 'fandaguoji', '颿达国际', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('128', 'feiyuanvipshop', '飞远配送', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('129', 'hnfy', '飞鹰物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('130', 'fengxingtianxia', '风行天下', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('131', 'flysman', '飞力士物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('132', 'fbkd', '飞邦快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('133', 'sccod', '丰程物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('134', 'crazyexpress', '疯狂快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('135', 'ftlexpress', '法翔速运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('136', 'ftd', '富腾达快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('137', 'arkexpress', '方舟国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('138', 'fedroad', 'FedRoad 联邦转运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('139', 'freakyquick', 'FQ狂派速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('140', 'fecobv', '丰客物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('141', 'fyex', '飞云快递系统', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('142', 'beebird', '锋鸟物流', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('143', 'shipgce', '飞洋快递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('144', 'koali', '番薯国际货运', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('145', 'epanex', '泛捷国际速递', 'F', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('146', 'gaticn', 'GATI快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('147', 'gts', 'GTS快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('148', 'guotongkuaidi', '国通快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('149', 'ndkd', '能达速递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('150', 'gongsuda', '共速达', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('151', 'gtongsudi', '广通速递（山东）', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('152', 'suteng', '速腾物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('153', 'gdkd', '港快速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('154', 'hre', '高铁速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('155', 'gscq365', '哥士传奇速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('156', 'gjwl', '冠捷物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('157', 'xdshipping', '国晶物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('158', 'ge2d', 'GE2D跨境物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('159', 'gaotieex', '高铁快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('160', 'gansuandi', '甘肃安的快递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('161', 'gdct56', '广东诚通物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('162', 'ghtexpress', 'GHT物流', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('163', 'goldjet', '高捷快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('164', 'gtgogo', 'GT国际快运', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('165', 'gxwl', '光线速递', 'G', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('166', 'tdhy', '华宇物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('167', 'hl', '恒路物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('168', 'hlyex', '好来运快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('169', 'hebeijianhua', '河北建华', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('170', 'huaqikuaiyun', '华企快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('171', 'haosheng', '昊盛物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('172', 'hutongwuliu', '户通物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('173', 'hzpl', '华航快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('174', 'huangmajia', '黄马甲快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('175', 'ucs', '合众速递（UCS）', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('176', 'pfcexpress', '皇家物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('177', 'huoban', '伙伴物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('178', 'nedahm', '红马速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('179', 'huiwen', '汇文配送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('180', 'nmhuahe', '华赫物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('181', 'hjs', '猴急送', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('182', 'hangyu', '航宇快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('183', 'huilian', '辉联物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('184', 'huanqiu', '环球速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('185', 'htwd', '华通务达物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('186', 'hipito', '海派通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('187', 'hqtd', '环球通达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('188', 'airgtc', '航空快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('189', 'haoyoukuai', '好又快物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('190', 'ccd', '河南次晨达', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('191', 'hfwuxi', '和丰同城', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('192', 'higo', '黑狗物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('193', 'hyytes', '恒宇运通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('194', 'hengrui56', '恒瑞物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('195', 'hangrui', '上海航瑞货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('196', 'ghl', '环创物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('197', 'hnqst', '河南全速通', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('198', 'hitaoe', 'Hi淘易快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('199', 'hhair56', '华瀚快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('200', 'haimibuy', '海米派物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('201', 'ht22', '海淘物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('202', 'hivewms', '海沧无忧', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('203', 'hnht56', '鸿泰物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('204', 'hsgtsd', '海硕高铁速递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('205', 'hltop', '海联快递', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('206', 'hlkytj', '互联快运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('207', 'haidaibao', '海带宝转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('208', 'flowerkd', '花瓣转运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('209', 'heimao56', '黑猫速运', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('210', 'logistics', '華信物流WTO', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('211', 'hgy56', '环国运物流', 'H', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('212', 'iparcel', 'i-parcel', 'I', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('213', 'jjwl', '佳吉物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('214', 'jywl', '佳怡物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('215', 'jymwl', '加运美快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('216', 'jxd', '急先达物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('217', 'jgsd', '京广速递快件', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('218', 'jykd', '晋越快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('219', 'jd', '京东物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('220', 'jietekuaidi', '捷特快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('221', 'jiuyicn', '久易快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('222', 'jiuyescm', '九曳供应链', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('223', 'junfengguoji', '骏丰国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('224', 'jiajiatong56', '佳家通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('225', 'jrypex', '吉日优派', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('226', 'jinchengwuliu', '锦程国际物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('227', 'jgwl', '景光物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('228', 'pzhjst', '急顺通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('229', 'ruexp', '捷网俄全通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('230', 'jialidatong', '嘉里大通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('231', 'jmjss', '金马甲', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('232', 'jiacheng', '佳成快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('233', 'jsexpress', '骏绅物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('234', 'hrex', '锦程快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('235', 'jieanda', '捷安达国际速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('236', 'newsway', '家家通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('237', 'mapleexpress', '今枫国际快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('238', 'jixiangyouau', '吉祥邮（澳洲）', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('239', 'jjx888', '佳捷翔物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('240', 'polarexpress', '极地快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('241', 'jiazhoumao', '加州猫速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('242', 'juzhongda', '聚中大', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('243', 'jieborne', '捷邦物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('244', 'jxfex', '集先锋速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('245', 'jiugong', '九宫物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('246', 'jiujiuwl', '久久物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('247', 'jintongkd', '劲通快递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('248', 'jcsuda', '嘉诚速达', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('249', 'jingshun', '景顺物流', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('250', 'fastontime', '加拿大联通快运', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('251', 'khzto', '柬埔寨中通', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('252', 'kjkd', '快捷快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('253', 'kangliwuliu', '康力物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('254', 'kuayue', '跨越速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('255', 'kuaiyouda', '快优达速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('256', 'happylink', '开心快递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('257', 'ksudi', '快速递', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('258', 'kyue', '跨跃国际', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('259', 'kfwnet', '快服务', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('260', 'kuai8', '快8速运', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('261', 'kuaidawuliu', '快达物流', 'K', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('262', 'lianb', '联邦快递（国内）', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('263', 'lhtwl', '联昊通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('264', 'lb', '龙邦速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('265', 'lejiedi', '乐捷递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('266', 'lanhukuaidi', '蓝弧快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('267', 'ltexp', '乐天速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('268', 'lutong', '鲁通快运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('269', 'ledii', '乐递供应链', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('270', 'lundao', '论道国际物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('271', 'lasy56', '林安物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('272', 'lsexpress', '6LS EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('273', 'szuem', '联运通物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('274', 'blueskyexpress', '蓝天国际航空快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('275', 'lfexpress', '龙枫国际速递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('276', 'gslhkd', '联合快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('277', 'longfx', '龙飞祥快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('278', 'luben', '陆本速递 LUBEN EXPRESS', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('279', 'unitedex', '联合速运', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('280', 'lbex', '龙邦物流', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('281', 'ltparcel', '联通快递', 'L', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('282', 'macroexpressco', 'ME物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('283', 'mh', '民航快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('284', 'meiguokuaidi', '美国快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('285', 'menduimen', '门对门', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('286', 'mingliangwuliu', '明亮物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('287', 'minbangsudi', '民邦速递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('288', 'minshengkuaidi', '闽盛快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('289', 'yundaexus', '美国韵达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('290', 'mchy', '木春货运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('291', 'meiquick', '美快国际物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('292', 'valueway', '美通快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('293', 'cnmcpl', '马珂博逻', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('294', 'mailongdy', '迈隆递运', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('295', 'zsmhwl', '明辉物流', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('296', 'mosuda', '魔速达', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('297', 'meibang', '美邦国际快递', 'M', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('298', 'nuoyaao', '偌亚奥国际', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('299', 'nuoer', '诺尔国际物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('300', 'nell', '尼尔快递', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('301', 'ndwl', '南方传媒物流', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('302', 'canhold', '能装能送', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('303', 'wanjiatong', '宁夏万家通', 'N', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('304', 'nlebv', '欧亚专线', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('305', 'oborexpress', 'OBOR Express', 'O', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('306', 'pcaexpress', 'PCA Express', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('307', 'pingandatengfei', '平安达腾飞', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('308', 'peixingwuliu', '陪行物流', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('309', 'pengyuanexpress', '鹏远国际速递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('310', 'postelbe', 'PostElbe', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('311', 'papascm', '啪啪供应链', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('312', 'bazirim', '皮牙子快递', 'P', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('313', 'qfkd', '全峰快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('314', 'qy', '全一快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('315', 'qrt', '全日通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('316', 'qckd', '全晨快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('317', 'sevendays', '7天连锁物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('318', 'qbexpress', '秦邦快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('319', 'quanxintong', '全信通快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('320', 'quansutong', '全速通国际快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('321', 'qinyuan', '秦远物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('322', 'qichen', '启辰国际物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('323', 'quansu', '全速快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('324', 'qzx56', '全之鑫物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('325', 'qskdyxgs', '千顺快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('326', 'zqlwl', '青旅物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('327', 'quanchuan56', '全川物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('328', 'quantwl', '全通快运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('329', 'yatexpress', '乾坤物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('330', 'guexp', '全联速运', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('331', 'bjqywl', '青云物流', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('332', 'signedexpress', '签收快递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('333', 'express7th', '7号速递', 'Q', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('334', 'riyuwuliu', '日昱物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('335', 'rfsd', '瑞丰速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('336', 'rrs', '日日顺物流', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('337', 'rytsd', '日益通速递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('338', 'rrskx', '日日顺快线', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('339', 'gdrz58', '容智快运', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('340', 'rrthk', '日日通国际', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('341', 'homecourier', '如家国际快递', 'R', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('342', 'sewl', '速尔快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('343', 'haihongwangsong', '山东海红', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('344', 'sh', '盛辉物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('345', 'sfwl', '盛丰物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('346', 'shiyunkuaidi', '世运快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('347', 'shangda', '上大物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('348', 'stsd', '三态速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('349', 'saiaodi', '赛澳递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('350', 'ewl', '申通E物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('351', 'shenganwuliu', '圣安物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('352', 'sxhongmajia', '山西红马甲', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('353', 'suijiawuliu', '穗佳物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('354', 'syjiahuier', '沈阳佳惠尔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('355', 'shlindao', '上海林道货运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('356', 'sfift', '十方通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('357', 'shunjiefengda', '顺捷丰达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('358', 'subida', '速必达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('359', 'stcd', '速通成达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('360', 'stkd', '顺通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('361', 'sendtochina', '速递中国', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('362', 'sihaiet', '四海快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('363', 'staky', '首通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('364', 'hnssd56', '顺时达物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('365', 'superb', 'Superb Grace', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('366', 'sfjhd', '圣飞捷快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('367', 'sofast56', '嗖一下同城快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('368', 's2c', 'S2C', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('369', 'chinasqk', 'SQK国际速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('370', 'shunshid', '顺士达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('371', 'synship', 'SYNSHIP快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('372', 'shandiantu', '闪电兔', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('373', 'sdsy888', '首达速运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('374', 'sczpds', '速呈宅配', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('375', 'sureline', 'Sureline冠泰', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('376', 'stosolution', '申通国际', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('377', 'sycawl', '狮爱高铁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('378', 'sxexpress', '三象速递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('379', 'shangqiao56', '商桥物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('380', 'shd56', '商海德物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('381', 'shenma', '神马快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('382', 'sihiexpress', '四海捷运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('383', 'superoz', '速配鸥翼', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('384', 'fastgoexpress', '速派快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('385', 'zjstky', '苏通快运', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('386', 'suning', '苏宁物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('387', 'shaoke', '捎客物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('388', 'sdto', '速达通跨境物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('389', 'sut56', '速通物流', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('390', 'sundarexpress', '顺达快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('391', 'sxjdfreight', '顺心捷达', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('392', 'shengtongscm', '盛通快递', 'S', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('393', 'tnt', 'TNT快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('394', 'tt', '天天快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('395', 'tianzong', '天纵物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('396', 'chinatzx', '同舟行物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('397', 'nntengda', '腾达速递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('398', 'sd138', '泰国138', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('399', 'tongdaxing', '通达兴物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('400', 'tlky', '天联快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('401', 'ibenben', '途鲜物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('402', 'krtao', '淘韩国际快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('403', 'lntjs', '特急送', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('404', 'tny', 'TNY物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('405', 'djy56', '天翔东捷运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('406', 'guoeryue', '天天快物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('407', 'tianma', '天马迅达', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('408', 'surpassgo', '天越物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('409', 'tianxiang', '天翔快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('410', 'tywl99', '天翼物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('411', 'shpost', '同城快寄', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('412', 'humpline', '驼峰国际', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('413', 'transrush', 'TransRush', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('414', 'tstexp', 'TST速运通', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('415', 'ctoexp', '泰国中通CTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('416', 'thaizto', '泰国中通ZTO', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('417', 'tswlcloud', '天使物流云', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('418', 'tzky', '铁中快运', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('419', 'tcxbthai', 'TCXB国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('420', 'taimek', '天美快递', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('421', 'taoplus', '淘布斯国际物流', 'T', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('422', 'ups', 'UPS快递查询', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('423', 'yskd', '优速快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('424', 'usps', 'USPS美国邮政', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('425', 'ueq', 'UEQ快递', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('426', 'uex', 'UEX国际物流', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('427', 'utaoscm', 'UTAO 优到', 'U', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('428', 'wxwl', '万象物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('429', 'weitepai', '微特派', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('430', 'wjwl', '万家物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('431', 'wanboex', '万博快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('432', 'wtdchina', '威时沛运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('433', 'wzhaunyun', '微转运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('434', 'gswtkd', '万通快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('435', 'wandougongzhu', '豌豆物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('436', 'wjkwl', '万家康物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('437', 'vps', '维普恩物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('438', 'wykjt', '51跨境通', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('439', 'wherexpess', '威盛快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('440', 'weilaimingtian', '未来明天快递', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('441', 'wdm', '万达美', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('442', 'wto56kj', '温通物流', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('443', '56kuaiyun', '五六快运', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('444', 'wowvip', '沃埃家', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('445', 'grivertek', '潍鸿', 'W', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('446', 'xbwl', '新邦物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('447', 'xfwl', '信丰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('448', 'newegg', '新蛋物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('449', 'xianglongyuntong', '祥龙运通物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('450', 'xianchengliansudi', '西安城联速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('451', 'xilaikd', '喜来快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('452', 'xsrd', '鑫世锐达', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('453', 'xtb', '鑫通宝物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('454', 'xintianjie', '信天捷快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('455', 'xaetc', '西安胜峰', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('456', 'xianfeng', '先锋快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('457', 'sunspeedy', '新速航', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('458', 'xipost', '西邮寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('459', 'sinatone', '信联通', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('460', 'sunjex', '新杰物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('461', 'alog', '心怡物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('462', 'csxss', '新时速物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('463', 'xiangteng', '翔腾物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('464', 'westwing', '西翼物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('465', 'littlebearbear', '小熊物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('466', 'huanqiuabc', '中国香港环球快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('467', 'xinning', '新宁物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('468', 'wlwex', '星空国际', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('469', 'yyexp', '西安运逸快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('470', 'xiyoug', '西游寄', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('471', 'xlobo', 'xLobo', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('472', 'xunsuexpress', '迅速快递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('473', 'whgjkd', '香港伟豪国际物流', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('474', 'xyd666', '鑫远东速运', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('475', 'xdexpress', '迅达速递', 'X', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('476', 'ytkd', '运通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('477', 'ycwl', '远成物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('478', 'yfsd', '亚风速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('479', 'yishunhang', '亿顺航', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('480', 'yfwl', '越丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('481', 'yad', '源安达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('482', 'yfh', '原飞航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('483', 'yinjiesudi', '银捷速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('484', 'yitongfeihong', '一统飞鸿', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('485', 'yuxinwuliu', '宇鑫物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('486', 'yitongda', '易通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('487', 'youbijia', '邮必佳', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('488', 'yiqiguojiwuliu', '一柒物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('489', 'yinsu', '音素快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('490', 'yilingsuyun', '亿领速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('491', 'yujiawuliu', '煜嘉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('492', 'gml', '英脉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('493', 'leopard', '云豹国际货运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('494', 'czwlyn', '云南中诚', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('495', 'sdyoupei', '优配速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('496', 'yongchang', '永昌物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('497', 'yufeng', '御风速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('498', 'yousutongda', '优速通达', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('499', 'yongwangda', '永旺达快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('500', 'yingchao', '英超物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('501', 'edlogistics', '益递物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('502', 'yjxlm', '宜家行', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('503', 'onehcang', '一号仓', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('504', 'ycgky', '远成快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('505', 'yunfeng56', '韵丰物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('506', 'iyoungspeed', '驿扬国际速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('507', 'zgyzt', '一站通快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('508', 'eupackage', '易优包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('509', 'ydglobe', '云达通', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('510', 'el56', 'YLTD', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('511', 'yundx', '运东西', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('512', 'yangbaoguo', '洋包裹', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('513', 'uluckex', '优联吉运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('514', 'ecmscn', '易客满', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('515', 'ubonex', '优邦速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('516', 'yue777', '玥玛速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('517', 'ywexpress', '远为快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('518', 'ezhuanyuan', '易转运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('519', 'yiqisong', '一起送', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('520', 'yongbangwuliu', '永邦国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('521', 'yyox', '邮客全球速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('522', 'yihangmall', '易航物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('523', 'yiouzhou', '易欧洲国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('524', 'ykouan', '洋口岸', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('525', 'youyou', '优优速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('526', 'ytky168', '运通快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('527', 'sixroad', '易普递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('528', 'yourscm', '雅澳物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('529', 'euguoji', '易邮国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('530', 'uscbexpress', '易境达国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('531', 'yfsuyun', '驭丰速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('532', 'yimidida', '壹米滴答', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('533', 'ugoexpress', '邮鸽速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('534', 'youban', '邮邦国际', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('535', 'hkems', '云邮跨境快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('536', 'youlai', '邮来速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('537', 'eta100', '易达国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('538', 'yatfai', '一辉物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('539', 'yzswuliu', '亚洲顺物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('540', 'yifankd', '艺凡快递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('541', 'mantoo', '优能物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('542', 'vctrans', '越中国际物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('543', 'yhtlogistics', '宇航通物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('544', 'ycgglobal', 'YCG物流', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('545', 'yidihui', '驿递汇速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('546', 'yuanhhk', '远航国际快运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('547', 'yiyou', '易邮速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('548', 'eusacn', '优莎速运', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('549', 'uhi', '优海国际速递', 'Y', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('550', 'zjs', '宅急送', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('551', 'ztky', '中铁快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('552', 'ztwl', '中铁物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('553', 'zywl', '中邮物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('554', 'zhimakaimen', '芝麻开门', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('555', 'zhengzhoujianhua', '郑州建华', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('556', 'zhongsukuaidi', '中速快件', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('557', 'zhongtianwanyun', '中天万运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('558', 'zhongruisudi', '中睿速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('559', 'zhongwaiyun', '中外运速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('560', 'zengyisudi', '增益速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('561', 'sujievip', '郑州速捷', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('562', 'ztong', '智通物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('563', 'zhichengtongda', '至诚通达快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('564', 'zhdwl', '众辉达物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('565', 'kuachangwuliu', '直邮易', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('566', 'topspeedex', '中运全速', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('567', 'otobv', '中欧快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('568', 'zsky123', '准实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('569', 'cnws', '中国翼', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('570', 'zytdscm', '中宇天地', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('571', 'zhuanyunsifang', '转运四方', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('572', 'hrbzykd', '卓烨快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('573', 'zhuoshikuaiyun', '卓实快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('574', 'chinaicip', '卓志速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('575', 'ynztsy', '纵通速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('576', 'zdepost', '直德邮', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('577', 'chinapostcb', '中邮电商', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('578', 'chunghwa56', '中骅物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('579', 'cosco', '中远e环球', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('580', 'zf365', '珠峰速运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('581', 'zhongtongkuaiyun', '中通快运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('582', 'eucnrail', '中欧国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('583', 'chnexp', '中翼国际物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('584', 'cccc58', '中集冷云', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('585', 'auvanda', '中联速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('586', 'zyzoom', '增速跨境', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('587', 'zhpex', '众派速递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('588', 'byht', '展勤快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('589', 'zhongchuan', '众川国际', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('590', 'zhonghuanus', '中环转运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('591', 'zhonghuan', '中环快递', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('592', 'uszcn', '转运中国', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('593', 'zhitengwuliu', '志腾物流', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('594', 'zsda56', '转瞬达集运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('595', 'zjgj56', '振捷国际货运', 'Z', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('596', 'jtexpress', '极兔速递', 'J', '1', '100', '1553911076', '1553911076');
INSERT INTO `ey_shop_express` VALUES ('598', 'fengwang', '丰网速运', 'F', '0', '100', '1553911076', '1647484768');

-- -----------------------------
-- Table structure for `ey_shop_order`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order`;
CREATE TABLE `ey_shop_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '订单id',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态：0未付款(已下单)，1已付款(待发货)，2已发货(待收货)，3已完成(确认收货)，-1订单取消(已关闭)，4订单过期',
  `payment_method` tinyint(1) DEFAULT '0' COMMENT '订单支付方式，0为在线支付，1为货到付款，默认0',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `order_terminal` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单终端(1=电脑端、2=手机端、3微信小程序)',
  `contains_virtual` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单是否包含虚拟商品(1=不包含、2=包含)',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '订单手动退款原因',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `express_order` varchar(50) DEFAULT '' COMMENT '发货物流单号',
  `express_name` varchar(32) DEFAULT '' COMMENT '发货物流名称',
  `express_code` varchar(32) DEFAULT '' COMMENT '发货物流code',
  `express_time` int(11) DEFAULT '0' COMMENT '发货时间',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `confirm_time` int(11) DEFAULT '0' COMMENT '收货确认时间',
  `shipping_fee` decimal(10,2) DEFAULT '0.00' COMMENT '订单运费',
  `order_total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '订单总价',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_total_num` int(10) DEFAULT '0' COMMENT '订单总数',
  `country` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家',
  `province` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '省份',
  `city` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '城市',
  `district` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '县区',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '收货地址',
  `mobile` varchar(20) DEFAULT '' COMMENT '手机',
  `prom_type` tinyint(1) unsigned DEFAULT '0' COMMENT '订单类型：0普通订单，1虚拟订单',
  `virtual_delivery` text COMMENT '虚拟订单时，卖家发货给买家的回复',
  `admin_note` text COMMENT '管理员操作备注',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `user_note` text COMMENT '会员备注',
  `group` varchar(50) DEFAULT '' COMMENT '订单分组',
  `order_md5` varchar(50) DEFAULT '' COMMENT '订单标识串，删除未付款的重复订单',
  `order_source` tinyint(3) DEFAULT '10' COMMENT '10-普通订单 20-秒杀订单',
  `order_source_id` int(10) DEFAULT '0' COMMENT '来源id(秒杀订单:active_time_id)',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `coupon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '优惠券数据表ID',
  `use_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员的优惠券数据表ID',
  `coupon_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '使用的优惠券金额',
  PRIMARY KEY (`order_id`),
  UNIQUE KEY `order_code` (`order_code`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单主表';


-- -----------------------------
-- Table structure for `ey_shop_order_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_comment`;
CREATE TABLE `ey_shop_order_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `total_score` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '总评分，1：好评，2中评，3差评',
  `content` varchar(1000) NOT NULL DEFAULT '' COMMENT '评论内容',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '晒单图片',
  `admin_reply` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员回复',
  `ip_address` varchar(15) NOT NULL DEFAULT '' COMMENT 'IP地址',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：0否，1是',
  `is_anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否匿名评价：0否，1是',
  `is_new_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否新版评价：0否，1是',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `users_id` (`users_id`),
  KEY `order_id` (`order_id`),
  KEY `details_id` (`details_id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商品评价表';


-- -----------------------------
-- Table structure for `ey_shop_order_details`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_details`;
CREATE TABLE `ey_shop_order_details` (
  `details_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `product_name` varchar(100) NOT NULL DEFAULT '' COMMENT '产品名称',
  `num` int(10) NOT NULL DEFAULT '0' COMMENT '单个产品数量',
  `data` text COMMENT '序列化额外数据',
  `product_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '产品单价',
  `prom_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品类型：0普通产品，1虚拟产品',
  `litpic` varchar(500) NOT NULL DEFAULT '' COMMENT '封面图片',
  `apply_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否申请退换货服务：0 未申请、1已申请',
  `is_comment` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已评论，0为否，1为是，默认0',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`details_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单详情表';


-- -----------------------------
-- Table structure for `ey_shop_order_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_log`;
CREATE TABLE `ey_shop_order_log` (
  `action_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `action_user` int(10) DEFAULT '0' COMMENT '操作人；0:用户操作；1以上:管理员id',
  `order_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态，单条记录状态',
  `express_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '物流状态，0:未发货，1:已发货',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，0:未支付，1:已支付',
  `action_desc` varchar(255) DEFAULT '' COMMENT '状态描述',
  `action_note` varchar(255) NOT NULL DEFAULT '' COMMENT '操作备注',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`action_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_service`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service`;
CREATE TABLE `ey_shop_order_service` (
  `service_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型：1换货，2退货，3维修',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `details_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单明细表ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `product_name` varchar(200) NOT NULL DEFAULT '' COMMENT '产品名称',
  `product_spec` varchar(200) NOT NULL DEFAULT '' COMMENT '产品规格',
  `product_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品数量',
  `product_img` varchar(500) NOT NULL DEFAULT '' COMMENT '产品图片',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '退换货描述',
  `upload_img` varchar(3000) NOT NULL DEFAULT '' COMMENT '上传的图片',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '退货的收货地址',
  `consignee` varchar(30) NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机',
  `manual_refund` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '服务单是否被手动关闭并退款',
  `refund_note` varchar(500) NOT NULL DEFAULT '' COMMENT '服务单手动退款原因',
  `refund_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还金额',
  `refund_balance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '退还余额',
  `refund_code` varchar(40) NOT NULL DEFAULT '' COMMENT '退款单号',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1审核中 2审核通过 3审核不通过 4已发货 5已收货 6换货完成 7退款完成 8服务取消',
  `users_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '会员发货信息',
  `admin_delivery` varchar(500) NOT NULL DEFAULT '' COMMENT '管理员发货信息',
  `admin_note` varchar(1000) NOT NULL DEFAULT '' COMMENT '管理员操作备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`service_id`),
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `product_id` (`product_id`) USING BTREE,
  KEY `details_id` (`details_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务表';


-- -----------------------------
-- Table structure for `ey_shop_order_service_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_service_log`;
CREATE TABLE `ey_shop_order_service_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `service_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '服务表ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `log_note` varchar(500) NOT NULL DEFAULT '' COMMENT '记录备注',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  PRIMARY KEY (`log_id`),
  KEY `service_id` (`service_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单退换货服务记录表';


-- -----------------------------
-- Table structure for `ey_shop_order_unified_pay`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_order_unified_pay`;
CREATE TABLE `ey_shop_order_unified_pay` (
  `unified_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '统一支付订单ID',
  `unified_number` varchar(30) NOT NULL DEFAULT '' COMMENT '统一支付订单编号',
  `unified_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '统一支付订单应付款金额',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_ids` text NOT NULL COMMENT '合并支付的订单ID，serialize序列化存储',
  `pay_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '统一支付订单状态：0未付款，1已付款',
  `pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '统一支付订单时间',
  `pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '统一支付订单方式名称',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`unified_id`),
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_shop_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attr`;
CREATE TABLE `ey_shop_product_attr` (
  `product_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attribute`;
CREATE TABLE `ey_shop_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `list_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text NOT NULL COMMENT '可选值列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `is_custom` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义参数(0否 1是)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`list_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_product_attrlist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_product_attrlist`;
CREATE TABLE `ey_shop_product_attrlist` (
  `list_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '列表id',
  `list_name` varchar(60) NOT NULL DEFAULT '' COMMENT '列表名称',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0=禁用，1=启用)',
  `attr_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '参数数量',
  `desc` text NOT NULL COMMENT '描述备注',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '列表排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_shop_shipping_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_shop_shipping_template`;
CREATE TABLE `ey_shop_shipping_template` (
  `template_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID',
  `template_region` varchar(255) NOT NULL DEFAULT '' COMMENT '模板运送区域',
  `template_money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '模板运费',
  `province_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'region表id',
  `lang` varchar(30) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='运费模板表';

-- -----------------------------
-- Records of `ey_shop_shipping_template`
-- -----------------------------
INSERT INTO `ey_shop_shipping_template` VALUES ('1', '北京市', '0.00', '1', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('2', '天津市', '0.00', '338', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('3', '河北省', '0.00', '636', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('4', '山西省', '0.00', '3102', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('5', '内蒙古自治区', '0.00', '4670', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('6', '辽宁省', '0.00', '5827', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('7', '吉林省', '0.00', '7531', 'cn', '1554775921');
INSERT INTO `ey_shop_shipping_template` VALUES ('8', '黑龙江省', '0.00', '8558', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('9', '上海市', '0.00', '10543', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('10', '江苏省', '0.00', '10808', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('11', '浙江省', '0.00', '12596', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('12', '安徽省', '0.00', '14234', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('13', '福建省', '0.00', '16068', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('14', '江西省', '0.00', '17359', 'cn', '1554775962');
INSERT INTO `ey_shop_shipping_template` VALUES ('15', '山东省', '0.00', '19280', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('16', '河南省', '0.00', '21387', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('17', '湖北省', '0.00', '24022', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('18', '湖南省', '0.00', '25579', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('19', '广东省', '0.00', '28240', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('20', '广西壮族自治区', '0.00', '30164', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('21', '海南省', '0.00', '31563', 'cn', '1555483193');
INSERT INTO `ey_shop_shipping_template` VALUES ('22', '重庆市', '0.00', '31929', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('23', '四川省', '0.00', '33007', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('24', '贵州省', '0.00', '37906', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('25', '云南省', '0.00', '39556', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('26', '西藏自治区', '0.00', '41103', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('27', '陕西省', '0.00', '41877', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('28', '甘肃省', '0.00', '43776', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('29', '青海省', '0.00', '45286', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('30', '宁夏回族自治区', '0.00', '45753', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('31', '新疆维吾尔自治区', '0.00', '46047', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('32', '台湾省', '0.00', '47493', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('33', '香港特别行政区', '0.00', '47494', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('34', '澳门特别行政区', '0.00', '47495', 'cn', '1554775610');
INSERT INTO `ey_shop_shipping_template` VALUES ('35', '统一配送价格', '0.00', '100000', 'cn', '1556618311');

-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('1', '1', '1', '', '', '1599189692', '1599189692');
INSERT INTO `ey_single_content` VALUES ('2', '2', '8', '&lt;p&gt;广州市某某渔具生成有限公司&amp;nbsp;创建于1996年，地处广东省闻名中外的太湖之滨——陶都宜兴，位于苏、浙、皖三省交界处，沪、宁、杭的中心，是一个文化发达的新兴城市，沪宜高速、宁杭高速、长深高速横穿而过，水陆交通十分便利。&lt;/p&gt;&lt;p&gt;从最初的鱼线研发与市场开拓开始，慢慢的建立起集渔具的研发、生产、销售为一体的大型企业，现旗下品牌有佳钓尼、新晨、活丽，还有鱼竿、钓箱、鱼竿支架、抄网、钓鱼椅、钓鱼配件等系列产品。&lt;/p&gt;&lt;p&gt;公司产品质量稳定，技术力量雄厚，测试手段齐全。奉行简捷周到、诚信高效的服务宗旨，恪守商业道德，以客户的需求为服务起点，以客户满意为服务内容。秉成客户至上的经营理念，以人为本的管理意识，高素质的管理人才，全方位的服务模式让客户更加省心、放心、安心。竭诚欢迎国内外客户来人、来电洽谈业务，欢迎使用。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;公司多年来始终立足于“以质量为生命，以科技为发展”，发挥整体的科技优势，一步一台阶，在为国内外众多化工企业的服务和技术合作过程中，博取众长，通过自主创新和研究开发，可以为不同的石油化工企业提供国际先进水平的技术及装置。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '', '1599189713', '1599189713');
INSERT INTO `ey_single_content` VALUES ('3', '3', '9', '&lt;p style=&quot;text-align:center&quot;&gt;&lt;img title=&quot;加入我们(图1)&quot; alt=&quot;加入我们(图1)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z4102432316.jpg&quot;/&gt;&lt;/p&gt;', '', '1599204887', '1599204887');
INSERT INTO `ey_single_content` VALUES ('4', '4', '10', '&lt;p&gt;&lt;img src=&quot;/uploads/ueditor/20200904/1-200Z4102445J6.jpg&quot; title=&quot;&quot; alt=&quot;1-200Z4102445J6.jpg&quot;/&gt;&lt;/p&gt;', '', '1599186286', '1599186286');
INSERT INTO `ey_single_content` VALUES ('5', '5', '7', '&lt;p style=&quot;text-align: center;&quot;&gt;地址：广东省广州市番禺经济开发区&lt;br style=&quot;-webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;microsoft yahei&amp;quot;, 宋体, Arial; font-size: 14px; white-space: normal;&quot;/&gt;电话：+86 0000 88888&lt;br style=&quot;-webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;microsoft yahei&amp;quot;, 宋体, Arial; font-size: 14px; white-space: normal;&quot;/&gt;QQ：88888888&lt;br style=&quot;-webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;microsoft yahei&amp;quot;, 宋体, Arial; font-size: 14px; white-space: normal;&quot;/&gt;手机：13988888888&lt;br style=&quot;-webkit-tap-highlight-color: rgba(255, 255, 255, 0); margin: 0px; color: rgb(51, 51, 51); font-family: &amp;quot;microsoft yahei&amp;quot;, 宋体, Arial; font-size: 14px; white-space: normal;&quot;/&gt;邮箱：admin@admin.com&lt;/p&gt;', '', '1638408580', '1638408580');
INSERT INTO `ey_single_content` VALUES ('6', '6', '5', '&lt;p&gt;\r\n    &lt;img title=&quot;服务流程(图1)&quot; alt=&quot;服务流程(图1)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z41023451A.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n    迎宾打招呼 → 留意信号 → 开场白 → 产品展示 → 聆听判断顾客需求并做好产品搭配 → 记录顾客个人及消费信息 → 收银服务 → 欢送客人\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n    &lt;img title=&quot;服务流程(图2)&quot; alt=&quot;服务流程(图2)&quot; src=&quot;/uploads/ueditor/20200904/1-200Z4102345b3.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;h3&gt;\r\n    一、关于价格\r\n&lt;/h3&gt;\r\n&lt;p&gt;\r\n    价格是商品同货币交换时一单位商品需要的货币的数量多少（比例的指数，这种说法是错误的，指数是多种商品才有的，无量纲），或者说，价格是价值的（货币删除，价值本身是用货币表示的）表现。价格是商品的交换价值在流通过程中所取得的转化形式。在经济学及营商的过程中，价格是一项以货币为表现形式，为商品、服务及资产所订立的价值数字。在微观经济学之中，资源在需求和供应者之间重新分配的过程中，价格是重要的变数之一。\r\n&lt;/p&gt;\r\n&lt;h3&gt;\r\n    二、关于产品质量\r\n&lt;/h3&gt;\r\n&lt;p&gt;\r\n    质量，是量度物体平动惯性大小的物理量，拼音为：zhì liàng，意思是产品或工作的优劣程度，提高质量（一组固有特性满足要求的程度）。社会学领域，（客观）价值或主体感受的现量，如（观察）社会质量（社会大众生活的适应性及水准）。\r\n&lt;/p&gt;\r\n&lt;h3&gt;\r\n    三、关于运输\r\n&lt;/h3&gt;\r\n&lt;p&gt;\r\n    运输是指用特定的设备和工具，将物品从一个地点向另一个地点运送的物流活动，它是在不同地域范围内，以改变物的空间位置为目的对物进行的空间位移。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n    &lt;br/&gt;\r\n&lt;/p&gt;', '', '1599204929', '1599204929');
INSERT INTO `ey_single_content` VALUES ('7', '7', '23', '', '', '1599188646', '1599188646');
INSERT INTO `ey_single_content` VALUES ('8', '8', '25', '&lt;p&gt;适用于深海、浅海、江河、湖泊、水库、池塘和沟渠的捕捞、养殖作业，长期以品质优良、价格合理、交货及时、诚实守信，赢得海内外客户青睐。&lt;/p&gt;', '', '1599124991', '1599124991');
INSERT INTO `ey_single_content` VALUES ('9', '9', '26', '&lt;p&gt;适用于深海、浅海、江河、湖泊、水库、池塘和沟渠的捕捞、养殖作业，长期以品质优良、价格合理、交货及时、诚实守信，赢得海内外客户青睐。&lt;/p&gt;', '', '1599124997', '1599124997');
INSERT INTO `ey_single_content` VALUES ('10', '10', '27', '&lt;p&gt;适用于深海、浅海、江河、湖泊、水库、池塘和沟渠的捕捞、养殖作业，长期以品质优良、价格合理、交货及时、诚实守信，赢得海内外客户青睐。&lt;/p&gt;', '', '1599124499', '1599124499');
INSERT INTO `ey_single_content` VALUES ('11', '11', '28', '&lt;p&gt;适用于深海、浅海、江河、湖泊、水库、池塘和沟渠的捕捞、养殖作业，长期以品质优良、价格合理、交货及时、诚实守信，赢得海内外客户青睐。&lt;/p&gt;', '', '1599124504', '1599124504');
INSERT INTO `ey_single_content` VALUES ('12', '12', '24', '', '', '1599188739', '1599188739');

-- -----------------------------
-- Table structure for `ey_sms_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_log`;
CREATE TABLE `ey_sms_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `source` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送来源，与场景ID对应：0=注册，1=绑定，2=登录密码，3=支付密码，4=找回密码',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `mobile` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '验证码',
  `status` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '发送状态,1:成功,0:失败',
  `is_use` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否使用，1:是，0:否',
  `msg` varchar(255) NOT NULL DEFAULT '' COMMENT '短信内容',
  `ip` varchar(20) DEFAULT 'IP地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `error_msg` text NOT NULL COMMENT '发送短信异常内容',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='手机短信发送记录';


-- -----------------------------
-- Table structure for `ey_sms_template`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sms_template`;
CREATE TABLE `ey_sms_template` (
  `tpl_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sms_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '短信服务商类型，1---阿里云短信， 2---腾讯云短信',
  `tpl_title` varchar(128) NOT NULL DEFAULT '' COMMENT '短信标题',
  `sms_sign` varchar(50) NOT NULL DEFAULT '' COMMENT '短信签名',
  `sms_tpl_code` varchar(100) NOT NULL DEFAULT '' COMMENT '短信模板ID',
  `tpl_content` varchar(1000) NOT NULL DEFAULT '' COMMENT '发送短信内容',
  `send_scene` varchar(100) NOT NULL DEFAULT '' COMMENT '短信发送场景',
  `is_open` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='手机短信发送模板';

-- -----------------------------
-- Records of `ey_sms_template`
-- -----------------------------
INSERT INTO `ey_sms_template` VALUES ('1', '1', '账号注册', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '0', '1', 'cn', '1599182043', '1599182043');
INSERT INTO `ey_sms_template` VALUES ('2', '1', '手机绑定', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '1', '1', 'cn', '1599182043', '1599182043');
INSERT INTO `ey_sms_template` VALUES ('3', '1', '找回密码', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '4', '1', 'cn', '1599182043', '1599182043');
INSERT INTO `ey_sms_template` VALUES ('4', '1', '订单付款', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '5', '1', 'cn', '1599182043', '1638408557');
INSERT INTO `ey_sms_template` VALUES ('5', '2', '账号注册', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '0', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_sms_template` VALUES ('6', '2', '手机绑定', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '1', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_sms_template` VALUES ('7', '2', '找回密码', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '4', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_sms_template` VALUES ('8', '2', '订单付款', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '5', '1', 'cn', '1614656192', '1638408557');
INSERT INTO `ey_sms_template` VALUES ('9', '1', '订单发货', '', '', '您有新的消息：您有新的${content}订单，请注意查收！', '6', '1', 'cn', '1599182043', '1638408557');
INSERT INTO `ey_sms_template` VALUES ('10', '2', '订单发货', '', '', '您有新的消息：您有新的{1}订单，请注意查收！', '6', '1', 'cn', '1614656192', '1638408557');
INSERT INTO `ey_sms_template` VALUES ('11', '1', '账号登录', '', '', '验证码为 ${content} ，请在30分钟内输入验证。', '2', '1', 'cn', '1599182043', '1599182043');
INSERT INTO `ey_sms_template` VALUES ('12', '2', '账号登录', '', '', '验证码为 {1} ，请在30分钟内输入验证。', '2', '1', 'cn', '1614656192', '1614656192');

-- -----------------------------
-- Table structure for `ey_smtp_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_record`;
CREATE TABLE `ey_smtp_record` (
  `record_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，与场景ID对应：0=默认，2=注册，3=绑定邮箱，4=找回密码',
  `email` varchar(50) DEFAULT '' COMMENT '邮件地址',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID',
  `code` varchar(20) DEFAULT '' COMMENT '发送邮件内容',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否使用，默认0，0为未使用，1为使用',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`record_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='邮件发送记录表';


-- -----------------------------
-- Table structure for `ey_smtp_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_smtp_tpl`;
CREATE TABLE `ey_smtp_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '邮件标题',
  `tpl_content` text COMMENT '发送邮件内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '邮件发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='邮件模板表';

-- -----------------------------
-- Records of `ey_smtp_tpl`
-- -----------------------------
INSERT INTO `ey_smtp_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请查收！', '${content}', '1', '1', 'cn', '1544763495', '1552638302');
INSERT INTO `ey_smtp_tpl` VALUES ('2', '会员注册', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '2', '1', 'cn', '1544763495', '1552667056');
INSERT INTO `ey_smtp_tpl` VALUES ('3', '绑定邮箱', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '3', '1', 'cn', '1544763495', '1552667400');
INSERT INTO `ey_smtp_tpl` VALUES ('4', '找回密码', '验证码已发送至您的邮箱，请登录邮箱查看验证码！', '${content}', '4', '1', 'cn', '1544763495', '1552663577');
INSERT INTO `ey_smtp_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1599182043', '1638408557');
INSERT INTO `ey_smtp_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1638408557', '1638408557');

-- -----------------------------
-- Table structure for `ey_special_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_content`;
CREATE TABLE `ey_special_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `content_ey_m` longtext COMMENT '手机端内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题附加表';


-- -----------------------------
-- Table structure for `ey_special_node`
-- -----------------------------
DROP TABLE IF EXISTS `ey_special_node`;
CREATE TABLE `ey_special_node` (
  `node_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '节点名称',
  `code` varchar(50) NOT NULL DEFAULT '' COMMENT '节点标识',
  `isauto` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动获取文档',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字（多个中间用'',''分开）',
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `aidlist` text NOT NULL COMMENT '关联文章列表（多个中间用'',''分开）',
  `row` int(5) NOT NULL DEFAULT '10' COMMENT '文档数',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='专题节点表';


-- -----------------------------
-- Table structure for `ey_sql_cache_table`
-- -----------------------------
DROP TABLE IF EXISTS `ey_sql_cache_table`;
CREATE TABLE `ey_sql_cache_table` (
  `cache_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sql_name` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句的标识名称，目前由模型名称+模型ID组成',
  `sql_result` text NOT NULL COMMENT 'mysql执行结果',
  `sql_md5` varchar(60) NOT NULL DEFAULT '' COMMENT 'mysql语句MD5的值',
  `sql_query` text NOT NULL COMMENT '完整mysql语句',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`cache_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='mysql缓存表';

-- -----------------------------
-- Records of `ey_sql_cache_table`
-- -----------------------------
INSERT INTO `ey_sql_cache_table` VALUES ('1', 'ArchivesMaxID', '37', '494a17e43cff13eeb4b9c9837c29026c', 'SELECT MAX(aid) AS tp_max FROM `ey_archives` LIMIT 1', '1638408557', '1638408557');
INSERT INTO `ey_sql_cache_table` VALUES ('2', '|model|all|count|', '{\"1\":{\"channel\":1,\"total\":17},\"2\":{\"channel\":2,\"total\":8},\"6\":{\"channel\":6,\"total\":12}}', 'd5ac17fe5649c6d04f4b174c42f2d535', 'SELECT channel, count(aid) as total FROM `ey_archives` WHERE  `lang` = \'cn\'  AND `status` = 1  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `channel`', '1638408557', '1638408557');
INSERT INTO `ey_sql_cache_table` VALUES ('3', '|arctype|all|count|', '{\"11\":{\"typeid\":11,\"num\":8},\"17\":{\"typeid\":17,\"num\":11},\"19\":{\"typeid\":19,\"num\":6}}', '9f6b5e62b9b8456535e5881c8b05072f', 'SELECT typeid, count(typeid) as num FROM `ey_archives` WHERE  `channel` IN (1,2,3,4,5,7,51)  AND `lang` = \'cn\'  AND `is_del` = 0  AND (  (users_id = 0 OR (users_id > 0 AND arcrank >= 0)) ) GROUP BY `typeid`', '1638408564', '1638408564');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'tagid',
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `count` int(10) unsigned DEFAULT '0' COMMENT '点击',
  `total` int(10) unsigned DEFAULT '0' COMMENT '文档数',
  `weekcc` int(10) unsigned DEFAULT '0' COMMENT '周统计',
  `monthcc` int(10) unsigned DEFAULT '0' COMMENT '月统计',
  `weekup` int(10) unsigned DEFAULT '0' COMMENT '每周更新',
  `monthup` int(10) unsigned DEFAULT '0' COMMENT '每月更新',
  `is_common` tinyint(1) DEFAULT '0' COMMENT '是否常用标签，0=否，1=是',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE,
  KEY `lang` (`lang`,`add_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签索引表';


-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'tagid',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_tuadui_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tuadui_content`;
CREATE TABLE `ey_tuadui_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `zhicheng1` varchar(200) NOT NULL DEFAULT '' COMMENT '职称一',
  `zhicheng2` varchar(200) NOT NULL DEFAULT '' COMMENT '职称二',
  `zhicheng3` varchar(200) NOT NULL DEFAULT '' COMMENT '职称三',
  `zhicheng4` varchar(200) NOT NULL DEFAULT '' COMMENT '职称四',
  `jianjie` longtext COMMENT '个人简介',
  `zhiwei` varchar(200) NOT NULL DEFAULT '' COMMENT '职位',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_tuadui_content`
-- -----------------------------
INSERT INTO `ey_tuadui_content` VALUES ('1', '12', '1561625442', '1561625442', '高级专业会计硕士', '中国注册资产评估师', '中国注册会计师', '', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('2', '13', '1561625619', '1561625619', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '高级专业会计硕士', '&lt;p&gt;会计师事务所股权合伙人，具有近30年执业经验，长期从事会计、审计行业积累了丰富的执业经验，使得他十分擅长于企业财务咨询、税收筹划、重组改制等业务，对现代独立审计和企业管理有着独到见解。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 123-4567&lt;/p&gt;&lt;p&gt;电子邮箱： admin@youweb.com&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('3', '14', '1561625700', '1561625700', '中国注册会计师', '澳洲会计师公会会员', '美国注册会计师', '英国特许公认会计师公会资深会员', '&lt;p&gt;拥有二十年丰富的审计及财务咨询经验，曾服务包括香港及美国上市公司在内的不同类型的客户，善长于国际准则审计、商定程序的审计及相关服务。为全国注册会计师行业领军人才、英国特许公认会计师公会资深会员、澳洲会计师公会会员、《小型企业财务报表审计工作底稿编制指南》编写组成员。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '高级合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('4', '15', '1561625764', '1561625764', '中国注册会计师', '中国注册资产评估师', '中国注册税务师', '', '&lt;p&gt;执业超过二十五年，多年来致力于为外商投资企业和国有企业的客户提供专业服务，涉及行业包括制造、地产、交通运输、酒店及旅游等。她在会计、审计、税务、外汇、咨询方面具备丰富的实务经验。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;联系电话：+86 400-123-4567&lt;/p&gt;&lt;p&gt;电子邮箱：admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '合伙人');
INSERT INTO `ey_tuadui_content` VALUES ('5', '45', '1561689749', '1561689749', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('6', '46', '1561689834', '1561689834', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('7', '47', '1561689943', '1561689943', 'CICPA', 'CCPV', 'CICTA', 'Master of Professional Accounting', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'senior partner');
INSERT INTO `ey_tuadui_content` VALUES ('8', '48', '1561689988', '1561689988', 'CICPA', 'CCPV', 'Master of Professional Accounting', '', '&lt;p&gt;Equity partners of accounting firms, with nearly 30 years of practice experience, have accumulated rich experience in accounting and auditing industry for a long time, which makes him very good at business such as enterprise financial consultation, tax planning, restructuring and restructuring, and has unique views on modern independent auditing and enterprise management.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;Contact number: +86 123-4567&lt;/p&gt;&lt;p&gt;E-mail: admin@youweb.com&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'Partner');

-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(200) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `idcode` varchar(50) DEFAULT '' COMMENT '页面唯一id标识（由 标识符+栏目id或文档id等）组成',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='可视化参数设置';


-- -----------------------------
-- Table structure for `ey_uploads`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads`;
CREATE TABLE `ey_uploads` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) NOT NULL DEFAULT '0' COMMENT '分组ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `title` varchar(200) DEFAULT '' COMMENT '文档标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `intro` varchar(500) DEFAULT '' COMMENT '图集描述',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` int(11) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `users_id` int(11) DEFAULT '0' COMMENT '用户ID',
  `sort_order` smallint(5) DEFAULT '100' COMMENT '排序',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '1已删除 0未删除',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`img_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `add_time` (`add_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传记录表';


-- -----------------------------
-- Table structure for `ey_uploads_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_uploads_type`;
CREATE TABLE `ey_uploads_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_type` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传分组表';


-- -----------------------------
-- Table structure for `ey_urls_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_urls_content`;
CREATE TABLE `ey_urls_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `pagePath` enum('首页','产品列表','信息公开','企业展播','龙凤美景','分销中心','购物车','个人中心','领取优惠券','新闻资讯','签到中心','地址管理','积分商城','砍价活动','拼团活动','我的收藏','我的优惠券','秒杀活动','我的足迹') DEFAULT '首页' COMMENT '跳转路径',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_urls_content`
-- -----------------------------
INSERT INTO `ey_urls_content` VALUES ('1', '113', '1667196112', '1667196112', '新闻资讯');
INSERT INTO `ey_urls_content` VALUES ('2', '114', '1667196466', '1667196466', '个人中心');
INSERT INTO `ey_urls_content` VALUES ('3', '115', '1667198526', '1667198526', '我的足迹');
INSERT INTO `ey_urls_content` VALUES ('4', '116', '1667198828', '1667198828', '首页');

-- -----------------------------
-- Table structure for `ey_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users`;
CREATE TABLE `ey_users` (
  `users_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `username` varchar(30) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '登录密码',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `is_mobile` tinyint(1) DEFAULT '0' COMMENT '绑定手机号，0为不绑定，1为绑定',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号码（仅用于登录）',
  `is_email` tinyint(1) DEFAULT '0' COMMENT '绑定邮箱，0为不绑定，1为绑定',
  `email` varchar(60) NOT NULL DEFAULT '' COMMENT '电子邮件（仅用于登录）',
  `paypwd` varchar(255) DEFAULT '' COMMENT '支付密码，暂时未用到，可保留。',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '用户金额',
  `frozen_money` decimal(10,2) DEFAULT '0.00' COMMENT '冻结金额',
  `scores` int(10) DEFAULT '0' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值',
  `reg_time` int(11) unsigned DEFAULT '0' COMMENT '注册时间',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_count` int(11) DEFAULT '0' COMMENT '登陆次数',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `province` int(6) DEFAULT '0' COMMENT '省份',
  `city` int(6) DEFAULT '0' COMMENT '市区',
  `district` int(6) DEFAULT '0' COMMENT '县',
  `level` smallint(5) DEFAULT '0' COMMENT '会员等级',
  `open_level_time` int(11) unsigned DEFAULT '0' COMMENT '开通会员级别时间',
  `level_maturity_days` varchar(20) DEFAULT '' COMMENT '会员级别到期天数',
  `discount` decimal(10,2) DEFAULT '1.00' COMMENT '会员折扣，默认1不享受',
  `total_amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费累计额度',
  `is_activation` tinyint(1) DEFAULT '1' COMMENT '是否激活，0否，1是。\r\n后台注册默认为1激活。\r\n前台注册时，当会员功能设置选择后台审核，需后台激活才可以登陆。',
  `register_place` tinyint(1) DEFAULT '2' COMMENT '注册位置。后台注册不受注册验证影响，1为后台注册，2为前台注册。默认为2。',
  `open_id` varchar(50) NOT NULL DEFAULT '' COMMENT '第三方唯一标识openid',
  `thirdparty` tinyint(1) DEFAULT '0' COMMENT '第三方注册类型：0=普通，1=微信，2=QQ',
  `is_lock` tinyint(1) DEFAULT '0' COMMENT '是否被锁定冻结',
  `admin_id` int(10) DEFAULT '0' COMMENT '关联管理员ID',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `unread_notice_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '未读消息数量',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  `sex` varchar(10) DEFAULT '保密' COMMENT '性别- 男,女,保密',
  `coin` int(11) unsigned DEFAULT '0' COMMENT '金币',
  `union_id` varchar(50) NOT NULL DEFAULT '' COMMENT '微信用户的unionId',
  PRIMARY KEY (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员信息表';


-- -----------------------------
-- Table structure for `ey_users_bottom_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_bottom_menu`;
CREATE TABLE `ey_users_bottom_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '功能开关状态，1=开启，0=关闭',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示, 1--是, 0--否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='会员中心移动端底部菜单表';

-- -----------------------------
-- Records of `ey_users_bottom_menu`
-- -----------------------------
INSERT INTO `ey_users_bottom_menu` VALUES ('1', '首页', 'home/Index/index', 'shouye', '100', '1', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_users_bottom_menu` VALUES ('2', '下载', 'user/Download/index', 'xiazai', '100', '1', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_users_bottom_menu` VALUES ('3', '发布', 'user/UsersRelease/article_add', 'fabu', '100', '1', '1', 'cn', '1614656192', '1614656192');
INSERT INTO `ey_users_bottom_menu` VALUES ('4', '我的', 'user/Users/centre', 'geren', '100', '1', '1', 'cn', '1614656192', '1614656192');

-- -----------------------------
-- Table structure for `ey_users_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_collection`;
CREATE TABLE `ey_users_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的收藏';


-- -----------------------------
-- Table structure for `ey_users_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_config`;
CREATE TABLE `ey_users_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会员功能配置表ID',
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置的value值',
  `desc` varchar(100) DEFAULT '' COMMENT '键名说明',
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='会员功能配置表';

-- -----------------------------
-- Records of `ey_users_config`
-- -----------------------------
INSERT INTO `ey_users_config` VALUES ('1', 'users_reg_notallow', 'www,bbs,ftp,mail,user,users,admin,administrator,eyoucms', '不允许注册的会员名', 'users', 'cn', '1547890773');
INSERT INTO `ey_users_config` VALUES ('2', 'score_signin_status', '1', '', 'score', 'cn', '1614656192');
INSERT INTO `ey_users_config` VALUES ('3', 'score_signin_score', '3', '', 'score', 'cn', '1614656192');
INSERT INTO `ey_users_config` VALUES ('4', 'shop_open', '0', '', 'shop', 'cn', '1638408547');
INSERT INTO `ey_users_config` VALUES ('5', 'pay_balance_open', '1', '', 'pay', 'cn', '1638408557');
INSERT INTO `ey_users_config` VALUES ('6', 'users_login_expiretime', '3600', '', 'users', 'cn', '1668570338');

-- -----------------------------
-- Table structure for `ey_users_footprint`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_footprint`;
CREATE TABLE `ey_users_footprint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` int(10) DEFAULT '0' COMMENT '频道模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目id',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `users_id` int(10) DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我的足迹';


-- -----------------------------
-- Table structure for `ey_users_forward`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_forward`;
CREATE TABLE `ey_users_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='转发记录';


-- -----------------------------
-- Table structure for `ey_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_level`;
CREATE TABLE `ey_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '类型，1=系统，0=用户',
  `amount` decimal(10,2) DEFAULT '0.00' COMMENT '消费额度',
  `down_count` int(10) DEFAULT '0' COMMENT '每天下载次数限制',
  `discount` float(10,2) DEFAULT '100.00' COMMENT '折扣率，初始值为100即100%，无折扣',
  `posts_count` int(10) DEFAULT '5' COMMENT '会员投稿次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='会员级别表';

-- -----------------------------
-- Records of `ey_users_level`
-- -----------------------------
INSERT INTO `ey_users_level` VALUES ('1', '注册会员', '10', '1', '0.00', '100', '100', '5', '1', '0', 'cn', '0', '1551151513');

-- -----------------------------
-- Table structure for `ey_users_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_like`;
CREATE TABLE `ey_users_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我喜欢的';


-- -----------------------------
-- Table structure for `ey_users_list`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_list`;
CREATE TABLE `ey_users_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员ID',
  `para_id` int(10) NOT NULL DEFAULT '0' COMMENT '属性ID',
  `info` text COMMENT '属性值',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员属性表(信息）';


-- -----------------------------
-- Table structure for `ey_users_menu`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_menu`;
CREATE TABLE `ey_users_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(30) DEFAULT '' COMMENT '导航名称',
  `version` varchar(10) DEFAULT 'weapp' COMMENT '分组',
  `mca` varchar(50) DEFAULT '' COMMENT '分组/控制器/操作名',
  `active_url` varchar(500) DEFAULT '' COMMENT '标记为选中的url',
  `is_userpage` tinyint(1) DEFAULT '0' COMMENT '默认会员首页',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态，1=显示，0=隐藏',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='会员菜单表';

-- -----------------------------
-- Records of `ey_users_menu`
-- -----------------------------
INSERT INTO `ey_users_menu` VALUES ('1', '个人信息', 'v1', 'user/Users/index', '', '1', '100', '1', 'cn', '1555904190', '1555917737');
INSERT INTO `ey_users_menu` VALUES ('2', '账户充值', 'v1', 'user/Pay/pay_consumer_details', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('3', '商城中心', 'v1', 'user/Shop/shop_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('4', '会员升级', 'v1', 'user/Level/level_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('5', '会员投稿', 'v1', 'user/UsersRelease/release_centre', '', '0', '100', '0', 'cn', '1555904190', '1555917761');
INSERT INTO `ey_users_menu` VALUES ('6', '我的下载', 'v1', 'user/Download/index', '', '0', '100', '1', 'cn', '1590484667', '1599182043');
INSERT INTO `ey_users_menu` VALUES ('7', '个人中心', 'v2', 'user/Users/index', 'user/Users/index|user/Pay/pay_account_recharge|user/Users/footprint_index|user/Level/level_centre|user/Download/index|user/Users/media_index', '1', '100', '1', 'cn', '1608708057', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('8', '我的信息', 'v2', 'user/Users/info', 'user/Users/info', '0', '100', '1', 'cn', '1608709100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('9', '我的收藏', 'v2', 'user/Users/collection_index', 'user/Users/collection_index', '0', '100', '1', 'cn', '1608708100', '1609385363');
INSERT INTO `ey_users_menu` VALUES ('10', '财务明细', 'v2', 'user/Pay/pay_consumer_details', 'user/Pay/pay_consumer_details|user/Users/score_index', '0', '100', '1', 'cn', '1608709000', '1609387813');
INSERT INTO `ey_users_menu` VALUES ('11', '我的收藏', 'v1', 'user/Users/collection_index', '', '0', '100', '1', 'cn', '1590484667', '1614651537');

-- -----------------------------
-- Table structure for `ey_users_money`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_money`;
CREATE TABLE `ey_users_money` (
  `moneyid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '金额明细表ID',
  `users_id` int(10) DEFAULT '0' COMMENT '会员表ID',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '金额',
  `users_money` decimal(10,2) DEFAULT '0.00' COMMENT '此条记录的账户金额',
  `cause` text COMMENT '事由，暂时在升级消费中使用到，以serialize序列化后存入，用于后续查询。',
  `cause_type` tinyint(1) DEFAULT '0' COMMENT '数据类型,0-消费,1-充值,2-退款,3-订单支付,4-管理员添加,5-管理员减少',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否成功，默认1，0失败，1未付款，2已付款，3已完成，4订单取消。',
  `pay_method` varchar(50) DEFAULT '' COMMENT '支付方式，wechat为微信支付，alipay为支付宝支付',
  `wechat_pay_type` varchar(20) NOT NULL DEFAULT '' COMMENT '微信支付时，标记使用的支付类型（扫码支付，微信内部，微信H5页面）',
  `pay_details` text COMMENT '支付时返回的数据，以serialize序列化后存入，用于后续查询。',
  `order_number` varchar(30) DEFAULT '' COMMENT '订单号',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员升级时所升级的会员级别ID，默认0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  PRIMARY KEY (`moneyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='金额明细表';


-- -----------------------------
-- Table structure for `ey_users_notice`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice`;
CREATE TABLE `ey_users_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text NOT NULL COMMENT '用户id',
  `usernames` text NOT NULL COMMENT '用户名字符串',
  `remark` text COMMENT '通知信息',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_read`;
CREATE TABLE `ey_users_notice_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `notice_id` int(10) DEFAULT NULL COMMENT '站内信id',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读, 1---是, 0---否',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除, 1---是, 0---否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户已读站内通知';


-- -----------------------------
-- Table structure for `ey_users_notice_tpl`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl`;
CREATE TABLE `ey_users_notice_tpl` (
  `tpl_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tpl_name` varchar(200) DEFAULT '' COMMENT '模板名称',
  `tpl_title` varchar(200) DEFAULT '' COMMENT '站内信标题',
  `tpl_content` text COMMENT '发送内容',
  `send_scene` tinyint(1) DEFAULT '0' COMMENT '站内信发送场景(1=留言表单）',
  `is_open` tinyint(1) DEFAULT '0' COMMENT '是否开启使用这个模板，1为是，0为否。',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='站内信模板表';

-- -----------------------------
-- Records of `ey_users_notice_tpl`
-- -----------------------------
INSERT INTO `ey_users_notice_tpl` VALUES ('1', '留言表单', '您有新的留言消息，请到内容管理中查看！', '${content}', '1', '1', 'cn', '1638408557', '1638408557');
INSERT INTO `ey_users_notice_tpl` VALUES ('5', '订单付款', '您有新的待发货订单消息，请到商城订单查看！', '${content}', '5', '1', 'cn', '1638408557', '1638408557');
INSERT INTO `ey_users_notice_tpl` VALUES ('6', '订单发货', '您有新的待收货订单消息，请到会员订单查看！', '${content}', '6', '1', 'cn', '1638408557', '1638408557');

-- -----------------------------
-- Table structure for `ey_users_notice_tpl_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_notice_tpl_content`;
CREATE TABLE `ey_users_notice_tpl_content` (
  `content_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `source` tinyint(1) DEFAULT '0' COMMENT '来源，对应 users_notice_tpl 表 send_scene 字段',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID，不为空则表示管理员接收信息',
  `users_id` int(10) DEFAULT '0' COMMENT '用户ID，不为空则表示会员接收信息，暂未使用',
  `content_title` varchar(200) DEFAULT '' COMMENT '通知标题',
  `content` text COMMENT '接收的通知内容',
  `is_read` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读，默认0，1是，0否',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`content_id`),
  KEY `admin_id` (`admin_id`) USING BTREE,
  KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='站内信发送接收记录表';


-- -----------------------------
-- Table structure for `ey_users_parameter`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_parameter`;
CREATE TABLE `ey_users_parameter` (
  `para_id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '是否为系统属性，系统属性不可删除，1为是，0为否，默认0。',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否禁用属性，1为是，0为否',
  `is_required` tinyint(1) DEFAULT '0' COMMENT '是否为必填属性，1为是，0为否，默认0。',
  `is_reg` tinyint(1) DEFAULT '1' COMMENT '是否为注册表单，1为是，0为否',
  `placeholder` varchar(255) DEFAULT '' COMMENT '提示文字',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`para_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='会员属性表(字段)';

-- -----------------------------
-- Records of `ey_users_parameter`
-- -----------------------------
INSERT INTO `ey_users_parameter` VALUES ('1', '手机号码', 'mobile_1', 'mobile', '', '1', '0', '0', '1', '', '1', 'cn', '0', '1599182043');
INSERT INTO `ey_users_parameter` VALUES ('2', '邮箱地址', 'email_2', 'email', '', '1', '0', '1', '1', '', '1', 'cn', '0', '1599182043');

-- -----------------------------
-- Table structure for `ey_users_score`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_score`;
CREATE TABLE `ey_users_score` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '积分明细表',
  `type` tinyint(1) DEFAULT '1' COMMENT '类型:1-提问,2-回答,3-最佳答案4-悬赏退回,5-每日签到,6-管理员编辑,7-问题悬赏/获得悬赏,9-积分兑换/退回',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `ask_id` int(10) DEFAULT '0' COMMENT '问题id',
  `reply_id` int(10) DEFAULT '0' COMMENT '回答id',
  `score` int(10) DEFAULT '0' COMMENT '积分',
  `devote` int(10) DEFAULT '0' COMMENT '贡献值,同score',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `info` varchar(255) DEFAULT '' COMMENT '说明',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) DEFAULT '0' COMMENT '更新时间',
  `current_score` int(10) DEFAULT '0' COMMENT '当前积分',
  `current_devote` int(10) DEFAULT '0' COMMENT '当前贡献值',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员表ID',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分详情表';


-- -----------------------------
-- Table structure for `ey_users_signin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_signin`;
CREATE TABLE `ey_users_signin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `lang` varchar(50) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '签到时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户签到表';


-- -----------------------------
-- Table structure for `ey_users_type_manage`
-- -----------------------------
DROP TABLE IF EXISTS `ey_users_type_manage`;
CREATE TABLE `ey_users_type_manage` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_name` varchar(30) DEFAULT '' COMMENT '类型名称',
  `level_id` int(10) DEFAULT '0' COMMENT '会员等级ID',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `limit_id` int(10) DEFAULT '0' COMMENT '会员期限限制，存储ID，值对应常量表的admin_member_limit_arr数组',
  `activity` varchar(30) DEFAULT '' COMMENT '活动文案',
  `sort_order` smallint(5) NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` varchar(20) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员产品类型表';


-- -----------------------------
-- Table structure for `ey_video_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_video_content`;
CREATE TABLE `ey_video_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `vdsrc` varchar(200) NOT NULL DEFAULT '' COMMENT '视频地址',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='附加表';

-- -----------------------------
-- Records of `ey_video_content`
-- -----------------------------
INSERT INTO `ey_video_content` VALUES ('1', '13', '1552364595', '1552364595', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('2', '14', '1552364689', '1552364689', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');
INSERT INTO `ey_video_content` VALUES ('3', '52', '1552382177', '1552382177', 'http://player.youku.com/embed/XMzU1NzU5MzM4MA==');
INSERT INTO `ey_video_content` VALUES ('4', '53', '1552382208', '1552382208', 'http://player.youku.com/embed/XMzYyOTQ2MjA5Mg==');

-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `position` varchar(30) DEFAULT 'default' COMMENT '插件位置',
  `is_buy` tinyint(1) DEFAULT '0' COMMENT '0-本地,1-线上购买 2-线上购买,但已删除,不显示在我的插件列表',
  `is_upgrade` tinyint(1) DEFAULT '1' COMMENT '是否提示升级',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件应用表';


-- -----------------------------
-- Table structure for `ey_weapp_ask`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask`;
CREATE TABLE `ey_weapp_ask` (
  `ask_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ask_title` varchar(80) NOT NULL DEFAULT '' COMMENT '问题标题',
  `is_recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题是否推荐',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '问题状态：0未解决，1已解决，2已关闭',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览点击量',
  `replies` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题回复量',
  `content` text NOT NULL COMMENT '问题内容',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '问题网址',
  `users_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '问题发布时IP地址',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关注问题则表示有回复时发送邮件通知到问题发布人',
  `solve_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '解决时间(这个问题存在最佳答案则表示已解决)',
  `bestanswer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最佳答案',
  `sort_order` int(10) NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`ask_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='问题表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_answer`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer`;
CREATE TABLE `ey_weapp_ask_answer` (
  `answer_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题栏目ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '1',
  `answer_pid` int(10) NOT NULL DEFAULT '0' COMMENT '子答案的父答案',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`answer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='答案表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_answer_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_answer_like`;
CREATE TABLE `ey_weapp_ask_answer_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `ask_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '问题ID',
  `answer_id` int(10) NOT NULL DEFAULT '0' COMMENT '答案ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='答案点赞表';


-- -----------------------------
-- Table structure for `ey_weapp_ask_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_type`;
CREATE TABLE `ey_weapp_ask_type` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目自增',
  `type_name` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级ID',
  `sort_order` int(10) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='问题栏目分类表';

-- -----------------------------
-- Records of `ey_weapp_ask_type`
-- -----------------------------
INSERT INTO `ey_weapp_ask_type` VALUES ('1', '问题求助', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('2', '功能建议', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('3', '业务咨询', '0', '100', '1565770890', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('4', 'BUG反馈', '1', '100', '1565771021', '1648617311');
INSERT INTO `ey_weapp_ask_type` VALUES ('5', '其他问题', '1', '100', '1565771021', '1648617311');

-- -----------------------------
-- Table structure for `ey_weapp_ask_users_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_ask_users_level`;
CREATE TABLE `ey_weapp_ask_users_level` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `level_name` varchar(30) DEFAULT '' COMMENT '级别名称',
  `level_value` int(10) DEFAULT '0' COMMENT '会员等级值',
  `ask_count` int(10) DEFAULT '5' COMMENT '发布问答次数限制',
  `answer_count` int(10) DEFAULT '0' COMMENT '回复问答次数限制',
  `ask_is_release` tinyint(1) DEFAULT '1' COMMENT '允许在问答中发布问题，1=是，0=否',
  `ask_is_review` tinyint(1) DEFAULT '0' COMMENT '在问答中发布问题或回答是否需要审核，1=是，0=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`level_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='上传记录表';


-- -----------------------------
-- Table structure for `ey_weapp_bshoucang`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_bshoucang`;
CREATE TABLE `ey_weapp_bshoucang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_collection`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_collection`;
CREATE TABLE `ey_weapp_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT NULL,
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `lang` varchar(50) DEFAULT '' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_collection`
-- -----------------------------
INSERT INTO `ey_weapp_collection` VALUES ('2', '2', '袋式除尘器处理风量是怎么计算', '29', 'cn', '1609829251', '1609829251');

-- -----------------------------
-- Table structure for `ey_weapp_comment`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment`;
CREATE TABLE `ey_weapp_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `is_bestanswer` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否最佳答案，0否，1是',
  `is_review` tinyint(1) NOT NULL DEFAULT '1' COMMENT '问题是否审核，1是，0否',
  `users_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论用户ID',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '评论用户名',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞量',
  `users_ip` varchar(30) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `content` text NOT NULL COMMENT '内容',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '子评论的父评论',
  `at_users_id` int(10) NOT NULL DEFAULT '0' COMMENT '被@的用户ID',
  `at_comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '@答案ID',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`comment_id`),
  KEY `aid` (`aid`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文档评论回复表';

-- -----------------------------
-- Records of `ey_weapp_comment`
-- -----------------------------
INSERT INTO `ey_weapp_comment` VALUES ('1', '439', '0', '1', '1', 'admin', '1', '127.0.0.1', '&lt;p&gt;&lt;span style=&quot;font-family: &amp;quot;Microsoft YaHei&amp;quot;, Arial, Helvetica, sans-serif; font-size: 15px; background-color: rgb(255, 255, 255);&quot;&gt;网站经过优化稳定后，在网站可用数据稳定上升的前提下，可以考虑增加交换更多的高权重友情链接。此时，友情链接的交换不能是单一的关键词链接，而是可以扩展网站的权限，追求多词多页权重的平均增加，从而帮助更多的收录和原创内容再次被收录到页面的内容排名中。&lt;/span&gt;&lt;/p&gt;', '0', '0', '0', '1627893894', '1628058396');

-- -----------------------------
-- Table structure for `ey_weapp_comment_level`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_level`;
CREATE TABLE `ey_weapp_comment_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_level_id` int(10) NOT NULL DEFAULT '0' COMMENT '会员级别ID',
  `is_comment` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否允许评论文档',
  `is_review` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论是否需要审核',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='评论级别表';

-- -----------------------------
-- Records of `ey_weapp_comment_level`
-- -----------------------------
INSERT INTO `ey_weapp_comment_level` VALUES ('1', '0', '0', '1', '1572418214', '1572418214');
INSERT INTO `ey_weapp_comment_level` VALUES ('2', '1', '1', '0', '1626925386', '0');
INSERT INTO `ey_weapp_comment_level` VALUES ('3', '2', '1', '0', '1626925386', '0');
INSERT INTO `ey_weapp_comment_level` VALUES ('4', '3', '1', '0', '1626925386', '0');

-- -----------------------------
-- Table structure for `ey_weapp_comment_like`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_comment_like`;
CREATE TABLE `ey_weapp_comment_like` (
  `like_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `comment_id` int(10) NOT NULL DEFAULT '0' COMMENT '评论ID',
  `users_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞用户ID',
  `click_like` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点赞',
  `users_ip` varchar(20) NOT NULL DEFAULT '' COMMENT '用户IP地址',
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`like_id`),
  KEY `aid` (`aid`,`comment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='文档评论点赞表';

-- -----------------------------
-- Records of `ey_weapp_comment_like`
-- -----------------------------
INSERT INTO `ey_weapp_comment_like` VALUES ('1', '439', '1', '1', '1', '127.0.0.1', '1628058396', '1628058396');

-- -----------------------------
-- Table structure for `ey_weapp_demo`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_demo`;
CREATE TABLE `ey_weapp_demo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_demo`
-- -----------------------------
INSERT INTO `ey_weapp_demo` VALUES ('2', '1', '易优CMS', 'http://www.eyoucms.com', '', '100', '1', '', '', '1', '0', '1524975826', '0');
INSERT INTO `ey_weapp_demo` VALUES ('3', '2', '织梦58', 'http://www.dede58.com', 'http://www.eyoucms.dev/public/upload/system/2018/04/29/814ece093a0ba636209255dc20bd6e62.png', '100', '0', '', '', '1', '0', '1524976095', '1524976135');
INSERT INTO `ey_weapp_demo` VALUES ('4', '1', 'ThinkPHP官网', 'http://www.thinkphp.cn', '', '100', '1', '', '', '1', '0', '1525266497', '1525266608');
INSERT INTO `ey_weapp_demo` VALUES ('5', '1', '微信小程序开发教程', 'http://www.yiyongtong.com', '', '100', '1', '', '', '1', '0', '1525748425', '0');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall`;
CREATE TABLE `ey_weapp_diyminipro_mall` (
  `mini_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '模板ID',
  `categoryid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '模板标题',
  `litpic` varchar(250) NOT NULL DEFAULT '' COMMENT '封面图',
  `component` text NOT NULL COMMENT '组件库',
  `mchid` varchar(50) NOT NULL DEFAULT '' COMMENT '微信支付商户号',
  `apikey` varchar(250) NOT NULL DEFAULT '' COMMENT '微信支付密钥',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态：4=审核中，5=发布',
  `cloud_id` int(10) NOT NULL DEFAULT '0' COMMENT '云ID',
  `config` text NOT NULL COMMENT '相关序列化信息',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`mini_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='微信小程序记录表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('3', '39', '购物商城', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', 'f1f0UQFSAwMDAwEJUgYFAgBWAAoIAQ8DU1BTVVFWC1dBAloPVBAfWl5SVlwxDFlRDwZJUFkMWQBDGhVfXlELThkCQRVYAV9WH1ReVgYWG0AKBwBdFBFSBENVChpeWhBQVgYfD1AUcVJBH0NQAQ1jUxsXSUFdEEEMUlNOWVZTDVpcAl8gUgFcRl1HHVsOBFldTwQQW1wHGwlYQAcaXFwSXHkKQBUdAVxGQ1xfFRENVkQTJApdXBEbBl5YFldZWwFLdxZHFV4MH1BcXUVYCwtSRCoOBFVdTlQKX0IDX15QFm1QG0c', '', '', '0', '58', 'eyJjb3B5cmlnaHQiOjEsIm1lYWxfdHlwZSI6MH0=', '0', 'cn', '1589423797', '1666759073');
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('4', '1', '默认商城风格', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', '8d9bBlFRVQYIVgkJAg5VAAcEAVNWAVdWWVNSUwZUVQwLVEAaFggLUlcRFVhATAwFDlcVQF0BBglNFwQEEFVcTgteRl8CBElYWRB7WEAUFw8BWm1TTBFPFQQWFwwBUxgACVBcXU0GEF9cAxVeXVcBFQ', '', '', '0', '2', '', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall` VALUES ('5', '1', '默认商城风格', 'https://service.eyysz.cn/uploads/allimg/20200514/1-200514103G4249.png', '8d9bBlFRVQYIVgkJAg5VAAcEAVNWAVdWWVNSUwZUVQwLVEAaFggLUlcRFVhATAwFDlcVQF0BBglNFwQEEFVcTgteRl8CBElYWRB7WEAUFw8BWm1TTBFPFQQWFwwBUxgACVBcXU0GEF9cAxVeXVcBFQ', '', '', '0', '2', '', '0', 'en', '1666758559', '1666758559');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_page`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_page`;
CREATE TABLE `ey_weapp_diyminipro_mall_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面id',
  `page_type` tinyint(3) NOT NULL DEFAULT '-1' COMMENT '页面类型(1首页 -1自定义页)',
  `page_name` varchar(255) NOT NULL DEFAULT '' COMMENT '页面名称',
  `page_data` longtext NOT NULL COMMENT '页面数据',
  `mini_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '微信小程序id',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设为首页：0=否，1=是',
  `is_system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统内置',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示：1=显示，0=隐藏',
  `is_del` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`page_id`),
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='微信小程序diy页面表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall_page`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('18', '7', '会员中心', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"type\":\"userCenter\",\"params\":{\"recomNum\":6,\"recomShow\":\"1\",\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('19', '6', '购物车', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8d2d\\u7269\\u8f66\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u8d2d\\u7269\\u8f66\",\"type\":\"cart\",\"params\":{\"recomNum\":6,\"recomShow\":1,\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('17', '4', '商品详情页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5546\\u54c1\\u8be6\\u60c5\\u9875\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u5546\\u54c1\\u8be6\\u60c5\\u9875\",\"type\":\"goodsDetails\",\"params\":{\"type\":\"phone\",\"phone_num\":\"\",\"recomNum\":6,\"recomShow\":1,\"titleArr\":[\"\\u4e0d\\u663e\\u793a\",\"\\u6700\\u65b0\",\"\\u63a8\\u8350\",\"\\u6700\\u70ed\"],\"recomTitle\":\"\\u53ef\\u80fd\\u4f60\\u8fd8\\u60f3\\u8981\"},\"style\":{\"show_type\":10,\"background\":\"#ffffff\"},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('16', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('15', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":\"10\"},\"style\":[]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('14', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8d2d\\u7269\\u5546\\u57ce\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"},\"id\":5},\"items\":[{\"name\":\"\\u56fe\\u7247\\u8f6e\\u64ad\",\"type\":\"banner\",\"style\":{\"btnColor\":\"#ffffff\",\"btnShape\":\"round\",\"imgHeights\":\"180\",\"show_type\":\"10\",\"imgHeightsType\":\"custom\"},\"params\":{\"interval\":\"2800\",\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"data\":[{\"litpic\":\"\\/uploads\\/allimg\\/20221016\\/1-221016091635D2.jpg\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"\\/uploads\\/allimg\\/20221018\\/1-22101Q01052524.jpg\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}]},{\"name\":\"\\u5bfc\\u822a\\u7ec4\",\"type\":\"navBar\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"background\":\"#ffffff\",\"rowsNum\":\"4\",\"show_type\":10},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Q3102.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u70ed\\u9500\\u4ea7\\u54c1\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c1\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Q9B6.png\",\"imgName\":\"icon-2.jpg\",\"url\":\"\",\"text\":\"\\u4f18\\u60e0\\u5238\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c2\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00RL44.png\",\"imgName\":\"icon-3.jpg\",\"url\":\"\",\"text\":\"\\u9650\\u65f6\\u62a2\\u8d2d\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c3\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00S4364.png\",\"imgName\":\"icon-4.jpg\",\"url\":\"\",\"text\":\"\\u5355\\u54c1\\u79d2\\u6740\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c4\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00T1123.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u670d\\u88c5\\u57ce\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c5\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00U2400.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u7535\\u5668\\u57ce\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c6\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00Z12M.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u6bcd\\u5a74\\u4e13\\u533a\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c7\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q00ZB36.png\",\"imgName\":\"icon-1.png\",\"url\":\"\",\"text\":\"\\u5168\\u90e8\\u5206\\u7c7b\",\"color\":\"#666666\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0},\"backgroundImage\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/navbar\\/03.png\",\"intro\":\"\\u526f\\u6587\\u672c8\",\"introcolor\":\"#666666\",\"background\":\"#ffffff\",\"bordercolor\":\"#eeeeee\"}]},{\"name\":\"\\u56fe\\u7247\\u6a71\\u7a97\",\"type\":\"window\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"0\",\"paddingLeft\":\"0\",\"background\":\"#ffffff\",\"layout\":\"3\"},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q0304X55.png\",\"url\":\"\\/pages\\/article\\/list?typeid=3\",\"pathconf\":{\"index\":\"article_list\",\"value\":\"3\",\"is_vars\":1}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q03056248.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05JY44.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}],\"dataNum\":4},{\"name\":\"\\u56fe\\u7247\\u6a71\\u7a97\",\"type\":\"window\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"0\",\"paddingLeft\":\"0\",\"background\":\"#ffffff\",\"layout\":\"4\"},\"data\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q051551H.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05201Z3.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q0520I23.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05214135.png\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}],\"dataNum\":4},{\"name\":\"\\u8f85\\u52a9\\u7a7a\\u767d\",\"type\":\"blank\",\"style\":{\"height\":\"10\",\"background\":\"#f4f4f4\"}},{\"name\":\"\\u5546\\u54c1\\u7ec4\",\"type\":\"goods\",\"params\":{\"source\":\"auto\",\"auto\":{\"orderby\":\"default\",\"showNum\":6},\"choice\":[],\"titleConf\":{\"typeid\":0,\"text\":\"\\u4e3a\\u60a8\\u63a8\\u8350\",\"url\":\"\",\"showhide\":\"show\"}},\"style\":{\"background\":\"#ffffff\",\"display\":\"list\",\"column\":\"2\",\"show\":{\"title\":\"1\",\"usersPrice\":\"1\",\"oldPrice\":\"1\",\"seoDescription\":\"0\",\"stockCount\":\"0\",\"salesNum\":\"0\"}},\"defaultData\":[{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"},{\"title\":\"\\u6b64\\u5904\\u663e\\u793a\\u5546\\u54c1\\u540d\\u79f0\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/goods\\/01.png\",\"users_price\":\"99.00\",\"old_price\":\"139.00\",\"seo_description\":\"\\u6b64\\u6b3e\\u5546\\u54c1\\u7f8e\\u89c2\\u5927\\u65b9 \\u4e0d\\u5bb9\\u9519\\u8fc7\",\"stock_count\":\"100\",\"sales_num\":\"10\"}],\"data\":[]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#e93b3d\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q059363L.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q05945328.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10215415.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u6211\\u7684\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/uploads\\/allimg\\/20200518\\/1-20051Q10223462.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}],\"id\":4},\"diyStyle\":{\"titleModel\":{\"style\":4,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '1', '1', '1', '0', 'cn', '1589423797', '1666062563');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('21', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u9875\\u9762\\u6807\\u9898\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[]}', '4', '1', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('22', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":20},\"style\":[]}]}', '4', '0', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('23', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}]}', '4', '0', '1', '1', '0', 'zh', '1666758479', '1666758479');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('24', '1', '首页', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u9875\\u9762\\u6807\\u9898\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[]}', '5', '1', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('25', '2', '分类频道', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"share_title\":\"\\u5206\\u7c7b\\u9891\\u9053\"}},\"items\":[{\"name\":\"\\u5206\\u7c7b\\u9891\\u9053\",\"type\":\"category\",\"params\":{\"show_type\":20},\"style\":[]}]}', '5', '0', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('26', '3', '联系我们', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"share_title\":\"\\u8054\\u7cfb\\u6211\\u4eec\"}},\"items\":[{\"name\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"type\":\"contact\",\"params\":{\"titleConf\":{\"text\":\"\\u6b64\\u5904\\u663e\\u793a\\u6807\\u9898\\u680f\\u540d\\u79f0\",\"showhide\":\"show\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"paddingTop\":\"10\",\"paddingLeft\":\"10\",\"background\":\"#ffffff\",\"borderBottomColor\":\"#eeeeee\"},\"data\":{\"logo\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/logo.png\",\"banner\":\"\\/weapp\\/DiyminiproMall\\/template\\/diyminipro\\/img\\/diy\\/contact\\/banner.png\",\"web_name\":\"\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u516c\\u53f8\",\"mobile\":\"13800000000\",\"weixin\":\"123456789\",\"qq\":\"10000\",\"email\":\"test@email.com\",\"address\":\"\\u6d77\\u5357\\u7701\\u6d77\\u53e3\\u5e02\",\"coordinate\":\"110.32552547126,20.044049439257\",\"nav_title\":\"\\u516c\\u53f8\\u7b80\\u4ecb\",\"content\":\"<p>&nbsp;&nbsp;&nbsp;&nbsp;\\u67d0\\u67d0\\u7f51\\u7edc\\u79d1\\u6280\\u6709\\u9650\\u516c\\u53f8\\u6210\\u7acb\\u4e8e2006\\u5e74\\uff0c\\u81f4\\u529b\\u884c\\u4e1a10\\u5e74\\uff0c\\u5f00\\u521b\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9\\u4e91\\u5e73\\u53f0\\uff0c\\u6253\\u9020\\u96c6\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u6280\\u672f\\u3001\\u4e91\\u7aef\\u67b6\\u6784\\u3001\\u6574\\u5408\\u8425\\u9500\\u4e3a\\u4e00\\u4f53\\u5546\\u4e1a\\u6a21\\u5f0f\\u3002\\u4f34\\u968f\\u7740\\u4e2d\\u56fd\\u4e92\\u8054\\u7f51\\u7684\\u6210\\u957f\\uff0c\\u7ecf\\u5386\\u4e86\\u4e92\\u8054\\u7f51\\u5feb\\u901f\\u53d1\\u5c55\\u768410\\u5e74\\uff0c\\u79ef\\u7d2f\\u4e86\\u96c4\\u539a\\u81ea\\u4e3b\\u7814\\u53d1\\u6280\\u672f\\u548c\\u4e30\\u5bcc\\u7684\\u54cd\\u5e94\\u5f0f\\u7f51\\u7ad9\\u5f00\\u53d1\\u6848\\u4f8b\\u3002<\\/p><p><br\\/><\\/p><p>&nbsp;&nbsp;&nbsp;&nbsp;\\u9762\\u5bf9\\u65e5\\u65b0\\u6708\\u5f02\\u7684\\u4e92\\u8054\\u7f51\\u8d8b\\u52bf\\uff0c2016\\u65d7\\u4e0b\\u201c\\u67d0\\u67d0\\u201c\\u54cd\\u5e94\\u5f0f\\u8425\\u9500\\u4e91\\u5e73\\u53f0\\uff0c\\u653b\\u514b\\u6280\\u672f\\u96be\\u9898\\uff0c\\u81ea\\u4e3b\\u6253\\u9020\\u4ee5SaaS\\u4e91\\u5e73\\u53f0\\u4e3a\\u6784\\u67b6\\uff0c\\u201c\\u5feb\\u901f\\u54cd\\u5e94\\u5f0f\\u5efa\\u7ad9+\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u201d\\u4e3a\\u6838\\u5fc3\\uff0c\\u4ece\\u8fc7\\u53bb\\u5c40\\u9650\\u7684\\u5b9a\\u5236\\u5efa\\u7ad9\\u8fd0\\u8425\\u8f6c\\u53d8\\u4e3a\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\uff0c\\u9886\\u5148\\u5b9e\\u73b0\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u6280\\u672f\\u548c\\u7f51\\u7ad9\\u53ef\\u89c6\\u5316\\u7f16\\u8f91\\u65b9\\u6848\\uff0c\\u4e0d\\u4ec5\\u63d0\\u4f9b\\u5168\\u8bbe\\u5907\\u667a\\u80fd\\u54cd\\u5e94\\u5f0f\\u7cfb\\u7edf\\u7684\\u529f\\u80fd\\uff0c\\u66f4\\u878d\\u5408\\u4e86\\u826f\\u597d\\u7684\\u7528\\u6237\\u4f53\\u9a8c\\u548c\\u591a\\u5c42\\u6b21\\u4f18\\u5316\\u6307\\u5bfc\\uff0c\\u6e17\\u900f\\u5230\\u4e92\\u8054\\u7f51+\\u7684\\u5168\\u7ef4\\u5ea6\\u6574\\u5408\\u8425\\u9500\\u8fd0\\u8425\\u7ba1\\u7406\\u4e2d\\uff0c\\u5176\\u521b\\u65b0\\u7684\\u5546\\u4e1a\\u6a21\\u5f0f\\u96c6\\u5408\\u4e86\\u4ea7\\u4e1a\\u94fe\\u7684\\u5173\\u952e\\u5143\\u7d20\\uff0c\\u771f\\u6b63\\u610f\\u4e49\\u4e0a\\u5177\\u5907\\u4e86\\u4f01\\u4e1a\\u53d1\\u5c55\\u9700\\u6c42\\u7684\\u6574\\u4f53\\u8425\\u9500\\uff0c\\u4e3a\\u4f01\\u4e1a\\u63d0\\u4f9b\\u591a\\u5143\\u3001\\u9ad8\\u6548\\u3001\\u6613\\u7528\\u7684\\u7f51\\u7ad9\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u6ee1\\u8db3\\u4f01\\u4e1a\\u5404\\u4e2a\\u9636\\u6bb5\\u4e0d\\u540c\\u53d8\\u5316\\u7684\\u7cfb\\u7edf\\u5347\\u7ea7\\u3002<\\/p>\"}}]}', '5', '0', '1', '1', '0', 'en', '1666758559', '1666758559');
INSERT INTO `ey_weapp_diyminipro_mall_page` VALUES ('20', '5', '直播列表', '{\"page\":{\"type\":\"page\",\"name\":\"\\u9875\\u9762\\u8bbe\\u7f6e\",\"params\":{\"title\":\"\\u76f4\\u64ad\\u5217\\u8868\",\"share_title\":\"\\u5206\\u4eab\\u6807\\u9898\"}},\"items\":[{\"name\":\"\\u76f4\\u64ad\\u5217\\u8868\\u9875\",\"type\":\"liveListp\",\"params\":{\"start\":1,\"showNum\":10,\"titleConf\":{\"text\":\"\\u76f4\\u64ad\\u5217\\u8868\\u9875\",\"showhide\":\"hide\",\"url\":\"\",\"pathconf\":{\"index\":\"default\",\"value\":\"\",\"is_vars\":0}}},\"style\":{\"background\":\"#ffffff\"},\"defaultData\":[{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"101\",\"live_status_text\":\"\\u76f4\\u64ad\\u4e2d\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/02.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":23.9},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":45}]},{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"102\",\"live_status_text\":\"\\u76f4\\u64ad\\u9884\\u544a\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/03.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":2591.9},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":4159}]},{\"name\":\"\\u4e3b\\u64ad\\u540d\\u79f0\",\"live_status\":\"103\",\"live_status_text\":\"\\u76f4\\u64ad\\u56de\\u653e\",\"title\":\"\\u76f4\\u64ad\\u95f4\\u6807\\u9898\",\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/04.jpg\",\"goodsList\":[{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo1.jpg\",\"price\":425},{\"litpic\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/diy\\/liveList\\/demo2.jpg\",\"price\":654}]}]}],\"tabbar\":{\"name\":\"\\u5e95\\u90e8\\u83dc\\u5355\\u7ec4\",\"type\":\"tabBar\",\"style\":{\"color\":\"#666666\",\"selectedColor\":\"#00aeff\",\"background\":\"#ffffff\"},\"adddata\":{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/custom-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},\"data\":[{\"pagePath\":\"\\/pages\\/index\\/index\",\"text\":\"\\u9996\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/home-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"index_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/category\\/index\",\"text\":\"\\u5206\\u7c7b\\u9875\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/cate-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"category_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/contact\\/index\",\"text\":\"\\u8054\\u7cfb\\u6211\\u4eec\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/contact.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/contact-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"contact_view\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/flow\\/index\",\"text\":\"\\u8d2d\\u7269\\u8f66\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/flow-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"flow_index\",\"value\":\"\",\"is_vars\":0}},{\"pagePath\":\"\\/pages\\/user\\/index\",\"text\":\"\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"iconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user.png\",\"selectedIconPath\":\"https:\\/\\/service.eyysz.cn\\/public\\/static\\/common\\/diyminipro\\/img\\/tabbar\\/user-active.png\",\"color\":\"\",\"selectedColor\":\"\",\"url\":\"\",\"pathconf\":{\"index\":\"user_index\",\"value\":\"\",\"is_vars\":0}}]},\"diyStyle\":{\"titleModel\":{\"style\":0,\"text\":{\"source\":\"default\",\"default\":{\"size\":15,\"color\":\"#000000\"},\"custom\":{\"size\":15,\"color\":\"#000000\"}},\"linesbackground\":\"#00aeff\"},\"commonModel\":{\"background\":\"#f4f4f4\",\"navtitleTextColor\":\"black\",\"navtitleBackgroundColor\":\"#ffffff\"}}}', '3', '0', '1', '1', '0', 'cn', '1604452245', '1604452245');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_setting`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_setting`;
CREATE TABLE `ey_weapp_diyminipro_mall_setting` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '页面组',
  `value` text NOT NULL COMMENT '组装之后的值',
  `mini_id` int(11) NOT NULL DEFAULT '0' COMMENT '小程序ID',
  `lang` varchar(10) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`name`) USING BTREE,
  KEY `mini_id` (`mini_id`,`lang`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='微信小程序多功能配置表';

-- -----------------------------
-- Records of `ey_weapp_diyminipro_mall_setting`
-- -----------------------------
INSERT INTO `ey_weapp_diyminipro_mall_setting` VALUES ('1', 'setting', '{\"tcp\":\"http\",\"domain\":\"www.scvip.net.cn\",\"root_dir\":\"\",\"name\":\"setting\",\"nid\":\"DiyminiproMall\",\"intro\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"mini_id\":3,\"email\":\"15898383@qq.com\",\"appId\":\"wx168903912112b207\",\"navTitle\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"username\":\"\\u7ba1\\u7406\\u5458\",\"mobile\":\"\",\"appSecret\":\"119c8c037962100f06e611c228181ae8\",\"originalId\":\"\",\"wechatId\":\"\",\"online_mini_id\":0,\"webviewdomain\":\"\",\"minipro\":\"DiyminiproMall\",\"status\":1,\"domain_api\":0,\"reason\":\"\",\"addTime\":1666683126,\"createminiproTime\":1666683261,\"auditid\":\"\",\"auditTime\":0,\"auditstatus\":3,\"miniproStatus\":3,\"estimateTime\":604800,\"version\":\"v4.20\",\"releaseTime\":0,\"template\":\"DiyminiproMall\",\"templateId\":223,\"component_info\":\"006dBANVAwIAAgkEUwZTCgUMUQFVBwNdBV4DCVROGltZXRVbXQBdRm9TSUQKVkMIEEJLVwRSAVtTDlIHXFRaAFBRARYfR1BdXUJWWgZcFW1TVlBREkdoTV1TBF5GDxoOBG9dcQZQYGJVWElMK2sEVFFZcQ1VeAd\\/aww4CCFqAFJUCQB3VVV5f31EDXEqalZza3ZBQSxAbwpxdRhGUm0LXHlkNlZ5AHJLRQMKQgp0AlhaTVRmCmxDdEZQG10idl9uTkZIYXgMUn9CdFt6VwsScUUDf3EYU1MUZHQPRxxbbGtPfAhZUDMBcQlfD0JVdFBLQUZxYjlcdn5zdil6RhkaWUNEDVtBDElXQm1YVwBXEkFtQVxfBFoVAxAOU281ZAxtWkhUB0cKellBYFxWFmMCX1hNan0SQAZYQk0qYA9mQVtHQCFBRhVaAwgHbQMPfwlxZ0J+UjJdZGt0ejtpLQFdZ2FDEXV7AGkffB9abQ5WFVgffEtcCnt5dHZbTHINf3RzegEcQQoHYlVkegh1JFcCVFpWS14IVlAUBWJXfQxDbWtzVwd6egF2BXZEQGU6YzdTc3B3eCV9FUQ\",\"authorizerInfo\":{\"nick_name\":\"\\u9b45\\u529b\\u9f99\\u51e4\",\"head_img\":\"http:\\/\\/wx.qlogo.cn\\/mmopen\\/zuIr8icwRPWFmpCgFsZVt9PeXPo6mMArnbQicgYmpDzAOHChgrlxibPCVseA2xcDQiceGVyXHcK9V0JLiaBibC2jiaZLW4icofdvtW9a\\/0\",\"service_type_info\":{\"id\":0},\"verify_type_info\":{\"id\":0},\"user_name\":\"gh_07bc9a3aac62\",\"alias\":\"\",\"qrcode_url\":\"http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/R0STiadkveico1hUksDhD88AR04Ol2DCaCSxetuO9XxX4pZflE5rGYNwP93MFLflM2hTrQUp9U9DGZd3eMSLc2NA\\/0\",\"business_info\":{\"open_pay\":0,\"open_shake\":0,\"open_scan\":0,\"open_card\":0,\"open_store\":0},\"idc\":1,\"principal_name\":\"\\u6c5f\\u6cb9\\u5e02\\u9f99\\u51e4\\u9547\\u4eba\\u6c11\\u653f\\u5e9c\",\"signature\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u53d1\\u5e03\\u5e73\\u53f0\\uff0c\\u4ea4\\u6d41\\u5e73\\u53f0\",\"MiniProgramInfo\":{\"network\":{\"RequestDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"WsRequestDomain\":[\"wss:\\/\\/gm.scvip.net.cn\",\"wss:\\/\\/service.eyysz.cn\",\"wss:\\/\\/www.scvip.net.cn\"],\"UploadDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"DownloadDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/service.eyysz.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"BizDomain\":[\"https:\\/\\/gm.scvip.net.cn\",\"https:\\/\\/www.scvip.net.cn\"],\"UDPDomain\":[\"udp:\\/\\/gm.scvip.net.cn\"],\"TCPDomain\":[\"tcp:\\/\\/gm.scvip.net.cn\"],\"PrefetchDNSDomain\":[],\"NewRequestDomain\":[],\"NewWsRequestDomain\":[],\"NewUploadDomain\":[],\"NewDownloadDomain\":[],\"NewBizDomain\":[],\"NewUDPDomain\":[],\"NewTCPDomain\":[],\"NewPrefetchDNSDomain\":[]},\"categories\":[{\"first\":\"\\u653f\\u52a1\\u6c11\\u751f\",\"second\":\"\\u515a\\/\\u56e2\\/\\u7ec4\\u7ec7\"}],\"visit_status\":0},\"register_type\":0,\"account_status\":1,\"basic_config\":{\"is_phone_configured\":true,\"is_email_configured\":true}},\"authorizerStatus\":1}', '3', 'cn', '1666058922', '1666759067');
INSERT INTO `ey_weapp_diyminipro_mall_setting` VALUES ('2', 'set_arctype', 'a:9:{i:0;s:1:\"3\";i:1;s:2:\"50\";i:2;s:1:\"2\";i:3;s:1:\"4\";i:4;s:2:\"10\";i:5;s:2:\"14\";i:6;s:2:\"15\";i:7;s:2:\"29\";i:8;s:1:\"1\";}', '3', 'cn', '1666058988', '1666058996');

-- -----------------------------
-- Table structure for `ey_weapp_diyminipro_mall_users`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_diyminipro_mall_users`;
CREATE TABLE `ey_weapp_diyminipro_mall_users` (
  `wxuser_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(100) NOT NULL DEFAULT '' COMMENT '微信昵称',
  `headimgurl` varchar(200) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`wxuser_id`),
  KEY `openid` (`openid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='微信小程序用户表';


-- -----------------------------
-- Table structure for `ey_weapp_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_keywords`;
CREATE TABLE `ey_weapp_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(100) DEFAULT '' COMMENT '关键词',
  `keywordsseo` varchar(255) DEFAULT '' COMMENT '关键词SEO扩展',
  `url` varchar(255) DEFAULT '' COMMENT '链接',
  `djl` int(10) NOT NULL DEFAULT '0' COMMENT '访问次数',
  `zt` int(1) NOT NULL DEFAULT '0' COMMENT '搜索页有无结果',
  `ssrk` int(1) NOT NULL DEFAULT '0' COMMENT '是否是用户搜索入库',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_keywords`
-- -----------------------------
INSERT INTO `ey_weapp_keywords` VALUES ('11', '布料机', '布料机,布料机打混凝土,布料机图片,布料机生产厂家混凝土布料机,布料机混凝土布料机,布料机多少钱一台,布料机型号及尺寸,布料机的使用与安装,布料机是干什么用的,布料机配件', '%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662432654', '1662432654');
INSERT INTO `ey_weapp_keywords` VALUES ('12', '液压布料机', '液压布料机,液压布料机多少钱一台,移动式液压布料机,内爬式液压布料机,移动液压布料机,液压布料机型号,液压布料机图片,液压布料机厂家,液压布料机安装调试视频,液压布料机租赁', '%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662432710', '1662432710');
INSERT INTO `ey_weapp_keywords` VALUES ('13', '混凝土布料机', '混凝土布料机,混凝土布料机价格,混凝土布料机图片,混凝土布料机型号有几种,混凝土布料机如何使用,混凝土布料机生产厂家,混凝土布料机重量,混凝土布料机方案,混凝土布料机公司,混凝土布料机盛基好', '%E6%B7%B7%E5%87%9D%E5%9C%9F%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662434049', '1662434049');
INSERT INTO `ey_weapp_keywords` VALUES ('14', '布料机厂家', '布料机厂家,混凝土布料机生产厂家,布料机型号及尺寸,淮安布料机厂家,布料机配件,布料机型号,布料机厂家直销,布料机报价,布料机厂家直销 布料机生产厂家', '%E5%B8%83%E6%96%99%E6%9C%BA%E5%8E%82%E5%AE%B6', '0', '0', '0', '0', '0', '0', '0', '1662434067', '1662434493');
INSERT INTO `ey_weapp_keywords` VALUES ('17', '布料机价格', '混凝土布料机价格,布料机多少钱一台,新型布料机图片,兰州混凝土布料机价格,定西混凝土布料机价格,布料机价格和图片,布料机价格厂家,布料机价格,新型布料机价格', '%E5%B8%83%E6%96%99%E6%9C%BA%E4%BB%B7%E6%A0%BC', '0', '0', '0', '0', '0', '0', '0', '1662442182', '1662442213');
INSERT INTO `ey_weapp_keywords` VALUES ('15', '混凝土布料机价格', '混凝土布料机价格,混凝土布料机图片,小型混凝土布料机,兰州混凝土布料机价格,定西混凝土布料机价格,电动混凝土布料机价格,布料机混凝土布料机,混凝土布料机如何使用,最先进混凝土布料机,混凝土布料机型号有几种', '%E6%B7%B7%E5%87%9D%E5%9C%9F%E5%B8%83%E6%96%99%E6%9C%BA%E4%BB%B7%E6%A0%BC', '0', '0', '0', '0', '0', '0', '0', '1662434086', '1662434086');
INSERT INTO `ey_weapp_keywords` VALUES ('16', '液压布料机型号', '液压布料机图片,混凝土液压布料机,液压布料机厂家,液压布料机租赁,液压布料机产品资料,移动式液压布料机,二手液压布料机,液压布料机多少钱一台,液压式混凝土布料机,新型液压布料机', '%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA%E5%9E%8B%E5%8F%B7', '0', '0', '0', '0', '0', '0', '0', '1662434119', '1662434532');
INSERT INTO `ey_weapp_keywords` VALUES ('18', '电梯井液压布料机', '电梯井布料机安装视频,电梯井布料机图片,电梯井布料机价格,电梯井布料机厂家,电梯井爬升式布料机,电梯井内爬式布料机安装', '%E7%94%B5%E6%A2%AF%E4%BA%95%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662442536', '1662442632');
INSERT INTO `ey_weapp_keywords` VALUES ('19', '楼面内爬液压布料机', '楼面内爬式布料机,楼面内爬式布料机安装视频,楼面内爬式布料机图片,楼面内爬式布料机价格,楼面内爬式布料机厂家,楼面内爬式布料机,楼面内爬式布料机安装', '%E6%A5%BC%E9%9D%A2%E5%86%85%E7%88%AC%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662442554', '1662442708');
INSERT INTO `ey_weapp_keywords` VALUES ('20', '移动液压布料机', '移动液压布料机价格,移动式液压布料机,液压布料机图片,混凝土液压布料机,液压布料机厂家,液压布料机租赁,液压布料机产品资料,二手液压布料机,液压布料机型号,液压布料机多少钱一台', '%E7%A7%BB%E5%8A%A8%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662442731', '1662442731');
INSERT INTO `ey_weapp_keywords` VALUES ('21', '车轮式布料机', '车轮式布料机,车轮式布料机价格,车轮式布料机厂家,行走式布料机,车轮式布料机图片,车轮式布料机安装,车轮式混凝土布料机,车轮式布料机操作方法,车轮式布料机说明书', '%E8%BD%A6%E8%BD%AE%E5%BC%8F%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662442748', '1662442866');
INSERT INTO `ey_weapp_keywords` VALUES ('22', '内爬液压布料机', '内爬液压布料机需不需要缆风绳,内爬式混凝土液压布料机,液压布料机图片,混凝土液压布料机,液压布料机厂家,液压布料机租赁,液压布料机产品资料,移动式液压布料机,二手液压布料机,液压布料机多少钱一台', '%E5%86%85%E7%88%AC%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662442906', '1662442906');
INSERT INTO `ey_weapp_keywords` VALUES ('24', '船用布料机', '混凝土船用布料机,船用混凝土布料机价格,布料机图片,船用布料机安装，液压布料机,贵阳布料机,船用用什么布料,布料机打混凝土,布料机安装视频,布料机多少钱一台', '%E8%88%B9%E7%94%A8%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662443027', '1662443083');
INSERT INTO `ey_weapp_keywords` VALUES ('25', '模架液压布料机', '模架液压布料机图片,模架混凝土液压布料机,液压布料机厂家,液压布料机租赁,液压布料机产品资料,移动式液压布料机,二手液压布料机,液压布料机型号,液压布料机多少钱一台,液压式混凝土布料机', '%E6%A8%A1%E6%9E%B6%E6%B6%B2%E5%8E%8B%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662443246', '1662443285');
INSERT INTO `ey_weapp_keywords` VALUES ('26', '塔式混凝土布料机', '塔式混凝土布料机价格,布料机混凝土布料机,混凝土布料机图片,混凝土布料机如何使用,塔式布料机图片,塔式布料机价格,中联塔式布料机,塔式皮带布料机,塔式布料机安装视频,塔式布料机22米图片', '%E5%A1%94%E5%BC%8F%E6%B7%B7%E5%87%9D%E5%9C%9F%E5%B8%83%E6%96%99%E6%9C%BA', '0', '0', '0', '0', '0', '0', '0', '1662443304', '1662443304');
INSERT INTO `ey_weapp_keywords` VALUES ('28', '专用制梁布料机', '路桥专用制梁布料机,专用制梁布料机价格,专用制梁布料机厂家,制梁布料机图片，制梁布料机报价', '%E8%B7%AF%E6%A1%A5%E4%B8%93%E7%94%A8%E5%88%B6%E6%A2%81%E5%B8%83%E6%96%99%E6%9C%BA', '1', '0', '0', '0', '0', '0', '0', '1662443345', '1662443495');

-- -----------------------------
-- Table structure for `ey_weapp_linkkeyword`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_linkkeyword`;
CREATE TABLE `ey_weapp_linkkeyword` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '关键词',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '链接地址',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(1=启用，0=禁用)',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;


-- -----------------------------
-- Table structure for `ey_weapp_messages`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages`;
CREATE TABLE `ey_weapp_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '通知标题',
  `users_id` text COMMENT '通知用户账号',
  `remark` text COMMENT '通知信息',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_messages_read`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_messages_read`;
CREATE TABLE `ey_weapp_messages_read` (
  `messages_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` varchar(50) DEFAULT NULL COMMENT '用户账号',
  `id` int(10) DEFAULT NULL COMMENT '站内信id',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`messages_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_minicount`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount`;
CREATE TABLE `ey_weapp_minicount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` int(10) DEFAULT '0' COMMENT '今天流量',
  `total` int(10) DEFAULT '0' COMMENT '总流量',
  `dayline` int(10) DEFAULT '0',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `users_id` (`dayline`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount`
-- -----------------------------
INSERT INTO `ey_weapp_minicount` VALUES ('1', '3', '3', '1', '1524975826', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_minicount_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minicount_log`;
CREATE TABLE `ey_weapp_minicount_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT '',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_minicount_log`
-- -----------------------------
INSERT INTO `ey_weapp_minicount_log` VALUES ('1', '127.0.0.1', '1600738682', '1600738692');

-- -----------------------------
-- Table structure for `ey_weapp_minipro0002`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_minipro0002`;
CREATE TABLE `ey_weapp_minipro0002` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT '' COMMENT '页面组',
  `value` text COMMENT '组装之后的值',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='插件小程序0002表';

-- -----------------------------
-- Records of `ey_weapp_minipro0002`
-- -----------------------------
INSERT INTO `ey_weapp_minipro0002` VALUES ('1', 'minipro', '{\"username\":\"\\u8303\\u4e2d\\u6797\",\"email\":\"jymjzx@126.com\",\"mobile\":\"13990166543\",\"appId\":\"wx168903912112b207\",\"appSecret\":\"119c8c037962100f06e611c228181ae8\",\"originalId\":\"gh_07bc9a3aac62\",\"wechatId\":\"\",\"tcp\":\"https\",\"domain\":\"gm.scvip.net.cn\",\"mini_id\":0,\"online_mini_id\":0,\"root_dir\":\"\",\"webviewdomain\":\"gm.scvip.net.cn\",\"intro\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"navTitle\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u7f51\",\"minipro\":\"Minipro0002\",\"status\":1,\"domain_api\":0,\"reason\":\"\",\"addTime\":1665983178,\"createminiproTime\":0,\"auditid\":\"\",\"auditTime\":0,\"auditstatus\":3,\"miniproStatus\":2,\"estimateTime\":604800,\"version\":\"\",\"releaseTime\":0,\"template\":\"Minipro0002\",\"templateId\":144,\"component_info\":\"5006BVIGVlVVUwAAVlUNUAtXBAJVBldQDFMBVFIeFFJXX0haDFMIEToCQEAPBxYIGhFKBVRUUlRUUldWCARUCV5TXBdOFAUKCBNfXgMNQG1ZBVEDQkE7QloPAQ8SXxQHCW1KVjZXPFwMIHgAP1RfClUtHzFuBjJFWzcQBUAOBUgKQ0B8OGkvPCI6AWkKLGxoDCcACnNhUGNUMgIsXyRCfgBYYgEGURYHAzdjRgFQa2ZnHF0DQmFUeWYvBilID1l5YXF9eSQBP1UAMHdDMlNgYF0RY1NUZFd5QAkONURXXFZ7elZlLWJVVAsAUn1REEBrejJ0NXZVJXd0My45EkkUUE1GUFoQXxwAFzxRUwUGR0FnEl0NVFxGDBdSVT50UWVnU1x6d1tlJyg6PFhIKS4ZURUtazF3cwUCVFJcVG8LAG4OXFcMKnUDVTQ3WnoIAWBKUTRxCkh0F2JYLgAnXgpHWGkfb18beARdElpvQlYkf0ABIwsLBlQgdFBUNFRYUn1iTB9LBhtiPBdTFgFqFSdfC3sHBxwCf11bACcwEQBIA3BUdEINBnISLQRXA1o+L3pbeSF2N3R1Rks\",\"authorizerInfo\":{\"nick_name\":\"\\u9b45\\u529b\\u9f99\\u51e4\",\"head_img\":\"http:\\/\\/wx.qlogo.cn\\/mmopen\\/zuIr8icwRPWFmpCgFsZVt9PeXPo6mMArnbQicgYmpDzAOHChgrlxibPCVseA2xcDQiceGVyXHcK9V0JLiaBibC2jiaZLW4icofdvtW9a\\/0\",\"service_type_info\":{\"id\":0},\"verify_type_info\":{\"id\":0},\"user_name\":\"gh_07bc9a3aac62\",\"alias\":\"\",\"qrcode_url\":\"http:\\/\\/mmbiz.qpic.cn\\/mmbiz_jpg\\/R0STiadkveico1hUksDhD88AR04Ol2DCaCSxetuO9XxX4pZflE5rGYNwP93MFLflM2hTrQUp9U9DGZd3eMSLc2NA\\/0\",\"business_info\":{\"open_pay\":0,\"open_shake\":0,\"open_scan\":0,\"open_card\":0,\"open_store\":0},\"idc\":1,\"principal_name\":\"\\u6c5f\\u6cb9\\u5e02\\u9f99\\u51e4\\u9547\\u4eba\\u6c11\\u653f\\u5e9c\",\"signature\":\"\\u9f99\\u51e4\\u4fe1\\u606f\\u53d1\\u5e03\\u5e73\\u53f0\\uff0c\\u4ea4\\u6d41\\u5e73\\u53f0\",\"MiniProgramInfo\":{\"network\":{\"RequestDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"WsRequestDomain\":[\"wss:\\/\\/gm.scvip.net.cn\"],\"UploadDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"DownloadDomain\":[\"https:\\/\\/gm.scvip.net.cn\"],\"BizDomain\":[],\"UDPDomain\":[\"udp:\\/\\/gm.scvip.net.cn\"],\"TCPDomain\":[\"tcp:\\/\\/gm.scvip.net.cn\"],\"PrefetchDNSDomain\":[],\"NewRequestDomain\":[],\"NewWsRequestDomain\":[],\"NewUploadDomain\":[],\"NewDownloadDomain\":[],\"NewBizDomain\":[],\"NewUDPDomain\":[],\"NewTCPDomain\":[],\"NewPrefetchDNSDomain\":[]},\"categories\":[{\"first\":\"\\u653f\\u52a1\\u6c11\\u751f\",\"second\":\"\\u515a\\/\\u56e2\\/\\u7ec4\\u7ec7\"}],\"visit_status\":0},\"register_type\":0,\"account_status\":1,\"basic_config\":{\"is_phone_configured\":true,\"is_email_configured\":true}},\"authorizerStatus\":1}', '1665983176', '1665983746');

-- -----------------------------
-- Table structure for `ey_weapp_multicity`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_multicity`;
CREATE TABLE `ey_weapp_multicity` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '表id',
  `topid` int(10) DEFAULT '0' COMMENT '顶级ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '父id',
  `name` varchar(32) DEFAULT '' COMMENT '地区名称',
  `level` tinyint(4) DEFAULT '0' COMMENT '地区等级 分省市县区',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态（1：开启，0：隐藏）',
  `is_hot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否热门',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '城市目录',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=404 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_multicity`
-- -----------------------------
INSERT INTO `ey_weapp_multicity` VALUES ('31', '21', '21', '无锡市', '2', '1', '0', 'wuxi', '无锡市混凝土布料机厂家', '无锡市混凝土布料机价格,无锡混凝土布料机,无锡混凝土布料机厂家', '无锡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1652178546', '1655083631');
INSERT INTO `ey_weapp_multicity` VALUES ('30', '22', '22', '中山区', '3', '1', '0', 'zhongshan', '中山区', '中山区布料机价格,中山区液压布料机,中山区液压布料机厂家', '中山区布料机专业生产厂家联系电话：17858811257', '100', '1652178529', '1655083040');
INSERT INTO `ey_weapp_multicity` VALUES ('29', '22', '22', '玄武湖区', '3', '1', '0', 'xuanwuhuqu', '玄武湖区液压布料机厂家', '玄武湖区布料机价格,玄武湖区液压布料机,玄武湖区液压布料机厂家', '玄武湖区布料机专业生产厂家联系电话：17858811257', '100', '1652178510', '1655082644');
INSERT INTO `ey_weapp_multicity` VALUES ('28', '27', '27', '上海市', '2', '1', '0', 'shs', '上海液压布料机厂家', '上海布料机价格,上海液压布料机,上海液压布料机厂家', '上海布料机专业生产厂家联系电话：17858811257', '100', '1652178474', '1655099437');
INSERT INTO `ey_weapp_multicity` VALUES ('21', '0', '0', '江苏省', '1', '1', '0', 'jss', '江苏省液压布料机厂家', '江苏省布料机价格,江苏省液压布料机,江苏省液压布料机厂家', '江苏省布料机专业生产厂家联系电话：17858811257', '5', '1651929303', '1655099305');
INSERT INTO `ey_weapp_multicity` VALUES ('22', '21', '21', '南京市', '2', '1', '0', 'nanjingshi', '南京液压布料机厂家', '南京布料机价格,南京液压布料机,南京液压布料机厂家', '南京布料机专业生产厂家联系电话：17858811257', '100', '1651929318', '1655082152');
INSERT INTO `ey_weapp_multicity` VALUES ('23', '22', '22', '雨花台区', '3', '1', '0', 'yuhuataiqu', '雨花台液压布料机厂家', '雨花台布料机价格,雨花台液压布料机,雨花台液压布料机厂家', '雨花台布料机专业生产厂家联系电话：17858811257', '100', '1651929328', '1655082310');
INSERT INTO `ey_weapp_multicity` VALUES ('27', '0', '0', '上海市', '1', '1', '0', 'shanghai', '上海', '上海', '上海', '100', '1652008705', '1655080594');
INSERT INTO `ey_weapp_multicity` VALUES ('32', '0', '0', '安徽省', '1', '1', '0', 'ahs', '安徽省混凝土布料机厂家', '安徽省混凝土布料机价格,安徽省混凝土布料机,安徽省混凝土布料机厂家', '安徽省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078313', '1655099813');
INSERT INTO `ey_weapp_multicity` VALUES ('33', '32', '32', '合肥市', '2', '1', '0', 'hfs', '合肥市混凝土布料机厂家', '合肥市混凝土布料机价格,合肥市混凝土布料机,合肥市混凝土布料机厂家', '合肥市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078483', '1655099967');
INSERT INTO `ey_weapp_multicity` VALUES ('34', '21', '21', '徐州市', '2', '1', '0', 'xuzhoushi', '徐州液压布料机厂家', '徐州布料机价格,徐州液压布料机,徐州液压布料机厂家', '徐州布料机专业生产厂家联系电话：17858811257', '100', '1655078597', '1655083882');
INSERT INTO `ey_weapp_multicity` VALUES ('35', '21', '21', '常州市', '2', '1', '0', 'changzhoushi', '常州市混凝土布料机厂家', '常州混凝土布料机价格,常州混凝土布料机,常州混凝土布料机厂家', '常州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078620', '1655085638');
INSERT INTO `ey_weapp_multicity` VALUES ('36', '21', '21', '苏州市', '2', '1', '0', 'suzhoushi', '苏州液压布料机厂家', '苏州布料机价格,苏州液压布料机,苏州液压布料机厂家', '苏州布料机专业生产厂家联系电话：17858811257', '100', '1655078636', '1655085619');
INSERT INTO `ey_weapp_multicity` VALUES ('37', '21', '21', '南通市', '2', '1', '0', 'nantongshi', '南通混凝土布料机厂家', '南通混凝土布料机价格,南通混凝土布料机,南通混凝土布料机厂家', '南通混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655078656', '1655085015');
INSERT INTO `ey_weapp_multicity` VALUES ('38', '21', '21', '连云港市', '2', '1', '0', 'lianyungang', '连云港液压布料机厂家', '连云港布料机价格,连云港液压布料机,连云港液压布料机厂家', '连云港布料机专业生产厂家联系电话：17858811257', '100', '1655079160', '1655085085');
INSERT INTO `ey_weapp_multicity` VALUES ('39', '28', '28', '黄浦区', '3', '1', '0', 'hp', '黄浦区液压布料机厂家', '黄浦区布料机价格,黄浦区液压布料机,黄浦区液压布料机厂家', '黄浦区布料机专业生产厂家联系电话：17858811257', '100', '1655085561', '1655085561');
INSERT INTO `ey_weapp_multicity` VALUES ('40', '28', '28', '徐汇区', '3', '1', '0', 'xhq', '徐汇区混凝土布料机厂家', '徐汇混凝土布料机价格,徐汇混凝土布料机,徐汇混凝土布料机厂家', '徐汇区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655085936', '1655085936');
INSERT INTO `ey_weapp_multicity` VALUES ('41', '28', '28', '长宁区', '3', '1', '0', 'clq', '长宁区液压布料机厂家', '长宁区布料机价格,长宁区液压布料机,长宁区液压布料机厂家', '长宁区布料机专业生产厂家联系电话：17858811257', '100', '1655086068', '1655086068');
INSERT INTO `ey_weapp_multicity` VALUES ('42', '28', '28', '静安区', '3', '1', '0', 'jaq', '静安区液压布料机厂家', '静安区布料机价格,静安区液压布料机,静安区液压布料机厂家', '静安区布料机专业生产厂家联系电话：17858811257', '100', '1655086482', '1655086482');
INSERT INTO `ey_weapp_multicity` VALUES ('43', '28', '28', '普陀区', '3', '1', '0', 'ptq', '普陀区液压布料机厂家', '普陀区布料机价格,普陀区液压布料机,普陀区液压布料机厂家', '普陀区布料机专业生产厂家联系电话：17858811257', '100', '1655086643', '1655086643');
INSERT INTO `ey_weapp_multicity` VALUES ('44', '28', '28', '虹口区', '3', '1', '0', 'hkq', '虹口区液压布料机厂家', '虹口区布料机价格,虹口区液压布料机,虹口区液压布料机厂家', '虹口区布料机专业生产厂家联系电话：17858811257', '100', '1655088752', '1655088752');
INSERT INTO `ey_weapp_multicity` VALUES ('47', '28', '28', '杨浦区', '3', '1', '0', 'yp', '杨浦区混凝土布料机厂家', '杨浦区混凝土布料机价格,杨浦区混凝土布料机,杨浦区混凝土布料机厂家', '杨浦区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655089323', '1655089323');
INSERT INTO `ey_weapp_multicity` VALUES ('46', '28', '28', '浦东新区', '3', '1', '0', 'ptxq', '浦东新区液压布料机厂家', '浦东新区布料机价格,浦东新区液压布料机,浦东新区液压布料机厂家', '浦东新区布料机专业生产厂家联系电话：17858811257', '100', '1655089160', '1655089160');
INSERT INTO `ey_weapp_multicity` VALUES ('48', '28', '28', '闵行区', '3', '1', '0', 'mhq', '闵行区液压布料机厂家', '闵行区布料机价格,闵行区液压布料机,闵行区液压布料机厂家', '闵行区布料机专业生产厂家联系电话：17858811257', '100', '1655089457', '1655089457');
INSERT INTO `ey_weapp_multicity` VALUES ('49', '28', '28', '宝山区', '3', '1', '0', 'bsq', '宝山区混凝土布料机厂家', '宝山区混凝土布料机价格,宝山区混凝土布料机,宝山区混凝土布料机厂家', '宝山区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655089724', '1655089724');
INSERT INTO `ey_weapp_multicity` VALUES ('50', '28', '28', '嘉定区', '3', '1', '0', 'jdq', '嘉定区液压布料机厂家', '嘉定区布料机价格,嘉定区液压布料机,嘉定区液压布料机厂家', '嘉定区布料机专业生产厂家联系电话：17858811257', '100', '1655089836', '1655089836');
INSERT INTO `ey_weapp_multicity` VALUES ('51', '28', '28', '金山区', '3', '1', '0', 'jsq', '金山区液压布料机厂家', '金山区布料机价格,金山区液压布料机,金山区液压布料机厂家', '金山区布料机专业生产厂家联系电话：17858811257', '100', '1655089938', '1655089938');
INSERT INTO `ey_weapp_multicity` VALUES ('52', '28', '28', '松江区', '3', '1', '0', 'sjq', '松江区液压布料机厂家', '松江区布料机价格,松江区液压布料机,松江区液压布料机厂家', '松江区布料机专业生产厂家联系电话：17858811257', '100', '1655090045', '1655090045');
INSERT INTO `ey_weapp_multicity` VALUES ('53', '28', '28', '青浦区', '3', '1', '0', 'qpq', '青浦区混凝土布料机厂家', '青浦区混凝土布料机价格,青浦区混凝土布料机,青浦区混凝土布料机厂家', '青浦区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090322', '1655090322');
INSERT INTO `ey_weapp_multicity` VALUES ('54', '28', '28', '奉贤区', '3', '1', '0', 'fxq', '奉贤区混凝土布料机厂家', '奉贤区混凝土布料机价格,奉贤区混凝土布料机,奉贤区混凝土布料机厂家', '奉贤区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090427', '1655090427');
INSERT INTO `ey_weapp_multicity` VALUES ('55', '28', '28', '崇明区', '3', '1', '0', 'cmq', '崇明区混凝土布料机厂家', '崇明区混凝土布料机价格,崇明区混凝土布料机,崇明区混凝土布料机厂家', '崇明区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655090489', '1655090489');
INSERT INTO `ey_weapp_multicity` VALUES ('56', '21', '21', '淮安', '2', '1', '0', 'wa', '淮安市混凝土布料机厂家', '淮安市混凝土布料机价格,淮安市混凝土布料机,淮安市混凝土布料机厂家', '淮安市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655097935', '1655097935');
INSERT INTO `ey_weapp_multicity` VALUES ('57', '21', '21', '盐城市', '2', '1', '0', 'yc', '盐城市液压布料机厂家', '盐城市布料机价格,盐城市液压布料机,盐城市液压布料机厂家', '盐城市布料机专业生产厂家联系电话：17858811257', '100', '1655098121', '1655098121');
INSERT INTO `ey_weapp_multicity` VALUES ('58', '21', '21', '扬州市', '2', '1', '0', 'yzs', '扬州市混凝土布料机厂家', '扬州市混凝土布料机价格,扬州市混凝土布料机,扬州市混凝土布料机厂家', '扬州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098232', '1655098232');
INSERT INTO `ey_weapp_multicity` VALUES ('59', '21', '21', '镇江市', '2', '1', '0', 'zjs', '镇江市液压布料机厂家', '镇江市混凝土布料机价格,镇江市混凝土布料机,镇江市混凝土布料机厂家', '镇江市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098309', '1655098309');
INSERT INTO `ey_weapp_multicity` VALUES ('60', '21', '21', '泰州市', '2', '1', '0', 'tzs', '泰州市混凝土布料机厂家', '泰州市混凝土布料机价格,泰州市混凝土布料机,泰州市混凝土布料机厂家', '泰州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655098436', '1655098436');
INSERT INTO `ey_weapp_multicity` VALUES ('61', '21', '21', '宿迁市', '2', '1', '0', 'sqs', '宿迁市液压布料机厂家', '宿迁市布料机价格,宿迁市液压布料机,宿迁市液压布料机厂家', '宿迁市布料机专业生产厂家联系电话：17858811257', '100', '1655098681', '1655098681');
INSERT INTO `ey_weapp_multicity` VALUES ('62', '0', '0', '浙江省', '1', '1', '0', 'zj', '浙江省液压布料机厂家', '浙江省布料机价格,浙江省液压布料机,浙江省液压布料机厂家', '浙江省布料机专业生产厂家联系电话：17858811257', '100', '1655098805', '1655100142');
INSERT INTO `ey_weapp_multicity` VALUES ('63', '62', '62', '杭州市', '2', '1', '0', 'hzs', '杭州市混凝土布料机厂家', '杭州市混凝土布料机价格,杭州市混凝土布料机,杭州市混凝土布料机厂家', '杭州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655100230', '1655100230');
INSERT INTO `ey_weapp_multicity` VALUES ('64', '62', '62', '宁波市', '2', '1', '0', 'nbs', '宁波市液压布料机厂家', '宁波市布料机价格,宁波市液压布料机,宁波市液压布料机厂家', '宁波市布料机专业生产厂家联系电话：17858811257', '100', '1655101124', '1655101124');
INSERT INTO `ey_weapp_multicity` VALUES ('65', '62', '62', '温州市', '2', '1', '0', 'wzs', '温州市液压布料机厂家', '温州市布料机价格,温州市液压布料机,温州市液压布料机厂家', '温州市布料机专业生产厂家联系电话：17858811257', '100', '1655101203', '1655101203');
INSERT INTO `ey_weapp_multicity` VALUES ('66', '62', '62', '嘉兴市', '2', '1', '0', 'jxs', '嘉兴市混凝土布料机厂家', '嘉兴市混凝土布料机价格,嘉兴市混凝土布料机,嘉兴市混凝土布料机厂家', '嘉兴市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655101307', '1655101307');
INSERT INTO `ey_weapp_multicity` VALUES ('67', '62', '62', '湖州市', '2', '1', '0', 'huzs', '湖州市液压布料机厂家', '湖州市布料机价格,湖州市液压布料机,湖州市液压布料机厂家', '湖州市布料机专业生产厂家联系电话：17858811257', '100', '1655101600', '1655101600');
INSERT INTO `ey_weapp_multicity` VALUES ('68', '62', '62', '绍兴市', '2', '1', '0', 'sxs', '绍兴市混凝土布料机厂家', '绍兴市混凝土布料机价格,绍兴市混凝土布料机,绍兴市混凝土布料机厂家', '绍兴市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102448', '1655102448');
INSERT INTO `ey_weapp_multicity` VALUES ('69', '62', '62', '金华市', '2', '1', '0', 'jhs', '金华市液压布料机厂家', '金华市布料机价格,金华市液压布料机,金华市液压布料机厂家', '金华市布料机专业生产厂家联系电话：17858811257', '100', '1655102558', '1655102558');
INSERT INTO `ey_weapp_multicity` VALUES ('70', '62', '62', '衢州市', '2', '1', '0', 'qzs', '衢州市混凝土布料机厂家', '衢州市混凝土布料机价格,衢州市混凝土布料机,衢州市混凝土布料机厂家', '衢州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102650', '1655102650');
INSERT INTO `ey_weapp_multicity` VALUES ('71', '62', '62', '舟山市', '2', '1', '0', 'zss', '舟山市液压布料机厂家', '舟山市布料机价格,舟山市液压布料机,舟山市液压布料机厂家', '舟山市布料机专业生产厂家联系电话：17858811257', '100', '1655102723', '1655102723');
INSERT INTO `ey_weapp_multicity` VALUES ('72', '62', '62', '台州市', '2', '1', '0', 'tz', '台州市液压布料机厂家', '台州市布料机价格,台州市液压布料机,台州市液压布料机厂家', '台州市布料机专业生产厂家联系电话：17858811257', '100', '1655102796', '1655102796');
INSERT INTO `ey_weapp_multicity` VALUES ('73', '62', '62', '丽水市', '2', '1', '0', 'ls', '丽水市混凝土布料机厂家', '丽水市混凝土布料机价格,丽水市混凝土布料机,丽水市混凝土布料机厂家', '丽水市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655102871', '1655102871');
INSERT INTO `ey_weapp_multicity` VALUES ('74', '32', '32', '马鞍山市', '2', '1', '0', 'mas', '马鞍山市混凝土布料机厂家', '马鞍山市混凝土布料机价格,马鞍山市混凝土布料机,马鞍山市混凝土布料机厂家', '马鞍山市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655103721', '1655103762');
INSERT INTO `ey_weapp_multicity` VALUES ('75', '32', '32', '淮北市', '2', '1', '0', 'hb', '淮北市液压布料机厂家', '淮北市布料机价格,淮北市液压布料机,淮北市液压布料机厂家', '淮北市布料机专业生产厂家联系电话：17858811257', '100', '1655103919', '1655103961');
INSERT INTO `ey_weapp_multicity` VALUES ('76', '32', '32', '宿州市', '2', '1', '0', 'sz', '宿州市液压布料机厂家', '宿州市布料机价格,宿州市液压布料机,宿州市液压布料机厂家', '宿州市布料机专业生产厂家联系电话：17858811257', '100', '1655104042', '1655104042');
INSERT INTO `ey_weapp_multicity` VALUES ('77', '32', '32', '阜阳市', '2', '1', '0', 'fys', '阜阳市混凝土布料机厂家', '阜阳市混凝土布料机价格,阜阳市混凝土布料机,阜阳市混凝土布料机厂家', '阜阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655105710', '1655105710');
INSERT INTO `ey_weapp_multicity` VALUES ('78', '32', '32', '蚌埠市', '2', '1', '0', 'bbs', '蚌埠市液压布料机厂家', '蚌埠市布料机价格,蚌埠市液压布料机,蚌埠市液压布料机厂家', '蚌埠市布料机专业生产厂家联系电话：17858811257', '100', '1655106025', '1655106025');
INSERT INTO `ey_weapp_multicity` VALUES ('79', '32', '32', '淮南市', '2', '1', '0', 'hns', '淮南市混凝土布料机厂家', '淮南市混凝土布料机价格,淮南市混凝土布料机,淮南市混凝土布料机厂家', '淮南市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106118', '1655106118');
INSERT INTO `ey_weapp_multicity` VALUES ('80', '32', '32', '滁州市', '2', '1', '0', 'czs', '滁州市混凝土布料机厂家', '滁州市混凝土布料机价格,滁州市混凝土布料机,滁州市混凝土布料机厂家', '滁州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106243', '1655106243');
INSERT INTO `ey_weapp_multicity` VALUES ('81', '32', '32', '六安市', '2', '1', '0', 'las', '六安市液压布料机厂家', '六安市布料机价格,六安市液压布料机,六安市液压布料机厂家', '六安市布料机专业生产厂家联系电话：17858811257', '100', '1655106328', '1655106328');
INSERT INTO `ey_weapp_multicity` VALUES ('82', '32', '32', '巢湖市', '2', '1', '0', 'chs', '巢湖市混凝土布料机厂家', '巢湖市混凝土布料机价格,巢湖市混凝土布料机,巢湖市混凝土布料机厂家', '巢湖市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106705', '1655106705');
INSERT INTO `ey_weapp_multicity` VALUES ('83', '32', '32', '芜湖市', '2', '1', '0', 'whs', '芜湖市混凝土布料机厂家', '芜湖市混凝土布料机价格,芜湖市混凝土布料机,芜湖市混凝土布料机厂家', '芜湖市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106846', '1655106846');
INSERT INTO `ey_weapp_multicity` VALUES ('84', '32', '32', '亳州市', '2', '1', '0', 'hz', '亳州市混凝土布料机厂家', '亳州市混凝土布料机价格,亳州市混凝土布料机,亳州市混凝土布料机厂家', '亳州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655106978', '1655106978');
INSERT INTO `ey_weapp_multicity` VALUES ('85', '32', '32', '安庆市', '2', '1', '0', 'aqs', '安庆市液压布料机厂家', '安庆市布料机价格,安庆市液压布料机,安庆市液压布料机厂家', '安庆市布料机专业生产厂家联系电话：17858811257', '100', '1655107049', '1655107049');
INSERT INTO `ey_weapp_multicity` VALUES ('86', '32', '32', '池州市', '2', '1', '0', 'cz', '池州市液压布料机厂家', '池州市布料机价格,池州市液压布料机,池州市液压布料机厂家', '池州市布料机专业生产厂家联系电话：17858811257', '100', '1655107131', '1655107131');
INSERT INTO `ey_weapp_multicity` VALUES ('87', '32', '32', '铜陵市', '2', '1', '0', 'tls', '铜陵市混凝土布料机厂家', '铜陵市混凝土布料机价格,铜陵市混凝土布料机,铜陵市混凝土布料机厂家', '铜陵市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655107636', '1655107636');
INSERT INTO `ey_weapp_multicity` VALUES ('88', '32', '32', '宣城市', '2', '1', '0', 'xcs', '宣城市液压布料机厂家', '宣城市布料机价格,宣城市液压布料机,宣城市液压布料机厂家', '宣城市布料机专业生产厂家联系电话：17858811257', '100', '1655107718', '1655107718');
INSERT INTO `ey_weapp_multicity` VALUES ('89', '32', '32', '黄山市', '2', '1', '0', 'hss', '黄山市液压布料机厂家', '黄山市布料机价格,黄山市液压布料机,黄山市液压布料机厂家', '黄山市布料机专业生产厂家联系电话：17858811257', '100', '1655107885', '1655107885');
INSERT INTO `ey_weapp_multicity` VALUES ('90', '0', '0', '广东省', '1', '1', '0', 'gds', '广东省液压布料机厂家', '广东省布料机价格,广东省液压布料机,广东省液压布料机厂家', '广东省布料机专业生产厂家联系电话：17858811257', '100', '1655108165', '1655108165');
INSERT INTO `ey_weapp_multicity` VALUES ('91', '90', '90', '广州市', '2', '1', '0', 'gzs', '广州液压布料机厂家', '广州布料机价格,广州液压布料机,广州液压布料机厂家', '广州布料机专业生产厂家联系电话：17858811257', '100', '1655108235', '1655108235');
INSERT INTO `ey_weapp_multicity` VALUES ('92', '90', '90', '深圳市', '2', '1', '0', 'szs', '深圳市混凝土布料机厂家', '深圳市混凝土布料机价格,深圳市混凝土布料机,深圳市混凝土布料机厂家', '深圳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655108360', '1655108360');
INSERT INTO `ey_weapp_multicity` VALUES ('93', '90', '90', '珠海市', '2', '1', '0', 'zhs', '珠海市液压布料机厂家', '珠海市布料机价格,珠海市液压布料机,珠海市液压布料机厂家', '珠海市布料机专业生产厂家联系电话：17858811257', '100', '1655108491', '1655108491');
INSERT INTO `ey_weapp_multicity` VALUES ('94', '90', '90', '汕头市', '2', '1', '0', 'sts', '汕头市混凝土布料机厂家', '汕头市混凝土布料机价格,汕头市混凝土布料机,汕头市混凝土布料机厂家', '汕头市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655109162', '1655109162');
INSERT INTO `ey_weapp_multicity` VALUES ('95', '90', '90', '佛山市', '2', '1', '0', 'fss', '佛山液压布料机厂家', '佛山布料机价格,佛山液压布料机,佛山液压布料机厂家', '佛山布料机专业生产厂家联系电话：17858811257', '100', '1655109448', '1655109448');
INSERT INTO `ey_weapp_multicity` VALUES ('96', '90', '90', '韶关市', '2', '1', '0', 'sgs', '韶关混凝土布料机厂家', '韶关混凝土布料机价格,韶关混凝土布料机,韶关混凝土布料机厂家', '韶关混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655109637', '1655109637');
INSERT INTO `ey_weapp_multicity` VALUES ('97', '90', '90', '湛江市', '2', '1', '0', 'zanj', '湛江液压布料机厂家', '湛江布料机价格,湛江液压布料机,湛江液压布料机厂家', '湛江布料机专业生产厂家联系电话：17858811257', '100', '1655109903', '1655109903');
INSERT INTO `ey_weapp_multicity` VALUES ('98', '90', '90', '肇庆市', '2', '1', '0', 'zqs', '肇庆市混凝土布料机厂家', '肇庆市混凝土布料机价格,肇庆市混凝土布料机,肇庆市混凝土布料机厂家', '肇庆市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655167284', '1655167284');
INSERT INTO `ey_weapp_multicity` VALUES ('99', '90', '90', '江门市', '2', '1', '0', 'jms', '江门市液压布料机厂家', '江门布料机价格,江门液压布料机,江门液压布料机厂家', '江门布料机专业生产厂家联系电话：17858811257', '100', '1655168283', '1655168283');
INSERT INTO `ey_weapp_multicity` VALUES ('100', '90', '90', '茂名市', '2', '1', '0', 'mms', '茂名市混凝土布料机厂家', '茂名混凝土布料机价格,茂名混凝土布料机,茂名混凝土布料机厂家', '茂名混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655168887', '1655168887');
INSERT INTO `ey_weapp_multicity` VALUES ('101', '90', '90', '惠州市', '2', '1', '0', 'huz', '惠州市液压布料机厂家', '惠州布料机价格,惠州液压布料机,惠州液压布料机厂家\r\n', '惠州布料机专业生产厂家联系电话：17858811257', '100', '1655168978', '1655168978');
INSERT INTO `ey_weapp_multicity` VALUES ('102', '90', '90', '梅州市', '2', '1', '0', 'mzs', '梅州市混凝土布料机厂家', '梅州市混凝土布料机价格,梅州混凝土布料机,梅州混凝土布料机厂家', '梅州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655170606', '1655170606');
INSERT INTO `ey_weapp_multicity` VALUES ('103', '90', '90', '汕尾市', '2', '1', '0', 'sw', '汕尾市液压布料机厂家', '汕尾布料机价格,汕尾液压布料机,汕尾液压布料机厂家', '汕尾市布料机专业生产厂家联系电话：17858811257', '100', '1655170776', '1655170776');
INSERT INTO `ey_weapp_multicity` VALUES ('105', '90', '90', '河源市', '2', '1', '0', 'hy', '河源市液压布料机厂家', '河源布料机价格,河源液压布料机,河源液压布料机厂家', '河源布料机专业生产厂家联系电话：17858811257', '100', '1655171593', '1655171593');
INSERT INTO `ey_weapp_multicity` VALUES ('106', '90', '90', '阳江市', '2', '1', '0', 'yjs', '阳江混凝土布料机厂家', '阳江混凝土布料机价格,阳江混凝土布料机,阳江混凝土布料机厂家', '阳江混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172208', '1655172208');
INSERT INTO `ey_weapp_multicity` VALUES ('107', '90', '90', '清远市', '2', '1', '0', 'qy', '清远混凝土布料机厂家', '清远混凝土布料机价格,清远混凝土布料机,清远混凝土布料机厂家', '清远混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172272', '1655172272');
INSERT INTO `ey_weapp_multicity` VALUES ('108', '90', '90', '东莞市', '2', '1', '0', 'dgs', '东莞市混凝土布料机厂家', '东莞市混凝土布料机价格,东莞市混凝土布料机,东莞市混凝土布料机厂家', '东莞市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172584', '1655172584');
INSERT INTO `ey_weapp_multicity` VALUES ('109', '90', '90', '中山市', '2', '1', '0', 'zs', '中山市液压布料机厂家', '中山市布料机价格,中山市液压布料机,中山市液压布料机厂家', '中山市布料机专业生产厂家联系电话：17858811257', '100', '1655172657', '1655172657');
INSERT INTO `ey_weapp_multicity` VALUES ('110', '90', '90', '潮州市', '2', '1', '0', 'caz', '潮州市混凝土布料机厂家', '潮州混凝土布料机价格,潮州混凝土布料机,潮州混凝土布料机厂家', '潮州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172723', '1655172723');
INSERT INTO `ey_weapp_multicity` VALUES ('111', '90', '90', '揭阳市', '2', '1', '0', 'jys', '揭阳市液压布料机厂家', '揭阳市布料机价格,揭阳市液压布料机,揭阳市液压布料机厂家', '揭阳市布料机专业生产厂家联系电话：17858811257', '100', '1655172787', '1655172787');
INSERT INTO `ey_weapp_multicity` VALUES ('112', '90', '90', '云浮市', '2', '1', '0', 'yfs', '云浮市混凝土布料机厂家', '云浮市混凝土布料机价格,云浮市混凝土布料机,云浮市混凝土布料机厂家', '云浮市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655172854', '1655172854');
INSERT INTO `ey_weapp_multicity` VALUES ('113', '0', '0', '天津市', '1', '1', '0', 'tjs', '天津市液压布料机厂家', '天津市布料机价格,天津市液压布料机,天津市液压布料机厂家', '天津市布料机专业生产厂家联系电话：17858811257', '100', '1655173208', '1655173208');
INSERT INTO `ey_weapp_multicity` VALUES ('114', '0', '0', '重庆市', '1', '1', '0', 'cqs', '重庆市混凝土布料机厂家', '重庆市混凝土布料机价格,重庆市混凝土布料机,重庆市混凝土布料机厂家', '重庆市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655173272', '1655173272');
INSERT INTO `ey_weapp_multicity` VALUES ('115', '0', '0', '湖北省', '1', '1', '0', 'hbs', '湖北省液压布料机厂家', '湖北省布料机价格,湖北省液压布料机,湖北省液压布料机厂家', '湖北省布料机专业生产厂家联系电话：17858811257', '100', '1655173362', '1655173362');
INSERT INTO `ey_weapp_multicity` VALUES ('116', '115', '115', '武汉市', '2', '1', '0', 'wh', '武汉市混凝土布料机厂家', '武汉市混凝土布料机价格,武汉市混凝土布料机,武汉市混凝土布料机厂家', '武汉市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655173574', '1655173574');
INSERT INTO `ey_weapp_multicity` VALUES ('118', '115', '115', '黄石市', '2', '1', '0', 'hs', '黄石市混凝土布料机厂家', '黄石市混凝土布料机价格,黄石市混凝土布料机,黄石市混凝土布料机厂家', '黄石市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655176082', '1655176082');
INSERT INTO `ey_weapp_multicity` VALUES ('119', '115', '115', '十堰市', '2', '1', '0', 'sy', '十堰市液压布料机厂家', '十堰布料机价格,十堰液压布料机,十堰液压布料机厂家', '十堰布料机专业生产厂家联系电话：17858811257', '100', '1655176138', '1655176138');
INSERT INTO `ey_weapp_multicity` VALUES ('120', '115', '115', '宜昌市', '2', '1', '0', 'ycs', '宜昌混凝土布料机厂家', '宜昌混凝土布料机价格,宜昌混凝土布料机,宜昌混凝土布料机厂家', '宜昌混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655183905', '1655183905');
INSERT INTO `ey_weapp_multicity` VALUES ('121', '115', '115', '襄阳市', '2', '1', '0', 'xys', '襄阳市液压布料机厂家', '襄阳市布料机价格,襄阳市液压布料机,襄阳市液压布料机厂家', '襄阳市布料机专业生产厂家联系电话：17858811257', '100', '1655183999', '1655183999');
INSERT INTO `ey_weapp_multicity` VALUES ('122', '115', '115', '鄂州市', '2', '1', '0', 'ezs', '鄂州市混凝土布料机厂家', '鄂州混凝土布料机价格,鄂州混凝土布料机,鄂州混凝土布料机厂家', '鄂州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655184167', '1655184167');
INSERT INTO `ey_weapp_multicity` VALUES ('123', '115', '115', '荆门市', '2', '1', '0', 'jm', '荆门市液压布料机厂家', '荆门布料机价格,荆门液压布料机,荆门液压布料机厂家', '荆门布料机专业生产厂家联系电话：17858811257', '100', '1655184839', '1655184839');
INSERT INTO `ey_weapp_multicity` VALUES ('124', '115', '115', '孝感市', '2', '1', '0', 'xgs', '孝感市混凝土布料机厂家', '孝感混凝土布料机价格,孝感混凝土布料机,孝感混凝土布料机厂家', '孝感混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185032', '1655185032');
INSERT INTO `ey_weapp_multicity` VALUES ('125', '115', '115', '荆州市', '2', '1', '0', 'jz', '荆州混凝土布料机厂家', '荆州混凝土布料机价格,荆州混凝土布料机,荆州混凝土布料机厂家', '荆州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185133', '1655185133');
INSERT INTO `ey_weapp_multicity` VALUES ('126', '115', '115', '黄冈市', '2', '1', '0', 'hgs', '黄冈液压布料机厂家', '黄冈布料机价格,黄冈液压布料机,黄冈液压布料机厂家', '黄冈布料机专业生产厂家联系电话：17858811257', '100', '1655185212', '1655185581');
INSERT INTO `ey_weapp_multicity` VALUES ('127', '115', '115', '咸宁市', '2', '1', '0', 'xn', '咸宁市混凝土布料机厂家', '咸宁市混凝土布料机价格,咸宁市混凝土布料机,咸宁市混凝土布料机厂家', '咸宁市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655185272', '1655185272');
INSERT INTO `ey_weapp_multicity` VALUES ('128', '115', '115', '随州市', '2', '1', '0', 'suz', '随州市液压布料机厂家', '随州市布料机价格,随州市液压布料机,随州市液压布料机厂家', '随州市布料机专业生产厂家联系电话：17858811257', '100', '1655185901', '1655185901');
INSERT INTO `ey_weapp_multicity` VALUES ('129', '115', '115', '恩施土家族苗族自治州', '2', '1', '0', 'es', '恩施土家族苗族自治州液压布料机厂家', '恩施土家族苗族自治州布料机价格,恩施土家族苗族自治州液压布料机,恩施土家族苗族自治州液压布料机厂家', '恩施土家族苗族自治州布料机专业生产厂家联系电话：17858811257', '100', '1655185990', '1655185990');
INSERT INTO `ey_weapp_multicity` VALUES ('130', '0', '0', '河南省', '1', '1', '0', 'hn', '河南省液压布料机厂家', '河南省布料机价格,河南省液压布料机,河南省液压布料机厂家', '河南省布料机专业生产厂家联系电话：17858811257', '100', '1655186157', '1655186157');
INSERT INTO `ey_weapp_multicity` VALUES ('131', '130', '130', '郑州市', '2', '1', '0', 'zz', '郑州市混凝土布料机厂家', '郑州市混凝土布料机价格,郑州市混凝土布料机,郑州市混凝土布料机厂家', '郑州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655186220', '1655186220');
INSERT INTO `ey_weapp_multicity` VALUES ('132', '130', '130', '开封市', '2', '1', '0', 'kf', '开封市液压布料机厂家', '开封市布料机价格,开封市液压布料机,开封市液压布料机厂家', '开封市布料机专业生产厂家联系电话：17858811257', '100', '1655186315', '1655186315');
INSERT INTO `ey_weapp_multicity` VALUES ('133', '130', '130', '洛阳市', '2', '1', '0', 'ly', '洛阳市液压布料机厂家', '洛阳市布料机价格,洛阳市液压布料机,洛阳市液压布料机厂家', '洛阳市布料机专业生产厂家联系电话：17858811257', '100', '1655186399', '1655186399');
INSERT INTO `ey_weapp_multicity` VALUES ('134', '130', '130', '平顶山市', '2', '1', '0', 'pdss', '平顶山市液压布料机厂家', '平顶山市布料机价格,平顶山市液压布料机,平顶山市液压布料机厂家', '平顶山市布料机专业生产厂家联系电话：17858811257', '100', '1655191816', '1655191816');
INSERT INTO `ey_weapp_multicity` VALUES ('135', '130', '130', '焦作市', '2', '1', '0', 'jzs', '焦作市混凝土布料机厂家', '焦作市混凝土布料机价格,焦作市混凝土布料机,焦作市混凝土布料机厂家', '焦作市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655191941', '1655191941');
INSERT INTO `ey_weapp_multicity` VALUES ('136', '130', '130', '鹤壁市', '2', '1', '0', 'hebi', '鹤壁市液压布料机厂家', '鹤壁市布料机价格,鹤壁市液压布料机,鹤壁市液压布料机厂家', '鹤壁市布料机专业生产厂家联系电话：17858811257', '100', '1655192147', '1655192147');
INSERT INTO `ey_weapp_multicity` VALUES ('137', '130', '130', '新乡市', '2', '1', '0', 'xxs', '新乡市混凝土布料机厂家', '新乡市混凝土布料机价格,新乡市混凝土布料机,新乡市混凝土布料机厂家', '新乡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192225', '1655192225');
INSERT INTO `ey_weapp_multicity` VALUES ('138', '130', '130', '安阳市', '2', '1', '0', 'ays', '安阳市液压布料机厂家', '安阳市布料机价格,安阳市液压布料机,安阳市液压布料机厂家', '安阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192342', '1655192342');
INSERT INTO `ey_weapp_multicity` VALUES ('139', '130', '130', '濮阳市', '2', '1', '0', 'pys', '濮阳市液压布料机厂家', '濮阳市布料机价格,濮阳市液压布料机,濮阳市液压布料机厂家', '濮阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192495', '1655192495');
INSERT INTO `ey_weapp_multicity` VALUES ('140', '130', '130', '许昌市', '2', '1', '0', 'xc', '许昌市混凝土布料机厂家', '许昌市混凝土布料机价格,许昌市混凝土布料机,许昌市混凝土布料机厂家', '许昌市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192546', '1655192546');
INSERT INTO `ey_weapp_multicity` VALUES ('141', '130', '130', '漯河市', '2', '1', '0', 'lh', '漯河市混凝土布料机厂家', '漯河市混凝土布料机价格,漯河市混凝土布料机,漯河市混凝土布料机厂家', '漯河市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192610', '1655192610');
INSERT INTO `ey_weapp_multicity` VALUES ('142', '130', '130', '三门峡市', '2', '1', '0', 'smx', '三门峡市液压布料机厂家', '三门峡市布料机价格,三门峡市液压布料机,三门峡市液压布料机厂家', '三门峡市布料机专业生产厂家联系电话：17858811257', '100', '1655192713', '1655192713');
INSERT INTO `ey_weapp_multicity` VALUES ('143', '130', '130', '南阳市', '2', '1', '0', 'nys', '南阳市混凝土布料机厂家', '南阳市混凝土布料机价格,南阳市混凝土布料机,南阳市混凝土布料机厂家', '南阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655192800', '1655192800');
INSERT INTO `ey_weapp_multicity` VALUES ('144', '130', '130', '商丘市', '2', '1', '0', 'sq', '商丘市液压布料机厂家', '商丘市布料机价格,商丘市液压布料机,商丘市液压布料机厂家', '商丘市布料机专业生产厂家联系电话：17858811257', '100', '1655192857', '1655192857');
INSERT INTO `ey_weapp_multicity` VALUES ('145', '130', '130', '信阳市', '2', '1', '0', 'xy', '信阳市液压布料机厂家', '信阳市布料机价格,信阳市液压布料机,信阳市液压布料机厂家', '信阳市布料机专业生产厂家联系电话：17858811257', '100', '1655192949', '1655192949');
INSERT INTO `ey_weapp_multicity` VALUES ('146', '130', '130', '周口市', '2', '1', '0', 'zk', '周口市液压布料机厂家', '周口市布料机价格,周口市液压布料机,周口市液压布料机厂家', '周口市布料机专业生产厂家联系电话：17858811257', '100', '1655193085', '1655193085');
INSERT INTO `ey_weapp_multicity` VALUES ('147', '130', '130', '驻马店市', '2', '1', '0', 'zmd', '驻马店市混凝土布料机厂家', '驻马店市混凝土布料机价格,驻马店市混凝土布料机,驻马店市混凝土布料机厂家', '驻马店市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655193239', '1655193239');
INSERT INTO `ey_weapp_multicity` VALUES ('148', '130', '130', '济源市', '2', '1', '0', 'qys', '济源市液压布料机厂家', '济源市布料机价格,济源市液压布料机,济源市液压布料机厂家', '济源市布料机专业生产厂家联系电话：17858811257', '100', '1655193328', '1655193328');
INSERT INTO `ey_weapp_multicity` VALUES ('149', '0', '0', '福建省', '1', '1', '0', 'fjs', '福建液压布料机厂家', '福建布料机价格,福建液压布料机,福建液压布料机厂家', '福建布料机专业生产厂家联系电话：17858811257', '100', '1655252985', '1655252985');
INSERT INTO `ey_weapp_multicity` VALUES ('150', '149', '149', '福州市', '2', '1', '0', 'fzs', '福州液压布料机厂家', '福州布料机价格,福州液压布料机,福州液压布料机厂家', '福州布料机专业生产厂家联系电话：17858811257', '100', '1655253106', '1655253106');
INSERT INTO `ey_weapp_multicity` VALUES ('151', '149', '149', '莆田市', '2', '1', '0', 'pt', '莆田混凝土布料机厂家', '莆田混凝土布料机价格,莆田混凝土布料机,莆田混凝土布料机厂家', '莆田混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655253347', '1655253347');
INSERT INTO `ey_weapp_multicity` VALUES ('152', '149', '149', '泉州市', '2', '1', '0', 'qz', '泉州液压布料机厂家', '泉州布料机价格,泉州液压布料机,泉州液压布料机厂家', '泉州布料机专业生产厂家联系电话：17858811257', '100', '1655253639', '1655253639');
INSERT INTO `ey_weapp_multicity` VALUES ('153', '149', '149', '漳州市', '2', '1', '0', 'zzs', '漳州液压布料机厂家', '漳州布料机价格,漳州液压布料机,漳州液压布料机厂家', '漳州布料机专业生产厂家联系电话：17858811257', '100', '1655253810', '1655253810');
INSERT INTO `ey_weapp_multicity` VALUES ('154', '149', '149', '龙岩市', '2', '1', '0', 'lys', '龙岩混凝土布料机厂家', '龙岩混凝土布料机价格,龙岩混凝土布料机,龙岩混凝土布料机厂家', '龙岩混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655253969', '1655253969');
INSERT INTO `ey_weapp_multicity` VALUES ('155', '149', '149', '三明市', '2', '1', '0', 'sms', '三明液压布料机厂家', '三明布料机价格,三明液压布料机,三明液压布料机厂家', '三明布料机专业生产厂家联系电话：17858811257', '100', '1655254021', '1655254021');
INSERT INTO `ey_weapp_multicity` VALUES ('156', '149', '149', '南平市', '2', '1', '0', 'nps', '南平液压布料机厂家', '南平布料机价格,南平液压布料机,南平液压布料机厂家', '南平布料机专业生产厂家联系电话：17858811257', '100', '1655255346', '1655255346');
INSERT INTO `ey_weapp_multicity` VALUES ('157', '149', '149', '宁德市', '2', '1', '0', 'nds', '宁德市混凝土布料机厂家', '宁德市混凝土布料机价格,宁德市混凝土布料机,宁德市混凝土布料机厂家', '宁德市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655255444', '1655255444');
INSERT INTO `ey_weapp_multicity` VALUES ('177', '168', '168', '沧州市', '2', '1', '0', 'cangzhou', '沧州液压布料机厂家', '沧州布料机价格,沧州液压布料机,沧州液压布料机厂家', '沧州布料机专业生产厂家联系电话：17858811257', '100', '1655261312', '1655261312');
INSERT INTO `ey_weapp_multicity` VALUES ('168', '0', '0', '河北省', '1', '1', '0', 'hebei', '河北液压布料机厂家', '河北布料机价格,河北液压布料机,河北液压布料机厂家', '河北省布料机专业生产厂家联系电话：17858811257', '100', '1655259373', '1655259373');
INSERT INTO `ey_weapp_multicity` VALUES ('169', '168', '168', '石家庄市', '2', '1', '0', 'sjzs', '石家庄混凝土布料机厂家', '石家庄混凝土布料机价格,石家庄混凝土布料机,石家庄混凝土布料机厂家', '石家庄混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655259882', '1655259882');
INSERT INTO `ey_weapp_multicity` VALUES ('170', '168', '168', '唐山市', '2', '1', '0', 'tss', '唐山市混凝土布料机厂家', '唐山市混凝土布料机价格,唐山市混凝土布料机,唐山市混凝土布料机厂家', '唐山市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655260398', '1655260398');
INSERT INTO `ey_weapp_multicity` VALUES ('171', '168', '168', '秦皇岛市', '2', '1', '0', 'qhds', '秦皇岛市液压布料机厂家', '秦皇岛市布料机价格,秦皇岛市液压布料机,秦皇岛市液压布料机厂家', '秦皇岛市布料机专业生产厂家联系电话：17858811257', '100', '1655260796', '1655260796');
INSERT INTO `ey_weapp_multicity` VALUES ('172', '168', '168', '邯郸市', '2', '1', '0', 'hds', '邯郸市混凝土布料机厂家', '邯郸市混凝土布料机价格,邯郸市混凝土布料机,邯郸市混凝土布料机厂家', '邯郸市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655260954', '1655260954');
INSERT INTO `ey_weapp_multicity` VALUES ('173', '168', '168', '邢台市', '2', '1', '0', 'xt', '邢台市液压布料机厂家', '邢台市布料机价格,邢台市液压布料机,邢台市液压布料机厂家', '邢台市布料机专业生产厂家联系电话：17858811257', '100', '1655261016', '1655261016');
INSERT INTO `ey_weapp_multicity` VALUES ('174', '168', '168', '保定市', '2', '1', '0', 'bds', '保定市液压布料机厂家', '保定市布料机价格,保定市液压布料机,保定市液压布料机厂家', '保定市布料机专业生产厂家联系电话：17858811257', '100', '1655261106', '1655261106');
INSERT INTO `ey_weapp_multicity` VALUES ('175', '168', '168', '张家口市', '2', '1', '0', 'zjk', '张家口市液压布料机厂家', '张家口市布料机价格,张家口市液压布料机,张家口市液压布料机厂家', '张家口市布料机专业生产厂家联系电话：17858811257', '100', '1655261197', '1655261197');
INSERT INTO `ey_weapp_multicity` VALUES ('176', '168', '168', '承德市', '2', '1', '0', 'cds', '承德市混凝土布料机厂家', '承德市混凝土布料机价格,承德市混凝土布料机,承德市混凝土布料机厂家', '承德市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655261253', '1655261253');
INSERT INTO `ey_weapp_multicity` VALUES ('178', '168', '168', '廊坊市', '2', '1', '0', 'lfs', '廊坊市混凝土布料机厂家', '廊坊市混凝土布料机价格,廊坊市混凝土布料机,廊坊市混凝土布料机厂家', '廊坊市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655261425', '1655261425');
INSERT INTO `ey_weapp_multicity` VALUES ('179', '168', '168', '衡水市', '2', '1', '0', 'hengshui', '衡水市液压布料机厂家', '衡水市布料机价格,衡水市液压布料机,v液压布料机厂家', '衡水市布料机专业生产厂家联系电话：17858811257', '100', '1655261490', '1655261490');
INSERT INTO `ey_weapp_multicity` VALUES ('180', '0', '0', '北京', '1', '1', '0', 'beijing', '北京液压布料机厂家', '北京布料机价格,北京液压布料机,北京液压布料机厂家', '北京布料机专业生产厂家联系电话：17858811257', '100', '1655261615', '1655261849');
INSERT INTO `ey_weapp_multicity` VALUES ('181', '0', '0', '山东省', '1', '1', '0', 'sds', '山东省液压布料机厂家', '山东布料机价格,山东液压布料机,山东液压布料机厂家', '山东布料机专业生产厂家联系电话：17858811257', '100', '1655262328', '1655262328');
INSERT INTO `ey_weapp_multicity` VALUES ('182', '181', '181', '济南市', '2', '1', '0', 'jns', '济南液压布料机厂家', '济南布料机价格,济南液压布料机,济南液压布料机厂家', '济南布料机专业生产厂家联系电话：17858811257', '100', '1655262522', '1655262522');
INSERT INTO `ey_weapp_multicity` VALUES ('184', '181', '181', '青岛市', '2', '1', '0', 'qds', '青岛混凝土布料机厂家', '青岛混凝土布料机价格,青岛混凝土布料机,青岛混凝土布料机厂家', '青岛混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655262686', '1655262686');
INSERT INTO `ey_weapp_multicity` VALUES ('185', '181', '181', '烟台市', '2', '1', '0', 'yts', '烟台市液压布料机厂家', '烟台布料机价格,烟台液压布料机,烟台液压布料机厂家', '烟台布料机专业生产厂家联系电话：17858811257', '100', '1655262753', '1655262753');
INSERT INTO `ey_weapp_multicity` VALUES ('186', '181', '181', '威海市', '2', '1', '0', 'weihai', '威海液压布料机厂家', '威海布料机价格,威海液压布料机,威海液压布料机厂家', '威海布料机专业生产厂家联系电话：17858811257', '100', '1655262894', '1655262894');
INSERT INTO `ey_weapp_multicity` VALUES ('187', '181', '181', '东营市', '2', '1', '0', 'dys', '东营混凝土布料机厂家', '东营混凝土布料机价格,东营混凝土布料机,东营混凝土布料机厂家', '东营混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655263074', '1655263074');
INSERT INTO `ey_weapp_multicity` VALUES ('188', '181', '181', '淄博市', '2', '1', '0', 'zbs', '淄博市液压布料机厂家', '淄博布料机价格,淄博液压布料机,淄博液压布料机厂家', '淄博布料机专业生产厂家联系电话：17858811257', '100', '1655263561', '1655263561');
INSERT INTO `ey_weapp_multicity` VALUES ('189', '181', '181', '潍坊市', '2', '1', '0', 'wfs', '潍坊市液压布料机厂家', '潍坊布料机价格,潍坊液压布料机,潍坊液压布料机厂家', '潍坊布料机专业生产厂家联系电话：17858811257', '100', '1655263696', '1655263696');
INSERT INTO `ey_weapp_multicity` VALUES ('190', '181', '181', '日照市', '2', '1', '0', 'rzs', '日照市液压布料机厂家', '日照市布料机价格,日照市液压布料机,日照市液压布料机厂家', '日照市布料机专业生产厂家联系电话：17858811257', '100', '1655269649', '1655269649');
INSERT INTO `ey_weapp_multicity` VALUES ('191', '181', '181', '莱芜市', '2', '1', '0', 'lw', '莱芜市液压布料机厂家', '莱芜市布料机价格,莱芜市液压布料机,莱芜市液压布料机厂家', '莱芜市布料机专业生产厂家联系电话：17858811257', '100', '1655269776', '1655269776');
INSERT INTO `ey_weapp_multicity` VALUES ('192', '181', '181', '菏泽市', '2', '1', '0', 'heze', '菏泽市混凝土布料机厂家', '菏泽市混凝土布料机价格,菏泽市混凝土布料机,菏泽市混凝土布料机厂家', '菏泽市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655269860', '1655269860');
INSERT INTO `ey_weapp_multicity` VALUES ('193', '181', '181', '枣庄市', '2', '1', '0', 'zaozhuang', '枣庄市液压布料机厂家', '枣庄市布料机价格,枣庄市液压布料机,枣庄市液压布料机厂家', '枣庄市布料机专业生产厂家联系电话：17858811257', '100', '1655270569', '1655270569');
INSERT INTO `ey_weapp_multicity` VALUES ('194', '181', '181', '德州市', '2', '1', '0', 'dz', '德州市混凝土布料机厂家', '德州市混凝土布料机价格,德州市混凝土布料机,德州市混凝土布料机厂家', '德州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270654', '1655270654');
INSERT INTO `ey_weapp_multicity` VALUES ('195', '181', '181', '滨州市', '2', '1', '0', 'bz', '滨州液压布料机厂家', '滨州布料机价格,滨州液压布料机,滨州液压布料机厂家', '滨州布料机专业生产厂家联系电话：17858811257', '100', '1655270777', '1655270777');
INSERT INTO `ey_weapp_multicity` VALUES ('196', '181', '181', '临沂市', '2', '1', '0', 'lq', '临沂混凝土布料机厂家', '临沂混凝土布料机价格,临沂混凝土布料机,临沂混凝土布料机厂家', '临沂混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270841', '1655270841');
INSERT INTO `ey_weapp_multicity` VALUES ('197', '181', '181', '济宁市', '2', '1', '0', 'jn', '济宁液压布料机厂家', '济宁布料机价格,济宁液压布料机,济宁液压布料机厂家', '济宁布料机专业生产厂家联系电话：17858811257', '100', '1655270909', '1655270909');
INSERT INTO `ey_weapp_multicity` VALUES ('198', '181', '181', '聊城市', '2', '1', '0', 'lc', '聊城混凝土布料机厂家', '聊城混凝土布料机价格,聊城混凝土布料机,聊城混凝土布料机厂家', '聊城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655270978', '1655270978');
INSERT INTO `ey_weapp_multicity` VALUES ('199', '181', '181', '泰安市', '2', '1', '0', 'ta', '泰安市液压布料机厂家', '泰安市布料机价格,泰安市液压布料机,泰安市液压布料机厂家', '泰安市布料机专业生产厂家联系电话：17858811257', '100', '1655271042', '1655271042');
INSERT INTO `ey_weapp_multicity` VALUES ('200', '0', '0', '湖南省', '1', '1', '0', 'hunan', '湖南省液压布料机厂家', '湖南省布料机价格,湖南省液压布料机,湖南省液压布料机厂家', '湖南省布料机专业生产厂家联系电话：17858811257', '100', '1655271212', '1655271521');
INSERT INTO `ey_weapp_multicity` VALUES ('201', '200', '200', '长沙市', '2', '1', '0', 'cs', '长沙液压布料机厂家', '长沙布料机价格,长沙液压布料机,长沙液压布料机厂家', '长沙布料机专业生产厂家联系电话：17858811257', '100', '1655279148', '1655279148');
INSERT INTO `ey_weapp_multicity` VALUES ('202', '200', '200', '湘潭市', '2', '1', '0', 'xts', '湘潭混凝土布料机厂家', '湘潭混凝土布料机价格,湘潭混凝土布料机,湘潭混凝土布料机厂家', '湘潭混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279234', '1655279234');
INSERT INTO `ey_weapp_multicity` VALUES ('203', '200', '200', '株洲市', '2', '1', '0', 'zhuzhou', '株洲液压布料机厂家', '株洲布料机价格,株洲液压布料机,株洲液压布料机厂家', '株洲布料机专业生产厂家联系电话：17858811257', '100', '1655279317', '1655279317');
INSERT INTO `ey_weapp_multicity` VALUES ('204', '200', '200', '衡阳市', '2', '1', '0', 'hengyang', '衡阳液压布料机厂家', '衡阳布料机价格,衡阳液压布料机,衡阳液压布料机厂家', '衡阳布料机专业生产厂家联系电话：17858811257', '100', '1655279594', '1655279594');
INSERT INTO `ey_weapp_multicity` VALUES ('205', '200', '200', '邵阳市', '2', '1', '0', 'sys', '邵阳混凝土布料机厂家', '邵阳混凝土布料机价格,邵阳混凝土布料机,邵阳混凝土布料机厂家', '邵阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279676', '1655279676');
INSERT INTO `ey_weapp_multicity` VALUES ('206', '200', '200', '岳阳市', '2', '1', '0', 'yys', '岳阳液压布料机厂家', '岳阳布料机价格,岳阳液压布料机,岳阳液压布料机厂家', '岳阳布料机专业生产厂家联系电话：17858811257', '100', '1655279790', '1655279790');
INSERT INTO `ey_weapp_multicity` VALUES ('207', '200', '200', '常德市', '2', '1', '0', 'cd', '常德混凝土布料机厂家', '常德混凝土布料机价格,常德混凝土布料机,常德混凝土布料机厂家', '常德混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655279951', '1655279951');
INSERT INTO `ey_weapp_multicity` VALUES ('208', '200', '200', '张家界市', '2', '1', '0', 'zjjs', '张家界液压布料机厂家', '张家界布料机价格,张家界液压布料机,张家界液压布料机厂家', '张家界布料机专业生产厂家联系电话：17858811257', '100', '1655280149', '1655280149');
INSERT INTO `ey_weapp_multicity` VALUES ('209', '200', '200', '郴州市', '2', '1', '0', 'chengzhou', '郴州混凝土布料机厂家', '郴州混凝土布料机价格,郴州混凝土布料机,郴州混凝土布料机厂家', '郴州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280236', '1655280236');
INSERT INTO `ey_weapp_multicity` VALUES ('210', '200', '200', '益阳市', '2', '1', '0', 'yy', '益阳混凝土布料机厂家', '益阳混凝土布料机价格,益阳混凝土布料机,益阳混凝土布料机厂家', '益阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280341', '1655280341');
INSERT INTO `ey_weapp_multicity` VALUES ('211', '200', '200', '永州市', '2', '1', '0', 'yz', '永州液压布料机厂家', '永州布料机价格,永州液压布料机,永州液压布料机厂家', '永州布料机专业生产厂家联系电话：17858811257', '100', '1655280397', '1655280397');
INSERT INTO `ey_weapp_multicity` VALUES ('212', '200', '200', '怀化市', '2', '1', '0', 'hhs', '怀化混凝土布料机厂家', '怀化混凝土布料机价格,怀化混凝土布料机,怀化混凝土布料机厂家', '怀化混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280464', '1655280464');
INSERT INTO `ey_weapp_multicity` VALUES ('213', '200', '200', '娄底市', '2', '1', '0', 'lds', '娄底液压布料机厂家', '娄底布料机价格,娄底液压布料机,娄底液压布料机厂家', '娄底布料机专业生产厂家联系电话：17858811257', '100', '1655280534', '1655280534');
INSERT INTO `ey_weapp_multicity` VALUES ('214', '200', '200', '湘西土家族苗族自治州', '2', '1', '0', 'xxz', '湘西州混凝土布料机厂家', '湘西州混凝土布料机价格,湘西州混凝土布料机,湘西州混凝土布料机厂家', '湘西州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655280616', '1655280616');
INSERT INTO `ey_weapp_multicity` VALUES ('215', '0', '0', '四川省', '1', '1', '0', 'scs', '四川混凝土布料机厂家', '四川混凝土布料机价格,四川混凝土布料机,四川混凝土布料机厂家', '四川混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655281819', '1655281819');
INSERT INTO `ey_weapp_multicity` VALUES ('216', '215', '215', '成都市', '2', '1', '0', 'chengdushi', '成都市混凝土布料机厂家', '成都混凝土布料机价格,成都混凝土布料机,成都混凝土布料机厂家', '成都混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655281887', '1655281887');
INSERT INTO `ey_weapp_multicity` VALUES ('217', '215', '215', '绵阳市', '2', '1', '0', 'mys', '绵阳液压布料机厂家', '绵阳布料机价格,绵阳液压布料机,绵阳液压布料机厂家', '绵阳布料机专业生产厂家联系电话：17858811257', '100', '1655281965', '1655281965');
INSERT INTO `ey_weapp_multicity` VALUES ('218', '215', '215', '自贡市', '2', '1', '0', 'zgs', '自贡市混凝土布料机厂家', '自贡混凝土布料机价格,自贡混凝土布料机,自贡混凝土布料机厂家', '自贡混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655282032', '1655282032');
INSERT INTO `ey_weapp_multicity` VALUES ('219', '215', '215', '攀枝花市', '2', '1', '0', 'pzhs', '攀枝花液压布料机厂家', '攀枝花布料机价格,攀枝花液压布料机,攀枝花液压布料机厂家', '攀枝花布料机专业生产厂家联系电话：17858811257', '100', '1655282093', '1655282093');
INSERT INTO `ey_weapp_multicity` VALUES ('220', '215', '215', '泸州市', '2', '1', '0', 'lzs', '泸州市混凝土布料机厂家', '泸州混凝土布料机价格,泸州混凝土布料机,泸州混凝土布料机厂家', '泸州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655282343', '1655282343');
INSERT INTO `ey_weapp_multicity` VALUES ('221', '215', '215', '德阳市', '2', '1', '0', 'deyang', '德阳混凝土布料机厂家', '德阳混凝土布料机价格,德阳混凝土布料机,德阳混凝土布料机厂家', '德阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655283164', '1655283164');
INSERT INTO `ey_weapp_multicity` VALUES ('222', '215', '215', '广元市', '2', '1', '0', 'gys', '广元混凝土布料机厂家', '广元混凝土布料机价格,广元混凝土布料机,广元混凝土布料机厂家', '广元混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655284129', '1655284129');
INSERT INTO `ey_weapp_multicity` VALUES ('223', '215', '215', '遂宁市', '2', '1', '0', 'sns', '遂宁液压布料机厂家', '遂宁布料机价格,遂宁液压布料机,遂宁液压布料机厂家', '遂宁布料机专业生产厂家联系电话：17858811257', '100', '1655284263', '1655284263');
INSERT INTO `ey_weapp_multicity` VALUES ('224', '215', '215', '内江市', '2', '1', '0', 'njs', '内江液压布料机厂家', '内江布料机价格,内江液压布料机,内江液压布料机厂家', '内江布料机专业生产厂家联系电话：17858811257', '100', '1655284412', '1655284412');
INSERT INTO `ey_weapp_multicity` VALUES ('225', '215', '215', '乐山市', '2', '1', '0', 'lss', '乐山混凝土布料机厂家', '乐山混凝土布料机价格,乐山混凝土布料机,乐山混凝土布料机厂家', '乐山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339495', '1655339495');
INSERT INTO `ey_weapp_multicity` VALUES ('226', '215', '215', '资阳市', '2', '1', '0', 'zy', '资阳市混凝土布料机厂家', '资阳市混凝土布料机价格,资阳市混凝土布料机,资阳市锡混凝土布料机厂家', '资阳市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339617', '1655339617');
INSERT INTO `ey_weapp_multicity` VALUES ('227', '215', '215', '宜宾市', '2', '1', '0', 'yb', '宜宾液压布料机厂家', '宜宾布料机价格,宜宾液压布料机,宜宾液压布料机厂家', '宜宾布料机专业生产厂家联系电话：17858811257', '100', '1655339797', '1655339797');
INSERT INTO `ey_weapp_multicity` VALUES ('228', '215', '215', '南充市', '2', '1', '0', 'ncs', '南充混凝土布料机厂家', '南充混凝土布料机价格,南充混凝土布料机,南充混凝土布料机厂家', '南充市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655339893', '1655339893');
INSERT INTO `ey_weapp_multicity` VALUES ('229', '215', '215', '达州市', '2', '1', '0', 'dzs', '达州市混凝土布料机厂家', '达州市混凝土布料机价格,达州市混凝土布料机,达州市混凝土布料机厂家', '达州市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655340103', '1655340103');
INSERT INTO `ey_weapp_multicity` VALUES ('230', '215', '215', '雅安市', '2', '1', '0', 'yas', '雅安液压布料机厂家', '雅安布料机价格,雅安液压布料机,雅安液压布料机厂家', '雅安布料机专业生产厂家联系电话：17858811257', '100', '1655340166', '1655340166');
INSERT INTO `ey_weapp_multicity` VALUES ('231', '215', '215', '广安市', '2', '1', '0', 'ga', '广安市液压布料机厂家', '广安市布料机价格,广安市液压布料机,广安市液压布料机厂家', '广安市布料机专业生产厂家联系电话：17858811257', '100', '1655340230', '1655340230');
INSERT INTO `ey_weapp_multicity` VALUES ('232', '215', '215', '巴中市', '2', '1', '0', 'bzs', '巴中混凝土布料机厂家', '巴中混凝土布料机价格,巴中混凝土布料机,巴中混凝土布料机厂家', '巴中混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655340386', '1655340386');
INSERT INTO `ey_weapp_multicity` VALUES ('233', '215', '215', '眉山市', '2', '1', '0', 'ms', '眉山液压布料机厂家', '眉山布料机价格,眉山液压布料机,眉山液压布料机厂家', '眉山布料机专业生产厂家联系电话：17858811257', '100', '1655340456', '1655340456');
INSERT INTO `ey_weapp_multicity` VALUES ('235', '0', '0', '江西省', '1', '1', '0', 'jx', '江西省混凝土布料机厂家', '江西省混凝土布料机价格,江西省混凝土布料机,江西省混凝土布料机厂家', '江西省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655341875', '1655341875');
INSERT INTO `ey_weapp_multicity` VALUES ('236', '235', '235', '南昌市', '2', '1', '0', 'nc', '南昌混凝土布料机厂家', '南昌混凝土布料机价格,南昌混凝土布料机,南昌混凝土布料机厂家', '南昌混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655341946', '1655341946');
INSERT INTO `ey_weapp_multicity` VALUES ('237', '235', '235', '九江市', '2', '1', '0', 'jjs', '九江液压布料机厂家', '九江布料机价格,九江液压布料机,九江液压布料机厂家', '九江布料机专业生产厂家联系电话：17858811257', '100', '1655342206', '1655342206');
INSERT INTO `ey_weapp_multicity` VALUES ('238', '235', '235', '上饶市', '2', '1', '0', 'srs', '上饶液压布料机厂家', '上饶布料机价格,上饶液压布料机,上饶液压布料机厂家', '上饶布料机专业生产厂家联系电话：17858811257', '100', '1655342355', '1655342367');
INSERT INTO `ey_weapp_multicity` VALUES ('239', '235', '235', '抚州市', '2', '1', '0', 'wz', '抚州混凝土布料机厂家', '抚州混凝土布料机价格,抚州混凝土布料机,抚州混凝土布料机厂家', '抚州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655342453', '1655342453');
INSERT INTO `ey_weapp_multicity` VALUES ('240', '235', '235', '宜春市', '2', '1', '0', 'yichun', '宜春混凝土布料机厂家', '宜春混凝土布料机价格,宜春混凝土布料机,宜春混凝土布料机厂家', '宜春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655342570', '1655342570');
INSERT INTO `ey_weapp_multicity` VALUES ('241', '235', '235', '吉安市', '2', '1', '0', 'jas', '吉安液压布料机厂家', '吉安布料机价格,吉安液压布料机,吉安液压布料机厂家', '吉安布料机专业生产厂家联系电话：17858811257', '100', '1655342810', '1655342810');
INSERT INTO `ey_weapp_multicity` VALUES ('242', '235', '235', '赣州市', '2', '1', '0', 'gz', '赣州混凝土布料机厂家', '赣州混凝土布料机价格,赣州混凝土布料机,赣州混凝土布料机厂家', '赣州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343199', '1655343199');
INSERT INTO `ey_weapp_multicity` VALUES ('243', '235', '235', '景德镇市', '2', '1', '0', 'jdzs', '景德镇混凝土布料机专业生产厂家联系电话：17858811257', '景德镇混凝土布料机价格,景德镇混凝土布料机,景德镇混凝土布料机厂家', '景德镇混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343303', '1655343303');
INSERT INTO `ey_weapp_multicity` VALUES ('244', '235', '235', '萍乡市', '2', '1', '0', 'pxs', '萍乡市混凝土布料机厂家', '萍乡市混凝土布料机价格,萍乡市混凝土布料机,萍乡市锡混凝土布料机厂家', '萍乡市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343533', '1655343533');
INSERT INTO `ey_weapp_multicity` VALUES ('245', '235', '235', '新余市', '2', '1', '0', 'xinyu', '新余液压布料机厂家', '新余布料机价格,新余液压布料机,新余液压布料机厂家', '新余布料机专业生产厂家联系电话：17858811257', '100', '1655343607', '1655343607');
INSERT INTO `ey_weapp_multicity` VALUES ('246', '235', '235', '鹰潭市', '2', '1', '0', 'yt', '鹰潭市混凝土布料机厂家', '鹰潭市混凝土布料机价格,鹰潭市混凝土布料机,鹰潭市混凝土布料机厂家', '鹰潭市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655343664', '1655343664');
INSERT INTO `ey_weapp_multicity` VALUES ('247', '0', '0', '山西省', '1', '1', '0', 'sx', '山西液压布料机厂家', '山西布料机价格,山西液压布料机,山西液压布料机厂家', '山西布料机专业生产厂家联系电话：17858811257', '100', '1655344414', '1655344414');
INSERT INTO `ey_weapp_multicity` VALUES ('248', '247', '247', '太原市', '2', '1', '0', 'tys', '太原市液压布料机厂家', '太原市布料机价格,太原市液压布料机,太原市液压布料机厂家', '太原市布料机专业生产厂家联系电话：17858811257', '100', '1655344770', '1655344770');
INSERT INTO `ey_weapp_multicity` VALUES ('249', '247', '247', '临汾市', '2', '1', '0', 'lf', '临汾液压布料机厂家', '临汾布料机价格,临汾液压布料机,临汾液压布料机厂家', '临汾布料机专业生产厂家联系电话：17858811257', '100', '1655344896', '1655344896');
INSERT INTO `ey_weapp_multicity` VALUES ('250', '247', '247', '朔州市', '2', '1', '0', 'shuozhou', '朔州液压布料机厂家', '朔州布料机价格,朔州液压布料机,朔州液压布料机厂家', '朔州布料机专业生产厂家联系电话：17858811257', '100', '1655345000', '1655345000');
INSERT INTO `ey_weapp_multicity` VALUES ('251', '247', '247', '大同市', '2', '1', '0', 'dts', '大同市液压布料机厂家', '大同市布料机价格,大同市液压布料机,大同市液压布料机厂家', '大同市布料机专业生产厂家联系电话：17858811257', '100', '1655345061', '1655345061');
INSERT INTO `ey_weapp_multicity` VALUES ('252', '247', '247', '长治市', '2', '1', '0', 'changzhishi', '长治市液压布料机厂家', '长治布料机价格,长治液压布料机,长治液压布料机厂家', '长治布料机专业生产厂家联系电话：17858811257', '100', '1655345161', '1655345161');
INSERT INTO `ey_weapp_multicity` VALUES ('253', '247', '247', '吕梁市', '2', '1', '0', 'lls', '吕梁市混凝土布料机厂家', '吕梁混凝土布料机价格,吕梁混凝土布料机,吕梁混凝土布料机厂家', '吕梁混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655345289', '1655345289');
INSERT INTO `ey_weapp_multicity` VALUES ('254', '247', '247', '晋中市', '2', '1', '0', 'jinzhong', '晋中液压布料机厂家', '晋中布料机价格,晋中液压布料机,晋中液压布料机厂家', '晋中布料机专业生产厂家联系电话：17858811257', '100', '1655345379', '1655345379');
INSERT INTO `ey_weapp_multicity` VALUES ('255', '247', '247', '忻州市', '2', '1', '0', 'xinzhou', '忻州液压布料机厂家', '忻州布料机价格,忻州液压布料机,忻州液压布料机厂家', '忻州布料机专业生产厂家联系电话：17858811257', '100', '1655345655', '1655345655');
INSERT INTO `ey_weapp_multicity` VALUES ('256', '247', '247', '运城市', '2', '1', '0', 'yuncheng', '运城混凝土布料机厂家', '运城混凝土布料机价格,运城混凝土布料机,运城混凝土布料机厂家', '运城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655345755', '1655345755');
INSERT INTO `ey_weapp_multicity` VALUES ('257', '247', '247', '阳泉市', '2', '1', '0', 'yangquan', '阳泉液压布料机厂家', '阳泉布料机价格,阳泉液压布料机,阳泉液压布料机厂家', '阳泉布料机专业生产厂家联系电话：17858811257', '100', '1655345853', '1655345853');
INSERT INTO `ey_weapp_multicity` VALUES ('258', '247', '247', '晋城市', '2', '1', '0', 'jincheng', '晋城混凝土布料机厂家', '晋城混凝土布料机价格,晋城混凝土布料机,晋城混凝土布料机厂家', '晋城混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346149', '1655346149');
INSERT INTO `ey_weapp_multicity` VALUES ('259', '247', '247', '阳泉市', '2', '1', '0', 'yqs', '阳泉液压布料机厂家', '阳泉布料机价格,阳泉液压布料机,阳泉液压布料机厂家', '阳泉布料机专业生产厂家联系电话：17858811257', '100', '1655346233', '1655346233');
INSERT INTO `ey_weapp_multicity` VALUES ('260', '0', '0', '辽宁省', '1', '1', '0', 'lns', '辽宁省混凝土布料机厂家', '辽宁省混凝土布料机价格,辽宁省混凝土布料机,辽宁省混凝土布料机厂家', '辽宁省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346466', '1655346466');
INSERT INTO `ey_weapp_multicity` VALUES ('261', '260', '260', '沈阳市', '2', '1', '0', 'shengyangshi', '沈阳市混凝土布料机厂家', '沈阳混凝土布料机价格,沈阳混凝土布料机,沈阳混凝土布料机厂家', '沈阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346602', '1655346602');
INSERT INTO `ey_weapp_multicity` VALUES ('262', '260', '260', '大连市', '2', '1', '0', 'dls', '大连液压布料机厂家', '大连布料机价格,大连液压布料机,大连液压布料机厂家', '大连布料机专业生产厂家联系电话：17858811257', '100', '1655346721', '1655346721');
INSERT INTO `ey_weapp_multicity` VALUES ('263', '260', '260', '鞍山市', '2', '1', '0', 'ass', '鞍山混凝土布料机厂家', '鞍山混凝土布料机价格,鞍山混凝土布料机,鞍山混凝土布料机厂家', '鞍山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346840', '1655346840');
INSERT INTO `ey_weapp_multicity` VALUES ('264', '260', '260', '抚顺市', '2', '1', '0', 'wss', '抚顺市液压布料机厂家', '抚顺布料机价格,抚顺液压布料机,抚顺液压布料机厂家', '抚顺布料机专业生产厂家联系电话：17858811257', '100', '1655346913', '1655346913');
INSERT INTO `ey_weapp_multicity` VALUES ('265', '260', '260', '本溪市', '2', '1', '0', 'bx', '本溪市混凝土布料机厂家', '本溪混凝土布料机价格,本溪混凝土布料机,本溪混凝土布料机厂家', '本溪混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655346996', '1655346996');
INSERT INTO `ey_weapp_multicity` VALUES ('266', '260', '260', '丹东市', '2', '1', '0', 'dds', '丹东市液压布料机厂家', '丹东布料机价格,丹东液压布料机,丹东液压布料机厂家', '丹东布料机专业生产厂家联系电话：17858811257', '100', '1655347071', '1655347071');
INSERT INTO `ey_weapp_multicity` VALUES ('267', '260', '260', '锦州市', '2', '1', '0', 'jinzhou', '锦州混凝土布料机厂家', '锦州混凝土布料机价格,锦州混凝土布料机,锦州混凝土布料机厂家', '锦州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347177', '1655347177');
INSERT INTO `ey_weapp_multicity` VALUES ('268', '260', '260', '营口市', '2', '1', '0', 'yks', '营口市液压布料机厂家', '营口布料机价格,营口液压布料机,营口液压布料机厂家', '营口布料机专业生产厂家联系电话：17858811257', '100', '1655347447', '1655347447');
INSERT INTO `ey_weapp_multicity` VALUES ('269', '260', '260', '阜新市', '2', '1', '0', 'fxs', '阜新液压布料机厂家', '阜新布料机价格,阜新液压布料机,阜新液压布料机厂家', '阜新布料机专业生产厂家联系电话：17858811257', '100', '1655347518', '1655347518');
INSERT INTO `ey_weapp_multicity` VALUES ('270', '260', '260', '辽阳市', '2', '1', '0', 'liaoyang', '辽阳混凝土布料机厂家', '辽阳混凝土布料机价格,辽阳混凝土布料机,辽阳混凝土布料机厂家', '辽阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347623', '1655347623');
INSERT INTO `ey_weapp_multicity` VALUES ('271', '260', '260', '盘锦市', '2', '1', '0', 'pjs', '盘锦液压布料机厂家', '盘锦布料机价格,盘锦液压布料机,盘锦液压布料机厂家', '盘锦布料机专业生产厂家联系电话：17858811257', '100', '1655347677', '1655347677');
INSERT INTO `ey_weapp_multicity` VALUES ('272', '260', '260', '铁岭市', '2', '1', '0', 'tl', '铁岭液压布料机厂家', '铁岭布料机价格,铁岭液压布料机,铁岭液压布料机厂家', '铁岭布料机专业生产厂家联系电话：17858811257', '100', '1655347753', '1655347753');
INSERT INTO `ey_weapp_multicity` VALUES ('273', '260', '260', '朝阳市', '2', '1', '0', 'zhaoyang', '朝阳混凝土布料机厂家', '朝阳混凝土布料机价格,朝阳混凝土布料机,朝阳混凝土布料机厂家', '朝阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655347829', '1655347829');
INSERT INTO `ey_weapp_multicity` VALUES ('274', '260', '260', '葫芦岛市', '2', '1', '0', 'hld', '葫芦岛液压布料机厂家', '葫芦岛布料机价格,葫芦岛液压布料机,葫芦岛液压布料机厂家', '葫芦岛布料机专业生产厂家联系电话：17858811257', '100', '1655347897', '1655347897');
INSERT INTO `ey_weapp_multicity` VALUES ('275', '0', '0', '台湾省', '1', '1', '0', 'tianwansheng', '台湾省混凝土布料机厂家', '台湾混凝土布料机价格,台湾混凝土布料机,台湾混凝土布料机厂家', '台湾混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349018', '1655357173');
INSERT INTO `ey_weapp_multicity` VALUES ('276', '275', '275', '台北市', '2', '1', '0', 'tbs', '台北市混凝土布料机厂家', '台北混凝土布料机价格,台北混凝土布料机,台北混凝土布料机厂家', '台北混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349307', '1655349307');
INSERT INTO `ey_weapp_multicity` VALUES ('277', '275', '275', '新北市', '2', '1', '0', 'xbs', '新北液压布料机厂家', '新北布料机价格,新北液压布料机,新北液压布料机厂家', '新北布料机专业生产厂家联系电话：17858811257', '100', '1655349738', '1655349738');
INSERT INTO `ey_weapp_multicity` VALUES ('278', '275', '275', '桃园市', '2', '1', '0', 'ty', '桃园混凝土布料机厂家', '桃园混凝土布料机价格,桃园混凝土布料机,桃园混凝土布料机厂家', '桃园混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655349821', '1655349821');
INSERT INTO `ey_weapp_multicity` VALUES ('279', '275', '275', '台中市', '2', '1', '0', 'taizhong', '台中液压布料机厂家', '台中布料机价格,台中液压布料机,台中液压布料机厂家', '台中布料机专业生产厂家联系电话：17858811257', '100', '1655349896', '1655349896');
INSERT INTO `ey_weapp_multicity` VALUES ('280', '275', '275', '台南市', '2', '1', '0', 'tns', '台南混凝土布料机厂家', '台南混凝土布料机价格,台南混凝土布料机,台南混凝土布料机厂家', '台南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655356543', '1655356543');
INSERT INTO `ey_weapp_multicity` VALUES ('281', '275', '275', '高雄市', '2', '1', '0', 'gxs', '高雄液压布料机厂家', '高雄布料机价格,高雄液压布料机,高雄液压布料机厂家', '高雄布料机专业生产厂家联系电话：17858811257', '100', '1655356621', '1655356621');
INSERT INTO `ey_weapp_multicity` VALUES ('282', '275', '275', '基隆市', '2', '1', '0', 'jls', '基隆液压布料机厂家', '基隆布料机价格,基隆液压布料机,基隆液压布料机厂家', '基隆布料机专业生产厂家联系电话：17858811257', '100', '1655356694', '1655356694');
INSERT INTO `ey_weapp_multicity` VALUES ('283', '275', '275', '新竹市', '2', '1', '0', 'xzs', '新竹液压布料机厂家', '新竹布料机价格,新竹液压布料机,新竹液压布料机厂家', '新竹布料机专业生产厂家联系电话：17858811257', '100', '1655356884', '1655356884');
INSERT INTO `ey_weapp_multicity` VALUES ('284', '275', '275', '嘉义市', '2', '1', '0', 'jiayi', '嘉义混凝土布料机厂家', '嘉义混凝土布料机价格,嘉义混凝土布料机,嘉义混凝土布料机厂家', '嘉义混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655356954', '1655356954');
INSERT INTO `ey_weapp_multicity` VALUES ('285', '0', '0', '陕西省', '1', '1', '0', 'shanxisheng', '陕西省混凝土布料机厂家', '陕西混凝土布料机价格,陕西混凝土布料机,陕西混凝土布料机厂家', '陕西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357159', '1655357159');
INSERT INTO `ey_weapp_multicity` VALUES ('286', '285', '285', '西安市', '2', '1', '0', 'xian', '西安混凝土布料机厂家', '西安混凝土布料机价格,西安混凝土布料机,西安混凝土布料机厂家', '西安混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357370', '1655357370');
INSERT INTO `ey_weapp_multicity` VALUES ('287', '285', '285', '咸阳市', '2', '1', '0', 'xianyang', '咸阳液压布料机厂家', '咸阳布料机价格,咸阳液压布料机,咸阳液压布料机厂家', '咸阳布料机专业生产厂家联系电话：17858811257', '100', '1655357469', '1655357469');
INSERT INTO `ey_weapp_multicity` VALUES ('288', '285', '285', '宝鸡市', '2', '1', '0', 'baoji', '宝鸡混凝土布料机厂家', '宝鸡混凝土布料机价格,宝鸡混凝土布料机,宝鸡混凝土布料机厂家', '宝鸡混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655357605', '1655357605');
INSERT INTO `ey_weapp_multicity` VALUES ('289', '285', '285', '铜川市', '2', '1', '0', 'tongchuan', '铜川液压布料机厂家', '铜川布料机价格,铜川液压布料机,铜川液压布料机厂家', '铜川布料机专业生产厂家联系电话：17858811257', '100', '1655357712', '1655357712');
INSERT INTO `ey_weapp_multicity` VALUES ('290', '285', '285', '渭南市', '2', '1', '0', 'weinan', '渭南液压布料机厂家', '渭南布料机价格,渭南液压布料机,渭南液压布料机厂家', '渭南布料机专业生产厂家联系电话：17858811257', '100', '1655357824', '1655357824');
INSERT INTO `ey_weapp_multicity` VALUES ('291', '285', '285', '延安市', '2', '1', '0', 'yanan', '延安液压布料机厂家', '延安布料机价格,延安液压布料机,延安液压布料机厂家', '延安布料机专业生产厂家联系电话：17858811257', '100', '1655357909', '1655357909');
INSERT INTO `ey_weapp_multicity` VALUES ('292', '285', '285', '榆林市', '2', '1', '0', 'yl', '榆林液压布料机厂家', '榆林布料机价格,榆林液压布料机,榆林液压布料机厂家', '榆林布料机专业生产厂家联系电话：17858811257', '100', '1655358079', '1655358120');
INSERT INTO `ey_weapp_multicity` VALUES ('293', '285', '285', '汉中市', '2', '1', '0', 'hanzhong', '汉中液压布料机厂家', '汉中布料机价格,汉中液压布料机,汉中液压布料机厂家', '汉中布料机专业生产厂家联系电话：17858811257', '100', '1655358197', '1655358197');
INSERT INTO `ey_weapp_multicity` VALUES ('294', '285', '285', '安康市', '2', '1', '0', 'ankang', '安康混凝土布料机厂家', '安康混凝土布料机价格,安康混凝土布料机,安康混凝土布料机厂家', '安康混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358260', '1655358260');
INSERT INTO `ey_weapp_multicity` VALUES ('295', '285', '285', '商洛市', '2', '1', '0', 'shangluo', '商洛混凝土布料机厂家', '商洛混凝土布料机价格,商洛混凝土布料机,商洛混凝土布料机厂家', '商洛混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358363', '1655358363');
INSERT INTO `ey_weapp_multicity` VALUES ('296', '0', '0', '吉林省', '1', '1', '0', 'jilinsheng', '吉林混凝土布料机厂家', '吉林混凝土布料机价格,吉林混凝土布料机,吉林混凝土布料机厂家', '吉林混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358470', '1655358470');
INSERT INTO `ey_weapp_multicity` VALUES ('297', '296', '296', '长春市', '2', '1', '0', 'ccs', '长春混凝土布料机厂家', '长春混凝土布料机价格,长春混凝土布料机,长春混凝土布料机厂家', '长春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358612', '1655358612');
INSERT INTO `ey_weapp_multicity` VALUES ('298', '296', '296', '吉林市', '2', '1', '0', 'jilin', '吉林液压布料机厂家', '吉林布料机价格,吉林液压布料机,吉林液压布料机厂家', '吉林布料机专业生产厂家联系电话：17858811257', '100', '1655358713', '1655358713');
INSERT INTO `ey_weapp_multicity` VALUES ('299', '296', '296', '四平市', '2', '1', '0', 'siping', '四平混凝土布料机厂家', '四平混凝土布料机价格,四平混凝土布料机,四平混凝土布料机厂家', '四平混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655358820', '1655358820');
INSERT INTO `ey_weapp_multicity` VALUES ('300', '296', '296', '辽源市', '2', '1', '0', 'liaoyuan', '辽源液压布料机厂家', '辽源布料机价格,辽源液压布料机,辽源液压布料机厂家', '辽源布料机专业生产厂家联系电话：17858811257', '100', '1655359567', '1655359567');
INSERT INTO `ey_weapp_multicity` VALUES ('301', '296', '296', '通化市', '2', '1', '0', 'tonghua', '通化混凝土布料机厂家', '通化混凝土布料机价格,通化混凝土布料机,通化混凝土布料机厂家', '通化混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655359640', '1655359640');
INSERT INTO `ey_weapp_multicity` VALUES ('302', '296', '296', '白山市', '2', '1', '0', 'baishan', '白山市液压布料机厂家', '白山布料机价格,白山液压布料机,白山液压布料机厂家', '白山布料机专业生产厂家联系电话：17858811257', '100', '1655359708', '1655359708');
INSERT INTO `ey_weapp_multicity` VALUES ('303', '296', '296', '松原市', '2', '1', '0', 'songyuan', '松原液压布料机厂家', '松原布料机价格,松原液压布料机,松原液压布料机厂家', '松原布料机专业生产厂家联系电话：17858811257', '100', '1655359811', '1655359811');
INSERT INTO `ey_weapp_multicity` VALUES ('304', '296', '296', '白城市', '2', '1', '0', 'baicheng', '白城液压布料机厂家', '白城布料机价格,白城液压布料机,白城液压布料机厂家', '白城布料机专业生产厂家联系电话：17858811257', '100', '1655359880', '1655359880');
INSERT INTO `ey_weapp_multicity` VALUES ('305', '0', '0', '黑龙江省', '1', '1', '0', 'hljs', '黑龙江混凝土布料机厂家', '黑龙江混凝土布料机价格,黑龙江混凝土布料机,黑龙江混凝土布料机厂家', '黑龙江混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655360653', '1655360653');
INSERT INTO `ey_weapp_multicity` VALUES ('306', '305', '305', '哈尔滨市', '2', '1', '0', 'hebs', '哈尔滨液压布料机厂家', '哈尔滨布料机价格,哈尔滨液压布料机,哈尔滨液压布料机厂家', '哈尔滨布料机专业生产厂家联系电话：17858811257', '100', '1655360862', '1655360862');
INSERT INTO `ey_weapp_multicity` VALUES ('307', '305', '305', '齐齐哈尔市', '2', '1', '0', 'qqhe', '齐齐哈尔混凝土布料机厂家', '齐齐哈尔混凝土布料机价格,齐齐哈尔混凝土布料机,齐齐哈尔混凝土布料机厂家', '齐齐哈尔混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655360944', '1655360944');
INSERT INTO `ey_weapp_multicity` VALUES ('308', '305', '305', '牡丹江市', '2', '1', '0', 'mdjs', '牡丹江液压布料机厂家', '牡丹江布料机价格,牡丹江液压布料机,牡丹江液压布料机厂家', '牡丹江布料机专业生产厂家联系电话：17858811257', '100', '1655361058', '1655361058');
INSERT INTO `ey_weapp_multicity` VALUES ('309', '305', '305', '佳木斯市', '2', '1', '0', 'jmss', '佳木斯液压布料机厂家', '佳木斯布料机价格,佳木斯液压布料机,佳木斯液压布料机厂家', '佳木斯布料机专业生产厂家联系电话：17858811257', '100', '1655361375', '1655361375');
INSERT INTO `ey_weapp_multicity` VALUES ('310', '305', '305', '大庆市', '2', '1', '0', 'dqs', '大庆液压布料机厂家', '大庆布料机价格,大庆液压布料机,大庆液压布料机厂家', '大庆布料机专业生产厂家联系电话：17858811257', '100', '1655362509', '1655365064');
INSERT INTO `ey_weapp_multicity` VALUES ('311', '305', '305', '鸡西市', '2', '1', '0', 'jixishi', '鸡西混凝土布料机厂家', '鸡西混凝土布料机价格,鸡西混凝土布料机,鸡西混凝土布料机厂家', '鸡西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655362620', '1655362928');
INSERT INTO `ey_weapp_multicity` VALUES ('312', '305', '305', '双鸭山市', '2', '1', '0', 'syss', '双鸭山液压布料机厂家', '双鸭山布料机价格,双鸭山液压布料机,双鸭山液压布料机厂家', '双鸭山布料机专业生产厂家联系电话：17858811257', '100', '1655363051', '1655363051');
INSERT INTO `ey_weapp_multicity` VALUES ('313', '305', '305', '伊春市', '2', '1', '0', 'yichunshi', '伊春混凝土布料机厂家', '伊春混凝土布料机价格,伊春混凝土布料机,伊春混凝土布料机厂家', '伊春混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655363217', '1655363217');
INSERT INTO `ey_weapp_multicity` VALUES ('314', '305', '305', '七台河市', '2', '1', '0', 'qitaihe', '七台河液压布料机厂家', '七台河布料机价格,七台河液压布料机,七台河液压布料机厂家', '七台河布料机专业生产厂家联系电话：17858811257', '100', '1655363492', '1655363492');
INSERT INTO `ey_weapp_multicity` VALUES ('315', '305', '305', '鹤岗市', '2', '1', '0', 'hegangshi', '鹤岗液压布料机厂家', '鹤岗布料机价格,鹤岗液压布料机,鹤岗液压布料机厂家', '鹤岗布料机专业生产厂家联系电话：17858811257', '100', '1655363835', '1655363835');
INSERT INTO `ey_weapp_multicity` VALUES ('316', '305', '305', '黑河市', '2', '1', '0', 'heiheshi', '黑河混凝土布料机厂家', '黑河混凝土布料机价格,黑河混凝土布料机,黑河混凝土布料机厂家', '黑河混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655363941', '1655363941');
INSERT INTO `ey_weapp_multicity` VALUES ('317', '305', '305', '绥化市', '2', '1', '0', 'sss', '绥化液压布料机厂家', '绥化布料机价格,绥化液压布料机,绥化液压布料机厂家', '绥化布料机专业生产厂家联系电话：17858811257', '100', '1655364017', '1655364334');
INSERT INTO `ey_weapp_multicity` VALUES ('318', '305', '305', '大兴安岭', '2', '1', '0', 'dxal', '大兴安岭液压布料机厂家', '大兴安岭布料机价格,大兴安岭液压布料机,大兴安岭液压布料机厂家', '大兴安岭布料机专业生产厂家联系电话：17858811257', '100', '1655364688', '1655364688');
INSERT INTO `ey_weapp_multicity` VALUES ('319', '0', '0', '海南省', '1', '1', '0', 'hainansheng', '海南省混凝土布料机厂家', '海南混凝土布料机价格,海南混凝土布料机,海南混凝土布料机厂家', '海南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655364793', '1655364793');
INSERT INTO `ey_weapp_multicity` VALUES ('320', '319', '319', '海口市', '2', '1', '0', 'hks', '海口混凝土布料机厂家', '海口混凝土布料机价格,海口混凝土布料机,海口混凝土布料机厂家', '海口混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655365503', '1655365503');
INSERT INTO `ey_weapp_multicity` VALUES ('321', '319', '319', '三亚市', '2', '1', '0', 'sanyashi', '三亚液压布料机厂家', '三亚布料机价格,三亚液压布料机,三亚液压布料机厂家', '三亚布料机专业生产厂家联系电话：17858811257', '100', '1655365693', '1655365788');
INSERT INTO `ey_weapp_multicity` VALUES ('322', '319', '319', '三沙市', '2', '1', '0', 'shansha', '三沙市液压布料机厂家', '三沙布料机价格,三沙液压布料机,三沙液压布料机厂家', '三沙布料机专业生产厂家联系电话：17858811257', '100', '1655365908', '1655365908');
INSERT INTO `ey_weapp_multicity` VALUES ('323', '319', '319', '儋州市', '2', '1', '0', 'danzhoushi', '儋州混凝土布料机厂家', '儋州混凝土布料机价格,儋州混凝土布料机,儋州混凝土布料机厂家', '儋州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655366019', '1655366019');
INSERT INTO `ey_weapp_multicity` VALUES ('324', '0', '0', '贵州省', '1', '1', '0', 'guizhou', '贵州混凝土布料机厂家', '贵州混凝土布料机价格,贵州混凝土布料机,贵州混凝土布料机厂家', '贵州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655367341', '1655367341');
INSERT INTO `ey_weapp_multicity` VALUES ('325', '324', '324', '贵阳市', '2', '1', '0', 'gy', '贵阳混凝土布料机厂家', '贵阳混凝土布料机价格,贵阳混凝土布料机,贵阳混凝土布料机厂家', '贵阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655367878', '1655367878');
INSERT INTO `ey_weapp_multicity` VALUES ('326', '324', '324', '遵义市', '2', '1', '0', 'zys', '遵义液压布料机厂家', '遵义布料机价格,遵义液压布料机,遵义液压布料机厂家', '遵义布料机专业生产厂家联系电话：17858811257', '100', '1655367999', '1655368056');
INSERT INTO `ey_weapp_multicity` VALUES ('327', '324', '324', '六盘水市', '2', '1', '0', 'lpss', '六盘水液压布料机厂家', '六盘水布料机价格,六盘水液压布料机,六盘水液压布料机厂家', '六盘水布料机专业生产厂家联系电话：17858811257', '100', '1655368313', '1655368313');
INSERT INTO `ey_weapp_multicity` VALUES ('328', '324', '324', '安顺市', '2', '1', '0', 'as', '安顺混凝土布料机厂家', '安顺混凝土布料机价格,安顺混凝土布料机,安顺混凝土布料机厂家', '安顺混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655368393', '1655368393');
INSERT INTO `ey_weapp_multicity` VALUES ('329', '324', '324', '毕节市', '2', '1', '0', 'bijie', '毕节液压布料机厂家', '毕节布料机价格,毕节液压布料机,毕节液压布料机厂家', '毕节布料机专业生产厂家联系电话：17858811257', '100', '1655368562', '1655368562');
INSERT INTO `ey_weapp_multicity` VALUES ('330', '324', '324', '铜仁市', '2', '1', '0', 'tr', '铜仁混凝土布料机厂家', '铜仁混凝土布料机价格,铜仁混凝土布料机,铜仁混凝土布料机厂家', '铜仁混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655368766', '1655368766');
INSERT INTO `ey_weapp_multicity` VALUES ('331', '324', '324', '凯里市', '2', '1', '0', 'kls', '凯里混凝土布料机厂家', '凯里混凝土布料机价格,凯里混凝土布料机,凯里混凝土布料机厂家', '凯里混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655369653', '1655369653');
INSERT INTO `ey_weapp_multicity` VALUES ('332', '324', '324', '都匀市', '2', '1', '0', 'dunjun', '都匀液压布料机厂家', '都匀布料机价格,都匀液压布料机,都匀液压布料机厂家', '都匀布料机专业生产厂家联系电话：17858811257', '100', '1655369851', '1655369862');
INSERT INTO `ey_weapp_multicity` VALUES ('333', '324', '324', '兴义市', '2', '1', '0', 'xinyi', '兴义混凝土布料机厂家', '兴义混凝土布料机价格,兴义混凝土布料机,兴义混凝土布料机厂家', '兴义混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655369935', '1655369935');
INSERT INTO `ey_weapp_multicity` VALUES ('334', '0', '0', '云南省', '1', '1', '0', 'yunan', '云南混凝土布料机厂家', '云南混凝土布料机价格,云南混凝土布料机,云南混凝土布料机厂家', '云南混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655425416', '1655425416');
INSERT INTO `ey_weapp_multicity` VALUES ('335', '334', '334', '昆明市', '2', '1', '0', 'kms', '昆明液压布料机厂家', '昆明布料机价格,昆明液压布料机,昆明液压布料机厂家', '昆明布料机专业生产厂家联系电话：17858811257', '100', '1655425647', '1655425647');
INSERT INTO `ey_weapp_multicity` VALUES ('336', '334', '334', '曲靖市', '2', '1', '0', 'qjs', '曲靖液压布料机厂家', '曲靖布料机价格,曲靖液压布料机,曲靖液压布料机厂家', '曲靖布料机专业生产厂家联系电话：17858811257', '100', '1655425935', '1655425935');
INSERT INTO `ey_weapp_multicity` VALUES ('337', '334', '334', '玉溪市', '2', '1', '0', 'ys', '玉溪混凝土布料机厂家', '玉溪混凝土布料机价格,玉溪混凝土布料机,玉溪混凝土布料机厂家', '玉溪混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426018', '1655426018');
INSERT INTO `ey_weapp_multicity` VALUES ('338', '334', '334', '丽江市', '2', '1', '0', 'lijiang', '丽江市液压布料机厂家', '丽江布料机价格,丽江液压布料机,丽江液压布料机厂家', '丽江布料机专业生产厂家联系电话：17858811257', '100', '1655426499', '1655426499');
INSERT INTO `ey_weapp_multicity` VALUES ('339', '334', '334', '普洱市', '2', '1', '0', 'puershi', '普洱混凝土布料机厂家', '普洱混凝土布料机价格,普洱混凝土布料机,普洱混凝土布料机厂家', '普洱混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426610', '1655426610');
INSERT INTO `ey_weapp_multicity` VALUES ('340', '334', '334', '保山市', '2', '1', '0', 'baoshan', '保山液压布料机厂家', '保山布料机价格,保山液压布料机,保山液压布料机厂家', '保山布料机专业生产厂家联系电话：17858811257', '100', '1655426723', '1655426723');
INSERT INTO `ey_weapp_multicity` VALUES ('341', '334', '334', '昭通市', '2', '1', '0', 'zts', '昭通混凝土布料机厂家', '昭通混凝土布料机价格,昭通混凝土布料机,昭通混凝土布料机厂家', '昭通混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655426879', '1655426879');
INSERT INTO `ey_weapp_multicity` VALUES ('342', '334', '334', '临沧市', '2', '1', '0', 'lincang', '临沧液压布料机厂家', '临沧布料机价格,临沧液压布料机,临沧液压布料机厂家', '临沧布料机专业生产厂家联系电话：17858811257', '100', '1655427017', '1655427017');
INSERT INTO `ey_weapp_multicity` VALUES ('343', '0', '0', '甘肃省', '1', '1', '0', 'ganshusheng', '甘肃省液压布料机厂家', '甘肃布料机价格,甘肃液压布料机,甘肃液压布料机厂家', '甘肃布料机专业生产厂家联系电话：17858811257', '100', '1655427225', '1655427225');
INSERT INTO `ey_weapp_multicity` VALUES ('344', '343', '343', '兰州市', '2', '1', '0', 'lanzhou', '兰州混凝土布料机厂家', '兰州混凝土布料机价格,兰州混凝土布料机,兰州混凝土布料机厂家', '兰州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655427682', '1655427682');
INSERT INTO `ey_weapp_multicity` VALUES ('345', '343', '343', '嘉峪关市', '2', '1', '0', 'jiayuguan', '嘉峪关市液压布料机厂家', '嘉峪关市布料机价格,嘉峪关市液压布料机,嘉峪关市液压布料机厂家', '嘉峪关市布料机专业生产厂家联系电话：17858811257', '100', '1655427831', '1655427831');
INSERT INTO `ey_weapp_multicity` VALUES ('346', '343', '343', '金昌市', '2', '1', '0', 'jcs', '金昌液压布料机厂家', '金昌布料机价格,金昌液压布料机,金昌液压布料机厂家', '金昌布料机专业生产厂家联系电话：17858811257', '100', '1655428010', '1655428010');
INSERT INTO `ey_weapp_multicity` VALUES ('347', '343', '343', '白银市', '2', '1', '0', 'baiyin', '白银液压布料机厂家', '白银布料机价格,白银液压布料机,白银液压布料机厂家', '白银布料机专业生产厂家联系电话：17858811257', '100', '1655428094', '1655428094');
INSERT INTO `ey_weapp_multicity` VALUES ('348', '343', '343', '天水市', '2', '1', '0', 'tianshui', '天水混凝土布料机厂家', '天水混凝土布料机价格,天水混凝土布料机,天水混凝土布料机厂家', '天水混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655428339', '1655428339');
INSERT INTO `ey_weapp_multicity` VALUES ('349', '343', '343', '武威市', '2', '1', '0', 'wuwei', '武威混凝土布料机厂家', '武威混凝土布料机价格,武威混凝土布料机,武威混凝土布料机厂家', '武威混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655428429', '1655428429');
INSERT INTO `ey_weapp_multicity` VALUES ('350', '343', '343', '张掖市', '2', '1', '0', 'zhangye', '张掖液压布料机厂家', '张掖布料机价格,张掖液压布料机,张掖液压布料机厂家', '张掖布料机专业生产厂家联系电话：17858811257', '100', '1655428511', '1655428511');
INSERT INTO `ey_weapp_multicity` VALUES ('351', '343', '343', '平凉市', '2', '1', '0', 'pls', '平凉液压布料机厂家', '平凉布料机价格,平凉液压布料机,平凉液压布料机厂家', '平凉布料机专业生产厂家联系电话：17858811257', '100', '1655428610', '1655428610');
INSERT INTO `ey_weapp_multicity` VALUES ('352', '343', '343', '酒泉市', '2', '1', '0', 'jiuquan', '酒泉液压布料机厂家', '酒泉布料机价格,酒泉液压布料机,酒泉液压布料机厂家', '酒泉布料机专业生产厂家联系电话：17858811257', '100', '1655429398', '1655429398');
INSERT INTO `ey_weapp_multicity` VALUES ('353', '343', '343', '庆阳市', '2', '1', '0', 'qingyang', '庆阳混凝土布料机厂家', '庆阳混凝土布料机价格,庆阳混凝土布料机,庆阳混凝土布料机厂家', '庆阳混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429487', '1655429487');
INSERT INTO `ey_weapp_multicity` VALUES ('354', '343', '343', '定西市', '2', '1', '0', 'dingxi', '定西混凝土布料机厂家', '定西混凝土布料机价格,定西混凝土布料机,定西混凝土布料机厂家', '定西混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429599', '1655429599');
INSERT INTO `ey_weapp_multicity` VALUES ('355', '343', '343', '陇南市', '2', '1', '0', 'longnan', '陇南市液压布料机厂家', '陇南市布料机价格,陇南市液压布料机,陇南市液压布料机厂家', '陇南市布料机专业生产厂家联系电话：17858811257', '100', '1655429748', '1655429748');
INSERT INTO `ey_weapp_multicity` VALUES ('356', '0', '0', '青海省', '1', '1', '0', 'qinghaisheng', '青海省混凝土布料机厂家', '青海省混凝土布料机价格,青海省混凝土布料机,青海省混凝土布料机厂家', '青海省混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655429823', '1655429823');
INSERT INTO `ey_weapp_multicity` VALUES ('357', '356', '356', '西宁市', '2', '1', '0', 'xining', '西宁液压布料机厂家', '西宁布料机价格,西宁液压布料机,西宁液压布料机厂家', '西宁布料机专业生产厂家联系电话：17858811257', '100', '1655430430', '1655430430');
INSERT INTO `ey_weapp_multicity` VALUES ('358', '356', '356', '海东市', '2', '1', '0', 'haidong', '海东市混凝土布料机厂家', '海东市混凝土布料机价格,海东市混凝土布料机,海东市混凝土布料机厂家', '海东市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655430581', '1655430581');
INSERT INTO `ey_weapp_multicity` VALUES ('359', '0', '0', '内蒙古自治区', '1', '1', '0', 'neimenggu', '内蒙古混凝土布料机厂家', '内蒙古混凝土布料机价格,内蒙古混凝土布料机,内蒙古混凝土布料机厂家', '内蒙古混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655430794', '1655430794');
INSERT INTO `ey_weapp_multicity` VALUES ('360', '359', '359', '呼和浩特市', '2', '1', '0', 'huhehaote', '呼和浩特混凝土布料机厂家', '呼和浩特混凝土布料机价格,呼和浩特混凝土布料机,呼和浩特混凝土布料机厂家', '呼和浩特混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655431592', '1655431592');
INSERT INTO `ey_weapp_multicity` VALUES ('361', '359', '359', '包头市', '2', '1', '0', 'bts', '包头液压布料机厂家', '包头布料机价格,包头液压布料机,包头液压布料机厂家', '包头布料机专业生产厂家联系电话：17858811257', '100', '1655431780', '1655431780');
INSERT INTO `ey_weapp_multicity` VALUES ('362', '359', '359', '乌海市', '2', '1', '0', 'wuhaishi', '乌海液压布料机厂家', '乌海布料机价格,乌海液压布料机,乌海液压布料机厂家', '乌海布料机专业生产厂家联系电话：17858811257', '100', '1655431945', '1655431945');
INSERT INTO `ey_weapp_multicity` VALUES ('363', '359', '359', '赤峰市', '2', '1', '0', 'chifengshi', '赤峰液压布料机厂家', '赤峰布料机价格,赤峰液压布料机,赤峰液压布料机厂家', '赤峰布料机专业生产厂家联系电话：17858811257', '100', '1655432072', '1655432072');
INSERT INTO `ey_weapp_multicity` VALUES ('364', '359', '359', '通辽市', '2', '1', '0', 'tongliao', '通辽市混凝土布料机厂家', '通辽市混凝土布料机价格,通辽市混凝土布料机,通辽市混凝土布料机厂家', '通辽市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432207', '1655432207');
INSERT INTO `ey_weapp_multicity` VALUES ('365', '359', '359', '鄂尔多斯市', '2', '1', '0', 'eeds', '鄂尔多斯混凝土布料机厂家', '鄂尔多斯混凝土布料机价格,鄂尔多斯混凝土布料机,鄂尔多斯混凝土布料机厂家', '鄂尔多斯混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432333', '1655432333');
INSERT INTO `ey_weapp_multicity` VALUES ('366', '359', '359', '呼伦贝尔市', '2', '1', '0', 'hnbe', '呼伦贝尔液压布料机厂家', '呼伦贝尔布料机价格,呼伦贝尔液压布料机,呼伦贝尔液压布料机厂家', '呼伦贝尔布料机专业生产厂家联系电话：17858811257', '100', '1655432441', '1655432441');
INSERT INTO `ey_weapp_multicity` VALUES ('367', '359', '359', '巴彦淖尔市', '2', '1', '0', 'bayanzhuoer', '巴彦淖尔混凝土布料机厂家', '巴彦淖尔混凝土布料机价格,巴彦淖尔混凝土布料机,巴彦淖尔混凝土布料机厂家', '巴彦淖尔混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655432575', '1655432575');
INSERT INTO `ey_weapp_multicity` VALUES ('368', '359', '359', '乌兰察布市', '2', '1', '0', 'wlcb', '乌兰察布液压布料机厂家', '乌兰察布布料机价格,乌兰察布液压布料机,乌兰察布液压布料机厂家', '乌兰察布布料机专业生产厂家联系电话：17858811257', '100', '1655433709', '1655433709');
INSERT INTO `ey_weapp_multicity` VALUES ('369', '0', '0', '广西壮族自治区', '1', '1', '0', 'guangxizhuangzu', '广西壮族自治区混凝土布料机厂家', '广西壮族自治区混凝土布料机价格,广西壮族自治区混凝土布料机,广西壮族自治区混凝土布料机厂家', '广西壮族自治区混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655433838', '1655433838');
INSERT INTO `ey_weapp_multicity` VALUES ('370', '369', '369', '南宁市', '2', '1', '0', 'nanling', '南宁市混凝土布料机厂家', '南宁市混凝土布料机价格,南宁市混凝土布料机,南宁市混凝土布料机厂家', '南宁市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434130', '1655434130');
INSERT INTO `ey_weapp_multicity` VALUES ('371', '369', '369', '柳州市', '2', '1', '0', 'liuzhou', '柳州液压布料机厂家', '柳州布料机价格,柳州液压布料机,柳州液压布料机厂家', '柳州布料机专业生产厂家联系电话：17858811257', '100', '1655434221', '1655434221');
INSERT INTO `ey_weapp_multicity` VALUES ('372', '369', '369', '桂林市', '2', '1', '0', 'guilin', '桂林液压布料机厂家', '桂林布料机价格,桂林液压布料机,桂林液压布料机厂家', '桂林布料机专业生产厂家联系电话：17858811257', '100', '1655434333', '1655434355');
INSERT INTO `ey_weapp_multicity` VALUES ('373', '369', '369', '梧州市', '2', '1', '0', 'wuzhou', '梧州液压布料机厂家', '梧州布料机价格,梧州液压布料机,梧州液压布料机厂家', '梧州布料机专业生产厂家联系电话：17858811257', '100', '1655434664', '1655434664');
INSERT INTO `ey_weapp_multicity` VALUES ('374', '369', '369', '北海市', '2', '1', '0', 'beihai', '北海混凝土布料机厂家', '北海混凝土布料机价格,北海混凝土布料机,北海混凝土布料机厂家', '北海混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434823', '1655434823');
INSERT INTO `ey_weapp_multicity` VALUES ('375', '369', '369', '防城港市', '2', '1', '0', 'fcgs', '防城港混凝土布料机厂家', '防城港混凝土布料机价格,防城港混凝土布料机,防城港混凝土布料机厂家', '防城港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655434944', '1655434944');
INSERT INTO `ey_weapp_multicity` VALUES ('376', '369', '369', '钦州市', '2', '1', '0', 'qinzhou', '钦州市液压布料机厂家', '钦州市布料机价格,钦州市液压布料机,钦州市液压布料机厂家', '钦州市布料机专业生产厂家联系电话：17858811257', '100', '1655435039', '1655435039');
INSERT INTO `ey_weapp_multicity` VALUES ('377', '369', '369', '贵港市', '2', '1', '0', 'guigang', '贵港混凝土布料机厂家', '贵港混凝土布料机价格,贵港混凝土布料机,贵港混凝土布料机厂家', '贵港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435119', '1655435613');
INSERT INTO `ey_weapp_multicity` VALUES ('378', '369', '369', '玉林市', '2', '1', '0', 'yulin', '玉林混凝土布料机厂家', '玉林混凝土布料机价格,玉林混凝土布料机,玉林混凝土布料机厂家', '玉林混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435732', '1655435732');
INSERT INTO `ey_weapp_multicity` VALUES ('379', '369', '369', '百色市', '2', '1', '0', 'bss', '百色液压布料机厂家', '百色布料机价格,百色液压布料机,百色液压布料机厂家', '百色布料机专业生产厂家联系电话：17858811257', '100', '1655435799', '1655435799');
INSERT INTO `ey_weapp_multicity` VALUES ('380', '369', '369', '贺州市', '2', '1', '0', 'hezhoushi', '贺州混凝土布料机厂家', '贺州混凝土布料机价格,贺州混凝土布料机,贺州混凝土布料机厂家', '贺州混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655435900', '1655435900');
INSERT INTO `ey_weapp_multicity` VALUES ('381', '369', '369', '河池市', '2', '1', '0', 'hechi', '河池液压布料机厂家', '河池布料机价格,河池液压布料机,河池液压布料机厂家', '河池布料机专业生产厂家联系电话：17858811257', '100', '1655436199', '1655436199');
INSERT INTO `ey_weapp_multicity` VALUES ('382', '369', '369', '来宾市', '2', '1', '0', 'laibing', '来宾液压布料机厂家', '来宾布料机价格,来宾液压布料机,来宾液压布料机厂家', '来宾布料机专业生产厂家联系电话：17858811257', '100', '1655442556', '1655442556');
INSERT INTO `ey_weapp_multicity` VALUES ('383', '369', '369', '崇左市', '2', '1', '0', 'chongzuo', '崇左混凝土布料机厂家', '崇左混凝土布料机价格,崇左混凝土布料机,崇左混凝土布料机厂家', '崇左混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655442635', '1655442635');
INSERT INTO `ey_weapp_multicity` VALUES ('384', '0', '0', '西藏自治区', '1', '1', '0', 'xizang', '西藏液压布料机厂家', '西藏布料机价格,西藏液压布料机,西藏液压布料机厂家', '西藏布料机专业生产厂家联系电话：17858811257', '100', '1655442717', '1655442717');
INSERT INTO `ey_weapp_multicity` VALUES ('385', '384', '384', '拉萨市', '2', '1', '0', 'lasa', '拉萨液压布料机厂家', '拉萨布料机价格,拉萨液压布料机,拉萨液压布料机厂家', '拉萨布料机专业生产厂家联系电话：17858811257', '100', '1655443531', '1655443531');
INSERT INTO `ey_weapp_multicity` VALUES ('386', '384', '384', '日喀则市', '2', '1', '0', 'rikaze', '日喀则混凝土布料机厂家', '日喀则混凝土布料机价格,日喀则混凝土布料机,日喀则混凝土布料机厂家', '日喀则混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655443634', '1655443634');
INSERT INTO `ey_weapp_multicity` VALUES ('387', '384', '384', '山南市', '2', '1', '0', 'shannan', '山南液压布料机厂家', '山南布料机价格,山南液压布料机,山南液压布料机厂家', '山南布料机专业生产厂家联系电话：17858811257', '100', '1655443742', '1655443742');
INSERT INTO `ey_weapp_multicity` VALUES ('388', '384', '384', '林芝市', '2', '1', '0', 'linzhi', '林芝液压布料机厂家', '林芝布料机价格,林芝液压布料机,林芝液压布料机厂家', '林芝布料机专业生产厂家联系电话：17858811257', '100', '1655444220', '1655444220');
INSERT INTO `ey_weapp_multicity` VALUES ('389', '384', '384', '昌都市', '2', '1', '0', 'changdu', '昌都混凝土布料机厂家', '昌都混凝土布料机价格,昌都混凝土布料机,昌都混凝土布料机厂家', '昌都混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655444376', '1655444376');
INSERT INTO `ey_weapp_multicity` VALUES ('390', '384', '384', '那曲市', '2', '1', '0', 'naqu', '那曲液压布料机厂家', '那曲布料机价格,那曲液压布料机,那曲液压布料机厂家', '那曲布料机专业生产厂家联系电话：17858811257', '100', '1655444458', '1655444458');
INSERT INTO `ey_weapp_multicity` VALUES ('391', '0', '0', '宁夏回族自治区', '1', '1', '0', 'ningxiahuizu', '宁夏混凝土布料机厂家', '宁夏混凝土布料机价格,宁夏混凝土布料机,宁夏混凝土布料机厂家', '宁夏市混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655444592', '1655444592');
INSERT INTO `ey_weapp_multicity` VALUES ('393', '391', '391', '银川市', '2', '1', '0', 'yinchuan', '银川液压布料机厂家', '银川布料机价格,银川液压布料机,银川液压布料机厂家', '银川布料机专业生产厂家联系电话：17858811257', '100', '1655444991', '1655444991');
INSERT INTO `ey_weapp_multicity` VALUES ('394', '391', '391', '石嘴山市', '2', '1', '0', 'shizuishan', '石嘴山混凝土布料机厂家', '石嘴山混凝土布料机价格,石嘴山混凝土布料机,石嘴山混凝土布料机厂家', '石嘴山混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445081', '1655445081');
INSERT INTO `ey_weapp_multicity` VALUES ('395', '391', '391', '吴忠市', '2', '1', '0', 'wuzhong', '吴忠液压布料机厂家', '吴忠布料机价格,吴忠液压布料机,吴忠液压布料机厂家', '吴忠布料机专业生产厂家联系电话：17858811257', '100', '1655445206', '1655445206');
INSERT INTO `ey_weapp_multicity` VALUES ('396', '391', '391', '固原市', '2', '1', '0', 'guyuan', '固原液压布料机厂家', '固原布料机价格,固原液压布料机,固原液压布料机厂家', '固原布料机专业生产厂家联系电话：17858811257', '100', '1655445291', '1655445291');
INSERT INTO `ey_weapp_multicity` VALUES ('397', '391', '391', '中卫市', '2', '1', '0', 'zhongwei', '中卫混凝土布料机厂家', '中卫混凝土布料机价格,中卫混凝土布料机,中卫混凝土布料机厂家', '中卫混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445372', '1655445372');
INSERT INTO `ey_weapp_multicity` VALUES ('398', '0', '0', '新疆维吾尔自治区', '1', '1', '0', 'xinjiang', '新疆混凝土布料机厂家', '新疆混凝土布料机价格,新疆混凝土布料机,新疆混凝土布料机厂家', '新疆混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655445482', '1655445482');
INSERT INTO `ey_weapp_multicity` VALUES ('399', '398', '398', '乌鲁木齐', '2', '1', '0', 'wulumuqi', '乌鲁木齐液压布料机厂家', '乌鲁木齐布料机价格,乌鲁木齐液压布料机,乌鲁木齐液压布料机厂家', '乌鲁木齐布料机专业生产厂家联系电话：17858811257', '100', '1655445694', '1655445694');
INSERT INTO `ey_weapp_multicity` VALUES ('400', '398', '398', '克拉玛依', '2', '1', '0', 'kelamayi', '克拉玛依混凝土布料机厂家', '克拉玛依混凝土布料机价格,克拉玛依混凝土布料机,克拉玛依混凝土布料机厂家', '克拉玛依混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655446070', '1655446070');
INSERT INTO `ey_weapp_multicity` VALUES ('401', '398', '398', '吐鲁番', '2', '1', '0', 'tulufan', '吐鲁番液压布料机厂家', '吐鲁番布料机价格,吐鲁番液压布料机,吐鲁番液压布料机厂家', '吐鲁番布料机专业生产厂家联系电话：17858811257', '100', '1655446375', '1655446375');
INSERT INTO `ey_weapp_multicity` VALUES ('402', '398', '398', '哈密市', '2', '1', '0', 'hami', '哈密混凝土布料机厂家', '哈密混凝土布料机价格,哈密混凝土布料机,哈密混凝土布料机厂家', '哈密混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655446477', '1655446477');
INSERT INTO `ey_weapp_multicity` VALUES ('403', '0', '0', '香港', '1', '1', '0', 'hk', '香港混凝土布料机厂家', '香港混凝土布料机价格,香港混凝土布料机,香港混凝土布料机厂家', '香港混凝土布料机专业生产厂家联系电话：17858811257', '100', '1655448070', '1655448070');

-- -----------------------------
-- Table structure for `ey_weapp_picture_cleaning`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_picture_cleaning`;
CREATE TABLE `ey_weapp_picture_cleaning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table_of_ontents` varchar(50) DEFAULT '' COMMENT '移动的目录文件夹名称',
  `url` varchar(255) DEFAULT '' COMMENT '文件地址',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=正常，1=清理',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=786 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_pushall`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushall`;
CREATE TABLE `ey_weapp_pushall` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_pushalltag`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_pushalltag`;
CREATE TABLE `ey_weapp_pushalltag` (
  `aid` int(100) NOT NULL COMMENT '文章ID',
  `baidupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '百度推送状态',
  `shenmapushzt` int(1) NOT NULL DEFAULT '0' COMMENT '神马推送状态',
  `sogoupushzt` int(1) NOT NULL DEFAULT '0' COMMENT '搜狗推送状态',
  `toutiaopushzt` int(1) NOT NULL DEFAULT '0' COMMENT '头条推送状态',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_weapp_qqlogin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_qqlogin`;
CREATE TABLE `ey_weapp_qqlogin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT 'openid',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ昵称',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `sta` tinyint(1) NOT NULL DEFAULT '0' COMMENT '修改用户名或者绑定已有账号标识,0-未标记,1-已标记',
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='qq登陆记录表';


-- -----------------------------
-- Table structure for `ey_weapp_sitecollect`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollect`;
CREATE TABLE `ey_weapp_sitecollect` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '' COMMENT '任务名称',
  `typeid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集栏目',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  `is_desc` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否倒序采集',
  `is_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '入库状态(1=显示，0=屏蔽(草稿))',
  `is_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否获取第一张图片为封面',
  `is_filt_repet` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤重复标题',
  `is_local` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '图片是否本地保存',
  `filt_iframe` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否过滤Iframe',
  `filt_js` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_a` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_style` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_object` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_note` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_table` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_img` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_embed` tinyint(1) NOT NULL DEFAULT '0',
  `filt_param` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_b` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filt_div_e` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `get_style` tinyint(1) unsigned NOT NULL DEFAULT '2' COMMENT '获取方式，1：手工输入，2：批量生成',
  `url_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '网址规则',
  `min_id` int(6) unsigned NOT NULL DEFAULT '1' COMMENT '最小值页码',
  `max_id` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '最大值页码',
  `list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表规则',
  `a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面链接规则',
  `a_involve` varchar(100) NOT NULL DEFAULT '' COMMENT '必须包含',
  `a_exclusive` varchar(100) NOT NULL DEFAULT '' COMMENT '不能包含',
  `is_list_litpic` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '获取列表缩略图',
  `litpic_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '列表缩略图规则',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否文章分页',
  `page_a_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '页面正则代码',
  `page_list_rule` varchar(255) NOT NULL DEFAULT '' COMMENT '分页正则代码',
  `sort_order` int(6) unsigned NOT NULL DEFAULT '100',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态，1：启用，0：锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='文章采集任务列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollect`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollect` VALUES ('1', '示例任务(示例网址：http://www.zzfrjt.com/nba/index_2.html)', '10', '1589179925', '1589179925', '1', '1', '1', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '2', 'http://www.zzfrjt.com/nba/index_{{id}}.html', '2', '3', '&lt;ul id=\'listNewsTimeLy\' class=&quot;listNewsTimeLy&quot;&gt;[内容]&lt;div class=&quot;pagnation&quot; id=&quot;pagnation&quot; style=&quot;padding-bottom:30px;&quot;&gt;', '&lt;a class=&quot;J-share-a&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;&gt;', '', '', '1', '&lt;img class=&quot;animation&quot; src=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('2', '电脑站模板采集', '13', '1589179954', '1589338310', '1', '0', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '', '1', '0', '&lt;ul class=&quot;blocks-2 blocks-lg-3 met-pager-ajax met-grid&quot;&gt;\r\n[内容]\r\n        &lt;/ul&gt;\r\n      &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n', '&lt;figure class=&quot;widget-header cover&quot;&gt; &lt;a href=&quot;[内容]&quot;', '', '', '1', '&lt;img class=&quot;cover-image&quot; data-original=&quot;[内容]&quot;', '0', '', '', '100', '1');
INSERT INTO `ey_weapp_sitecollect` VALUES ('4', '新闻采集', '24', '1589330098', '1589330918', '1', '1', '0', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', 'https://www.shwlz.com/jzzx.html?pagesize=10&amp;p=3', '1', '0', '&lt;ul class=&quot;textlist&quot;&gt;[内容]&lt;/ul&gt;', '', '', '', '0', '', '0', '', '', '100', '1');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_record`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_record`;
CREATE TABLE `ey_weapp_sitecollet_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `url_list` text NOT NULL COMMENT '执行url集合（json格式）',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COMMENT='文章采集记录列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_record`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('37', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/\"]', '1589186342', '1589186342');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('38', '3', '案例采集', '[\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_15.html\",\"https:\\/\\/www.eyoucms.com\\/anli\\/list_4_14.html\"]', '1589188627', '1589188627');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('39', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_2.html\"]', '1589251086', '1589251086');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('40', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/jzzx.html?pagesize=10&amp;p=3\"]', '1589330331', '1589330331');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('41', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/seo.html?pagesize=10&amp;p=1\"]', '1589330512', '1589330512');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('42', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/wxyx.html\"]', '1589330764', '1589330764');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('43', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/xwdt.html\"]', '1589330842', '1589330842');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('44', '4', '新闻采集', '[\"https:\\/\\/www.shwlz.com\\/faq.html?pagesize=20&amp;p=1\"]', '1589330945', '1589330945');
INSERT INTO `ey_weapp_sitecollet_record` VALUES ('45', '2', '电脑站模板采集', '[\"https:\\/\\/www.eyoucms.com\\/moban\\/list_3_21.html\"]', '1589338349', '1589338349');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_rule`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_rule`;
CREATE TABLE `ey_weapp_sitecollet_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '字段别名（中文）',
  `rule` varchar(255) NOT NULL DEFAULT '' COMMENT '采集规则',
  `origin` varchar(255) NOT NULL DEFAULT '' COMMENT '初始字符串',
  `replace` varchar(255) NOT NULL DEFAULT '' COMMENT '替换字符串',
  `default` varchar(255) NOT NULL DEFAULT '' COMMENT '默认值（不采集）',
  `is_page` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于分页',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=utf8 COMMENT='文章采集规则列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_rule`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('37', '1', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('38', '1', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('39', '1', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('40', '1', 'litpic', '缩略图', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('41', '1', 'title', '标题', '&lt;h1&gt;&lt;span&gt;[内容]&lt;/span&gt;&lt;/h1&gt;', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('42', '1', 'content', '内容详情', '&lt;div class=&quot;J-contain_detail_cnt contain_detail_cnt&quot;&gt;[内容]&lt;p&gt;上一篇', '', '', '', '1', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('43', '1', 'add_time', '新增时间', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('44', '1', 'duoxuan', '多选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('45', '1', 'xialakuang', '下拉框测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('46', '1', 'danxuan', '但选项测试', '', '', '', '', '0', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('358', '2', 'users_price', '价格', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('356', '2', 'diy_mbbh', '模板编号', '&lt;dd&gt;模板编号：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('357', '2', 'diy_webewm', '网站二维码', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('355', '2', 'diy_pcys', '电脑站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('354', '2', 'diy_mbys', '手机站演示地址', '&lt;a id=&quot;collect-btn&quot; class=&quot;collect-btn nonofavV3&quot; href=&quot;[内容]&quot; target=&quot;_blank&quot;  rel=&quot;nofollow&quot;&gt;模板演示&lt;/a&gt;\r\n', '/plus/', 'https://www.eyoucms.com/plus/', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('349', '2', 'seo_keywords', 'SEO关键词', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('352', '2', 'yanse', '颜色', '&lt;dd&gt;模板颜色：[内容]&lt;/dd&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('353', '2', 'sshy', '所属行业', 'class=&quot;cjzy&quot;&gt;[内容]&lt;/a&gt;', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('347', '2', 'litpic', '缩略图', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('348', '2', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('302', '4', 'alwz', '案例网址', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('299', '4', 'seo_keywords', 'SEO关键词', '', '东莞建站公司,企业网站建设,公司网站定制,企业网站优化,网络', '企业网站建设', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('300', '4', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('301', '4', 'add_time', '新增时间', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('297', '4', 'litpic', '缩略图', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('298', '4', 'seo_title', 'SEO标题', '', '', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('296', '4', 'content', '内容详情', '&lt;div class=&quot;InfoContent&quot;&gt;[内容]&lt;div class=&quot;Tag&quot;&gt;', '', '', '', '1', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('295', '4', 'title', '标题', '&lt;div class=&quot;InfoTitle&quot;&gt;&lt;h1&gt;[内容]&lt;/h1&gt;&lt;/div&gt;\r\n', '东莞', '', '', '0', '1589330918', '1589330918');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('351', '2', 'add_time', '新增时间', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('350', '2', 'seo_description', 'SEO描述', '', '', '', '', '0', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('346', '2', 'content', '内容详情', '&lt;div class=&quot;clearfix&quot;&gt;[内容]&lt;/div&gt;\r\n', '', '', '', '1', '1589338310', '1589338310');
INSERT INTO `ey_weapp_sitecollet_rule` VALUES ('345', '2', 'title', '标题', '&lt;h1&gt;\r\n            [内容]\r\n            &lt;/h1&gt;', '', '', '', '0', '1589338310', '1589338310');

-- -----------------------------
-- Table structure for `ey_weapp_sitecollet_urllist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_sitecollet_urllist`;
CREATE TABLE `ey_weapp_sitecollet_urllist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `collectid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '采集列表id',
  `url` varchar(512) NOT NULL DEFAULT '' COMMENT '文章url',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `collectid` (`collectid`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COMMENT='文章采集链接列表';

-- -----------------------------
-- Records of `ey_weapp_sitecollet_urllist`
-- -----------------------------
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('37', '1', 'http://www.zzfrjt.com/nba/index_3.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('38', '1', 'http://www.zzfrjt.com/nba/index_2.html', '1589179925', '1589179925');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('62', '2', 'https://www.eyoucms.com/moban/list_3_21.html', '1589338258', '1589338258');
INSERT INTO `ey_weapp_sitecollet_urllist` VALUES ('61', '4', 'https://www.shwlz.com/faq.html?pagesize=20&amp;p=1', '1589330889', '1589330889');

-- -----------------------------
-- Table structure for `ey_weapp_spider_tongji`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_spider_tongji`;
CREATE TABLE `ey_weapp_spider_tongji` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spider` int(10) NOT NULL DEFAULT '0' COMMENT '蜘蛛分类',
  `total` int(10) NOT NULL DEFAULT '0' COMMENT '蜘蛛统计',
  `month` int(10) NOT NULL DEFAULT '0' COMMENT '最近30天',
  `week` int(10) NOT NULL DEFAULT '0' COMMENT '当周',
  `pre_week` int(10) NOT NULL DEFAULT '0' COMMENT '上一周',
  `day` int(10) NOT NULL DEFAULT '0' COMMENT '当天',
  `pre_day` int(10) NOT NULL DEFAULT '0' COMMENT '昨天',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `spider` (`spider`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_spider_tongji`
-- -----------------------------
INSERT INTO `ey_weapp_spider_tongji` VALUES ('1', '99', '45152', '2814', '329', '722', '101', '136', '1603780570', '1662512757');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('2', '3', '5473', '171', '15', '31', '2', '8', '1603784549', '1662506860');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('3', '1', '32000', '1058', '76', '350', '17', '32', '1603785024', '1662509317');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('4', '4', '727', '45', '10', '8', '2', '3', '1603787463', '1662129759');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('5', '2', '13726', '771', '68', '188', '16', '23', '1603802050', '1662512792');
INSERT INTO `ey_weapp_spider_tongji` VALUES ('6', '6', '2097', '156', '15', '28', '3', '8', '1604092131', '1662510966');

-- -----------------------------
-- Table structure for `ey_weapp_spider_visit`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp_spider_visit`;
CREATE TABLE `ey_weapp_spider_visit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spider` int(10) DEFAULT '0' COMMENT '蜘蛛分类',
  `useragent` varchar(500) DEFAULT '' COMMENT '蜘蛛标识',
  `url` varchar(500) DEFAULT '' COMMENT '抓取的URL',
  `ip` varchar(20) DEFAULT '' COMMENT '蜘蛛ip',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `spider` (`spider`)
) ENGINE=MyISAM AUTO_INCREMENT=99213 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_weapp_spider_visit`
-- -----------------------------
INSERT INTO `ey_weapp_spider_visit` VALUES ('95066', '3', 'sogou web spider/4.0(+http://www.sogou.com/docs/help/webmasters.htm#07)', '/', '58.250.125.149', '1660606159', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95075', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/news/436.html', '185.191.171.4', '1660611263', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95076', '99', 'mozilla/5.0 (compatible; dotbot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)', '/news/92.html', '216.244.66.194', '1660612094', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95065', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/products/75.html?admin_id=1', '185.191.171.17', '1660604867', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95059', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/news/434.html', '114.119.151.153', '1660600757', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95058', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/news/356.html', '185.191.171.25', '1660600355', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95060', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/products/324.html', '185.191.171.2', '1660601022', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95071', '99', 'mozilla/5.0 (compatible; semrushbot/7~bl; +http://www.semrush.com/bot.html)', '/news/list_3_35/', '185.191.171.43', '1660609228', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95054', '99', 'mozilla/5.0 (linux; android 7.0;) applewebkit/537.36 (khtml, like gecko) mobile safari/537.36 (compatible; petalbot;+https://webmaster.petalsearch.com/site/petalbot)', '/news/398.html', '114.119.151.155', '1660599909', '0');
INSERT INTO `ey_weapp_spider_visit` VALUES ('95