<?php

namespace app\admin\behavior;

/**
 * 系统行为扩展：
 */
class AppEndBehavior {
    protected static $actionName;
    protected static $controllerName;
    protected static $moduleName;
    protected static $method;

    /**
     * 构造方法
     * @param Request $request Request对象
     * @access public
     */
    public function __construct()
    {

    }

    // 行为扩展的执行入口必须是run
    public function run(&$params){
        self::$actionName = request()->action();
        self::$controllerName = request()->controller();
        self::$moduleName = request()->module();
        self::$method = request()->method();
        // file_put_contents ( DATA_PATH."log.txt", date ( "Y-m-d H:i:s" ) . "  " . var_export('admin_CoreProgramBehavior',true) . "\r\n", FILE_APPEND );
        $this->_initialize();
    }

    private function _initialize() {
        $this->resetAuthor(); // 临时处理授权问题
        $this->clearHtmlCache(); // 变动数据之后，清除页面缓存和数据
    }

    /**
     * 临时处理授权问题
     */
    private function resetAuthor()
    {
        /*在以下相应的控制器和操作名里执行，以便提高性能*/
        $ctlActArr = array(
            'Index@index',
        );
        $ctlActStr = self::$controllerName.'@'.self::$actionName;
        if (in_array($ctlActStr, $ctlActArr) && 'GET' == self::$method) {
            if(!empty($_SESSION['isset_resetAuthor']))
                return true;
            $_SESSION['isset_resetAuthor'] = 1;

            session('isset_author', null);
        }
        /*--end*/
    }

    /**
     * 数据变动之后，清理页面和数据缓存
     */
    private function clearHtmlCache()
    {
        /*在以下相应的控制器和操作名里执行，以便提高性能*/
        $actArr = ['add','edit','del','recovery','changeTableVal'];
        if ('POST' == self::$method) {
            foreach ($actArr as $key => $val) {
                if (preg_match('/^((.*)_)?('.$val.')$/i', self::$actionName) || preg_match('/^(ajax_)?'.$val.'(_(.*))?$/i', self::$actionName)) {
                    $aids = [];
                    if (!empty($_POST['aids'])) {
                        $aids = $_POST['aids'];
                    } else if (!empty($_POST['aid'])) {
                        $aids = [$_POST['aid']];
                    }
                    if (!empty($aids)) {
                        $typeids = [];
                        $archivesList = \think\Db::name('archives')->field('aid,typeid,stypeid')->where(['aid'=>['IN', $aids]])->select();
                        foreach ($archivesList as $_k => $_v) {
                            $typeids[] = $_v['typeid'];
                            $_v['stypeid'] = trim($_v['stypeid'], ',');
                            $stypeid = explode(',', $_v['stypeid']);
                            foreach ($stypeid as $_k2 => $_v2) {
                                $typeids[] = $_v2;
                            }
                        }

                        $filelist = [];
                        // 文档
                        foreach ($aids as $_k => $_v) {
                            $arr = glob(HTML_ROOT.'view'.DS."*_{$_v}.html");
                            if (is_array($arr)) {
                                $filelist = array_merge($filelist, $arr);
                            }
                        }
                        // 文档涉及的所有相关栏目ID
                        $typeid_list = $this->getAllPid($typeids);
                        foreach ($typeid_list as $_k => $_v) {
                            $arr = glob(HTML_ROOT.'lists'.DS."*_{$_v['id']}.html");
                            if (is_array($arr)) {
                                $filelist = array_merge($filelist, $arr);
                            }
                        }
                        // tag标签
                        $tagids = \think\Db::name('taglist')->where(['aid'=>['IN', $aids]])->group('tid')->column('tid');
                        foreach ($tagids as $_k => $_v) {
                            $arr = glob(HTML_ROOT.'tags'.DS."*_{$_v}.html");
                            if (is_array($arr)) {
                                $filelist = array_merge($filelist, $arr);
                            }
                        }
                        // 删除页面缓存文件
                        foreach ($filelist as $_k => $_v) {
                            @unlink($_v);
                        }
                    }
                    \think\Cache::clear();
                    // delFile(HTML_ROOT.'lists');
                    delFile(HTML_ROOT.'index');
                    break;
                }
            }
        }
    }

    /**
     * 获取当前栏目的所有父级
     * @author wengxianhu by 2018-4-26
     */
    private function getAllPid($ids = [])
    {
        $data = array();
        $arctype_list = model('Arctype')->getAll('id,parent_id', [], 'id');
        foreach ($ids as $key => $typeid) {
            if (isset($arctype_list[$typeid])) {
                // 第一个先装起来
                $data[$typeid] = $arctype_list[$typeid];
            }

            while (true)
            {
                $typeid = $arctype_list[$typeid]['parent_id'];
                if($typeid > 0){
                    if (isset($arctype_list[$typeid])) {
                        $data[$typeid] = $arctype_list[$typeid];
                    }
                } else {
                    break;
                }
            }
        }

        !empty($data) && $data = array_reverse($data, true);

        return $data;
    }
}
