### Your Journey with Go

Google's Go Programming language (often called GoLang for clarity), is one of today's fastest-growing languages and has one of the highest developer satisifaction ratings in the industry -- Go developers love coding in Go!

Combined with Docker, it creates an expressive, portable, and scalable foundation for building production web services -- and that's what we're going to get a quick introduction to in this course!

### Prerequisites

Prior to starting this course, you should have:

* Basic understanding of what Go, REST APIs, JSON, and Docker are (as well as their use-cases)

* Familiarity with a C++ or Java-like programming language (this will make reading Go pretty easy for you)

* Basic POSIX shell/bash familiarity (i.e., you know what `cd`, `mkdir`, et al. do)

* Go installed [from official Go site](https://golang.org/dl). These demos use Go 1.11.2, however, any recent Go 1.X.X version should work

* Go `dep` package manager installed [from official Go project](https://github.com/golang/dep)

* Docker installed via [docker site](https://docs.docker.com/install). These demos use docker `18.06.1-ce`, but any recent installation should work just fine

* Docker compose installed if you didn't get it as part of your initial docker install [from here](https://docs.docker.com/compose/install). Note that this might come separately on some Docker installations

### Reference Full Code

For reference (or lazy typists!) you may find the full reference source of this project on GitHub <a rel="noopener" target="_blank" href="https://github.com/exlskills/demo-go-webservice">here</a>.

### Ready to Build a Scalable Web Service with Docker and Go?!

Prepare for 🚀 with this Open Course from EXLskills! It's going to be FAST, so let's start hacking!
