# ml-surveys

It's hard to keep up with the latest and greatest in machine learning. Here's a selection of **survey papers summarizing the advances in the field**.

[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](./CONTRIBUTING.md)

Figuring out how to implement your ML project? Learn how other organizations did it 👉[`applied-ml`](https://github.com/eugeneyan/applied-ml)

**Table of Contents**

- [Recommendation](#recommendation)
- [Deep Learning](#deep-learning)
- [Natural Language Processing](#natural-language-processing)
- [Computer Vision](#computer-vision)
- [Vision and Language](#vision-and-language)
- [Reinforcement Learning](#reinforcement-learning)
- [Graph](#graph)
- [Embeddings](#embeddings)
- [Meta-learning and Few-shot Learning](#meta-learning-and-few-shot-Learning)
- [Others](#others)

## Recommendation
- Algorithms: [Recommender systems survey (2013)](http://irntez.ir/wp-content/uploads/2016/12/sciencedirec.pdf)
- Algorithms: [Deep Learning based Recommender System: A Survey and New Perspectives (2019)](https://arxiv.org/pdf/1707.07435.pdf)
- Algorithms: [Are We Really Making Progress? An Analysis of Neural Recommendation Approaches (2019)](https://arxiv.org/pdf/1907.06902.pdf)
- Serendipity: [A Survey of Serendipity in Recommender Systems (2016)](https://www.researchgate.net/publication/306075233_A_Survey_of_Serendipity_in_Recommender_Systems)
- Diversity: [Diversity in Recommender Systems – A survey (2017)](https://papers-gamma.link/static/memory/pdfs/153-Kunaver_Diversity_in_Recommender_Systems_2017.pdf)
- Explanations: [A Survey of Explanations in Recommender Systems (2007)](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.418.9237&rep=rep1&type=pdf)

## Deep Learning
- Architecture: [A State-of-the-Art Survey on Deep Learning Theory and Architectures (2019)](https://www.mdpi.com/2079-9292/8/3/292/htm)
- Knowledge distillation: [Knowledge Distillation: A Survey (2021)](https://arxiv.org/pdf/2006.05525.pdf)
- Model compression: [Compression of Deep Learning Models for Text: A Survey (2020)](https://arxiv.org/pdf/2008.05221.pdf)
- Transfer learning: [A Survey on Deep Transfer Learning (2018)](https://arxiv.org/pdf/1808.01974.pdf)
- Neural architecture search: [A Comprehensive Survey of Neural Architecture Search (2021)](https://arxiv.org/abs/2006.02903)
- Neural architecture search: [Neural Architecture Search: A Survey (2019)](https://arxiv.org/abs/1808.05377)

## Natural Language Processing
- Deep Learning: [Recent Trends in Deep Learning Based Natural Language Processing (2018)](https://arxiv.org/pdf/1708.02709.pdf)
- Classification: [Deep Learning Based Text Classification: A Comprehensive Review (2021)](https://arxiv.org/pdf/2004.03705)
- Generation: [Survey of the SOTA in Natural Language Generation: Core tasks, applications and evaluation (2018)](https://www.jair.org/index.php/jair/article/view/11173/26378)
- Generation: [Neural Language Generation: Formulation, Methods, and Evaluation (2020)](https://arxiv.org/pdf/2007.15780.pdf)
- Transfer learning: [Exploring Transfer Learning with T5: the Text-To-Text Transfer Transformer (2020)](https://arxiv.org/abs/1910.10683)
- Transformers: [Efficient Transformers: A Survey (2020)](https://arxiv.org/pdf/2009.06732.pdf)
- Metrics: [Beyond Accuracy: Behavioral Testing of NLP Models with CheckList (2020)](https://arxiv.org/pdf/2005.04118.pdf)
- Metrics: [Evaluation of Text Generation: A Survey (2020)](https://arxiv.org/pdf/2006.14799.pdf)

## Computer Vision
- Object detection: [Object Detection in 20 Years (2019)](https://arxiv.org/pdf/1905.05055.pdf)
- Adversarial attacks: [Threat of Adversarial Attacks on Deep Learning in Computer Vision (2018)](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=8294186)
- Autonomous vehicles: [Computer Vision for Autonomous Vehicles: Problems, Datasets and SOTA (2021)](https://arxiv.org/pdf/1704.05519.pdf)
- Image Captioning: [A Comprehensive Survey of Deep Learning for Image Captioning (2018)](https://arxiv.org/pdf/1810.04020.pdf)
- Instance Segmentation: [A Survey on Instance Segmentation: State of the art](https://arxiv.org/abs/2007.00047)
- Vision Transformer: [A Survey on Vision Transformer](https://arxiv.org/abs/2012.12556)
- Architectures: [Review of deep learning: concepts, CNN architectures, challenges, applications, future directions](https://link.springer.com/article/10.1186/s40537-021-00444-8)
- Transformers: [Transformers in Vision: A Survey](https://arxiv.org/abs/2101.01169)

## Vision and Language

- Trends: [Trends in Integration of Vision and Language Research: Tasks, Datasets, and Methods (2021)](https://doi.org/10.1613/jair.1.11688) 
- Trends: [Multimodal Research in Vision and Language: Current and Emerging Trends (2020)](https://arxiv.org/abs/2010.09522) 

## Reinforcement Learning
- Algorithms: [A Brief Survey of Deep Reinforcement Learning (2017)](https://arxiv.org/pdf/1708.05866.pdf)
- Transfer learning: [Transfer Learning for Reinforcement Learning Domains (2009)](http://www.jmlr.org/papers/volume10/taylor09a/taylor09a.pdf)
- Economics: [Review of Deep Reinforcement Learning Methods and Applications in Economics (2020)](https://arxiv.org/pdf/2004.01509.pdf)
- Discovery: [Deep Reinforcement Learning for Search, Recommendation, and Online Advertising (2018)](https://arxiv.org/pdf/1812.07127.pdf)

## Graph
- Survey: [A Comprehensive Survey on Graph Neural Networks (2019)](https://arxiv.org/pdf/1901.00596.pdf)
- Survey: [A Practical Guide to Graph Neural Networks (2020)](https://arxiv.org/pdf/2010.05234.pdf)
- Fraud detection: [A systematic literature review of graph-based anomaly detection approaches (2020)](https://www.sciencedirect.com/science/article/pii/S0167923620300580)
- Knowledge graphs: [A Comprehensive Introduction to Knowledge Graphs (2021)](https://arxiv.org/pdf/2003.02320.pdf)

## Embeddings
- Text: [From Word to Sense Embeddings:A Survey on Vector Representations of Meaning (2018)](https://www.jair.org/index.php/jair/article/view/11259/26454)
- Text: [Diachronic Word Embeddings and Semantic Shifts (2018)](https://arxiv.org/pdf/1806.03537.pdf)
- Text: [Word Embeddings: A Survey (2019)](https://arxiv.org/abs/1901.09069)
- Text: [A Reproducible Survey on Word Embeddings and Ontology-based Methods for Word Similarity (2019)](https://doi.org/10.1016/j.engappai.2019.07.010)
- Graph: [A Comprehensive Survey of Graph Embedding: Problems, Techniques and Applications (2017)](https://arxiv.org/pdf/1709.07604)

## Meta-learning and Few-shot Learning
- NLP: [Meta-learning for Few-shot Natural Language Processing: A Survey (2020)](https://arxiv.org/abs/2007.09604)
- Domain Agnostic: [Learning from Few Samples: A Survey (2020)](https://arxiv.org/abs/2007.15484)
- Neural Networks: [Meta-Learning in Neural Networks: A Survey (2020)](https://arxiv.org/abs/2004.05439)
- Domain Agnostic: [A Comprehensive Overview and Survey of Recent Advances in Meta-Learning (2020)](https://arxiv.org/abs/2004.11149)
- Domain Agnostic: [Baby steps towards few-shot learning with multiple semantics (2020)](https://arxiv.org/abs/1906.01905)
- Domain Agnostic: [Meta-Learning: A Survey (2018)](https://arxiv.org/abs/1810.03548)
- Domain Agnostic: [A Perspective View And Survey Of Meta-learning (2002)](https://www.researchgate.net/publication/2375370_A_Perspective_View_And_Survey_Of_Meta-Learning)

## Others
- Transfer learning: [A Survey on Transfer Learning (2009)](https://www.cse.ust.hk/~qyang/Docs/2009/tkde_transfer_learning.pdf)
