# Contributing to `ethereum-boilerplate`

## Setting up the project for debugging and contributing

### Setting up you local machine:

- [Fork](https://github.com/ethereum-boilerplate/ethereum-boilerplate) this project and clone the fork on your local machine:

```sh
git clone https://github.com/ethereum-boilerplate/ethereum-boilerplate.git
cd ethereum-boilerplate # go into the clone directory
npm install # install all the node dependencies
```

Make sure to have a ESlint and Prettier plugin installed to check for code-smells and auto-formatting.

### Pull Requests

1. Fork the repo and create your branch from `main`.
2. Make sure your code lints and is correctly formatted.

### Known Issues

We use GitHub issues to track public bugs. We will keep a close eye on this and try to make it clear when we have an internal fix in progress. Before filing a new issue, try to make sure your problem doesn't already exist.

### Coding Style

Please follow the [Coding Style](https://github.com/ethereum-boilerplate/ethereum-boilerplate/blob/main/CODING_STYLE.md).

## License

By contributing to the ethereum-boilerplate, you agree that your contributions will be licensed under its license.
