/*
 * Decompiled with CFR 0.152.
 */
package rife.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import rife.CoreVersion;
import rife.tools.InnerClassException;
import rife.tools.exceptions.FileUtilsErrorException;

public final class FileUtils {
    public static final Pattern JAVA_FILE_PATTERN = Pattern.compile("^.*\\.java$");
    public static final Pattern JAR_FILE_PATTERN = Pattern.compile("^.*\\.jar$");
    private static final int S_IRUSR = 256;
    private static final int S_IWUSR = 128;
    private static final int S_IXUSR = 64;
    private static final int S_IRGRP = 32;
    private static final int S_IWGRP = 16;
    private static final int S_IXGRP = 8;
    private static final int S_IROTH = 4;
    private static final int S_IWOTH = 2;
    private static final int S_IXOTH = 1;

    private FileUtils() {
    }

    public static List<String> getFileList(File dir) {
        return FileUtils.getFileList(dir, null, null, true);
    }

    public static List<String> getFileList(File dir, Pattern included, Pattern excluded) {
        return FileUtils.getFileList(dir, new Pattern[]{included}, new Pattern[]{excluded}, true);
    }

    public static List<String> getFileList(File dir, List<Pattern> included, List<Pattern> excluded) {
        return FileUtils.getFileList(dir, included.toArray(new Pattern[0]), excluded.toArray(new Pattern[0]), true);
    }

    public static List<String> getFileList(File dir, Pattern[] included, Pattern[] excluded) {
        return FileUtils.getFileList(dir, included, excluded, true);
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getFileList(File file, Pattern[] included, Pattern[] excluded, boolean root) {
        if (null == file) {
            return new ArrayList<String>();
        }
        ArrayList<String> file_list = new ArrayList<String>();
        if (file.isDirectory()) {
            String[] list = file.list();
            if (null != list) {
                for (String list_entry : list) {
                    File next_file = new File(file.getAbsolutePath() + File.separator + list_entry);
                    List<String> dir = FileUtils.getFileList(next_file, included, excluded, false);
                    for (String string : dir) {
                        void var13_14;
                        if (root) {
                            if (!FileUtils.filter(string, included, excluded)) {
                                continue;
                            }
                        } else {
                            String string2 = file.getName() + File.separator + string;
                        }
                        int filelist_size = file_list.size();
                        for (int j = 0; j < filelist_size; ++j) {
                            if (file_list.get(j).compareTo((String)var13_14) <= 0) continue;
                            file_list.add(j, (String)var13_14);
                            break;
                        }
                        if (file_list.size() != filelist_size) continue;
                        file_list.add((String)var13_14);
                    }
                }
            }
        } else if (file.isFile()) {
            String file_name = file.getName();
            if (root) {
                if (FileUtils.filter(file_name, included, excluded)) {
                    file_list.add(file_name);
                }
            } else {
                file_list.add(file_name);
            }
        }
        return file_list;
    }

    private static boolean filter(String name, Pattern[] included, Pattern[] excluded) {
        if (null == name) {
            return false;
        }
        boolean accepted = false;
        if (null == included || included.length == 0) {
            accepted = true;
        } else {
            for (Pattern pattern : included) {
                if (pattern == null || !pattern.matcher(name).matches()) continue;
                accepted = true;
                break;
            }
        }
        if (accepted && excluded != null) {
            for (Pattern pattern : excluded) {
                if (pattern == null || !pattern.matcher(name).matches()) continue;
                accepted = false;
                break;
            }
        }
        return accepted;
    }

    public static void moveFile(File source, File target) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (null == target) {
            throw new IllegalArgumentException("target can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException("The source file '" + source.getAbsolutePath() + "' does not exist.");
        }
        FileUtils.copy(source, target);
        FileUtils.deleteFile(source);
    }

    public static void moveDirectory(File source, File target) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (null == target) {
            throw new IllegalArgumentException("target can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException("The source directory '" + source.getAbsolutePath() + "' does not exist.");
        }
        if (!target.exists()) {
            target.mkdirs();
        }
        String[] file_list = source.list();
        assert (file_list != null);
        for (String element : file_list) {
            File current_file = new File(source.getAbsolutePath() + File.separator + element);
            File target_file = new File(target.getAbsolutePath() + File.separator + element);
            if (current_file.isDirectory()) {
                FileUtils.moveDirectory(current_file, target_file);
                continue;
            }
            FileUtils.moveFile(current_file, target_file);
        }
        FileUtils.deleteFile(source);
    }

    public static void deleteDirectory(File source) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (!source.exists()) {
            throw new FileUtilsErrorException("The directory '" + source.getAbsolutePath() + "' does not exist");
        }
        String[] file_list = source.list();
        if (file_list != null) {
            for (String element : file_list) {
                File current_file = new File(source.getAbsolutePath() + File.separator + element);
                if (current_file.isDirectory()) {
                    FileUtils.deleteDirectory(current_file);
                    continue;
                }
                FileUtils.deleteFile(current_file);
            }
        }
        FileUtils.deleteFile(source);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        if (null == outputStream) {
            throw new IllegalArgumentException("outputStream can't be null.");
        }
        try {
            byte[] buffer = new byte[1024];
            int return_value = -1;
            return_value = inputStream.read(buffer);
            while (-1 != return_value) {
                outputStream.write(buffer, 0, return_value);
                return_value = inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error during the copying of streams.", e);
        }
    }

    public static void copy(InputStream inputStream, File target) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        if (null == target) {
            throw new IllegalArgumentException("target can't be null.");
        }
        try (FileOutputStream file_output_stream = new FileOutputStream(target);){
            FileUtils.copy(inputStream, (OutputStream)file_output_stream);
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while copying an input stream to file '" + target.getAbsolutePath() + "'.", e);
        }
    }

    public static void copy(File source, OutputStream outputStream) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (null == outputStream) {
            throw new IllegalArgumentException("outputStream can't be null.");
        }
        try (FileInputStream file_input_stream = new FileInputStream(source);){
            FileUtils.copy((InputStream)file_input_stream, outputStream);
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while copying file '" + source.getAbsolutePath() + "' to an output stream.", e);
        }
    }

    public static void copy(File source, File target) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (null == target) {
            throw new IllegalArgumentException("target can't be null.");
        }
        try (FileInputStream file_input_stream = new FileInputStream(source);
             FileOutputStream file_output_stream = new FileOutputStream(target);){
            FileUtils.copy((InputStream)file_input_stream, (OutputStream)file_output_stream);
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while copying file '" + source.getAbsolutePath() + "' to file '" + target.getAbsolutePath() + "'.", e);
        }
    }

    public static void copyDirectory(File sourceDir, File targetDir) throws FileUtilsErrorException {
        if (null == sourceDir) {
            throw new IllegalArgumentException("sourceDir can't be null.");
        }
        if (null == targetDir) {
            throw new IllegalArgumentException("targetDir can't be null.");
        }
        try {
            String source_path = sourceDir.getAbsolutePath();
            Files.walk(Paths.get(source_path, new String[0]), new FileVisitOption[0]).forEach(source -> {
                String destination_name = source.toString().substring(source_path.length());
                if (!destination_name.isEmpty()) {
                    Path destination = Paths.get(targetDir.getAbsolutePath(), destination_name);
                    try {
                        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        throw new InnerClassException("Error while copying file '" + source.toFile().getAbsolutePath() + "' to file '" + destination.toFile().getAbsolutePath() + "'.", e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while copying directory '" + sourceDir.getAbsolutePath() + "' to directory '" + targetDir.getAbsolutePath() + "'.", e);
        }
        catch (InnerClassException e) {
            throw new FileUtilsErrorException(e.getMessage(), e.getCause());
        }
    }

    public static ByteArrayOutputStream readStream(InputStream inputStream) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        try {
            byte[] buffer = new byte[1024];
            int return_value = -1;
            ByteArrayOutputStream output_stream = new ByteArrayOutputStream(buffer.length);
            return_value = inputStream.read(buffer);
            while (-1 != return_value) {
                output_stream.write(buffer, 0, return_value);
                return_value = inputStream.read(buffer);
            }
            output_stream.close();
            inputStream.close();
            return output_stream;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading the complete contents of an input stream.", e);
        }
    }

    public static String readString(InputStream inputStream) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        return FileUtils.readStream(inputStream).toString(StandardCharsets.UTF_8);
    }

    public static String readString(Reader reader) throws FileUtilsErrorException {
        if (null == reader) {
            throw new IllegalArgumentException("reader can't be null.");
        }
        try {
            char[] buffer = new char[1024];
            StringBuilder result = new StringBuilder();
            int size = reader.read(buffer);
            while (size != -1) {
                result.append(buffer, 0, size);
                size = reader.read(buffer);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading the complete contents of an reader.", e);
        }
    }

    public static String readString(InputStream inputStream, String encoding) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        try {
            return FileUtils.readStream(inputStream).toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new FileUtilsErrorException("Encoding '" + encoding + "' is not supported.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readString(URL source, String encoding) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try {
            URLConnection connection = source.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", "RIFE2 " + CoreVersion.getVersion());
            try (InputStream input_stream = connection.getInputStream();){
                if (null == encoding) {
                    String string2 = FileUtils.readString(input_stream);
                    return string2;
                }
                String string = FileUtils.readString(input_stream, encoding);
                return string;
            }
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading url '" + String.valueOf(source) + ".", e);
        }
    }

    public static String readString(File source) throws FileUtilsErrorException {
        return FileUtils.readString(source, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readString(File source, String encoding) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        try (FileInputStream file_input_stream = new FileInputStream(source);){
            if (null == encoding) {
                String string = FileUtils.readString(file_input_stream);
                return string;
            }
            String string = FileUtils.readString(file_input_stream, encoding);
            return string;
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while reading url '" + source.getAbsolutePath() + ".", e);
        }
    }

    public static String readString(URL source) throws FileUtilsErrorException {
        return FileUtils.readString(source, null);
    }

    public static byte[] readBytes(InputStream inputStream) throws FileUtilsErrorException {
        if (null == inputStream) {
            throw new IllegalArgumentException("inputStream can't be null.");
        }
        return FileUtils.readStream(inputStream).toByteArray();
    }

    public static byte[] readBytes(URL source) throws FileUtilsErrorException {
        byte[] byArray;
        block9: {
            if (null == source) {
                throw new IllegalArgumentException("source can't be null.");
            }
            URLConnection connection = source.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", "RIFE2 " + CoreVersion.getVersion());
            InputStream input_stream = connection.getInputStream();
            try {
                byArray = FileUtils.readBytes(input_stream);
                if (input_stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input_stream != null) {
                        try {
                            input_stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileUtilsErrorException("Error while reading url '" + String.valueOf(source) + ".", e);
                }
            }
            input_stream.close();
        }
        return byArray;
    }

    public static byte[] readBytes(File source) throws FileUtilsErrorException {
        byte[] byArray;
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        FileInputStream file_input_stream = new FileInputStream(source);
        try {
            byArray = FileUtils.readBytes(file_input_stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file_input_stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while reading file '" + source.getAbsolutePath() + ".", e);
            }
        }
        file_input_stream.close();
        return byArray;
    }

    public static void writeBytes(byte[] content, File destination) throws FileUtilsErrorException {
        if (null == content) {
            throw new IllegalArgumentException("content can't be null.");
        }
        if (null == destination) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        try (FileOutputStream file_output_stream = new FileOutputStream(destination);){
            file_output_stream.write(content);
            file_output_stream.flush();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while write a string to '" + destination.getAbsolutePath() + ".", e);
        }
    }

    public static void writeString(String content, File destination) throws FileUtilsErrorException {
        if (null == content) {
            throw new IllegalArgumentException("content can't be null.");
        }
        if (null == destination) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        try (FileWriter file_writer = new FileWriter(destination);){
            file_writer.write(content, 0, content.length());
            file_writer.flush();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while write a string to '" + destination.getAbsolutePath() + ".", e);
        }
    }

    public static void deleteFile(File file) {
        if (null == file) {
            throw new IllegalArgumentException("file can't be null.");
        }
        file.delete();
    }

    public static String getUniqueFilename() {
        Date current_date = new Date();
        return current_date.getTime() + "-" + (long)(1000000.0 * Math.random());
    }

    public static void unzipFile(File source, File destination) throws FileUtilsErrorException {
        if (null == source) {
            throw new IllegalArgumentException("source can't be null.");
        }
        if (null == destination) {
            throw new IllegalArgumentException("destination can't be null.");
        }
        ZipFile zip_file = null;
        Enumeration<? extends ZipEntry> entries = null;
        try {
            zip_file = new ZipFile(source);
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while creating the zipfile '" + source.getAbsolutePath() + "'.", e);
        }
        entries = zip_file.entries();
        byte[] buffer = new byte[1024];
        while (entries.hasMoreElements()) {
            ZipEntry entry = null;
            InputStream input_stream = null;
            String output_filename = null;
            File output_file = null;
            StringBuilder output_file_directory_name = null;
            File output_file_directory = null;
            FileOutputStream file_output_stream = null;
            int count = -1;
            entry = entries.nextElement();
            try {
                input_stream = zip_file.getInputStream(entry);
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while obtaining the input stream for entry '" + entry.getName() + "'.", e);
            }
            output_filename = destination.getAbsolutePath() + File.separator + entry.getName().replace('/', File.separatorChar);
            output_file = new File(output_filename);
            if (entry.isDirectory()) {
                output_file_directory = new File(output_filename);
                if (!output_file_directory.exists()) {
                    if (output_file_directory.mkdirs()) continue;
                    throw new FileUtilsErrorException("Couldn't create directory '" + output_file_directory.getAbsolutePath() + "' and its parents.");
                }
                if (output_file_directory.isDirectory()) continue;
                throw new FileUtilsErrorException("Destination '" + output_file_directory.getAbsolutePath() + "' exists and is not a directory.");
            }
            output_file_directory_name = new StringBuilder(output_file.getPath());
            output_file_directory_name.setLength(output_file_directory_name.length() - output_file.getName().length() - File.separator.length());
            output_file_directory = new File(output_file_directory_name.toString());
            if (!output_file_directory.exists()) {
                if (!output_file_directory.mkdirs()) {
                    throw new FileUtilsErrorException("Couldn't create directory '" + output_file_directory.getAbsolutePath() + "' and its parents.");
                }
            } else {
                if (!output_file_directory.isDirectory()) {
                    throw new FileUtilsErrorException("Destination '" + output_file_directory.getAbsolutePath() + "' exists and is not a directory.");
                }
                if (!output_file_directory.canWrite()) {
                    throw new FileUtilsErrorException("Destination '" + output_file_directory.getAbsolutePath() + "' isn't writable.");
                }
            }
            try {
                file_output_stream = new FileOutputStream(output_filename);
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while creating the output stream for file '" + output_filename + "'.", e);
            }
            try {
                while ((count = input_stream.read(buffer)) != -1) {
                    file_output_stream.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while uncompressing entry '" + output_filename + "'.", e);
            }
            try {
                file_output_stream.close();
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while closing the output stream for file '" + output_filename + "'.", e);
            }
            try {
                input_stream.close();
            }
            catch (IOException e) {
                throw new FileUtilsErrorException("Error while closing the input stream for entry '" + entry.getName() + "'.", e);
            }
        }
        try {
            zip_file.close();
        }
        catch (IOException e) {
            throw new FileUtilsErrorException("Error while closing the zip file '" + source.getAbsolutePath() + "'.", e);
        }
    }

    public static String getBaseName(File file) {
        if (null == file) {
            throw new IllegalArgumentException("file can't be null.");
        }
        return FileUtils.getBaseName(file.getName());
    }

    public static String getBaseName(String fileName) {
        if (null == fileName) {
            throw new IllegalArgumentException("fileName can't be null.");
        }
        String basename = fileName;
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            basename = fileName.substring(0, index);
        }
        return basename;
    }

    public static String getExtension(File file) {
        if (null == file) {
            throw new IllegalArgumentException("file can't be null.");
        }
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        if (null == fileName) {
            throw new IllegalArgumentException("fileName can't be null.");
        }
        String ext = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            ext = fileName.substring(index + 1).toLowerCase();
        }
        return ext;
    }

    @SafeVarargs
    public static List<String> combineToAbsolutePaths(List<File> ... files) {
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List<File> list : files) {
            for (File file : list) {
                result.add(file.getAbsolutePath());
            }
        }
        return result;
    }

    public static String generateDirectoryListing(File directory) throws IOException {
        int trim_prefix = directory.getAbsolutePath().length();
        return Files.walk(Path.of(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]).map(path -> path.toAbsolutePath().toString().substring(trim_prefix).replace(File.separatorChar, '/')).filter(s -> !s.isEmpty()).sorted().collect(Collectors.joining("\n"));
    }

    public static String joinPaths(List<String> paths) {
        if (paths == null) {
            return "";
        }
        return String.join((CharSequence)File.pathSeparator, paths);
    }

    public static List<File> getJavaFileList(File directory) {
        if (directory == null) {
            return Collections.emptyList();
        }
        File dir_abs = directory.getAbsoluteFile();
        return FileUtils.getFileList(dir_abs, JAVA_FILE_PATTERN, null).stream().map(file -> new File(dir_abs, (String)file)).toList();
    }

    public static void transformFiles(File directory, Function<String, String> transformer) throws FileUtilsErrorException {
        FileUtils.transformFiles(directory, null, (Pattern[])null, transformer);
    }

    public static void transformFiles(File directory, Pattern included, Pattern excluded, Function<String, String> transformer) throws FileUtilsErrorException {
        FileUtils.transformFiles(directory, new Pattern[]{included}, new Pattern[]{excluded}, transformer);
    }

    public static void transformFiles(File directory, List<Pattern> included, List<Pattern> excluded, Function<String, String> transformer) throws FileUtilsErrorException {
        FileUtils.transformFiles(directory, included.toArray(new Pattern[0]), excluded.toArray(new Pattern[0]), transformer);
    }

    public static void transformFiles(File directory, Pattern[] included, Pattern[] excluded, Function<String, String> transformer) throws FileUtilsErrorException {
        for (String entry : FileUtils.getFileList(directory, included, excluded)) {
            File file = new File(directory, entry);
            String contents = FileUtils.readString(file);
            String transformed = transformer.apply(contents);
            if (transformed.equals(contents)) continue;
            FileUtils.writeString(transformed, file);
        }
    }

    public static Set<PosixFilePermission> permissionsFromMode(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static Path path(File file, String ... paths) {
        return Path.of(file.getAbsolutePath(), paths);
    }

    public static Path path(Path path, String ... paths) {
        return Path.of(path.toAbsolutePath().toString(), paths);
    }

    public static String versionFromResource(String name) {
        String version;
        block10: {
            version = null;
            URL resource = FileUtils.class.getClassLoader().getResource(name);
            try {
                if (resource == null) break block10;
                URLConnection connection = resource.openConnection();
                connection.setUseCaches(false);
                try (InputStream input_stream = connection.getInputStream();){
                    version = FileUtils.readString(input_stream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (version != null) {
            version = version.trim();
        }
        if (null == version) {
            version = "unknown version";
        }
        return version;
    }
}

