<?php

/*-----------------------------------------------------------------------------------*/
/* Head Hook
/*-----------------------------------------------------------------------------------*/

function of_head()
{
    do_action('of_head');
}

/*-----------------------------------------------------------------------------------*/
/* Get the style path currently selected */
/*-----------------------------------------------------------------------------------*/

function of_style_path()
{
    $style = $_REQUEST['style'];
    if ($style != '') {
        $style_path = $style;
    } else {
        $stylesheet = get_option('of_alt_stylesheet');
        $style_path = str_replace(".css", "", $stylesheet);
    }
    if ($style_path == "default")
        echo 'images';
    else
        echo 'styles/' . $style_path;
}

/*-----------------------------------------------------------------------------------*/
/* Add default options after activation */
/*-----------------------------------------------------------------------------------*/
if (is_admin() && isset($_GET['activated']) && $pagenow == "themes.php") {
    //Call action that sets
    add_action('admin_head', 'of_option_setup');
}

function of_option_setup()
{

    //Update EMPTY options
    $of_array = array();
    add_option('of_options', $of_array);

    $template = get_option('of_template');
    $saved_options = get_option('of_options');

    foreach ($template as $option) {
        if ($option['type'] != 'heading') {
            $id = $option['id'];
            $std = $option['std'];
            $db_option = get_option($id);
            if (empty($db_option)) {
                if (is_array($option['type'])) {
                    foreach ($option['type'] as $child) {
                        $c_id = $child['id'];
                        $c_std = $child['std'];
                        update_option($c_id, $c_std);
                        $of_array[$c_id] = $c_std;
                    }
                } else {
                    update_option($id, $std);
                    $of_array[$id] = $std;
                }
            } else { //So just store the old values over again.
                $of_array[$id] = $db_option;
            }
        }
    }
    update_option('of_options', $of_array);
}

/*-----------------------------------------------------------------------------------*/
/* Admin Backend */
/*-----------------------------------------------------------------------------------*/
function optionsframework_admin_head()
{

    //Tweaked the message on theme activate
    ?>
    <script type="text/javascript">
        jQuery(function () {
            var message = '<p><a href="You can change theme settings at <?php echo admin_url('admin.php?page=optionsframework'); ?>">Theme Admin Panel</a>.</p>';
            jQuery('.themes-php #message2').html(message);

        });
    </script>
    <?php
}

?>