# WinDiff

## About

WinDiff is an open-source web-based tool that allows browsing and comparing
symbol, type and syscall information of Microsoft Windows binaries across
different versions of the operating system. The binary database is automatically
updated to include information from the latest Windows updates (including
Insider Preview).

It was inspired by [ntdiff](https://github.com/ntdiff/ntdiff) and made possible
with the help of [Winbindex](https://github.com/m417z/winbindex).

## Screenshot

<img src="./docs/static/windiff_screenshot.png" alt="Screenshot of WinDiff">

## How It Works

WinDiff is made of two parts: a CLI tool written in Rust and a web frontend
written in TypeScript using the Next.js framework.

The CLI tool is used to generate compressed JSON databases out of a
configuration file and relies on `Winbindex` to find and download the required
PEs (and PDBs). Types are reconstructed using `resym`. The idea behind the CLI
tool is to be able to easily update and regenerate databases as new versions of
Windows are released. The CLI tool's code is in the `windiff_cli` directory.

The frontend is used to visualize the data generated by the CLI tool, in a
user-friendly way. The frontend follows the same principle as `ntdiff`, as it
allows browsing information extracted from official Microsoft PEs and PDBs for
certain versions of Microsoft Windows and also allows comparing this information
between versions. The frontend's code is in the `windiff_frontend` directory.

A scheduled GitHub action fetches new updates from `Winbindex` every day and
updates the configuration file used to generate the live version of WinDiff.
Currently, because of (free plans) storage and compute limitations, **only KB**
**and Insider Preview updates less than one year old are kept** for the live
version. You can of course rebuild a local version of WinDiff yourself, without
those limitations if you need to. See the next section for that.

Note: `Winbindex` doesn't provide unique download links for 100% of the indexed
files, so it might happen that some PEs' information are unavailable in WinDiff
because of that. However, as soon as these PEs are on VirusTotal, `Winbindex`
will be able to provide unique download links for them and they will then be
integrated into WinDiff automatically.

## How to Build

### Prerequisites

- Rust 1.68 or superior
- Node.js 16.8 or superior

### Command-Line

The full build of WinDiff is "self-documented" in `ci/build_frontend.sh`, which
is the build script used to build the live version of WinDiff. Here's what's inside:

```bash
# Resolve the project's root folder
PROJECT_ROOT=$(git rev-parse --show-toplevel)

# Generate databases
cd "$PROJECT_ROOT/windiff_cli"
cargo run --release "$PROJECT_ROOT/ci/db_configuration.json" "$PROJECT_ROOT/windiff_frontend/public/"

# Build the frontend
cd "$PROJECT_ROOT/windiff_frontend"
npm ci
npm run build
```

The configuration file used to generate the data for the live version of WinDiff
is located here: `ci/db_configuration.json`, but you can customize it or use
your own. PRs aimed at adding new binaries to track in the live configuration
are welcome.
