import GithubFullIcon from "./GithubFullIcon";

interface Props {
  className?: string;
}

export const TerminalIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="currentColor"
      width="800px"
      height="800px"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M20 4H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM6.414 15.707 5 14.293 7.293 12 5 9.707l1.414-1.414L10.121 12l-3.707 3.707zM19 16h-7v-2h7v2z" />
    </svg>
  );
};

export const VercelIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 222"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <polygon
          fill="currentColor"
          points="128 0 256 221.705007 0 221.705007"
        ></polygon>
      </g>
    </svg>
  );
};

export const SupabaseIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 263"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <title>supabase</title>
      <defs>
        <linearGradient
          x1="20.8617445%"
          y1="20.6868812%"
          x2="63.4256086%"
          y2="44.0710077%"
          id="supabase-linearGradient-1"
        >
          <stop stopColor="#249361" offset="0%"></stop>
          <stop stopColor="#3ECF8E" offset="100%"></stop>
        </linearGradient>
        <linearGradient
          x1="1.99116498%"
          y1="-13.1584008%"
          x2="21.4025077%"
          y2="34.708062%"
          id="supabase-linearGradient-2"
        >
          <stop stopColor="#000000" offset="0%"></stop>
          <stop stopColor="#000000" stopOpacity="0" offset="100%"></stop>
        </linearGradient>
      </defs>
      <g>
        <path
          d="M149.601512,258.578826 C142.884085,267.038157 129.263882,262.403261 129.102024,251.601817 L126.735244,93.6176533 L232.963622,93.6176533 C252.204429,93.6176533 262.935398,115.840956 250.971119,130.909887 L149.601512,258.578826 Z"
          fill="url(#supabase-linearGradient-1)"
        ></path>
        <path
          d="M149.601512,258.578826 C142.884085,267.038157 129.263882,262.403261 129.102024,251.601817 L126.735244,93.6176533 L232.963622,93.6176533 C252.204429,93.6176533 262.935398,115.840956 250.971119,130.909887 L149.601512,258.578826 Z"
          fillOpacity="0.2"
          fill="url(#supabase-linearGradient-2)"
        ></path>
        <path
          d="M106.399023,4.36908575 C113.11645,-4.09118439 126.736889,0.544432392 126.898746,11.3460249 L127.935901,169.329953 L23.0369844,169.329953 C3.79559007,169.329953 -6.93568494,147.106651 5.02918175,132.037719 L106.399023,4.36908575 Z"
          fill="#3ECF8E"
        ></path>
      </g>
    </svg>
  );
};

export const NetlifyIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 256"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <defs>
        <radialGradient
          cx="50%"
          cy="-50%"
          fx="50%"
          fy="-50%"
          r="99.999879%"
          id="radialGradient-1"
        >
          <stop stopColor="#20C6B7" offset="0%"></stop>
          <stop stopColor="#4D9ABF" offset="100%"></stop>
        </radialGradient>
      </defs>
      <g>
        <path
          d="M185.531657,88.8386745 L185.438083,88.7986152 C185.384611,88.7785856 185.33114,88.7585559 185.284353,88.71182 C185.128922,88.5450526 185.059783,88.3156671 185.097204,88.0909005 L190.263857,56.537508 L214.49299,80.7466915 L189.294692,91.4558836 C189.224664,91.4840915 189.149609,91.4977229 189.074123,91.4959429 L188.973865,91.4959429 C188.940445,91.4759132 188.907026,91.449207 188.840187,91.3824415 C187.90243,90.3394667 186.781011,89.4772625 185.531657,88.8386745 Z M220.675596,86.9158271 L246.582387,112.794149 C251.962925,118.175451 254.656536,120.859426 255.639069,123.9707 C255.786115,124.431382 255.906425,124.892064 256,125.3661 L194.087047,99.1739796 C194.053777,99.1602565 194.020356,99.1469026 193.986789,99.1339203 C193.739485,99.033772 193.452077,98.9202706 193.452077,98.6665615 C193.452077,98.4128525 193.746169,98.2926745 193.993473,98.1925262 L194.07368,98.1591434 L220.675596,86.9158271 Z M254.943944,133.671732 C253.607164,136.182117 251.000444,138.785972 246.589071,143.199174 L217.380434,172.369037 L179.603039,164.510734 L179.402522,164.470674 C179.068327,164.417262 178.714081,164.357173 178.714081,164.056728 C178.424059,160.910007 176.838377,158.025062 174.336127,156.091599 C174.182397,155.938039 174.222501,155.697683 174.269288,155.477357 C174.269288,155.443974 174.269288,155.410591 174.282656,155.383885 L181.38764,111.812696 L181.414376,111.665811 C181.454479,111.331984 181.514634,110.944744 181.81541,110.944744 C184.891098,110.562547 187.68443,108.962956 189.568732,106.504836 C189.628887,106.43807 189.66899,106.364628 189.749197,106.324569 C189.963082,106.22442 190.21707,106.324569 190.437639,106.41804 L254.93726,133.671732 L254.943944,133.671732 Z M210.663116,179.078974 L162.632621,227.056688 L170.853816,176.581943 L170.867184,176.515177 C170.873868,176.448412 170.887235,176.381646 170.907287,176.321557 C170.974126,176.16132 171.147907,176.094554 171.315005,176.027789 L171.395212,175.994406 C173.195291,175.227234 174.787364,174.044216 176.040521,172.542628 C176.200935,172.355684 176.394768,172.175417 176.642072,172.142034 C176.706258,172.131568 176.771719,172.131568 176.835905,172.142034 L210.656432,179.08565 L210.663116,179.078974 Z M152.466411,237.211726 L147.052453,242.619735 L87.198141,156.211777 C87.1764966,156.180172 87.1542123,156.149008 87.1313021,156.118306 C87.0377275,155.991451 86.937469,155.864597 86.9575207,155.717712 C86.9642046,155.610888 87.0310436,155.517416 87.1045665,155.437297 L87.1714054,155.350502 C87.3518707,155.08344 87.5056004,154.816378 87.6726978,154.529286 L87.8063758,154.295607 L87.8264275,154.275577 C87.9200021,154.11534 88.0068928,153.961779 88.1673063,153.874984 C88.3076682,153.808218 88.5015013,153.834924 88.6552309,153.868307 L154.966189,167.528536 C155.151602,167.557337 155.326509,167.6332 155.474165,167.748862 C155.561056,167.835657 155.581108,167.929129 155.601159,168.035954 C156.538781,171.579604 159.080685,174.481797 162.472207,175.880905 C162.659356,175.974376 162.579149,176.181349 162.492259,176.401676 C162.448907,176.498239 162.41532,176.598887 162.392,176.702121 C161.556513,181.776301 154.391374,225.427609 152.466411,237.211726 Z M141.157254,248.501779 C137.166967,252.447622 134.814235,254.537383 132.154043,255.378629 C129.531121,256.207124 126.716183,256.207124 124.093261,255.378629 C120.978565,254.390499 118.284953,251.706524 112.904415,246.325222 L52.796115,186.282975 L68.4965928,161.96029 C68.5701157,161.840112 68.6436385,161.733287 68.7639487,161.646492 C68.9310462,161.526314 69.1716665,161.579727 69.3721835,161.646492 C72.9758773,162.732509 76.8450731,162.536667 80.3204094,161.092338 C80.5008747,161.025573 80.6813399,160.978837 80.8217018,161.105691 C80.8918911,161.169689 80.9546672,161.241354 81.0088509,161.319341 L141.157254,248.508455 L141.157254,248.501779 Z M47.0011749,180.494403 L33.2122921,166.720673 L60.442495,155.116823 C60.5120976,155.086505 60.5871334,155.070606 60.6630636,155.070087 C60.8903162,155.070087 61.0239942,155.29709 61.1443043,155.504063 C61.4179565,155.924608 61.7078093,156.33441 62.0132111,156.732549 L62.1001018,156.839374 C62.1803086,156.952875 62.1268374,157.066376 62.0466306,157.173201 L47.0078588,180.494403 L47.0011749,180.494403 Z M27.1098927,160.624979 L9.66491737,143.199174 C6.69726639,140.234785 4.54505104,138.084934 3.04785776,136.235529 L56.091277,147.225136 C56.1579088,147.237472 56.2247588,147.248601 56.2917939,147.258519 C56.619305,147.311931 56.9802355,147.37202 56.9802355,147.679142 C56.9802355,148.01297 56.5858855,148.16653 56.2516906,148.293385 L56.0979609,148.36015 L27.1098927,160.624979 Z M0,127.275594 C0.0604502235,126.153061 0.262565974,125.042646 0.601550873,123.9707 C1.59076787,120.859426 4.2776951,118.175451 9.66491737,112.794149 L31.9891387,90.4944599 C42.2678594,105.395725 52.574449,120.277789 62.9088536,135.140574 C63.0893188,135.38093 63.2898358,135.647992 63.0826349,135.848289 C62.1067857,136.923214 61.1309365,138.098287 60.442495,139.373509 C60.3678094,139.537425 60.2528491,139.679819 60.1083,139.787455 C60.0214094,139.840868 59.9278348,139.820838 59.8275763,139.800809 L59.8142085,139.800809 L0,127.268917 L0,127.275594 Z M37.964544,84.5256209 L67.9819326,54.5412184 C70.8025378,55.7763809 81.069006,60.1094642 90.2526827,63.9818653 C97.2039372,66.9195489 103.540273,69.5901704 105.532075,70.4581223 C105.732592,70.538241 105.913057,70.6183596 105.999948,70.8186562 C106.053419,70.9388342 106.026683,71.0923949 105.999948,71.2192495 C105.034732,75.6158947 106.348462,80.2026244 109.495627,83.4239895 C109.696144,83.6242861 109.495627,83.911378 109.321845,84.1584104 L109.228271,84.2986181 L78.7496932,131.455117 C78.6694864,131.588648 78.5959636,131.702149 78.4622856,131.788944 C78.301872,131.889093 78.0746195,131.842357 77.8874703,131.795621 C76.7020471,131.485387 75.4834144,131.319494 74.2581134,131.301556 C73.161954,131.301556 71.97222,131.501852 70.7691183,131.722179 L70.7624344,131.722179 C70.6287564,131.742208 70.5084463,131.768915 70.4015039,131.688796 C70.2833886,131.592374 70.181798,131.477365 70.1007284,131.348292 L37.964544,84.5256209 Z M74.0442286,48.4855843 L112.904415,9.66810134 C118.284953,4.29347565 120.978565,1.60282452 124.093261,0.621371137 C126.716183,-0.207123712 129.531121,-0.207123712 132.154043,0.621371137 C135.26874,1.60282452 137.962351,4.29347565 143.342889,9.66810134 L151.764601,18.0805589 L124.126681,60.8372085 C124.058309,60.96168 123.965028,61.0707669 123.852641,61.1576831 C123.685543,61.2711845 123.451607,61.2244486 123.25109,61.1576831 C118.82732,59.8166713 114.026083,60.7408929 110.418005,63.628008 C110.237539,63.8149515 109.970184,63.7081266 109.742931,63.6079783 C106.133626,62.0389882 78.0612517,50.1881055 74.0442286,48.4855843 Z M157.633064,23.942573 L183.152189,49.4336549 L177.003003,87.4766576 L177.003003,87.5768059 C176.997512,87.6635077 176.979502,87.7489613 176.949531,87.8305149 C176.882692,87.964046 176.749014,87.9907522 176.615336,88.0308116 C175.300608,88.4286107 174.062357,89.0447985 172.95256,89.8535107 C172.904848,89.8874753 172.860126,89.925447 172.818882,89.9670121 C172.745359,90.0471308 172.671836,90.1205729 172.551526,90.133926 C172.453607,90.136948 172.356022,90.1210796 172.264118,90.0871901 L133.377196,73.5827495 L133.303674,73.5493667 C133.056369,73.4492184 132.762278,73.3290404 132.762278,73.0753314 C132.53371,70.9106875 131.825947,68.8239396 130.690269,66.9662848 C130.50312,66.6591633 130.295919,66.3386887 130.456333,66.0248907 L157.633064,23.942573 Z M131.351975,81.4009938 L167.805958,96.8238327 C168.006475,96.9173045 168.227044,97.0040997 168.313934,97.2110728 C168.348719,97.335548 168.348719,97.4671613 168.313934,97.5916364 C168.206992,98.1257607 168.113417,98.7333271 168.113417,99.34757 L168.113417,100.369083 C168.113417,100.622792 167.852745,100.729617 167.612125,100.829765 L167.538602,100.856471 C161.763714,103.320119 86.4629122,135.394283 86.3492859,135.394283 C86.2356596,135.394283 86.1153495,135.394283 86.0017232,135.280782 C85.8012062,135.080485 86.0017232,134.80007 86.1821885,134.546361 C86.2140937,134.502354 86.2452892,134.457838 86.275763,134.41283 L116.232997,88.0775474 L116.286468,87.9974288 C116.460249,87.7170135 116.660766,87.4032155 116.981593,87.4032155 L117.282369,87.4499514 C117.964126,87.5434231 118.565677,87.6302183 119.173912,87.6302183 C123.718963,87.6302183 127.929819,85.4202791 130.469701,81.6413497 C130.530215,81.5404379 130.606999,81.4502028 130.696953,81.3742876 C130.877418,81.2407565 131.144774,81.307522 131.351975,81.4009938 Z M89.6043445,142.725139 L171.682619,107.760028 C171.682619,107.760028 171.802929,107.760028 171.916556,107.873529 C172.364377,108.320858 172.745359,108.621303 173.112974,108.901718 L173.293439,109.01522 C173.460536,109.108691 173.627634,109.215516 173.641002,109.389107 C173.641002,109.455872 173.641002,109.495932 173.627634,109.556021 L166.596172,152.69991 L166.569437,152.873501 C166.52265,153.207328 166.475862,153.587892 166.161719,153.587892 C162.355867,153.844495 158.921931,155.960553 156.984726,159.242933 L156.951307,159.296345 C156.857732,159.449906 156.770841,159.59679 156.617112,159.676909 C156.47675,159.743674 156.296285,159.716968 156.149239,159.683585 L90.69382,146.196947 C90.626981,146.183594 89.6778674,142.731816 89.6043445,142.725139 Z"
          fill="url(#radialGradient-1)"
          fillRule="nonzero"
        ></path>
      </g>
    </svg>
  );
};

export const RenderIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="#46E3B7"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Render</title>
      <path d="M13.586 0v3.172H7.523a4.528 4.528 0 0 0-3.018 1.305 4.498 4.498 0 0 0-1.333 2.99v11.326H0V7.509a7.472 7.472 0 0 1 2.204-5.305A7.471 7.471 0 0 1 4.588.589 7.432 7.432 0 0 1 7.51 0Zm5.207 0v3.158H15.62V0ZM24 0v3.158h-3.172V0Zm0 5.207v3.172h-3.172V5.207Zm0 5.207v3.172h-3.172v-3.172Zm0 5.207v3.172h-3.172V15.62Zm0 5.207V24h-3.172v-3.172Zm-5.207 0V24H15.62v-3.172Zm-5.207 0V24h-3.172v-3.172Zm-5.207 0V24H5.207v-3.172Zm-5.221 0V24H0v-3.172Z" />
    </svg>
  );
};

export const FlyIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 231"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      preserveAspectRatio="xMidYMid"
    >
      <title>Fly</title>
      <defs>
        <radialGradient
          cx="53.095502%"
          cy="49.5644668%"
          fx="53.095502%"
          fy="49.5644668%"
          r="93.3475634%"
          gradientTransform="translate(0.530955,0.495645),scale(0.776037,1.000000),translate(-0.530955,-0.495645)"
          id="flyRadialGradient-1"
        >
          <stop stopColor="#BA7BF0" offset="0%"></stop>
          <stop stopColor="#996BEC" offset="45%"></stop>
          <stop stopColor="#5046E4" offset="100%"></stop>
        </radialGradient>
      </defs>
      <g>
        <path
          d="M179.015724,31.5981633 L208.493624,31.5981633 C234.713177,31.5981633 256,52.8849859 256,79.1045394 L256,182.757366 C256,208.976919 234.713177,230.263742 208.493624,230.263742 L206.170688,230.263742 C192.675834,228.152832 186.823283,224.105623 182.302133,220.685139 L144.823356,189.869603 C142.888438,188.304709 140.123096,188.304709 138.188178,189.869603 L126.012253,199.881612 L91.7201077,171.685225 C89.7874529,170.117244 87.0207027,170.117244 85.0880479,171.685225 L37.4475963,213.594729 C27.8596397,221.392933 21.5175572,219.952401 17.4048695,219.500286 C6.78172539,210.782261 1.7723975e-13,197.555558 1.7723975e-13,182.757366 L1.7723975e-13,79.1045394 C1.7723975e-13,52.8849859 21.2868226,31.5981633 47.5094942,31.5981633 L76.9219152,31.5981633 L76.8689086,31.7166486 L75.8773735,34.6070667 L75.5686881,35.5986018 L74.2341693,41.5197496 L74.0502052,42.5580551 L73.4640147,48.4885571 L73.3860638,50.1161712 L73.3735917,50.6867715 L73.4297163,53.4056977 L73.5637918,54.9990134 L73.8943035,57.4934412 L74.3152382,59.7384261 L74.8141237,61.8056831 L75.4626749,64.044432 L77.1464137,68.7838447 L77.7014238,70.2056685 L80.6323764,76.3980853 L81.6675639,78.3000865 L85.0568676,84.1183392 L86.35397,86.2167765 L91.0840286,93.1824659 L91.7668782,94.1054042 L97.9218786,102.115635 L99.9111847,104.582001 L106.939235,112.798022 L108.382885,114.378866 L114.176193,120.611817 L116.471067,122.987759 L120.262597,126.754345 L119.501797,127.390424 L119.027855,127.817595 C117.740107,129.018038 116.517837,130.293314 115.373519,131.634069 C114.823615,132.282586 114.299382,132.95244 113.802029,133.642084 C113.043345,134.695591 112.364825,135.804571 111.772189,136.959673 C111.469251,137.559446 111.197617,138.174525 110.958382,138.802431 C110.341268,140.406623 109.970188,142.094882 109.857715,143.809995 L109.835889,145.291061 C109.889724,147.379425 110.31523,149.441491 111.092457,151.380583 C111.879818,153.346447 113.028339,155.147489 114.478643,156.690596 C115.532538,157.813088 116.732982,158.792151 118.048792,159.596604 C119.168167,160.282572 120.362374,160.846936 121.603352,161.277225 C124.300906,162.19158 127.16315,162.516932 129.997101,162.231344 L130.012691,162.231344 C132.43049,161.996821 134.780567,161.299208 136.934728,160.176559 C137.863903,159.683909 138.749425,159.113309 139.578822,158.464758 C141.953856,156.616352 143.794126,154.169117 144.910661,151.374347 C145.783711,149.194841 146.210881,146.865669 146.173465,144.520907 L146.104868,143.295519 C145.946598,141.676778 145.560297,140.088537 144.957432,138.577933 C144.696242,137.920037 144.399594,137.276779 144.068792,136.650987 C143.454989,135.49822 142.756722,134.392455 141.979708,133.342752 C141.624124,132.862412 141.256071,132.391429 140.875924,131.930283 C139.610396,130.419568 138.248064,128.992661 136.797535,127.658575 L135.771701,126.785525 L137.508447,125.070606 L144.973022,117.27552 L147.554754,114.441226 L151.567665,109.926312 L154.17746,106.873756 L157.900393,102.340134 L160.419765,99.1722105 L164.120873,94.2238895 L165.988575,91.663983 L168.638905,87.700961 L170.846473,84.3241294 L175.005932,77.0809349 L177.384992,72.3290501 L177.453589,72.1825025 L179.274521,67.7736015 C179.298553,67.7166087 179.319373,67.658314 179.336882,67.5989915 L181.298126,61.4814075 L181.503916,60.5896496 L182.355139,55.7192794 L182.520395,54.4003508 L182.570284,53.5927798 L182.629526,50.5433419 L182.613936,49.9758596 L182.458034,47.2444612 L182.264716,45.1241977 L181.298126,39.0097317 C181.282535,38.9286628 181.266945,38.8475939 181.242001,38.766525 L180.001023,34.2453747 L179.573852,32.9888067 L179.015724,31.5981633 L179.015724,31.5981633 Z M193.028172,160.85629 C186.848056,160.943442 181.859218,165.932279 181.772067,172.112395 C181.862519,178.290605 186.849938,183.276642 193.028172,183.365383 C199.206248,183.275056 204.193646,178.29042 204.287395,172.112395 C204.198572,165.931775 199.208817,160.943401 193.028172,160.85629 L193.028172,160.85629 Z"
          fill="url(#flyRadialGradient-1)"
        ></path>
        <path
          d="M102.630111,230.263785 L47.5094942,230.263785 C36.5295537,230.278541 25.8864388,226.473255 17.4048695,219.500286 C21.5175572,219.952401 27.8596397,221.392933 37.4475963,213.594729 L85.0880479,171.685225 C87.0207027,170.117244 89.7874529,170.117244 91.7201077,171.685225 L126.012253,199.881612 L138.188178,189.869603 C140.123096,188.304709 142.888438,188.304709 144.823356,189.869603 L182.302133,220.685139 C186.823283,224.105623 192.675834,228.152832 206.170688,230.263785 L181.238883,230.263785 C179.03631,230.236593 176.896925,229.523828 175.118181,228.224547 L174.681656,227.887799 L141.699085,200.498983 L109.149921,227.887799 C107.311666,229.400946 105.01091,230.239385 102.630111,230.263785 Z M193.028172,160.85629 C186.848056,160.943442 181.859218,165.932279 181.772067,172.112395 C181.862519,178.290605 186.849938,183.276642 193.028172,183.365383 C199.206248,183.275056 204.193646,178.29042 204.287395,172.112395 C204.198572,165.931775 199.208817,160.943401 193.028172,160.85629 L193.028172,160.85629 Z M120.262597,126.754345 L116.471067,122.987759 L114.176193,120.611817 L108.382885,114.378866 L106.939235,112.798022 L99.9111847,104.582001 L97.9218786,102.115635 L91.7668782,94.1054042 L91.0840286,93.1824659 L86.35397,86.2167765 L85.0568676,84.1183392 L81.6675639,78.3000865 L80.6323764,76.3980853 L77.7014238,70.2056685 L77.1464137,68.7838447 L75.4626749,64.044432 L74.8141237,61.8056831 L74.3152382,59.7384261 L73.8943035,57.4934412 L73.5637918,54.9990134 L73.4297163,53.4056977 L73.3735917,50.6867715 L73.3860638,50.1161712 L73.4640147,48.4885571 L74.0502052,42.5580551 L74.2341693,41.5197496 L75.5686881,35.5986018 L75.8773735,34.6070667 L76.8689086,31.7166486 L77.1869481,30.9683203 L78.7646736,27.5010657 L79.8591038,25.4369268 L81.3838228,22.9237908 L82.9023056,20.685042 L83.9842637,19.2632182 L85.2314775,17.7603254 L86.6034128,16.2511967 L87.7789119,15.0694615 L90.6412677,12.5500895 L92.7334689,10.8382885 C92.7833575,10.794636 92.8363641,10.7572196 92.8893707,10.7198032 L95.3650902,9.04541856 L97.3325701,7.79196862 L101.067976,5.82448875 C101.1241,5.79019037 101.189579,5.76212806 101.248822,5.73406575 L106.546362,3.53585131 L107.035894,3.35188726 L111.744126,1.97371594 L113.733432,1.52783699 L116.421178,0.988416988 L118.204694,0.717147973 L120.939211,0.377282194 L122.803795,0.212026357 L126.504902,0.0155901733 L127.954788,0 L130.701777,0.0561246239 L131.415807,0.0966590746 L135.394419,0.427170749 L140.657662,1.169263 L141.265678,1.29710242 L146.46656,2.59108681 L147.994397,3.04631987 L149.690608,3.63251038 L151.757865,4.41513708 L153.391715,5.10734078 L155.792602,6.23918736 L157.304849,7.01557799 L160.023775,8.61201174 L161.037136,9.23561867 L164.744479,11.9420728 L165.807729,12.865011 L168.39258,15.2191272 L168.520419,15.3469666 L170.712398,17.6979648 L171.466962,18.5491882 L174.039341,21.9665542 L174.563171,22.7834793 L176.605483,26.2320256 L177.219736,27.4137608 L178.370291,29.9861394 L179.573852,32.9888067 L180.001023,34.2453747 L181.242001,38.766525 C181.265137,38.8465079 181.283874,38.9276985 181.298126,39.0097317 L182.264716,45.1241977 L182.458034,47.2444612 L182.613936,49.9758596 L182.629526,50.5433419 L182.570284,53.5927798 L182.520395,54.4003508 L182.355139,55.7192794 L181.503916,60.5896496 L181.298126,61.4814075 L179.336882,67.5989915 C179.319373,67.658314 179.298553,67.7166087 179.274521,67.7736015 L177.453589,72.1825025 L177.384992,72.3290501 L175.005932,77.0809349 L170.846473,84.3241294 L168.638905,87.700961 L165.988575,91.663983 L164.120873,94.2238895 L160.419765,99.1722105 L157.900393,102.340134 L154.17746,106.873756 L151.567665,109.926312 L147.554754,114.441226 L144.973022,117.27552 L137.508447,125.070606 L135.771701,126.785525 L136.797535,127.658575 C138.247421,128.993094 139.610002,130.418036 140.875924,131.930283 C141.256324,132.391752 141.624252,132.862575 141.979708,133.342752 C142.756722,134.392455 143.454989,135.49822 144.068792,136.650987 C144.399303,137.274594 144.695517,137.920027 144.957432,138.577933 C145.552976,140.087061 145.955203,141.683495 146.104868,143.295519 L146.173465,144.520907 C146.211741,146.866572 145.782456,149.19637 144.910661,151.374347 C143.794126,154.169117 141.953856,156.616352 139.578822,158.464758 C138.749425,159.113309 137.863903,159.683909 136.934728,160.176559 C134.780567,161.299208 132.43049,161.996821 130.012691,162.231344 L129.997101,162.231344 C127.16315,162.516932 124.300906,162.19158 121.603352,161.277225 C120.361442,160.846638 119.169677,160.283163 118.048792,159.596604 C116.734053,158.792074 115.533278,157.814674 114.478643,156.690596 C113.028339,155.147489 111.879818,153.346447 111.092457,151.380583 C110.31523,149.441491 109.889724,147.379425 109.835889,145.291061 L109.857715,143.809995 C109.970188,142.094882 110.341268,140.406623 110.958382,138.802431 C111.19847,138.172588 111.469739,137.558335 111.772189,136.959673 C112.364615,135.802882 113.044347,134.695979 113.802029,133.642084 C114.297797,132.952998 114.824745,132.282621 115.373519,131.634069 C116.517837,130.293314 117.740107,129.018038 119.027855,127.817595 L119.501797,127.390424 L120.262597,126.754345 L120.262597,126.754345 Z"
          fill="#000000"
        ></path>
        <path
          d="M141.699085,200.498983 L174.681656,227.887799 C176.566346,229.421574 178.921212,230.260475 181.351132,230.263742 L102.517862,230.263742 C104.937457,230.263742 107.282219,229.424991 109.149921,227.887799 L141.699085,200.498983 Z M128.163697,135.859006 L128.463028,135.946311 C128.559687,135.993082 128.640756,136.061679 128.728061,136.120921 L128.977504,136.342302 C129.594875,136.909784 130.193537,137.505329 130.770374,138.116463 C131.175718,138.54987 131.571709,138.995749 131.952109,139.457218 C132.435404,140.040291 132.887519,140.651426 133.2991,141.287505 C133.476828,141.568128 133.642084,141.851869 133.797985,142.148082 C133.932061,142.403761 134.053664,142.668794 134.159677,142.936945 C134.34676,143.40465 134.487071,143.8973 134.530724,144.399303 L134.521369,145.34095 C134.395548,147.065393 133.447455,148.623885 131.973935,149.52847 C131.031128,150.098132 129.971482,150.446728 128.874609,150.548068 L127.711582,150.582366 L126.729401,150.495061 C126.270179,150.428065 125.818193,150.318461 125.379292,150.167667 C124.932554,150.015453 124.50386,149.814699 124.100898,149.569005 L123.333861,149.007759 C122.430626,148.235695 121.81522,147.180712 121.587762,146.014445 C121.549781,145.818246 121.519616,145.620615 121.497339,145.422019 L121.469276,144.524025 C121.484867,144.280818 121.522283,144.040729 121.57529,143.800641 C121.709365,143.276811 121.902683,142.768571 122.14589,142.285276 C122.460228,141.678782 122.818729,141.096218 123.218494,140.542294 C123.882635,139.6443 124.602901,138.789959 125.373056,137.982388 C125.868823,137.458558 126.377063,136.950319 126.907129,136.460787 L127.284411,136.120921 C127.546326,135.946311 127.549444,135.946311 127.848775,135.859006 L128.163697,135.859006 L128.163697,135.859006 Z M126.233633,10.6636786 L126.355237,10.6543244 L126.355237,115.635434 L126.093322,115.152138 C122.63777,108.759172 119.420859,102.240064 116.449241,95.6082969 C114.037956,90.2411122 111.854426,84.7744837 109.904486,79.2230247 C108.345881,74.8006804 107.029162,70.2967721 105.960172,65.7312887 C105.130775,62.1050144 104.494696,58.4257335 104.232781,54.7090362 C104.132522,53.1230225 104.102352,51.533355 104.142358,49.9446792 C104.167302,48.5602719 104.223427,47.1789825 104.310732,45.7976931 C104.447925,43.624423 104.669306,41.4573889 104.987345,39.305945 C105.239906,37.6128521 105.551709,35.9259954 105.938346,34.2578469 C106.243913,32.9326821 106.599369,31.6168715 107.004714,30.3228871 C107.590904,28.4520663 108.292462,26.624898 109.109387,24.8413822 C109.408718,24.199067 109.729876,23.5598699 110.066624,22.933145 C112.093346,19.1790312 114.843453,15.7211308 118.444783,13.4075491 C120.785242,11.8851635 123.455755,10.9443905 126.233633,10.6636786 L126.233633,10.6636786 Z M139.846973,10.9287115 L146.909321,12.9429619 C150.18014,14.1496413 153.329355,15.7242488 156.222891,17.6886106 C160.166898,20.3506259 163.566176,23.7414368 166.238018,27.6787937 C167.80639,30.0110836 169.103492,32.5273376 170.116853,35.1558408 C171.585448,39.0440301 172.495914,43.1193014 172.817071,47.2631694 C172.910612,48.3482455 172.963619,49.4364396 172.985445,50.5246337 C173.010389,51.5348769 173.004153,52.5482382 172.923084,53.5584814 C172.7225,55.8192746 172.297391,58.05449 171.654044,60.2310756 C171.136566,62.0122548 170.525624,63.7649397 169.823758,65.481846 C168.950708,67.6176997 167.980999,69.713019 166.91775,71.7584498 C164.563633,76.3045443 161.854061,80.6542026 158.954289,84.8604314 C155.359605,90.0300045 151.527599,95.0304454 147.470567,99.845706 C143.064633,105.100057 138.469794,110.193069 133.69509,115.114722 C136.935179,109.039399 139.959482,102.851433 142.762335,96.5624155 C144.321352,93.0577445 145.789947,89.5156572 147.171236,85.9392714 C148.690619,82.0109037 150.060421,78.026308 151.277688,73.9940806 C152.181918,70.972705 152.980135,67.9201491 153.63804,64.8332948 C154.202404,62.1860833 154.645165,59.5108096 154.919552,56.8199457 C155.150287,54.5749607 155.234474,52.3175036 155.178349,50.0662826 C155.157066,48.688214 155.106126,47.3107631 155.025565,45.9348867 C154.695054,40.3972571 153.853184,34.8783357 152.238042,29.5683227 C151.626506,27.5550581 150.882799,25.5843371 150.011766,23.6690011 C147.944509,19.1665591 145.060327,14.9572123 141.156547,11.8859481 L139.846973,10.9287115 L139.846973,10.9287115 Z"
          fill="#FFFFFF"
        ></path>
      </g>
    </svg>
  );
};

export const RailwayIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="currentColor"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Railway</title>
      <path d="M.113 10.27A13.026 13.026 0 000 11.48h18.23c-.064-.125-.15-.237-.235-.347-3.117-4.027-4.793-3.677-7.19-3.78-.8-.034-1.34-.048-4.524-.048-1.704 0-3.555.005-5.358.01-.234.63-.459 1.24-.567 1.737h9.342v1.216H.113v.002zm18.26 2.426H.009c.02.326.05.645.094.961h16.955c.754 0 1.179-.429 1.315-.96zm-17.318 4.28s2.81 6.902 10.93 7.024c4.855 0 9.027-2.883 10.92-7.024H1.056zM11.988 0C7.5 0 3.593 2.466 1.531 6.108l4.75-.005v-.002c3.71 0 3.849.016 4.573.047l.448.016c1.563.052 3.485.22 4.996 1.364.82.621 2.007 1.99 2.712 2.965.654.902.842 1.94.396 2.934-.408.914-1.289 1.458-2.353 1.458H.391s.099.42.249.886h22.748A12.026 12.026 0 0024 12.005C24 5.377 18.621 0 11.988 0z" />
    </svg>
  );
};

export const HerokuIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 285"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M230.4,0 C244.39552,0 255.77047,11.2315104 255.99657,25.1765997 L256,25.6 L256,258.844444 C256,272.839964 244.765005,284.214915 230.823296,284.441014 L230.4,284.444444 L25.6,284.444444 C11.60448,284.444444 0.2295296,273.209449 0.003430144,259.26774 L0,258.844444 L0,25.6 C0,11.60096 11.2349952,0.2294592 25.1767043,0.003429088 L25.6,0 L230.4,0 Z M230.4,14.2222222 L25.6,14.2222222 C19.426,14.2222222 14.3820625,19.169691 14.2259468,25.3068692 L14.2222222,25.6 L14.2222222,258.844444 C14.2222222,265.018444 19.169691,270.062382 25.3068692,270.218498 L25.6,270.222222 L230.4,270.222222 C236.5775,270.222222 241.618047,265.274753 241.774056,259.137575 L241.777778,258.844444 L241.777778,25.6 C241.777778,19.328 236.675556,14.2222222 230.4,14.2222222 Z M64,184.888889 L96,213.333333 L64,241.777778 L64,184.888889 Z M92.4444444,42.6666667 L92.4444444,123.416889 C106.645333,118.794667 126.496,113.777778 145.777778,113.777778 C163.36,113.777778 173.884444,120.689778 179.616,126.488889 C191.7248,138.738489 192.013158,154.309103 191.997015,156.385666 L191.996444,156.444444 L192,241.777778 L163.555556,241.777778 L163.555556,156.835556 C163.416889,150.197333 160.216889,142.222222 145.777778,142.222222 C117.146098,142.222222 85.0644658,156.478539 84.1117507,156.905113 L84.0924444,156.913778 L64,166.016 L64,42.6666667 L92.4444444,42.6666667 Z M192,42.6666667 C190.08,58.8231111 183.530667,74.3111111 170.666667,88.8888889 L170.666667,88.8888889 L142.222222,88.8888889 C153.400889,74.2222222 160.419556,58.7875556 163.555556,42.6666667 L163.555556,42.6666667 Z"
          fill="currentColor"
        ></path>
      </g>
    </svg>
  );
};

export const GCPIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 206"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M170.2517,56.8186 L192.5047,34.5656 L193.9877,25.1956 C153.4367,-11.6774 88.9757,-7.4964 52.4207,33.9196 C42.2667,45.4226 34.7337,59.7636 30.7167,74.5726 L38.6867,73.4496 L83.1917,66.1106 L86.6277,62.5966 C106.4247,40.8546 139.8977,37.9296 162.7557,56.4286 L170.2517,56.8186 Z"
          fill="#EA4335"
        ></path>
        <path
          d="M224.2048,73.9182 C219.0898,55.0822 208.5888,38.1492 193.9878,25.1962 L162.7558,56.4282 C175.9438,67.2042 183.4568,83.4382 183.1348,100.4652 L183.1348,106.0092 C198.4858,106.0092 210.9318,118.4542 210.9318,133.8052 C210.9318,149.1572 198.4858,161.2902 183.1348,161.2902 L127.4638,161.2902 L121.9978,167.2242 L121.9978,200.5642 L127.4638,205.7952 L183.1348,205.7952 C223.0648,206.1062 255.6868,174.3012 255.9978,134.3712 C256.1858,110.1682 244.2528,87.4782 224.2048,73.9182"
          fill="#4285F4"
        ></path>
        <path
          d="M71.8704,205.7957 L127.4634,205.7957 L127.4634,161.2897 L71.8704,161.2897 C67.9094,161.2887 64.0734,160.4377 60.4714,158.7917 L52.5844,161.2117 L30.1754,183.4647 L28.2234,191.0387 C40.7904,200.5277 56.1234,205.8637 71.8704,205.7957"
          fill="#34A853"
        ></path>
        <path
          d="M71.8704,61.4255 C31.9394,61.6635 -0.2366,94.2275 0.0014,134.1575 C0.1344,156.4555 10.5484,177.4455 28.2234,191.0385 L60.4714,158.7915 C46.4804,152.4705 40.2634,136.0055 46.5844,122.0155 C52.9044,108.0255 69.3704,101.8085 83.3594,108.1285 C89.5244,110.9135 94.4614,115.8515 97.2464,122.0155 L129.4944,89.7685 C115.7734,71.8315 94.4534,61.3445 71.8704,61.4255"
          fill="#FBBC05"
        ></path>
      </g>
    </svg>
  );
};

export const GithubIcon = ({ className }: Props) => {
  return <GithubFullIcon className={className} />;
};

export const DockerIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 185"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M250.715745,70.4971666 C244.951102,66.4973277 231.740464,64.997388 221.412146,66.9973071 C220.211179,56.9977092 214.68673,48.2480609 205.078993,40.4983724 L199.554544,36.4985331 L195.711449,42.248302 C190.90758,49.7480006 188.505646,60.2475786 189.226226,70.2471769 C189.46642,73.7470364 190.667387,79.9967847 194.270289,85.496564 C190.90758,87.4964838 183.941971,89.996383 174.814621,89.996383 L1.15476998,89.996383 L0.674383104,91.9963028 C-1.00697093,101.9959 -1.00697093,133.244645 18.6888904,157.243681 C33.5808831,175.492947 55.6786788,184.742575 84.7420842,184.742575 C147.672763,184.742575 194.270289,154.493791 216.127891,99.7459909 C224.774854,99.9959813 243.269748,99.7459909 252.637292,80.996745 C252.877486,80.4967649 253.357872,79.4968046 255.039227,75.7469554 L256,73.7470364 L250.715745,70.4971666 L250.715745,70.4971666 Z M139.986573,0 L113.565295,0 L113.565295,24.9989952 L139.986573,24.9989952 L139.986573,0 L139.986573,0 Z M139.986573,29.9987943 L113.565295,29.9987943 L113.565295,54.9977896 L139.986573,54.9977896 L139.986573,29.9987943 L139.986573,29.9987943 Z M108.761427,29.9987943 L82.3401495,29.9987943 L82.3401495,54.9977896 L108.761427,54.9977896 L108.761427,29.9987943 L108.761427,29.9987943 Z M77.5362814,29.9987943 L51.1150037,29.9987943 L51.1150037,54.9977896 L77.5362814,54.9977896 L77.5362814,29.9987943 L77.5362814,29.9987943 Z M46.311135,59.9975886 L19.8898576,59.9975886 L19.8898576,84.9965839 L46.311135,84.9965839 L46.311135,59.9975886 L46.311135,59.9975886 Z M77.5362814,59.9975886 L51.1150037,59.9975886 L51.1150037,84.9965839 L77.5362814,84.9965839 L77.5362814,59.9975886 L77.5362814,59.9975886 Z M108.761427,59.9975886 L82.3401495,59.9975886 L82.3401495,84.9965839 L108.761427,84.9965839 L108.761427,59.9975886 L108.761427,59.9975886 Z M139.986573,59.9975886 L113.565295,59.9975886 L113.565295,84.9965839 L139.986573,84.9965839 L139.986573,59.9975886 L139.986573,59.9975886 Z M171.211719,59.9975886 L144.790441,59.9975886 L144.790441,84.9965839 L171.211719,84.9965839 L171.211719,59.9975886 L171.211719,59.9975886 Z"
          fill="#2396ED"
          fillRule="nonzero"
        ></path>
      </g>
    </svg>
  );
};

export const KubernetesIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 249"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M82.0851613,244.934194 C76.1393548,244.934194 70.523871,242.291613 66.7251613,237.501935 L8.91870968,165.656774 C5.12,160.867097 3.63354839,154.756129 5.12,148.810323 L25.7651613,59.1277419 C27.0864516,53.1819355 31.0503226,48.3922581 36.5006452,45.7496774 L120.072258,5.78064516 C122.714839,4.45935484 125.687742,3.79870968 128.660645,3.79870968 C131.633548,3.79870968 134.606452,4.45935484 137.249032,5.78064516 L220.820645,45.5845161 C226.270968,48.2270968 230.234839,53.0167742 231.556129,58.9625806 L252.20129,148.645161 C253.522581,154.590968 252.20129,160.701935 248.402581,165.491613 L190.596129,237.336774 C186.797419,241.96129 181.181935,244.769032 175.236129,244.769032 L82.0851613,244.934194 L82.0851613,244.934194 Z"
          fill="#326DE6"
        ></path>
        <path
          d="M128.495484,7.92774194 C130.807742,7.92774194 133.12,8.42322581 135.267097,9.41419355 L218.83871,49.2180645 C223.132903,51.3651613 226.436129,55.3290323 227.427097,59.9535484 L248.072258,149.636129 C249.228387,154.425806 248.072258,159.380645 244.934194,163.179355 L187.127742,235.024516 C184.154839,238.823226 179.530323,240.970323 174.740645,240.970323 L82.0851613,240.970323 C77.2954839,240.970323 72.6709677,238.823226 69.6980645,235.024516 L11.8916129,163.179355 C8.91870968,159.380645 7.76258065,154.425806 8.75354839,149.636129 L29.3987097,59.9535484 C30.5548387,55.163871 33.6929032,51.2 37.9870968,49.2180645 L121.55871,9.24903226 C123.705806,8.42322581 126.183226,7.92774194 128.495484,7.92774194 L128.495484,7.92774194 Z M128.495484,0.16516129 L128.495484,0.16516129 C125.027097,0.16516129 121.55871,0.990967742 118.255484,2.47741935 L34.683871,42.4464516 C28.0774194,45.5845161 23.4529032,51.3651613 21.8012903,58.4670968 L1.15612903,148.149677 C-0.495483871,155.251613 1.15612903,162.51871 5.78064516,168.299355 L63.5870968,240.144516 C68.0464516,245.76 74.8180645,248.898065 81.92,248.898065 L174.575484,248.898065 C181.677419,248.898065 188.449032,245.76 192.908387,240.144516 L250.714839,168.299355 C255.339355,162.683871 256.990968,155.251613 255.339355,148.149677 L234.694194,58.4670968 C233.042581,51.3651613 228.418065,45.5845161 221.811613,42.4464516 L138.570323,2.47741935 C135.432258,0.990967742 131.963871,0.16516129 128.495484,0.16516129 L128.495484,0.16516129 L128.495484,0.16516129 Z"
          fill="#FFFFFF"
        ></path>
        <path
          d="M212.232258,142.534194 L212.232258,142.534194 L212.232258,142.534194 C212.067097,142.534194 212.067097,142.534194 212.232258,142.534194 L212.067097,142.534194 C211.901935,142.534194 211.736774,142.534194 211.736774,142.369032 C211.406452,142.369032 211.076129,142.203871 210.745806,142.203871 C209.589677,142.03871 208.59871,141.873548 207.607742,141.873548 C207.112258,141.873548 206.616774,141.873548 205.956129,141.708387 L205.790968,141.708387 C202.322581,141.378065 199.514839,141.047742 196.872258,140.221935 C195.716129,139.726452 195.385806,139.065806 195.055484,138.405161 C195.055484,138.24 194.890323,138.24 194.890323,138.074839 L194.890323,138.074839 L192.743226,137.414194 C193.734194,129.816774 193.403871,121.889032 191.587097,114.126452 C189.770323,106.363871 186.632258,99.0967742 182.338065,92.4903226 L183.989677,91.003871 L183.989677,90.6735484 C183.989677,89.8477419 184.154839,89.0219355 184.815484,88.196129 C186.797419,86.3793548 189.274839,84.8929032 192.247742,83.076129 L192.247742,83.076129 C192.743226,82.7458065 193.23871,82.5806452 193.734194,82.2503226 C194.725161,81.7548387 195.550968,81.2593548 196.541935,80.5987097 C196.707097,80.4335484 197.037419,80.2683871 197.367742,79.9380645 C197.532903,79.7729032 197.698065,79.7729032 197.698065,79.6077419 L197.698065,79.6077419 C200.010323,77.6258065 200.505806,74.3225806 198.854194,72.1754839 C198.028387,71.0193548 196.541935,70.3587097 195.055484,70.3587097 C193.734194,70.3587097 192.578065,70.8541935 191.421935,71.68 L191.421935,71.68 L191.421935,71.68 C191.256774,71.8451613 191.256774,71.8451613 191.091613,72.0103226 C190.76129,72.1754839 190.596129,72.5058065 190.265806,72.6709677 C189.44,73.4967742 188.779355,74.1574194 188.11871,74.9832258 C187.788387,75.3135484 187.458065,75.8090323 186.962581,76.1393548 L186.962581,76.1393548 C184.650323,78.6167742 182.503226,80.5987097 180.356129,82.0851613 C179.860645,82.4154839 179.365161,82.5806452 178.869677,82.5806452 C178.539355,82.5806452 178.209032,82.5806452 177.87871,82.4154839 L177.548387,82.4154839 L177.548387,82.4154839 L175.566452,83.7367742 C173.419355,81.4245161 171.107097,79.4425806 168.794839,77.4606452 C158.885161,69.6980645 146.828387,64.9083871 134.276129,63.7522581 L134.110968,61.6051613 C133.945806,61.44 133.945806,61.44 133.780645,61.2748387 C133.285161,60.7793548 132.624516,60.283871 132.459355,59.1277419 C132.294194,56.4851613 132.624516,53.5122581 132.954839,50.2090323 L132.954839,50.043871 C132.954839,49.5483871 133.12,48.8877419 133.285161,48.3922581 C133.450323,47.4012903 133.615484,46.4103226 133.780645,45.2541935 L133.780645,44.2632258 L133.780645,43.7677419 L133.780645,43.7677419 L133.780645,43.7677419 C133.780645,40.7948387 131.468387,38.3174194 128.660645,38.3174194 C127.339355,38.3174194 126.018065,38.9780645 125.027097,39.9690323 C124.036129,40.96 123.540645,42.2812903 123.540645,43.7677419 L123.540645,43.7677419 L123.540645,43.7677419 L123.540645,44.0980645 L123.540645,45.0890323 C123.540645,46.2451613 123.705806,47.236129 124.036129,48.2270968 C124.20129,48.7225806 124.20129,49.2180645 124.366452,49.8787097 L124.366452,50.043871 C124.696774,53.3470968 125.192258,56.32 124.861935,58.9625806 C124.696774,60.1187097 124.036129,60.6141935 123.540645,61.1096774 C123.375484,61.2748387 123.375484,61.2748387 123.210323,61.44 L123.210323,61.44 L123.045161,63.5870968 C120.072258,63.9174194 117.099355,64.2477419 114.126452,64.9083871 C101.409032,67.716129 90.1780645,74.1574194 81.4245161,83.4064516 L79.7729032,82.2503226 L79.4425806,82.2503226 C79.1122581,82.2503226 78.7819355,82.4154839 78.4516129,82.4154839 C77.956129,82.4154839 77.4606452,82.2503226 76.9651613,81.92 C74.8180645,80.4335484 72.6709677,78.2864516 70.3587097,75.8090323 L70.3587097,75.8090323 C70.0283871,75.4787097 69.6980645,74.9832258 69.2025806,74.6529032 C68.5419355,73.8270968 67.8812903,73.1664516 67.0554839,72.3406452 C66.8903226,72.1754839 66.56,72.0103226 66.2296774,71.68 C66.0645161,71.5148387 65.8993548,71.5148387 65.8993548,71.3496774 L65.8993548,71.3496774 C64.9083871,70.523871 63.5870968,70.0283871 62.2658065,70.0283871 C60.7793548,70.0283871 59.2929032,70.6890323 58.4670968,71.8451613 C56.8154839,73.9922581 57.3109677,77.2954839 59.6232258,79.2774194 L59.6232258,79.2774194 L59.6232258,79.2774194 C59.7883871,79.2774194 59.7883871,79.4425806 59.9535484,79.4425806 C60.283871,79.6077419 60.4490323,79.9380645 60.7793548,80.1032258 C61.7703226,80.763871 62.596129,81.2593548 63.5870968,81.7548387 C64.0825806,81.92 64.5780645,82.2503226 65.0735484,82.5806452 L65.0735484,82.5806452 C68.0464516,84.3974194 70.523871,85.883871 72.5058065,87.7006452 C73.3316129,88.5264516 73.3316129,89.3522581 73.3316129,90.1780645 L73.3316129,90.5083871 L73.3316129,90.5083871 L74.9832258,91.9948387 C74.6529032,92.4903226 74.3225806,92.8206452 74.1574194,93.316129 C65.8993548,106.363871 62.7612903,121.723871 64.9083871,136.91871 L62.7612903,137.579355 C62.7612903,137.744516 62.596129,137.744516 62.596129,137.909677 C62.2658065,138.570323 61.7703226,139.230968 60.7793548,139.726452 C58.3019355,140.552258 55.3290323,140.882581 51.8606452,141.212903 L51.6954839,141.212903 C51.2,141.212903 50.5393548,141.212903 50.043871,141.378065 C49.0529032,141.378065 48.0619355,141.543226 46.9058065,141.708387 C46.5754839,141.708387 46.2451613,141.873548 45.9148387,141.873548 C45.7496774,141.873548 45.5845161,141.873548 45.4193548,142.03871 L45.4193548,142.03871 L45.4193548,142.03871 C42.4464516,142.699355 40.6296774,145.507097 41.1251613,148.149677 C41.6206452,150.461935 43.7677419,151.948387 46.4103226,151.948387 C46.9058065,151.948387 47.236129,151.948387 47.7316129,151.783226 L47.7316129,151.783226 L47.7316129,151.783226 C47.8967742,151.783226 48.0619355,151.783226 48.0619355,151.618065 C48.3922581,151.618065 48.7225806,151.452903 49.0529032,151.452903 C50.2090323,151.122581 51.0348387,150.792258 52.0258065,150.296774 C52.5212903,150.131613 53.0167742,149.80129 53.5122581,149.636129 L53.6774194,149.636129 C56.8154839,148.48 59.6232258,147.489032 62.2658065,147.15871 L62.596129,147.15871 C63.5870968,147.15871 64.2477419,147.654194 64.7432258,147.984516 C64.9083871,147.984516 64.9083871,148.149677 65.0735484,148.149677 L65.0735484,148.149677 L67.3858065,147.819355 C71.3496774,160.04129 78.9470968,170.941935 89.0219355,178.869677 C91.3341935,180.686452 93.6464516,182.172903 96.123871,183.659355 L95.1329032,185.806452 C95.1329032,185.971613 95.2980645,185.971613 95.2980645,186.136774 C95.6283871,186.797419 95.9587097,187.623226 95.6283871,188.779355 C94.6374194,191.256774 93.1509677,193.734194 91.3341935,196.541935 L91.3341935,196.707097 C91.003871,197.202581 90.6735484,197.532903 90.3432258,198.028387 C89.6825806,198.854194 89.1870968,199.68 88.5264516,200.670968 C88.3612903,200.836129 88.196129,201.166452 88.0309677,201.496774 C88.0309677,201.661935 87.8658065,201.827097 87.8658065,201.827097 L87.8658065,201.827097 L87.8658065,201.827097 C86.5445161,204.634839 87.5354839,207.772903 90.0129032,208.929032 C90.6735484,209.259355 91.3341935,209.424516 91.9948387,209.424516 C93.9767742,209.424516 95.9587097,208.103226 96.9496774,206.286452 L96.9496774,206.286452 L96.9496774,206.286452 C96.9496774,206.12129 97.1148387,205.956129 97.1148387,205.956129 C97.28,205.625806 97.4451613,205.295484 97.6103226,205.130323 C98.1058065,203.974194 98.2709677,203.148387 98.6012903,202.157419 C98.7664516,201.661935 98.9316129,201.166452 99.0967742,200.670968 L99.0967742,200.670968 C100.252903,197.367742 101.07871,194.725161 102.565161,192.412903 C103.225806,191.421935 104.051613,191.256774 104.712258,190.926452 C104.877419,190.926452 104.877419,190.926452 105.042581,190.76129 L105.042581,190.76129 L106.19871,188.614194 C113.465806,191.421935 121.393548,192.908387 129.32129,192.908387 C134.110968,192.908387 139.065806,192.412903 143.690323,191.256774 C146.663226,190.596129 149.470968,189.770323 152.27871,188.779355 L153.269677,190.596129 C153.434839,190.596129 153.434839,190.596129 153.6,190.76129 C154.425806,190.926452 155.086452,191.256774 155.747097,192.247742 C157.068387,194.56 158.059355,197.367742 159.215484,200.505806 L159.215484,200.670968 C159.380645,201.166452 159.545806,201.661935 159.710968,202.157419 C160.04129,203.148387 160.206452,204.139355 160.701935,205.130323 C160.867097,205.460645 161.032258,205.625806 161.197419,205.956129 C161.197419,206.12129 161.362581,206.286452 161.362581,206.286452 L161.362581,206.286452 L161.362581,206.286452 C162.353548,208.268387 164.335484,209.424516 166.317419,209.424516 C166.978065,209.424516 167.63871,209.259355 168.299355,208.929032 C169.455484,208.268387 170.446452,207.277419 170.776774,205.956129 C171.107097,204.634839 171.107097,203.148387 170.446452,201.827097 L170.446452,201.827097 L170.446452,201.827097 C170.446452,201.661935 170.28129,201.661935 170.28129,201.496774 C170.116129,201.166452 169.950968,200.836129 169.785806,200.670968 C169.290323,199.68 168.629677,198.854194 167.969032,198.028387 C167.63871,197.532903 167.308387,197.202581 166.978065,196.707097 L166.978065,196.541935 C165.16129,193.734194 163.509677,191.256774 162.683871,188.779355 C162.353548,187.623226 162.683871,186.962581 162.849032,186.136774 C162.849032,185.971613 163.014194,185.971613 163.014194,185.806452 L163.014194,185.806452 L162.188387,183.824516 C170.941935,178.704516 178.374194,171.437419 183.989677,162.51871 C186.962581,157.894194 189.274839,152.774194 190.926452,147.654194 L192.908387,147.984516 C193.073548,147.984516 193.073548,147.819355 193.23871,147.819355 C193.899355,147.489032 194.394839,146.993548 195.385806,146.993548 L195.716129,146.993548 C198.35871,147.323871 201.166452,148.314839 204.304516,149.470968 L204.469677,149.470968 C204.965161,149.636129 205.460645,149.966452 205.956129,150.131613 C206.947097,150.627097 207.772903,150.957419 208.929032,151.287742 C209.259355,151.287742 209.589677,151.452903 209.92,151.452903 C210.085161,151.452903 210.250323,151.452903 210.415484,151.618065 L210.415484,151.618065 C210.910968,151.783226 211.24129,151.783226 211.736774,151.783226 C214.214194,151.783226 216.36129,150.131613 217.021935,147.984516 C217.021935,146.002581 215.205161,143.36 212.232258,142.534194 L212.232258,142.534194 Z M135.762581,134.44129 L128.495484,137.909677 L121.228387,134.44129 L119.411613,126.67871 L124.366452,120.402581 L132.459355,120.402581 L137.414194,126.67871 L135.762581,134.44129 L135.762581,134.44129 Z M178.869677,117.264516 C180.190968,122.88 180.52129,128.495484 180.025806,133.945806 L154.756129,126.67871 C152.443871,126.018065 151.122581,123.705806 151.618065,121.393548 C151.783226,120.732903 152.113548,120.072258 152.609032,119.576774 L172.593548,101.574194 C175.40129,106.19871 177.548387,111.483871 178.869677,117.264516 L178.869677,117.264516 Z M164.665806,91.6645161 L143.029677,107.024516 C141.212903,108.180645 138.735484,107.850323 137.249032,106.033548 C136.753548,105.538065 136.588387,104.877419 136.423226,104.216774 L134.936774,77.2954839 C146.332903,78.6167742 156.738065,83.7367742 164.665806,91.6645161 L164.665806,91.6645161 Z M116.769032,78.1212903 C118.585806,77.7909677 120.237419,77.4606452 122.054194,77.1303226 L120.567742,103.556129 C120.402581,105.868387 118.585806,107.850323 116.108387,107.850323 C115.447742,107.850323 114.621935,107.685161 114.126452,107.354839 L92.16,91.6645161 C98.9316129,84.8929032 107.354839,80.2683871 116.769032,78.1212903 L116.769032,78.1212903 Z M84.2322581,101.574194 L103.886452,119.08129 C105.703226,120.567742 105.868387,123.375484 104.381935,125.192258 C103.886452,125.852903 103.225806,126.348387 102.4,126.513548 L76.8,133.945806 C75.8090323,122.714839 78.2864516,111.31871 84.2322581,101.574194 L84.2322581,101.574194 Z M79.7729032,146.332903 L106.033548,141.873548 C108.180645,141.708387 110.162581,143.194839 110.658065,145.341935 C110.823226,146.332903 110.823226,147.15871 110.492903,147.984516 L110.492903,147.984516 L100.418065,172.263226 C91.1690323,166.317419 83.7367742,157.233548 79.7729032,146.332903 L79.7729032,146.332903 Z M140.056774,179.2 C136.258065,180.025806 132.459355,180.52129 128.495484,180.52129 C122.714839,180.52129 117.099355,179.530323 111.814194,177.87871 L124.861935,154.260645 C126.183226,152.774194 128.330323,152.113548 130.147097,153.104516 C130.972903,153.6 131.633548,154.260645 132.129032,154.92129 L132.129032,154.92129 L144.846452,177.87871 C143.36,178.374194 141.708387,178.704516 140.056774,179.2 L140.056774,179.2 Z M172.263226,156.242581 C168.134194,162.849032 162.683871,168.134194 156.407742,172.263226 L146.002581,147.323871 C145.507097,145.341935 146.332903,143.194839 148.314839,142.203871 C148.975484,141.873548 149.80129,141.708387 150.627097,141.708387 L177.052903,146.167742 C176.061935,149.80129 174.410323,153.104516 172.263226,156.242581 L172.263226,156.242581 Z"
          fill="#FFFFFF"
        ></path>
      </g>
    </svg>
  );
};

export const AWSIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 153"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M72.392053,55.4384106 C72.392053,58.5748344 72.7311258,61.1178808 73.3245033,62.9827815 C74.002649,64.8476821 74.8503311,66.8821192 76.0370861,69.0860927 C76.4609272,69.7642384 76.6304636,70.4423841 76.6304636,71.0357616 C76.6304636,71.8834437 76.1218543,72.7311258 75.0198675,73.5788079 L69.6794702,77.1390728 C68.9165563,77.6476821 68.1536424,77.9019868 67.4754967,77.9019868 C66.6278146,77.9019868 65.7801325,77.4781457 64.9324503,76.7152318 C63.7456954,75.4437086 62.7284768,74.0874172 61.8807947,72.7311258 C61.0331126,71.2900662 60.1854305,69.6794702 59.2529801,67.7298013 C52.6410596,75.5284768 44.3337748,79.4278146 34.3311258,79.4278146 C27.210596,79.4278146 21.5311258,77.3933775 17.3774834,73.3245033 C13.2238411,69.2556291 11.1046358,63.8304636 11.1046358,57.0490066 C11.1046358,49.8437086 13.6476821,43.994702 18.818543,39.586755 C23.989404,35.1788079 30.8556291,32.9748344 39.586755,32.9748344 C42.4688742,32.9748344 45.4357616,33.2291391 48.5721854,33.6529801 C51.7086093,34.0768212 54.9298013,34.7549669 58.3205298,35.5178808 L58.3205298,29.3298013 C58.3205298,22.8874172 56.9642384,18.394702 54.3364238,15.7668874 C51.6238411,13.1390728 47.0463576,11.8675497 40.5192053,11.8675497 C37.5523179,11.8675497 34.5006623,12.2066225 31.3642384,12.9695364 C28.2278146,13.7324503 25.1761589,14.6649007 22.2092715,15.8516556 C20.8529801,16.4450331 19.8357616,16.784106 19.2423841,16.9536424 C18.6490066,17.1231788 18.2251656,17.207947 17.8860927,17.207947 C16.6993377,17.207947 16.1059603,16.3602649 16.1059603,14.5801325 L16.1059603,10.4264901 C16.1059603,9.07019868 16.2754967,8.05298013 16.6993377,7.45960265 C17.1231788,6.86622517 17.8860927,6.27284768 19.0728477,5.6794702 C22.0397351,4.15364238 25.6,2.88211921 29.7536424,1.86490066 C33.9072848,0.762913907 38.3152318,0.254304636 42.9774834,0.254304636 C53.0649007,0.254304636 60.4397351,2.54304636 65.186755,7.1205298 C69.8490066,11.6980132 72.2225166,18.6490066 72.2225166,27.9735099 L72.2225166,55.4384106 L72.392053,55.4384106 Z M37.9761589,68.3231788 C40.7735099,68.3231788 43.6556291,67.8145695 46.7072848,66.797351 C49.7589404,65.7801325 52.4715232,63.9152318 54.7602649,61.3721854 C56.1165563,59.7615894 57.1337748,57.981457 57.6423841,55.9470199 C58.1509934,53.9125828 58.4900662,51.4543046 58.4900662,48.5721854 L58.4900662,45.0119205 C56.0317881,44.418543 53.4039735,43.9099338 50.6913907,43.5708609 C47.9788079,43.2317881 45.3509934,43.0622517 42.7231788,43.0622517 C37.0437086,43.0622517 32.8900662,44.1642384 30.0927152,46.4529801 C27.2953642,48.7417219 25.9390728,51.9629139 25.9390728,56.2013245 C25.9390728,60.1854305 26.9562914,63.1523179 29.0754967,65.186755 C31.1099338,67.3059603 34.0768212,68.3231788 37.9761589,68.3231788 Z M106.045033,77.4781457 C104.519205,77.4781457 103.501987,77.2238411 102.823841,76.6304636 C102.145695,76.1218543 101.552318,74.9350993 101.043709,73.3245033 L81.1231788,7.7986755 C80.6145695,6.10331126 80.3602649,5.0013245 80.3602649,4.40794702 C80.3602649,3.05165563 81.0384106,2.28874172 82.394702,2.28874172 L90.7019868,2.28874172 C92.3125828,2.28874172 93.4145695,2.54304636 94.007947,3.13642384 C94.6860927,3.64503311 95.194702,4.83178808 95.7033113,6.44238411 L109.944371,62.5589404 L123.168212,6.44238411 C123.592053,4.74701987 124.100662,3.64503311 124.778808,3.13642384 C125.456954,2.62781457 126.643709,2.28874172 128.169536,2.28874172 L134.950993,2.28874172 C136.561589,2.28874172 137.663576,2.54304636 138.341722,3.13642384 C139.019868,3.64503311 139.613245,4.83178808 139.952318,6.44238411 L153.345695,63.2370861 L168.010596,6.44238411 C168.519205,4.74701987 169.112583,3.64503311 169.70596,3.13642384 C170.384106,2.62781457 171.486093,2.28874172 173.011921,2.28874172 L180.895364,2.28874172 C182.251656,2.28874172 183.01457,2.96688742 183.01457,4.40794702 C183.01457,4.83178808 182.929801,5.25562914 182.845033,5.76423841 C182.760265,6.27284768 182.590728,6.95099338 182.251656,7.88344371 L161.822517,73.4092715 C161.313907,75.1046358 160.72053,76.2066225 160.042384,76.7152318 C159.364238,77.2238411 158.262252,77.5629139 156.821192,77.5629139 L149.531126,77.5629139 C147.92053,77.5629139 146.818543,77.3086093 146.140397,76.7152318 C145.462252,76.1218543 144.868874,75.0198675 144.529801,73.3245033 L131.390728,18.6490066 L118.336424,73.2397351 C117.912583,74.9350993 117.403974,76.0370861 116.725828,76.6304636 C116.047682,77.2238411 114.860927,77.4781457 113.335099,77.4781457 L106.045033,77.4781457 Z M214.972185,79.7668874 C210.564238,79.7668874 206.156291,79.2582781 201.917881,78.2410596 C197.67947,77.2238411 194.37351,76.1218543 192.169536,74.8503311 C190.813245,74.0874172 189.880795,73.2397351 189.541722,72.4768212 C189.202649,71.7139073 189.033113,70.8662252 189.033113,70.1033113 L189.033113,65.7801325 C189.033113,64 189.711258,63.1523179 190.982781,63.1523179 C191.491391,63.1523179 192,63.2370861 192.508609,63.4066225 C193.017219,63.5761589 193.780132,63.9152318 194.627815,64.2543046 C197.509934,65.5258278 200.646358,66.5430464 203.952318,67.2211921 C207.343046,67.8993377 210.649007,68.2384106 214.039735,68.2384106 C219.380132,68.2384106 223.533775,67.3059603 226.415894,65.4410596 C229.298013,63.5761589 230.823841,60.8635762 230.823841,57.3880795 C230.823841,55.0145695 230.060927,53.0649007 228.535099,51.4543046 C227.009272,49.8437086 224.127152,48.402649 219.97351,47.0463576 L207.682119,43.2317881 C201.49404,41.2821192 196.916556,38.4 194.119205,34.5854305 C191.321854,30.8556291 189.880795,26.7019868 189.880795,22.2940397 C189.880795,18.7337748 190.643709,15.597351 192.169536,12.8847682 C193.695364,10.1721854 195.729801,7.7986755 198.272848,5.93377483 C200.815894,3.98410596 203.698013,2.54304636 207.088742,1.52582781 C210.47947,0.508609272 214.039735,0.0847682119 217.769536,0.0847682119 C219.634437,0.0847682119 221.584106,0.169536424 223.449007,0.42384106 C225.398675,0.678145695 227.178808,1.01721854 228.95894,1.35629139 C230.654305,1.78013245 232.264901,2.20397351 233.790728,2.71258278 C235.316556,3.22119205 236.503311,3.72980132 237.350993,4.2384106 C238.537748,4.91655629 239.38543,5.59470199 239.89404,6.35761589 C240.402649,7.03576159 240.656954,7.96821192 240.656954,9.15496689 L240.656954,13.1390728 C240.656954,14.9192053 239.978808,15.8516556 238.707285,15.8516556 C238.029139,15.8516556 236.927152,15.5125828 235.486093,14.8344371 C230.654305,12.6304636 225.229139,11.5284768 219.210596,11.5284768 C214.378808,11.5284768 210.564238,12.2913907 207.936424,13.9019868 C205.308609,15.5125828 203.952318,17.9708609 203.952318,21.4463576 C203.952318,23.8198675 204.8,25.8543046 206.495364,27.4649007 C208.190728,29.0754967 211.327152,30.6860927 215.819868,32.1271523 L227.856954,35.9417219 C233.960265,37.8913907 238.368212,40.6039735 240.996026,44.0794702 C243.623841,47.5549669 244.895364,51.5390728 244.895364,55.9470199 C244.895364,59.592053 244.13245,62.8980132 242.691391,65.7801325 C241.165563,68.6622517 239.131126,71.205298 236.503311,73.2397351 C233.875497,75.3589404 230.739073,76.8847682 227.09404,77.986755 C223.27947,79.1735099 219.295364,79.7668874 214.972185,79.7668874 Z"
          fill="currentColor"
          fillRule="nonzero"
        ></path>
        <path
          d="M230.993377,120.964238 C203.104636,141.562914 162.58543,152.498013 127.745695,152.498013 C78.9192053,152.498013 34.9245033,134.442384 1.69536424,104.434437 C-0.932450331,102.060927 1.4410596,98.8397351 4.57748344,100.704636 C40.5192053,121.557616 84.8529801,134.188079 130.712583,134.188079 C161.65298,134.188079 195.645033,127.745695 226.924503,114.521854 C231.586755,112.402649 235.570861,117.57351 230.993377,120.964238 Z M242.606623,107.740397 C239.046358,103.162914 219.04106,105.536424 209.970861,106.638411 C207.258278,106.977483 206.834437,104.603974 209.292715,102.823841 C225.229139,91.6344371 251.422517,94.8556291 254.474172,98.5854305 C257.525828,102.4 253.62649,128.593377 238.707285,141.139073 C236.418543,143.088742 234.21457,142.071523 235.231788,139.528477 C238.622517,131.136424 246.166887,112.233113 242.606623,107.740397 Z"
          fill="#FF9900"
        ></path>
      </g>
    </svg>
  );
};

export const GitlabIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      viewBox="0 0 256 236"
      version="1.1"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      preserveAspectRatio="xMidYMid"
    >
      <g>
        <path
          d="M128.07485,236.074667 L128.07485,236.074667 L175.17885,91.1043048 L80.9708495,91.1043048 L128.07485,236.074667 L128.07485,236.074667 Z"
          fill="#E24329"
        ></path>
        <path
          d="M128.07485,236.074423 L80.9708495,91.104061 L14.9557638,91.104061 L128.07485,236.074423 L128.07485,236.074423 Z"
          fill="#FC6D26"
        ></path>
        <path
          d="M14.9558857,91.1044267 L14.9558857,91.1044267 L0.641828571,135.159589 C-0.663771429,139.17757 0.766171429,143.57955 4.18438095,146.06275 L128.074971,236.074789 L14.9558857,91.1044267 L14.9558857,91.1044267 Z"
          fill="#FCA326"
        ></path>
        <path
          d="M14.9558857,91.1045486 L80.9709714,91.1045486 L52.6000762,3.79026286 C51.1408762,-0.703146667 44.7847619,-0.701927619 43.3255619,3.79026286 L14.9558857,91.1045486 L14.9558857,91.1045486 Z"
          fill="#E24329"
        ></path>
        <path
          d="M128.07485,236.074423 L175.17885,91.104061 L241.193935,91.104061 L128.07485,236.074423 L128.07485,236.074423 Z"
          fill="#FC6D26"
        ></path>
        <path
          d="M241.193935,91.1044267 L241.193935,91.1044267 L255.507992,135.159589 C256.813592,139.17757 255.38365,143.57955 251.96544,146.06275 L128.07485,236.074789 L241.193935,91.1044267 L241.193935,91.1044267 Z"
          fill="#FCA326"
        ></path>
        <path
          d="M241.193935,91.1045486 L175.17885,91.1045486 L203.549745,3.79026286 C205.008945,-0.703146667 211.365059,-0.701927619 212.824259,3.79026286 L241.193935,91.1045486 L241.193935,91.1045486 Z"
          fill="#E24329"
        ></path>
      </g>
    </svg>
  );
};

export const RailsIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="#CC0000"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Ruby on Rails</title>
      <path d="M7.523 7.781c-.187 0-.382.011-.582.035l.116.358c.175-.018.351-.024.527-.024h.06l-.12-.369zm2.315.358l-.024.4c.2.067.394.138.588.217l.026-.404c-.055-.03-.208-.104-.59-.213zm-4.988.23a9.597 9.597 0 00-.473.26l.28.426c.157-.097.308-.19.466-.268L4.85 8.37zm2.89.022a5.602 5.602 0 00-.654.027c-.443.04-.909.169-1.38.375-1.418.618-2.878 1.918-3.833 3.51-.955 1.591-1.291 3-1.4 3.603-.037.202-.05.313-.05.313h4.79s-.057-.26-.096-.678a8.18 8.18 0 01-.033-.732c0-.55.055-1.203.244-1.858.047-.163.103-.328.168-.49.065-.162.14-.321.225-.479.17-.314.381-.618.646-.894s.584-.525.963-.736c.248-.12.698-.365 1.346-.489.216-.041.453-.07.713-.076.26-.005.542.012.845.06.606.097 1.298.32 2.075.74.388.211.798.47 1.228.788.11-.09.211-.162.211-.162s-.196-.197-.547-.486c-.35-.29-.853-.672-1.467-1.043-.306-.186-.642-.37-.998-.538a8.852 8.852 0 00-1.129-.44 7.48 7.48 0 00-1.226-.27 6.048 6.048 0 00-.64-.045zm2.086 1.65l-.023.383c.2.006.4.03.6.072l.025-.375a4.32 4.32 0 00-.602-.08zm-1.418.146c-.206.061-.381.127-.533.194l.139.418c.175-.085.351-.157.527-.211l-.133-.4zm-6.008.024c-.157.151-.31.303-.449.455l.467.4c.127-.163.267-.327.412-.478l-.43-.377zm4.34.898c-.14.128-.266.267-.375.407l.291.435c.103-.151.224-.29.358-.43l-.274-.412zm.989.787v4.323h1.164v-1.043L9.9 16.219h1.721l-1.351-1.364s1.06-.09 1.06-1.46c0-1.37-1.285-1.499-1.285-1.499H7.729zm5.292.032c-.842 0-1.126.763-1.126 1.127v3.164h1.181v-.758h1.11v.758h1.146v-3.164c0-.922-.838-1.127-1.129-1.127h-1.182zm2.85 0v4.29h1.23v-4.29h-1.23zm1.733 0v4.291h2.88v-1.11h-1.656v-3.181h-1.224zm4.359 0c-.485 0-1.133.399-1.133 1.144v.383c0 .746.642 1.127 1.133 1.127 1.364.006-.327 0 .933 0v.533l-2.005.006v1.098h1.982c.406 0 1.103-.297 1.127-1.127v-.424c0-.71-.581-1.129-1.127-1.129h-.988v-.508h1.957v-1.103h-1.88zM5.668 12.8a5.75 5.75 0 00-.182.666l.49.388c.025-.236.069-.472.13-.709l-.438-.345zm7.771.15h.407c.327 0 .334.236.334.236v1.05h-1.11v-1.05s0-.236.37-.236zm-4.546.031h.933s.262.097.262.49c0 .395-.268.499-.268.499h-.927v-.989zm-8.59.061c-.115.26-.242.563-.303.727l.697.255c.08-.206.206-.504.303-.728l-.697-.254zm5.092 1.963c.012.321.043.584.074.765l.726.26a8.003 8.003 0 01-.144-.787l-.656-.238z" />
    </svg>
  );
};

export const NextJsIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="currentColor"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Next.js</title>
      <path d="M11.5725 0c-.1763 0-.3098.0013-.3584.0067-.0516.0053-.2159.021-.3636.0328-3.4088.3073-6.6017 2.1463-8.624 4.9728C1.1004 6.584.3802 8.3666.1082 10.255c-.0962.659-.108.8537-.108 1.7474s.012 1.0884.108 1.7476c.652 4.506 3.8591 8.2919 8.2087 9.6945.7789.2511 1.6.4223 2.5337.5255.3636.04 1.9354.04 2.299 0 1.6117-.1783 2.9772-.577 4.3237-1.2643.2065-.1056.2464-.1337.2183-.1573-.0188-.0139-.8987-1.1938-1.9543-2.62l-1.919-2.592-2.4047-3.5583c-1.3231-1.9564-2.4117-3.556-2.4211-3.556-.0094-.0026-.0187 1.5787-.0235 3.509-.0067 3.3802-.0093 3.5162-.0516 3.596-.061.115-.108.1618-.2064.2134-.075.0374-.1408.0445-.495.0445h-.406l-.1078-.068a.4383.4383 0 01-.1572-.1712l-.0493-.1056.0053-4.703.0067-4.7054.0726-.0915c.0376-.0493.1174-.1125.1736-.143.0962-.047.1338-.0517.5396-.0517.4787 0 .5584.0187.6827.1547.0353.0377 1.3373 1.9987 2.895 4.3608a10760.433 10760.433 0 004.7344 7.1706l1.9002 2.8782.096-.0633c.8518-.5536 1.7525-1.3418 2.4657-2.1627 1.5179-1.7429 2.4963-3.868 2.8247-6.134.0961-.6591.1078-.854.1078-1.7475 0-.8937-.012-1.0884-.1078-1.7476-.6522-4.506-3.8592-8.2919-8.2087-9.6945-.7672-.2487-1.5836-.42-2.4985-.5232-.169-.0176-1.0835-.0366-1.6123-.037zm4.0685 7.217c.3473 0 .4082.0053.4857.047.1127.0562.204.1642.237.2767.0186.061.0234 1.3653.0186 4.3044l-.0067 4.2175-.7436-1.14-.7461-1.14v-3.066c0-1.982.0093-3.0963.0234-3.1502.0375-.1313.1196-.2346.2323-.2955.0961-.0494.1313-.054.4997-.054z" />
    </svg>
  );
};

export const NuxtJsIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="currentColor"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Nuxt.js</title>
      <path d="M13.4642 19.8295h8.9218c.2834 0 .5618-.0723.8072-.2098a1.5899 1.5899 0 0 0 .5908-.5732 1.5293 1.5293 0 0 0 .216-.783 1.529 1.529 0 0 0-.2167-.7828L17.7916 7.4142a1.5904 1.5904 0 0 0-.5907-.573 1.6524 1.6524 0 0 0-.807-.2099c-.2833 0-.5616.0724-.807.2098a1.5904 1.5904 0 0 0-.5907.5731L13.4642 9.99l-2.9954-5.0366a1.5913 1.5913 0 0 0-.591-.573 1.6533 1.6533 0 0 0-.8071-.2098c-.2834 0-.5617.0723-.8072.2097a1.5913 1.5913 0 0 0-.591.573L.2168 17.4808A1.5292 1.5292 0 0 0 0 18.2635c-.0001.2749.0744.545.216.783a1.59 1.59 0 0 0 .5908.5732c.2454.1375.5238.2098.8072.2098h5.6003c2.219 0 3.8554-.9454 4.9813-2.7899l2.7337-4.5922L16.3935 9.99l4.3944 7.382h-5.8586ZM7.123 17.3694l-3.9083-.0009 5.8586-9.8421 2.9232 4.921-1.9572 3.2892c-.7478 1.1967-1.5972 1.6328-2.9163 1.6328z" />
    </svg>
  );
};

export const LaravalIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="#FF2D20"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>Laravel</title>
      <path d="M23.642 5.43a.364.364 0 01.014.1v5.149c0 .135-.073.26-.189.326l-4.323 2.49v4.934a.378.378 0 01-.188.326L9.93 23.949a.316.316 0 01-.066.027c-.008.002-.016.008-.024.01a.348.348 0 01-.192 0c-.011-.002-.02-.008-.03-.012-.02-.008-.042-.014-.062-.025L.533 18.755a.376.376 0 01-.189-.326V2.974c0-.033.005-.066.014-.098.003-.012.01-.02.014-.032a.369.369 0 01.023-.058c.004-.013.015-.022.023-.033l.033-.045c.012-.01.025-.018.037-.027.014-.012.027-.024.041-.034H.53L5.043.05a.375.375 0 01.375 0L9.93 2.647h.002c.015.01.027.021.04.033l.038.027c.013.014.02.03.033.045.008.011.02.021.025.033.01.02.017.038.024.058.003.011.01.021.013.032.01.031.014.064.014.098v9.652l3.76-2.164V5.527c0-.033.004-.066.013-.098.003-.01.01-.02.013-.032a.487.487 0 01.024-.059c.007-.012.018-.02.025-.033.012-.015.021-.03.033-.043.012-.012.025-.02.037-.028.014-.01.026-.023.041-.032h.001l4.513-2.598a.375.375 0 01.375 0l4.513 2.598c.016.01.027.021.042.031.012.01.025.018.036.028.013.014.022.03.034.044.008.012.019.021.024.033.011.02.018.04.024.06.006.01.012.021.015.032zm-.74 5.032V6.179l-1.578.908-2.182 1.256v4.283zm-4.51 7.75v-4.287l-2.147 1.225-6.126 3.498v4.325zM1.093 3.624v14.588l8.273 4.761v-4.325l-4.322-2.445-.002-.003H5.04c-.014-.01-.025-.021-.04-.031-.011-.01-.024-.018-.035-.027l-.001-.002c-.013-.012-.021-.025-.031-.04-.01-.011-.021-.022-.028-.036h-.002c-.008-.014-.013-.031-.02-.047-.006-.016-.014-.027-.018-.043a.49.49 0 01-.008-.057c-.002-.014-.006-.027-.006-.041V5.789l-2.18-1.257zM5.23.81L1.47 2.974l3.76 2.164 3.758-2.164zm1.956 13.505l2.182-1.256V3.624l-1.58.91-2.182 1.255v9.435zm11.581-10.95l-3.76 2.163 3.76 2.163 3.759-2.164zm-.376 4.978L16.21 7.087 14.63 6.18v4.283l2.182 1.256 1.58.908zm-8.65 9.654l5.514-3.148 2.756-1.572-3.757-2.163-4.323 2.489-3.941 2.27z" />
    </svg>
  );
};

export const PlaceholderIcon = ({ className }: Props) => {
  return (
    <svg
      className={className}
      fill="currentColor"
      role="img"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
    >
      <title>CodeSandbox</title>
      <path d="M0 24H24V0H0V2.45455H21.5455V21.5455H2.45455V0H0Z" />
    </svg>
  );
};
