<a href="https://envless.dev">
  <img alt="Frictionless and secure way to share and manage app secrets across team." src="https://envless.dev/og.png" />
  <h1 align="center">.envless</h1>
</a>

<p align="center">
  An open-source, frictionless and secure way to share and manage app secrets across teams.
</p>

<p align="center">
  <a href="https://github.com/envless/envless/stargazers">
    <img src="https://img.shields.io/github/stars/envless/envless??style=flat&label=%40envless/envless&logo=github&color=2dd4bf&logoColor=fff" alt="Github" />
  </a>
  <a href="https://twitter.com/envless">
    <img src="https://img.shields.io/twitter/follow/envless?style=flat&label=%40envless&logo=twitter&color=0bf&logoColor=fff" alt="Twitter" />
  </a>
  <a href="https://github.com/envless/envless/actions/workflows/ci.yml">
    <img src="https://github.com/envless/envless/actions/workflows/ci.yml/badge.svg?branch=main" alt="CI" />
  </a>
  <a href="https://github.com/envless/envless/blob/main/LICENSE">
    <img src="https://img.shields.io/github/license/envless/envless?label=license&logo=github&color=f80&logoColor=fff" alt="License" />
  </a>
  <a href="https://dub.sh/envless-slack">
    <img src="https://img.shields.io/badge/Slack-Join%20us%20on%20Slack-purple" alt="Join us on Slack" />
  </a>
  <a href="https://dub.sh/envless-discord">
    <img src="https://img.shields.io/badge/Discord-Join%20us%20on%20Discord-blue" alt="Join us on Discord" />
  </a>
</p>

## 📖 Table of contents

- <a href="#about">About</a>
- <a href="#community">Community</a>
- <a href="#contributors">Contributors</a>
- <a href="#Contributing">Contributing</a>
- <a href="#License">License</a>

<h2 id="about">💡 About </h2>

- **What is `Envless` ?** It is an open-source tool that provides a frictionless and secure way to share and manage app secrets across teams.
- With **`Envless`**, you can easily store and share sensitive data like API keys, passwords, and certificates without compromising security.
- **`Envless`** uses state-of-the-art encryption and access control features to ensure that your secrets are only accessible to authorized team members.
- **`Envless`** is designed to be easy to use and integrate into your existing workflow. It supports a wide range of programming languages and deployment environments, including containers, serverless functions, and traditional servers.
- Whether you're a small team or a large enterprise, Envless can help you simplify your secret management and reduce the risk of data breaches.
- To get started with **`Envless`**, check out the <a href="https://envless.dev">website</a>.
- You can also join our community on Discord or Slack to ask questions and share feedback.

<h2 id="community">🚀 Community</h2>

- We have Slack and Discord where we discuss about out updates, features, requests, best practices, contributions and everything.
- **Please click on the banners below and join us.**
  .
  .

<table>
  <tr>
     <td style="text-align: center;">
      <a href="https://dub.sh/envless-discord">
        <img src="./.github/images/discord-banner.png" width="380" alt="Discord invite banner">
      </a>
    </td>
     <td style="text-align: center;">
      <a href="https://dub.sh/envless-slack">
        <img src="./.github/images/slack-banner.png" width="380" alt="Slack invite banner">
      </a>
    </td>
  </tr>
</table>

<h2 id="Contributing">🤝 Contributing</h2>

Whether you are a community member or not, we would love your point of view! Feel free to first check out our

- [Contribution Guidelines](https://github.com/envless/envless/blob/main/CONTRIBUTING.md)
- The guide outlines the process for **creating an issue** and **submitting a pull request.**

<h2 id="License">🛡️ License</h2>

Envless is licensed under the GNU Affero General Public License v3.0 License - see the [LICENSE](https://github.com/envless/envless/blob/main/LICENSE) file for details.

<h2 id="contributors">✨ Contributors</h2>

- We ❤️ contributors! Feel free to contribute to this project!.
- Any contributions you make are truly appreciated.
- Let's continue contributing to keep the community active and growing.
- We also welcome you to join our [Slack](https://dub.sh/envless-slack) or [Discord](https://dub.sh/envless-discord) community for either support or contributing guidance.

<a href="https://github.com/envless/envless/graphs/contributors">
  <p>
    <img src="https://contrib.rocks/image?repo=envless/envless" alt="A table of avatars from the project's contributors" />
  </p>
</a>
<h2>🙏 Support</h2>
<p>
Don't forget to leave a star ⭐️
</p>
<image src=".github/images/envless.gif">
