# Changelog

## 0.1.2 (2023-04-12)

### ⚠ BREAKING CHANGES

- **test:** seperate folder structure for e2e and unit testing ([#101](https://github.com/envless/envless/issues/101))

### Features

- add branch status ([#152](https://github.com/envless/envless/issues/152)) ([a995109](https://github.com/envless/envless/commit/a9951090aa7c2d4e3405addd7f2882225ae6ac6d))
- add branches seeder ([#169](https://github.com/envless/envless/issues/169)) ([59643cd](https://github.com/envless/envless/commit/59643cd9ca4ca926fbab137cdfd8f2fe0788ac72))
- Add browser confirm for CLI token rotation ([#337](https://github.com/envless/envless/issues/337)) ([9841e18](https://github.com/envless/envless/commit/9841e18c61b7382f56fa6a428ab09e6e0c09b2f0))
- add changelog pages ([a1d8b3f](https://github.com/envless/envless/commit/a1d8b3f1dc6b0f1bacb6b2fe9f2cb649c8561e7f))
- add global toast notification ([#67](https://github.com/envless/envless/issues/67)) ([#89](https://github.com/envless/envless/issues/89)) ([b34365c](https://github.com/envless/envless/commit/b34365c7cd423855a74950b9d09bb9aad12e4744))
- add missing indices for association ([#204](https://github.com/envless/envless/issues/204)) ([2c71275](https://github.com/envless/envless/commit/2c71275031be026536f204141a352b71629e9b0b))
- add og image api endpoint ([#191](https://github.com/envless/envless/issues/191)) ([8f97a13](https://github.com/envless/envless/commit/8f97a13e700a191ac21be3e87017bec715db4714))
- add protected status & description to branches ([de37cc3](https://github.com/envless/envless/commit/de37cc3159f2c03e80834e10dca962c3e6273f91))
- add public key table ([479bd4b](https://github.com/envless/envless/commit/479bd4ba25399076cbe7d1fc12a8a9fd52182f47))
- add release please github action ([#315](https://github.com/envless/envless/issues/315)) ([7d40d99](https://github.com/envless/envless/commit/7d40d995c2ab983167167e3cde51f3a560417e6d))
- add seed for audits as well ([#167](https://github.com/envless/envless/issues/167)) ([7156270](https://github.com/envless/envless/commit/715627009f749d74285ad43f7b7665812ec8c321))
- add seed for pull requests ([#183](https://github.com/envless/envless/issues/183)) ([#198](https://github.com/envless/envless/issues/198)) ([c6f0f89](https://github.com/envless/envless/commit/c6f0f897bbd4dce2cbc2b79baf6f12785f2f48d6))
- add semantic pr title workflow ([#314](https://github.com/envless/envless/issues/314)) ([5f0ab4e](https://github.com/envless/envless/commit/5f0ab4eccdf36741b027cfe5929a626638e479f8))
- add tool-version and gitignore redis dump.rdb ([04ef6cf](https://github.com/envless/envless/commit/04ef6cf9fb641ddfa487ae3ee12837a7c3763413))
- add updatedAt column to pull requests table ([#231](https://github.com/envless/envless/issues/231)) ([ccd0e88](https://github.com/envless/envless/commit/ccd0e88acca51dddec655ab8a3ea0e13074663a3))
- Add user lockout for failed 2FA ([#308](https://github.com/envless/envless/issues/308)) ([a3e08de](https://github.com/envless/envless/commit/a3e08de67a8f232765354e8d4ea0c48a15ce6100))
- added hover call for pull request title ([#182](https://github.com/envless/envless/issues/182)) ([#187](https://github.com/envless/envless/issues/187)) ([4326dd9](https://github.com/envless/envless/commit/4326dd97b4e5ac22b7c1ff213b8410626726fa2f))
- added migration for pull request ([#196](https://github.com/envless/envless/issues/196)) ([#197](https://github.com/envless/envless/issues/197)) ([558348d](https://github.com/envless/envless/commit/558348d735d5d145ff9b081de41fd6aded62fc41))
- added project_setting table ([#153](https://github.com/envless/envless/issues/153)) ([5d3ff0e](https://github.com/envless/envless/commit/5d3ff0e22b540c7a2feb97aa675a845ffac07091))
- additional security - ask users to provide OTP for one last time before they disable two factor auth ([#110](https://github.com/envless/envless/issues/110)) ([e3cbb07](https://github.com/envless/envless/commit/e3cbb07c21b8abe83105f363dd223e6cba9188ee))
- audit log table ([#300](https://github.com/envless/envless/issues/300)) ([9bc73ca](https://github.com/envless/envless/commit/9bc73ca660fc21de1dd4a67b98266ea9d5f2ca34))
- base job class implementation and delete project cron job ([#298](https://github.com/envless/envless/issues/298)) ([f37e27c](https://github.com/envless/envless/commit/f37e27c7318be5d59dd1bc0aef413433cbad43cd))
- basic 404 page ([#243](https://github.com/envless/envless/issues/243)) ([b5d4ecc](https://github.com/envless/envless/commit/b5d4ecc75492f64cb1a70732121c660cecabbd11))
- basic create pull request modal ([#165](https://github.com/envless/envless/issues/165)) ([#170](https://github.com/envless/envless/issues/170)) ([c5614da](https://github.com/envless/envless/commit/c5614da9393861f4603a6fc580ef950e264b5dfe))
- branch combobox ([#246](https://github.com/envless/envless/issues/246)) ([4b7952f](https://github.com/envless/envless/commit/4b7952f3f3cf45f4e83846e34a04af39a7346def))
- branch dropdown ([#230](https://github.com/envless/envless/issues/230)) ([a069ef7](https://github.com/envless/envless/commit/a069ef740335457cf6aa89659ddeff627770bc88))
- branch table sorting ([#158](https://github.com/envless/envless/issues/158)) ([66acb67](https://github.com/envless/envless/commit/66acb67f4d16b87415b724a0fb278e6fa2bba2ac))
- button variants ([#209](https://github.com/envless/envless/issues/209)) ([b16cecd](https://github.com/envless/envless/commit/b16cecdce4e5743dd3fd50fc44bc6c9036a3ef8d))
- Complete integration UI ([#90](https://github.com/envless/envless/issues/90)) ([7d2c158](https://github.com/envless/envless/commit/7d2c158611031e45339e56d76cf051de60af63a7))
- Complete UI for members tab ([#64](https://github.com/envless/envless/issues/64)) ([9dff351](https://github.com/envless/envless/commit/9dff35114c15b997c14ea216f8a9ded3d6b23937))
- configure vitest and playwright, works better for next.js projects ([#245](https://github.com/envless/envless/issues/245)) ([15ec717](https://github.com/envless/envless/commit/15ec717f3871de2e4a828c5673a5871bbc3bec05))
- create an openpgp library to encrypt, decrypt, revoke and generate keys ([#207](https://github.com/envless/envless/issues/207)) ([f902930](https://github.com/envless/envless/commit/f902930b11d93338bc8490c214eccfcbb76ddb6a))
- Create blog with github mdx and get rid of notion cms ([#335](https://github.com/envless/envless/issues/335)) ([de6ffe0](https://github.com/envless/envless/commit/de6ffe096908ad8b4437afa8e1b288e165d36315))
- create new branch from branch page ([#162](https://github.com/envless/envless/issues/162)) ([#163](https://github.com/envless/envless/issues/163)) ([19b94f9](https://github.com/envless/envless/commit/19b94f951bdd11928144986ef968ffe62043178b))
- create project keys, if it was not created already. ([#340](https://github.com/envless/envless/issues/340)) ([cf978e3](https://github.com/envless/envless/commit/cf978e348ea9e518c326938da6c29d3a992b6740))
- create project slug ([#213](https://github.com/envless/envless/issues/213)) ([6c516cc](https://github.com/envless/envless/commit/6c516cc0c6d04baef0e9c1bae6ea7a86a3b4e4b5))
- create seed file for secrets ([#327](https://github.com/envless/envless/issues/327)) ([77e5d82](https://github.com/envless/envless/commit/77e5d82f8772537d60ecf987cd69de7b9fd853e8))
- custom 500 incase of failure or some error during serverside execution ([#270](https://github.com/envless/envless/issues/270)) ([4f21705](https://github.com/envless/envless/commit/4f21705b6ae2d69d02aa6a8410024a21de10d660))
- download audit log as csv ([#310](https://github.com/envless/envless/issues/310)) ([96add8a](https://github.com/envless/envless/commit/96add8a0fdb6533cad68ec09c44953dff7806491))
- End-to-end encryption using OpenPGP for asymmetric encryption and AES256-GCM for symmetric encryption ([#266](https://github.com/envless/envless/issues/266)) ([d57cd49](https://github.com/envless/envless/commit/d57cd494f444036f226c42ff6f23334ad7dfb528))
- env upload and editor ([#59](https://github.com/envless/envless/issues/59)) ([#84](https://github.com/envless/envless/issues/84)) ([046f10a](https://github.com/envless/envless/commit/046f10a7d21fd09833c77a21e5bb19e35b1cbceb))
- error boundary to handle and track error ([#269](https://github.com/envless/envless/issues/269)) ([40958f2](https://github.com/envless/envless/commit/40958f2eebea13cf5eb85a368de5c1ebdb93ec57))
- fix issue with env variables on monorepo and add some scripts to package ([#280](https://github.com/envless/envless/issues/280)) ([8dc590b](https://github.com/envless/envless/commit/8dc590bfdb47d186b85fa836827c17d0905c45f3))
- further cleanup members page ([#69](https://github.com/envless/envless/issues/69)) ([479cdbe](https://github.com/envless/envless/commit/479cdbeafa80134cd4f1eb81c12d6bb3410c31c8))
- generate prId ([#214](https://github.com/envless/envless/issues/214)) ([432d8b4](https://github.com/envless/envless/commit/432d8b4541fcdbc459bb442ec0a0536051474d92))
- get rid of all the icon library and stick with lucide-react. We ([#63](https://github.com/envless/envless/issues/63)) ([526fa6c](https://github.com/envless/envless/commit/526fa6c0c049641c6602dff8f9fbbb59cf6339fc))
- getting started with integrations ([#299](https://github.com/envless/envless/issues/299)) ([0efa1d4](https://github.com/envless/envless/commit/0efa1d4b04dc498571b87c900b13609785cec66f))
- import cli to monorepo ([#283](https://github.com/envless/envless/issues/283)) ([5f68171](https://github.com/envless/envless/commit/5f68171e3876bc42213c31969b84d58ef0543551))
- import docs to envless monorepo as well ([#284](https://github.com/envless/envless/issues/284)) ([12196cb](https://github.com/envless/envless/commit/12196cbce681e543fcfb4ff50295c258dac4d158))
- integrated balloon css ([#174](https://github.com/envless/envless/issues/174)) ([21fcb2c](https://github.com/envless/envless/commit/21fcb2c3266b24881dd065bbceee7931bb675a66))
- introducing turborepo for monorepo ([#279](https://github.com/envless/envless/issues/279)) ([3237ce1](https://github.com/envless/envless/commit/3237ce135ef301c6ee71e0ffc222a06129162bb6))
- inviting everybody to write blog posts 👋 ([#233](https://github.com/envless/envless/issues/233)) ([fdaaee6](https://github.com/envless/envless/commit/fdaaee66ae7805bfd5a002aa3eb2eff1cf080c5f))
- jest configuration for unit testing ([#100](https://github.com/envless/envless/issues/100)) ([6a8660f](https://github.com/envless/envless/commit/6a8660fa74d02428f30751480aea7a76408726ac))
- loading secrets in env variable editor ([#350](https://github.com/envless/envless/issues/350)) ([e31a312](https://github.com/envless/envless/commit/e31a312662c16093de7e34c12d6a4980479bed2e))
- made application environment variable type-safe ([#221](https://github.com/envless/envless/issues/221)) ([e5b4027](https://github.com/envless/envless/commit/e5b402731126e604faaef434cb39acc7243753a8))
- Making changelog responsive ([#57](https://github.com/envless/envless/issues/57)) ([d285ec9](https://github.com/envless/envless/commit/d285ec9bc0e4e4ada242bba2d41921a21f3cfeda))
- new create new branch ([#115](https://github.com/envless/envless/issues/115)) ([831e618](https://github.com/envless/envless/commit/831e61865c956cbdfa636d3b023ed052cc0d4acd))
- New post to blog 'debugging code like a pro' ([#236](https://github.com/envless/envless/issues/236)) ([04d0bd8](https://github.com/envless/envless/commit/04d0bd8d986c758da398fa4c2531fd6decddce0d))
- open PR modal from branches page ([459ccac](https://github.com/envless/envless/commit/459ccac32e73b0ece0f7846d29e1b8c4dc21e972))
- populate branches list on create PR modal ([#366](https://github.com/envless/envless/issues/366)) ([faa6b67](https://github.com/envless/envless/commit/faa6b67669ed64cbcb559e2349a13958d61d3bb8))
- prettify pr detail page url with prId instead of its cuid ([#219](https://github.com/envless/envless/issues/219)) ([5191f69](https://github.com/envless/envless/commit/5191f6977fd98b03177d7000695bc12f3e0c6f0b))
- Project &gt; branches page ui design ([#108](https://github.com/envless/envless/issues/108)) ([e15bd0e](https://github.com/envless/envless/commit/e15bd0e13f7d10c78fc80b7e0f07b7996932c0da))
- project deletion notice email template ([#289](https://github.com/envless/envless/issues/289)) ([d9a8e63](https://github.com/envless/envless/commit/d9a8e63a1dfd4d4d1207c50d3aefcfe55f4ad636))
- project restoration and project card design ([#294](https://github.com/envless/envless/issues/294)) ([f9ac068](https://github.com/envless/envless/commit/f9ac068a315f31c0d62c081472ba30c7281fa133))
- protect main branch and adjust UI accordingly ([#175](https://github.com/envless/envless/issues/175)) ([#176](https://github.com/envless/envless/issues/176)) ([dc4ee43](https://github.com/envless/envless/commit/dc4ee437ea31aeb7014ccde4c13f2230e1a14691))
- Protected branch settings ([#295](https://github.com/envless/envless/issues/295)) ([a18f9ba](https://github.com/envless/envless/commit/a18f9ba9f6dac0216c1859fed2fe95eaba26837f))
- pull request detail ([#211](https://github.com/envless/envless/issues/211)) ([3490d12](https://github.com/envless/envless/commit/3490d126e9dc9adf19d5e79089fcd2c2f077e597))
- Re-activate inactive users ([#338](https://github.com/envless/envless/issues/338)) ([7378416](https://github.com/envless/envless/commit/7378416f048a6f38bc523bb6df731c55713fe5e6))
- Refactor access control logic for all pages ([#297](https://github.com/envless/envless/issues/297)) ([c261bbe](https://github.com/envless/envless/commit/c261bbee585c258e27e2156d9cfb53ebf354a420))
- Refactor members invite workflow ([#347](https://github.com/envless/envless/issues/347)) ([a81170d](https://github.com/envless/envless/commit/a81170d0b7e25d6762b4986298bd628158eadeef))
- refactor members table ([#353](https://github.com/envless/envless/issues/353)) ([b15a7a9](https://github.com/envless/envless/commit/b15a7a9ad30d0e5244ba2d2b8b6ed444d40fef83))
- remove SHADOW_DATABASE for simplicity ([#206](https://github.com/envless/envless/issues/206)) ([e18eb99](https://github.com/envless/envless/commit/e18eb99b4f3c614ac4b5c2315d4f3b2017b77ec5))
- remvoe filters and sort pill when delete clicked ([#160](https://github.com/envless/envless/issues/160)) ([#161](https://github.com/envless/envless/issues/161)) ([b5cd998](https://github.com/envless/envless/commit/b5cd998fd0600864fc8e76a56f04cc1f7eb1193b))
- Render invitation expired status and re-invite pending user, if they invitation expired ([#306](https://github.com/envless/envless/issues/306)) ([5e01165](https://github.com/envless/envless/commit/5e01165baae632187dfe00b570650135ca240c61))
- rendering protected branches table ([#172](https://github.com/envless/envless/issues/172)) ([#173](https://github.com/envless/envless/issues/173)) ([82ebd58](https://github.com/envless/envless/commit/82ebd58fca9c22eeca46827cbf92ecf9a05d52eb))
- scale animation on toggle ([#111](https://github.com/envless/envless/issues/111)) ([e784561](https://github.com/envless/envless/commit/e784561d033671de9ac705174c593f83c0c4fcfa))
- separate all static pages (home, blog, changelog) to its own monorepo app, create standalone platform ([#344](https://github.com/envless/envless/issues/344)) ([da4eda1](https://github.com/envless/envless/commit/da4eda1b78e0972080f83760d4c530adf8793ecc))
- set default `encryptedProjectKey` ([087c009](https://github.com/envless/envless/commit/087c009883189c9d4e7619b73d617d3acde474b4))
- setup CI for envless ([#332](https://github.com/envless/envless/issues/332)) ([487ddde](https://github.com/envless/envless/commit/487dddeaedb5a270b719935e9ce2d657cd83941c))
- Show a confirmation modal before deleting the project ([#244](https://github.com/envless/envless/issues/244)) ([5ddf3d9](https://github.com/envless/envless/commit/5ddf3d9eca2cc7e9383dffd66831af3b194149af))
- symlink readme ([#281](https://github.com/envless/envless/issues/281)) ([9bcbf2c](https://github.com/envless/envless/commit/9bcbf2c61f83e9a71eacde8f38c70f1d27b41177))
- table component empty state ([#215](https://github.com/envless/envless/issues/215)) ([f1e6b5a](https://github.com/envless/envless/commit/f1e6b5a1311956c5605c6dfeb86a01ca557c958b))
- table component using @tanstack/react-table ([#135](https://github.com/envless/envless/issues/135)) ([9dbd7ae](https://github.com/envless/envless/commit/9dbd7ae761a64d94c5f188a8e6df48dcc8266ec4))
- **test:** seperate folder structure for e2e and unit testing ([#101](https://github.com/envless/envless/issues/101)) ([11fa949](https://github.com/envless/envless/commit/11fa949e7c749c728bd3d4c65ccb59fb08a96304))
- use balloon.css for simple one-liner tooltip ([#125](https://github.com/envless/envless/issues/125)) ([411f2eb](https://github.com/envless/envless/commit/411f2eb659bdab19ae8104497eb92ccb1effe451))
- use project.slug instead or project.id on routes ([#229](https://github.com/envless/envless/issues/229)) ([e6a14bb](https://github.com/envless/envless/commit/e6a14bbb6f77ee2ed6b49ce1848de82811725566))
- utils for two factor auth modal ([#316](https://github.com/envless/envless/issues/316)) ([2fae218](https://github.com/envless/envless/commit/2fae21859e366b57092e4cb1fb33f449e48d069d))
- Working with react markdown to render with more control ([00475c4](https://github.com/envless/envless/commit/00475c44a7c8586bfad2a06d38cf6c460c601ce9))
- write seed file and command for quickstart ([#166](https://github.com/envless/envless/issues/166)) ([d4e842b](https://github.com/envless/envless/commit/d4e842bb3954411a2b2d40b7c37c99d234a2bb7e))

### Bug Fixes

- add recommended strict: false ([2bd6fac](https://github.com/envless/envless/commit/2bd6fac09010662031f8e49f4b378dbb58410fe1))
- added missing dependency ([cc53c58](https://github.com/envless/envless/commit/cc53c58b61c99ff6bf8a246d9e5001d3ee244bcf))
- Adding a line on contributing guideline ([aa0efbb](https://github.com/envless/envless/commit/aa0efbb27164f7e26f0f52fb3293ef4fcfa14840))
- avatar on member's table ([#352](https://github.com/envless/envless/issues/352)) ([30f8458](https://github.com/envless/envless/commit/30f8458bf63d3c8e0e35c02b24d758afd9e5b247))
- build error ([#333](https://github.com/envless/envless/issues/333)) ([92fa0f7](https://github.com/envless/envless/commit/92fa0f7ad2651d2cfd6a7d1cf8ab9bf5062bc64c))
- button full width issue ([#210](https://github.com/envless/envless/issues/210)) ([aa47bfb](https://github.com/envless/envless/commit/aa47bfb10715d4b8b0d1858abbf3817d501b2d6d))
- complete UI design for pull request page ([#68](https://github.com/envless/envless/issues/68)) ([8ab460b](https://github.com/envless/envless/commit/8ab460bef50584bbb33e512d4857afe2e972f4a5))
- confirmation input and generic form ([#259](https://github.com/envless/envless/issues/259)) ([ae51824](https://github.com/envless/envless/commit/ae518246af7dd9ec005803d09778a0d14c78eb2a))
- discord invitation link that never expires ([bdb295b](https://github.com/envless/envless/commit/bdb295b3c4c2291e6557e5eefce4e70469a5943b))
- env typescript validation ([#227](https://github.com/envless/envless/issues/227)) ([dd38808](https://github.com/envless/envless/commit/dd3880881e4639f8df9b33e7bfc9d2284cd899ab))
- fixing few formatting issues ([81cb6c6](https://github.com/envless/envless/commit/81cb6c6abe469a09fe7aed87aac9d474af8db2e3))
- jsx syntax for svg attributes ([ac21bd0](https://github.com/envless/envless/commit/ac21bd0f8fe42b9768adbafb843dac2325467f70))
- link to edit doc ([f5831a4](https://github.com/envless/envless/commit/f5831a44952fefceb9df1547692eb058a7e75a6e))
- loading dynamic content on pull request and small fixes ([#216](https://github.com/envless/envless/issues/216)) ([de9a0a2](https://github.com/envless/envless/commit/de9a0a268e8d305959f1e8f6175f33ad5dd8141b))
- merge conflicts ([59c4f43](https://github.com/envless/envless/commit/59c4f430f866fd1b316d77aee5b9e3c1d4c1bcea))
- overflow of project search popover ([#66](https://github.com/envless/envless/issues/66)) ([e48ff09](https://github.com/envless/envless/commit/e48ff09f255a15b79055af2219ebb3fdc314817c))
- overflow of project search popover ([#66](https://github.com/envless/envless/issues/66)) ([#83](https://github.com/envless/envless/issues/83)) ([14d3fde](https://github.com/envless/envless/commit/14d3fdea2d5de69084431f89daa89a80eca3d582))
- package.json & yarn.lock to reduce vulnerabilities ([#220](https://github.com/envless/envless/issues/220)) ([6e71c88](https://github.com/envless/envless/commit/6e71c88e4ec68a591d081753f293b0698ad632d6))
- popover and tooltip UI fixes ([#116](https://github.com/envless/envless/issues/116)) ([067b390](https://github.com/envless/envless/commit/067b39022ffb3d7b4490b09a2a506f21a78c3d4d))
- populate branches on new branch modal ([#368](https://github.com/envless/envless/issues/368)) ([2179fe8](https://github.com/envless/envless/commit/2179fe8c1a8528247a6c8df10a154027c1ad212d))
- refactor using custom server side props function ([#286](https://github.com/envless/envless/issues/286)) ([f7e7183](https://github.com/envless/envless/commit/f7e71835fc16c66dcec5f232ad3d58984be5a96d))
- remove unstable_get_server_session from trpc create context ([#217](https://github.com/envless/envless/issues/217)) ([3cd4611](https://github.com/envless/envless/commit/3cd4611b0b5bb19a9973b77e1cc024da223598ff))
- removing single filter from table removes all other filters ([#212](https://github.com/envless/envless/issues/212)) ([0fe5cea](https://github.com/envless/envless/commit/0fe5ceac32801b3b96dc0960a562f1f89bc09d88))
- some cli issues ([d42159b](https://github.com/envless/envless/commit/d42159b3e611d2dec300f39cea18d4255e203823))
- some existing issues, builds were failing ([3341ec7](https://github.com/envless/envless/commit/3341ec7ef1d3f154fbbee34f45b9b5de371374fa))
- store project data to access log while creating project ([#293](https://github.com/envless/envless/issues/293)) ([3ea3620](https://github.com/envless/envless/commit/3ea3620dd33d068b3d74cf32e750fab38db8d883))
- the conflicts between useState and useEffect ([#326](https://github.com/envless/envless/issues/326)) ([42e7154](https://github.com/envless/envless/commit/42e7154873cd57587f6f6071db3cabece3f2ce56))
- update NextSeo with proper description and canonical URL ([bdf8ffd](https://github.com/envless/envless/commit/bdf8ffd179c4a287d045b097ae32b217b3b7f096))
- updated discord invitation link ([4b5740f](https://github.com/envless/envless/commit/4b5740f5683805e884e6d88fcdb0097d25b09aa1))
- updated readme ([#128](https://github.com/envless/envless/issues/128)) ([fc9c8b7](https://github.com/envless/envless/commit/fc9c8b7fcd216bc7cd3fb704bfee8d9c2843d34a))
- upgrade @headlessui/react from 1.7.9 to 1.7.12 ([#255](https://github.com/envless/envless/issues/255)) ([b54fa88](https://github.com/envless/envless/commit/b54fa882ae4e8eb108a8c0357de02c27925e2cff))
- upgrade @next/font from 13.1.6 to 13.2.1 ([#252](https://github.com/envless/envless/issues/252)) ([f75eabb](https://github.com/envless/envless/commit/f75eabbbd08d03376ce98b6c87111fd281c98616))
- upgrade @radix-ui/react-popover from 1.0.3 to 1.0.4 ([#254](https://github.com/envless/envless/issues/254)) ([964840a](https://github.com/envless/envless/commit/964840a58f3ccb9acedf568d99ea497711c4fba7))
- upgrade @tanstack/react-query from 4.24.9 to 4.24.10 ([#256](https://github.com/envless/envless/issues/256)) ([cf5e625](https://github.com/envless/envless/commit/cf5e625ff9b6001c0ced04f1d2179fc3ca09accc))
- upgrade @trpc/client from 10.9.0 to 10.12.0 ([#239](https://github.com/envless/envless/issues/239)) ([1ee9c38](https://github.com/envless/envless/commit/1ee9c384f2517711c9b52c0f1aa8600e43257012))
- upgrade @trpc/next from 10.9.0 to 10.10.0 ([#141](https://github.com/envless/envless/issues/141)) ([9087051](https://github.com/envless/envless/commit/908705122cf91a50da8687ed016f93d2e5bfd58e))
- upgrade @trpc/react-query from 10.12.0 to 10.13.0 ([#274](https://github.com/envless/envless/issues/274)) ([006f562](https://github.com/envless/envless/commit/006f56277df32f2c723bd9e9340e3c080ce726dc))
- upgrade @trpc/react-query from 10.9.0 to 10.10.0 ([#140](https://github.com/envless/envless/issues/140)) ([5025ae9](https://github.com/envless/envless/commit/5025ae9de9f9cea7ed942e72491badc29589d03e))
- upgrade @trpc/server from 10.9.0 to 10.10.0 ([#142](https://github.com/envless/envless/issues/142)) ([6368fc6](https://github.com/envless/envless/commit/6368fc640af32468d0f37bf489a99c8d28469111))
- upgrade @types/node from 18.11.18 to 18.14.0 ([#242](https://github.com/envless/envless/issues/242)) ([790fac4](https://github.com/envless/envless/commit/790fac46139ac18fdaa631a0cf493b5fc51cd803))
- upgrade @types/node from 18.14.0 to 18.14.2 ([#273](https://github.com/envless/envless/issues/273)) ([170a063](https://github.com/envless/envless/commit/170a063a6c4ef081d8ee8f54d9668c9ff4631938))
- upgrade @types/react-dom from 18.0.8 to 18.0.10 ([0823cde](https://github.com/envless/envless/commit/0823cdefc7aff3958738f6c4c291994fa5c7480c))
- upgrade @vercel/analytics from 0.1.8 to 0.1.10 ([#238](https://github.com/envless/envless/issues/238)) ([06334cc](https://github.com/envless/envless/commit/06334cc7658289f32ddd630f2302f37d0c9e8304))
- upgrade @vercel/og from 0.0.21 to 0.0.22 ([dd02002](https://github.com/envless/envless/commit/dd02002280158450adeb489b065e859de6ad16b0))
- upgrade lucide-react from 0.105.0 to 0.109.0 ([#139](https://github.com/envless/envless/issues/139)) ([83513fd](https://github.com/envless/envless/commit/83513fd4b8be5f29a70dd0884541cb8cd3ebc25b))
- upgrade lucide-react from 0.109.0 to 0.115.0 ([#240](https://github.com/envless/envless/issues/240)) ([813f16d](https://github.com/envless/envless/commit/813f16d9d575543f5a0f3786da4a5636e58dc1d1))
- upgrade lucide-react from 0.115.0 to 0.118.0 ([#278](https://github.com/envless/envless/issues/278)) ([20eca4c](https://github.com/envless/envless/commit/20eca4c65fd0d53b444ec1f8ec002c4a01ed35fa))
- upgrade next from 13.1.6 to 13.2.1 ([#253](https://github.com/envless/envless/issues/253)) ([82e19fe](https://github.com/envless/envless/commit/82e19feebc3da65cadaff47c21f935881bf97419))
- upgrade zod from 3.20.2 to 3.20.6 ([#241](https://github.com/envless/envless/issues/241)) ([2cb7145](https://github.com/envless/envless/commit/2cb71458072b96e60b0252921aa4a855cd90bb6b))
