﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace MultiModuleMain
{
    internal static class Db
    {
        // Get ModuleClass.netmodule bytes
        public static Byte[] GetModuleBytes()
        {
            var assembly = @"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";
            return Convert.FromBase64String(assembly);
        }
    }

    /**
     * Compile with: csc /platform:x86 /addmodule:..\Module\ModuleClass.netmodule Program.cs
     */
    class Program
    {
        static void Main(string[] args)
        {
            var executingAssembly = Assembly.GetExecutingAssembly();
            var moduleBytes = Db.GetModuleBytes();
            var module = executingAssembly.LoadModule("ModuleClass.netmodule", moduleBytes);

            Console.WriteLine("[+] Create Module");
            var moduleType = module.GetType("Module.ModuleClass");
            var moduleClass = Activator.CreateInstance(moduleType);
            Console.WriteLine("[+] Inspect Module");
            var inspectMethod = moduleType.GetMethod("Inspect");
            inspectMethod.Invoke(moduleClass, null);
            Console.WriteLine("[+] End, press end to finish");
            Console.ReadLine();

        }
    }
}
