# 国际化

- 实现国际化的方式参考vue-element-admin的
[官方文档](https://panjiachen.github.io/vue-element-admin-site/zh/guide/advanced/i18n.html),这里不再赘述,强烈建议你先把改文档读了之后再看下面的内容。


## 默认约定
针对网站资源涉及到的国际化资源的管理维护，这里给出一些flash-vue-admin的资源分类建议，当然，你也可以根据你的实际情况进行调整。

- src/lang/为国际化资源目录,目前提供了英文（en.js）和中文(zh.js)的两种语言实现。
- 目前资源语言资源文件中是json配置主要有以下几个节点：
    - route 左侧菜单资源
    - navbar 顶部导航栏资源
    - button 公共的按钮资源，比如：添加、删除、修改、确定、取消之类等等
    - common 其他公共的资源，比如一些弹出框标题、提示信息、label等等
    - login 登录页面资源
    - config 参数管理界面资源
 

## 添加新的语言支持
如果你还需要支持出中英文之外的其他语言，那么你可以通过下面步骤添加新的语言支持
- 在src/lang/目录下新增对应的资源文件
- 在src/lang/index.js中import对应的资源文件
- 在src/lang/index.js中的messages变量中加入新的语言声明
- 在src/components/LangSelect/index.vue的语言下拉框中增加新的语言选项


## 左侧菜单树的国际化
- 左侧菜单树是候系统后台配置好后生成的，所以菜单树的title目前取自后台配置的code，而不是title。code值必须与国际化资源文件中的key值一致。
- 如果菜单不想使用国际化直接取后台数据库的title作为菜单名称即可
- 请根据需要自行调整cn.enilu.flash.service.system.MenuService类的方法transferRouteMenu
```java
//如果使用前端vue-i18n对菜单进行国际化，则title設置为code，且code需要与国际化资源文件中的key值一致
meta.setTitle(String.valueOf(source[8]));
//如果不需要做国际化，则title直接设置后台管理配置的菜单标题即可
//meta.setTitle(String.valueOf(source[3]));
```
