# YouTube Downloader

This is a simple Python application that allows you to download YouTube videos or audio in MP3 format. The application provides a graphical user interface (GUI) built with `tkinter`, making it easy to use.

## Features

- Download YouTube videos in the best available quality.
- Download YouTube audio as MP3 files.
- Choose between video and audio download options.
- List downloaded files in a scrollable list.
- Open the download folder by double-clicking on the listed file.
- Progress bar and status updates during the download process.

## Requirements

- Python 3.x
- `yt-dlp` library
- `tkinter` (included with Python)

## Installation

1. **Clone the repository:**

    ```bash
    git clone https://github.com/your-username/YT-DOW.git
    ```

2. **Navigate to the project directory:**

    ```bash
    cd YT-DOW
    ```

3. **Install the required Python packages:**

    ```bash
    pip install yt-dlp
    ```

## Usage

1. **Run the application:**

    ```bash
    python main.py
    ```

2. **Enter the YouTube video URL** in the text field.

3. **Choose the download type** (Video or Audio) by selecting the appropriate option.

4. **Click the "Download" button** to start the download process.

5. The downloaded files will be saved in the `downloads` folder in the project directory.

6. **View downloaded files** in the listbox. You can double-click on a file to open the folder where it is saved.

## Notes

- This application uses `yt-dlp` for downloading YouTube content.
- MP3 conversion is handled by `ffmpeg`, which needs to be installed on your system for audio downloads to work correctly.

## Converting to .exe

To convert this Python application to a standalone `.exe` file for Windows, you can use `PyInstaller`.

### Steps:

1. **Install PyInstaller:**

    ```bash
    pip install pyinstaller
    ```

2. **Navigate to the project directory and run the following command:**

    ```bash
    pyinstaller --onefile --windowed main.py
    ```

    - `--onefile`: Packages everything into a single `.exe` file.
    - `--windowed`: Hides the command line console, showing only the GUI.

3. The generated `.exe` file will be located in the `dist` folder.

4. You can now use this `.exe` file on other Windows computers.


## Contributing

Contributions are welcome! Please fork the repository and submit a pull request with your changes.

## Contact

For any questions or suggestions, feel free to contact me at [emre@emreylmz.com](emre@emreylmz.com).
