
## Platform support

emlearn works on *any* hardware platform and SDK with **C99 compiler** support.
That is practically *all* microcontroller, embedded device and most DSP platforms from the last 20 years.
For example, emlearn is known to work together with the following.

### Software frameworks and RTOS

- Zephyr
- MBed
- Arduino
- STM32Cube
- ESP-IDF
- FreeRTOS
- Contiki-NG
- RIOT
- Apache mynewt
- Azure RTOS ThreadX
- and so on..

### Microcontroller hardware platforms

- ST STM32F4/STM32L4/STM32F1 et.c.
- Espressif ESP8266/ESP32
- Nordic NRF51/NRF52/NRF53/NRF91
- Atmel AVR8/AVR32
- Raspberry PI Pico / RP2040
- and so on...

### Embedded OS platforms

- Linux
- Windows 10 IoT
- Android
- and so on...

### Other programming languages

Since emlearn is a standard C library, it works well with any language that supports C bindings.

- C++
- Rust
- Zig
- Nim
- Python. Using CFFI or pybind11
- Node.js/JavaScript
- WebAssembly/WASM. Using Emscripten
- Java. Using JNI/JNA


### More

This list is **not exhaustive**, and emlearn should work on *any platform* with a C99 compiler.
If you have used emlearn on a platform not mentioned here, please let us know.

