<h1 align="center">
	<img alt="Discord logo" src="https://github.com/eltonlazzarin/monorepo/blob/master/assets/monorepo.svg" height="150px" width="150px" />
</h1>

<h3 align="center">
  Simple folder structure for Monorepo architecture
</h3>

<p align="center"></p>

<p align="center">
  <img alt="GitHub top language" src="https://img.shields.io/github/languages/top/eltonlazzarin/monorepo">

  <img alt="GitHub language count" src="https://img.shields.io/github/languages/count/eltonlazzarin/monorepo">

  <img alt="GitHub last commit" src="https://img.shields.io/github/last-commit/eltonlazzarin/monorepo">

  <img alt="GitHub issues" src="https://img.shields.io/github/issues/eltonlazzarin/monorepo">

  <img alt="GitHub" src="https://img.shields.io/github/license/eltonlazzarin/monorepo">
</p>

<p align="center">
  <a href="#-about-the-project">About The Project</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-technologies">Technologies</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-getting-started">Getting Started</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-how-to-contribute">How To Contribute</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#-license">License</a>
</p>

## 👨🏻‍💻 About the project

<p>
In revision control systems, a monorepo is a software development strategy where code for many projects is stored in the same repository.

So, I decided to study and I created a simple monorepo folder structure.

</p>

## 🚀 Technologies

Main technologies that I used to develop this frontend app

- [Express](https://expressjs.com/)
- [Cors](https://expressjs.com/en/resources/middleware/cors.html)
- [ReactJS](https://nodejs.org/en)
- [TypeScript](https://www.typescriptlang.org)
- [Jest](https://jestjs.io/docs/en/getting-started)
- [React-Native](https://reactnative.dev/docs/getting-started)
- [Expo](https://docs.expo.io)
- [VS Code](https://code.visualstudio.com) with [ESLint](https://eslint.org/docs/user-guide/getting-started), [EditorConfig](https://marketplace.visualstudio.com/items?itemName=EditorConfig.EditorConfig) and [Prettier RC](https://github.com/prettier/prettier)

## 💻 Getting started

### Requirements

- [Node.js](https://nodejs.org/en/)
- [Yarn](https://classic.yarnpkg.com/) or [npm](https://www.npmjs.com/)

**Clone the project and access the folder**

```bash
$ git clone https://github.com/eltonlazzarin/monorepo.git

$ cd monorepo
```

**Follow the steps below**

```bash
# Install the dependencies
$ yarn i

# Run the web app
$ yarn start
```

## 🤔 How to contribute

**Follow the steps below**

```bash
# Clone your fork
$ git clone https://github.com/eltonlazzarin/monorepo.git

$ cd monorepo

# Create a branch with your feature
$ git checkout -b your-feature

# Make the commit with your changes
$ git commit -m 'feat: Your new feature'

# Send the code to your remote branch
$ git push origin your-feature
```

After your pull request is merged, you can delete your branch

## 📝 License

This project is under the MIT license. See the [LICENSE](https://github.com/eltonlazzarin/monorepo/blob/master/LICENSE) for more information.
