// Ouzel by Elviss Strazdins

#ifndef OUZEL_CORE_SETUP_H
#define OUZEL_CORE_SETUP_H

#include "Platform.h"
#if __has_include("../Config.h")
#  include "../Config.h"
#else
#  include "../DefaultConfig.h"
#endif

#ifndef OUZEL_DEVELOPER_NAME
#  error "OUZEL_DEVELOPER_NAME must be set"
#endif

#ifndef OUZEL_APPLICATION_NAME
#  error "OUZEL_APPLICATION_NAME must be set"
#endif

// OpenGL
#ifndef OUZEL_ENABLE_OPENGL
#  define OUZEL_ENABLE_OPENGL 1
#endif
#if OUZEL_SUPPORTS_OPENGL && OUZEL_ENABLE_OPENGL
#  define OUZEL_COMPILE_OPENGL 1
#endif

// Direct3D 11
#ifndef OUZEL_ENABLE_DIRECT3D11
#  define OUZEL_ENABLE_DIRECT3D11 1
#endif
#if OUZEL_SUPPORTS_DIRECT3D11 && OUZEL_ENABLE_DIRECT3D11
#  define OUZEL_COMPILE_DIRECT3D11 1
#endif

// Metal
#ifndef OUZEL_ENABLE_METAL
#  define OUZEL_ENABLE_METAL 1
#endif
#if OUZEL_SUPPORTS_METAL && OUZEL_ENABLE_METAL
#  define OUZEL_COMPILE_METAL 1
#endif

// OpenAL
#ifndef OUZEL_ENABLE_OPENAL
#  define OUZEL_ENABLE_OPENAL 1
#endif
#if OUZEL_SUPPORTS_OPENAL && OUZEL_ENABLE_OPENAL
#  define OUZEL_COMPILE_OPENAL 1
#endif

// XAudio 2
#ifndef OUZEL_ENABLE_XAUDIO2
#  define OUZEL_ENABLE_XAUDIO2 1
#endif
#if OUZEL_SUPPORTS_XAUDIO2 && OUZEL_ENABLE_XAUDIO2
#  define OUZEL_COMPILE_XAUDIO2 1
#endif

// OpenSL
#ifndef OUZEL_ENABLE_OPENSL
#  define OUZEL_ENABLE_OPENSL 1
#endif
#if OUZEL_SUPPORTS_OPENSL && OUZEL_ENABLE_OPENSL
#  define OUZEL_COMPILE_OPENSL 1
#endif

// CoreAudio
#ifndef OUZEL_ENABLE_COREAUDIO
#  define OUZEL_ENABLE_COREAUDIO 1
#endif
#if OUZEL_SUPPORTS_COREAUDIO && OUZEL_ENABLE_COREAUDIO
#  define OUZEL_COMPILE_COREAUDIO 1
#endif

// ALSA
#ifndef OUZEL_ENABLE_ALSA
#  define OUZEL_ENABLE_ALSA 1
#endif
#if OUZEL_SUPPORTS_ALSA && OUZEL_ENABLE_ALSA
#  define OUZEL_COMPILE_ALSA 1
#endif

// WASAPI
#ifndef OUZEL_ENABLE_WASAPI
#  define OUZEL_ENABLE_WASAPI 1
#endif
#if OUZEL_SUPPORTS_WASAPI && OUZEL_ENABLE_WASAPI
#  define OUZEL_COMPILE_WASAPI 1
#endif

#endif // OUZEL_CORE_SETUP_H
