[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/eliastor)

# Golang in Systems Engineering 101

## Requirements
1. [VSCode](https://code.visualstudio.com/download)
2. [installed go](https://go.dev/dl)
3. [Go plugin in VSCode](vscode:extension/golang.Go)

## Structure

This course consists of topics.
Each topic has training materials, hints, quizes and excersices.

Each quiz should be solved, and answers should be sent as replies in Issues for respective Unit or directly to me.

Each exercise should be solved, and answers should be placed to respective folder sent in Pull Request to this repository. See Unit 1 Exercise 0 for more info.

If case of any question, don't hesitate to use Issues or contact me directly.

Sync the main branch from time to time, new units and FAQs are being added.

### How to make Pull Request

1. Fork https://github.com/eliastor/course-golang-syseng-101/fork
2. Clone forked repo to your local system
3. Make a new branch
4. Make your changes
5. Push it back to your repo
6. Click the Compare & pull request button
7. Click Create pull request to open a new pull request

If the reviewers ask for changes, repeat steps 4 and 5 to add more commits to your pull request.

## Unit 1: A tour of Go

Here are basics of Go we should understand.

ETC: 7-8 hours

More on [unit folder](unit1)

## Unit 2: Concurrency

Here are basics of Go concurrency. 

ETC: 7-14 hours

More on [unit folder](unit2)

## Unit 3: First project with streams

ETC: 7-12 hours

More on [unit folder](unit3)

## Unit 4: Web Server

ETC: 7-8 hours

More on [unit folder](unit4)

## Unit 5: Errors

ETC: 4-6 hours

More on [unit folder](unit5)

## Unit 6: Contexts

ETC: 4-6 hours

More on [unit folder](unit6)

## Roadmap of further units

6. Tests
7. Metrics, logging, error handling
8. Control loops, databases and more complexity to apps
9. Pools, zero-copy, pagination, streaming.
