import { Component } from '@angular/core';
import { MatFormField, MatLabel } from '@angular/material/form-field';
import { MatInput } from '@angular/material/input';
import { MatAutocomplete, MatAutocompleteTrigger, MatOption } from '@angular/material/autocomplete';
import { FormControl, ReactiveFormsModule } from '@angular/forms';
import { map, Observable, startWith } from 'rxjs';
import { AsyncPipe } from '@angular/common';

@Component({
    selector: 'app-autocomplete-filter-example',
    imports: [
        MatFormField,
        MatInput,
        MatAutocomplete,
        MatOption,
        MatAutocompleteTrigger,
        ReactiveFormsModule,
        MatLabel,
        AsyncPipe
    ],
    templateUrl: './autocomplete-filter-example.component.html',
    styleUrl: './autocomplete-filter-example.component.scss'
})
export class AutocompleteFilterExampleComponent {
  myControl = new FormControl('');
  options: string[] = ['One', 'Two', 'Three'];
  filteredOptions: Observable<string[]>;

  ngOnInit() {
    this.filteredOptions = this.myControl.valueChanges.pipe(
      startWith(''),
      map(value => this._filter(value || '')),
    );
  }

  private _filter(value: string): string[] {
    const filterValue = value.toLowerCase();

    return this.options.filter(option => option.toLowerCase().includes(filterValue));
  }
}
