import { Component } from '@angular/core';
import { MatAutocomplete, MatAutocompleteTrigger, MatOption } from '@angular/material/autocomplete';
import { MatFormField, MatLabel } from '@angular/material/form-field';
import { MatInput } from '@angular/material/input';
import { AsyncPipe } from '@angular/common';
import { map, Observable, startWith } from 'rxjs';
import { FormControl, ReactiveFormsModule } from '@angular/forms';

@Component({
    selector: 'app-auto-highlight-first-person-example',
    imports: [
        MatAutocomplete,
        MatOption,
        MatFormField,
        MatInput,
        MatAutocompleteTrigger,
        AsyncPipe,
        MatLabel,
        ReactiveFormsModule
    ],
    templateUrl: './auto-highlight-first-person-example.component.html',
    styleUrl: './auto-highlight-first-person-example.component.scss'
})
export class AutoHighlightFirstPersonExampleComponent {
  myControl = new FormControl('');
  options: string[] = ['One', 'Two', 'Three'];
  filteredOptions: Observable<string[]>;

  ngOnInit() {
    this.filteredOptions = this.myControl.valueChanges.pipe(
      startWith(''),
      map(value => this._filter(value || '')),
    );
  }

  private _filter(value: string): string[] {
    const filterValue = value.toLowerCase();

    return this.options.filter(option => option.toLowerCase().includes(filterValue));
  }
}
