# Elementar Admin

[Overview](https://elementarui.com) | [Live Demo](https://demo.elementarui.com/pages/dashboard/basic) | [Documentation](https://elementarui.com/documentation)

# Modern Angular UI Components & Admin Panel, based on [Angular Material 3](https://material.angular.io) components and [Tailwind](https://tailwindcss.com/) css framework

<a target="_blank" href="https://elementarui.com">
  <img src="https://demo.elementarui.com/assets/preview.png">
</a>

## Key features

- Based on the most popular Angular material components
- All components are designed from scratch specifically for the elementar admin
- It has a large number of components aimed at creating real projects
- Free and Open Source for personal and commercial purposes

## What's included:

- Angular 18+ & Typescript
- Tailwind 3+ & SCSS
- High resolution
- Flexibly configurable themes (3 themes included)
- Light & dark color schemes in each theme
- 50+ Angular Components

## Install

Install full project (with demo pages and examples):

```bash
npx @elementarui/elementar-cli@latest new your-project-name
```

Install minimal project (without demo pages and examples):

```bash
npx @elementarui/elementar-cli@latest new your-project-name --minimal
```

#### Start demo application
```bash
cd your-project-name
npm run start:demo
```

[Live Preview (Demo)](https://demo.elementarui.com)

### Start mono application
```bash
cd your-project-name
npm run start:mono
```

[Live Preview (Mono)](https://mono.elementarui.com)

### Start dual tier application
```bash
cd your-project-name
npm run start:dual-tier
```

[Live Preview (Dual Tier)](https://dual-tier.elementarui.com)

### Start minimal application
```bash
cd your-project-name
npm run start
```

[Live Preview (Minimal)](https://minimal.elementarui.com)

## Update

To update your project, run next command:

```bash
cd your-project-name
npx @elementarui/elementar-cli@latest update
```

By default, update command will update only `projects/components` folder and root `package.json`, but if you
want to update all projects like demo, dual-tier, mono layout, you can do this with command:

```bash
cd your-project-name
npx @elementarui/elementar-cli@latest update all
```
