/*
 * WHAT IS THIS FILE?
 *
 * It's the bundle entry point for `npm run preview`.
 * That is, serving your app built in production mode.
 *
 * Feel free to modify this file, but don't remove it!
 *
 * Learn more about Vite's preview command:
 * - https://vitejs.dev/config/preview-options.html#preview-options
 *
 */
import { createQwikCity } from "@builder.io/qwik-city/middleware/node";
import qwikCityPlan from "@qwik-city-plan";
import render from "./entry.ssr";

/**
 * The default export is the QwikCity adapter used by Vite preview.
 */
// some fixes for ssr-benchmark
export async function handler(req: any, res: any, next = () => res.end()) {
  if (!req.connection) {
    req.connection = {
      encrypted: false,
    };
  }
  const app = createQwikCity({ render, qwikCityPlan });
  return await app.router(req, res, next);
}

export default handler;