<img width='500px' src='http://i.imgur.com/pa4vzNh.png'>

As much as this series is to educate aspiring computer programmers and data scientists of all ages and all backgrounds, it is also a reminder to myself. After playing with computers and numbers for nearly 4 decades, I've also made this to keep in mind how to have fun with computers and maths.

Using Jupyter notebooks as an interactive learning medium, this series provides an introduction to:

- Computer Science
- Python programming language
- Numerical computing
- Numbers theory
- Prime numbers
- Data visualization
- Deep learning

#### Interactive in Mybinder:

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/mikkokotila/jupyter4kids/master?filepath=notebooks)

#### Interative in Azure (requires logging in):

<a href="https://notebooks.azure.com/import/gh/mikkokotila/jupyter4kids"><img src="https://notebooks.azure.com/launch.png" /></a>

#### Static in Nbviewer:

Use the link provided for each part below the corresponding title.

#### Launch in Binder (no login required)

Click the badge in the corresponding part below.

## Part 1 : Introduction

Start learning [here](https://nbviewer.jupyter.org/github/mikkokotila/jupyter4kids/blob/master/notebooks/numerical-computing-is-fun-1.ipynb) or 

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/mikkokotila/jupyter4kids/master?filepath=%2Fnotebooks%2Fnumerical-computing-is-fun-1.ipynb)

What you will learn:

- <code>print</code> is the command to print something on the screen
- Math operations are very easy to perform in Python
- Python deals with numbers based on data types
- In Python there are two numerical data types; int and float
- Functions are powerful tools to easily perform various operations
- Functions may accept arguments (parameters) as input
- Functions are computer processes, and arguments are what is being processed
- It's very easy to create your own functions

## Part 2 : Prime Numbers

Continue learning [here](https://nbviewer.jupyter.org/github/mikkokotila/jupyter4kids/blob/master/notebooks/numerical-computing-is-fun-2.ipynb). 

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/mikkokotila/jupyter4kids/master?filepath=%2Fnotebooks%2Fnumerical-computing-is-fun-2.ipynb)

What you will learn:

- Prime numbers relate with divisibility
- Divisibility means that when one number is divided by other, the product is not a whole number
- A prime number is any number that is divisible only by itself and 1
- Binary means 0 and 1
- Boolean logic is the binary language of computers
- Python gives us an easy to use way to instruct computers
- Boolean logic statements involve <code>is</code>, <code>is not</code>, <code>and</code> and <code>or</code> statements
- Boolean statements can be joined together
- Boolean statements always return either True or False as output
- It's easy to perform computing operations with small numbers
- The biggest prime number is a really big number
- Very big numbers require vast networks of computers joined together

## Part 3 : Algorithms Overview

Continue learning [here](https://nbviewer.jupyter.org/github/mikkokotila/jupyter4kids/blob/master/notebooks/numerical-computing-is-fun-3.ipynb).

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/mikkokotila/jupyter4kids/master?filepath=%2Fnotebooks%2Fnumerical-computing-is-fun-3.ipynb)

What you will learn: 

- Algoritms are like insides of factories 
- Algoritms process inputs to produce outputs
- Conditional statements are a tool for putting boolean logic in to action
- Conditional statements are part of "flow control"
- Flow controls give us the ability to create rules for computer programs
- The three conditional statements in Python are <code>if</code>, <code>else</code> and <code>elif</code>
- Even just <code>if</code> alone can be used to create a conditional statement

## Part 4: Automation Overview

Continue learning [here](https://nbviewer.jupyter.org/github/mikkokotila/jupyter4kids/blob/master/notebooks/numerical-computing-is-fun-4.ipynb).

[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/mikkokotila/jupyter4kids/master?filepath=%2Fnotebooks%2Fnumerical-computing-is-fun-4.ipynb)

What you will learn: 

- Generally speaking computer programs are focused on process automation
- Loops are a highly effective method for automation
- With small changes to our code, we can make big improvements in capability
- Sometimes we can get more done with less code!
- It's very convinient to store values in to memory
- Computer memory is nothing like human memory, and also not like a safe deposit box
- Any value can be stored in to memory 
- Numbers can be automatically generated with <code>range</code> function
- It's meaningful to learn new concepts by gradually improving things

<hr>

## CREDITS 

**Numerical Computing is Fun** is an [Eka Foundation](http://eka.to) project.
