const data = [
    { glyph: "a", lsb: 80, rsb: 75, lsbType: "ROUND", rsbType: "FLAT" },
    { glyph: "b", lsb: 75, rsb: 39, lsbType: "FLAT", rsbType: "ROUND" },
    { glyph: "c", lsb: 69, rsb: 67, lsbType: "ROUND", rsbType: "ROUND" },
    { glyph: "d", lsb: 49, rsb: 78, lsbType: "ROUND", rsbType: "FLAT" },
    { glyph: "e", lsb: 68, rsb: 67, lsbType: "ROUND", rsbType: "ROUND" },
    { glyph: "f", lsb: 75, rsb: 80, lsbType: "EDGE", rsbType: "EDGE" },
    { glyph: "g", lsb: 66, rsb: 51, lsbType: "ROUND", rsbType: "ROUND" },
    { glyph: "h", lsb: 95, rsb: 85, lsbType: "FLAT", rsbType: "FLAT" },
    { glyph: "i", lsb: 100, rsb: 80, lsbType: "EDGE", rsbType: "EDGE" },
    { glyph: "j", lsb: 125, rsb: 170, lsbType: "EDGE", rsbType: "FLAT" },
    { glyph: "k", lsb: 80, rsb: 40, lsbType: "FLAT", rsbType: "SHARP" },
    { glyph: "l", lsb: 75, rsb: 75, lsbType: "EDGE", rsbType: "EDGE" },
    { glyph: "m", lsb: 42, rsb: 37, lsbType: "FLAT", rsbType: "FLAT" },
    { glyph: "n", lsb: 95, rsb: 85, lsbType: "FLAT", rsbType: "FLAT" },
    { glyph: "o", lsb: 57, rsb: 57, lsbType: "ROUND", rsbType: "ROUND" },
    { glyph: "p", lsb: 75, rsb: 39, lsbType: "FLAT", rsbType: "ROUND" },
    { glyph: "q", lsb: 39, rsb: 75, lsbType: "ROUND", rsbType: "FLAT" },
    { glyph: "r", lsb: 130, rsb: 50, lsbType: "FLAT", rsbType: "SHARP" },
    { glyph: "s", lsb: 82, rsb: 92, lsbType: "ROUND", rsbType: "ROUND" },
    { glyph: "t", lsb: 70, rsb: 85, lsbType: "EDGE", rsbType: "EDGE" },
    { glyph: "u", lsb: 87, rsb: 86, lsbType: "FLAT", rsbType: "FLAT" },
    { glyph: "v", lsb: 60, rsb: 60, lsbType: "SHARP", rsbType: "SHARP" },
    { glyph: "w", lsb: 10, rsb: 10, lsbType: "SHARP", rsbType: "SHARP" },
    { glyph: "x", lsb: 47, rsb: 47, lsbType: "SHARP", rsbType: "SHARP" },
    { glyph: "y", lsb: 50, rsb: 55, lsbType: "SHARP", rsbType: "SHARP" },
    { glyph: "z", lsb: 95, rsb: 85, lsbType: "EDGE", rsbType: "EDGE" },
]
const breakpoints = [100, 50, 0]
const typeValues = { FLAT: 60, ROUND: 30, EDGE: 20, SHARP: 0 }
const findGroup = (sb, sbType) => {
    const weightedValue = sb + typeValues[sbType]
    return weightedValue > breakpoints[0]
        ? "0"
        : weightedValue > breakpoints[1]
        ? "1"
        : weightedValue > breakpoints[2]
        ? "2"
        : "3"
}

const dataGroup = [
    ...data.map((letter) => `LSB${findGroup(letter.lsb, letter.lsbType)}`),
    ...data.map((letter) => `RSB${findGroup(letter.rsb, letter.rsbType)}`),
]

// console.log(dataGroup)

const words = [
    "Abbreviation",
    "Abbreviatory",
    "Aberrational",
    "Abirritation",
    "Abirritative",
    "Abjectedness",
    "Abnormalness",
    "Abolitionary",
    "Abolitionise",
    "Abolitionism",
    "Abolitionist",
    "Abolitionize",
    "Abortiveness",
    "Abrasiveness",
    "Absoluteness",
    "Absolutistic",
    "Absorbedness",
    "Absorptivity",
    "Absquatulate",
    "Abstractness",
    "Abstruseness",
    "Acanthaceous",
    "Acaulescence",
    "Acceleration",
    "Accelerative",
    "Acceleratory",
    "Accelerogram",
    "Accentuality",
    "Accentuation",
    "Acciaccatura",
    "Acciaccature",
    "Acclimatable",
    "Accommodable",
    "Accommodator",
    "Accompanyist",
    "Accomplisher",
    "Accordionist",
    "Accouchement",
    "Accouplement",
    "Accouterment",
    "Accreditable",
    "Accretionary",
    "Accumulation",
    "Accumulative",
    "Accurateness",
    "Accursedness",
    "Accusatorial",
    "Acenesthesia",
    "Acetaldehyde",
    "Acetonitrile",
    "Acetophenone",
    "Acetostearin",
    "Achlamydeous",
    "Achromatopia",
    "Achromatopsy",
    "Acidophilous",
    "Acknowledger",
    "Acoelomatous",
    "Acoustimeter",
    "Acoustooptic",
    "Acquaintance",
    "Acquiescence",
    "Acritarchous",
    "Acrocephalia",
    "Acrocephalic",
    "Acrocyanosis",
    "Acrodontisms",
    "Acrophonetic",
    "Actinography",
    "Actinometric",
    "Actinomorphy",
    "Actinomycete",
    "Adaptability",
    "Adaptational",
    "Adaptiveness",
    "Addictedness",
    "Adenological",
    "Adenosarcoma",
    "Adequateness",
    "Adhesiveness",
    "Adiaphoresis",
    "Adiponitrile",
    "Adjudication",
    "Adjudicative",
    "Adjudicatory",
    "Adminiculary",
    "Administrant",
    "Administrate",
    "Admirability",
    "Admonishment",
    "Adoptability",
    "Adorableness",
    "Adscititious",
    "Adularescent",
    "Adulteration",
    "Advantageous",
    "Adventitious",
    "Adventureful",
    "Advertisable",
    "Advisability",
    "Aelurophilia",
    "Aelurophilic",
    "Aelurophobia",
    "Aerification",
    "Aeroembolism",
    "Aeromagnetic",
    "Aeromechanic",
    "Aeromedicine",
    "Aeronautical",
    "Aerostatical",
    "Aesthetician",
    "Aestheticise",
    "Aestheticism",
    "Aestheticize",
    "Aetiological",
    "Affectedness",
    "Affectionate",
    "Afforestment",
    "Affrications",
    "Aforethought",
    "Afterthought",
    "Agamogenesis",
    "Agamogenetic",
    "Agaricaceous",
    "Agglomerator",
    "Agglutinable",
    "Agglutinogen",
    "Aggressivity",
    "Aggrievement",
    "Agoraphobiac",
    "Agreeability",
    "Agribusiness",
    "Agrichemical",
    "Agricultural",
    "Agrobacteria",
    "Agrobiologic",
    "Agrobusiness",
    "Agrochemical",
    "Agroforestry",
    "Agrostologic",
    "Ailurophilia",
    "Ailurophilic",
    "Ailurophobia",
    "Ailurophobic",
    "Aircraftsman",
    "Airtightness",
    "Albuminoidal",
    "Alcoholicity",
    "Aldermanship",
    "Alethiologic",
    "Alexipharmic",
    "Algesiometer",
    "Algometrical",
    "Alienability",
    "Alimentation",
    "Alimentative",
    "Alkahestical",
    "Alkalescence",
    "Alkalifiable",
    "Alkalimetric",
    "Alkalization",
    "Alkaptonuria",
    "Allegoristic",
    "Allelopathic",
    "Alliteration",
    "Alliterative",
    "Alliumphobia",
    "Alloantibody",
    "Allomorphism",
    "Allotropical",
    "Alluringness",
    "Allusiveness",
    "Almightiness",
    "Alphabetical",
    "Bacchanalian",
    "Bachelorette",
    "Bachelorhood",
    "Bachelorlike",
    "Backboneless",
    "Backcourtman",
    "Backgrounder",
    "Backpressure",
    "Backswordman",
    "Backwardness",
    "Backwoodsman",
    "Bactericidal",
    "Bacterioidal",
    "Bacteriology",
    "Bacteriostat",
    "Bafflegabber",
    "Bafflingness",
    "Balistrariae",
    "Balladmonger",
    "Balletomania",
    "Ballistician",
    "Ballottement",
    "Balneologist",
    "Balsamaceous",
    "Baluchithere",
    "Banderillero",
    "Bandersnatch",
    "Bandoneonist",
    "Bantamweight",
    "Barbarianism",
    "Bardolatrous",
    "Bariatrician",
    "Baroreceptor",
    "Baroscopical",
    "Barristerial",
    "Basidiospore",
    "Basification",
    "Bathypelagic",
    "Battleground",
    "Battological",
    "Bearableness",
    "Becomingness",
    "Bedazzlement",
    "Befuddlement",
    "Beggarliness",
    "Belittlement",
    "Belletristic",
    "Belligerence",
    "Belligerency",
    "Benefactress",
    "Benumbedness",
    "Benzaldehyde",
    "Benzonitrile",
    "Benzophenone",
    "Benzoylation",
    "Bequeathable",
    "Bequeathment",
    "Besottedness",
    "Betweenbrain",
    "Bewilderment",
    "Biauriculate",
    "Bibliography",
    "Bibliologist",
    "Bibliomaniac",
    "Bibliopegist",
    "Bibliophagic",
    "Bibliophilic",
    "Bibliophobia",
    "Bibliopolism",
    "Bibliopolist",
    "Bibliothecae",
    "Bibliothecal",
    "Bibliotheque",
    "Bibulousness",
    "Bicameralism",
    "Bicameralist",
    "Bicentennial",
    "Bicollateral",
    "Biddableness",
    "Bidialectism",
    "Biflagellate",
    "Bifunctional",
    "Bilateralism",
    "Bilingualism",
    "Biliteralism",
    "Billingsgate",
    "Bimillennial",
    "Bimillennium",
    "Binocularity",
    "Bioautograph",
    "Bioavailable",
    "Biochemistry",
    "Biocoenology",
    "Biocorrosion",
    "Biodiversity",
    "Bioecologist",
    "Bioflavonoid",
    "Biogenetical",
    "Biogeography",
    "Biographical",
    "Bioinorganic",
    "Biomagnetism",
    "Biometrician",
    "Biophysicist",
    "Biopsychical",
    "Biorhythmist",
    "Bioscientist",
    "Biosociology",
    "Biosynthesis",
    "Biosynthetic",
    "Biotechnical",
    "Biotelemetry",
    "Bioterrorism",
    "Bioterrorist",
    "Bioturbation",
    "Bipropellant",
    "Birefringent",
    "Bismuthinite",
    "Biuniqueness",
    "Blabbermouth",
    "Blackishness",
    "Blamefulness",
    "Blandishment",
    "Blastocoelic",
    "Blastodermic",
    "Blastomycete",
    "Blastosphere",
    "Blastostylar",
    "Blastulation",
    "Blockheadism",
    "Blockishness",
    "Bloodcurdler",
    "Bloodthirsty",
    "Bloomingness",
    "Blushfulness",
    "Cabinetmaker",
    "Cachinnation",
    "Cachinnatory",
    "Cacodaemonic",
    "Cacodemoniac",
    "Calabrasella",
    "Calciphilous",
    "Calciphobous",
    "Caliginosity",
    "Calligrapher",
    "Calligraphic",
    "Callisthenic",
    "Calorescence",
    "Calorimetric",
    "Calumniation",
    "Calumniatory",
    "Cameralistic",
    "Cameraperson",
    "Canaliculate",
    "Canalization",
    "Cancellation",
    "Candleholder",
    "Cankeredness",
    "Canonization",
    "Canorousness",
    "Cantankerous",
    "Cantillation",
    "Capacitation",
    "Capacitative",
    "Capercaillie",
    "Capillaceous",
    "Capitalistic",
    "Capitulation",
    "Capitulatory",
    "Caponization",
    "Captiousness",
    "Caravanserai",
    "Carbamylurea",
    "Carbocholine",
    "Carbohydrase",
    "Carbohydrate",
    "Carbonaceous",
    "Carcinogenic",
    "Cardinalfish",
    "Cardinalship",
    "Cardioactive",
    "Cardiography",
    "Cardiologist",
    "Cardiophobia",
    "Cardioplegia",
    "Cyclopaedist",
    "Cyclopentane",
    "Cyclopropane",
    "Cyclosporine",
    "Cylinderlike",
    "Cymotrichous",
    "Cytoanalyzer",
    "Cytochemical",
    "Cytomembrane",
    "Cytoskeletal",
    "Cytoskeleton",
    "Cytotaxonomy",
    "Cytotoxicity",
    "Curanderismo",
    "Curarization",
    "Customizable",
    "Customshouse",
    "Cutinization",
    "Cyanogenesis",
    "Cyanogenetic",
    "Cyberculture",
    "Cybernetical",
    "Cyberstalker",
    "Cyberwarfare",
    "Cyclandelate",
    "Cyclogenesis",
    "Criticalness",
    "Criticizable",
    "Crossability",
    "Crosscurrent",
    "Crossdresser",
    "Cruciformity",
    "Crushability",
    "Cryoplankton",
    "Cryopreserve",
    "Cryosurgical",
    "Cryptanalyst",
    "Cryptococcal",
    "Cryptococcus",
    "Craveability",
    "Creativeness",
    "Credibleness",
    "Creditorship",
    "Creditworthy",
    "Cremasterial",
    "Cremationist",
    "Crenellation",
    "Creolization",
    "Criminogenic",
    "Cringeworthy",
    "Cringingness",
    "Counteroffer",
    "Counterorder",
    "Counterparty",
    "Counterpoint",
    "Counterpoise",
    "Counterpunch",
    "Counterscarp",
    "Countershaft",
    "Counterstain",
    "Countertenor",
    "Countertrade",
    "Countertrend",
    "Contaminator",
    "Contemplable",
    "Contemplator",
    "Contemporary",
    "Contemporise",
    "Contemptible",
    "Contemptuous",
    "Conterminous",
    "Contestation",
    "Continuation",
    "Continuative",
    "Contortional",
    "Contractible",
    "Circumocular",
    "Circumrotate",
    "Circumscribe",
    "Circumscript",
    "Circumstance",
    "Circumventor",
    "Citification",
    "Citriculture",
    "Civilization",
    "Cladocarpous",
    "Cladogenesis",
    "Cladogenetic",
    "Clairaudient",
    "Clairvoyance",
    "Clankingness",
    "Clannishness",
    "Classicalism",
    "Chromatogram",
    "Chromatology",
    "Chromocenter",
    "Chromonemata",
    "Chromophilia",
    "Chromophilic",
    "Chromophobic",
    "Chromophoric",
    "Chromosphere",
    "Chronography",
    "Chronologist",
    "Chronologize",
    "Chronometric",
    "Chronotropic",
    "Chrysography",
    "Churchliness",
    "Churchwarden",
    "Churlishness",
    "Churnability",
    "Chylocaulous",
    "Chymotrypsin",
    "Chymotryptic",
    "Cinchonidine",
    "Cinematheque",
    "Circularness",
    "Circulatable",
    "Circumcenter",
    "Circumcircle",
    "Circumcision",
    "Circumfluent",
    "Circumfusion",
    "Circumjacent",
    "Celestiality",
    "Cellarmaster",
    "Cellulolytic",
    "Cementitious",
    "Centillionth",
    "Centralistic",
    "Centrifugate",
    "Centrosphere",
    "Centuplicate",
    "Cephalometer",
    "Cephalometry",
    "Cephalopodic",
    "Dactinomycin",
    "Dactyloscopy",
    "Danceability",
    "Daredeviltry",
    "Darksomeness",
    "Darmstadtium",
    "Dasyphyllous",
    "Dateableness",
    "Daughterless",
    "Daughterlike",
    "Dauntingness",
    "Deaccelerate",
    "Dealcoholize",
    "Deallocation",
    "Deambulatory",
    "Deannexation",
    "Debaucherous",
    "Debilitation",
    "Debilitative",
    "Debonairness",
    "Debrouillard",
    "Decaffeinate",
    "Decalcomania",
    "Decalescence",
    "Decapitalize",
    "Decapitation",
    "Droughtiness",
    "Dumbstricken",
    "Dumortierite",
    "Duodecillion",
    "Duplicatable",
    "Dwarfishness",
    "Dynamization",
    "Dynamogenous",
    "Dynamometric",
    "Dysaesthetic",
    "Dysanagnosia",
    "Dysautonomia",
    "Dysmenorrhea",
    "Dysphemistic",
    "Dysteleology",
    "Doubtfulness",
    "Doubtingness",
    "Downcastness",
    "Draftsperson",
    "Dramatherapy",
    "Dramatizable",
    "Drapeability",
    "Draughtboard",
    "Draughtiness",
    "Drawlingness",
    "Dreadfulness",
    "Dreamfulness",
    "Drillability",
    "Drinkability",
    "Driveability",
    "Documentable",
    "Docutainment",
    "Dodecahedral",
    "Dodecahedron",
    "Dodecaphonic",
    "Dolorimetric",
    "Dolorousness",
    "Domesticable",
    "Domesticator",
    "Dopaminergic",
    "Doppelganger",
    "Dorsiflexion",
    "Dorsiventral",
    "Dorsolateral",
    "Dorsoventral",
    "Doubleganger",
    "Doubleheader",
    "Distributism",
    "Distributist",
    "Distributive",
    "Ditheistical",
    "Ditransitive",
    "Ditriglyphic",
    "Divarication",
    "Diversionary",
    "Diversionist",
    "Diverticular",
    "Diverticulum",
    "Divertimenti",
    "Divertimento",
    "Divinization",
    "Divisibility",
    "Divisiveness",
    "Disinvention",
    "Dislodgement",
    "Dismayedness",
    "Dismountable",
    "Disobedience",
    "Disopyramide",
    "Disorientate",
    "Dispensation",
    "Dichromatism",
    "Dictatorship",
    "Diencephalic",
    "Diencephalon",
    "Differentiae",
    "Differential",
    "Diffusionism",
    "Diffusionist",
    "Digestedness",
    "Digitization",
    "Digressional",
    "Dilaceration",
    "Dilapidation",
    "Dextrocardia",
    "Dextrorotary",
    "Dextrousness",
    "Diageotropic",
    "Diagrammable",
    "Diagrammatic",
    "Dialectician",
    "Dialecticism",
    "Dialectology",
    "Diamagnetism",
    "Diapophysial",
    "Diarthrodial",
    "Diastereomer",
    "Diastrophism",
    "Diatessarial",
    "Diathermancy",
    "Diatomaceous",
    "Diazomethane",
    "Diazotizable",
    "Dibranchiate",
    "Dichlorbenil",
    "Detonability",
    "Detoxication",
    "Detruncation",
    "Detumescence",
    "Deuteranopia",
    "Deuteranopic",
    "Deuterostome",
    "Deutoplasmic",
    "Deviationism",
    "Deviationist",
    "Devilishness",
    "Depoliticize",
    "Depolymerize",
    "Depopularize",
    "Depopulation",
    "Depopulative",
    "Depositional",
    "Depravedness",
    "Depreciation",
    "Depreciative",
    "Depreciatory",
    "Deprogrammer",
    "Deputization",
    "Deracination",
    "Denizenation",
    "Denomination",
    "Denominative",
    "Denouncement",
    "Densitometer",
    "Densitometry",
    "Dentilingual",
    "Dentirostral",
    "Denuclearise",
    "Denudational",
    "Denunciation",
    "Denunciative",
    "Denunciatory",
    "Deontologist",
    "Deoxymannose",
    "Departmental",
    "Easterliness",
    "Eavesdropper",
    "Eccentricity",
    "Ecclesiastic",
    "Ecclesiology",
    "Echolocation",
    "Ecogeography",
    "Econometrist",
    "Ecoterrorism",
    "Ecoterrorist",
    "Ectoparasite",
    "Editorialist",
    "Educationese",
    "Edulcoration",
    "Edulcorative",
    "Effectuality",
    "Effectuation",
    "Effervescent",
    "Efflorescent",
    "Effusiveness",
    "Ehrlichiosis",
    "Eisteddfodau",
    "Eisteddfodic",
    "Elaeothesium",
    "Elasmobranch",
    "Elliptograph",
    "Elocutionary",
    "Eloquentness",
    "Elucubration",
    "Emancipation",
    "Emancipative",
    "Emargination",
    "Emasculation",
    "Emasculatory",
    "Embattlement",
    "Embezzlement",
    "Embitterment",
    "Emblazonment",
    "Emblematical",
    "Embolization",
    "Embranchment",
    "Embroideress",
    "Encipherment",
    "Encirclement",
    "Encroachment",
    "Encrustation",
    "Encyclopedia",
    "Encyclopedic",
    "Endangerment",
    "Endomembrane",
    "Endomorphism",
    "Endonuclease",
    "Endoparasite",
    "Entrenchment",
    "Entrepreneur",
    "Enviableness",
    "Envisagement",
    "Eosinophilia",
    "Eosinophilic",
    "Epencephalic",
    "Epencephalon",
    "Epexegetical",
    "Ephemerality",
    "Epicondylian",
    "Epicureanism",
    "Epicycloidal",
    "Epidemiology",
    "Epigrammatic",
    "Epigraphical",
    "Epimyocardia",
    "Epiphenomena",
    "Episcopalian",
    "Epistemology",
    "Episyllogism",
    "Epithalamion",
    "Epithalamium",
    "Epitrachelia",
    "Equalitarian",
    "Equalization",
    "Equatability",
    "Equestrienne",
    "Equilibrator",
    "Equipollence",
    "Equipollency",
    "Equiprobable",
    "Equitability",
    "Equivocality",
    "Equivocation",
    "Eremophilous",
    "Ergonometric",
    "Eriophyllous",
    "Erythematous",
    "Erythroblast",
    "Erythrocytic",
    "Espagnolette",
    "Essentialism",
    "Essentiality",
    "Esterifiable",
    "Estrangement",
    "Eternization",
    "Ethanolamine",
    "Etherealness",
    "Etherization",
    "Ethnobiology",
    "Ethnocentric",
    "Ethnographer",
    "Ethnographic",
    "Ethnological",
    "Ethnoscience",
    "Ethosuximide",
    "Ethylbenzene",
    "Ethynylation",
    "Etymological",
    "Euchromosome",
    "Eudemonistic",
    "Euglenophyte",
    "Euhemeristic",
    "Eulogistical",
    "Eulogization",
    "Eunuchoidism",
    "Euphorigenic",
    "Euphuistical",
    "Eurytopicity",
    "Evangelistic",
    "Eventfulness",
    "Everydayness",
    "Evisceration",
    "Evolutionary",
    "Evolutionism",
    "Exacerbation",
    "Exactingness",
    "Exaggeration",
    "Exaggerative",
    "Exaggeratory",
    "Exasperation",
    "Exchangeable",
    "Excitability",
    "Exclusionary",
    "Exclusionism",
    "Excogitation",
    "Excogitative",
    "Excrementous",
    "Excruciation",
    "Excubitorium",
    "Executorship",
    "Exenteration",
    "Exercitation",
    "Exfiltration",
    "Fabulousness",
    "Facelessness",
    "Facilitation",
    "Facilitative",
    "Factionalism",
    "Factionalist",
    "Factionalize",
    "Factiousness",
    "Faintishness",
    "Faithfulness",
    "Fallibleness",
    "Familiarness",
    "Fancifulness",
    "Faradization",
    "Farcicalness",
    "Fatherliness",
    "Fatigability",
    "Fearlessness",
    "Fearsomeness",
    "Feasibleness",
    "Featherbrain",
    "Featheriness",
    "Featherlight",
    "Febrifacient",
    "Fecklessness",
    "Feldspathoid",
    "Feldspathose",
    "Felicitation",
    "Feminization",
    "Feminophobia",
    "Fenestration",
    "Fenfluramine",
    "Fennelflower",
    "Fermentation",
    "Fermentative",
    "Ferricyanide",
    "Ferrocyanide",
    "Ferrosilicon",
    "Fertilizable",
    "Fiberization",
    "Fibrillation",
    "Fibrilliform",
    "Fibrinogenic",
    "Fibrinolysin",
    "Fibrinolytic",
    "Fibroadenoma",
    "Fibroblastic",
    "Fibromyalgia",
    "Fibrosarcoma",
    "Fiendishness",
    "Finalization",
    "Fingerflower",
    "Fissipalmate",
    "Fissirostral",
    "Fitspiration",
    "Flabelliform",
    "Flagellation",
    "Flagellatory",
    "Flagelliform",
    "Flagrantness",
    "Flamethrower",
    "Flammability",
    "Flannelboard",
    "Flannelmouth",
    "Flavoprotein",
    "Flexographic",
    "Flightworthy",
    "Flirtability",
    "Flittermouse",
    "Flocculation",
    "Floriculture",
    "Flowerpecker",
    "Fluidization",
    "Fluorapatite",
    "Fluoresceine",
    "Fluorescence",
    "Fluoridation",
    "Fluorination",
    "Fluorocarbon",
    "Fluorochrome",
    "Fluorography",
    "Fluorometric",
    "Fluoroscopic",
    "Fluorouracil",
    "Fluosilicate",
    "Fluphenazine",
    "Flutterboard",
    "Fluviomarine",
    "Focalization",
    "Folkloristic",
    "Followership",
    "Footsoreness",
    "Foraminifera",
    "Foreclosable",
    "Foregoneness",
    "Foreknowable",
    "Foreordinate",
    "Forepleasure",
    "Foresightful",
    "Forestalment",
    "Forestaysail",
    "Formaldehyde",
    "Formlessness",
    "Forsakenness",
    "Forswornness",
    "Fosphenytoin",
    "Fossilizable",
    "Foundational",
    "Fountainhead",
    "Fountainless",
    "Fountainlike",
    "Fragrantness",
    "Framableness",
    "Franchisable",
    "Francization",
    "Frangibility",
    "Frankincense",
    "Fraternalism",
    "Freezability",
    "Freightliner",
    "Frequentable",
    "Frequentness",
    "Freshmanship",
    "Frictionless",
    "Friendliness",
    "Frightenable",
    "Frondescence",
    "Frontierless",
    "Frontierlike",
    "Frontiersman",
    "Frontispiece",
    "Fructiferous",
    "Fruitfulness",
    "Fugitiveness",
    "Fumblingness",
    "Furazolidone",
    "Furfuraceous",
    "Furocoumarin",
    "Fusobacteria",
    "Futilitarian",
    "Gainlessness",
    "Galactometer",
    "Galactometry",
    "Galactorrhea",
    "Galactoscope",
    "Galactosemia",
    "Galactosemic",
    "Galvanometer",
    "Galvanometry",
    "Galvanoscope",
    "Galvanoscopy",
    "Galvanotaxis",
    "Gamesmanship",
    "Gamesomeness",
    "Gametogenous",
    "Gametophoric",
    "Gametophytic",
    "Gamification",
    "Gamopetalous",
    "Gamophyllous",
    "Gamosepalous",
    "Gasification",
    "Gasolineless",
    "Gastightness",
    "Gastrocnemii",
    "Gastrodermal",
    "Gastroplasty",
    "Gastropodous",
    "Gastroscopic",
    "Gastrulation",
    "Geanticlinal",
    "Gelatination",
    "Gemeinschaft",
    "Gemmological",
    "Genealogical",
    "Generational",
    "Generousness",
    "Geniculation",
    "Gentlepeople",
    "Gentleperson",
    "Genuflection",
    "Geobotanical",
    "Geochemistry",
    "Geodynamical",
    "Geognostical",
    "Geographical",
    "Geohydrology",
    "Geomagnetism",
    "Geometrician",
    "Geophysicist",
    "Geopolitical",
    "Geopotential",
    "Geoscientist",
    "Geosynclinal",
    "Geotechnical",
    "Geraniaceous",
    "Geratologous",
    "Geriatrician",
    "Gerontocracy",
    "Gerontogeous",
    "Gersdorffite",
    "Gesellschaft",
    "Gesticulator",
    "Ghoulishness",
    "Gingerbready",
    "Gingerliness",
    "Gingivectomy",
    "Glaciologist",
    "Gladiatorial",
    "Gladsomeness",
    "Glaucomatous",
    "Gleesomeness",
    "Globetrotter",
    "Globularness",
    "Glockenspiel",
    "Glossatorial",
    "Glossography",
    "Glossolalist",
    "Glutethimide",
    "Glycogenetic",
    "Glycopeptide",
    "Glycoprotein",
    "Glyptography",
    "Gnomological",
    "Gobbledegook",
    "Gobbledygook",
    "Goldendoodle",
    "Gonadotropic",
    "Gonadotropin",
    "Gossipmonger",
    "Governmental",
    "Governorship",
    "Gracefulness",
    "Graciousness",
    "Gradeability",
    "Gradeflation",
    "Gradualistic",
    "Graininesses",
    "Grallatorial",
    "Grammatology",
    "Granuloblast",
    "Granulocytic",
    "Graphophonic",
    "Graspingness",
    "Gravicembali",
    "Gravicembalo",
    "Grayanotoxin",
    "Greengrocery",
    "Greenhornism",
    "Greenskeeper",
    "Grievousness",
    "Griffinesque",
    "Grindability",
    "Grippingness",
    "Griseofulvin",
    "Grossularite",
    "Grotesquerie",
    "Groundedness",
    "Groundkeeper",
    "Guanethidine",
    "Guardianless",
    "Guardianship",
    "Gubernacular",
    "Gubernaculum",
    "Guidebookish",
    "Guilefulness",
    "Gumptionless",
    "Gutturalness",
    "Gutturonasal",
    "Gymnasiarchy",
    "Gymnocarpous",
    "Gymnospermal",
    "Gymnosporous",
    "Gynantherous",
    "Gynecocratic",
    "Gynecomastia",
    "Gynecopathic",
    "Gynodioecism",
    "Gypsophilous",
    "Gyromagnetic",
    "Haberdashery",
    "Habilimental",
    "Habilitation",
    "Habilitative",
    "Habitability",
    "Habitational",
    "Habitualness",
    "Hadrosaurian",
    "Hagiographer",
    "Hagiographic",
    "Hagiolatrous",
    "Hagiological",
    "Hairlessness",
    "Hairsbreadth",
    "Hairsplitter",
    "Hallowedness",
    "Hallucinator",
    "Hallucinogen",
    "Halobacteria",
    "Halogenation",
    "Halotrichite",
    "Hamantaschen",
    "Hasenpfeffer",
    "Hatchability",
    "Headlongness",
    "Headshrinker",
    "Heartbreaker",
    "Heartstopper",
    "Heavenliness",
    "Hebetudinous",
    "Hamperedness",
    "Handcraftman",
    "Handkerchief",
    "Happenchance",
    "Happenstance",
    "Hardenbergia",
    "Hardscrabble",
    "Harlequinade",
    "Harmlessness",
    "Harmonizable",
    "Hemichordate",
    "Hemimorphism",
    "Hemimorphite",
    "Hemiplankton",
    "Hemispheroid",
    "Hemodialyzer",
    "Hemodilution",
    "Hemorrhoidal",
    "Henceforward",
    "Henchmanship",
    "Hendecagonal",
    "Hendecahedra",
    "Henotheistic",
    "Heptahydrate",
    "Heteromerous",
    "Heteromorphy",
    "Heteronomous",
    "Heteronymous",
    "Heterophilic",
    "Heterophonic",
    "Heterophoria",
    "Heterophoric",
    "Heteroplasia",
    "Heteroplasty",
    "Heterosexism",
    "Heterosexist",
    "Heterosexual",
    "Heterotactic",
    "Heterotopous",
    "Heterozygote",
    "Heterozygous",
    "Hexachloride",
    "Hexafluoride",
    "Hexagrammoid",
    "Hexametrical",
    "Hexasyllabic",
    "Hexasyllable",
    "Hibernaculum",
    "Hidropoietic",
    "Hierarchical",
    "Hieroglyphic",
    "Hierological",
    "Hierophantic",
    "Hippological",
    "Hippophagism",
    "Hippophagous",
    "Hippopotamic",
    "Hippopotamus",
    "Histogenetic",
    "Histographer",
    "Histological",
    "Histrionical",
    "Holidaymaker",
    "Hologonidium",
    "Holometaboly",
    "Holomorphism",
    "Holophrastic",
    "Holoplankton",
    "Holopneustic",
    "Holothurioid",
    "Homelessness",
    "Homelikeness",
    "Homeomorphic",
    "Homeoplastic",
    "Homeotherapy",
    "Homeothermal",
    "Homeschooler",
    "Homesickness",
    "Hopelessness",
    "Horribleness",
    "Horsemanship",
    "Horseplayful",
    "Horsewhipper",
    "Horticulture",
    "Housebreaker",
    "Housecleaner",
    "Househusband",
    "Housewrecker",
    "Humanitarian",
    "Humanization",
    "Humification",
    "Huntsmanship",
    "Hurtlessness",
    "Hyalographer",
    "Hyaloplasmic",
    "Hybridizable",
    "Hydatidinous",
    "Hydnocarpate",
    "Hydrargyrism",
    "Hydrastinine",
    "Hydrobiology",
    "Hypernatural",
    "Hyperorganic",
    "Hyperostotic",
    "Hyperovarism",
    "Hyperplastic",
    "Hyperpyretic",
    "Hyperpyrexia",
    "Hyperrealism",
    "Hypersensual",
    "Hypersomniac",
    "Hyperspatial",
    "Hypersplenia",
    "Hypersthenic",
    "Hyperstoical",
    "Hypersurface",
    "Hypertension",
    "Hypertensive",
    "Hyperthermal",
    "Hyperthermia",
    "Hyperthyroid",
    "Hypertrophic",
    "Ichnographic",
    "Ichnological",
    "Ichthyofauna",
    "Ichthyologic",
    "Ichthyophagy",
    "Iconoclastic",
    "Iconographer",
    "Iconographic",
    "Iconolatrous",
    "Iconological",
    "Iconophilism",
    "Idealization",
    "Identifiable",
    "Idiocratical",
    "Idiomaticity",
    "Idiosyncrasy",
    "Idoneousness",
    "Ignitability",
    "Ignitibility",
    "Illegibility",
    "Illegitimacy",
    "Illegitimate",
    "Illiberalism",
    "Illiberality",
    "Illogicality",
    "Illumination",
    "Illuminative",
    "Illusiveness",
    "Illusoriness",
    "Illustration",
    "Illustrative",
    "Imbibitional",
    "Imitableness",
    "Immatureness",
    "Immeasurable",
    "Impoliteness",
    "Imponderable",
    "Imposingness",
    "Impotentness",
    "Impregnation",
    "Impressional",
    "Imprisonable",
    "Imprisonment",
    "Improperness",
    "Improvidence",
    "Improvisator",
    "Impudentness",
    "Inaccessible",
    "Inactivation",
    "Inactiveness",
    "Inadmissible",
    "Inadvertency",
    "Inappeasable",
    "Inapplicable",
    "Inarticulate",
    "Inaudibility",
    "Inauguration",
    "Inauspicious",
    "Incalculable",
    "Incalescence",
    "Incandescent",
    "Incapability",
    "Incapacitant",
    "Incapacitate",
    "Incendiarism",
    "Industrywide",
    "Ineffability",
    "Ineffaceable",
    "Inefficiency",
    "Inelasticity",
    "Ineradicable",
    "Inexactitude",
    "Inexpedience",
    "Inexpediency",
    "Inexperience",
    "Inexpertness",
    "Inexplicable",
    "Inexpressive",
    "Inexpugnable",
    "Inexpungible",
    "Inextensible",
    "Inextirpable",
    "Inextricable",
    "Infamousness",
    "Infanticidal",
    "Inspissation",
    "Installation",
    "Instauration",
    "Instructible",
    "Instructress",
    "Instrumental",
    "Insufferable",
    "Insufficient",
    "Insufflation",
    "Insulinomata",
    "Insurability",
    "Insurrection",
    "Intellection",
    "Intellective",
    "Intellectual",
    "Interfaculty",
    "Interfemoral",
    "Interference",
    "Interfertile",
    "Interfibrous",
    "Interfluvial",
    "Interfrontal",
    "Interfulgent",
    "Intergeneric",
    "Interglacial",
    "Interhostile",
    "Interinsular",
    "Interinvolve",
    "Interjacence",
    "Interjection",
    "Interjectory",
    "Interjugular",
    "Interkinetic",
    "Interlaminar",
    "Interpretive",
    "Interproduce",
    "Interpsychic",
    "Interquarter",
    "Interrailway",
    "Interreflect",
    "Interrogable",
    "Interrogator",
    "Interruption",
    "Interruptive",
    "Interscience",
    "Intersectant",
    "Intersection",
    "Intersegment",
    "Intersensory",
    "Intersession",
    "Intersociety",
    "Interspatial",
    "Interspersal",
    "Invigoration",
    "Invisibility",
    "Invitational",
    "Invitingness",
    "Involucelate",
    "Involutional",
    "Involvedness",
    "Invulnerable",
    "Irascibility",
    "Ironicalness",
    "Irrebuttable",
    "Irredeemable",
    "Irreformable",
    "Irrefragable",
    "Irregularity",
    "Irrelievable",
    "Irremissible",
    "Irrepealable",
    "Irresistible",
    "Irresolution",
    "Irresolvable",
    "Irrespective",
    "Irrespirable",
    "Irresponsive",
    "Irreversible",
    "Irrigational",
    "Irritability",
    "Irrotational",
    "Isocephalous",
    "Isocheimenal",
    "Isochromatic",
    "Isodiametric",
    "Isodimorphic",
    "Isolationism",
    "Jaculiferous",
    "Japonaiserie",
    "Jarovization",
    "Jettisonable",
    "Jitterbugger",
    "Jointureless",
    "Journalistic",
    "Judicialness",
    "Jurisconsult",
    "Jurisdiction",
    "Jurisdictive",
    "Jurisprudent",
    "Juvenescence",
    "Kaffeeklatch",
    "Kakistocracy",
    "Kaleidoscope",
    "Kangaroolike",
    "Karmadharaya",
    "Karyokinetic",
    "Karyoplasmic",
    "Katamorphism",
    "Katzenjammer",
    "Keratodermia",
    "Keratogenous",
    "Keratometric",
    "Keratoplasty",
    "Ketoconazole",
    "Killickinnic",
    "Kinaesthesia",
    "Kinaesthetic",
    "Kindergarten",
    "Kinetoscopic",
    "Kinglessness",
    "Kinnikinnick",
    "Kirschwasser",
    "Kissableness",
    "Kleptocratic",
    "Kleptomaniac",
    "Klipspringer",
    "Knightliness",
    "Knowableness",
    "Knowledgable",
    "Labanotation",
    "Labilization",
    "Laboratorian",
    "Labyrinthian",
    "Labyrinthine",
    "Lacerability",
    "Lachrymation",
    "Lachrymatory",
    "Lachrymosity",
    "Lactobacilli",
    "Lactoprotein",
    "Ladylikeness",
    "Lagomorphous",
    "Lallapalooza",
    "Lamprophonia",
    "Lamprophonic",
    "Lamprophyric",
    "Landgraviate",
    "Landlessness",
    "Languishment",
    "Laparoscopic",
    "Laparotomist",
    "Laryngectomy",
    "Laryngoscope",
    "Laryngoscopy",
    "Laticiferous",
    "Latifundista",
    "Latitudinous",
    "Laudableness",
    "Laughterless",
    "Laundrywoman",
    "Lauraldehyde",
    "Laureateship",
    "Leachability",
    "Leatheriness",
    "Legalization",
    "Legitimation",
    "Leishmanioid",
    "Lenitiveness",
    "Lenticellate",
    "Lepidopteral",
    "Lepidopteran",
    "Lepidopteron",
    "Leptocephali",
    "Leptosomatic",
    "Leptospermum",
    "Leucocytosis",
    "Leucopoietic",
    "Leukoblastic",
    "Leukopoietic",
    "Levitational",
    "Levorotatory",
    "Lexicography",
    "Liberalistic",
    "Liberticidal",
    "Lichenologic",
    "Lifelessness",
    "Lifelikeness",
    "Likeableness",
    "Likelinesses",
    "Limnological",
    "Linguistical",
    "Liquefacient",
    "Liquefaction",
    "Liquefactive",
    "Listenership",
    "Listlessness",
    "Literalistic",
    "Lithographic",
    "Lithological",
    "Lithoprinter",
    "Lithospheric",
    "Lithotomical",
    "Lithotripter",
    "Liturgiology",
    "Liverishness",
    "Lobeliaceous",
    "Localization",
    "Locksmithery",
    "Locomobility",
    "Locomotivity",
    "Lognormality",
    "Logocentrism",
    "Logomachical",
    "Lollapalooza",
    "Lonesomeness",
    "Longicaudate",
    "Longitudinal",
    "Longshoreman",
    "Lordlinesses",
    "Loutrophoroi",
    "Lovelessness",
    "Lovesickness",
    "Lubberliness",
    "Lucklessness",
    "Lugubriosity",
    "Lukewarmness",
    "Lumbersexual",
    "Luminescence",
    "Luminiferous",
    "Luminousness",
    "Luncheonette",
    "Lusciousness",
    "Lustrousness",
    "Lycanthropic",
    "Lychnoscopic",
    "Lymphadenoma",
    "Lymphangioma",
    "Lymphography",
    "Lymphomatoid",
    "Lyricization",
    "Macrocarpous",
    "Macroclimate",
    "Macrodontism",
    "Macrographic",
    "Macromineral",
    "Macronuclear",
    "Macropterous",
    "Mademoiselle",
    "Magistrality",
    "Magistrature",
    "Magnetizable",
    "Magnetograph",
    "Magnetometer",
    "Magnetometry",
    "Magnetooptic",
    "Magnetopause",
    "Magnificence",
    "Magniloquent",
    "Maidenliness",
    "Mainstreamer",
    "Maintainable",
    "Majoritarian",
    "Malapertness",
    "Malefactress",
    "Malformation",
    "Malleability",
    "Malnutrition",
    "Malocclusion",
    "Maltodextrin",
    "Maltreatment",
    "Malversation",
    "Marcasitical",
    "Marksmanship",
    "Marlinespike",
    "Marlingspike",
    "Marriageable",
    "Marshmallowy",
    "Martyrologic",
    "Mashrebeeyah",
    "Mashrebeeyeh",
    "Masslessness",
    "Massotherapy",
    "Masterliness",
    "Maximization",
    "Measuredness",
    "Mediaevalism",
    "Mediatorship",
    "Medicamental",
    "Megacephalic",
    "Megalecithal",
    "Megalocardia",
    "Megalomaniac",
    "Melancholiac",
    "Melanotropin",
    "Mellifluence",
    "Melodramatic",
    "Memorability",
    "Memorization",
    "Meningiomata",
    "Meningococci",
    "Meniscectomy",
    "Menstruation",
    "Mercantilism",
    "Mercantilist",
    "Merchantable",
    "Merchantlike",
    "Mercifulness",
    "Mercurialise",
    "Metempirical",
    "Metempsychic",
    "Metencephala",
    "Meteoritical",
    "Meteorograph",
    "Meteorologic",
    "Methacrylate",
    "Methanogenic",
    "Methaqualone",
    "Methohexital",
    "Methotrexate",
    "Methoxychlor",
    "Methysergide",
    "Meticulosity",
    "Metrological",
    "Metropolitan",
    "Metrorrhagia",
    "Microammeter",
    "Microanatomy",
    "Microbalance",
    "Microbicidal",
    "Microbiology",
    "Microblogger",
    "Microbrewery",
    "Microcapsule",
    "Microcircuit",
    "Microclimate",
    "Microcrystal",
    "Microculture",
    "Microdontism",
    "Microdontous",
    "Microecology",
    "Microfilaria",
    "Micrographia",
    "Micrographic",
    "Microgravity",
    "Microhabitat",
    "Micrological",
    "Micromanager",
    "Mirthfulness",
    "Misadventure",
    "Misalignment",
    "Misallotment",
    "Misanthropic",
    "Misappraisal",
    "Misapprehend",
    "Misassertion",
    "Misattribute",
    "Misauthorize",
    "Mockumentary",
    "Moderateness",
    "Modification",
    "Modificative",
    "Modificatory",
    "Modulability",
    "Morphologist",
    "Morphonology",
    "Morphosyntax",
    "Mosquitofish",
    "Mosstroopery",
    "Motivational",
    "Motorcyclist",
    "Motorization",
    "Mouldability",
    "Mountainless",
    "Mountainside",
    "Mournfulness",
    "Mousquetaire",
    "Mucilaginous",
    "Mucopurulent",
    "Multinervate",
    "Multinodular",
    "Multinominal",
    "Multinuclear",
    "Multiovulate",
    "Multipartite",
    "Multiradical",
    "Multisaccate",
    "Multisection",
    "Multisegment",
    "Multisensory",
    "Multiseptate",
    "Multiseriate",
    "Multispinous",
    "Multistriate",
    "Multisulcate",
    "Multititular",
    "Multitubular",
    "Multivalence",
    "Multivariate",
    "Multiversity",
    "Multivitamin",
    "Multivoltine",
    "Myoneuralgia",
    "Myxedematous",
    "Myxobacteria",
    "Myxomycetous",
    "Namelessness",
    "Nanoparticle",
    "Nanoplankton",
    "Naphthalenic",
    "Narcissistic",
    "Narcotherapy",
    "Nasalization",
    "Nasolacrimal",
    "Naturalistic",
    "Naturopathic",
    "Navigability",
    "Navigational",
    "Nazification",
    "Nebulization",
    "Nebulousness",
    "Necrological",
    "Necromimesis",
    "Necrophiliac",
    "Necrophilism",
    "Necropolitan",
    "Needlessness",
    "Neencephalic",
    "Neencephalon",
    "Negativeness",
    "Negativistic",
    "Neighborhood",
    "Neighborless",
    "Nematocystic",
    "Nematologist",
    "Nemoricoline",
    "Nemoricolous",
    "Neoanthropic",
    "Neoclassical",
    "Neoencephala",
    "Neoformation",
    "Neoformative",
    "Neoplatonism",
    "Neoytterbium",
    "Nephelinitic",
    "Nephelometer",
    "Nephelometry",
    "Nephrolithic",
    "Nephrologist",
    "Nephropathic",
    "Nepotistical",
    "Nesosilicate",
    "Neurasthenia",
    "Neurasthenic",
    "Newspapermen",
    "Nicotinamide",
    "Nicotineless",
    "Nidification",
    "Nightclubber",
    "Nitrobenzene",
    "Nitrogelatin",
    "Nitromannite",
    "Nitromethane",
    "Noctambulant",
    "Noctambulism",
    "Noctambulist",
    "Noctambulous",
    "Nomenclature",
    "Nomenklatura",
    "Nominalistic",
    "Nonabolition",
    "Nonabrogable",
    "Nonabsorbent",
    "Nonabstainer",
    "Nonaccedence",
    "Nonaccentual",
    "Nonacceptant",
    "Nonaccession",
    "Nonaccordant",
    "Nonaccretion",
    "Nonaccretive",
    "Nonacquittal",
    "Nonactivator",
    "Nonactuality",
    "Nonacuteness",
    "Nonadaptable",
    "Nonaddictive",
    "Nonadeptness",
    "Nonadherence",
    "Nonlabelling",
    "Nonlaminable",
    "Nonlethargic",
    "Nonliability",
    "Nonlitigious",
    "Nonlubricant",
    "Nonlucidness",
    "Nonlucrative",
    "Nonlymphatic",
    "Nonmalarious",
    "Nonmalicious",
    "Nonmalignant",
    "Nonmalignity",
    "Nonmalleable",
    "Nonmammalian",
    "Nonmandatory",
    "Nonmasculine",
    "Nonmediation",
    "Nonmediative",
    "Nonmedicinal",
    "Nonmelodious",
    "Nonmendicant",
    "Nonmercenary",
    "Nonreference",
    "Nonreflector",
    "Nonrejection",
    "Nonrejoinder",
    "Nonreligious",
    "Nonremission",
    "Nonremovable",
    "Nonrendition",
    "Nonrenewable",
    "Nonrepayable",
    "Nonrepellent",
    "Nonreplicate",
    "Nonrequisite",
    "Nonresidence",
    "Nonresidency",
    "Nonresilient",
    "Nonresistant",
    "Nonresistive",
    "Nonrestraint",
    "Nonretention",
    "Nonretentive",
    "Nonreticence",
    "Nontreatment",
    "Nontribesman",
    "Nontributary",
    "Nonturbinate",
    "Nontyphoidal",
    "Nontyrannous",
    "Nonumbilical",
    "Nonunitarian",
    "Nonuniteable",
    "Nonuniversal",
    "Nonvalidness",
    "Nonvariation",
    "Nonvasculose",
    "Nonvasculous",
    "Nonvegetable",
    "Nonvehicular",
    "Nonverbosity",
    "Nonveritable",
    "Nonverminous",
    "Nonvertebral",
    "Nonvesicular",
    "Nonvexatious",
    "Nonviability",
    "Nonvibratile",
    "Northeastern",
    "Northernmost",
    "Northernness",
    "Northwestern",
    "Notarization",
    "Notelessness",
    "Nuclearistic",
    "Nucleocapsid",
    "Nucleophilic",
    "Nucleosidase",
    "Numerousness",
    "Numismatical",
    "Nurserywoman",
    "Nutritionary",
    "Nutritionist",
    "Nyctitropism",
    "Nympholeptic",
    "Obdurateness",
    "Oblanceolate",
    "Obligational",
    "Obligingness",
    "Obliteration",
    "Obliterative",
    "Oblivescence",
    "Obnubilation",
    "Obreptitious",
    "Obscurantism",
    "Obscurantist",
    "Observership",
    "Obsolescence",
    "Obsoleteness",
    "Obstetrician",
    "Obstreperous",
    "Occupational",
    "Oceanography",
    "Oceanologist",
    "Octogenarian",
    "Octosyllabic",
    "Octosyllable",
    "Odontography",
    "Odontophoral",
    "Officeholder",
    "Olallieberry",
    "Oleomargaric",
    "Olericulture",
    "Olfactometer",
    "Oligarchical",
    "Oligophagous",
    "Oligophrenia",
    "Oligophrenic",
    "Oligotrophic",
    "Ombudsperson",
    "Omnidistance",
    "Omnipresence",
    "Oncogenicity",
    "Oncornavirus",
    "Oneirocritic",
    "Oneiromancer",
    "Onomasiology",
    "Onomastician",
    "Onomatologic",
    "Onomatopoeia",
    "Onomatopoeic",
    "Onychophagia",
    "Onychophoran",
    "Oophorectomy",
    "Operationism",
    "Ophiolatrous",
    "Ophiological",
    "Ophiophagous",
    "Opinionative",
    "Opisthograph",
    "Opposability",
    "Oppositeness",
    "Oppositional",
    "Opsonization",
    "Optimistical",
    "Optimization",
    "Optometrical",
    "Oracularness",
    "Orbicularity",
    "Orbiculation",
    "Orthogenetic",
    "Orthognathic",
    "Orthographer",
    "Orthographic",
    "Orthopterous",
    "Orthorhombic",
    "Orthotropous",
    "Oscillograph",
    "Oscillometer",
    "Oscillometry",
    "Oscilloscope",
    "Ossification",
    "Osteoblastic",
    "Osteoclastic",
    "Osteogenetic",
    "Osteological",
    "Osteomalacia",
    "Osteomalacic",
    "Osteoplastic",
    "Osteoporotic",
    "Osteosarcoma",
    "Outtyrannize",
    "Overabstract",
    "Overabundant",
    "Overactivity",
    "Pachydermoid",
    "Pachydermous",
    "Pacification",
    "Pacificatory",
    "Paedophiliac",
    "Paganization",
    "Painlessness",
    "Palatability",
    "Palatialness",
    "Palatography",
    "Paleobiology",
    "Paleobotanic",
    "Paleoclimate",
    "Paleoecology",
    "Paleogeology",
    "Paleographer",
    "Paleographic",
    "Paleoliberal",
    "Paleological",
    "Paleontology",
    "Paleozoology",
    "Palimpsestic",
    "Palingenetic",
    "Pappenheimer",
    "Papyrologist",
    "Paraboloidal",
    "Parachronism",
    "Paradigmatic",
    "Paradisaical",
    "Paradisiacal",
    "Paradoxology",
    "Paraesthesia",
    "Paraesthetic",
    "Paragraphist",
    "Parahydrogen",
    "Paralanguage",
    "Paralipomena",
    "Parallelable",
    "Pelecypodous",
    "Pellucidness",
    "Penalization",
    "Pendulumlike",
    "Penetrometer",
    "Penitentiary",
    "Pentadecagon",
    "Pentahydrate",
    "Pentahydroxy",
    "Pentametrist",
    "Pentarchical",
    "Peppershaker",
    "Peppershrike",
    "Peptidolytic",
    "Peradventure",
    "Perambulator",
    "Perspiration",
    "Perspiratory",
    "Pertinacious",
    "Perturbation",
    "Perturbative",
    "Pharmaceutic",
    "Pharmacolite",
    "Pharmacology",
    "Pharmacopeia",
    "Pharyngalise",
    "Pharyngology",
    "Phellodermal",
    "Phenanthrene",
    "Phenological",
    "Phenotypical",
    "Phentolamine",
    "Philanthropy",
    "Philatelical",
    "Philharmonic",
    "Philhellenic",
    "Philistinism",
    "Phillumenist",
    "Philodendron",
    "Phosphoritic",
    "Photoactinic",
    "Photobiology",
    "Photocathode",
    "Photochemist",
    "Photochromic",
    "Photocompose",
    "Photocurrent",
    "Photodynamic",
    "Photoelastic",
    "Photoengrave",
    "Photofission",
    "Photogelatin",
    "Photogeology",
    "Photographer",
    "Photographic",
    "Photogravure",
    "Photokinetic",
    "Phytological",
    "Phytonadione",
    "Phytophagous",
    "Phytophthora",
    "Piacularness",
    "Pianisticses",
    "Pigmentation",
    "Piperacillin",
    "Pisciculture",
    "Platformless",
    "Platitudinal",
    "Plausibility",
    "Pleasantness",
    "Pleomorphism",
    "Pleomorphous",
    "Plerocercoid",
    "Pleurocarpic",
    "Pleurogenous",
    "Ploddingness",
    "Plotlessness",
    "Plumbaginous",
    "Plumbiferous",
    "Politicalize",
    "Pollutedness",
    "Polyarchical",
    "Polybasicity",
    "Polybutylene",
    "Polycentrism",
    "Polychaetous",
    "Polychromous",
    "Polydemonism",
    "Polydisperse",
    "Polyembryony",
    "Polyethylene",
    "Polygraphist",
    "Polyhedrosis",
    "Polyhistoric",
    "Polyisoprene",
    "Polymorphism",
    "Polymorphous",
    "Practicalism",
    "Practicality",
    "Prankishness",
    "Praseodymium",
    "Preabsorbent",
    "Preabundance",
    "Preacquittal",
    "Preadaptable",
    "Preadherence",
    "Preadjective",
    "Preadmission",
    "Preadmitting",
    "Preadornment",
    "Preadulthood",
    "Preadvertise",
    "Propaedeutic",
    "Propagandise",
    "Propagandism",
    "Propagandist",
    "Propatriotic",
    "Propatronage",
    "Propenseness",
    "Propertyless",
    "Prophesiable",
    "Prophylactic",
    "Propitiation",
    "Propitiative",
    "Propitiatory",
    "Proportional",
    "Proportioner",
    "Propoxyphene",
    "Proprietress",
    "Proprivilege",
    "Propublicity",
    "Prorealistic",
    "Proscribable",
    "Proscription",
    "Proscriptive",
    "Pseudosocial",
    "Pseudosphere",
    "Pseudosubtle",
    "Pseudovarian",
    "Psilanthropy",
    "Psittacistic",
    "Psychoactive",
    "Psychobabble",
    "Psychologism",
    "Psychrometry",
    "Pteridophyte",
    "Pteridosperm",
    "Putrefactive",
    "Pyelographic",
    "Pyloroplasty",
    "Pyophthalmia",
    "Quackishness",
    "Quadrangular",
    "Quadrantlike",
    "Quadraphonic",
    "Quadraplegic",
    "Quadricopter",
    "Quadriennial",
    "Quadriennium",
    "Quadrinomial",
    "Quadriphonic",
    "Quadriplegia",
    "Quadriplegic",
    "Quadrivalent",
    "Quadrominium",
    "Quadrumanous",
    "Quadrupedism",
    "Quaestorship",
    "Qualificator",
    "Qualmishness",
    "Quantifiable",
    "Quantitation",
    "Quantitative",
    "Quantization",
    "Quaquaversal",
    "Quarterfinal",
    "Quarterstaff",
    "Quasicrystal",
    "Quattrocento",
    "Questionable",
    "Questionless",
    "Quicksilvery",
    "Quinalizarin",
    "Quinquennial",
    "Quinquennium",
    "Quintessence",
    "Quippishness",
    "Quizzicality",
    "Racemization",
    "Radiableness",
    "Radiobiology",
    "Radioelement",
    "Radiographer",
    "Radiographic",
    "Radioisotope",
    "Radiolocator",
    "Radiological",
    "Radiolucence",
    "Radiolucency",
    "Radionuclide",
    "Radiotherapy",
    "Radiothorium",
    "Rainlessness",
    "Rambunctious",
    "Ramentaceous",
    "Reactivation",
    "Reactiveness",
    "Readableness",
    "Readaptation",
    "Readjudicate",
    "Readjustable",
    "Readjustment",
    "Readmittance",
    "Realienation",
    "Reallocation",
    "Realteration",
    "Reamalgamate",
    "Recreational",
    "Recriminator",
    "Recrudescent",
    "Recuperation",
    "Recuperative",
    "Recuperatory",
    "Redecoration",
    "Rededication",
    "Redefinition",
    "Redelegation",
    "Redeliberate",
    "Redemandable",
    "Redemptional",
    "Redemptioner",
    "Redeployment",
    "Reexcavation",
    "Reexhibition",
    "Reexperience",
    "Reexperiment",
    "Reexposition",
    "Reexpression",
    "Refederalize",
    "Reflationary",
    "Reflectional",
    "Reflectivity",
    "Reflectorise",
    "Reforfeiture",
    "Ribonuclease",
    "Ridiculosity",
    "Riflemanship",
    "Rightfulness",
    "Rigorousness",
    "Rijksdaalder",
    "Rinseability",
    "Risorgimento",
    "Roadlessness",
    "Robotization",
    "Rockumentary",
    "Rollerskater",
    "Rootlessness",
    "Roundishness",
    "Ruralization",
    "Rusticalness",
    "Ruthlessness",
    "Saccharinity",
    "Saccharoidal",
    "Sacrilegious",
    "Salamandrine",
    "Salamandroid",
    "Salesmanship",
    "Salification",
    "Salinization",
    "Salpingotomy",
    "Saltationism",
    "Saltationist",
    "Salutariness",
    "Salutational",
    "Salutatorian",
    "Scattergraph",
    "Scenographer",
    "Scenographic",
    "Schismatical",
    "Schistosomal",
    "Schizocarpic",
    "Schizogenous",
    "Schizogonous",
    "Schizomycete",
    "Schizophytic",
    "Schizopodous",
    "Scholastical",
    "Schoolboyish",
    "Schoolfellow",
    "Schoolmaster",
    "Secularistic",
    "Sedulousness",
    "Seedlessness",
    "Segmentation",
    "Seismography",
    "Seismometric",
    "Seismoscopic",
    "Seleniferous",
    "Selenography",
    "Selenotropic",
    "Selflessness",
    "Selfsameness",
    "Shadowgraphy",
    "Shamefulness",
    "Shapeshifter",
    "Sharecropper",
    "Sharpshooter",
    "Shatterproof",
    "Sheepishness",
    "Sheepshearer",
    "Shellcracker",
    "Shellfishery",
    "Shepherdless",
    "Shepherdlike",
    "Shiftingness",
    "Siliciferous",
    "Siliquaceous",
    "Silviculture",
    "Simultaneity",
    "Simultaneous",
    "Sinecureship",
    "Singularness",
    "Singultation",
    "Sinisterness",
    "Sinistrality",
    "Siphonophore",
    "Siphunculate",
    "Sisterliness",
    "Situationism",
    "Situationist",
    "Sixteenpenny",
    "Sizeableness",
    "Skateboarder",
    "Skeletonlike",
    "Skeuomorphic",
    "Skillessness",
    "Skillfulness",
    "Skittishness",
    "Skullduggery",
    "Skutterudite",
    "Slaglessness",
    "Slaughterous",
    "Snaggleteeth",
    "Snaggletooth",
    "Snippetiness",
    "Snobbishness",
    "Snollygoster",
    "Snooperscope",
    "Socializable",
    "Sociobiology",
    "Sociocentric",
    "Southwestern",
    "Spaciousness",
    "Sparkishness",
    "Sparrowgrass",
    "Spasmolysant",
    "Spasmophilia",
    "Spasmophilic",
    "Spatiography",
    "Speakerphone",
    "Speakingness",
    "Specialistic",
    "Speciousness",
    "Speckledness",
    "Spectatorial",
    "Spectralness",
    "Spectrograph",
    "Spectrometer",
    "Spectrometry",
    "Spectroscope",
    "Squaresville",
    "Squarishness",
    "Squirearchal",
    "Squirrelfish",
    "Squirrellike",
    "Stabilograph",
    "Stackability",
    "Stageability",
    "Stainability",
    "Stalactiform",
    "Stalwartness",
    "Standpattism",
    "Stapedectomy",
    "Subtrapezoid",
    "Subtrihedral",
    "Subtrochlear",
    "Subtutorship",
    "Subumbellate",
    "Subumbilical",
    "Subuniversal",
    "Subvassalage",
    "Subvermiform",
    "Subversivism",
    "Subvertebral",
    "Subvesicular",
    "Subzygomatic",
    "Succedaneous",
    "Successional",
    "Succinctness",
    "Succinctoria",
    "Surveillance",
    "Surveyorship",
    "Survivorship",
    "Susceptivity",
    "Sustentation",
    "Sustentative",
    "Swainishness",
    "Synclinorial",
    "Synclinorian",
    "Synclinorium",
    "Syncretistic",
    "Syndactylism",
    "Syndiotactic",
    "Synostotical",
    "Systematical",
    "Tabernacular",
    "Tachygrapher",
    "Tachygraphic",
    "Tactlessness",
    "Taillessness",
    "Talismanical",
    "Tambourinist",
    "Tamelessness",
    "Tapestrylike",
    "Taramasalata",
    "Taskmistress",
    "Tastefulness",
    "Tauromachian",
    "Tautological",
    "Teachability",
    "Tearableness",
    "Tearlessness",
    "Teasableness",
    "Technetronic",
    "Technicality",
    "Technobabble",
    "Technobandit",
    "Technocratic",
    "Technography",
    "Technologist",
    "Technophilia",
    "Technophobia",
    "Teetertotter",
    "Telaesthesia",
    "Telecommuter",
    "Telegraphese",
    "Thalassocrat",
    "Thallophytic",
    "Thankfulness",
    "Thaumatology",
    "Thaumaturgic",
    "Theanthropic",
    "Theocratical",
    "Theomorphism",
    "Theopathetic",
    "Theophylline",
    "Theoretician",
    "Theorization",
    "Theosophical",
    "Thiosulfuric",
    "Thioxanthene",
    "Thoracostomy",
    "Thoroughfare",
    "Thoroughness",
    "Thoroughwort",
    "Thortveitite",
    "Thousandfold",
    "Thrombectomy",
    "Thrombocytic",
    "Thrombolytic",
    "Throttleable",
    "Throttlehold",
    "Thunderation",
    "Thundercloud",
    "Thunderstick",
    "Thunderstone",
    "Thunderstorm",
    "Thyrotrophic",
    "Thyrotrophin",
    "Thysanoptera",
    "Ticklishness",
    "Tidelessness",
    "Tigerishness",
    "Timberdoodle",
    "Timelessness",
    "Timocratical",
    "Timorousness",
    "Tintinnabula",
    "Tintlessness",
    "Tirelessness",
    "Tiresomeness",
    "Titaniferous",
    "Togetherness",
    "Toilsomeness",
    "Tolerability",
    "Tollgatherer",
    "Tonelessness",
    "Tractability",
    "Tradespeople",
    "Traditionary",
    "Traditionist",
    "Traducianism",
    "Traducianist",
    "Tragicalness",
    "Tragicomical",
    "Trailbreaker",
    "Trainability",
    "Trampboarder",
    "Trampishness",
    "Trampolinist",
    "Tranquilizer",
    "Tranquillise",
    "Tranquillity",
    "Tranquilness",
    "Transaminase",
    "Transannular",
    "Transaquatic",
    "Transcalency",
    "Transcendent",
    "Trephination",
    "Trepidatious",
    "Triacontanol",
    "Triadelphous",
    "Triangulator",
    "Tribespeople",
    "Trichocystic",
    "Trichogramma",
    "Trichogynial",
    "Trichologist",
    "Trichopteran",
    "Trichopteron",
    "Trichotomous",
    "Trichromatic",
    "Trickishness",
    "Tricuspidate",
    "Triflingness",
    "Tropological",
    "Tropophilous",
    "Tropospheric",
    "Troubledness",
    "Troublemaker",
    "Troubleproof",
    "Troubleshoot",
    "Trustability",
    "Trustfulness",
    "Trypaflavine",
    "Trypanosomal",
    "Trypanosomic",
    "Tryparsamide",
    "Tubocurarine",
    "Tubuliferous",
    "Turbellarian",
    "Turbidimeter",
    "Turbidimetry",
    "Twistability",
    "Typification",
    "Tyrannicidal",
    "Uglification",
    "Ulcerousness",
    "Ultimateness",
    "Ultracareful",
    "Ultradistant",
    "Ultraleftism",
    "Ultraleftist",
    "Ultraliberal",
    "Ultramontane",
    "Ultramundane",
    "Ultraprecise",
    "Ultraradical",
    "Ultrarealism",
    "Ultraserious",
    "Ultraviolent",
    "Umbilication",
    "Umbrellabird",
    "Umbrellaless",
    "Umbrellalike",
    "Unabjectness",
    "Unabjuratory",
    "Unabrogative",
    "Unabsorbable",
    "Unabsorptive",
    "Unabstemious",
    "Unacademical",
    "Unacceptable",
    "Unenthusiasm",
    "Unenunciable",
    "Unepithelial",
    "Unequatorial",
    "Unequestrian",
    "Unequivalent",
    "Uneradicable",
    "Unerringness",
    "Unethicality",
    "Unetymologic",
    "Uneuphonious",
    "Unevanescent",
    "Unevidential",
    "Unexaminable",
    "Unexceedable",
    "Unexcludable",
    "Unexcrescent",
    "Unexculpable",
    "Unexecutable",
    "Unexemptible",
    "Unexhaustive",
    "Unvitreosity",
    "Unvitrescent",
    "Unvociferous",
    "Unvoluminous",
    "Unvoluptuous",
    "Unvulgarness",
    "Unwieldiness",
    "Unwilfulness",
    "Unwoefulness",
    "Unwontedness",
    "Unworthiness",
    "Uprootedness",
    "Uranographer",
    "Uranographic",
    "Uranological",
    "Urbanization",
    "Ureterostomy",
    "Urethrectomy",
    "Urethroscope",
    "Urethroscopy",
    "Urethrostomy",
    "Uricacidemia",
    "Urinogenital",
    "Usufructuary",
    "Usuriousness",
    "Uxoriousness",
    "Vacationland",
    "Vainglorious",
    "Valetudinary",
    "Valorization",
    "Valorousness",
    "Valuableness",
    "Vanquishable",
    "Vanquishment",
    "Vaporability",
    "Vaporishness",
    "Vaporization",
    "Vaporousness",
    "Variableness",
    "Variocoupler",
    "Vasodilation",
    "Vasoligation",
    "Vasoligature",
    "Vaticination",
    "Vaudevillian",
    "Vegetational",
    "Velarization",
    "Velociraptor",
    "Vendibleness",
    "Venepuncture",
    "Venerability",
    "Vengefulness",
    "Venipuncture",
    "Venomousness",
    "Ventricosity",
    "Ventrodorsal",
    "Verbenaceous",
    "Verderership",
    "Veridicality",
    "Verification",
    "Verificative",
    "Verificatory",
    "Vermiculture",
    "Verticalness",
    "Verticillate",
    "Vesiculation",
    "Veterinarian",
    "Videographer",
    "Vigilanteism",
    "Vigintillion",
    "Vigorousness",
    "Vilification",
    "Vincibleness",
    "Vinicultural",
    "Vinification",
    "Vinylstyrene",
    "Violableness",
    "Viridescence",
    "Virtuousness",
    "Visceromotor",
    "Viscoelastic",
    "Viscountship",
    "Visitatorial",
    "Visualizable",
    "Visuospatial",
    "Vitalization",
    "Viticultural",
    "Vitiliginous",
    "Vitreousness",
    "Vitrifaction",
    "Vituperation",
    "Vituperative",
    "Vivification",
    "Vocalization",
    "Vociferation",
    "Voicefulness",
    "Voidableness",
    "Volatileness",
    "Volcanogenic",
    "Volcanologic",
    "Volumetrical",
    "Voluminosity",
    "Voluntaryism",
    "Voluntaryist",
    "Volunteerism",
    "Voluptuosity",
    "Vomiturition",
    "Vowelization",
    "Vulcanizable",
    "Wagelessness",
    "Wakerifeness",
    "Walkingstick",
    "Wallydraigle",
    "Wantlessness",
    "Warehouseman",
    "Washfountain",
    "Wastefulness",
    "Watchability",
    "Watchfulness",
    "Watermanship",
    "Wearifulness",
    "Weatherboard",
    "Weatherglass",
    "Weatherproof",
    "Weathertight",
    "Weatherwoman",
    "Webliography",
    "Weightedness",
    "Weightlifter",
    "Weisenheimer",
    "Welterweight",
    "Westerliness",
    "Whataboutism",
    "Whencesoever",
    "Wherethrough",
    "Whigmaleerie",
    "Whimsicality",
    "Whippoorwill",
    "Whipscorpion",
    "Whoremastery",
    "Whortleberry",
    "Wicketkeeper",
    "Wifelessness",
    "Wikileakable",
    "Windlessness",
    "Wineglassful",
    "Winglessness",
    "Winterbourne",
    "Wirelessness",
    "Withdrawable",
    "Withdrawment",
    "Witheredness",
    "Wollastonite",
    "Womanishness",
    "Wonderstruck",
    "Wondrousness",
    "Wordlessness",
    "Workableness",
    "Workingwoman",
    "Wrathfulness",
    "Wretchedness",
    "Wrongfulness",
    "Xenocurrency",
    "Yachtmanship",
    "Yarovization",
    "Yellowhammer",
    "Zincographer",
    "Zincographic",
]

//

const names = ["@naro", "@regu", "@wide"]
const glyphNames = ["m", "o", "l"]
const combLookup = {
    "@naro-@naro-@wide": -40,
    "@naro-@regu-@wide": -30,
    "@naro-@wide-@wide": -20,
    "@wide-@naro-@naro": 40,
    "@wide-@regu-@naro": 30,
    "@wide-@wide-@naro": 20,
    "@regu-@naro-@wide": -20,
    "@regu-@regu-@wide": -15,
    "@regu-@wide-@wide": -10,
    "@wide-@naro-@regu": 20,
    "@wide-@regu-@regu": 15,
    "@wide-@wide-@regu": 10,
    "@naro-@naro-@regu": -10,
    "@naro-@regu-@regu": -7,
    "@naro-@wide-@regu": -5,
    "@regu-@naro-@naro": 10,
    "@regu-@regu-@naro": 7,
    "@regu-@wide-@naro": 5,
}
const lookup = (x, y, z) => combLookup[`${names[x]}-${names[y]}-${names[z]}`]
let combinations = ""
names.forEach((_, i) => {
    names.forEach((_, j) => {
        names.forEach((_, k) => {
            names.forEach((_, l) => {
                // if (names[i] != names[k])
                // 	combinations += `    pos ${names[i]} ${names[j]}' ${names[k]} ${names[l]} <${lookup(
                // 		i,
                // 		j,
                // 		k
                // 	)} 0 0 0>;\n`
                // if (names[j] != names[l])
                // 	combinations += `    pos ${names[i]} ${names[j]} ${names[k]}' ${names[l]} <${lookup(
                // 		j,
                // 		k,
                // 		l
                // 	)} 0 0 0>;\n`
                combinations += glyphNames[i] + glyphNames[j] + glyphNames[k] + glyphNames[l] + "\n"
            })
        })
    })
})
// console.log(combinations)
for (let i = 0; i < 50; i++) {
    const randomWord = words[Math.floor(words.length * Math.random())]
    console.log(
        randomWord
            .split("")
            // .map((l, i) => (i == 6 ? l.toUpperCase() : l))
            .map((l, i) => (i == 0 ? " " + l : l))
            .join(""),
    )
}
