const websiteData = {
    pushPage: {
        coordinates: { x: 0, y: 0 },
        scale: 1,
        distance: 64,
        scaleOffset: 1.5,
    },
    weight: 400,
    letterSpacing: 0,
    lineHeight: 1,
    fontName: "CommitMono",
    italic: false,
    invert: false,
    highContrast: false,
    tutorial: [
        "ArrowUp",
        "ArrowDown",
        "ArrowLeft",
        "ArrowRight",
        "1",
        "2",
        "3",
        "w",
        "a",
        "s",
        "d",
        "+",
        "-",
        "Enter",
        "Escape",
    ],
    enableFeaturesInDocs: false,
    sections: [
        {
            name: "home",
            description: null,
            content: {},
        },
        {
            name: "concept",
            description: `The most effective font is the one you don’t notice. No super high x-height, no geometric construction, no eye-catching design and no confusing ligatures. Designed to be neutral and anonymous, Commit Mono is quietly useful.

Tip: Press <span class="span_key">I</span> to switch between italic and regular.`,
            content: {},
        },
        {
            name: "familiar",
            description: `All research suggests the most familiar fonts are the ones you read fastest and most precisely. Commit Mono takes inspiration in fonts tested by time.

Tip: Press <span class="span_key">C</span> to enable/disable high contrast mode.`,
            content: {
                svgs: {
                    franklin_gothic: `<svg width="1000" height="200" viewBox="0 0 1000 200" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M22.224 40H18.576C18.336 38.848 18.336 38.416 18.144 35.728C16.224 39.232 13.872 40.624 9.84 40.624C4.944 40.624 1.584 37.696 1.584 33.472C1.584 30.784 3.12 28.24 5.568 26.992C7.728 25.84 10.944 25.264 15.072 25.264C15.936 25.264 16.656 25.264 18.144 25.36V24.592C18.144 20.128 16.464 18.496 11.952 18.496C8.4 18.496 6.24 19.984 5.616 22.816L2.208 22.24C2.544 20.464 2.976 19.552 3.984 18.544C5.856 16.624 8.832 15.664 12.768 15.664C16.32 15.664 18.72 16.576 20.112 18.448C21.264 20.032 21.696 21.904 21.696 25.36V35.392C21.696 37.12 21.84 38.56 22.224 40ZM18.144 28.144C16.848 28.096 15.6 28.048 15.024 28.048C8.88 28.048 5.52 29.968 5.52 33.568C5.52 36.112 7.488 37.792 10.56 37.792C14.88 37.792 18.192 34.24 18.192 29.68C18.192 29.248 18.192 28.768 18.144 28.144ZM30.8783 40H29.1023V7.984H32.7983V20.272C34.7183 17.008 36.6863 15.712 39.7583 15.712C45.4703 15.712 49.3583 20.704 49.3583 28.048C49.3583 35.44 45.3263 40.624 39.6143 40.624C36.3983 40.624 34.0943 39.184 32.2223 36.064L30.8783 40ZM32.7983 25.408V30.736C33.0383 32.944 33.3743 33.952 34.2383 35.152C35.3903 36.64 37.3583 37.6 39.2303 37.6C43.0223 37.6 45.4703 34.048 45.4703 28.528C45.4703 25.6 44.7503 22.72 43.5503 20.944C42.6383 19.6 40.9583 18.736 39.2303 18.736C37.5023 18.736 35.9663 19.504 34.6703 20.944C33.5663 22.24 33.1343 23.296 32.7983 25.408ZM68.8515 31.696L72.1635 32.272C71.5875 35.152 70.9155 36.544 69.3795 38.08C67.6995 39.808 65.6355 40.624 62.9955 40.624C56.9475 40.624 53.0115 35.728 53.0115 28.192C53.0115 20.704 57.0435 15.712 63.1875 15.712C68.0355 15.712 71.2035 18.592 72.1635 23.968L68.8515 24.592C68.5635 22.768 68.2275 21.904 67.6035 20.992C66.5475 19.552 64.9635 18.736 63.1395 18.736C59.2515 18.736 56.8515 22.336 56.8515 28.096C56.8515 34.048 59.1555 37.6 63.0915 37.6C66.0675 37.6 68.0835 35.584 68.8515 31.696ZM95.6749 7.984V40H92.3149V35.968C90.3469 39.328 88.2349 40.672 84.8269 40.672C79.2589 40.672 75.3229 35.584 75.3229 28.384C75.3229 20.896 79.3069 15.712 85.0189 15.712C87.9949 15.712 89.8669 16.768 91.9789 19.552V7.984H95.6749ZM91.9789 30.4V25.456C91.7869 23.248 91.4989 22.24 90.5869 21.088C89.4829 19.6 87.4669 18.64 85.5949 18.64C81.8029 18.64 79.3549 22.288 79.3549 27.904C79.3549 34.048 81.6109 37.648 85.4509 37.648C87.2269 37.648 88.9549 36.736 90.2509 35.248C91.4029 33.856 91.7869 32.752 91.9789 30.4ZM118.671 32.944L122.079 33.664C120.543 38.032 116.847 40.624 112.047 40.624C105.567 40.624 101.199 35.68 101.199 28.288C101.199 20.848 105.711 15.712 112.191 15.712C116.175 15.712 119.439 17.728 121.119 21.184C122.079 23.248 122.463 25.216 122.511 28.48H105.279C105.279 31.264 105.519 32.512 106.239 34C107.295 36.16 109.743 37.6 112.287 37.6C114.207 37.6 116.031 36.832 117.231 35.44C117.759 34.864 118.143 34.192 118.671 32.944ZM105.471 25.744H118.479C118.431 23.536 118.095 22.432 117.135 21.04C115.935 19.36 114.351 18.544 112.239 18.544C110.175 18.544 108.447 19.408 107.151 20.992C106.095 22.336 105.711 23.488 105.471 25.744ZM137.379 16.336V19.216H131.619V40H128.211V19.216H124.035V16.336H128.211C128.307 13.408 128.451 12.448 128.979 11.056C129.795 8.752 132.195 7.312 135.267 7.312C136.275 7.312 137.139 7.408 138.771 7.648V10.624C137.763 10.336 137.283 10.288 136.563 10.288C134.115 10.288 132.579 11.056 132.051 12.544C131.619 13.552 131.619 13.744 131.619 16.336H137.379ZM160.992 12.64V15.568C157.824 15.52 156.816 16.144 156.48 18.256C157.968 19.984 158.736 21.904 158.736 23.968C158.736 28.576 154.944 31.84 149.664 31.84C149.04 31.84 148.512 31.792 148.032 31.696C147.264 31.552 146.688 31.456 146.496 31.456C145.248 31.456 144 32.56 144 33.712C144 34.48 144.384 35.056 145.2 35.44C146.016 35.824 146.976 35.92 151.344 36.064C156.24 36.208 157.824 36.448 159.312 37.456C160.992 38.512 161.904 40.192 161.904 42.16C161.904 46.624 157.872 48.928 150 48.928C142.944 48.928 139.2 46.768 139.2 42.688C139.2 40.384 140.304 38.944 142.8 37.984C141.072 36.736 140.496 35.776 140.496 34.144C140.496 32.224 141.36 31.12 143.76 29.968C141.552 28.048 140.688 26.272 140.688 23.68C140.688 19.072 144.528 15.616 149.712 15.616C151.488 15.616 153.024 15.952 154.56 16.72C154.8 15.328 155.232 14.416 156.048 13.648C156.864 12.832 157.824 12.592 160.032 12.592C160.32 12.592 160.512 12.592 160.992 12.64ZM149.808 18.544C146.688 18.544 144.48 20.704 144.48 23.824C144.48 26.944 146.592 29.008 149.76 29.008C152.832 29.008 155.04 26.896 155.04 23.92C155.04 20.848 152.832 18.544 149.808 18.544ZM145.344 39.04C143.376 40 142.752 40.816 142.752 42.304C142.752 43.072 143.088 43.888 143.616 44.32C144.912 45.424 147.504 46.096 150.288 46.096C152.208 46.096 154.272 45.76 155.904 45.232C157.536 44.704 158.4 43.648 158.4 42.304C158.4 41.248 157.872 40.528 156.768 40.048C155.616 39.52 155.184 39.472 151.056 39.376C148.656 39.328 146.448 39.184 145.344 39.04ZM183.85 40H180.154V25.648C180.154 23.2 180.058 22.336 179.674 21.376C179.05 19.792 177.37 18.736 175.546 18.736C173.914 18.736 172.138 19.6 170.938 20.992C169.546 22.576 168.97 24.448 168.97 27.232V40H165.274V7.984H168.97V20.704C170.89 17.104 172.954 15.664 176.218 15.664C178.81 15.664 181.066 16.768 182.41 18.784C183.61 20.512 183.85 21.712 183.85 25.648V40ZM194.844 16.336V40H191.148V16.336H194.844ZM194.988 7.984V12.064H191.004V7.984H194.988ZM205.344 16.048V40.768C205.344 45.712 202.992 48.208 198.432 48.208C197.472 48.208 196.656 48.064 195.072 47.728V44.8C196.272 45.088 196.896 45.184 197.76 45.184C200.544 45.184 201.648 43.888 201.648 40.768V16.048H205.344ZM205.536 7.984V12.064H201.36V7.984H205.536ZM232.249 40H228.409L221.497 26.8L216.361 32.704V40H212.665V7.984H216.361V28.48L227.353 16.336H231.289L223.897 24.688L232.249 40ZM239.986 40H236.29V7.984H239.986V40ZM279.08 40H275.48V25.312C275.48 22.72 275.336 22.048 274.712 20.992C273.944 19.696 272.408 18.88 270.92 18.88C269.432 18.88 267.896 19.648 266.696 20.944C265.352 22.48 264.872 24.016 264.872 26.656V40H261.32V24.448C261.32 22.576 260.984 21.424 260.216 20.464C259.304 19.36 258.008 18.736 256.664 18.736C253.4 18.736 250.856 21.856 250.856 25.84V40H247.352V16.336H250.52V20.896C252.2 17.488 254.696 15.712 257.816 15.712C261.128 15.712 263.528 17.776 264.44 21.376C266.024 17.68 268.664 15.712 271.928 15.712C274.424 15.712 276.728 17.008 277.976 19.072C278.84 20.464 279.08 21.904 279.08 25.312V40ZM305.118 40H301.662V24.784C301.662 20.944 299.934 18.88 296.766 18.88C292.926 18.88 290.142 22.336 290.142 26.992V40H286.446V16.336H289.854V20.704C292.302 16.96 294.174 15.712 297.438 15.712C300.414 15.712 302.91 17.248 304.254 19.84C304.878 21.04 305.118 22.816 305.118 26.32V40ZM321.294 15.712C327.726 15.712 331.854 20.704 331.854 28.432C331.854 35.536 327.294 40.624 320.91 40.624C314.718 40.624 310.59 35.632 310.59 28.096C310.59 20.752 314.958 15.712 321.294 15.712ZM321.15 18.736C319.278 18.736 317.358 19.744 316.254 21.328C315.198 22.864 314.622 25.168 314.622 28.048C314.622 34.144 317.022 37.6 321.198 37.6C325.326 37.6 327.822 34.096 327.822 28.24C327.822 25.024 327.294 22.912 326.142 21.28C324.942 19.696 323.07 18.736 321.15 18.736ZM341.048 48.016H337.352V16.336H340.664V20.944C342.536 17.296 344.792 15.712 348.104 15.712C353.72 15.712 357.512 20.752 357.512 28.144C357.512 35.584 353.672 40.624 348.056 40.624C344.984 40.624 343.064 39.472 341.048 36.4V48.016ZM341.048 24.784V31.408C341.624 35.008 344.312 37.6 347.336 37.6C348.92 37.6 350.696 36.688 351.704 35.392C352.904 33.856 353.48 31.552 353.48 28.384C353.48 22.432 351.176 18.928 347.336 18.928C344.408 18.928 342.008 21.136 341.048 24.784ZM381.329 16V48.016H377.633V35.68C376.049 38.992 373.745 40.624 370.481 40.624C364.865 40.624 361.121 35.728 361.121 28.336C361.121 20.8 365.057 15.664 370.865 15.664C374.129 15.664 375.857 16.72 378.017 20.224L379.457 16H381.329ZM377.633 29.488V26.32C377.345 23.392 376.913 22.096 375.713 20.752C374.561 19.504 372.881 18.736 371.297 18.736C367.601 18.736 365.153 22.528 365.153 28.192C365.153 33.856 367.505 37.456 371.249 37.456C373.409 37.456 375.281 36.256 376.433 34.144C377.201 32.8 377.441 31.792 377.633 29.488ZM392.423 40H388.727V16.336H391.943V21.856C393.095 19.504 393.527 18.784 394.391 17.728C395.447 16.48 397.223 15.664 399.047 15.664C399.335 15.664 399.863 15.712 400.391 15.76V19.264C395.927 18.88 392.519 22.432 392.423 27.472V40ZM401.73 33.856L405.234 33.136C405.618 34.48 406.002 35.2 406.77 35.824C408.114 36.928 410.37 37.6 412.578 37.6C415.89 37.6 418.146 36.064 418.146 33.76C418.146 31.84 416.754 30.64 414.066 30.112L409.074 29.2C405.042 28.432 402.69 26.032 402.69 22.672C402.69 18.496 406.242 15.712 411.618 15.712C416.562 15.712 419.778 17.776 420.93 21.712L417.57 22.432C416.466 19.888 414.546 18.736 411.522 18.736C408.45 18.736 406.434 20.128 406.434 22.24C406.434 24.016 407.634 25.072 410.13 25.552L414.786 26.368C419.634 27.232 421.986 29.536 421.986 33.376C421.986 37.696 418.098 40.624 412.242 40.624C408.882 40.624 406.194 39.76 404.178 37.984C402.93 36.928 402.306 35.92 401.73 33.856ZM437.916 37.456V40.384C436.284 40.624 435.516 40.672 434.412 40.672C429.948 40.672 427.644 38.224 427.644 33.472V19.216H423.468V16.336H427.644L427.788 10.384L431.244 10.096V16.336H436.572V19.216H431.244V34.048C431.244 36.496 432.54 37.744 435.084 37.744C435.948 37.744 436.62 37.696 437.916 37.456ZM459.711 40H456.399V35.488C454.719 38.848 452.175 40.624 448.863 40.624C444.063 40.624 441.087 37.168 441.087 31.456V16.336H444.783V31.456C444.783 33.616 445.167 35.008 445.983 35.968C446.847 37.024 448.143 37.6 449.439 37.6C453.087 37.6 456.015 34.048 456.015 29.68V16.336H459.711V40ZM484.055 16.336L475.895 40H472.055L463.607 16.336H467.687L474.263 35.584L480.791 16.336H484.055ZM515.601 16.336L508.785 40H505.809L500.529 22.432L495.681 40H492.657L485.553 16.336H489.249L494.385 33.952L499.329 16.336H502.017L507.297 34.048L512.625 16.336H515.601ZM536.676 40H532.404L526.404 30.4L520.26 40H516.66L524.628 27.712L517.428 16.336H521.652L526.74 24.4L531.876 16.336H535.428L528.516 26.944L536.676 40ZM557.483 16.336L547.979 42.784C547.163 45.04 546.155 46.528 544.715 47.536C543.851 48.16 542.699 48.448 541.019 48.448C540.059 48.448 539.483 48.352 538.235 48.064V45.136C539.387 45.376 539.963 45.472 540.683 45.472C542.363 45.472 543.562 44.848 544.427 43.456C544.907 42.688 545.339 41.68 546.011 39.568L537.803 16.336H541.547L547.883 34.144L554.363 16.336H557.483ZM576.492 37.168V40H559.068V37.168L571.644 19.216H560.028V16.336H576.492V18.352L563.484 37.168H576.492ZM25.536 88H21.408L18.192 78.64H6.336L3.504 88H0.144L10.512 55.984H15.12L25.536 88ZM17.328 75.616L12.432 60.256L7.488 75.616H17.328ZM29.9528 88V55.984H42.6248C45.3608 55.984 46.9928 56.416 48.6248 57.472C50.8328 58.96 52.0328 61.216 52.0328 63.808C52.0328 65.872 51.1688 67.936 49.7768 69.232C48.9128 70 48.0968 70.432 46.3688 71.008C48.5288 71.632 49.3928 72.064 50.4488 73.072C52.1288 74.752 52.9928 76.72 52.9928 79.12C52.9928 82.336 51.5528 84.976 48.9608 86.56C47.2808 87.568 45.4088 88 42.5768 88H29.9528ZM33.8408 84.496H42.4328C46.5128 84.496 48.9608 82.432 48.9608 78.928C48.9608 77.296 48.3368 75.664 47.2808 74.56C46.0808 73.264 44.5448 72.736 41.8568 72.736H33.8408V84.496ZM33.8408 69.712H40.8008C43.4408 69.712 44.9288 69.376 46.0808 68.512C47.2808 67.6 48.0488 65.968 48.0488 64.24C48.0488 61.072 45.7928 59.248 41.8088 59.248H33.8408V69.712ZM78.1215 77.248L81.7695 78.064C80.9055 81.376 80.1375 83.008 78.5535 84.88C76.4895 87.328 73.5615 88.624 69.9615 88.624C66.3135 88.624 63.3375 87.28 61.1775 84.736C58.4415 81.472 56.9535 76.864 56.9535 71.68C56.9535 61.792 62.1855 55.36 70.2495 55.36C76.2495 55.36 80.0895 58.768 81.7695 65.632L78.0255 66.352C76.4415 61.024 74.1375 58.768 70.2015 58.768C64.6335 58.768 61.3215 63.76 61.3215 72.112C61.3215 80.08 64.7295 85.216 70.0575 85.216C72.3615 85.216 74.6655 84.064 75.9615 82.288C76.9215 80.944 77.4015 79.84 78.1215 77.248ZM86.7653 88V55.984H97.4693C101.501 55.984 104.429 57.088 106.973 59.488C110.093 62.464 111.821 66.832 111.821 71.872C111.821 81.136 106.301 88 98.8133 88H86.7653ZM90.7493 84.592H97.2773C100.157 84.592 102.701 83.632 104.285 81.952C106.445 79.696 107.741 75.856 107.741 71.872C107.741 67.984 106.541 64.528 104.381 62.128C102.653 60.256 100.397 59.344 97.2293 59.344H90.7493V84.592ZM138.344 84.496V88H117.656V55.984H137.912V59.488H121.64V69.712H134.552V72.976H121.64V84.496H138.344ZM147.14 88H143.156V55.984H162.74V59.488H147.14V69.616H160.1V72.832H147.14V88ZM190.54 71.872V88.432H188.044L186.988 84.4C184.684 87.424 182.092 88.672 178.06 88.672C174.268 88.672 171.34 87.328 168.94 84.592C166.252 81.472 164.86 77.296 164.86 72.352C164.86 62.176 170.428 55.36 178.732 55.36C182.38 55.36 185.26 56.608 187.42 59.056C188.764 60.592 189.436 61.888 190.204 64.624L186.412 65.536C185.836 63.328 185.356 62.368 184.348 61.264C182.86 59.68 180.7 58.768 178.348 58.768C175.324 58.768 172.732 60.304 171.34 62.896C169.996 65.296 169.228 68.656 169.228 72.208C169.228 75.712 169.996 78.976 171.292 81.28C172.78 83.824 175.564 85.408 178.588 85.408C183.292 85.408 186.46 82.048 186.46 76.96C186.46 76.48 186.46 75.904 186.412 75.232H178.54V71.872H190.54ZM220.426 88H216.442V72.736H201.562V88H197.578V55.984H201.562V69.232H216.442V55.984H220.426V88ZM232.031 88H228.047V55.984H232.031V88ZM250.319 55.984V78.208C250.319 85.312 247.247 88.624 240.671 88.624C239.087 88.624 238.031 88.48 236.062 88V84.736C237.935 85.072 238.895 85.168 240.335 85.168C242.783 85.168 244.415 84.592 245.327 83.344C246.191 82.24 246.335 81.424 246.335 78.208V55.984H250.319ZM283.014 88H278.598L269.046 70.336L261.702 79.456V88H257.718V55.984H261.702V74.56L276.198 55.984H280.518L271.83 67.216L283.014 88ZM306.254 84.496V88H287.39V55.984H291.47V84.496H306.254ZM341.457 88H337.569V60.064L327.201 88H324.465L314.001 60.064V88H310.593V55.984H316.545L326.145 81.568L335.601 55.984H341.457V88ZM372.646 88H368.758L352.198 60.112L352.246 62.224C352.294 63.28 352.294 64 352.294 64.24V88H349.078V55.984H354.07L369.574 82.096L369.526 79.888C369.478 78.688 369.478 77.872 369.478 77.536V55.984H372.646V88ZM391.715 55.36C399.587 55.36 404.819 61.984 404.819 71.968C404.819 76.768 403.283 81.376 400.547 84.592C398.243 87.328 395.363 88.624 391.619 88.624C387.827 88.624 384.755 87.232 382.499 84.496C379.955 81.328 378.563 77.056 378.563 72.064C378.563 62.176 383.939 55.36 391.715 55.36ZM391.667 58.624C386.243 58.624 382.739 63.952 382.739 72.112C382.739 80.08 386.291 85.36 391.715 85.36C397.091 85.36 400.643 80.032 400.643 71.92C400.643 63.616 397.283 58.624 391.667 58.624ZM414.702 88H410.718V55.984H422.046C424.926 55.984 427.23 56.656 428.91 58C431.022 59.632 432.414 62.608 432.414 65.536C432.414 71.056 428.286 74.992 422.478 74.992H414.702V88ZM414.702 71.68H422.046C425.838 71.68 428.334 69.232 428.334 65.536C428.334 61.888 425.886 59.344 422.334 59.344H414.702V71.68ZM460.232 91.936V95.152C458.696 95.536 457.927 95.68 456.776 95.68C454.568 95.68 452.456 95.056 451.208 94C449.864 92.848 449.288 91.36 449.048 88.528C445.544 88.288 443.672 87.664 441.56 86.08C437.72 83.2 435.704 78.352 435.704 72.112C435.704 62.08 441.032 55.36 449 55.36C456.968 55.36 462.296 61.936 462.296 71.824C462.296 77.152 460.807 81.568 457.88 84.688C456.296 86.464 454.952 87.232 452.312 88V88.768C452.312 89.632 452.552 90.304 453.032 90.928C453.752 91.888 454.712 92.224 456.68 92.224C458.072 92.224 458.84 92.176 460.232 91.936ZM449.048 58.864C446.168 58.864 443.768 60.064 442.376 62.128C440.888 64.384 439.976 68.224 439.976 72.256C439.976 80.32 443.24 85.168 448.712 85.168C454.52 85.168 457.976 80.32 457.976 72.112C457.976 63.616 454.76 58.864 449.048 58.864ZM491.18 88H486.956L481.052 74.128H471.884V88H468.14V55.984H480.716C486.716 55.984 490.844 59.632 490.844 64.96C490.844 67.072 489.98 69.376 488.636 70.864C487.676 71.968 486.764 72.496 484.892 73.168L491.18 88ZM471.884 70.864H480.236C482.54 70.864 484.028 70.336 485.228 69.088C486.284 67.984 486.86 66.496 486.86 64.864C486.86 61.552 484.508 59.488 480.716 59.488H471.884V70.864ZM493.839 79.456L497.439 78.688C498.927 83.104 501.999 85.216 506.895 85.216C511.695 85.216 514.575 83.008 514.575 79.36C514.575 76.912 512.799 75.088 509.679 74.32L503.295 72.688C500.655 72.064 499.263 71.392 498.015 70.288C496.335 68.704 495.423 66.592 495.423 64.096C495.423 58.864 499.743 55.36 506.223 55.36C511.935 55.36 515.871 58.048 517.647 63.232L514.047 64.24C513.615 62.56 513.087 61.696 512.031 60.784C510.447 59.392 508.287 58.624 506.079 58.624C502.191 58.624 499.311 60.832 499.311 63.856C499.311 66.4 500.799 67.792 504.543 68.704L510.495 70.144C515.967 71.44 518.751 74.416 518.751 78.976C518.751 84.832 514.095 88.624 506.895 88.624C502.863 88.624 499.935 87.616 497.535 85.456C495.855 83.872 494.991 82.48 493.839 79.456ZM533.57 88H529.586V59.488H520.418V55.984H542.738V59.488H533.57V88ZM565.458 55.984H568.77V76.912C568.77 80.56 568.146 82.816 566.61 84.832C564.738 87.328 561.666 88.624 557.634 88.624C553.41 88.624 550.434 87.376 548.658 84.832C547.314 82.864 546.738 80.56 546.738 76.912V55.984H550.722V76.912C550.722 79.888 551.106 81.568 552.018 82.768C553.122 84.208 555.474 85.12 557.97 85.12C560.466 85.12 562.626 84.256 563.874 82.768C565.026 81.424 565.458 79.744 565.458 76.912V55.984ZM598.022 55.984L587.222 88H583.382L572.582 55.984H576.758L585.686 82.384L594.518 55.984H598.022ZM636.523 55.984L628.843 88H624.811L617.851 63.184L611.323 88H607.243L599.131 55.984H603.259L609.691 81.904L616.507 55.984H619.723L627.067 81.904L633.019 55.984H636.523ZM660.973 55.984L651.997 70.624L662.269 88H657.757L649.645 74.368L641.293 88H637.549L647.821 71.44L638.653 55.984H643.117L650.173 67.84L657.325 55.984H660.973ZM688.662 55.984L677.958 74.512V88H673.974V74.512L663.27 55.984H667.974L676.47 70.72L685.014 55.984H688.662ZM713.012 84.592V88H690.452V84.592L707.828 59.488H691.268V56.224H712.484V58.864L694.916 84.592H713.012ZM26.832 133.024V136H4.416V133.024H14.016V108.304C10.992 111.424 8.496 113.392 5.232 115.216V111.184C9.456 108.976 12.48 106.528 14.976 103.36H17.856V133.024H26.832ZM53.3719 132.688V136H30.6679V132.688C37.6759 127.456 37.6759 127.456 41.2279 124.48C47.4679 119.248 49.2919 116.704 49.2919 113.056C49.2919 109.36 46.1719 106.528 42.0919 106.528C39.6439 106.528 37.3879 107.68 35.9479 109.6C34.9879 110.848 34.6039 111.904 34.4119 113.872L30.6679 112.72C31.3879 109.84 32.0599 108.448 33.4999 106.912C35.5639 104.608 38.6359 103.36 42.1399 103.36C48.5239 103.36 53.2759 107.488 53.2759 113.008C53.2759 117.472 51.0679 120.688 44.1559 126.304C41.4199 128.56 38.9239 130.432 35.7079 132.688H53.3719ZM65.6558 120.976V117.76H69.3038C74.0558 117.76 76.7438 115.744 76.7438 112.144C76.7438 108.832 74.0078 106.528 70.0718 106.528C67.8638 106.528 65.7518 107.344 64.3598 108.736C63.5918 109.504 63.1598 110.176 62.5838 111.712L58.9358 110.704C59.9918 108.256 60.8558 107.056 62.5358 105.76C64.6478 104.176 67.3358 103.36 70.4078 103.36C76.4558 103.36 80.8238 106.96 80.8238 111.856C80.8238 115.552 78.5198 118.288 74.6798 119.152C79.3358 120.016 82.0718 122.944 82.0718 127.12C82.0718 132.784 77.1278 136.624 69.9278 136.624C66.5198 136.624 63.8318 135.76 61.4798 133.984C59.6078 132.544 58.7438 131.344 57.7838 128.848L61.5278 127.6C62.1998 129.568 62.7758 130.624 63.7838 131.488C65.1278 132.688 67.4318 133.36 70.0718 133.36C72.7598 133.36 74.8238 132.688 76.0718 131.44C77.2718 130.288 77.8958 128.8 77.8958 127.216C77.8958 123.328 74.6798 120.976 69.3038 120.976H65.6558ZM105.684 136H101.796V128.368H86.0036V125.68L100.644 103.312H105.684V125.2H110.868V128.368H105.684V136ZM101.796 125.2V110.08C101.796 108.736 101.796 108.112 101.892 106.528C101.076 108.016 100.74 108.592 100.164 109.552L90.1796 125.2H101.796ZM136.16 103.984L135.824 107.44H120.08L119.408 117.808C122.192 115.216 124.208 114.304 127.232 114.304C133.472 114.304 138.272 119.104 138.272 125.392C138.272 131.872 133.088 136.624 126.08 136.624C122.672 136.624 119.696 135.52 117.44 133.36C116.048 132.064 115.424 131.056 114.752 129.088L118.16 127.888C119.743 131.68 122.24 133.456 126.08 133.456C131.072 133.456 134.384 130.192 134.384 125.344C134.384 120.832 131.264 117.616 126.848 117.616C123.728 117.616 121.376 118.96 119.312 121.984L116.144 121.312L117.2 103.984H136.16ZM166.587 110.56L162.987 111.52C161.595 108.16 159.531 106.672 156.219 106.672C152.667 106.672 149.979 108.592 148.491 112.192C147.483 114.544 147.051 117.184 147.003 121.504C147.963 119.44 148.635 118.576 149.931 117.472C151.803 115.888 154.203 115.024 156.699 115.024C162.507 115.024 167.067 119.68 167.067 125.584C167.067 131.824 162.123 136.624 155.691 136.624C148.107 136.624 143.307 130.48 143.307 120.736C143.307 115.456 144.699 110.608 147.147 107.44C149.307 104.704 152.331 103.36 156.267 103.36C161.451 103.36 164.811 105.712 166.587 110.56ZM156.027 118.24C151.611 118.24 147.915 121.792 147.915 126.016C147.915 130.144 151.323 133.408 155.643 133.408C159.963 133.408 163.371 130.096 163.371 125.92C163.371 121.6 160.155 118.24 156.027 118.24ZM182.519 136H178.391V135.088C178.391 130.576 179.783 124.528 182.039 119.44C183.815 115.408 186.935 110.512 189.719 107.488H172.343L172.775 103.984H193.895V106.384C191.591 109.072 189.335 112.528 187.367 116.224C184.391 121.84 182.519 129.088 182.519 134.944V136ZM206.515 119.392C202.435 117.616 200.467 115.12 200.467 111.664C200.467 106.72 204.931 103.36 211.507 103.36C217.987 103.36 222.211 106.576 222.211 111.52C222.211 114.88 220.099 117.376 216.019 118.816C218.611 120.064 219.283 120.448 220.435 121.264C222.403 122.704 223.603 125.104 223.603 127.6C223.603 132.976 218.659 136.624 211.363 136.624C204.067 136.624 198.931 132.928 198.931 127.696C198.931 124.096 201.427 121.36 206.515 119.392ZM211.363 117.376C216.595 116.032 218.707 114.256 218.707 111.328C218.707 108.304 215.971 106.384 211.651 106.384C207.331 106.384 204.499 108.352 204.499 111.328C204.499 114.064 207.139 116.368 211.363 117.376ZM210.931 121.072C205.507 122.368 202.867 124.624 202.867 127.888C202.867 131.344 206.179 133.6 211.267 133.6C216.355 133.6 219.667 131.392 219.667 128.08C219.667 124.912 216.979 122.752 210.931 121.072ZM228.111 130.144L231.327 128.992C232.671 132.016 234.831 133.456 237.999 133.456C243.903 133.456 247.167 128.464 247.311 119.152C244.959 123.136 242.079 124.912 237.855 124.912C231.855 124.912 227.343 120.352 227.343 114.352C227.343 108.064 232.191 103.36 238.575 103.36C241.983 103.36 245.055 104.56 247.023 106.624C249.567 109.264 251.055 113.92 251.055 119.248C251.055 124 249.951 128.272 247.887 131.536C245.871 134.752 242.175 136.672 237.999 136.672C235.311 136.672 232.911 135.904 231.087 134.512C229.647 133.36 228.975 132.352 228.111 130.144ZM238.863 106.672C234.303 106.672 231.231 109.744 231.231 114.304C231.231 118.576 234.399 121.696 238.767 121.696C242.991 121.696 246.495 118.24 246.495 114.064C246.495 109.792 243.279 106.672 238.863 106.672ZM267.515 103.36C271.883 103.36 275.195 105.424 277.307 109.456C278.891 112.576 279.755 116.272 279.755 120.16C279.755 123.76 278.795 127.744 277.163 130.72C275.147 134.464 271.691 136.624 267.659 136.624C260.507 136.624 255.515 129.76 255.515 119.92C255.515 115.984 256.331 112.384 257.867 109.456C259.979 105.424 263.291 103.36 267.515 103.36ZM267.515 106.48C262.475 106.48 259.595 111.376 259.595 119.824C259.595 128.416 262.619 133.504 267.707 133.504C270.827 133.504 273.035 131.776 274.331 128.464C275.195 126.208 275.627 123.568 275.627 120.688C275.627 117.136 275.051 113.68 273.995 111.184C272.699 108.112 270.443 106.48 267.515 106.48ZM289.842 130.672V135.472L286.338 142H284.322L287.106 136H284.706V130.672H289.842ZM301.749 130.768V136H296.517V130.768H301.749ZM315.763 112.336V117.52H310.627V112.336H315.763ZM315.763 130.672V135.472L312.211 142H310.291L313.027 136H310.627V130.672H315.763ZM329.031 130.72V136H323.799V130.72H329.031ZM329.031 112.336V117.568H323.799V112.336H329.031ZM342.537 136H337.641V131.056H342.537V136ZM341.001 128.032H339.033L337.305 103.984H342.825L341.001 128.032ZM359.236 131.392V136H354.484V131.392H359.236ZM358.42 128.032H355.06V127.024C355.06 123.664 355.108 123.136 355.636 121.696C356.068 120.784 356.74 120.016 357.604 119.536C358.612 118.96 359.62 118.384 360.676 117.808C362.884 116.56 364.084 114.592 364.084 112.336C364.084 109.024 361.348 106.624 357.604 106.624C355.444 106.624 353.332 107.536 352.132 109.024C351.268 110.176 350.836 111.232 350.308 113.536L346.804 112.816C347.38 109.744 348.1 108.208 349.732 106.48C351.7 104.368 354.292 103.36 357.7 103.36C363.988 103.36 368.212 107.056 368.212 112.48C368.212 116.032 366.34 118.624 362.212 120.832C358.564 122.848 358.372 123.088 358.42 125.92V126.88V128.032ZM396.142 111.568L394.846 122.512C394.75 123.28 394.702 124.144 394.702 124.624C394.702 125.728 395.23 126.256 396.286 126.256C398.734 126.256 401.038 122.224 401.038 117.952C401.038 111.136 395.902 106.24 388.702 106.24C381.022 106.24 375.118 112.24 375.118 119.968C375.118 124.96 377.614 129.472 381.742 131.872C383.806 133.024 386.35 133.648 389.326 133.648C392.83 133.648 395.566 133.024 398.83 131.488C399.166 131.344 399.214 131.296 399.838 131.056L400.846 133.888C396.814 135.856 393.55 136.624 389.374 136.624C385.822 136.624 382.606 135.856 380.014 134.368C375.07 131.488 371.998 126.016 371.998 119.968C371.998 110.608 379.294 103.36 388.702 103.36C397.342 103.36 403.918 109.552 403.918 117.712C403.918 123.952 400.222 129.28 395.854 129.28C393.982 129.28 392.734 128.32 392.062 126.448C390.382 128.608 388.99 129.376 386.782 129.376C382.558 129.376 379.438 125.632 379.438 120.64C379.438 115.264 382.99 111.184 387.694 111.184C389.95 111.184 391.39 111.952 392.734 113.92L393.022 111.568H396.142ZM388.03 114.304C385.198 114.304 383.086 117.088 383.086 120.784C383.086 123.952 384.718 126.256 387.022 126.256C389.71 126.256 392.11 123.04 392.11 119.392C392.11 116.416 390.43 114.304 388.03 114.304ZM432.484 113.392L431.956 116.272H427.06L425.86 122.944H430.756L430.276 125.824H425.332L423.556 136H420.484L422.308 125.824H415.492L413.668 136H410.644L412.468 125.824H407.332L407.86 122.944H412.948L414.148 116.272H409.012L409.54 113.392H414.676L416.308 103.984H419.38L417.7 113.392H424.468L426.148 103.984H429.172L427.492 113.392H432.484ZM423.94 116.272H417.22L416.02 122.944H422.788L423.94 116.272ZM449.136 139.504H446.304V134.992C441.024 134.416 437.712 131.968 436.272 127.648L439.44 126.4C440.592 129.616 443.04 131.536 446.304 131.776V120.88C443.328 120.112 442.272 119.728 440.88 118.912C438.816 117.712 437.568 115.36 437.568 112.768C437.568 109.84 439.104 107.248 441.696 105.904C443.04 105.232 444.096 104.896 446.304 104.56V100.672H449.136V104.56C453.84 104.992 456.72 106.96 458.208 110.704L455.04 111.76C454.224 109.264 452.112 107.824 449.136 107.632V117.664C452.16 118.336 453.216 118.672 454.704 119.44C457.2 120.736 458.832 123.52 458.832 126.4C458.832 129.328 457.104 132.208 454.512 133.6C453.024 134.368 451.824 134.656 449.136 134.992V139.504ZM449.136 121.552V131.776C452.976 131.536 455.232 129.664 455.232 126.688C455.232 125.104 454.416 123.616 453.072 122.8C452.016 122.128 451.152 121.888 449.136 121.552ZM446.304 117.232V107.632C442.896 108.016 440.976 109.696 440.976 112.336C440.976 114.976 442.656 116.512 446.304 117.232ZM492.428 132.64V136C490.604 136.288 489.98 136.336 488.924 136.336C486.859 136.336 486.236 136 483.596 133.456C480.572 135.856 478.46 136.624 475.148 136.624C468.908 136.624 464.252 132.592 464.252 127.12C464.252 122.656 467.228 119.152 472.556 117.328C470.396 114.16 469.484 112.048 469.484 110.08C469.484 106.192 472.508 103.36 476.684 103.36C481.052 103.36 484.076 106.144 484.076 110.176C484.076 113.776 482.252 116.032 477.356 118.48L484.076 128.704C486.38 125.776 487.676 122.752 488.444 118.48L491.852 119.2C491.228 122.992 488.492 128.608 485.948 131.2C487.196 132.496 488.012 132.832 489.5 132.832C490.124 132.832 490.7 132.784 492.428 132.64ZM481.772 131.056L474.092 119.728C469.676 121.744 468.236 123.52 468.236 126.928C468.236 128.656 468.668 130.096 469.532 131.152C470.732 132.64 473.084 133.6 475.484 133.6C478.076 133.6 479.66 132.976 481.772 131.056ZM475.724 116.176C476.348 115.84 476.876 115.504 477.164 115.36C479.996 113.728 481.052 112.384 481.052 110.416C481.052 108.112 479.228 106.336 476.828 106.336C474.572 106.336 472.892 107.872 472.892 109.888C472.892 111.424 473.324 112.384 475.724 116.176ZM502.507 103.648C506.491 103.648 509.179 107.008 509.179 112.048C509.179 116.848 506.443 120.304 502.603 120.304C498.715 120.304 495.979 116.896 495.979 111.952C495.979 106.96 498.571 103.648 502.507 103.648ZM502.507 105.472C499.915 105.472 498.475 107.776 498.475 111.856C498.475 116.032 500.011 118.432 502.651 118.432C505.099 118.432 506.635 116.128 506.635 112.288C506.635 108.016 505.099 105.472 502.507 105.472ZM503.323 136H500.347L519.739 103.984H522.667L503.323 136ZM520.411 119.68C524.395 119.68 527.035 123.04 527.035 128.08C527.035 132.88 524.299 136.336 520.459 136.336C516.571 136.336 513.883 132.928 513.883 127.984C513.883 122.992 516.475 119.68 520.411 119.68ZM520.363 121.504C517.819 121.504 516.331 123.808 516.331 127.888C516.331 132.064 517.867 134.464 520.507 134.464C523.003 134.464 524.539 132.16 524.539 128.32C524.539 124 523.003 121.504 520.363 121.504ZM533.166 104.224L534.606 101.392L543.87 106.768L542.91 108.64L533.166 104.224ZM557.406 123.664L555.294 122.272C557.166 118.288 559.038 116.704 561.87 116.704C563.214 116.704 564.942 117.232 567.246 118.336C569.502 119.392 570.798 119.824 571.902 119.824C573.678 119.824 574.782 119.008 576.222 116.608L578.382 117.904C577.374 119.824 576.654 120.832 575.694 121.744C574.734 122.656 573.054 123.328 571.758 123.328C570.27 123.328 568.926 122.896 565.806 121.408C564.174 120.64 562.59 120.16 561.582 120.16C559.998 120.16 558.846 121.12 557.406 123.664ZM603.77 118.528H599.882L592.922 106.72L586.01 118.528H582.122L590.57 103.888H595.322L603.77 118.528ZM618.074 112.816L617.162 103.984H620.81L619.898 112.816L628.202 109.168L629.306 112.528L620.234 114.352L626.234 120.928L623.306 122.992L618.986 115.408L614.666 122.992L611.738 120.928L617.738 114.352L608.666 112.528L609.77 109.168L618.074 112.816ZM11.856 192.016H9.408C4.8 185.968 2.496 179.296 2.496 172C2.496 164.944 4.8 158.272 9.36 151.984H11.808C7.776 158.272 5.904 164.512 5.904 171.808C5.904 179.104 7.776 185.44 11.856 192.016ZM15.9893 151.984H18.4373C23.0453 158.032 25.3493 164.704 25.3493 172C25.3493 179.056 23.0453 185.728 18.4853 192.016H16.0373C20.0693 185.728 21.9413 179.488 21.9413 172.192C21.9413 164.896 20.0693 158.56 15.9893 151.984ZM39.9398 192.016H31.6358V151.984H39.9398V154.384H34.8518V189.472H39.9398V192.016ZM43.8743 151.984H52.1783V192.016H43.8743V189.616H48.9622V154.528H43.8743V151.984ZM64.7048 158.656V166.768C64.7048 169.696 63.9848 170.944 61.7288 172.048C63.9368 173.104 64.7048 174.544 64.7048 177.424V185.2C64.7048 188.608 65.5688 189.472 69.1208 189.52V192.016H68.1128C63.3128 192.016 61.4888 190.144 61.4888 185.152V177.472C61.4888 174.832 60.7688 173.632 58.7528 173.104V170.8C60.7208 170.272 61.4888 169.072 61.4888 166.576V158.272C61.4888 153.856 63.4568 151.984 68.1128 151.984H69.1208V154.48C65.6648 154.528 64.7048 155.44 64.7048 158.656ZM76.6729 185.344V177.232C76.6729 174.304 77.3929 173.056 79.6489 171.952C77.4409 170.896 76.6729 169.456 76.6729 166.576V158.8C76.6729 155.392 75.8089 154.528 72.2569 154.48V151.984H73.2649C78.0649 151.984 79.8889 153.856 79.8889 158.848V166.528C79.8889 169.168 80.6089 170.368 82.6249 170.896V173.2C80.6569 173.728 79.8889 174.928 79.8889 177.424V185.728C79.8889 190.144 77.9209 192.016 73.2649 192.016H72.2569V189.52C75.7129 189.472 76.6729 188.56 76.6729 185.344ZM85.3594 187.168H109.359V190.384H85.3594V187.168ZM112.239 162.208H134.655V165.424H112.239V162.208ZM112.239 169.792H134.655V173.008H112.239V169.792ZM148.859 170.56V173.44H138.251V170.56H148.859ZM152.411 166.336H161.867V156.496H165.371V166.336H174.827V169.6H165.371V179.44H161.867V169.6H152.411V166.336ZM201.703 156.832V160.384L184.759 168.16L201.703 175.888V179.488L180.919 169.696V166.576L201.703 156.832ZM210.051 179.488V175.888L226.995 168.16L210.051 160.384V156.832L230.835 166.576V169.696L210.051 179.488ZM234.911 192.016H231.791L251.087 151.984H254.255L234.911 192.016ZM276.724 192.016L257.428 151.984H260.548L279.892 192.016H276.724ZM287.865 151.984H291.465V192.016H287.865V151.984ZM307.161 164.368H304.857L304.137 151.984H307.881L307.161 164.368ZM315.833 164.368H313.529L312.809 151.984H316.553L315.833 164.368ZM322.312 164.368H319.961L319.289 151.984H323.033L322.312 164.368Z" fill="#111111"/>
					</svg>`,
                    letter_gothic: `<svg width="1000" height="200" viewBox="0 0 1000 200" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M7.536 18.736L6.72 15.568C9.168 14.608 11.424 13.792 14.112 13.792C19.008 13.792 21.984 17.824 21.984 22.096V33.232C21.984 35.584 22.32 37.984 23.088 40.192L19.728 40.624L18.816 37.408C17.088 39.472 15.12 40.528 12.432 40.528C7.536 40.528 4.8 36.688 4.8 32.128C4.8 27.184 7.824 22.864 13.008 22.864C14.928 22.864 16.752 23.44 18.384 24.112V21.664C18.384 18.832 16.656 16.816 13.968 16.816C11.712 16.816 9.6 17.872 7.536 18.736ZM18.384 33.088V27.136C16.848 26.464 15.216 25.888 13.488 25.888C9.84 25.888 8.4 29.056 8.4 32.32C8.4 34.72 9.648 37.504 12.432 37.504C15.216 37.504 16.896 35.152 18.384 33.088ZM34.2533 4.384H37.8533V15.232C39.6773 14.272 41.2133 13.792 43.3253 13.792C47.4533 13.792 53.7893 17.152 53.7893 26.944C53.7893 37.024 47.9813 40.528 43.4693 40.528C40.4933 40.528 39.3413 39.52 37.1813 37.6L36.4133 40.48L33.0053 40.048C34.0613 37.024 34.2533 33.76 34.2533 30.496V4.384ZM37.8533 18.88V32.992C38.9573 35.344 40.4933 37.504 43.4213 37.504C45.7733 37.504 50.1893 35.488 50.1893 27.088C50.1893 19.936 46.5893 16.816 42.7493 16.816C40.9733 16.816 39.2933 17.728 37.8533 18.88ZM80.1225 33.28L82.5705 35.824C79.9785 38.608 77.3865 40.528 73.4025 40.528C68.6505 40.528 62.3145 37.6 62.3145 27.424C62.3145 17.152 68.1225 13.792 73.2585 13.792C77.4825 13.792 80.4585 16.096 82.7145 19.504L79.5945 21.568C78.2985 18.976 76.4265 16.816 73.2585 16.816C69.6105 16.816 65.9145 19.504 65.9145 27.088C65.9145 35.104 70.0425 37.504 73.3545 37.504C76.1865 37.504 78.3945 35.344 80.1225 33.28ZM110.824 40.096L107.416 40.528L106.648 37.648C104.488 39.568 103.336 40.528 100.36 40.528C95.8478 40.528 90.0878 37.072 90.0878 26.992C90.0878 17.2 96.3278 13.792 100.504 13.792C102.664 13.792 104.152 14.32 105.928 15.28V4.384H109.528V30.832C109.528 34 109.816 37.168 110.824 40.096ZM105.928 33.088V18.928C104.536 17.776 102.904 16.816 101.08 16.816C97.2398 16.816 93.6878 20.032 93.6878 27.136C93.6878 35.488 98.0558 37.504 100.456 37.504C103.24 37.504 104.968 35.44 105.928 33.088ZM139.989 28.096H122.901C123.093 35.152 126.261 37.504 130.197 37.504C133.029 37.504 135.861 36.208 138.213 34.768L139.749 37.984C136.533 39.424 133.461 40.528 129.909 40.528C122.325 40.528 119.301 34 119.301 27.328C119.301 20.608 122.421 13.792 130.101 13.792C138.645 13.792 139.989 23.344 139.989 26.128V28.096ZM122.853 25.072H136.389C136.245 20.848 133.845 16.816 129.813 16.816C125.781 16.816 123.813 19.888 122.853 25.072ZM169.586 6.544V10.192C167.57 9.328 165.266 7.792 163.058 7.792C159.89 7.792 158.498 9.76 158.498 13.072V15.952H166.754V18.976H158.498V40H154.898V18.976H148.514V15.952H154.898V13.504C154.898 7.408 159.026 4.768 162.818 4.768C165.17 4.768 167.474 5.584 169.586 6.544ZM193.76 13.792H197.168C196.304 16.912 196.064 20.128 196.064 23.392V37.504C196.064 45.52 190.208 47.824 186.512 47.824C183.488 47.824 180.368 46.096 178.352 43.888L180.896 41.68C182.336 43.552 184.544 44.8 186.944 44.8C190.736 44.8 192.464 41.344 192.464 37.696V35.68C190.496 36.976 188.864 37.84 186.32 37.84C180.032 37.84 177.008 31.84 177.008 26.272C177.008 20.176 179.696 13.792 186.799 13.792C189.248 13.792 191.12 14.608 193.088 16.048L193.76 13.792ZM192.464 31.456V19.984C191.312 18.256 189.056 16.816 186.848 16.816C182.096 16.816 180.608 21.904 180.608 25.84C180.608 30.832 183.008 34.816 186.512 34.816C188.72 34.816 191.36 33.328 192.464 31.456ZM207.133 40V4.384H210.733V18.016C212.557 15.568 215.293 13.792 218.461 13.792C221.533 13.792 225.085 14.752 225.085 25.264V40H221.485V24.976C221.485 22.624 221.485 16.816 218.221 16.816C215.533 16.816 213.133 19.216 212.029 21.472C210.637 24.352 210.733 27.232 210.733 30.448V40H207.133ZM243.498 40V17.344H236.202V14.32H247.098V40H243.498ZM245.178 4.768C246.858 4.768 248.202 6.064 248.202 7.792C248.202 9.52 246.858 10.816 245.178 10.816C243.498 10.816 242.154 9.52 242.154 7.792C242.154 6.064 243.498 4.768 245.178 4.768ZM262.535 37.504H266.135C266.135 42.256 267.095 44.8 270.647 44.8C273.959 44.8 275.255 41.152 275.255 39.664V17.344H267.815V14.32H278.855V39.472C278.855 45.184 274.295 47.824 270.695 47.824C265.175 47.824 262.535 43.744 262.535 37.504ZM276.791 4.768C278.471 4.768 279.767 6.064 279.767 7.792C279.767 9.52 278.471 10.816 276.791 10.816C275.063 10.816 273.719 9.52 273.719 7.792C273.719 6.064 275.111 4.768 276.791 4.768ZM307.781 14.32H312.341C307.253 20.224 305.765 22.24 301.973 26.08L314.597 40H309.845L299.765 28.192L298.133 29.824V40H294.533V4.384H298.133V25.552C301.541 22.048 305.045 18.448 307.781 14.32ZM329.458 40V7.408H322.162V4.384H333.058V40H329.458ZM348.639 40V22.288C348.639 18.784 348.159 16.48 347.583 13.792H351.183L351.711 16.096C353.247 14.752 354.591 13.792 356.751 13.792C359.103 13.792 359.727 14.368 361.119 16.144C362.607 14.8 363.951 13.792 366.063 13.792C369.519 13.792 371.727 16.048 371.727 19.504V40H368.127V19.504C368.127 17.776 367.215 16.816 365.775 16.816C364.143 16.816 362.751 18.16 361.983 19.504V40H358.383V19.744C358.383 18.4 357.999 16.816 356.367 16.816C354.639 16.816 352.911 18.352 352.239 19.936V40H348.639ZM383.084 29.296V40H379.484V27.088C379.484 22.768 379.292 18.4 378.332 14.32H381.788L382.604 19.024C384.428 16 387.74 13.792 391.34 13.792C395.42 13.792 397.532 17.536 397.532 21.904V40H393.932V22.96C393.932 20.512 393.932 16.816 390.764 16.816C387.356 16.816 383.084 20.272 383.084 29.296ZM417.338 40.528C412.874 40.528 407.162 37.552 407.162 27.184C407.162 17.248 412.442 13.792 417.338 13.792C426.41 13.792 427.562 23.008 427.562 27.184C427.562 37.12 422.282 40.528 417.338 40.528ZM417.338 37.504C422.954 37.504 423.962 31.6 423.962 27.184C423.962 22.768 422.954 16.816 417.338 16.816C411.722 16.816 410.762 22.768 410.762 27.184C410.762 31.6 411.722 37.504 417.338 37.504ZM439.399 13.84L440.119 16.672C442.279 14.752 443.431 13.792 446.407 13.792C450.919 13.792 456.727 17.248 456.727 27.328C456.727 37.072 450.391 40.528 446.263 40.528C444.151 40.528 442.615 40 440.791 39.04V49.84H437.191V23.776C437.191 20.512 436.999 17.392 435.991 14.272L439.399 13.84ZM440.791 21.28V35.392C442.231 36.544 443.911 37.504 445.687 37.504C449.911 37.504 453.127 33.856 453.127 27.184C453.127 18.784 448.711 16.816 446.359 16.816C443.431 16.816 441.895 18.928 440.791 21.28ZM483.684 49.84H480.084V39.04C478.308 40 476.82 40.528 474.66 40.528C470.484 40.528 464.196 37.12 464.196 27.328C464.196 17.248 470.004 13.792 474.516 13.792C477.492 13.792 478.644 14.752 480.804 16.672L481.524 13.84L484.932 14.272C483.972 17.296 483.684 20.32 483.684 23.488V49.84ZM480.084 35.392V21.04C478.836 18.736 477.444 16.816 474.612 16.816C472.212 16.816 467.796 18.784 467.796 27.184C467.796 33.856 471.012 37.504 475.236 37.504C477.06 37.504 478.692 36.544 480.084 35.392ZM500.417 29.296V40H496.817V25.264C496.817 20.992 496.481 17.536 495.809 14.32H499.313L500.129 19.216C502.097 16.192 504.257 13.792 508.097 13.792C512.897 13.792 514.049 18.496 514.049 22.384H510.449C510.353 20.464 510.641 16.816 507.905 16.816C505.265 16.816 500.417 20.848 500.417 29.296ZM540.335 16.768L538.751 19.696C536.735 18.256 534.479 16.816 531.887 16.816C529.727 16.816 527.711 18.4 527.711 20.704C527.711 23.2 530.687 24.448 532.655 25.168C536.687 26.656 540.911 28.336 540.911 33.424C540.911 37.648 537.071 40.528 533.087 40.528C529.199 40.528 525.359 38.608 522.527 36.064L524.495 33.184C526.511 35.344 529.823 37.504 532.847 37.504C535.247 37.504 537.311 36.16 537.311 33.568C537.311 30.208 534.623 29.296 531.983 28.288C528.335 26.896 524.111 25.168 524.111 20.56C524.111 16.816 527.567 13.792 532.031 13.792C535.247 13.792 537.791 14.944 540.335 16.768ZM569.02 14.32V17.344H559.852V31.984C559.852 34.48 559.9 37.504 563.164 37.504C565.9 37.504 567.58 35.248 568.588 32.992L572.044 33.856C570.316 37.552 567.388 40.528 563.068 40.528C558.892 40.528 556.252 38.512 556.252 30.832V17.344H550.732V14.32H556.252V6.448H559.852V14.32H569.02ZM595.545 24.832V14.32H599.145V26.752C599.145 31.216 599.241 35.632 600.249 40H596.841L596.025 35.056C594.345 37.888 590.889 40.528 587.577 40.528C583.017 40.528 581.097 36.64 581.097 32.176V14.32H584.697V31.12C584.697 33.52 584.697 37.504 587.865 37.504C591.417 37.504 595.545 33.52 595.545 24.832ZM624.998 14.32H628.742L620.774 40.336H616.694L608.726 14.32H612.47L618.71 34.24L624.998 14.32ZM639.38 40.336L634.868 14.32H638.9L641.828 33.568H641.924L645.62 20.608H649.124L652.82 33.568H652.916L655.844 14.32H659.876L655.364 40.336H651.524L647.348 26.416L643.22 40.336H639.38ZM686.305 14.32L678.337 26.128L688.465 40H683.905L676.321 28.912L668.833 40H664.273L674.353 26.272L666.193 14.32H670.369L676.369 23.344L682.225 14.32H686.305ZM712.11 14.32H715.95L706.446 38.416C705.006 42.112 702.702 47.824 697.998 47.824C694.686 47.824 692.382 45.28 691.47 42.256L694.494 40.672C695.07 42.208 696.078 44.8 697.998 44.8C700.014 44.8 701.214 42.016 701.886 40.48L703.566 36.592L695.31 14.32H699.198L705.438 31.792L712.11 14.32ZM743.339 14.32V17.008L728.603 36.976H743.915V40H723.947V37.36L738.779 17.344H726.059V14.32H743.339ZM14.448 50.56L26.688 88H22.8L19.728 77.824H9.216L6.144 88H2.256L14.448 50.56ZM14.448 60.832L10.08 74.8H18.864L14.448 60.832ZM43.8533 88H33.9653V53.44H41.2133C45.1973 53.44 52.0613 53.92 52.0613 62.176C52.0613 65.488 50.3333 68.032 47.5013 69.616C51.4373 71.536 53.5493 74.128 53.5493 78.592C53.5493 83.632 49.9013 88 43.8533 88ZM37.5653 56.464V68.512H41.7413C44.9573 68.512 48.4613 66.16 48.4613 62.032C48.4613 56.32 43.6613 56.464 41.4532 56.464H37.5653ZM37.5653 84.976H43.6133C46.7813 84.976 49.9493 83.104 49.9493 78.784C49.9493 74.944 47.5493 71.536 42.0773 71.536H37.5653V84.976ZM81.8025 60.928H78.2025C78.1545 58.048 76.0905 55.792 73.1625 55.792C65.8665 55.792 65.3865 65.68 65.3865 71.008C65.3865 76.048 65.9145 85.648 72.8265 85.648C76.4265 85.648 78.5865 82.96 78.6345 79.552H82.2345C81.8505 85.168 78.4425 88.672 72.6825 88.672C63.1785 88.672 61.7865 78.256 61.7865 70.912C61.7865 63.328 63.3705 52.768 73.1145 52.768C77.9145 52.768 81.5145 56.128 81.8025 60.928ZM91.7198 88V53.44H100.504C107.176 53.44 111.64 57.232 111.64 70.72C111.64 84.016 107.512 88 99.9758 88H91.7198ZM95.3198 56.464V84.976H99.7358C104.728 84.976 108.04 83.584 108.04 70.72C108.04 57.472 104.248 56.464 99.6398 56.464H95.3198ZM139.749 53.44V56.464H125.397V68.752H135.717V71.776H125.397V84.976H140.085V88H121.797V53.44H139.749ZM169.73 53.44V56.464H154.802V68.464H165.986V71.488H154.802V88H151.202V53.44H169.73ZM194.624 73.744H186.464V70.72H198.224V88.672H194.624V85.312C192.848 87.472 190.208 88.672 187.376 88.672C184.592 88.672 176.96 88.192 176.96 71.488C176.96 57.808 181.136 52.768 187.856 52.768C193.712 52.768 196.448 56.896 196.544 62.272H192.944C193.232 59.104 191.696 55.792 188.048 55.792C180.848 55.792 180.56 65.824 180.56 70.96C180.56 75.76 180.8 85.648 187.568 85.648C190.928 85.648 194.624 82.96 194.624 76.048V73.744ZM209.869 53.44V68.56H221.869V53.44H225.469V88H221.869V71.584H209.869V88H206.269V53.44H209.869ZM251.13 53.44V56.464H246.426V84.976H251.13V88H238.17V84.976H242.826V56.464H238.17V53.44H251.13ZM271.607 56.464V53.44H281.591V76.048C281.591 80.848 281.207 88.672 271.799 88.672C266.183 88.672 262.631 85.504 262.631 78.016V73.168H266.231V79.36C266.231 83.344 268.151 85.648 271.703 85.648C275.831 85.648 277.991 83.296 277.991 78.352V56.464H271.607ZM297.605 53.44V68.656C300.101 68.368 306.005 62.368 309.365 53.008L312.917 54.88L310.085 59.632C305.525 67.264 303.173 69.184 300.965 70.576L315.893 88H311.093L297.893 71.728H297.605V88H294.005V53.44H297.605ZM327.634 53.44V84.976H342.61V88H324.034V53.44H327.634ZM359.775 70.672L367.023 53.44H370.575V88H366.975V61.696H366.879L359.775 78.64L352.719 61.696L352.623 61.792V88H349.023V53.44H352.527L359.775 70.672ZM379.676 88V53.44H383.852L394.364 79.264H394.508V53.44H398.108V88.336H394.7L383.372 60.448L383.276 60.544V88H379.676ZM406.73 70.72C406.73 56.272 411.53 52.768 417.338 52.768C427.418 52.768 427.946 64.288 427.946 70.72C427.946 75.328 428.281 88.672 417.338 88.672C406.682 88.672 406.73 75.616 406.73 70.72ZM417.338 85.648C420.938 85.648 424.346 83.248 424.346 70.72C424.346 67.552 424.826 55.792 417.338 55.792C409.658 55.792 410.33 68.704 410.33 70.72C410.33 74.656 410.138 85.648 417.338 85.648ZM438.151 88V53.44H446.455C452.695 53.44 456.343 57.184 456.343 64C456.343 71.296 451.543 74.416 444.775 74.416H441.751V88H438.151ZM441.751 71.392H445.735C449.911 71.392 452.743 68.896 452.743 64.048C452.743 58.624 450.247 56.464 445.975 56.464H441.751V71.392ZM474.9 88.672C463.956 88.672 464.244 75.136 464.244 70.72C464.244 56.224 469.092 52.768 474.9 52.768C486.228 52.768 485.556 67.264 485.556 70.72C485.556 77.104 485.076 82.048 482.1 85.408L486.324 90.88H481.908L479.508 87.52C478.116 88.288 476.484 88.672 474.9 88.672ZM467.844 70.72C467.844 83.008 471.3 85.648 474.9 85.648C479.124 85.648 481.956 82.048 481.956 70.72C481.956 58.432 478.548 55.792 474.9 55.792C467.028 55.792 467.844 69.28 467.844 70.72ZM495.569 88V53.44H504.545C513.185 53.44 513.953 61.216 513.953 63.232C513.953 66.784 512.609 70.048 507.809 72.784L517.121 88H512.753L504.353 73.6C502.625 73.648 500.897 73.648 499.169 73.696V88H495.569ZM499.169 70.624H502.577C507.473 70.624 510.353 68.128 510.353 63.04C510.353 58.432 508.433 56.464 502.721 56.464H499.169V70.624ZM542.159 57.088L539.999 59.68C537.887 57.808 535.487 55.792 532.511 55.792C529.439 55.792 526.943 57.904 526.943 61.072C526.943 62.896 527.279 64.528 531.935 67.36L534.671 69.04C541.007 72.928 542.734 74.752 542.734 78.784C542.734 84.976 538.607 88.672 532.559 88.672C528.095 88.672 524.783 86.512 522.095 83.056L524.879 80.848C526.559 83.536 529.247 85.648 532.559 85.648C536.159 85.648 539.135 82.96 539.135 79.264C539.135 76.48 538.943 75.52 532.847 71.872L529.727 70C526.319 67.984 523.343 65.632 523.343 61.312C523.343 55.888 527.471 52.768 532.655 52.768C536.255 52.768 539.567 54.688 542.159 57.088ZM572.812 53.44V56.464H562.972V88H559.372V56.464H549.724V53.44H572.812ZM595.977 53.44H599.577V78.928C599.577 85.456 594.681 88.672 590.025 88.672C586.281 88.672 580.425 86.56 580.425 77.008V53.44H584.025V78.928C584.025 83.92 587.241 85.648 590.025 85.648C594.441 85.648 595.977 82.384 595.977 78.496V53.44ZM618.662 82.768L624.854 53.44H628.838L621.014 88.336H616.07L608.39 53.44H612.326L618.566 82.768H618.662ZM647.444 63.088L652.868 80.416H652.964L654.692 53.44H658.58L655.94 88.336H651.812L647.444 73.36L643.028 88.336H639.044L636.164 53.44H640.052L641.876 80.416H641.972L647.444 63.088ZM666.385 53.44H670.513L676.369 66.832L682.225 53.44H686.401L678.241 70.576L686.641 88H682.465L676.369 74.176L670.273 88H666.145L674.593 70.528L666.385 53.44ZM704.286 69.088L710.91 53.44H714.894L706.062 73.408V88H702.462V73.408L693.63 53.44H697.614L704.286 69.088ZM725.003 53.44H743.003V55.984L728.795 84.976H744.155V88H724.475V85.408L738.875 56.464H725.003V53.44ZM16.368 100.384V132.976H22.56V136H6.288V132.976H12.768V104.32L6 106.384V103.648L16.368 100.384ZM37.1813 132.976H52.9253V136H33.5813V134.464C33.5813 126.88 36.7013 123.52 42.1253 118.864C44.8613 116.56 49.2293 113.056 49.2293 109.168C49.2293 105.952 47.3573 103.792 44.0933 103.792C39.8693 103.792 38.0453 107.248 37.8533 110.992H34.2533C34.5893 105.136 37.9493 100.768 44.1413 100.768C49.2293 100.768 52.8293 103.888 52.8293 109.12C52.8293 114.304 48.6053 117.52 45.1013 120.688L42.6053 122.944C39.4853 125.776 37.3733 128.56 37.1813 132.976ZM69.4665 119.008V115.984C73.3545 116.176 77.0025 113.632 77.0025 109.504C77.0025 106.096 74.2185 103.792 71.0025 103.792C68.0265 103.792 65.5785 106.24 64.4265 108.784L61.4025 107.056C63.4185 103.168 66.9705 100.768 71.3865 100.768C76.4745 100.768 80.6025 104.704 80.6025 109.792C80.6025 113.056 78.7305 115.552 76.0425 117.232C79.8825 118.912 82.1865 122.032 82.1865 126.304C82.1865 132.688 77.4825 136.672 71.2425 136.672C66.3945 136.672 63.3225 134.08 60.9225 130.096L64.0905 128.224C65.5305 131.488 67.6425 133.648 71.3865 133.648C75.5625 133.648 78.5865 131.056 78.5865 126.784C78.5865 121.264 74.5545 118.528 69.4665 119.008ZM106.648 100.768V124.048H111.592V127.072H106.648V136H103.048V127.072H89.2718V124.72L101.992 100.768H106.648ZM103.048 124.048V105.664H102.952L93.3997 124.048H103.048ZM137.205 101.44V104.464H124.965L124.005 116.56C125.637 115.072 127.557 114.352 129.765 114.352C135.093 114.352 139.365 118.48 139.365 125.392C139.365 131.344 135.573 136.672 129.237 136.672C125.109 136.672 122.085 134.176 119.925 130.912L122.709 128.848C124.005 131.44 126.453 133.648 129.477 133.648C133.605 133.648 135.765 129.328 135.765 125.68C135.765 119.872 132.501 117.376 129.861 117.376C127.125 117.376 125.301 119.104 123.957 121.312L120.309 120.592L121.749 101.44H137.205ZM164.834 124.768C164.834 121.024 163.298 116.992 158.93 116.992C155.042 116.992 152.306 121.408 152.306 125.584C152.306 129.184 154.034 133.648 158.258 133.648C163.106 133.648 164.834 128.896 164.834 124.768ZM168.05 102.88L166.322 105.856C164.834 104.848 163.346 103.792 161.426 103.792C155.378 103.792 152.306 112.528 152.066 117.472C154.13 115.168 156.194 113.968 159.41 113.968C165.362 113.968 168.434 119.344 168.434 124.72C168.434 130.624 165.074 136.672 158.498 136.672C150.098 136.672 148.466 127.984 148.466 121.312C148.466 107.008 155.138 100.768 161.57 100.768C163.826 100.768 166.13 101.68 168.05 102.88ZM177.152 101.44H196.544L183.056 136H179.168L191.84 104.464H177.152V101.44ZM208.429 126.592C208.429 131.104 211.501 133.648 215.869 133.648C220.237 133.648 223.309 131.104 223.309 126.592C223.309 122.128 220.189 119.536 215.869 119.536C211.549 119.536 208.429 122.128 208.429 126.592ZM222.109 110.128C222.109 106.288 219.805 103.792 215.869 103.792C211.741 103.792 209.581 106.48 209.581 110.512C209.581 114.208 212.269 116.512 215.869 116.512C219.757 116.512 222.109 114.016 222.109 110.128ZM221.725 117.904C225.229 119.248 226.909 123.04 226.909 126.592C226.909 132.208 223.165 136.672 215.869 136.672C208.189 136.672 204.829 131.872 204.829 126.592C204.829 123.04 206.509 119.248 210.013 117.904C207.229 115.504 205.981 113.632 205.981 109.84C205.981 104.176 210.445 100.768 215.869 100.768C221.581 100.768 225.709 104.272 225.709 110.176C225.709 113.776 224.365 115.648 221.725 117.904ZM238.074 112.672C238.074 116.416 239.658 120.448 243.978 120.448C247.866 120.448 250.65 116.08 250.65 111.808C250.65 108.256 248.874 103.792 244.698 103.792C239.85 103.792 238.074 108.544 238.074 112.672ZM234.906 134.56L236.634 131.584C237.978 132.544 239.802 133.648 241.53 133.648C247.578 133.648 250.602 124.912 250.89 119.92C248.778 122.272 246.762 123.472 243.546 123.472C237.594 123.472 234.474 118.096 234.474 112.72C234.474 106.816 237.882 100.768 244.458 100.768C252.858 100.768 254.49 109.456 254.49 116.128C254.49 129.712 248.25 136.672 241.386 136.672C239.082 136.672 236.826 135.76 234.906 134.56ZM283.463 118.72C283.463 123.52 283.607 136.672 273.431 136.672C263.351 136.672 263.399 122.752 263.399 118.72C263.399 116.704 262.583 100.768 273.431 100.768C283.415 100.768 283.463 113.728 283.463 118.72ZM266.999 118.72C266.999 123.136 266.903 133.648 273.431 133.648C276.599 133.648 279.863 131.392 279.863 118.72C279.863 106.48 276.887 103.792 273.431 103.792C266.615 103.792 266.999 115.456 266.999 118.72ZM298.949 141.376V138.112C300.101 137.872 301.157 137.392 302.021 136.576C300.245 136.432 298.853 135.088 298.853 133.264C298.853 131.056 300.484 129.52 302.645 129.52C305.045 129.52 306.629 131.632 306.629 133.888C306.629 137.92 302.453 140.56 298.949 141.376ZM327.154 132.928C327.154 130.816 328.978 129.232 331.042 129.232C333.106 129.232 334.882 130.816 334.882 132.928C334.882 135.04 333.106 136.672 331.042 136.672C328.93 136.672 327.154 135.04 327.154 132.928ZM356.511 141.376V138.112C357.663 137.872 358.719 137.392 359.583 136.576C357.807 136.432 356.415 135.088 356.415 133.264C356.415 131.056 358.047 129.52 360.207 129.52C362.607 129.52 364.191 131.632 364.191 133.888C364.191 137.92 360.015 140.56 356.511 141.376ZM356.415 116.656C356.415 114.544 358.239 112.96 360.303 112.96C362.367 112.96 364.143 114.544 364.143 116.656C364.143 118.768 362.367 120.4 360.303 120.4C358.191 120.4 356.415 118.768 356.415 116.656ZM384.716 132.928C384.716 130.816 386.54 129.232 388.604 129.232C390.668 129.232 392.444 130.816 392.444 132.928C392.444 135.04 390.668 136.672 388.604 136.672C386.492 136.672 384.716 135.04 384.716 132.928ZM384.716 116.656C384.716 114.544 386.54 112.96 388.604 112.96C390.668 112.96 392.444 114.544 392.444 116.656C392.444 118.768 390.668 120.4 388.604 120.4C386.492 120.4 384.716 118.768 384.716 116.656ZM419.69 101.44L419.018 125.488H415.802L414.986 101.44H419.69ZM413.498 132.928C413.498 130.816 415.322 129.232 417.386 129.232C419.45 129.232 421.226 130.816 421.226 132.928C421.226 135.04 419.45 136.672 417.386 136.672C415.273 136.672 413.498 135.04 413.498 132.928ZM447.655 125.632H444.055V120.544C444.055 117.664 444.919 116.56 448.327 114.016C450.055 112.672 450.919 111.52 450.919 109.216C450.919 106.048 449.047 103.792 445.783 103.792C442.519 103.792 440.791 106.048 440.791 109.072H437.191C437.431 103.984 440.695 100.768 445.831 100.768C451.111 100.768 454.519 104.032 454.519 109.36C454.519 112.48 453.415 114.112 451.447 115.84C448.615 118.384 447.655 118.24 447.655 120.544V125.632ZM442.375 132.928C442.375 130.816 444.199 129.232 446.263 129.232C448.327 129.232 450.103 130.816 450.103 132.928C450.103 135.04 448.327 136.672 446.263 136.672C444.151 136.672 442.375 135.04 442.375 132.928ZM485.364 129.424L486.66 132.64C482.82 135.136 478.404 136.672 473.844 136.672C467.316 136.672 460.356 132.16 460.356 121.744C460.356 112.288 465.54 100.768 476.196 100.768C482.964 100.768 489.444 106.864 489.444 115.552C489.444 120.304 487.332 127.36 481.572 127.36C479.46 127.36 478.74 126.736 477.3 125.248C475.716 126.544 474.66 127.36 472.5 127.36C469.764 127.36 467.844 125.44 467.844 122.656C467.844 119.872 469.092 116.128 471.012 113.968C473.028 111.76 476.532 111.424 479.364 111.424H481.524L480.228 119.296C480.132 119.968 479.844 121.312 479.844 121.984C479.844 123.136 480.372 124.336 481.62 124.336C484.932 124.336 485.844 118.384 485.844 115.888C485.844 107.152 479.892 104.368 476.148 104.368C467.604 104.368 463.956 114.304 463.956 121.552C463.956 129.136 467.508 133.072 474.132 133.072C478.356 133.072 481.86 131.68 485.364 129.424ZM477.348 115.888L477.54 114.4C473.844 114.496 471.444 118.432 471.444 122.368C471.444 123.232 471.828 124.336 472.788 124.336C474.228 124.336 476.436 122.896 477.348 115.888ZM501.521 97.36H505.121L497.153 140.608H493.553L496.433 124.96H490.049L490.769 121.792H497.009L498.161 115.456H491.873L492.449 112.288H498.785L501.521 97.36ZM505.649 140.608H502.049L510.017 97.36H513.617L510.881 112.288H517.265L516.641 115.456H510.257L509.105 121.792H515.537L514.961 124.96H508.529L505.649 140.608ZM533.951 120.256V129.808C536.111 129.184 537.551 127.6 537.551 125.296C537.551 122.8 536.591 121.504 533.951 120.256ZM530.734 129.76V118.912C529.055 118.336 527.183 117.376 525.935 116.08C524.735 114.784 523.919 113.152 523.919 111.136C523.919 107.248 527.231 104.56 530.734 103.936V100.384H533.951V103.888C536.447 104.224 539.087 105.52 541.055 107.248L538.943 109.984C537.599 108.64 535.775 107.44 533.951 107.056V116.56C538.943 118.672 541.151 121.216 541.151 125.2C541.151 129.616 538.127 132.304 533.951 132.976V137.44H530.734V132.976C527.855 132.784 525.023 131.248 522.911 129.184L525.118 126.592C526.703 128.08 528.623 129.424 530.734 129.76ZM530.783 115.312V107.2C528.671 107.872 527.519 108.928 527.519 111.232C527.519 112.912 528.335 114.112 530.783 115.312ZM564.892 130.24L558.316 120.256C556.3 122.704 554.236 125.44 554.236 128.752C554.236 131.632 555.82 133.648 558.844 133.648C561.388 133.648 563.5 132.352 564.892 130.24ZM568.732 129.808L572.908 134.56L570.076 136.672L566.812 132.88C564.748 135.328 562.012 136.672 558.844 136.672C554.044 136.672 550.636 133.696 550.636 128.8C550.636 124.048 553.42 120.544 556.396 117.136C554.764 114.496 553.18 111.808 553.18 108.64C553.18 102.832 557.116 100.768 559.516 100.768C563.308 100.768 565.66 103.936 565.66 107.488C565.66 111.664 563.212 114.4 560.668 117.376L566.332 126.496C566.476 125.776 566.572 124.96 566.668 124.096C566.86 122.08 566.86 119.872 566.86 118.336H570.364C570.316 122.176 570.172 126.16 568.732 129.808ZM558.796 114.4C560.284 112.144 562.06 110.128 562.06 107.296C562.06 105.904 561.292 103.792 559.564 103.792C557.5 103.792 556.78 106.528 556.78 108.16C556.78 110.56 557.596 112.384 558.796 114.4ZM598.137 127.168C598.137 125.968 597.801 124.72 596.361 124.72C593.385 124.72 592.329 129.232 592.329 131.584C592.329 132.88 592.665 134.032 594.201 134.032C597.033 134.032 598.137 129.376 598.137 127.168ZM596.985 100.768H600.441L582.297 136.672H578.841L596.985 100.768ZM587.241 105.856C587.241 104.656 586.857 103.408 585.465 103.408C582.441 103.408 581.433 107.92 581.433 110.272C581.433 111.616 581.721 112.72 583.305 112.72C586.137 112.72 587.241 108.064 587.241 105.856ZM588.921 131.104C588.921 126.736 591.465 122.08 596.313 122.08C599.481 122.08 601.545 124 601.545 127.216C601.545 131.632 599.097 136.672 594.105 136.672C590.601 136.672 588.921 134.416 588.921 131.104ZM578.025 109.792C578.025 105.424 580.569 100.768 585.417 100.768C588.585 100.768 590.649 102.688 590.649 105.904C590.649 110.32 588.201 115.36 583.209 115.36C579.705 115.36 578.025 113.104 578.025 109.792ZM614.822 98.8L623.318 105.616L621.494 107.968L612.23 101.776L614.822 98.8ZM641.972 115.168C643.748 115.168 646.004 116.032 648.068 116.944C650.132 117.856 652.052 118.72 653.204 118.72C655.652 118.72 657.668 115.984 658.58 114.016L661.076 115.84C659.588 118.768 656.804 121.888 653.252 121.888C651.332 121.888 648.164 120.448 646.34 119.728C645.092 119.2 643.316 118.336 641.972 118.336C639.14 118.336 637.844 121.36 636.548 123.424L634.052 121.552C635.876 118.432 637.94 115.168 641.972 115.168ZM670.465 118.864H666.913L674.785 103.36H677.953L685.825 118.864H682.273L676.369 107.248L670.465 118.864ZM703.422 101.44H706.83V110.32L715.47 107.776L716.478 110.896L707.598 113.44L713.166 120.448L710.622 122.464L705.15 115.6L699.822 122.464L697.182 120.448L702.702 113.44L693.822 110.896L694.782 107.776L703.422 110.32V101.44ZM19.728 185.392L18 187.744C11.424 183.568 8.4 175.648 8.4 168.064C8.4 160.48 11.424 152.656 18 148.384L19.728 150.784C14.064 154.816 12 161.344 12 168.064C12 174.784 14.064 181.312 19.728 185.392ZM37.8533 150.784L39.5813 148.384C46.1573 152.656 49.1813 160.48 49.1813 168.064C49.1813 175.648 46.1573 183.52 39.5813 187.744L37.8533 185.392C43.5173 181.36 45.5813 174.784 45.5813 168.064C45.5813 161.392 43.5173 154.816 37.8533 150.784ZM79.6425 189.376H65.6265V148.384H79.6425V151.408H69.2265V186.352H79.6425V189.376ZM93.0158 189.376V186.352H103.432V151.408H93.0158V148.384H107.032V189.376H93.0158ZM138.549 148.384V149.728H136.965C132.261 149.728 130.869 151.552 130.869 154.144V162.784C130.869 165.232 130.917 167.152 128.469 168.496C130.917 169.792 130.869 171.712 130.869 174.16V182.8C130.869 185.392 132.261 187.216 136.965 187.216H138.549V188.56H135.909C129.093 188.56 127.269 186.352 127.269 181.072V172.96C127.269 169.072 124.389 169.408 121.557 168.496C124.389 167.536 127.269 167.872 127.269 163.984V155.872C127.269 150.592 129.093 148.384 135.909 148.384H138.549ZM149.378 149.728V148.384H152.018C158.834 148.384 160.658 150.592 160.658 155.872V163.984C160.658 167.872 163.538 167.536 166.37 168.496C163.538 169.408 160.658 169.072 160.658 172.96V181.072C160.658 186.352 158.834 188.56 152.018 188.56H149.378V187.216H150.962C155.666 187.216 157.058 185.392 157.058 182.8V174.16C157.058 171.712 157.01 169.792 159.458 168.496C157.01 167.152 157.058 165.232 157.058 162.784V154.144C157.058 151.552 155.666 149.728 150.962 149.728H149.378ZM201.488 190H172.688V187.6H201.488V190ZM229.069 162.304V165.472H202.669V162.304H229.069ZM229.069 167.968V171.136H202.669V167.968H229.069ZM250.89 168.304H238.41V165.28H250.89V168.304ZM286.631 165.136V168.304H275.111V179.68H271.751V168.304H260.231V165.136H271.751V153.76H275.111V165.136H286.631ZM310.613 149.44L312.629 151.936L296.645 166.72L312.629 181.504L310.613 184L291.749 166.72L310.613 149.44ZM320.53 151.936L322.546 149.44L341.41 166.72L322.546 184L320.53 181.504L336.514 166.72L320.53 151.936ZM354.351 185.296H350.751L365.199 148.144H368.799L354.351 185.296ZM393.98 185.296L379.532 148.144H383.132L397.58 185.296H393.98ZM415.754 197.824V145.984H418.922V197.824H415.754ZM442.807 149.44H449.431V155.68L447.415 161.92H444.823L442.807 155.68V149.44ZM465.924 149.44H472.548V155.68L470.532 161.872H467.94L465.924 155.68V149.44ZM477.252 149.44H483.876V155.68L481.86 161.872H479.268L477.252 155.68V149.44Z" fill="#111111"/>
					</svg>`,
                    fira_mono: `<svg width="1000" height="200" viewBox="0 0 1000 200" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M23.5077 36.3385C23.5077 37.3723 23.68 38.1272 24.0246 38.6031C24.3692 39.079 24.9026 39.4318 25.6246 39.6615L24.6154 42.5662C23.4995 42.4185 22.5231 42.0656 21.6862 41.5077C20.8492 40.9333 20.2421 40.0718 19.8646 38.9231C18.9292 40.121 17.7641 41.0318 16.3692 41.6554C14.9744 42.2626 13.4318 42.5662 11.7415 42.5662C9.14872 42.5662 7.10564 41.8359 5.61231 40.3754C4.11897 38.9149 3.37231 36.9785 3.37231 34.5662C3.37231 31.8913 4.41436 29.84 6.49846 28.4123C8.58256 26.9846 11.5938 26.2708 15.5323 26.2708H19.3477V24.1046C19.3477 22.2338 18.7979 20.9128 17.6985 20.1415C16.6154 19.3538 15.1056 18.96 13.1692 18.96C12.3159 18.96 11.3149 19.0667 10.1662 19.28C9.01744 19.4769 7.77026 19.8133 6.42462 20.2892L5.34154 17.1631C6.93333 16.5723 8.42667 16.1538 9.82154 15.9077C11.2164 15.6615 12.5456 15.5385 13.8092 15.5385C17.0421 15.5385 19.4626 16.2933 21.0708 17.8031C22.6954 19.2964 23.5077 21.3313 23.5077 23.9077V36.3385ZM12.8 39.4154C14.08 39.4154 15.3026 39.0954 16.4677 38.4554C17.6328 37.799 18.5928 36.8964 19.3477 35.7477V29.0769H15.6062C12.7508 29.0769 10.7323 29.5692 9.55077 30.5538C8.38564 31.5385 7.80308 32.8595 7.80308 34.5169C7.80308 36.1251 8.21333 37.3477 9.03385 38.1846C9.87077 39.0051 11.1262 39.4154 12.8 39.4154ZM38.6143 19.4523C39.5661 18.2051 40.6574 17.2451 41.8882 16.5723C43.1354 15.8831 44.5056 15.5385 45.9989 15.5385C48.3128 15.5385 50.1836 16.0964 51.6112 17.2123C53.0389 18.3282 54.081 19.9036 54.7374 21.9385C55.3938 23.9569 55.722 26.32 55.722 29.0277C55.722 31.6369 55.3282 33.9672 54.5405 36.0185C53.7528 38.0533 52.5959 39.6533 51.0697 40.8185C49.56 41.9836 47.6892 42.5662 45.4574 42.5662C42.4543 42.5662 40.0995 41.4831 38.3928 39.3169L38.0974 42H34.4789V5.64308L38.6143 5.12615V19.4523ZM44.4728 39.2185C46.6389 39.2185 48.3046 38.3815 49.4697 36.7077C50.6348 35.0338 51.2174 32.4656 51.2174 29.0031C51.2174 26.7385 50.9877 24.8595 50.5282 23.3662C50.0687 21.8564 49.3795 20.7323 48.4605 19.9938C47.5579 19.239 46.442 18.8615 45.1128 18.8615C43.6687 18.8615 42.3969 19.2964 41.2974 20.1662C40.2143 21.0195 39.32 21.9713 38.6143 23.0215V35.8708C39.2871 36.8882 40.1323 37.7005 41.1497 38.3077C42.1836 38.9149 43.2912 39.2185 44.4728 39.2185ZM75.7271 38.9969C77.0235 38.9969 78.2297 38.7836 79.3456 38.3569C80.4779 37.9303 81.5199 37.3887 82.4717 36.7323L84.4902 39.44C83.3579 40.4082 81.9958 41.1713 80.404 41.7292C78.8122 42.2872 77.2533 42.5662 75.7271 42.5662C73.1507 42.5662 70.9517 42.0164 69.1302 40.9169C67.3251 39.801 65.9466 38.2421 64.9948 36.24C64.043 34.2215 63.5671 31.8585 63.5671 29.1508C63.5671 26.5579 64.043 24.2359 64.9948 22.1846C65.963 20.1169 67.3497 18.4923 69.1548 17.3108C70.9763 16.1292 73.1835 15.5385 75.7763 15.5385C77.4338 15.5385 78.9846 15.7928 80.4287 16.3015C81.8892 16.7938 83.2266 17.5405 84.441 18.5415L82.4225 21.2985C81.323 20.5272 80.2153 19.9528 79.0994 19.5754C77.9999 19.1815 76.8758 18.9846 75.7271 18.9846C73.4953 18.9846 71.6574 19.8215 70.2133 21.4954C68.7692 23.1692 68.0471 25.721 68.0471 29.1508C68.0471 31.4482 68.3753 33.3272 69.0317 34.7877C69.7046 36.2318 70.6153 37.2985 71.764 37.9877C72.9292 38.6605 74.2502 38.9969 75.7271 38.9969ZM109.049 5.12615L113.185 5.64308V42H109.566L109.172 38.5785C108.204 39.9569 107.088 40.9662 105.825 41.6062C104.577 42.2462 103.24 42.5662 101.812 42.5662C99.564 42.5662 97.7096 42 96.2491 40.8677C94.7886 39.7354 93.7055 38.16 92.9999 36.1415C92.2943 34.1067 91.9414 31.7518 91.9414 29.0769C91.9414 26.4841 92.3435 24.1703 93.1476 22.1354C93.9517 20.0841 95.1086 18.4759 96.6184 17.3108C98.1445 16.1292 99.9743 15.5385 102.108 15.5385C103.601 15.5385 104.914 15.801 106.046 16.3262C107.178 16.8349 108.179 17.5897 109.049 18.5908V5.12615ZM103.191 18.8615C101.025 18.8615 99.3589 19.7067 98.1937 21.3969C97.0286 23.0872 96.4461 25.6472 96.4461 29.0769C96.4461 31.3087 96.684 33.1795 97.1599 34.6892C97.6358 36.199 98.3332 37.3313 99.2522 38.0862C100.188 38.841 101.328 39.2185 102.674 39.2185C104.151 39.2185 105.406 38.8 106.44 37.9631C107.49 37.1262 108.36 36.1826 109.049 35.1323V22.1846C108.343 21.1344 107.49 20.3221 106.489 19.7477C105.488 19.1569 104.389 18.8615 103.191 18.8615ZM126.322 30.5046C126.404 32.5067 126.79 34.1477 127.479 35.4277C128.168 36.6913 129.079 37.6267 130.211 38.2338C131.343 38.8246 132.574 39.12 133.903 39.12C135.233 39.12 136.431 38.9231 137.497 38.5292C138.58 38.1354 139.688 37.5528 140.82 36.7815L142.765 39.5138C141.551 40.4656 140.164 41.2123 138.605 41.7538C137.062 42.2954 135.479 42.5662 133.854 42.5662C131.343 42.5662 129.202 42 127.43 40.8677C125.657 39.7354 124.303 38.16 123.368 36.1415C122.449 34.1067 121.99 31.7518 121.99 29.0769C121.99 26.4513 122.457 24.121 123.393 22.0862C124.328 20.0513 125.641 18.4513 127.331 17.2862C129.021 16.121 131.015 15.5385 133.313 15.5385C135.495 15.5385 137.374 16.0554 138.95 17.0892C140.525 18.1067 141.731 19.5672 142.568 21.4708C143.421 23.3579 143.848 25.6144 143.848 28.24C143.848 28.6831 143.84 29.1015 143.823 29.4954C143.807 29.8728 143.782 30.2092 143.75 30.5046H126.322ZM133.362 18.9354C131.442 18.9354 129.834 19.6164 128.537 20.9785C127.257 22.3405 126.527 24.4492 126.347 27.3046H139.86C139.811 24.5313 139.204 22.4472 138.039 21.0523C136.874 19.641 135.315 18.9354 133.362 18.9354ZM167.915 5.12615C169.31 5.12615 170.573 5.24923 171.705 5.49539C172.838 5.74154 173.913 6.08615 174.93 6.52923L173.601 9.60616C172.764 9.24513 171.878 8.97436 170.942 8.79385C170.007 8.61333 169.039 8.52308 168.038 8.52308C166.233 8.52308 164.871 8.8759 163.952 9.58154C163.049 10.2872 162.598 11.3703 162.598 12.8308V18.0985H171.385L170.942 21.3477H162.598V42H158.462V21.3477H152.284V18.0985H158.462V12.9292C158.462 11.321 158.873 9.93436 159.693 8.76923C160.53 7.6041 161.662 6.70974 163.09 6.08615C164.518 5.44615 166.126 5.12615 167.915 5.12615ZM203.206 13.3231L204.486 17.2123C203.386 17.5569 202.213 17.7703 200.966 17.8523C199.719 17.9344 198.365 17.9754 196.904 17.9754C198.398 18.6646 199.522 19.559 200.277 20.6585C201.032 21.7415 201.409 23.0215 201.409 24.4985C201.409 26.2051 201.023 27.7231 200.252 29.0523C199.481 30.3815 198.365 31.4236 196.904 32.1785C195.46 32.9333 193.713 33.3108 191.661 33.3108C190.792 33.3108 190.061 33.2697 189.471 33.1877C188.896 33.1056 188.338 32.9826 187.797 32.8185C187.403 33.081 187.075 33.4421 186.812 33.9015C186.566 34.361 186.443 34.8369 186.443 35.3292C186.443 35.9528 186.689 36.4697 187.181 36.88C187.674 37.2903 188.584 37.4954 189.914 37.4954H194.591C196.33 37.4954 197.889 37.8072 199.267 38.4308C200.662 39.0544 201.754 39.8913 202.541 40.9415C203.345 41.9918 203.748 43.1897 203.748 44.5354C203.748 47.079 202.664 49.0318 200.498 50.3938C198.349 51.7559 195.304 52.4369 191.366 52.4369C188.609 52.4369 186.435 52.1497 184.843 51.5754C183.251 51.0174 182.111 50.1559 181.421 48.9908C180.749 47.8421 180.412 46.3897 180.412 44.6338H184.154C184.154 45.6349 184.351 46.4636 184.744 47.12C185.138 47.7764 185.852 48.2605 186.886 48.5723C187.92 48.9005 189.405 49.0646 191.341 49.0646C193.245 49.0646 194.796 48.9005 195.994 48.5723C197.208 48.2605 198.102 47.7846 198.677 47.1446C199.267 46.521 199.563 45.7415 199.563 44.8062C199.563 43.5754 199.005 42.6482 197.889 42.0246C196.773 41.401 195.378 41.0892 193.704 41.0892H189.077C186.845 41.0892 185.196 40.5969 184.129 39.6123C183.079 38.6277 182.554 37.4954 182.554 36.2154C182.554 35.3785 182.792 34.5662 183.267 33.7785C183.76 32.9908 184.474 32.2933 185.409 31.6862C183.916 30.8985 182.816 29.9221 182.111 28.7569C181.405 27.5918 181.052 26.1805 181.052 24.5231C181.052 22.7672 181.487 21.2164 182.357 19.8708C183.226 18.5087 184.441 17.4421 186 16.6708C187.559 15.8995 189.356 15.5138 191.391 15.5138C193.573 15.4974 195.345 15.4072 196.707 15.2431C198.07 15.0626 199.235 14.8082 200.203 14.48C201.187 14.1518 202.189 13.7662 203.206 13.3231ZM191.391 18.5415C189.306 18.5415 187.764 19.1077 186.763 20.24C185.778 21.3559 185.286 22.7836 185.286 24.5231C185.286 26.279 185.795 27.7231 186.812 28.8554C187.83 29.9877 189.389 30.5538 191.489 30.5538C193.327 30.5538 194.722 30.0205 195.674 28.9538C196.642 27.8872 197.126 26.4021 197.126 24.4985C197.126 22.5456 196.642 21.0687 195.674 20.0677C194.722 19.0503 193.294 18.5415 191.391 18.5415ZM215.802 5.24923V19.6246C216.819 18.2626 218.066 17.2451 219.543 16.5723C221.037 15.8831 222.546 15.5385 224.073 15.5385C226.6 15.5385 228.446 16.2113 229.611 17.5569C230.776 18.9026 231.359 20.7733 231.359 23.1692V42H227.223V23.2677C227.223 21.7087 226.862 20.5764 226.14 19.8708C225.418 19.1487 224.286 18.7877 222.743 18.7877C221.759 18.7877 220.823 19.0092 219.937 19.4523C219.051 19.8954 218.255 20.4451 217.55 21.1015C216.844 21.7579 216.261 22.4308 215.802 23.12V42H211.666V5.69231L215.802 5.24923ZM254.318 16.08V38.7262H261.628V42H242.182V38.7262H250.182V19.3538H242.428V16.08H254.318ZM251.019 3.94462C251.938 3.94462 252.668 4.22359 253.21 4.78154C253.768 5.33949 254.047 6.02051 254.047 6.82462C254.047 7.66154 253.768 8.36718 253.21 8.94154C252.668 9.49949 251.938 9.77846 251.019 9.77846C250.149 9.77846 249.436 9.49949 248.878 8.94154C248.32 8.36718 248.041 7.66154 248.041 6.82462C248.041 6.02051 248.32 5.33949 248.878 4.78154C249.436 4.22359 250.149 3.94462 251.019 3.94462ZM287.689 16.08V37.84C287.689 40.7282 287.041 43.1405 285.744 45.0769C284.448 47.0297 282.569 48.5969 280.107 49.7785C277.646 50.96 274.667 51.8462 271.172 52.4369L270.483 49.2369C273.043 48.8103 275.307 48.1703 277.277 47.3169C279.246 46.4636 280.78 45.2903 281.88 43.7969C282.996 42.32 283.554 40.4246 283.554 38.1108V19.3538H272.772V16.08H287.689ZM283.824 3.94462C284.743 3.94462 285.482 4.22359 286.04 4.78154C286.598 5.33949 286.877 6.02051 286.877 6.82462C286.877 7.66154 286.598 8.36718 286.04 8.94154C285.482 9.49949 284.743 9.77846 283.824 9.77846C282.938 9.77846 282.224 9.49949 281.683 8.94154C281.141 8.36718 280.87 7.66154 280.87 6.82462C280.87 6.02051 281.141 5.33949 281.683 4.78154C282.224 4.22359 282.938 3.94462 283.824 3.94462ZM321.971 16.08L310.303 27.7477L323.325 42H317.885L305.134 27.8462L316.605 16.08H321.971ZM304.666 5.12615V42H300.531V5.64308L304.666 5.12615ZM339.884 5.64308V35.6C339.884 36.88 340.278 37.7908 341.065 38.3323C341.869 38.8574 342.903 39.12 344.167 39.12C344.955 39.12 345.701 39.0379 346.407 38.8738C347.112 38.7097 347.818 38.4882 348.524 38.2092L349.631 41.2369C348.926 41.5815 348.048 41.8851 346.998 42.1477C345.964 42.4267 344.79 42.5662 343.478 42.5662C341.18 42.5662 339.318 41.9344 337.89 40.6708C336.462 39.3908 335.748 37.6267 335.748 35.3785V8.91692H327.798V5.64308H339.884ZM376.406 15.5385C377.243 15.5385 378.039 15.719 378.793 16.08C379.565 16.441 380.197 17.1385 380.689 18.1723C381.181 19.2062 381.427 20.7159 381.427 22.7015V42H377.587V23.3662C377.587 21.7415 377.489 20.5682 377.292 19.8462C377.095 19.1241 376.529 18.7631 375.593 18.7631C374.822 18.7631 374.051 19.0092 373.28 19.5015C372.525 19.9774 371.786 20.7651 371.064 21.8646V42H367.2V23.3662C367.2 21.7415 367.101 20.5682 366.904 19.8462C366.707 19.1241 366.141 18.7631 365.206 18.7631C364.402 18.7631 363.622 19.0092 362.867 19.5015C362.129 19.9774 361.399 20.7651 360.677 21.8646V42H356.861V16.08H360.11L360.357 19.0831C361.062 18.0821 361.85 17.2451 362.72 16.5723C363.606 15.8831 364.697 15.5385 365.993 15.5385C366.978 15.5385 367.905 15.7764 368.775 16.2523C369.645 16.7118 370.285 17.6144 370.695 18.96C371.401 17.9426 372.197 17.1221 373.083 16.4985C373.969 15.8585 375.077 15.5385 376.406 15.5385ZM388.854 42V16.08H392.374L392.694 19.6738C393.744 18.3446 395.057 17.3272 396.632 16.6215C398.224 15.8995 399.767 15.5385 401.26 15.5385C403.804 15.5385 405.65 16.2113 406.799 17.5569C407.964 18.9026 408.546 20.7733 408.546 23.1692V42H404.411V26.2215C404.411 24.4492 404.312 23.0215 404.115 21.9385C403.919 20.839 403.508 20.0431 402.885 19.5508C402.261 19.0421 401.293 18.7877 399.98 18.7877C398.963 18.7877 398.003 19.0092 397.1 19.4523C396.214 19.8954 395.418 20.4533 394.712 21.1262C394.023 21.7826 393.449 22.4472 392.989 23.12V42H388.854ZM428.256 15.5385C430.701 15.5385 432.744 16.0964 434.385 17.2123C436.043 18.3118 437.282 19.8708 438.102 21.8892C438.939 23.9077 439.357 26.2872 439.357 29.0277C439.357 31.6697 438.931 34.0082 438.077 36.0431C437.224 38.0779 435.969 39.6779 434.311 40.8431C432.67 41.9918 430.635 42.5662 428.207 42.5662C425.778 42.5662 423.735 42.0082 422.077 40.8923C420.42 39.7764 419.165 38.2092 418.311 36.1908C417.474 34.1559 417.056 31.7846 417.056 29.0769C417.056 26.4021 417.483 24.0472 418.336 22.0123C419.189 19.9774 420.445 18.3938 422.102 17.2615C423.776 16.1128 425.827 15.5385 428.256 15.5385ZM428.256 18.9108C426.024 18.9108 424.334 19.7395 423.185 21.3969C422.053 23.0379 421.487 25.5979 421.487 29.0769C421.487 32.4903 422.045 35.0256 423.161 36.6831C424.293 38.3405 425.975 39.1692 428.207 39.1692C430.439 39.1692 432.112 38.3405 433.228 36.6831C434.361 35.0256 434.927 32.4738 434.927 29.0277C434.927 25.5815 434.369 23.0379 433.253 21.3969C432.137 19.7395 430.471 18.9108 428.256 18.9108ZM459.51 15.5385C461.808 15.5385 463.637 16.0964 465 17.2123C466.378 18.3282 467.371 19.9036 467.978 21.9385C468.585 23.9569 468.889 26.32 468.889 29.0277C468.889 31.6369 468.52 33.9672 467.781 36.0185C467.059 38.0533 465.96 39.6533 464.483 40.8185C463.006 41.9836 461.143 42.5662 458.895 42.5662C456.056 42.5662 453.775 41.5651 452.052 39.5631V51.92L447.916 52.4369V16.08H451.436L451.781 19.6985C452.733 18.3692 453.865 17.3436 455.178 16.6215C456.507 15.8995 457.951 15.5385 459.51 15.5385ZM458.526 18.8615C457.098 18.8615 455.834 19.2964 454.735 20.1662C453.652 21.0195 452.757 21.9713 452.052 23.0215V35.8708C452.725 36.8718 453.57 37.6677 454.587 38.2585C455.621 38.8328 456.753 39.12 457.984 39.12C460.134 39.12 461.75 38.2995 462.833 36.6585C463.916 35.0174 464.458 32.4656 464.458 29.0031C464.458 26.7385 464.245 24.8595 463.818 23.3662C463.391 21.8564 462.743 20.7323 461.873 19.9938C461.004 19.239 459.888 18.8615 458.526 18.8615ZM485.989 15.5385C487.548 15.5385 488.918 15.8256 490.1 16.4C491.298 16.9744 492.34 17.8113 493.226 18.9108L493.571 16.08H497.091V52.4369L492.955 51.92V38.7262C492.02 40.0554 490.921 41.0318 489.657 41.6554C488.41 42.2626 487.081 42.5662 485.669 42.5662C483.355 42.5662 481.493 42.0082 480.082 40.8923C478.687 39.7764 477.677 38.2092 477.054 36.1908C476.43 34.1559 476.118 31.7846 476.118 29.0769C476.118 26.4841 476.488 24.1703 477.226 22.1354C477.981 20.0841 479.097 18.4759 480.574 17.3108C482.051 16.1292 483.856 15.5385 485.989 15.5385ZM487.023 18.8615C484.873 18.8615 483.257 19.7067 482.174 21.3969C481.091 23.0872 480.549 25.6472 480.549 29.0769C480.549 31.3087 480.771 33.1713 481.214 34.6646C481.657 36.1579 482.313 37.2738 483.183 38.0123C484.069 38.7508 485.185 39.12 486.531 39.12C487.975 39.12 489.23 38.7179 490.297 37.9138C491.364 37.1097 492.25 36.1826 492.955 35.1323V22.1846C492.283 21.1344 491.429 20.3221 490.395 19.7477C489.378 19.1569 488.254 18.8615 487.023 18.8615ZM507.225 42V38.8246H511.262V19.2554H507.225V16.08H514.413L515.176 22.2092C516.177 20.0759 517.391 18.4267 518.819 17.2615C520.247 16.0964 522.134 15.5138 524.48 15.5138C525.203 15.5138 525.843 15.5713 526.4 15.6862C526.975 15.7846 527.557 15.9159 528.148 16.08L526.942 19.7723C526.4 19.6246 525.908 19.5179 525.465 19.4523C525.022 19.3703 524.513 19.3292 523.939 19.3292C521.953 19.3292 520.247 20.0349 518.819 21.4462C517.391 22.8574 516.251 24.9908 515.397 27.8462V38.8246H520.665V42H507.225ZM524.16 24.8431V19.2062L524.579 16.08H528.148L527.557 24.8431H524.16ZM545.322 39.1446C547.308 39.1446 548.875 38.7754 550.024 38.0369C551.189 37.2821 551.772 36.281 551.772 35.0338C551.772 34.2462 551.624 33.5651 551.329 32.9908C551.05 32.4164 550.467 31.8995 549.581 31.44C548.695 30.9805 547.333 30.521 545.495 30.0615C543.706 29.6185 542.147 29.1097 540.818 28.5354C539.505 27.9446 538.479 27.1815 537.741 26.2462C537.019 25.3108 536.658 24.0964 536.658 22.6031C536.658 21.1426 537.068 19.8872 537.889 18.8369C538.726 17.7703 539.882 16.958 541.359 16.4C542.836 15.8256 544.551 15.5385 546.504 15.5385C548.588 15.5385 550.401 15.8174 551.944 16.3754C553.503 16.9169 554.824 17.5897 555.907 18.3938L554.086 21.2C553.101 20.5272 552.018 19.9774 550.836 19.5508C549.655 19.1077 548.227 18.8862 546.553 18.8862C544.518 18.8862 543.074 19.2062 542.221 19.8462C541.368 20.4697 540.941 21.2821 540.941 22.2831C540.941 23.0379 541.146 23.6697 541.556 24.1785C541.983 24.6708 542.697 25.1221 543.698 25.5323C544.699 25.9262 546.077 26.361 547.833 26.8369C549.524 27.28 550.992 27.8133 552.239 28.4369C553.503 29.0605 554.488 29.881 555.193 30.8985C555.899 31.9159 556.252 33.2287 556.252 34.8369C556.252 36.6749 555.727 38.1682 554.676 39.3169C553.626 40.4492 552.264 41.2779 550.59 41.8031C548.933 42.3118 547.177 42.5662 545.322 42.5662C542.976 42.5662 540.974 42.2297 539.316 41.5569C537.675 40.8677 536.297 40.039 535.181 39.0708L537.544 36.3385C538.561 37.1754 539.727 37.8564 541.039 38.3815C542.369 38.8903 543.796 39.1446 545.322 39.1446ZM586.62 40.6954C585.734 41.2862 584.659 41.7456 583.395 42.0738C582.132 42.4021 580.893 42.5662 579.678 42.5662C576.889 42.5662 574.739 41.8359 573.229 40.3754C571.719 38.9149 570.965 37.0359 570.965 34.7385V19.28H565.008V16.08H570.965V10.1969L575.1 9.70462V16.08H584.06L583.568 19.28H575.1V34.6892C575.1 36.1333 575.477 37.2328 576.232 37.9877C577.003 38.7426 578.275 39.12 580.048 39.12C581.016 39.12 581.91 39.0051 582.731 38.7754C583.551 38.5456 584.314 38.2503 585.02 37.8892L586.62 40.6954ZM599.708 16.08V34.4431C599.708 36.1497 600.061 37.3805 600.767 38.1354C601.472 38.8903 602.572 39.2677 604.065 39.2677C605.493 39.2677 606.838 38.8656 608.102 38.0615C609.382 37.241 610.375 36.2728 611.08 35.1569V16.08H615.216V42H611.696L611.351 38.5046C610.334 39.8174 609.078 40.8267 607.585 41.5323C606.092 42.2215 604.582 42.5662 603.056 42.5662C600.545 42.5662 598.666 41.9015 597.419 40.5723C596.188 39.2267 595.573 37.3477 595.573 34.9354V16.08H599.708ZM646.716 16.08L637.289 42H632.489L623.135 16.08H627.516L635.024 38.2338L642.433 16.08H646.716ZM673.835 42H667.977L664.629 22.9723L660.986 42H655.275L650.549 16.08H654.783L658.081 39.44L662.217 19.3785H667.115L671.029 39.44L674.327 16.08H678.364L673.835 42ZM686.677 42H681.951L691.526 28.3138L683.133 16.08H688.031L694.037 25.7292L700.117 16.08H704.843L696.474 28.1415L706.025 42H700.954L693.865 30.8738L686.677 42ZM735.261 16.08L726.153 42.1723C725.546 43.9282 724.775 45.5364 723.839 46.9969C722.92 48.4574 721.714 49.6636 720.221 50.6154C718.744 51.5836 716.865 52.1826 714.584 52.4123L713.944 49.1138C715.733 48.8185 717.144 48.3672 718.178 47.76C719.212 47.1528 720.024 46.3733 720.615 45.4215C721.222 44.4697 721.755 43.3292 722.215 42H720.836L711.778 16.08H716.208L723.642 38.8492L730.978 16.08H735.261ZM748.398 38.48H762.823L762.281 42H743.327V38.8738L757.703 19.6738H744.46V16.08H762.675V19.28L748.398 38.48ZM21.3415 81.36H7.92615L5.21846 90H1.00923L12.0369 56.1046H17.5015L28.5292 90H24.0492L21.3415 81.36ZM9.03385 77.8154H20.2338L14.6708 59.6985L9.03385 77.8154ZM51.5866 80.4738C51.5866 78.7672 51.2502 77.4544 50.5774 76.5354C49.921 75.6 49.043 74.9518 47.9436 74.5908C46.8441 74.2297 45.6379 74.0492 44.3251 74.0492H38.5405V86.48H44.1282C44.9651 86.48 45.8184 86.3979 46.6882 86.2338C47.5579 86.0697 48.362 85.7744 49.1005 85.3477C49.8554 84.921 50.4543 84.3221 50.8974 83.5508C51.3569 82.7631 51.5866 81.7374 51.5866 80.4738ZM50.2328 64.8677C50.2328 62.9477 49.6338 61.5856 48.4359 60.7815C47.2543 59.961 45.6379 59.5508 43.5866 59.5508H38.5405V70.5292H44.0051C46.0071 70.5292 47.5415 70.0862 48.6082 69.2C49.6912 68.2974 50.2328 66.8533 50.2328 64.8677ZM56.0913 80.3262C56.0913 82.1641 55.722 83.7067 54.9836 84.9538C54.2615 86.201 53.2851 87.1938 52.0543 87.9323C50.84 88.6708 49.4779 89.2041 47.9682 89.5323C46.4748 89.8441 44.9487 90 43.3897 90H34.282V56.1046H42.6266C44.12 56.1046 45.5723 56.2441 46.9836 56.5231C48.4112 56.7856 49.6912 57.2451 50.8236 57.9015C51.9723 58.5415 52.8912 59.4113 53.5805 60.5108C54.2697 61.6103 54.6143 62.9887 54.6143 64.6462C54.6143 66.1067 54.3107 67.3456 53.7036 68.3631C53.1128 69.3641 52.3333 70.1682 51.3651 70.7754C50.4133 71.3826 49.3959 71.8092 48.3128 72.0554C49.5764 72.2523 50.7989 72.6379 51.9805 73.2123C53.1784 73.7703 54.163 74.6236 54.9343 75.7723C55.7056 76.9046 56.0913 78.4226 56.0913 80.3262ZM76.6871 55.5631C78.9025 55.5631 80.7569 55.8421 82.2502 56.4C83.7435 56.9579 85.163 57.7785 86.5087 58.8615L84.121 61.6431C83.0543 60.7405 81.922 60.1005 80.724 59.7231C79.5425 59.3292 78.3035 59.1323 77.0071 59.1323C75.1528 59.1323 73.4379 59.5754 71.8625 60.4615C70.2871 61.3313 69.0153 62.7836 68.0471 64.8185C67.0953 66.8369 66.6194 69.5774 66.6194 73.04C66.6194 76.4041 67.0707 79.1036 67.9733 81.1385C68.8922 83.1733 70.1312 84.6421 71.6902 85.5446C73.2492 86.4472 74.9887 86.8985 76.9087 86.8985C78.8122 86.8985 80.3712 86.6113 81.5856 86.0369C82.8163 85.4626 83.883 84.8062 84.7856 84.0677L87.001 86.8738C85.9671 87.8749 84.6215 88.7446 82.964 89.4831C81.3066 90.2051 79.2717 90.5662 76.8594 90.5662C74.1189 90.5662 71.6328 89.8933 69.401 88.5477C67.1856 87.2021 65.4297 85.2328 64.1333 82.64C62.8369 80.0308 62.1887 76.8308 62.1887 73.04C62.1887 69.2328 62.8451 66.0328 64.1579 63.44C65.4871 60.8472 67.2512 58.8862 69.4502 57.5569C71.6656 56.2277 74.0779 55.5631 76.6871 55.5631ZM111.24 72.8923C111.24 69.9385 110.928 67.5754 110.305 65.8031C109.681 64.0308 108.86 62.7015 107.843 61.8154C106.826 60.9292 105.71 60.3385 104.495 60.0431C103.297 59.7477 102.116 59.6 100.951 59.6H96.963V86.5785H101C102.214 86.5785 103.42 86.3897 104.618 86.0123C105.833 85.6185 106.94 84.9292 107.941 83.9446C108.942 82.9436 109.738 81.5569 110.329 79.7846C110.936 77.9959 111.24 75.6985 111.24 72.8923ZM115.794 72.8923C115.794 75.7149 115.49 78.1272 114.883 80.1292C114.292 82.1149 113.48 83.7559 112.446 85.0523C111.412 86.3487 110.231 87.3579 108.901 88.08C107.589 88.7856 106.202 89.2862 104.741 89.5815C103.297 89.8605 101.878 90 100.483 90H92.7045V56.1046H99.9414C101.927 56.1046 103.855 56.3262 105.726 56.7692C107.613 57.2123 109.312 58.0328 110.821 59.2308C112.348 60.4123 113.554 62.1026 114.44 64.3015C115.342 66.5005 115.794 69.3641 115.794 72.8923ZM128.587 59.6V71.0215H141.14V74.5415H128.587V86.5785H143.996V90H124.303V56.1046H143.553L143.06 59.6H128.587ZM158.709 59.6V71.4646H172.001V74.9108H158.709V90H154.475V56.1046H174.438L173.921 59.6H158.709ZM192.621 90.5662C189.946 90.5662 187.616 89.9179 185.631 88.6215C183.661 87.3251 182.135 85.3805 181.052 82.7877C179.969 80.1949 179.427 76.9456 179.427 73.04C179.427 70.119 179.813 67.5672 180.584 65.3846C181.372 63.2021 182.431 61.3805 183.76 59.92C185.105 58.4595 186.623 57.3682 188.314 56.6462C190.02 55.9241 191.784 55.5631 193.606 55.5631C195.821 55.5631 197.659 55.8831 199.12 56.5231C200.58 57.1467 201.975 58.0656 203.304 59.28L200.72 61.9631C199.686 60.9949 198.595 60.281 197.446 59.8215C196.314 59.3621 195.042 59.1323 193.631 59.1323C192.4 59.1323 191.21 59.3703 190.061 59.8462C188.913 60.3221 187.879 61.1015 186.96 62.1846C186.057 63.2513 185.335 64.6708 184.794 66.4431C184.269 68.2154 184.006 70.4144 184.006 73.04C184.006 76.3056 184.342 78.9641 185.015 81.0154C185.704 83.0667 186.714 84.5764 188.043 85.5446C189.389 86.4964 191.046 86.9723 193.015 86.9723C194.197 86.9723 195.313 86.8328 196.363 86.5538C197.43 86.2749 198.463 85.8728 199.464 85.3477V75.0092H192.794L192.277 71.4646H203.698V87.6123C202.172 88.4328 200.547 89.1303 198.824 89.7046C197.101 90.279 195.034 90.5662 192.621 90.5662ZM227.888 90V73.9262H215.088V90H210.83V56.1046H215.088V70.4308H227.888V56.1046H232.146V90H227.888ZM260.718 56.1046V59.5262H253.185V86.5785H260.718V90H241.321V86.5785H248.853V59.5262H241.321V56.1046H260.718ZM290.224 56.1046V78.7508C290.224 80.1621 290.036 81.5733 289.658 82.9846C289.297 84.3795 288.674 85.6513 287.787 86.8C286.918 87.9323 285.736 88.8431 284.243 89.5323C282.749 90.2215 280.887 90.5662 278.655 90.5662C276.998 90.5662 275.365 90.3036 273.757 89.7785C272.165 89.2533 270.696 88.4903 269.35 87.4892L271.246 84.6585C272.723 85.5774 274.068 86.201 275.283 86.5292C276.497 86.841 277.605 86.9969 278.606 86.9969C280.969 86.9969 282.782 86.2421 284.046 84.7323C285.326 83.2226 285.966 81.1467 285.966 78.5046V59.6H275.923V56.1046H290.224ZM304.74 90H300.482V56.1046H304.74V90ZM304.986 71.9077L318.328 56.1046H323.251L310.008 71.6369L324.186 90H318.869L304.986 71.9077ZM331.515 90V56.1046H335.798V86.1846H351.256L350.764 90H331.515ZM380.492 56.1046L382.412 90H378.301L377.243 72.3015C377.193 71.1036 377.144 69.8892 377.095 68.6585C377.046 67.4277 377.013 66.2462 376.997 65.1138C376.98 63.9815 376.972 62.9723 376.972 62.0862C376.972 61.2 376.972 60.5108 376.972 60.0185L371.261 83.92H366.978L360.849 60.0185C360.865 60.4944 360.882 61.2 360.898 62.1354C360.914 63.0544 360.923 64.0964 360.923 65.2615C360.939 66.4267 360.931 67.6246 360.898 68.8554C360.882 70.0697 360.849 71.2021 360.8 72.2523L359.889 90H355.877L357.797 56.1046H363.753L369.243 79.3169L374.486 56.1046H380.492ZM403.352 90L391.414 60.1908C391.43 60.5682 391.463 61.2 391.512 62.0862C391.578 62.9559 391.644 63.9979 391.709 65.2123C391.791 66.4103 391.857 67.6821 391.906 69.0277C391.955 70.3733 391.98 71.7026 391.98 73.0154V90H388.017V56.1046H393.802L405.937 86.0369C405.921 85.561 405.863 84.6913 405.765 83.4277C405.666 82.1477 405.576 80.6051 405.494 78.8C405.412 76.9949 405.371 75.0831 405.371 73.0646V56.1046H409.334V90H403.352ZM440.687 73.0892C440.687 76.5026 440.219 79.5303 439.284 82.1723C438.365 84.7979 436.978 86.8574 435.124 88.3508C433.269 89.8277 430.964 90.5662 428.207 90.5662C425.466 90.5662 423.161 89.8441 421.29 88.4C419.435 86.9395 418.041 84.9046 417.105 82.2954C416.186 79.6862 415.727 76.6338 415.727 73.1385C415.727 69.7087 416.186 66.6728 417.105 64.0308C418.041 61.3887 419.435 59.321 421.29 57.8277C423.161 56.3179 425.466 55.5631 428.207 55.5631C430.964 55.5631 433.269 56.2933 435.124 57.7538C436.978 59.2144 438.365 61.2574 439.284 63.8831C440.219 66.5087 440.687 69.5774 440.687 73.0892ZM436.207 73.0892C436.207 68.5764 435.583 65.1221 434.336 62.7262C433.105 60.3303 431.062 59.1323 428.207 59.1323C425.351 59.1323 423.3 60.3385 422.053 62.7508C420.822 65.1631 420.207 68.6256 420.207 73.1385C420.207 77.6513 420.847 81.0892 422.127 83.4523C423.407 85.799 425.433 86.9723 428.207 86.9723C431.062 86.9723 433.105 85.7908 434.336 83.4277C435.583 81.0482 436.207 77.6021 436.207 73.0892ZM465.812 66.5662C465.812 64.8103 465.467 63.4236 464.778 62.4062C464.089 61.3723 463.145 60.6338 461.947 60.1908C460.749 59.7313 459.379 59.5015 457.836 59.5015H452.938V73.9754H457.664C459.256 73.9754 460.659 73.7621 461.873 73.3354C463.088 72.8923 464.048 72.1374 464.753 71.0708C465.459 69.9877 465.812 68.4862 465.812 66.5662ZM470.39 66.5169C470.39 69.159 469.824 71.2759 468.692 72.8677C467.576 74.4595 466.033 75.6164 464.064 76.3385C462.095 77.0605 459.83 77.4215 457.27 77.4215H452.938V90H448.655V56.1046H457.32C461.356 56.1046 464.54 56.958 466.87 58.6646C469.217 60.3549 470.39 62.9723 470.39 66.5169ZM499.749 73.0892C499.749 75.4851 499.528 77.6841 499.085 79.6862C498.642 81.6882 497.903 83.4523 496.869 84.9785C495.852 86.5046 494.473 87.7436 492.734 88.6954C494.326 89.0072 495.679 89.4749 496.795 90.0985C497.928 90.7221 498.879 91.5672 499.651 92.6338C500.438 93.7169 501.111 95.0872 501.669 96.7446L497.165 98.5169C496.492 96.7774 495.721 95.3087 494.851 94.1108C493.997 92.9128 492.923 92.0021 491.626 91.3785C490.346 90.7713 488.73 90.4677 486.777 90.4677C484.184 90.4677 481.985 89.7538 480.18 88.3262C478.391 86.8821 477.037 84.8636 476.118 82.2708C475.199 79.6779 474.74 76.6338 474.74 73.1385C474.74 69.7087 475.208 66.6728 476.143 64.0308C477.095 61.3887 478.498 59.321 480.352 57.8277C482.207 56.3179 484.504 55.5631 487.245 55.5631C490.002 55.5631 492.307 56.2933 494.162 57.7538C496.016 59.2144 497.411 61.2574 498.346 63.8831C499.282 66.5087 499.749 69.5774 499.749 73.0892ZM495.318 73.0892C495.318 68.56 494.687 65.1056 493.423 62.7262C492.176 60.3303 490.116 59.1323 487.245 59.1323C484.389 59.1323 482.33 60.3385 481.066 62.7508C479.803 65.1467 479.171 68.6092 479.171 73.1385C479.171 77.6513 479.819 81.0892 481.115 83.4523C482.428 85.799 484.471 86.9723 487.245 86.9723C490.1 86.9723 492.159 85.7908 493.423 83.4277C494.687 81.0482 495.318 77.6021 495.318 73.0892ZM528.493 65.6062C528.493 67.2964 528.124 68.7733 527.385 70.0369C526.663 71.3005 525.678 72.3426 524.431 73.1631C523.184 73.9836 521.781 74.5826 520.222 74.96L530.265 90H525.145L515.89 75.4523H511.311V90H507.028V56.1046H515.742C519.927 56.1046 523.094 56.9087 525.244 58.5169C527.41 60.1087 528.493 62.4718 528.493 65.6062ZM523.914 65.6062C523.914 63.4236 523.291 61.8646 522.044 60.9292C520.796 59.9774 518.86 59.5015 516.234 59.5015H511.311V72.1046H516.234C518.663 72.1046 520.55 71.6123 521.896 70.6277C523.242 69.6267 523.914 67.9528 523.914 65.6062ZM557.975 80.6215C557.975 82.5579 557.491 84.281 556.522 85.7908C555.554 87.2841 554.151 88.4574 552.313 89.3108C550.475 90.1477 548.235 90.5662 545.593 90.5662C543.115 90.5662 540.867 90.1887 538.849 89.4338C536.847 88.679 535.132 87.6123 533.704 86.2338L536.239 83.3785C537.421 84.4779 538.775 85.3559 540.301 86.0123C541.827 86.6523 543.616 86.9723 545.667 86.9723C547.046 86.9723 548.334 86.7508 549.532 86.3077C550.73 85.8482 551.698 85.159 552.436 84.24C553.175 83.3046 553.544 82.1231 553.544 80.6954C553.544 79.5959 553.331 78.6605 552.904 77.8892C552.477 77.1179 551.722 76.4369 550.639 75.8462C549.556 75.239 548.047 74.6482 546.11 74.0738C543.878 73.4174 541.942 72.679 540.301 71.8585C538.676 71.0215 537.413 69.9959 536.51 68.7815C535.624 67.5672 535.181 66.0656 535.181 64.2769C535.181 62.5867 535.649 61.0851 536.584 59.7723C537.519 58.4595 538.808 57.4338 540.449 56.6954C542.106 55.9405 544.01 55.5631 546.159 55.5631C548.506 55.5631 550.541 55.8995 552.264 56.5723C554.004 57.2287 555.579 58.1805 556.99 59.4277L554.479 62.2092C553.265 61.1262 551.96 60.3467 550.566 59.8708C549.171 59.3785 547.751 59.1323 546.307 59.1323C545.076 59.1323 543.944 59.321 542.91 59.6985C541.893 60.0595 541.072 60.6092 540.449 61.3477C539.841 62.0697 539.538 62.9969 539.538 64.1292C539.538 65.0974 539.8 65.9344 540.326 66.64C540.851 67.3456 541.737 67.9938 542.984 68.5846C544.231 69.159 545.93 69.7662 548.079 70.4062C549.835 70.9149 551.46 71.5549 552.953 72.3262C554.463 73.081 555.677 74.1149 556.596 75.4277C557.515 76.7241 557.975 78.4554 557.975 80.6215ZM577.906 59.7723V90H573.648V59.7723H563.063V56.1046H588.638L588.195 59.7723H577.906ZM616.594 56.1046V79.0215C616.594 81.3026 616.127 83.3128 615.191 85.0523C614.272 86.7918 612.968 88.1456 611.277 89.1138C609.603 90.0821 607.626 90.5662 605.345 90.5662C603.015 90.5662 601.013 90.0821 599.339 89.1138C597.681 88.1292 596.41 86.7672 595.523 85.0277C594.637 83.2882 594.194 81.2862 594.194 79.0215V56.1046H598.428V79.1692C598.428 81.7456 599.027 83.6738 600.225 84.9538C601.439 86.2338 603.146 86.8738 605.345 86.8738C607.56 86.8738 609.267 86.2338 610.465 84.9538C611.679 83.6738 612.287 81.7456 612.287 79.1692V56.1046H616.594ZM635.024 85.1508L644.181 56.1046H648.489L637.141 90H632.71L621.362 56.1046H625.965L635.024 85.1508ZM679.004 56.1046L673.835 90H668.223L664.334 64.4246L660.42 90H654.684L649.909 56.1046H654.192L657.811 85.2985L661.872 60.0431H667.115L670.98 85.2985L675.041 56.1046H679.004ZM681.656 56.1046H686.554L693.988 69.1262L701.446 56.1046H706.074L696.45 71.7108L707.231 90H702.333L693.89 74.6892L685.348 90H680.745L691.379 71.9323L681.656 56.1046ZM725.685 76.9292V90H721.353V76.9785L709.907 56.1046H714.633L723.618 73.0892L732.701 56.1046H737.132L725.685 76.9292ZM746.503 86.3077H764.25L763.734 90H741.801V86.5292L759.721 59.7477H743.574V56.1046H764.3V59.6L746.503 86.3077ZM18.3877 104.105V137.015H14.2523V108.585L6.47385 113.311L4.67692 110.357L14.7692 104.105H18.3877ZM25.4769 134.628V138H5.90769V134.628H25.4769ZM42.7989 103.563C44.9323 103.563 46.7538 103.973 48.2636 104.794C49.7897 105.614 50.963 106.738 51.7836 108.166C52.6041 109.594 53.0143 111.21 53.0143 113.015C53.0143 114.574 52.7436 116.101 52.202 117.594C51.6605 119.071 50.7907 120.63 49.5928 122.271C48.4112 123.895 46.8523 125.701 44.9159 127.686C42.9959 129.672 40.6328 131.936 37.8266 134.48H53.802L53.2851 138H33.1251V134.628C35.6851 132.183 37.8595 130.041 39.6482 128.203C41.4533 126.365 42.9384 124.757 44.1036 123.378C45.2851 121.984 46.2041 120.72 46.8605 119.588C47.5333 118.455 48.001 117.381 48.2636 116.363C48.5261 115.329 48.6574 114.263 48.6574 113.163C48.6574 111.259 48.1159 109.758 47.0328 108.658C45.9661 107.559 44.4892 107.009 42.602 107.009C40.9282 107.009 39.5579 107.296 38.4912 107.871C37.4246 108.445 36.3579 109.364 35.2912 110.628L32.4359 108.412C33.7815 106.771 35.2748 105.557 36.9159 104.769C38.5569 103.965 40.5179 103.563 42.7989 103.563ZM72.281 103.563C74.4143 103.563 76.2522 103.949 77.7948 104.72C79.3538 105.475 80.5599 106.501 81.4133 107.797C82.2666 109.077 82.6933 110.488 82.6933 112.031C82.6933 113.393 82.3897 114.632 81.7825 115.748C81.1753 116.864 80.3712 117.783 79.3702 118.505C78.3692 119.227 77.2697 119.703 76.0717 119.932C77.401 120.031 78.6481 120.408 79.8133 121.065C80.9784 121.705 81.9302 122.624 82.6687 123.822C83.4071 125.003 83.7763 126.472 83.7763 128.228C83.7763 130.181 83.284 131.945 82.2994 133.52C81.3148 135.079 79.9363 136.31 78.164 137.212C76.4081 138.115 74.3569 138.566 72.0102 138.566C70.123 138.566 68.2358 138.205 66.3487 137.483C64.4779 136.761 62.8943 135.612 61.5979 134.037L64.3794 131.772C65.3476 132.905 66.4963 133.75 67.8256 134.308C69.1712 134.866 70.5333 135.145 71.9117 135.145C74.2748 135.145 76.121 134.529 77.4502 133.298C78.7794 132.051 79.444 130.361 79.444 128.228C79.444 126.619 79.1322 125.348 78.5087 124.412C77.9015 123.477 77.0728 122.812 76.0225 122.418C74.9722 122.008 73.7743 121.803 72.4287 121.803H69.5733L70.0902 118.529H72.084C73.1835 118.529 74.2174 118.324 75.1856 117.914C76.1702 117.487 76.9743 116.831 77.5979 115.945C78.2215 115.058 78.5333 113.951 78.5333 112.622C78.5333 110.751 77.9097 109.323 76.6625 108.338C75.4153 107.354 73.9056 106.862 72.1333 106.862C70.6563 106.862 69.3681 107.124 68.2687 107.649C67.1692 108.158 66.0615 108.937 64.9456 109.988L62.6563 107.452C64.1004 106.09 65.6348 105.106 67.2594 104.498C68.884 103.875 70.5579 103.563 72.281 103.563ZM102.083 103.563L105.529 105.015L96.5199 126.455H114.612V129.754H92.1384V126.751L102.083 103.563ZM110.231 116.831V138H106.243L106.218 127.243L106.785 116.831H110.231ZM142.1 104.105L141.485 107.403H128.094V118.086C129.128 117.528 130.104 117.151 131.023 116.954C131.959 116.741 132.935 116.634 133.953 116.634C135.791 116.634 137.407 117.052 138.802 117.889C140.197 118.71 141.28 119.916 142.051 121.508C142.822 123.099 143.208 125.019 143.208 127.268C143.208 129.516 142.732 131.493 141.78 133.2C140.845 134.907 139.524 136.228 137.817 137.163C136.111 138.098 134.084 138.566 131.737 138.566C129.702 138.566 127.881 138.205 126.273 137.483C124.681 136.761 123.229 135.76 121.916 134.48L124.476 132.018C125.51 133.069 126.617 133.856 127.799 134.382C128.997 134.89 130.326 135.145 131.787 135.145C134.018 135.145 135.758 134.472 137.005 133.126C138.252 131.764 138.876 129.77 138.876 127.145C138.876 125.323 138.605 123.887 138.063 122.837C137.522 121.787 136.783 121.04 135.848 120.597C134.929 120.137 133.903 119.908 132.771 119.908C131.77 119.908 130.884 120.006 130.113 120.203C129.341 120.384 128.463 120.663 127.479 121.04H124.156V104.105H142.1ZM164.173 103.563C165.486 103.563 166.692 103.735 167.792 104.08C168.891 104.408 169.917 104.892 170.869 105.532L169.244 108.338C168.473 107.863 167.652 107.51 166.782 107.28C165.929 107.034 165.035 106.911 164.099 106.911C162.294 106.911 160.76 107.518 159.496 108.732C158.233 109.93 157.281 111.629 156.641 113.828C156.001 116.01 155.689 118.578 155.705 121.532L155.755 123.132C155.755 127.301 156.304 130.361 157.404 132.314C158.503 134.25 160.3 135.218 162.795 135.218C164.944 135.218 166.553 134.455 167.619 132.929C168.702 131.403 169.244 129.327 169.244 126.702C169.244 124.847 168.99 123.387 168.481 122.32C167.989 121.237 167.291 120.466 166.389 120.006C165.486 119.547 164.436 119.317 163.238 119.317C161.482 119.317 159.931 119.842 158.585 120.892C157.24 121.943 156.149 123.288 155.312 124.929L155.213 121.286C156.329 119.383 157.601 118.012 159.029 117.175C160.456 116.338 162.073 115.92 163.878 115.92C165.634 115.92 167.234 116.306 168.678 117.077C170.122 117.848 171.279 119.03 172.149 120.622C173.035 122.197 173.478 124.191 173.478 126.603C173.478 129.097 173.002 131.239 172.05 133.028C171.098 134.8 169.81 136.17 168.185 137.138C166.561 138.09 164.772 138.566 162.819 138.566C160.752 138.566 159.004 138.181 157.576 137.409C156.149 136.622 154.992 135.506 154.105 134.062C153.219 132.601 152.571 130.853 152.161 128.818C151.767 126.767 151.57 124.486 151.57 121.975C151.57 118.234 152.062 114.985 153.047 112.228C154.048 109.471 155.484 107.337 157.355 105.828C159.242 104.318 161.515 103.563 164.173 103.563ZM188.535 138.468L184.671 137.286L197.889 107.551H181.987V104.105H202.049V107.28L188.535 138.468ZM231.654 112.178C231.654 113.819 231.145 115.247 230.128 116.462C229.111 117.659 227.658 118.775 225.771 119.809C227.986 120.728 229.751 121.951 231.063 123.477C232.376 125.003 233.033 126.816 233.033 128.917C233.033 130.755 232.557 132.404 231.605 133.865C230.653 135.325 229.307 136.474 227.568 137.311C225.845 138.148 223.785 138.566 221.39 138.566C218.977 138.566 216.91 138.148 215.186 137.311C213.48 136.457 212.175 135.309 211.273 133.865C210.386 132.421 209.943 130.796 209.943 128.991C209.943 126.907 210.559 125.151 211.79 123.723C213.037 122.279 214.686 121.089 216.737 120.154C214.948 119.301 213.595 118.267 212.676 117.052C211.773 115.838 211.322 114.287 211.322 112.4C211.322 110.841 211.634 109.512 212.257 108.412C212.897 107.296 213.718 106.377 214.719 105.655C215.736 104.933 216.836 104.408 218.017 104.08C219.215 103.735 220.372 103.563 221.488 103.563C222.719 103.563 223.933 103.735 225.131 104.08C226.345 104.408 227.445 104.925 228.43 105.631C229.414 106.32 230.194 107.206 230.768 108.289C231.359 109.372 231.654 110.669 231.654 112.178ZM228.676 128.966C228.676 127.44 228.29 126.234 227.519 125.348C226.747 124.462 225.681 123.723 224.319 123.132C222.957 122.542 221.381 121.943 219.593 121.335C218.657 121.762 217.787 122.304 216.983 122.96C216.179 123.616 215.531 124.437 215.039 125.422C214.546 126.39 214.3 127.588 214.3 129.015C214.3 130.935 214.891 132.453 216.073 133.569C217.271 134.669 219.035 135.218 221.365 135.218C223.728 135.218 225.533 134.628 226.78 133.446C228.044 132.248 228.676 130.755 228.676 128.966ZM215.408 112.449C215.408 113.746 215.703 114.763 216.294 115.502C216.901 116.24 217.763 116.847 218.879 117.323C219.995 117.783 221.316 118.267 222.842 118.775C224.417 117.873 225.599 116.962 226.386 116.043C227.174 115.108 227.568 113.869 227.568 112.326C227.568 110.619 227.035 109.266 225.968 108.265C224.918 107.264 223.424 106.763 221.488 106.763C219.568 106.763 218.075 107.264 217.008 108.265C215.941 109.266 215.408 110.661 215.408 112.449ZM250.502 103.612C252.964 103.612 255.015 104.178 256.656 105.311C258.297 106.443 259.52 108.043 260.324 110.111C261.144 112.178 261.555 114.632 261.555 117.471C261.555 120.884 261.202 123.781 260.496 126.16C259.807 128.523 258.732 130.501 257.272 132.092C255.811 133.684 253.94 135.022 251.659 136.105C249.378 137.188 246.654 138.164 243.487 139.034L242.527 135.883C245.743 134.981 248.418 133.914 250.552 132.683C252.685 131.436 254.301 129.869 255.401 127.982C256.5 126.078 257.091 123.715 257.173 120.892L257.247 118.529C257.263 115.707 257.025 113.45 256.533 111.76C256.057 110.053 255.319 108.831 254.318 108.092C253.333 107.337 252.061 106.96 250.502 106.96C248.303 106.96 246.638 107.633 245.505 108.978C244.373 110.324 243.807 112.293 243.807 114.886C243.807 117.463 244.348 119.342 245.432 120.523C246.531 121.688 248.049 122.271 249.985 122.271C251.676 122.271 253.136 121.795 254.367 120.843C255.598 119.891 256.763 118.611 257.862 117.003L257.838 120.597C256.837 122.041 255.631 123.231 254.219 124.166C252.808 125.102 251.142 125.569 249.222 125.569C247.335 125.569 245.661 125.134 244.201 124.265C242.74 123.395 241.592 122.156 240.755 120.548C239.934 118.939 239.524 117.003 239.524 114.738C239.524 112.326 240.016 110.291 241.001 108.634C241.985 106.976 243.306 105.729 244.964 104.892C246.621 104.039 248.467 103.612 250.502 103.612ZM280.55 103.563C284.21 103.563 286.975 105.073 288.846 108.092C290.717 111.112 291.652 115.428 291.652 121.04C291.652 126.669 290.717 131.001 288.846 134.037C286.975 137.056 284.21 138.566 280.55 138.566C276.907 138.566 274.142 137.056 272.255 134.037C270.384 131.001 269.449 126.669 269.449 121.04C269.449 115.428 270.384 111.112 272.255 108.092C274.142 105.073 276.907 103.563 280.55 103.563ZM280.55 106.886C278.466 106.886 276.825 107.994 275.627 110.209C274.429 112.408 273.83 116.018 273.83 121.04C273.83 123.584 273.962 125.758 274.224 127.563C274.487 129.368 274.889 130.837 275.43 131.969C275.988 133.085 276.686 133.906 277.523 134.431C278.376 134.956 279.385 135.218 280.55 135.218C281.962 135.218 283.168 134.734 284.169 133.766C285.186 132.798 285.958 131.272 286.483 129.188C287.024 127.087 287.295 124.371 287.295 121.04C287.295 117.659 287.057 114.927 286.581 112.843C286.122 110.759 285.392 109.249 284.39 108.314C283.406 107.362 282.126 106.886 280.55 106.886ZM285.547 108.092L286.63 111.711L275.849 133.545L274.323 130.665L285.547 108.092ZM310.082 129.902C311.214 129.902 312.158 130.287 312.912 131.058C313.684 131.83 314.069 132.757 314.069 133.84C314.069 134.431 313.996 135.03 313.848 135.637C313.717 136.244 313.47 136.933 313.109 137.705L309.122 146.837H305.38L307.743 137.114C307.251 136.753 306.857 136.285 306.562 135.711C306.283 135.12 306.143 134.496 306.143 133.84C306.143 132.741 306.521 131.813 307.276 131.058C308.03 130.287 308.966 129.902 310.082 129.902ZM335.256 134.209C335.256 133.405 335.445 132.683 335.822 132.043C336.2 131.387 336.708 130.87 337.348 130.492C338.005 130.098 338.743 129.902 339.564 129.902C340.401 129.902 341.147 130.098 341.804 130.492C342.46 130.87 342.977 131.387 343.355 132.043C343.732 132.683 343.921 133.405 343.921 134.209C343.921 135.013 343.732 135.752 343.355 136.425C342.977 137.081 342.46 137.606 341.804 138C341.147 138.377 340.401 138.566 339.564 138.566C338.743 138.566 338.005 138.377 337.348 138C336.708 137.606 336.2 137.081 335.822 136.425C335.445 135.752 335.256 135.013 335.256 134.209ZM369.095 129.852C370.244 129.852 371.196 130.246 371.95 131.034C372.722 131.805 373.107 132.724 373.107 133.791C373.107 134.398 373.033 135.005 372.886 135.612C372.754 136.219 372.5 136.917 372.123 137.705L368.135 146.862H364.393L366.757 137.089C365.673 136.334 365.132 135.243 365.132 133.815C365.132 132.716 365.509 131.781 366.264 131.009C367.036 130.238 367.979 129.852 369.095 129.852ZM369.095 112.843C370.244 112.843 371.196 113.229 371.95 114C372.722 114.771 373.107 115.707 373.107 116.806C373.107 117.889 372.722 118.833 371.95 119.637C371.196 120.425 370.244 120.818 369.095 120.818C367.979 120.818 367.036 120.425 366.264 119.637C365.509 118.833 365.132 117.889 365.132 116.806C365.132 116.051 365.304 115.378 365.649 114.788C365.993 114.197 366.469 113.729 367.077 113.385C367.684 113.024 368.357 112.843 369.095 112.843ZM394.663 134.554C394.663 133.487 395.041 132.56 395.795 131.772C396.567 130.985 397.51 130.591 398.626 130.591C399.775 130.591 400.727 130.985 401.482 131.772C402.253 132.56 402.639 133.487 402.639 134.554C402.639 135.67 402.253 136.622 401.482 137.409C400.727 138.181 399.775 138.566 398.626 138.566C397.51 138.566 396.567 138.181 395.795 137.409C395.041 136.622 394.663 135.67 394.663 134.554ZM394.663 116.806C394.663 116.051 394.835 115.378 395.18 114.788C395.525 114.197 396.001 113.729 396.608 113.385C397.215 113.024 397.888 112.843 398.626 112.843C399.775 112.843 400.727 113.229 401.482 114C402.253 114.771 402.639 115.707 402.639 116.806C402.639 117.889 402.253 118.833 401.482 119.637C400.727 120.425 399.775 120.818 398.626 120.818C397.51 120.818 396.567 120.425 395.795 119.637C395.041 118.833 394.663 117.889 394.663 116.806ZM430.397 104.105L429.979 126.825H426.262L425.77 104.105H430.397ZM428.157 131.969C429.109 131.969 429.897 132.289 430.521 132.929C431.161 133.569 431.481 134.341 431.481 135.243C431.481 136.162 431.161 136.95 430.521 137.606C429.897 138.246 429.109 138.566 428.157 138.566C427.222 138.566 426.443 138.246 425.819 137.606C425.195 136.95 424.884 136.162 424.884 135.243C424.884 134.341 425.195 133.569 425.819 132.929C426.443 132.289 427.222 131.969 428.157 131.969ZM457.713 103.563C459.732 103.563 461.463 103.924 462.907 104.646C464.368 105.368 465.484 106.312 466.255 107.477C467.026 108.626 467.412 109.848 467.412 111.145C467.412 112.72 467.116 114.008 466.526 115.009C465.935 115.994 465.196 116.831 464.31 117.52C463.441 118.193 462.563 118.857 461.676 119.514C460.79 120.154 460.044 120.909 459.436 121.778C458.846 122.648 458.55 123.764 458.55 125.126V126.825H454.39V124.88C454.39 123.288 454.677 121.967 455.252 120.917C455.843 119.867 456.573 118.972 457.443 118.234C458.312 117.495 459.182 116.814 460.052 116.191C460.922 115.551 461.652 114.862 462.243 114.123C462.833 113.385 463.129 112.474 463.129 111.391C463.129 109.996 462.571 108.921 461.455 108.166C460.339 107.395 458.952 107.009 457.295 107.009C456.13 107.009 454.932 107.296 453.701 107.871C452.47 108.429 451.346 109.339 450.329 110.603L447.375 108.437C448.819 106.747 450.403 105.516 452.126 104.745C453.865 103.957 455.728 103.563 457.713 103.563ZM456.581 131.969C457.533 131.969 458.329 132.289 458.969 132.929C459.609 133.569 459.929 134.341 459.929 135.243C459.929 136.162 459.609 136.95 458.969 137.606C458.329 138.246 457.533 138.566 456.581 138.566C455.662 138.566 454.891 138.246 454.267 137.606C453.644 136.95 453.332 136.162 453.332 135.243C453.332 134.341 453.644 133.569 454.267 132.929C454.891 132.289 455.662 131.969 456.581 131.969ZM486.457 103.563C489.001 103.563 491.142 103.949 492.882 104.72C494.637 105.475 496.065 106.517 497.165 107.846C498.281 109.175 499.134 110.718 499.725 112.474C500.332 114.213 500.75 116.068 500.98 118.037C501.21 119.99 501.325 121.975 501.325 123.994C501.325 128.129 501.128 131.567 500.734 134.308C500.356 137.032 499.651 139.067 498.617 140.412C497.583 141.774 496.073 142.455 494.088 142.455C493.07 142.455 492.192 142.209 491.454 141.717C490.715 141.225 490.108 140.601 489.632 139.846C489.156 139.108 488.812 138.345 488.598 137.557C488.385 136.753 488.287 136.055 488.303 135.465H488.106C487.811 136.219 487.384 136.966 486.826 137.705C486.285 138.427 485.571 139.026 484.685 139.502C483.798 139.994 482.699 140.24 481.386 140.24C479.597 140.24 478.153 139.756 477.054 138.788C475.971 137.819 475.183 136.482 474.691 134.775C474.198 133.069 473.952 131.132 473.952 128.966C473.952 124.683 474.806 121.499 476.512 119.415C478.219 117.315 480.582 116.265 483.602 116.265C484.75 116.265 485.85 116.388 486.9 116.634C487.95 116.88 489.165 117.372 490.543 118.111V132.658C490.543 134.431 490.699 135.785 491.011 136.72C491.323 137.639 491.741 138.271 492.266 138.615C492.791 138.96 493.374 139.132 494.014 139.132C494.785 139.132 495.384 138.747 495.811 137.975C496.237 137.204 496.541 136.129 496.722 134.751C496.902 133.372 497.009 131.772 497.042 129.951C497.074 128.113 497.091 126.144 497.091 124.043C497.091 121.696 496.959 119.506 496.697 117.471C496.434 115.419 495.934 113.623 495.195 112.08C494.457 110.537 493.39 109.331 491.995 108.462C490.601 107.592 488.771 107.157 486.506 107.157C484.914 107.157 483.175 107.452 481.288 108.043C479.417 108.617 477.431 109.832 475.331 111.686L472.968 108.929C475.167 107.009 477.415 105.639 479.712 104.818C482.026 103.982 484.274 103.563 486.457 103.563ZM483.798 119.317C481.55 119.317 480.016 120.129 479.195 121.754C478.375 123.378 477.965 125.783 477.965 128.966C477.965 130.574 478.079 131.994 478.309 133.225C478.555 134.439 478.966 135.399 479.54 136.105C480.114 136.794 480.894 137.138 481.878 137.138C483.027 137.138 483.93 136.876 484.586 136.351C485.259 135.826 485.768 135.227 486.112 134.554C486.473 133.865 486.752 133.282 486.949 132.806V120.055C486.441 119.793 485.932 119.604 485.423 119.489C484.931 119.374 484.389 119.317 483.798 119.317ZM524.604 115.551L523.151 126.455H527.139V129.655H522.684L521.65 138H518.105L519.213 129.655H512.05L510.967 138H507.422L508.53 129.655H504.64V126.455H508.948L510.45 115.551H506.462V112.326H510.868L511.951 104.105H515.496L514.314 112.326H521.551L522.634 104.105H526.179L525.022 112.326H528.96V115.551H524.604ZM512.468 126.455H519.631L521.133 115.551H513.92L512.468 126.455ZM548.572 96.2277V103.637C550.541 103.85 552.289 104.326 553.815 105.065C555.341 105.803 556.613 106.648 557.63 107.6L555.095 110.209C554.143 109.323 553.126 108.617 552.042 108.092C550.959 107.551 549.802 107.206 548.572 107.058V118.283C550.229 118.825 551.772 119.522 553.199 120.375C554.644 121.229 555.809 122.32 556.695 123.649C557.581 124.978 558.024 126.652 558.024 128.671C558.024 130.23 557.671 131.698 556.966 133.077C556.26 134.439 555.201 135.596 553.79 136.548C552.395 137.483 550.656 138.09 548.572 138.369V145.532H545.249V138.517C542.918 138.369 540.892 137.828 539.169 136.892C537.462 135.957 536.059 134.956 534.959 133.889L537.421 131.157C538.455 132.207 539.612 133.085 540.892 133.791C542.188 134.48 543.64 134.89 545.249 135.022V121.385C542.377 120.433 540.153 119.21 538.578 117.717C537.019 116.207 536.239 114.312 536.239 112.031C536.239 110.702 536.568 109.438 537.224 108.24C537.897 107.026 538.898 106 540.227 105.163C541.573 104.326 543.247 103.817 545.249 103.637V96.2277H548.572ZM548.572 122.542V134.8C551.903 134.127 553.569 132.101 553.569 128.72C553.569 127.342 553.199 126.16 552.461 125.175C551.739 124.191 550.442 123.313 548.572 122.542ZM545.249 107.157C543.903 107.387 542.795 107.904 541.926 108.708C541.072 109.495 540.646 110.578 540.646 111.957C540.646 113.106 540.957 114.082 541.581 114.886C542.221 115.69 543.444 116.462 545.249 117.2V107.157ZM574.829 103.612C576.306 103.612 577.709 103.85 579.038 104.326C580.368 104.802 581.705 105.778 583.051 107.255L580.565 109.52C579.728 108.568 578.858 107.863 577.955 107.403C577.069 106.944 576.011 106.714 574.78 106.714C573.057 106.714 571.76 107.182 570.891 108.117C570.021 109.036 569.586 110.226 569.586 111.686C569.586 112.687 569.857 113.623 570.398 114.492C570.94 115.346 571.67 116.035 572.589 116.56C573.508 117.085 574.526 117.348 575.641 117.348H589.328V120.597H584.921V133.988C584.429 134.628 583.748 135.301 582.878 136.006C582.025 136.712 580.926 137.319 579.58 137.828C578.234 138.32 576.61 138.566 574.706 138.566C572.146 138.566 570.054 138.074 568.429 137.089C566.821 136.105 565.631 134.841 564.86 133.298C564.105 131.739 563.728 130.115 563.728 128.425C563.728 125.881 564.392 123.797 565.721 122.172C567.067 120.548 568.979 119.481 571.457 118.972V118.825C569.963 118.48 568.782 117.947 567.912 117.225C567.059 116.486 566.443 115.641 566.066 114.689C565.705 113.721 565.525 112.728 565.525 111.711C565.525 110.25 565.902 108.913 566.657 107.698C567.412 106.468 568.487 105.483 569.881 104.745C571.276 103.99 572.926 103.612 574.829 103.612ZM581.155 120.597H575.051C573.344 120.597 571.957 120.999 570.891 121.803C569.824 122.591 569.036 123.575 568.528 124.757C568.035 125.922 567.789 127.095 567.789 128.277C567.789 129.458 568.027 130.583 568.503 131.649C568.995 132.716 569.75 133.577 570.768 134.234C571.801 134.89 573.147 135.218 574.805 135.218C576.183 135.218 577.414 134.997 578.497 134.554C579.596 134.094 580.482 133.446 581.155 132.609V120.597ZM615.462 103.194L618.12 104.917L594.81 138.985L592.225 137.262L615.462 103.194ZM612.09 125.422C611.121 125.422 610.301 125.815 609.628 126.603C608.955 127.374 608.619 128.622 608.619 130.345C608.619 131.936 608.947 133.175 609.603 134.062C610.26 134.948 611.089 135.391 612.09 135.391C613.074 135.391 613.887 134.989 614.527 134.185C615.183 133.381 615.511 132.101 615.511 130.345C615.511 128.572 615.183 127.309 614.527 126.554C613.887 125.799 613.074 125.422 612.09 125.422ZM598.797 106.517C597.829 106.517 597.009 106.919 596.336 107.723C595.663 108.527 595.327 109.766 595.327 111.44C595.327 113.048 595.655 114.295 596.311 115.182C596.968 116.051 597.796 116.486 598.797 116.486C599.782 116.486 600.594 116.084 601.234 115.28C601.891 114.476 602.219 113.196 602.219 111.44C602.219 109.668 601.891 108.404 601.234 107.649C600.594 106.894 599.782 106.517 598.797 106.517ZM598.797 103.563C600.34 103.563 601.644 103.924 602.711 104.646C603.778 105.368 604.59 106.328 605.148 107.526C605.722 108.724 606.01 110.029 606.01 111.44C606.01 112.818 605.722 114.115 605.148 115.329C604.59 116.544 603.778 117.528 602.711 118.283C601.644 119.022 600.34 119.391 598.797 119.391C597.271 119.391 595.967 119.022 594.883 118.283C593.8 117.528 592.972 116.544 592.397 115.329C591.823 114.115 591.536 112.818 591.536 111.44C591.536 110.012 591.823 108.708 592.397 107.526C592.972 106.328 593.8 105.368 594.883 104.646C595.967 103.924 597.271 103.563 598.797 103.563ZM612.09 122.443C613.632 122.443 614.937 122.812 616.003 123.551C617.07 124.273 617.882 125.233 618.44 126.431C619.015 127.629 619.302 128.933 619.302 130.345C619.302 131.739 619.015 133.044 618.44 134.258C617.882 135.456 617.07 136.433 616.003 137.188C614.937 137.926 613.632 138.295 612.09 138.295C610.563 138.295 609.259 137.926 608.176 137.188C607.093 136.433 606.264 135.456 605.69 134.258C605.115 133.044 604.828 131.739 604.828 130.345C604.828 128.917 605.115 127.604 605.69 126.406C606.264 125.208 607.093 124.248 608.176 123.526C609.259 122.804 610.563 122.443 612.09 122.443ZM639.184 107.378L629.239 102.8L631.455 99.28L640.538 105.089L639.184 107.378ZM659.804 118.283C661.035 118.283 662.077 118.529 662.931 119.022C663.8 119.514 664.572 120.088 665.244 120.745C665.917 121.401 666.565 121.975 667.189 122.468C667.813 122.96 668.502 123.206 669.257 123.206C670.274 123.206 671.185 122.804 671.989 122C672.793 121.196 673.507 120.203 674.131 119.022L677.084 120.548C676.609 121.483 676.026 122.435 675.337 123.403C674.647 124.355 673.802 125.159 672.801 125.815C671.8 126.455 670.57 126.775 669.109 126.775C667.96 126.775 666.959 126.529 666.106 126.037C665.269 125.545 664.506 124.97 663.817 124.314C663.144 123.657 662.471 123.083 661.798 122.591C661.142 122.098 660.428 121.852 659.657 121.852C658.59 121.852 657.671 122.254 656.9 123.058C656.129 123.846 655.423 124.831 654.783 126.012L651.829 124.56C652.321 123.592 652.904 122.624 653.577 121.655C654.25 120.687 655.086 119.883 656.087 119.243C657.105 118.603 658.344 118.283 659.804 118.283ZM695.834 96.6708L705.139 112.055H700.634L693.939 100.388L687.268 112.055H682.837L692.142 96.6708H695.834ZM721.427 109.52H725.612L725.292 119.489L734.645 116.166L735.901 120.055L726.375 122.862L732.455 130.738L729.156 133.151L723.519 124.929L717.882 133.151L714.584 130.738L720.664 122.862L711.138 120.055L712.393 116.166L721.747 119.489L721.427 109.52ZM10.4615 168.769C10.4615 171.329 10.6831 173.627 11.1262 175.662C11.5692 177.68 12.2256 179.534 13.0954 181.225C13.9651 182.898 15.0564 184.49 16.3692 186C17.6985 187.526 19.241 189.069 20.9969 190.628L18.8308 192.892C16.1723 190.71 13.8913 188.478 11.9877 186.197C10.1005 183.916 8.6482 181.372 7.63077 178.566C6.62974 175.76 6.12923 172.494 6.12923 168.769C6.12923 165.028 6.62974 161.754 7.63077 158.948C8.6482 156.142 10.1005 153.598 11.9877 151.317C13.8913 149.036 16.1723 146.812 18.8308 144.646L20.9969 146.911C19.2246 148.486 17.6738 150.037 16.3446 151.563C15.0318 153.073 13.9405 154.665 13.0708 156.338C12.201 157.996 11.5446 159.842 11.1015 161.877C10.6749 163.895 10.4615 166.193 10.4615 168.769ZM48.6082 168.769C48.6082 166.193 48.3866 163.895 47.9436 161.877C47.5169 159.842 46.8687 157.996 45.9989 156.338C45.1292 154.665 44.0297 153.073 42.7005 151.563C41.3877 150.037 39.8451 148.486 38.0728 146.911L40.2389 144.646C42.9138 146.812 45.1948 149.036 47.082 151.317C48.9692 153.598 50.4133 156.142 51.4143 158.948C52.4318 161.754 52.9405 165.028 52.9405 168.769C52.9405 172.494 52.4318 175.76 51.4143 178.566C50.4133 181.372 48.9692 183.916 47.082 186.197C45.1948 188.478 42.9138 190.71 40.2389 192.892L38.0728 190.628C39.8287 189.069 41.363 187.526 42.6759 186C44.0051 184.49 45.1046 182.898 45.9743 181.225C46.8441 179.534 47.5005 177.68 47.9436 175.662C48.3866 173.627 48.6082 171.329 48.6082 168.769ZM68.121 191.686V145.852H80.4533V149.422H72.0348V188.166H80.4533V191.686H68.121ZM109.074 145.852V191.686H96.7414V188.191H105.16V149.422H96.7414V145.852H109.074ZM140.353 144.868V148.117C139.155 148.117 138.063 148.24 137.079 148.486C136.111 148.716 135.356 149.118 134.814 149.692C134.289 150.267 134.068 151.054 134.15 152.055L135.183 162.148C135.331 163.526 135.249 164.667 134.937 165.569C134.626 166.472 134.1 167.177 133.362 167.686C132.64 168.195 131.713 168.556 130.58 168.769C131.729 168.966 132.673 169.311 133.411 169.803C134.15 170.279 134.667 170.968 134.962 171.871C135.257 172.757 135.331 173.93 135.183 175.391L134.15 185.483C134.068 186.501 134.289 187.296 134.814 187.871C135.339 188.445 136.094 188.847 137.079 189.077C138.063 189.307 139.155 189.422 140.353 189.422V192.671C138.974 192.671 137.653 192.548 136.39 192.302C135.126 192.072 134.01 191.67 133.042 191.095C132.074 190.521 131.343 189.733 130.851 188.732C130.359 187.748 130.195 186.501 130.359 184.991L131.343 175.637C131.475 174.505 131.368 173.553 131.023 172.782C130.695 172.01 129.973 171.428 128.857 171.034C127.758 170.624 126.109 170.418 123.91 170.418V167.12C126.109 167.12 127.758 166.923 128.857 166.529C129.973 166.135 130.695 165.553 131.023 164.782C131.368 164.01 131.475 163.067 131.343 161.951L130.359 152.548C130.195 151.038 130.359 149.791 130.851 148.806C131.343 147.805 132.066 147.017 133.017 146.443C133.986 145.869 135.101 145.467 136.365 145.237C137.645 144.991 138.974 144.868 140.353 144.868ZM154.967 144.868C156.345 144.868 157.667 144.991 158.93 145.237C160.194 145.467 161.31 145.869 162.278 146.443C163.246 147.017 163.976 147.805 164.469 148.806C164.977 149.791 165.141 151.038 164.961 152.548L163.976 161.951C163.845 163.067 163.984 164.01 164.395 164.782C164.821 165.553 165.593 166.135 166.709 166.529C167.824 166.923 169.392 167.12 171.41 167.12V170.418C169.408 170.418 167.841 170.624 166.709 171.034C165.593 171.428 164.821 172.01 164.395 172.782C163.984 173.553 163.845 174.505 163.976 175.637L164.961 184.991C165.125 186.501 164.961 187.748 164.469 188.732C163.976 189.733 163.246 190.521 162.278 191.095C161.326 191.67 160.21 192.072 158.93 192.302C157.667 192.548 156.345 192.671 154.967 192.671V189.422C156.165 189.422 157.248 189.307 158.216 189.077C159.201 188.847 159.964 188.445 160.505 187.871C161.047 187.296 161.269 186.501 161.17 185.483L160.136 175.391C159.989 173.93 160.071 172.757 160.382 171.871C160.694 170.968 161.252 170.279 162.056 169.803C162.877 169.327 163.952 168.999 165.281 168.818C164.001 168.605 162.951 168.236 162.13 167.711C161.326 167.186 160.76 166.472 160.432 165.569C160.103 164.667 160.005 163.526 160.136 162.148L161.17 152.055C161.269 151.054 161.047 150.267 160.505 149.692C159.964 149.118 159.209 148.716 158.241 148.486C157.273 148.24 156.181 148.117 154.967 148.117V144.868ZM179.649 194.935V191.317H204.264V194.935H179.649ZM231.063 164.24V167.809H211.913V164.24H231.063ZM231.063 173.569V177.163H211.913V173.569H231.063ZM241.148 172.388V168.794H260.89V172.388H241.148ZM282.421 159.145V168.966H292.095V172.437H282.421V182.185H278.557V172.437H269.006V168.966H278.557V159.145H282.421ZM318.574 156.757L320.568 159.932L303.189 170.591L320.568 181.348L318.352 184.375L299.645 172.683V168.449L318.574 156.757ZM331.17 156.757L350.099 168.449V172.683L331.416 184.375L329.176 181.323L346.555 170.591L329.176 159.883L331.17 156.757ZM360.307 191.071L356.96 189.594L378.03 146.148L381.329 147.772L360.307 191.071ZM386.491 147.772L389.789 146.148L410.86 189.594L407.512 191.071L386.491 147.772ZM430.028 146.271V191.022H426.336V146.271H430.028ZM455.916 162.443L455.153 149.643H460.323L459.56 162.443H455.916ZM481.337 162.443L480.549 149.643H485.743L484.98 162.443H481.337ZM489.558 162.443L488.82 149.643H493.989L493.202 162.443H489.558Z" fill="#111111"/>
					</svg>`,
                    untitled_sans: `<svg width="1000" height="200" viewBox="0 0 1000 200" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M19.056 42C18.768 40.656 18.624 39.072 18.624 37.92C17.568 40.752 14.256 42.528 10.224 42.528C6 42.528 2.4 40.08 2.4 35.616C2.4 30.96 5.856 28.944 10.752 28.368L18.528 27.36V25.968C18.528 22.128 16.176 20.496 12.864 20.496C9.648 20.496 7.632 22.176 7.344 24.96H3.504C3.984 20.064 7.824 17.28 12.96 17.28C18.816 17.28 22.464 20.064 22.464 25.872V36.96C22.464 38.736 22.56 40.416 23.04 42H19.056ZM11.04 39.504C14.784 39.504 18.528 37.152 18.528 32.496V30.336L11.952 31.056C8.928 31.488 6.432 32.256 6.432 35.52C6.432 37.776 8.016 39.504 11.04 39.504ZM34.5964 37.776V42H30.7564V6.672H34.7404V22.128C35.8444 19.68 38.5804 17.28 42.7564 17.28C48.9004 17.28 53.5084 22.272 53.5084 29.952C53.5084 37.584 48.9004 42.576 42.7564 42.576C38.7724 42.576 35.7964 40.224 34.5964 37.776ZM34.5484 29.568V30.24C34.5484 35.712 37.2364 39.456 41.9404 39.456C46.6924 39.456 49.4764 35.568 49.4764 29.952C49.4764 24.288 46.6924 20.4 41.9404 20.4C37.2364 20.4 34.5484 24.096 34.5484 29.568ZM58.5585 29.952C58.5585 22.224 63.2145 17.28 69.9345 17.28C75.3105 17.28 78.8625 20.352 79.6305 25.488H75.8385C75.1665 22.272 73.1985 20.496 69.9345 20.496C65.1825 20.496 62.4945 24.288 62.4945 29.952C62.4945 35.616 65.1825 39.36 69.9345 39.36C73.1985 39.36 75.1665 37.584 75.8385 34.368H79.6305C78.8625 39.552 75.3105 42.576 69.9345 42.576C63.2145 42.576 58.5585 37.68 58.5585 29.952ZM103.346 42V37.776C102.146 40.224 99.1695 42.576 95.1855 42.576C89.0415 42.576 84.4335 37.584 84.4335 29.952C84.4335 22.272 89.0415 17.28 95.1855 17.28C99.3615 17.28 102.098 19.68 103.202 22.128V6.672H107.186V42H103.346ZM103.394 30.24V29.568C103.394 24.096 100.706 20.4 96.0015 20.4C91.2495 20.4 88.4655 24.288 88.4655 29.952C88.4655 35.568 91.2495 39.456 96.0015 39.456C100.706 39.456 103.394 35.712 103.394 30.24ZM135.565 34.896C134.461 40.032 130.285 42.576 125.581 42.576C118.765 42.576 113.965 37.824 113.965 30.048C113.965 22.176 118.909 17.28 125.341 17.28C132.493 17.28 135.709 22.992 135.709 29.184V30.768H117.853C118.045 36.336 120.973 39.408 125.581 39.408C128.845 39.408 130.813 37.824 131.821 34.896H135.565ZM125.341 20.496C121.549 20.496 118.669 22.944 117.997 27.888H131.821C131.725 23.712 129.661 20.496 125.341 20.496ZM143.084 20.88H139.58V17.856H143.084V13.344C143.084 8.832 145.964 6.528 150.092 6.528C150.956 6.528 152.06 6.624 152.78 6.768V9.936C152.156 9.84 151.196 9.792 150.332 9.792C148.604 9.792 147.02 10.656 147.02 13.392V17.856H152.204V20.88H147.02V42H143.084V20.88ZM174.262 40.464V36.912C173.158 39.264 170.47 41.568 166.246 41.568C160.054 41.568 155.542 36.912 155.542 29.376C155.542 22.128 160.054 17.28 166.246 17.28C170.47 17.28 173.254 19.776 174.406 22.08V17.856H178.294V40.176C178.294 47.856 173.302 51.12 166.87 51.12C161.062 51.12 157.126 48.768 156.166 44.064H160.198C161.014 47.088 163.558 48.048 166.822 48.048C171.574 48.048 174.262 45.504 174.262 40.464ZM174.55 29.952V28.8C174.55 23.808 171.43 20.4 166.966 20.4C162.262 20.4 159.478 24 159.478 29.376C159.478 34.704 162.262 38.4 166.966 38.4C171.43 38.4 174.55 34.944 174.55 29.952ZM190.834 22.272C191.986 19.2 194.866 17.28 198.562 17.28C203.986 17.28 207.202 20.688 207.202 26.448V42H203.218V27.312C203.218 22.848 201.25 20.544 197.458 20.544C193.762 20.544 190.834 22.896 190.834 28.704V42H186.85V6.672H190.834V22.272ZM215.203 12.816V7.968H219.715V12.816H215.203ZM215.491 42V17.856H219.475V42H215.491ZM227.718 12.816V7.968H232.23V12.816H227.718ZM225.51 50.832C224.79 50.832 224.166 50.784 223.446 50.64V47.472C223.878 47.568 224.262 47.616 224.742 47.616C226.998 47.616 228.006 46.896 228.006 44.304V17.856H231.99V44.16C231.99 48.672 229.974 50.832 225.51 50.832ZM256.794 42L247.626 30.624L244.506 33.648V42H240.522V6.672H244.506V29.424L256.41 17.856H261.162L250.506 28.08L261.594 42H256.794ZM271.272 42H267.288V6.672H271.272V42ZM298.619 22.464C300.107 19.2 303.179 17.28 306.731 17.28C312.299 17.28 315.035 20.784 315.035 26.448V42H311.003V27.312C311.003 22.8 309.371 20.544 305.771 20.544C302.171 20.544 299.435 23.136 299.435 28.704V42H295.403V27.312C295.403 22.8 293.819 20.544 290.171 20.544C286.523 20.544 283.787 23.136 283.787 28.704V42H279.803V17.856H283.643V22.272C284.795 19.2 287.771 17.28 291.275 17.28C295.355 17.28 297.563 19.248 298.619 22.464ZM327.143 17.856V22.272C328.295 19.296 331.319 17.28 335.015 17.28C340.439 17.28 343.655 20.688 343.655 26.448V42H339.671V27.312C339.671 22.848 337.703 20.544 333.911 20.544C330.215 20.544 327.287 22.896 327.287 28.704V42H323.303V17.856H327.143ZM373.112 29.952C373.112 37.728 368.312 42.576 361.64 42.576C354.968 42.576 350.168 37.728 350.168 29.952C350.168 22.176 354.968 17.28 361.64 17.28C368.312 17.28 373.112 22.176 373.112 29.952ZM354.104 29.952C354.104 35.76 356.936 39.36 361.64 39.36C366.344 39.36 369.176 35.76 369.176 29.952C369.176 24.144 366.344 20.496 361.64 20.496C356.936 20.496 354.104 24.144 354.104 29.952ZM383.865 37.776V50.544H379.881V17.856H383.721V22.272C384.825 19.824 387.705 17.28 391.881 17.28C398.025 17.28 402.633 22.272 402.633 29.952C402.633 37.584 398.025 42.576 391.881 42.576C387.897 42.576 385.065 40.224 383.865 37.776ZM383.673 29.568V30.24C383.673 35.712 386.361 39.456 391.065 39.456C395.817 39.456 398.601 35.568 398.601 29.952C398.601 24.288 395.817 20.4 391.065 20.4C386.361 20.4 383.673 24.096 383.673 29.568ZM426.452 50.544V37.776C425.252 40.224 422.42 42.576 418.436 42.576C412.292 42.576 407.684 37.584 407.684 29.952C407.684 22.272 412.292 17.28 418.436 17.28C422.612 17.28 425.492 19.824 426.596 22.272V17.856H430.436V50.544H426.452ZM426.644 30.24V29.568C426.644 24.096 423.956 20.4 419.252 20.4C414.5 20.4 411.716 24.288 411.716 29.952C411.716 35.568 414.5 39.456 419.252 39.456C423.956 39.456 426.644 35.712 426.644 30.24ZM452.383 17.52V21.168C451.807 21.024 450.943 20.976 450.319 20.976C446.479 20.976 442.975 24 442.975 30.096V42H438.991V17.856H442.831V23.568C443.887 19.584 446.959 17.328 450.511 17.328C451.135 17.328 451.807 17.376 452.383 17.52ZM455.396 34.848H459.236C459.523 38.16 462.596 39.552 465.859 39.552C469.172 39.552 471.572 38.016 471.572 35.424C471.572 33.648 470.42 32.496 467.348 31.92L463.076 31.056C459.188 30.336 456.355 28.752 456.355 24.528C456.355 20.448 460.004 17.28 465.332 17.28C470.9 17.28 474.308 19.68 474.788 24.24H471.092C470.804 21.792 468.644 20.352 465.332 20.352C462.116 20.352 460.052 21.936 460.052 24.288C460.052 26.352 461.492 27.216 464.276 27.744L469.076 28.656C473.012 29.424 475.316 31.344 475.316 35.232C475.316 39.456 471.332 42.576 465.908 42.576C460.148 42.576 455.828 40.032 455.396 34.848ZM493.442 38.448V41.712C491.666 42.24 490.273 42.384 489.218 42.384C484.802 42.384 482.546 40.272 482.546 35.808V20.88H478.994V17.856H482.546V11.712H486.482V17.856H492.818V20.88H486.434V35.616C486.434 38.16 487.73 39.024 489.938 39.024C490.85 39.024 491.906 38.928 493.442 38.448ZM519.8 42H515.912V37.632C514.76 40.656 511.88 42.576 508.232 42.576C502.76 42.576 499.688 39.264 499.688 33.408V17.856H503.72V32.64C503.72 37.104 505.592 39.456 509.384 39.456C513.032 39.456 515.768 36.96 515.768 31.152V17.856H519.8V42ZM535.055 42L525.407 17.856H529.487L537.263 38.064H537.359L544.799 17.856H548.783L539.519 42H535.055ZM570.62 17.856L576.092 37.68H576.188L581.756 17.856H585.596L578.3 42H574.172L568.604 22.464H568.46L562.988 42H558.812L551.516 17.856H555.452L561.068 37.68H561.212L566.588 17.856H570.62ZM592.971 42H588.699L597.867 29.568L589.179 17.856H593.883L600.315 26.736L606.699 17.856H611.019L602.475 29.376L611.787 42H607.131L599.979 32.304L592.971 42ZM624.587 42.192L614.891 17.856H619.067L626.747 37.584H626.843L634.091 17.856H638.219L628.475 42.72C626.267 48.48 624.347 50.88 619.931 50.928C619.259 50.928 618.347 50.832 617.579 50.688V47.424C618.347 47.616 618.875 47.616 619.499 47.616C621.899 47.616 623.003 46.272 624.587 42.192ZM661.403 20.784L647.003 38.928H661.931V42H642.059V39.408L656.555 20.928H642.635V17.856H661.403V20.784ZM28.944 90L25.152 80.448H8.736L4.944 90H0.816L14.688 55.728H19.344L33.264 90H28.944ZM16.896 59.856L10.08 77.04H23.808L17.04 59.856H16.896ZM52.1261 90H38.5421V55.728H50.5901C58.2221 55.728 62.6381 58.896 62.6381 64.896C62.6381 68.064 60.2381 71.328 57.3101 72.192C61.5341 73.248 64.1741 76.368 64.1741 80.4C64.1741 86.688 59.7101 90 52.1261 90ZM42.6221 70.848H50.8301C55.9181 70.848 58.4621 68.688 58.4621 64.944C58.4621 61.152 55.9661 59.088 50.8781 59.088H42.6221V70.848ZM42.6221 74.064V86.64H51.9341C57.1661 86.64 60.0461 84.336 60.0461 80.4C60.0461 76.464 57.0701 74.064 51.8381 74.064H42.6221ZM73.2803 72.816C73.2803 81.36 77.3603 87.072 84.4163 87.072C90.1763 87.072 92.6723 83.856 93.4403 80.016H97.4723C96.3683 86.256 91.9043 90.576 84.4163 90.576C75.5843 90.576 69.0563 83.616 69.0563 72.816C69.0563 62.064 75.5843 55.152 84.4163 55.152C91.9043 55.152 96.3683 59.472 97.4723 65.712H93.4403C92.6723 61.872 90.1763 58.656 84.4163 58.656C77.3603 58.656 73.2803 64.272 73.2803 72.816ZM116.171 55.728C126.107 55.728 132.875 62.592 132.875 72.864C132.875 83.184 126.107 90 116.171 90H104.027V55.728H116.171ZM116.171 59.184H108.107V86.544H116.171C124.139 86.544 128.603 81.168 128.603 72.864C128.603 64.608 124.139 59.184 116.171 59.184ZM162.929 90H139.745V55.728H162.881V59.184H143.825V71.136H160.769V74.64H143.825V86.544H162.929V90ZM170.542 90V55.728H192.478V59.184H174.67V71.712H190.846V75.168H174.67V90H170.542ZM197.4 72.816C197.4 62.064 204.168 55.152 213.24 55.152C220.872 55.152 225.432 59.376 226.632 65.712H222.504C221.592 61.44 218.472 58.656 213.24 58.656C205.944 58.656 201.624 64.272 201.624 72.816C201.624 81.36 205.848 87.072 213.096 87.072C218.856 87.072 223.128 83.52 223.128 77.952V76.176H215.016V72.912H227.16V90H223.896L223.512 84.288C222.216 87.984 217.608 90.576 213.048 90.576C203.976 90.576 197.4 83.616 197.4 72.816ZM235.277 90V55.728H239.405V70.848H259.469V55.728H263.597V90H259.469V74.304H239.405V90H235.277ZM272.542 90V55.728H276.67V90H272.542ZM300.451 77.904V55.728H304.579V77.856C304.579 85.584 300.259 90.576 293.011 90.576C286.819 90.576 281.971 86.88 281.779 80.112H285.763C286.003 84.96 289.027 87.312 293.011 87.312C298.195 87.312 300.451 83.616 300.451 77.904ZM336.083 90L322.355 73.68L317.123 79.008V90H312.995V55.728H317.123V74.352L335.171 55.728H340.163L325.235 70.8L341.075 90H336.083ZM346.98 90V55.728H351.108V86.544H369.54V90H346.98ZM395.32 90H391.96L380.824 59.952H380.728V90H376.792V55.728H383.176L393.736 84.624H393.832L404.392 55.728H410.536V90H406.552V59.952H406.456L395.32 90ZM424.536 55.728L442.824 83.088H442.92V55.728H446.904V90H443.064L423.576 60.768H423.48V90H419.448V55.728H424.536ZM485.006 72.864C485.006 83.184 478.91 90.576 469.406 90.576C459.902 90.576 453.806 83.184 453.806 72.864C453.806 62.592 459.902 55.152 469.406 55.152C478.91 55.152 485.006 62.592 485.006 72.864ZM480.734 72.864C480.734 64.608 476.894 58.656 469.406 58.656C461.87 58.656 458.03 64.608 458.03 72.864C458.03 81.168 461.87 87.072 469.406 87.072C476.894 87.072 480.734 81.168 480.734 72.864ZM504.59 76.224H495.95V90H491.87V55.728H504.542C512.174 55.728 516.59 59.232 516.59 65.952C516.59 72.72 512.174 76.224 504.59 76.224ZM495.95 72.768H504.446C509.63 72.768 512.462 70.608 512.462 65.952C512.462 61.296 509.63 59.184 504.446 59.184H495.95V72.768ZM550.35 90.336L548.046 92.448L544.446 88.608C542.286 89.904 539.694 90.576 536.766 90.576C527.262 90.576 521.166 83.184 521.166 72.864C521.166 62.592 527.262 55.152 536.766 55.152C546.27 55.152 552.366 62.592 552.366 72.864C552.366 78.672 550.398 83.568 546.99 86.736L550.35 90.336ZM525.39 72.864C525.39 81.168 529.23 87.072 536.766 87.072C538.734 87.072 540.462 86.64 541.902 85.92L537.87 81.6L540.222 79.44L544.446 84C546.894 81.456 548.094 77.568 548.094 72.864C548.094 64.608 544.254 58.656 536.766 58.656C529.23 58.656 525.39 64.608 525.39 72.864ZM563.31 90H559.23V55.728H572.43C580.11 55.728 584.478 59.328 584.478 65.904C584.478 71.472 580.59 74.592 576.558 75.504L585.966 90H581.31L572.43 76.128H563.31V90ZM563.31 72.672H572.19C577.374 72.672 580.302 70.368 580.302 65.904C580.302 61.584 577.374 59.184 572.19 59.184H563.31V72.672ZM590.115 79.872H594.099C594.627 85.392 599.139 87.264 604.227 87.264C609.123 87.264 612.723 84.912 612.723 80.784C612.723 77.904 611.139 76.032 606.483 75.168L599.955 73.872C595.347 73.008 591.219 70.896 591.219 64.992C591.219 59.376 596.067 55.152 603.171 55.152C610.515 55.152 615.363 58.32 616.035 64.512H612.051C611.475 60.672 608.115 58.464 603.219 58.464C598.227 58.464 595.251 61.248 595.251 64.848C595.251 68.256 597.171 69.456 601.347 70.272L608.067 71.664C613.347 72.72 616.707 75.168 616.707 80.592C616.707 86.448 611.523 90.576 604.275 90.576C596.835 90.576 590.595 87.36 590.115 79.872ZM632.688 90V59.184H619.92V55.728H649.632V59.184H636.816V90H632.688ZM683.243 76.032C683.243 85.392 678.203 90.576 669.371 90.576C660.635 90.576 655.499 85.392 655.499 75.936V55.728H659.627V76.272C659.627 83.568 663.371 87.072 669.371 87.072C675.419 87.072 679.115 83.568 679.115 76.272V55.728H683.243V76.032ZM701.874 90L688.05 55.728H692.37L704.274 85.776H704.37L716.274 55.728H720.498L706.578 90H701.874ZM752.417 90L744.689 61.2H744.593L736.817 90H732.161L722.513 55.728H726.881L734.753 84.864H734.849L742.577 55.728H746.945L754.721 84.864H754.817L762.641 55.728H766.769L757.121 90H752.417ZM796.033 90L784.561 74.88L773.233 90H768.769L782.353 72L770.065 55.728H774.913L784.753 68.88L794.593 55.728H799.057L786.961 71.712L800.833 90H796.033ZM819.516 90H815.388V75.792L802.332 55.728H806.892L817.596 72.096H817.692L828.06 55.728H832.62L819.516 75.792V90ZM862.527 58.992L841.215 86.544H862.671V90H835.935V87.072L857.343 59.184H836.655V55.728H862.527V58.992ZM1.2 111.552V108.768C7.056 108.768 9.168 107.136 9.984 103.584H12.528V138H8.4V111.552H1.2ZM42.6353 113.136C42.6353 119.568 37.3073 122.448 32.1713 125.76C27.9953 128.544 23.8672 131.424 23.8672 134.544H42.9713V138H19.4513V136.128C19.4513 130.032 25.3553 125.76 30.4433 122.592C35.0033 119.664 38.6993 117.12 38.6993 113.136C38.6993 109.872 36.8273 106.608 31.7393 106.608C27.0353 106.608 24.2993 110.16 24.0113 114.288H20.1233C20.4593 108.24 24.5872 103.152 31.7873 103.152C38.9873 103.152 42.6353 108.048 42.6353 113.136ZM71.544 128.688C71.544 134.016 67.272 138.576 59.592 138.576C52.248 138.576 47.496 134.448 47.016 127.968H51.048C51.336 132.24 54.36 135.216 59.592 135.216C64.584 135.216 67.656 132.672 67.656 128.544C67.656 124.56 64.68 122.304 60.168 122.304H56.424V118.944H60.024C63.624 118.944 66.744 117.36 66.744 112.944C66.744 109.44 64.44 106.512 59.736 106.512C54.84 106.512 52.104 109.92 51.864 114H47.976C48.36 108.048 52.344 103.152 59.736 103.152C67.08 103.152 70.728 107.808 70.728 112.896C70.728 117.12 67.944 120.048 64.584 120.528C68.664 121.152 71.544 124.416 71.544 128.688ZM96.9563 103.728V125.28H104.3V128.592H96.9563V138H92.9243V128.592H75.9323V125.232L92.3003 103.728H96.9563ZM92.9243 108L79.9163 125.28H92.9243V108ZM120.627 118.56C117.027 118.56 114.627 120.336 113.331 122.4H109.635L111.555 103.728H130.851V107.232H114.531L113.379 118.56C114.819 116.736 117.795 115.2 120.963 115.2C128.115 115.2 132.579 120.384 132.579 126.864C132.579 133.392 128.115 138.576 120.627 138.576C113.715 138.576 108.771 134.448 108.243 127.824H112.323C112.659 132.192 115.827 135.216 120.675 135.216C126.051 135.216 128.595 131.232 128.595 126.864C128.595 122.496 126.051 118.56 120.627 118.56ZM151.08 106.608C144.744 106.608 141.432 113.184 141.432 122.064C142.536 118.512 145.896 115.104 151.128 115.104C157.896 115.104 162.456 120.096 162.456 126.672C162.456 133.584 157.752 138.576 150.6 138.576C143.016 138.576 137.592 131.952 137.592 121.44C137.592 110.592 143.256 103.152 151.128 103.152C157.224 103.152 161.352 106.752 162.12 112.512H158.328C157.512 108.624 155.16 106.608 151.08 106.608ZM150.6 135.216C155.496 135.216 158.568 131.616 158.568 126.816C158.568 121.968 155.496 118.464 150.6 118.464C145.8 118.464 142.536 121.968 142.536 126.816C142.536 131.616 145.8 135.216 150.6 135.216ZM185.88 107.232H166.296V103.728H190.392V106.656C182.232 116.544 179.352 126.336 179.208 138H174.888C175.032 125.856 179.4 115.488 185.88 107.232ZM207.5 103.152C213.932 103.152 218.828 106.704 218.828 112.608C218.828 116.496 216.572 119.28 213.164 120.624C216.812 121.296 220.364 124.608 220.364 128.64C220.364 134.544 215.372 138.576 207.5 138.576C199.724 138.576 194.684 134.544 194.684 128.64C194.684 124.608 198.236 121.296 201.884 120.624C198.523 119.28 196.22 116.496 196.22 112.608C196.22 106.704 201.116 103.152 207.5 103.152ZM207.5 118.848C211.628 118.848 215.036 116.832 215.036 112.608C215.036 108.432 211.628 106.416 207.5 106.416C203.42 106.416 200.012 108.432 200.012 112.608C200.012 116.832 203.42 118.848 207.5 118.848ZM207.5 135.264C212.972 135.264 216.236 132.672 216.236 128.64C216.236 124.656 212.972 122.16 207.5 122.16C202.124 122.16 198.812 124.656 198.812 128.64C198.812 132.672 202.124 135.264 207.5 135.264ZM236.811 135.12C243.147 135.12 246.459 128.544 246.459 119.664C245.355 123.216 241.995 126.624 236.763 126.624C229.995 126.624 225.435 121.632 225.435 115.056C225.435 108.144 230.139 103.152 237.291 103.152C244.875 103.152 250.299 109.776 250.299 120.288C250.299 131.136 244.635 138.576 236.763 138.576C230.667 138.576 226.539 134.976 225.771 129.216H229.563C230.379 133.104 232.731 135.12 236.811 135.12ZM237.291 106.512C232.395 106.512 229.323 110.112 229.323 114.912C229.323 119.76 232.395 123.264 237.291 123.264C242.091 123.264 245.355 119.76 245.355 114.912C245.355 110.112 242.091 106.512 237.291 106.512ZM255.483 120.864C255.483 110.592 260.811 103.152 269.115 103.152C277.467 103.152 282.747 110.592 282.747 120.864C282.747 131.136 277.467 138.576 269.115 138.576C260.811 138.576 255.483 131.136 255.483 120.864ZM259.707 120.864C259.707 129.264 262.875 135.024 269.115 135.024C275.403 135.024 278.571 129.264 278.571 120.864C278.571 112.464 275.403 106.704 269.115 106.704C262.875 106.704 259.707 112.464 259.707 120.864ZM288.018 137.952V132.768H293.25V138.816C293.25 142.8 290.85 145.536 286.482 145.536V143.088C288.93 143.088 290.322 141.984 290.322 138.816V137.952H288.018ZM302.736 138V132.768H307.968V138H302.736ZM321.487 132.96C321.199 134.08 320.831 135.296 320.383 136.608C319.935 137.92 319.439 139.216 318.895 140.496C318.383 141.808 317.871 143.04 317.359 144.192H314.191C314.415 143.296 314.639 142.336 314.863 141.312C315.119 140.288 315.359 139.248 315.583 138.192C315.807 137.168 315.999 136.16 316.159 135.168C316.351 134.176 316.511 133.264 316.639 132.432H321.151L321.487 132.96ZM316.063 114.864C316.063 113.648 316.351 112.8 316.927 112.32C317.503 111.84 318.191 111.6 318.991 111.6C319.823 111.6 320.527 111.84 321.103 112.32C321.711 112.8 322.015 113.648 322.015 114.864C322.015 116.016 321.711 116.848 321.103 117.36C320.527 117.872 319.823 118.128 318.991 118.128C318.191 118.128 317.503 117.872 316.927 117.36C316.351 116.848 316.063 116.016 316.063 114.864ZM329.003 135.408C329.003 134.224 329.291 133.392 329.867 132.912C330.443 132.432 331.131 132.192 331.931 132.192C332.763 132.192 333.467 132.432 334.043 132.912C334.651 133.392 334.955 134.224 334.955 135.408C334.955 136.56 334.651 137.392 334.043 137.904C333.467 138.416 332.763 138.672 331.931 138.672C331.131 138.672 330.443 138.416 329.867 137.904C329.291 137.392 329.003 136.56 329.003 135.408ZM329.003 114.864C329.003 113.648 329.291 112.8 329.867 112.32C330.443 111.84 331.131 111.6 331.931 111.6C332.763 111.6 333.467 111.84 334.043 112.32C334.651 112.8 334.955 113.648 334.955 114.864C334.955 116.016 334.651 116.848 334.043 117.36C333.467 117.872 332.763 118.128 331.931 118.128C331.131 118.128 330.443 117.872 329.867 117.36C329.291 116.848 329.003 116.016 329.003 114.864ZM346.215 128.352H343.479L342.279 103.728H347.415L346.215 128.352ZM341.847 135.408C341.847 134.224 342.135 133.392 342.711 132.912C343.287 132.432 343.991 132.192 344.823 132.192C345.623 132.192 346.311 132.432 346.887 132.912C347.495 133.392 347.799 134.224 347.799 135.408C347.799 136.56 347.495 137.392 346.887 137.904C346.311 138.416 345.623 138.672 344.823 138.672C343.991 138.672 343.287 138.416 342.711 137.904C342.135 137.392 341.847 136.56 341.847 135.408ZM358.001 127.056C358.001 125.84 358.113 124.8 358.337 123.936C358.593 123.04 359.009 122.192 359.585 121.392C360.193 120.592 361.009 119.76 362.033 118.896C363.281 117.84 364.241 116.96 364.913 116.256C365.617 115.552 366.113 114.864 366.401 114.192C366.689 113.52 366.833 112.704 366.833 111.744C366.833 110.208 366.337 109.024 365.345 108.192C364.353 107.36 362.913 106.944 361.025 106.944C359.457 106.944 358.065 107.152 356.849 107.568C355.633 107.952 354.465 108.416 353.345 108.96L351.857 105.6C353.137 104.928 354.545 104.368 356.081 103.92C357.649 103.472 359.393 103.248 361.313 103.248C364.353 103.248 366.705 104 368.369 105.504C370.033 107.008 370.865 109.056 370.865 111.648C370.865 113.088 370.625 114.32 370.145 115.344C369.697 116.336 369.041 117.264 368.177 118.128C367.345 118.96 366.353 119.856 365.201 120.816C364.145 121.712 363.329 122.496 362.753 123.168C362.209 123.84 361.841 124.512 361.649 125.184C361.457 125.824 361.361 126.608 361.361 127.536V128.352H358.001V127.056ZM356.897 135.408C356.897 134.224 357.169 133.392 357.713 132.912C358.289 132.432 359.009 132.192 359.873 132.192C360.673 132.192 361.361 132.432 361.937 132.912C362.513 133.392 362.801 134.224 362.801 135.408C362.801 136.56 362.513 137.392 361.937 137.904C361.361 138.416 360.673 138.672 359.873 138.672C359.009 138.672 358.289 138.416 357.713 137.904C357.169 137.392 356.897 136.56 356.897 135.408ZM412.462 120.864C412.462 122.336 412.286 123.776 411.934 125.184C411.614 126.592 411.102 127.872 410.398 129.024C409.694 130.144 408.83 131.056 407.806 131.76C406.782 132.432 405.566 132.768 404.158 132.768C402.686 132.768 401.518 132.352 400.654 131.52C399.822 130.656 399.31 129.68 399.118 128.592H398.878C398.302 129.776 397.454 130.768 396.334 131.568C395.214 132.368 393.806 132.768 392.11 132.768C389.678 132.768 387.79 131.952 386.446 130.32C385.134 128.688 384.478 126.528 384.478 123.84C384.478 121.728 384.894 119.872 385.726 118.272C386.558 116.64 387.726 115.36 389.23 114.432C390.766 113.504 392.574 113.04 394.654 113.04C396.062 113.04 397.438 113.168 398.782 113.424C400.158 113.648 401.23 113.904 401.998 114.192L401.518 123.936C401.486 124.512 401.47 124.928 401.47 125.184C401.47 125.408 401.47 125.568 401.47 125.664C401.47 127.328 401.758 128.432 402.334 128.976C402.942 129.52 403.646 129.792 404.446 129.792C405.438 129.792 406.27 129.392 406.942 128.592C407.646 127.76 408.174 126.672 408.526 125.328C408.91 123.952 409.102 122.448 409.102 120.816C409.102 117.84 408.494 115.328 407.278 113.28C406.094 111.2 404.446 109.616 402.334 108.528C400.254 107.44 397.886 106.896 395.23 106.896C392.51 106.896 390.094 107.328 387.982 108.192C385.87 109.056 384.094 110.272 382.654 111.84C381.246 113.408 380.174 115.264 379.438 117.408C378.702 119.52 378.334 121.856 378.334 124.416C378.334 127.552 378.894 130.224 380.014 132.432C381.134 134.608 382.766 136.272 384.91 137.424C387.086 138.544 389.742 139.104 392.878 139.104C394.83 139.104 396.686 138.88 398.446 138.432C400.238 138.016 401.822 137.552 403.198 137.04V140.304C401.822 140.88 400.27 141.344 398.542 141.696C396.846 142.08 394.958 142.272 392.878 142.272C389.102 142.272 385.87 141.568 383.182 140.16C380.494 138.752 378.43 136.736 376.99 134.112C375.582 131.456 374.878 128.272 374.878 124.56C374.878 121.584 375.342 118.832 376.27 116.304C377.198 113.744 378.542 111.536 380.302 109.68C382.062 107.792 384.19 106.336 386.686 105.312C389.214 104.256 392.062 103.728 395.23 103.728C397.726 103.728 400.014 104.128 402.094 104.928C404.206 105.696 406.03 106.832 407.566 108.336C409.134 109.808 410.334 111.6 411.166 113.712C412.03 115.824 412.462 118.208 412.462 120.864ZM388.222 123.936C388.222 125.984 388.622 127.472 389.422 128.4C390.254 129.328 391.358 129.792 392.734 129.792C394.526 129.792 395.806 129.12 396.574 127.776C397.374 126.432 397.838 124.688 397.966 122.544L398.254 116.544C397.838 116.416 397.31 116.304 396.67 116.208C396.03 116.112 395.374 116.064 394.702 116.064C393.134 116.064 391.87 116.448 390.91 117.216C389.95 117.984 389.262 118.976 388.846 120.192C388.43 121.376 388.222 122.624 388.222 123.936ZM438.306 117.072L436.818 124.752H443.394V127.968H436.194L434.226 138H430.818L432.786 127.968H425.922L424.05 138H420.69L422.514 127.968H416.466V124.752H423.138L424.674 117.072H418.242V113.904H425.25L427.17 103.728H430.626L428.706 113.904H435.618L437.538 103.728H440.85L438.93 113.904H445.026V117.072H438.306ZM426.546 124.752H433.41L434.898 117.072H428.034L426.546 124.752ZM458.441 135.648C456.681 135.616 454.969 135.472 453.305 135.216C451.641 134.928 450.297 134.544 449.273 134.064V129.984C450.361 130.496 451.753 130.944 453.449 131.328C455.145 131.712 456.809 131.92 458.441 131.952V122.256C456.873 121.808 455.497 121.328 454.313 120.816C453.161 120.272 452.217 119.664 451.481 118.992C450.745 118.32 450.185 117.552 449.801 116.688C449.449 115.792 449.273 114.768 449.273 113.616C449.273 112.048 449.641 110.704 450.377 109.584C451.145 108.464 452.217 107.584 453.593 106.944C454.969 106.272 456.585 105.888 458.441 105.792V101.568H461.513V105.744C463.209 105.776 464.745 105.968 466.121 106.32C467.529 106.64 468.809 107.04 469.961 107.52L468.665 111.072C467.641 110.656 466.505 110.304 465.257 110.016C464.041 109.696 462.793 109.488 461.513 109.392V119.04C463.625 119.648 465.385 120.304 466.793 121.008C468.201 121.68 469.257 122.528 469.961 123.552C470.697 124.544 471.065 125.84 471.065 127.44C471.065 129.68 470.233 131.504 468.569 132.912C466.905 134.288 464.553 135.136 461.513 135.456V140.784H458.441V135.648ZM461.513 131.712C463.401 131.52 464.777 131.088 465.641 130.416C466.505 129.712 466.937 128.816 466.937 127.728C466.937 126.928 466.777 126.272 466.457 125.76C466.137 125.216 465.577 124.752 464.777 124.368C464.009 123.984 462.921 123.616 461.513 123.264V131.712ZM458.441 109.488C457.289 109.552 456.345 109.76 455.609 110.112C454.873 110.432 454.313 110.864 453.929 111.408C453.577 111.952 453.401 112.576 453.401 113.28C453.401 114.112 453.545 114.832 453.833 115.44C454.153 116.016 454.681 116.512 455.417 116.928C456.153 117.312 457.161 117.664 458.441 117.984V109.488ZM488.358 103.2C490.086 103.2 491.558 103.504 492.774 104.112C494.022 104.688 494.982 105.52 495.654 106.608C496.326 107.696 496.662 109.024 496.662 110.592C496.662 112.608 496.006 114.32 494.694 115.728C493.414 117.136 491.782 118.416 489.798 119.568L499.062 128.496C499.894 127.504 500.566 126.368 501.078 125.088C501.622 123.776 502.07 122.368 502.422 120.864H506.694C506.182 122.912 505.542 124.816 504.774 126.576C504.006 128.336 503.014 129.872 501.798 131.184L508.806 138H503.094L498.918 133.968C498.15 134.64 497.35 135.264 496.518 135.84C495.718 136.384 494.838 136.848 493.878 137.232C492.918 137.616 491.878 137.92 490.758 138.144C489.67 138.368 488.454 138.48 487.11 138.48C484.902 138.48 482.982 138.128 481.35 137.424C479.75 136.688 478.502 135.616 477.606 134.208C476.742 132.8 476.31 131.088 476.31 129.072C476.31 127.44 476.598 126.032 477.174 124.848C477.782 123.664 478.646 122.608 479.766 121.68C480.886 120.752 482.198 119.856 483.702 118.992C483.03 118.224 482.374 117.424 481.734 116.592C481.094 115.76 480.566 114.864 480.15 113.904C479.734 112.912 479.526 111.84 479.526 110.688C479.526 109.12 479.878 107.776 480.582 106.656C481.286 105.536 482.294 104.688 483.606 104.112C484.95 103.504 486.534 103.2 488.358 103.2ZM486.246 121.632C485.094 122.304 484.102 122.992 483.27 123.696C482.47 124.368 481.846 125.12 481.398 125.952C480.95 126.784 480.726 127.776 480.726 128.928C480.726 130.688 481.318 132.096 482.502 133.152C483.686 134.208 485.27 134.736 487.254 134.736C489.302 134.736 491.062 134.4 492.534 133.728C494.006 133.056 495.238 132.256 496.23 131.328L486.246 121.632ZM488.214 106.656C486.87 106.656 485.766 107.008 484.902 107.712C484.07 108.416 483.654 109.392 483.654 110.64C483.654 111.792 483.958 112.864 484.566 113.856C485.174 114.816 486.054 115.888 487.206 117.072C489.094 115.984 490.438 114.96 491.238 114C492.07 113.008 492.486 111.872 492.486 110.592C492.486 109.44 492.102 108.496 491.334 107.76C490.566 107.024 489.526 106.656 488.214 106.656ZM518.282 103.248C520.65 103.248 522.442 104.192 523.658 106.08C524.874 107.936 525.482 110.56 525.482 113.952C525.482 117.344 524.89 120 523.706 121.92C522.554 123.808 520.746 124.752 518.282 124.752C516.778 124.752 515.498 124.32 514.442 123.456C513.386 122.592 512.586 121.36 512.042 119.76C511.53 118.128 511.274 116.192 511.274 113.952C511.274 110.56 511.834 107.936 512.954 106.08C514.074 104.192 515.85 103.248 518.282 103.248ZM518.282 106.224C517.066 106.224 516.17 106.88 515.594 108.192C515.05 109.472 514.778 111.392 514.778 113.952C514.778 116.512 515.05 118.448 515.594 119.76C516.17 121.072 517.066 121.728 518.282 121.728C519.53 121.728 520.458 121.088 521.066 119.808C521.674 118.496 521.978 116.544 521.978 113.952C521.978 111.392 521.674 109.472 521.066 108.192C520.458 106.88 519.53 106.224 518.282 106.224ZM540.218 103.728L521.21 138H517.514L536.522 103.728H540.218ZM539.258 116.976C540.826 116.976 542.138 117.408 543.194 118.272C544.25 119.104 545.05 120.32 545.594 121.92C546.17 123.488 546.458 125.408 546.458 127.68C546.458 131.072 545.866 133.728 544.682 135.648C543.53 137.536 541.722 138.48 539.258 138.48C537.754 138.48 536.474 138.048 535.418 137.184C534.362 136.32 533.562 135.088 533.018 133.488C532.506 131.856 532.25 129.92 532.25 127.68C532.25 124.288 532.81 121.664 533.93 119.808C535.05 117.92 536.826 116.976 539.258 116.976ZM539.258 120C538.042 120 537.146 120.64 536.57 121.92C536.026 123.2 535.754 125.12 535.754 127.68C535.754 130.272 536.026 132.224 536.57 133.536C537.146 134.816 538.042 135.456 539.258 135.456C540.506 135.456 541.434 134.816 542.042 133.536C542.65 132.256 542.954 130.304 542.954 127.68C542.954 125.12 542.65 123.2 542.042 121.92C541.434 120.64 540.506 120 539.258 120ZM555.773 101.232C556.125 101.936 556.557 102.736 557.069 103.632C557.613 104.496 558.173 105.344 558.749 106.176C559.357 107.008 559.901 107.728 560.381 108.336V108.912H557.549C557.005 108.464 556.397 107.936 555.725 107.328C555.053 106.688 554.381 106.032 553.709 105.36C553.069 104.656 552.477 103.984 551.933 103.344C551.421 102.704 551.021 102.16 550.733 101.712V101.232H555.773ZM575.225 122.688C574.073 122.176 573.113 121.84 572.345 121.68C571.609 121.488 570.889 121.392 570.185 121.392C569.289 121.392 568.345 121.664 567.353 122.208C566.361 122.752 565.481 123.424 564.713 124.224V120.48C565.481 119.648 566.345 119.024 567.305 118.608C568.265 118.16 569.321 117.936 570.473 117.936C571.401 117.936 572.313 118.032 573.209 118.224C574.137 118.416 575.337 118.832 576.809 119.472C577.961 119.984 578.905 120.336 579.641 120.528C580.409 120.688 581.129 120.768 581.801 120.768C582.729 120.768 583.689 120.496 584.681 119.952C585.673 119.408 586.553 118.736 587.321 117.936V121.632C586.553 122.464 585.689 123.104 584.729 123.552C583.769 124 582.713 124.224 581.561 124.224C580.665 124.224 579.737 124.128 578.777 123.936C577.849 123.712 576.665 123.296 575.225 122.688ZM591.605 125.184L601.781 103.488H604.181L615.413 125.184H611.669L603.029 107.952L595.349 125.184H591.605ZM632.706 101.52L631.746 110.736L640.962 108.144L641.634 112.56L632.802 113.28L638.514 120.864L634.386 123.12L630.306 114.72L626.61 123.12L622.338 120.864L627.954 113.28L619.218 112.56L619.89 108.144L629.01 110.736L628.002 101.52H632.706ZM1.92 172.848C1.92 170.224 2.16 167.664 2.64 165.168C3.152 162.672 3.936 160.288 4.992 158.016C6.048 155.744 7.376 153.648 8.976 151.728H12.96C11.488 153.712 10.24 155.856 9.216 158.16C8.224 160.464 7.472 162.848 6.96 165.312C6.448 167.776 6.192 170.272 6.192 172.8C6.192 175.264 6.448 177.712 6.96 180.144C7.472 182.576 8.224 184.912 9.216 187.152C10.208 189.424 11.44 191.568 12.912 193.584H8.976C7.376 191.696 6.048 189.632 4.992 187.392C3.936 185.184 3.152 182.848 2.64 180.384C2.16 177.92 1.92 175.408 1.92 172.848ZM26.8706 172.848C26.8706 175.408 26.6146 177.92 26.1026 180.384C25.6226 182.848 24.8546 185.184 23.7986 187.392C22.7746 189.632 21.4466 191.696 19.8146 193.584H15.8786C17.3506 191.568 18.5826 189.424 19.5746 187.152C20.5666 184.912 21.3186 182.576 21.8306 180.144C22.3426 177.712 22.5986 175.264 22.5986 172.8C22.5986 170.272 22.3426 167.776 21.8306 165.312C21.3186 162.848 20.5666 160.464 19.5746 158.16C18.5826 155.856 17.3346 153.712 15.8306 151.728H19.8146C21.4466 153.648 22.7746 155.744 23.7986 158.016C24.8546 160.288 25.6226 162.672 26.1026 165.168C26.6146 167.664 26.8706 170.224 26.8706 172.848ZM43.3733 193.584H32.6213V151.728H43.3733V155.184H36.7493V190.128H43.3733V193.584ZM45.7781 190.128H52.4021V155.184H45.7781V151.728H56.5301V193.584H45.7781V190.128ZM77.079 193.584C75.127 193.552 73.431 193.264 71.991 192.72C70.583 192.176 69.495 191.328 68.727 190.176C67.959 189.056 67.575 187.648 67.575 185.952V178.896C67.575 177.808 67.351 176.944 66.903 176.304C66.455 175.632 65.799 175.152 64.935 174.864C64.071 174.544 62.999 174.384 61.719 174.384V170.88C62.999 170.848 64.071 170.688 64.935 170.4C65.799 170.112 66.455 169.648 66.903 169.008C67.351 168.336 67.575 167.472 67.575 166.416V159.312C67.575 158.032 67.799 156.928 68.247 156C68.727 155.04 69.383 154.256 70.215 153.648C71.079 153.008 72.087 152.528 73.239 152.208C74.391 151.888 75.671 151.728 77.079 151.728V155.184C75.991 155.216 75.047 155.392 74.247 155.712C73.447 156.032 72.823 156.512 72.375 157.152C71.959 157.792 71.751 158.64 71.751 159.696V166.608C71.751 168.24 71.319 169.552 70.455 170.544C69.591 171.504 68.279 172.144 66.519 172.464V172.752C68.311 173.072 69.623 173.728 70.455 174.72C71.319 175.68 71.751 176.976 71.751 178.608V185.664C71.751 186.688 71.959 187.52 72.375 188.16C72.791 188.832 73.399 189.312 74.199 189.6C74.999 189.92 75.959 190.096 77.079 190.128V193.584ZM80.1454 190.128C81.2654 190.096 82.2094 189.92 82.9774 189.6C83.7774 189.28 84.3854 188.784 84.8014 188.112C85.2494 187.472 85.4734 186.64 85.4734 185.616V178.656C85.4734 177.024 85.9054 175.728 86.7694 174.768C87.6334 173.776 88.9454 173.12 90.7054 172.8V172.512C88.9454 172.192 87.6334 171.552 86.7694 170.592C85.9054 169.6 85.4734 168.288 85.4734 166.656V159.648C85.4734 158.592 85.2654 157.744 84.8494 157.104C84.4334 156.464 83.8254 155.984 83.0254 155.664C82.2574 155.344 81.2974 155.184 80.1454 155.184V151.728C81.6174 151.728 82.9294 151.888 84.0814 152.208C85.2654 152.528 86.2734 153.008 87.1054 153.648C87.9374 154.256 88.5614 155.04 88.9774 156C89.4254 156.96 89.6494 158.08 89.6494 159.36V166.368C89.6494 167.456 89.8734 168.336 90.3214 169.008C90.7694 169.648 91.4254 170.128 92.2894 170.448C93.1854 170.736 94.2574 170.88 95.5054 170.88V174.384C94.2574 174.384 93.1854 174.544 92.2894 174.864C91.4254 175.152 90.7694 175.616 90.3214 176.256C89.8734 176.896 89.6494 177.76 89.6494 178.848V186C89.6494 187.696 89.2494 189.104 88.4494 190.224C87.6494 191.344 86.5294 192.176 85.0894 192.72C83.6814 193.296 82.0334 193.584 80.1454 193.584V190.128ZM118.252 193.392H96.7477V190.32H118.252V193.392ZM120.86 166.032V162.624H142.844V166.032H120.86ZM120.86 175.584V172.176H142.844V175.584H120.86ZM149.817 174.288V170.784H163.113V174.288H149.817ZM182.705 167.376H192.257V170.784H182.705V180.672H179.249V170.784H169.697V167.376H179.249V157.44H182.705V167.376ZM219.774 180.432L197.166 170.496V168.096L219.774 156.816V160.56L201.678 169.104L219.774 176.688V180.432ZM224.634 176.688L242.73 169.152L224.634 160.56V156.816L247.242 168.096V170.496L224.634 180.432V176.688ZM267.079 151.728L254.311 186H250.183L262.951 151.728H267.079ZM272.171 151.728L284.987 186H280.811L268.043 151.728H272.171ZM296.894 149.52H300.398V197.568H296.894V149.52ZM319.539 151.728L318.579 164.112H315.939L314.979 151.728H319.539ZM330.321 151.728L329.361 164.112H326.721L325.761 151.728H330.321ZM339.105 151.728L338.145 164.112H335.505L334.545 151.728H339.105Z" fill="#111111"/>
					</svg>`,
                    commit_mono_example: `<svg width="1000" height="200" viewBox="0 0 1000 200" fill="none" xmlns="http://www.w3.org/2000/svg">
			   		<path d="M19.776 31.92V28.224C19.008 28.752 17.952 29.136 16.752 29.376L13.344 30C9.84 30.672 7.968 32.352 7.968 34.944C7.968 37.536 9.84 39.216 12.768 39.216C16.704 39.216 19.776 36.048 19.776 31.92ZM19.872 37.872C18.384 40.752 15.6 42.48 12.048 42.48C7.248 42.48 3.936 39.36 3.936 34.992C3.936 30.72 7.152 27.84 12.768 27.024L16.32 26.496C18.624 26.16 19.776 25.104 19.776 23.28C19.776 20.688 17.568 18.96 14.304 18.96C11.28 18.96 8.976 20.496 8.688 22.656H4.656C4.896 18.624 8.976 15.6 14.304 15.6C19.824 15.6 23.712 18.816 23.712 23.328V32.736C23.712 36.768 24.048 39.792 24.672 42H20.928C20.544 40.896 20.256 39.552 20.064 37.872H19.872ZM44.0933 38.928C48.3653 38.928 51.2933 34.896 51.2933 29.04C51.2933 23.184 48.3653 19.152 44.0933 19.152C39.8213 19.152 36.8453 23.232 36.8453 29.04C36.8453 34.848 39.8213 38.928 44.0933 38.928ZM36.7013 42H33.0053V6.48H36.9413V20.4H37.1813C38.7653 17.328 41.4053 15.6 44.7653 15.6C50.8613 15.6 55.2773 21.264 55.2773 29.04C55.2773 36.816 50.8613 42.48 44.8133 42.48C41.2613 42.48 38.5253 40.56 36.9413 37.152H36.7013V42ZM78.7305 35.376H82.7625C81.8985 39.6 77.9145 42.48 73.1145 42.48C66.3465 42.48 61.4025 36.72 61.4025 28.992C61.4025 21.216 66.2505 15.6 72.9705 15.6C77.8185 15.6 81.7065 18.48 82.4265 22.656H78.4425C77.7225 20.496 75.5625 19.152 72.9225 19.152C68.3625 19.152 65.3385 23.136 65.3385 28.992C65.3385 34.896 68.4585 38.928 73.1625 38.928C75.8505 38.928 78.0585 37.584 78.7305 35.376ZM99.9758 38.928C104.2 38.928 107.08 34.848 107.08 29.04C107.08 23.184 104.2 19.152 100.024 19.152C95.7518 19.152 92.6797 23.328 92.6797 29.04C92.6797 34.752 95.7518 38.928 99.9758 38.928ZM107.128 37.344H106.888C105.304 40.608 102.616 42.48 99.1598 42.48C93.1118 42.48 88.6478 36.816 88.6478 29.04C88.6478 21.312 93.1118 15.6 99.1598 15.6C102.52 15.6 105.16 17.328 106.744 20.448H106.984V6.48H110.968V33.36C110.968 35.808 111.112 38.976 111.304 42H107.512C107.32 40.368 107.224 38.88 107.128 37.344ZM122.853 26.64H136.437C136.197 22.08 133.461 19.056 129.765 19.056C126.165 19.056 123.477 21.984 122.853 26.64ZM140.325 29.76H122.709C122.997 35.328 125.925 38.976 130.341 38.976C133.029 38.976 135.189 37.584 135.957 35.376H139.845C138.885 39.648 135.045 42.48 130.293 42.48C123.573 42.48 118.773 36.816 118.773 28.896C118.773 21.12 123.333 15.6 129.765 15.6C135.957 15.6 140.325 20.784 140.325 28.272V29.76ZM155.138 42V19.632H147.794V16.08H155.138V15.12C155.138 9.168 158.066 6 163.586 6C165.506 6 167.234 6.384 168.578 7.104V10.416C167.138 9.696 165.698 9.312 164.162 9.312C160.754 9.312 159.074 11.232 159.074 15.12V16.08H168.098V19.632H159.074V42H155.138ZM187.088 29.76C190.16 29.76 192.32 27.552 192.32 24.432C192.32 21.264 190.16 19.104 187.088 19.104C183.968 19.104 181.808 21.264 181.808 24.432C181.808 27.552 183.968 29.76 187.088 29.76ZM190.16 40.752H184.016C181.616 40.752 179.792 42.384 179.792 44.448C179.792 47.04 182.816 48.768 187.328 48.768C191.984 48.768 195.056 46.944 195.056 44.16C195.056 42 193.232 40.752 190.16 40.752ZM180.368 39.12C179.023 38.304 178.208 36.96 178.208 35.28C178.208 33.456 179.264 31.92 180.992 31.008C179.12 29.424 177.968 27.072 177.968 24.288C177.968 19.248 181.76 15.6 187.088 15.6C188.192 15.6 189.248 15.744 190.256 16.08H198.704V19.392H194.72C195.68 20.736 196.208 22.416 196.208 24.288C196.208 29.376 192.32 33.12 187.088 33.12C185.744 33.12 184.496 32.88 183.392 32.448C182.336 32.928 181.664 33.792 181.664 34.848C181.664 36.144 182.624 37.056 183.92 37.056H190.4C195.632 37.056 198.992 39.696 198.992 43.728C198.992 48.624 194.096 52.08 187.184 52.08C180.752 52.08 176.192 49.056 176.192 44.832C176.192 42.24 177.824 40.128 180.368 39.12ZM210.589 42H206.653V6.48H210.589V19.824H210.781C212.221 17.136 214.717 15.6 217.837 15.6C222.541 15.6 225.757 19.152 225.757 24.48V42H221.773V24.816C221.773 21.264 219.853 18.96 216.877 18.96C213.229 18.96 210.589 22.32 210.589 27.024V42ZM235.578 42V38.448H243.402V19.632H235.818V16.08H247.338V38.448H255.162V42H235.578ZM241.242 7.728C241.242 5.76 242.826 4.224 244.746 4.224C246.714 4.224 248.25 5.76 248.25 7.728C248.25 9.648 246.714 11.232 244.746 11.232C242.826 11.232 241.242 9.648 241.242 7.728ZM278.471 42.96C278.471 48.912 275.543 52.08 270.023 52.08C268.103 52.08 266.375 51.696 265.031 50.976V47.664C266.471 48.384 267.911 48.768 269.447 48.768C272.807 48.768 274.535 46.848 274.535 42.96V19.632H265.271V16.08H278.471V42.96ZM272.519 7.728C272.519 5.76 274.103 4.224 276.023 4.224C277.991 4.224 279.527 5.76 279.527 7.728C279.527 9.648 277.991 11.232 276.023 11.232C274.103 11.232 272.519 9.648 272.519 7.728ZM292.421 42V6.48H296.357V29.232L308.453 16.08H313.493L303.701 26.592L314.357 42H309.653L301.013 29.52L296.357 34.464V42H292.421ZM331.426 33.312C331.426 37.248 333.106 39.12 336.562 39.12C338.002 39.12 339.49 38.784 340.882 38.064V41.376C339.538 42.096 337.81 42.48 335.89 42.48C330.37 42.48 327.442 39.312 327.442 33.312V10.032H319.906V6.48H331.426V33.312ZM347.631 42V16.08H351.183V18.864H351.375C352.095 16.848 353.871 15.6 356.031 15.6C358.335 15.6 360.063 17.04 360.735 19.44H360.927C361.887 16.896 363.711 15.6 366.207 15.6C369.855 15.6 372.111 18.288 372.111 22.56V42H368.271V23.088C368.271 20.496 367.167 18.912 365.343 18.912C363.279 18.912 361.839 20.976 361.839 23.952V42H357.951V23.088C357.951 20.448 356.847 18.912 355.071 18.912C353.007 18.912 351.519 21.024 351.519 24.048V42H347.631ZM383.276 42H379.34V16.08H383.036V20.064H383.228C384.62 17.232 387.164 15.6 390.476 15.6C395.276 15.6 398.444 19.152 398.444 24.48V42H394.46V24.816C394.46 21.216 392.588 18.96 389.564 18.96C385.868 18.96 383.276 22.32 383.276 27.024V42ZM417.338 42.48C410.81 42.48 406.058 36.864 406.058 29.04C406.058 21.216 410.81 15.6 417.338 15.6C423.866 15.6 428.666 21.216 428.666 29.04C428.666 36.864 423.866 42.48 417.338 42.48ZM417.338 38.88C421.658 38.88 424.634 34.848 424.634 29.04C424.634 23.232 421.658 19.2 417.338 19.2C413.018 19.2 410.042 23.232 410.042 29.04C410.042 34.848 413.018 38.88 417.338 38.88ZM447.031 19.152C442.759 19.152 439.783 23.232 439.783 29.04C439.783 34.848 442.759 38.928 447.031 38.928C451.303 38.928 454.231 34.896 454.231 29.04C454.231 23.184 451.303 19.152 447.031 19.152ZM435.943 51.6V16.08H439.639V20.928H439.879C441.463 17.52 444.151 15.6 447.751 15.6C453.799 15.6 458.215 21.264 458.215 29.04C458.215 36.816 453.799 42.48 447.703 42.48C444.343 42.48 441.703 40.752 440.119 37.68H439.879V51.6H435.943ZM473.988 19.152C469.716 19.152 466.788 23.184 466.788 29.04C466.788 34.896 469.716 38.928 473.988 38.928C478.26 38.928 481.236 34.848 481.236 29.04C481.236 23.232 478.26 19.152 473.988 19.152ZM485.076 16.08V51.6H481.14V37.68H480.9C479.316 40.752 476.676 42.48 473.316 42.48C467.22 42.48 462.804 36.816 462.804 29.04C462.804 21.264 467.22 15.6 473.268 15.6C476.868 15.6 479.556 17.52 481.14 20.928H481.38V16.08H485.076ZM499.889 27.264V42H495.953V16.08H499.649V20.256H499.841C501.281 17.424 503.873 15.744 507.137 15.744C511.217 15.744 514.145 18.48 514.625 22.656H510.449C509.969 20.544 508.289 19.2 506.033 19.2C502.433 19.2 499.889 22.512 499.889 27.264ZM522.767 35.376H526.655C526.991 37.584 529.631 39.216 532.799 39.216C536.063 39.216 538.271 37.44 538.271 34.752C538.271 32.64 536.879 31.536 533.279 30.96L532.127 30.816C526.367 29.904 523.679 27.696 523.679 23.616C523.679 18.912 527.327 15.6 532.607 15.6C537.647 15.6 541.631 18.624 541.919 22.656H538.127C537.791 20.544 535.487 19.008 532.607 19.008C529.631 19.008 527.615 20.688 527.615 23.28C527.615 25.392 529.007 26.496 532.367 27.024L533.567 27.168C539.471 28.08 542.207 30.336 542.207 34.368C542.207 39.264 538.223 42.672 532.559 42.672C527.135 42.672 522.911 39.552 522.767 35.376ZM561.532 33.312C561.532 37.248 563.212 39.12 566.668 39.12C568.156 39.12 569.596 38.784 571.036 38.064V41.376C569.692 42.096 567.964 42.48 566.044 42.48C560.524 42.48 557.596 39.312 557.596 33.312V19.632H550.252V16.08H557.596V8.592L561.532 7.92V16.08H570.556V19.632H561.532V33.312ZM599.289 16.08V33.36C599.289 35.808 599.433 38.976 599.625 42H595.881C595.689 40.656 595.593 39.408 595.545 38.16H595.353C593.913 40.896 591.369 42.48 588.153 42.48C583.353 42.48 580.185 38.928 580.185 33.6V16.08H584.169V33.264C584.169 36.864 586.041 39.12 589.065 39.12C592.761 39.12 595.353 35.76 595.353 31.056V16.08H599.289ZM616.31 42L607.91 16.08H611.942L618.854 37.824H619.046L625.766 16.08H629.702L621.494 42H616.31ZM637.556 42L633.956 16.08H637.652L640.436 37.632H640.628L645.668 18.96H649.508L654.596 37.68H654.788L657.572 16.08H661.22L657.62 42H652.676L647.684 23.568H647.492L642.548 42H637.556ZM664.993 42L673.681 28.656L665.761 16.08H670.369L676.369 25.776L682.417 16.08H686.881L678.961 28.56L687.745 42H683.089L676.321 31.392L669.553 42H664.993ZM693.918 51.312V47.952C694.926 48.288 695.886 48.432 696.846 48.432C699.822 48.432 701.454 46.992 702.894 43.104L703.278 42.048L693.822 16.08H697.95L705.198 36.672H705.39L712.59 16.08H716.574L706.446 44.208C704.574 49.488 701.838 51.84 697.374 51.84C696.318 51.84 695.214 51.696 693.918 51.312ZM723.947 42V38.832L738.443 19.536H724.427V16.08H743.291V19.248L728.747 38.544H744.107V42H723.947ZM14.256 60.192L9.408 76.416H19.296L14.448 60.192H14.256ZM11.472 56.4H17.328L27.456 90H23.328L20.352 80.064H8.352L5.376 90H1.344L11.472 56.4ZM37.2293 74.4V86.352H45.2453C48.4133 86.352 50.6213 83.904 50.6213 80.4C50.6213 76.848 48.4133 74.4 45.2453 74.4H37.2293ZM37.2293 60.048V70.752H44.6693C47.5973 70.752 49.6133 68.496 49.6133 65.28C49.6133 62.16 47.6453 60.048 44.6693 60.048H37.2293ZM45.0533 90H33.1013V56.4H44.4293C49.8053 56.4 53.6453 60 53.6453 64.992C53.6453 68.4 51.8693 71.088 49.0373 72.432C52.5413 73.68 54.7493 76.752 54.7493 80.736C54.7493 86.112 50.6693 90 45.0533 90ZM79.8825 81.456H83.9145C83.1945 86.736 78.6825 90.48 73.1625 90.48C65.6265 90.48 60.3945 83.424 60.3945 73.2C60.3945 62.928 65.5785 55.92 73.1145 55.92C78.4905 55.92 82.8105 59.472 83.5785 64.416H79.5465C78.8745 61.584 76.3305 59.664 73.2105 59.664C67.9305 59.664 64.5225 65.04 64.5225 73.248C64.5225 81.456 67.9305 86.736 73.2105 86.736C76.5225 86.736 79.2105 84.624 79.8825 81.456ZM90.2318 90V56.4H99.7358C107.848 56.4 113.368 63.216 113.368 73.2C113.368 83.184 107.848 90 99.7358 90H90.2318ZM94.3118 86.352H99.7358C105.496 86.352 109.24 81.168 109.24 73.2C109.24 65.232 105.496 60.048 99.7358 60.048H94.3118V86.352ZM120.645 90V56.4H140.613V60.048H124.773V70.752H138.453V74.4H124.773V86.352H140.613V90H120.645ZM150.002 90V56.4H169.97V60.048H154.082V71.376H167.81V75.024H154.082V90H150.002ZM194.528 75.6H186.944V71.952H198.512V90H194.768V84.96H194.576C192.8 88.416 189.872 90.48 186.272 90.48C179.6 90.48 174.704 83.376 174.704 73.392C174.704 63.024 179.936 55.92 187.568 55.92C192.992 55.92 197.408 59.472 198.272 64.416H194.192C193.472 61.584 190.832 59.664 187.664 59.664C182.288 59.664 178.832 64.992 178.832 73.296C178.832 81.36 182.096 86.832 186.944 86.832C191.408 86.832 194.528 82.224 194.528 75.6ZM204.637 90V56.4H208.765V70.752H222.973V56.4H227.101V90H222.973V74.496H208.765V90H204.637ZM234.666 90V86.352H242.586V60.048H234.762V56.4H254.586V60.048H246.714V86.352H254.682V90H234.666ZM261.863 81.456H265.799C266.039 84.624 268.679 86.832 272.279 86.832C276.215 86.832 278.759 84.24 278.759 80.208V60.048H265.655V56.4H282.887V80.448C282.887 86.4 278.615 90.48 272.279 90.48C266.231 90.48 261.863 86.736 261.863 81.456ZM291.317 90V56.4H295.397V73.536L310.661 56.4H315.701L303.173 70.512L316.325 90H311.573L300.484 73.632L295.397 79.344V90H291.317ZM322.546 90V56.4H326.674V86.352H342.034V90H322.546ZM347.439 90V56.4H352.911L359.679 77.28H359.871L366.639 56.4H372.159V90H368.271V67.776C368.271 65.712 368.271 63.84 368.463 61.632L368.271 61.584L361.551 82.272H357.999L351.279 61.584L351.087 61.632C351.279 63.84 351.279 65.712 351.279 67.776V90H347.439ZM396.14 77.856V56.4H399.98V90H394.892L380.972 60.672L380.78 60.72C380.924 62.4 380.972 63.84 380.972 66.864V90H377.18V56.4H382.94L396.14 84.048L396.332 84C396.188 82.32 396.14 80.88 396.14 77.856ZM417.338 90.48C409.898 90.48 404.666 83.376 404.666 73.2C404.666 63.024 409.898 55.92 417.338 55.92C424.778 55.92 430.01 63.024 430.01 73.2C430.01 83.376 424.778 90.48 417.338 90.48ZM417.338 86.736C422.522 86.736 425.882 81.36 425.882 73.2C425.882 64.992 422.522 59.664 417.338 59.664C412.154 59.664 408.794 64.992 408.794 73.2C408.794 81.36 412.154 86.736 417.338 86.736ZM440.695 60.048V72.048H449.095C452.407 72.048 454.663 69.648 454.663 66.048C454.663 62.448 452.407 60.048 449.095 60.048H440.695ZM440.695 90H436.567V56.4H448.855C454.615 56.4 458.647 60.384 458.647 66.048C458.647 71.712 454.615 75.696 448.855 75.696H440.695V90ZM474.9 86.736C476.58 86.736 478.068 86.16 479.316 85.104L473.172 78.912L475.332 76.752L481.284 82.704C482.676 80.4 483.444 77.136 483.444 73.2C483.444 64.992 480.084 59.664 474.9 59.664C469.716 59.664 466.356 64.992 466.356 73.2C466.356 81.36 469.716 86.736 474.9 86.736ZM474.9 90.48C467.46 90.48 462.228 83.376 462.228 73.2C462.228 63.024 467.46 55.92 474.9 55.92C482.34 55.92 487.572 63.024 487.572 73.2C487.572 78.24 486.276 82.512 484.116 85.536L489.492 90.912L487.284 93.072L482.052 87.84C480.036 89.52 477.636 90.48 474.9 90.48ZM497.873 60.048V71.376H506.129C509.345 71.376 511.457 69.12 511.457 65.712C511.457 62.352 509.345 60.048 506.129 60.048H497.873ZM497.873 90H493.745V56.4H505.889C511.505 56.4 515.441 60.24 515.441 65.712C515.441 70.32 512.705 73.728 508.577 74.736L516.401 90H511.889L504.257 75.072H497.873V90ZM521.183 81.456H525.167C525.503 84.72 528.575 87.024 532.559 87.024C536.783 87.024 539.663 84.48 539.663 80.928C539.663 77.808 537.503 75.888 533.231 75.024L531.311 74.592C525.215 73.392 522.143 70.32 522.143 65.472C522.143 59.808 526.319 55.92 532.463 55.92C538.415 55.92 543.023 59.568 543.311 64.416H539.327C538.943 61.584 536.111 59.568 532.511 59.568C528.671 59.568 526.175 61.824 526.175 65.184C526.175 68.112 528.047 69.936 531.839 70.752L533.807 71.136C540.383 72.432 543.695 75.648 543.695 80.688C543.695 86.592 539.183 90.672 532.607 90.672C526.175 90.672 521.375 86.784 521.183 81.456ZM559.18 90V60.048H549.052V56.4H573.436V60.048H563.308V90H559.18ZM601.257 56.4V79.44C601.257 85.92 596.601 90.48 590.025 90.48C583.449 90.48 578.793 85.92 578.793 79.44V56.4H582.921V79.44C582.921 83.808 585.801 86.736 590.025 86.736C594.297 86.736 597.129 83.808 597.129 79.44V56.4H601.257ZM616.07 90L605.654 56.4H609.878L618.758 85.44H618.95L627.83 56.4H631.958L621.542 90H616.07ZM636.548 90L632.995 56.4H636.74L639.572 84.624H639.764L645.859 61.488H649.364L655.412 84.624H655.604L658.436 56.4H662.18L658.628 90H653.54L647.684 67.68H647.492L641.636 90H636.548ZM662.497 90L673.825 72.528L663.265 56.4H667.969L676.369 69.216L684.769 56.4H689.377L678.865 72.48L690.241 90H685.537L676.321 75.84L667.105 90H662.497ZM703.086 90V75.888L691.758 56.4H696.318L705.198 71.76L714.126 56.4H718.542L707.214 75.888V90H703.086ZM722.219 90V86.592L739.883 60.048H722.699V56.4H744.827V59.808L727.211 86.352H745.643V90H722.219ZM4.032 138V134.4H13.008V114.528L4.464 114.48V111.312C11.424 111.312 13.2 110.016 14.016 104.4H17.136V134.4H25.728V138H4.032ZM54.1733 138H32.8133V136.416C32.8133 132.624 35.2133 129.024 41.3573 123.6C46.6373 118.944 48.6533 116.064 48.6533 113.088C48.6533 109.776 46.2053 107.568 42.7013 107.568C39.3413 107.568 36.7013 109.584 36.4133 112.416H32.2853C32.4773 107.568 36.8933 103.92 42.7013 103.92C48.5573 103.92 52.7333 107.616 52.7333 112.992C52.7333 117.072 50.2853 120.816 44.1893 126.144C40.2533 129.6 38.1893 132.048 37.4213 134.4H54.1733V138ZM65.5785 112.416H61.7385C61.7385 107.52 65.9145 103.92 71.6265 103.92C77.4345 103.92 81.6585 107.664 81.6585 112.848C81.6585 116.304 79.7865 118.848 76.6665 120C80.5545 121.248 82.9065 124.272 82.9065 128.448C82.9065 134.256 78.2505 138.48 71.7705 138.48C65.5305 138.48 60.8745 134.592 60.8745 129.456H64.8105C64.9545 132.576 67.8825 134.88 71.7705 134.88C75.9945 134.88 78.9705 132.192 78.9705 128.4C78.9705 124.752 76.1385 122.112 72.1545 122.112H69.1785V118.368H71.8665C75.3225 118.368 77.7225 116.208 77.7225 113.088C77.7225 109.824 75.1305 107.52 71.5785 107.52C68.2185 107.52 65.6745 109.584 65.5785 112.416ZM103.768 108.048L103.576 108L92.0078 126.384H103.576V114.192C103.576 112.128 103.576 110.256 103.768 108.048ZM103.576 130.032H88.2638V126.048L102.04 104.4H107.512V126.384H113.512V130.032H107.512V138H103.576V130.032ZM122.853 129.456C123.237 132.672 125.973 134.88 129.429 134.88C133.557 134.88 136.485 131.808 136.485 127.488C136.485 123.216 133.557 120.144 129.429 120.144C126.885 120.144 124.677 121.344 123.525 123.408L119.925 122.736L121.893 104.4H138.933V108H125.397L124.197 118.896C125.733 117.456 127.941 116.688 130.341 116.688C136.293 116.688 140.613 121.296 140.613 127.488C140.613 133.872 135.957 138.48 129.525 138.48C123.717 138.48 119.301 134.736 118.821 129.456H122.853ZM151.826 127.584C151.826 131.76 154.802 134.88 158.834 134.88C162.866 134.88 165.842 131.712 165.842 127.44C165.842 123.168 162.962 120.096 158.978 120.096C154.946 120.096 151.826 123.36 151.826 127.584ZM150.722 121.536C152.498 118.512 155.714 116.592 159.602 116.592C165.554 116.592 169.826 121.056 169.826 127.344C169.826 133.872 165.17 138.48 158.642 138.48C151.154 138.48 146.738 132.48 146.738 122.016C146.738 111.072 151.586 103.92 159.074 103.92C164.45 103.92 168.77 107.568 169.202 112.416H165.362C164.738 109.536 162.194 107.52 159.026 107.52C153.938 107.52 150.866 112.752 150.722 121.536ZM182.96 138C182.96 126.72 186.416 116.976 193.52 108.048H175.616V104.4H197.84V107.808C190.4 117.312 187.184 126.336 187.088 138H182.96ZM215.869 122.112C211.885 122.112 208.909 124.8 208.909 128.448C208.909 132.096 211.885 134.88 215.869 134.88C219.853 134.88 222.829 132.096 222.829 128.448C222.829 124.8 219.853 122.112 215.869 122.112ZM215.869 107.472C212.557 107.472 210.013 109.824 210.013 112.992C210.013 116.16 212.509 118.512 215.869 118.512C219.229 118.512 221.725 116.16 221.725 112.992C221.725 109.824 219.181 107.472 215.869 107.472ZM215.869 138.48C209.581 138.48 204.733 134.208 204.733 128.784C204.733 124.8 207.325 121.536 211.213 120.144C208.045 118.848 205.981 116.112 205.981 112.656C205.981 107.712 210.253 103.92 215.869 103.92C221.485 103.92 225.757 107.712 225.757 112.656C225.757 116.112 223.693 118.848 220.525 120.144C224.413 121.536 227.005 124.8 227.005 128.784C227.005 134.208 222.157 138.48 215.869 138.48ZM251.13 114.816C251.13 110.64 248.154 107.52 244.122 107.52C240.09 107.52 237.114 110.64 237.114 114.96C237.114 119.184 239.994 122.304 243.978 122.304C248.01 122.304 251.13 119.04 251.13 114.816ZM252.234 120.864C250.458 123.888 247.242 125.808 243.354 125.808C237.402 125.808 233.13 121.344 233.13 115.056C233.13 108.528 237.786 103.92 244.362 103.92C251.802 103.92 256.218 109.92 256.218 120.384C256.218 131.328 251.37 138.48 243.882 138.48C238.506 138.48 234.234 134.832 233.802 129.936H237.594C238.218 132.864 240.762 134.88 243.93 134.88C249.018 134.88 252.09 129.648 252.234 120.864ZM273.431 138.48C266.279 138.48 262.055 132.048 262.055 121.2C262.055 110.352 266.279 103.92 273.431 103.92C280.583 103.92 284.855 110.352 284.855 121.2C284.855 132.048 280.583 138.48 273.431 138.48ZM266.471 126.816L279.527 112.32C278.279 109.2 276.215 107.52 273.431 107.52C268.679 107.52 265.991 112.464 265.991 121.2C265.991 123.312 266.135 125.184 266.471 126.816ZM273.431 134.88C278.183 134.88 280.871 129.936 280.871 121.2C280.871 119.088 280.727 117.216 280.391 115.584L267.335 130.08C268.583 133.2 270.695 134.88 273.431 134.88ZM294.485 145.584L300.101 132.24H305.813L298.277 145.584H294.485ZM327.346 134.736C327.346 132.672 328.978 131.088 330.994 131.088C333.01 131.088 334.642 132.672 334.642 134.736C334.642 136.752 333.01 138.384 330.994 138.384C328.978 138.384 327.346 136.752 327.346 134.736ZM352.047 145.584L357.663 132.24H363.375L355.839 145.584H352.047ZM356.127 115.152C356.127 113.088 357.759 111.504 359.775 111.504C361.791 111.504 363.423 113.088 363.423 115.152C363.423 117.168 361.791 118.8 359.775 118.8C357.759 118.8 356.127 117.168 356.127 115.152ZM384.908 134.736C384.908 132.672 386.54 131.088 388.556 131.088C390.572 131.088 392.204 132.672 392.204 134.736C392.204 136.752 390.572 138.384 388.556 138.384C386.54 138.384 384.908 136.752 384.908 134.736ZM384.908 115.344C384.908 113.28 386.54 111.696 388.556 111.696C390.572 111.696 392.204 113.28 392.204 115.344C392.204 117.36 390.572 118.992 388.556 118.992C386.54 118.992 384.908 117.36 384.908 115.344ZM413.69 134.736C413.69 132.672 415.322 131.088 417.338 131.088C419.354 131.088 420.986 132.672 420.986 134.736C420.986 136.752 419.354 138.384 417.338 138.384C415.322 138.384 413.69 136.752 413.69 134.736ZM415.706 126.912L415.034 104.4H419.642L418.97 126.912H415.706ZM442.471 134.736C442.471 132.672 444.103 131.088 446.119 131.088C448.135 131.088 449.767 132.672 449.767 134.736C449.767 136.752 448.135 138.384 446.119 138.384C444.103 138.384 442.471 136.752 442.471 134.736ZM444.151 126.912C444.151 118.08 451.687 117.504 451.687 112.416C451.687 109.728 449.623 107.472 446.311 107.472C442.999 107.472 440.599 109.728 440.407 112.416H436.375C436.375 107.904 440.407 103.92 446.263 103.92C452.023 103.92 455.767 107.712 455.767 112.224C455.767 118.896 447.703 119.856 447.703 126.912H444.151ZM479.076 128.112C481.764 128.112 483.924 125.328 483.924 121.872C483.924 118.704 482.148 116.4 479.7 116.4C477.012 116.4 474.804 119.184 474.804 122.64C474.804 125.808 476.628 128.112 479.076 128.112ZM483.444 128.256C482.1 130.128 480.228 131.28 478.02 131.28C474.084 131.28 471.156 127.632 471.156 122.736C471.156 117.36 474.564 113.184 478.98 113.184C481.332 113.184 483.156 114.384 484.26 116.448H484.452C484.644 111.648 481.668 108.432 477.012 108.432C470.388 108.432 465.348 114.768 465.348 123.024C465.348 131.04 470.148 136.752 476.916 136.752C479.748 136.752 482.388 135.744 484.02 134.064L486.18 136.224C483.876 138.624 480.564 139.92 476.82 139.92C468.132 139.92 461.892 132.864 461.892 123.072C461.892 112.992 468.42 105.36 476.964 105.36C483.732 105.36 488.004 110.112 487.62 117.216L486.9 130.944H483.492L483.636 128.256H483.444ZM507.473 117.504H500.897L499.889 124.896H506.465L507.473 117.504ZM497.441 117.504H491.777V114.192H497.921L499.265 104.4H502.769L501.377 114.192H507.953L509.345 104.4H512.801L511.409 114.192H516.641V117.504H510.977L509.921 124.896H515.585V128.208H509.441L508.097 138H504.641L505.985 128.208H499.409L498.065 138H494.561L495.953 128.208H490.721V124.896H496.385L497.441 117.504ZM534.287 123.12V135.12C537.647 134.496 539.903 132.144 539.903 128.976C539.903 126.048 537.983 124.128 534.287 123.12ZM531.215 118.704V107.376C528.047 107.856 525.983 110.016 525.983 113.136C525.983 115.968 527.711 117.84 531.215 118.704ZM534.287 144.24H531.215V138.624C525.551 138.096 521.423 134.448 521.279 129.552H524.975C525.263 132.528 527.759 134.736 531.215 135.168V122.448C525.263 121.2 522.239 118.128 522.239 113.328C522.239 108.144 525.839 104.448 531.215 103.968V98.16H534.287V104.016C539.231 104.688 542.927 108.048 543.215 112.368H539.519C539.183 109.92 537.071 108.048 534.287 107.472V119.376C540.479 120.768 543.647 123.888 543.647 128.784C543.647 134.112 539.903 137.952 534.287 138.576V144.24ZM563.884 131.04L556.588 122.784L556.492 122.832C553.516 124.992 551.932 127.44 551.932 130.032C551.932 133.008 553.948 135.12 556.876 135.12C559.324 135.12 561.772 133.632 563.884 131.04ZM556.588 117.072L557.26 117.84L558.556 116.928C560.812 115.296 562.06 113.424 562.06 111.456C562.06 109.104 560.38 107.472 558.028 107.472C555.676 107.472 553.996 109.152 553.996 111.552C553.996 113.328 554.908 115.152 556.588 117.072ZM575.02 138H569.98L566.236 133.776C563.452 136.896 560.092 138.672 556.54 138.672C551.548 138.672 547.948 135.12 547.948 130.272C547.948 126.576 550.108 123.072 554.188 120.048L553.612 119.376C551.26 116.736 550.012 114 550.012 111.408C550.012 107.088 553.324 103.92 557.932 103.92C562.54 103.92 565.9 107.088 565.9 111.312C565.9 114.48 564.076 117.456 560.668 119.856L559.66 120.576L566.044 127.776C567.052 125.856 567.964 123.6 568.684 121.104H572.62C571.66 124.8 570.268 128.016 568.588 130.704L575.02 138ZM577.305 138L598.665 104.4H602.697L581.385 138H577.305ZM583.017 118.944C579.129 118.944 576.297 115.776 576.297 111.408C576.297 107.088 579.129 103.92 583.017 103.92C586.905 103.92 589.689 107.088 589.689 111.408C589.689 115.776 586.905 118.944 583.017 118.944ZM583.017 115.728C584.985 115.728 586.233 114 586.233 111.408C586.233 108.864 584.985 107.136 583.017 107.136C581.001 107.136 579.801 108.864 579.801 111.408C579.801 114 581.001 115.728 583.017 115.728ZM597.081 138.48C593.193 138.48 590.361 135.312 590.361 130.944C590.361 126.624 593.193 123.456 597.081 123.456C600.921 123.456 603.753 126.624 603.753 130.944C603.753 135.312 600.921 138.48 597.081 138.48ZM597.081 135.264C599.049 135.264 600.249 133.536 600.249 130.944C600.249 128.4 599.049 126.672 597.081 126.672C595.065 126.672 593.817 128.4 593.817 130.944C593.817 133.536 595.065 135.264 597.081 135.264ZM621.494 112.176L611.894 100.56H617.798L625.766 112.176H621.494ZM635.924 126.672V125.088C635.924 120.576 638.564 117.648 642.596 117.648C648.644 117.648 649.028 124.176 652.82 124.176C654.548 124.176 655.556 122.784 655.652 120.048L655.7 118.608H659.252V120.192C659.252 124.704 656.612 127.632 652.58 127.632C646.58 127.632 646.1 121.056 642.356 121.056C640.628 121.056 639.668 122.496 639.572 125.232L639.523 126.672H635.924ZM666.001 119.808L674.113 104.4H678.625L686.737 119.808H682.657L676.369 107.904L670.081 119.808H666.001ZM694.734 118.32L703.422 121.104V112.032H706.878V121.104L715.566 118.32L716.67 121.632L707.982 124.464L713.31 131.808L710.526 133.872L705.15 126.528L699.774 133.872L696.99 131.808L702.318 124.464L693.63 121.632L694.734 118.32ZM18.672 193.68C12.528 187.872 8.976 179.376 8.976 170.64C8.976 161.904 12.528 153.408 18.672 147.6H23.28C16.656 154.032 13.104 162.048 13.104 170.64C13.104 179.232 16.656 187.248 23.28 193.68H18.672ZM38.9093 193.68H34.3013C40.9253 187.248 44.4773 179.232 44.4773 170.64C44.4773 162.048 40.9253 154.032 34.3013 147.6H38.9093C45.0533 153.408 48.6053 161.904 48.6053 170.64C48.6053 179.376 45.0533 187.872 38.9093 193.68ZM66.7785 193.68V147.6H80.9865V151.2H70.7145V190.08H80.9865V193.68H66.7785ZM105.928 147.6V193.68H91.7198V190.08H101.992V151.2H91.7198V147.6H105.928ZM118.869 172.512V168.768H121.365C125.205 168.768 127.461 166.176 127.269 162.048L126.981 156.72C126.693 150.96 129.957 147.6 135.909 147.6H139.269V151.2H136.053C132.645 151.2 130.821 153.072 130.965 156.432L131.253 161.952C131.445 166.368 129.189 170.016 125.781 170.64C129.189 171.264 131.445 174.912 131.253 179.328L130.965 184.848C130.821 188.208 132.645 190.08 136.053 190.08H139.413V193.68H135.909C129.957 193.68 126.693 190.32 126.981 184.56L127.269 179.232C127.461 175.104 125.205 172.512 121.365 172.512H118.869ZM168.962 168.768V172.512H166.466C162.626 172.512 160.37 175.104 160.562 179.232L160.85 184.56C161.138 190.32 157.874 193.68 151.922 193.68H148.418V190.08H151.778C155.186 190.08 157.01 188.208 156.866 184.848L156.578 179.328C156.386 174.912 158.642 171.264 162.05 170.64C158.642 170.016 156.386 166.368 156.578 161.952L156.866 156.432C157.01 153.072 155.186 151.2 151.778 151.2H148.562V147.6H151.922C157.874 147.6 161.138 150.96 160.85 156.72L160.562 162.048C160.37 166.176 162.626 168.768 166.466 168.768H168.962ZM176.048 191.808V188.208H198.128V191.808H176.048ZM205.597 176.976V173.52H226.141V176.976H205.597ZM205.597 167.76V164.256H226.141V167.76H205.597ZM235.338 172.416V168.816H253.962V172.416H235.338ZM271.511 181.872V172.416H262.199V168.816H271.511V159.408H275.399V168.816H284.663V172.416H275.399V181.872H271.511ZM292.085 172.848V168.432L311.381 158.496V162.576L295.733 170.64L311.381 178.704V182.784L292.085 172.848ZM341.122 168.432V172.848L321.826 182.784V178.704L337.474 170.64L321.826 162.576V158.496L341.122 168.432ZM348.159 193.68L367.455 147.6H371.439L352.143 193.68H348.159ZM380.876 147.6L400.172 193.68H396.236L376.892 147.6H380.876ZM415.514 193.68V147.6H419.162V193.68H415.514ZM444.487 163.392L443.623 148.56H448.615L447.751 163.392H444.487ZM468.516 163.392L467.652 148.56H472.644L471.78 163.392H468.516ZM478.02 163.392L477.156 148.56H482.148L481.284 163.392H478.02Z" fill="#111111"/>
			   		</svg>`,
                },
                timeline: [
                    {
                        name: "franklin_gothic",
                        src: "franklin_gothic.svg",
                        description: [
                            "Franklin Gothic, 1896.",
                            "Tried-and-true, but overly traditional for code.",
                            "Inspiration was taken from most of the letter constructions, such as 'g'.",
                        ],
                    },
                    {
                        name: "letter_gothic",
                        src: "letter_gothic.svg",
                        description: [
                            "Letter Gothic, 1956.",
                            "Clear, simple and monospaced, but too quirky.",
                            "The first simple monospaced sans-serif. Inspiration was taken in the simple shapes.",
                        ],
                    },
                    {
                        name: "fira_mono",
                        src: "fira_mono.svg",
                        description: [
                            "Fira Mono, 2013.",
                            "Great letter distinction, but overly complex and unique.",
                            "Inspiration was taken in the way Fira handles monospace symbols.",
                        ],
                    },
                    {
                        name: "untitled_sans",
                        src: "untitled_sans.svg",
                        description: [
                            "Untitled Sans, 2017.",
                            "Intentionally neutral, but not optimised for code.",
                            "Inspiration was taken in its neutral nature.",
                        ],
                    },
                    {
                        name: "commit_mono_example",
                        src: "commit_mono.svg",
                        description: [
                            "Commit Mono, 2023.",
                            "Neutral and functional, created and tested for code.",
                            "Commit Mono takes the best of all the fonts before it and merges it into a clean package.",
                        ],
                    },
                ],
            },
        },
        {
            name: "intelligent",
            description: `Commit Mono uses an innovative technique to improve kerning. Kerning is crucial for efficient reading, but it’s not possible if you want a monospaced font. ‘Smart Kerning’ combats this by sliding letters to better spacing positions – all while preserving monospacing. This gives Commit Mono a superior reading experience compared to other monospaced fonts.

Tip: Press <span class="span_key">+</span> and <span class="span_key">-</span> to zoom in and out.`,
            content: {},
        },
        {
            name: "code",
            description:
                "Commit Mono is designed and tested for code first. Characters frequently used in code have been given extra care to look distinct and neat.",
            content: {
                characters: [
                    {
                        value: "0",
                        name: "zero",
                        description:
                            "0 (zero): The slashed '0' is easy to tell apart from 'O' at small sizes. Change to a dotted zero in '07 Customize'.",
                    },
                    {
                        value: "1",
                        name: "one",
                        description:
                            "1 (one): The '1' is in Helvetica style because it's easy to tell apart from 'l' and 'I' – even at small sizes.",
                    },
                    {
                        value: "@",
                        name: "at",
                        description:
                            "@ (at): The complex curves of the '@' function poorly at small sizes, hence the simplification of the design. Change to a more traditional '@' in '07 Customize'.",
                    },
                    {
                        value: "$",
                        name: "dollar",
                        description:
                            "$ (dollar): The '$' is slashed all the way through to make it easily distinguishable from 'S'.",
                    },
                    {
                        value: "?",
                        name: "question",
                        description: "? (question): The '?' and exclam symbols are simple and recognisable.",
                    },
                    {
                        value: '"',
                        name: "quotedbl",
                        description: `" (double quote): The " and ' have been very carefully adjusted since they're used repeatedly in programming.`,
                    },
                    {
                        value: "%",
                        name: "percent",
                        description:
                            "% (percent): The '%' is a quite wide symbol, so it will always look squashed in monospace. It fills all available space to look more natural.",
                    },
                    {
                        value: "&",
                        name: "ampersand",
                        description:
                            "& (ampersand): Unlike most coding fonts, the '&' in Commit Mono looks normal and boring.",
                    },
                    {
                        value: "*",
                        name: "asterisk",
                        description:
                            "* (asterisk): The '*' is centered like '+' and '='. This is more common in programming, but it can be changed in '07 Customize'.",
                    },
                    {
                        value: "-",
                        name: "hyphen",
                        description:
                            "- Hyphen: The '-' is short but not too short. This is because it often works like a minus so it has to fit next to +.",
                    },
                    {
                        value: "(",
                        name: "parenleft",
                        description:
                            "( (left parenthesis): The parentheses are crucial in programming fonts and much care has been given to make them distinguishable.",
                    },
                    {
                        value: "[",
                        name: "bracketleft",
                        description: "[ (left bracket): The brackets are tall and wide to make them stand out.",
                    },
                    {
                        value: "{",
                        name: "braceleft",
                        description:
                            "{ (left brace): The braces are slightly bent but not overly. This results in a neutral aesthetic.",
                    },
                    {
                        value: "~",
                        name: "asciitilde",
                        description:
                            "~ (tilde): The '~' has a slightly exaggerated curve to make it easy to tell apart in small sizes.",
                    },
                    {
                        value: ";",
                        name: "semicolon",
                        description:
                            "; (semicolon): As seen in the semicolon, the period and the comma are very dissimilar so you always know what you're looking at",
                    },
                    {
                        value: "#",
                        name: "numbersign",
                        description: "# (hash/numbersign): The '#' is slightly tilted but remains stable.",
                    },
                    {
                        value: "`",
                        name: "grave",
                        description:
                            "` (grave): The backtick or accent grave is overly tilted to distinguish it more from the single quote '.",
                    },
                    {
                        value: "<",
                        name: "less",
                        description:
                            "< (less): Less and greater symbols are slightly more closed than some coding fonts, which ties it together better with the lowercase letters.",
                    },
                ],
            },
        },
        {
            name: "distinct",
            description: `With simple letter constructions and confident choices Commit Mono emphasises character distinction without compromising style consistency.

Tip: Press <span class="span_key">M</span> to switch between light and dark mode.`,
            content: {
                waterfall: {
                    sizes: [2.5, 1.5, 1, 0.875, 0.75, 0.625, 0.5625, 0.5],
                    texts: ["tl1I|!ij", "O0QDØ38B", `:;.,${"`"}‘'"`, "2Z5S7T6b"],
                },
                gtcDifficulties: [
                    { name: "Easy", size: 2 },
                    { name: "Medium", size: 2 },
                    { name: "Hard", size: 2 },
                    { name: "Expert", size: 2 },
                ],
                gtc: {
                    Easy: [
                        { value: ["O", "0"], options: ["uppercase o", "zero"] },
                        { value: ["2", "Z"], options: ["two", "uppercase z"] },
                        { value: ["6", "b"], options: ["six", "lowercase B"] },
                        { value: ["8", "B"], options: ["eight", "uppercase b"] },
                        { value: ["5", "S"], options: ["five", "uppercase s"] },
                    ],
                    Medium: [
                        { value: [".", ","], options: ["period", "comma"] },
                        { value: ["l", "1"], options: ["lowercase L", "one"] },
                        { value: ["$", "S"], options: ["dollar", "uppercase s"] },
                        { value: ["∆", "A"], options: ["delta", "uppercase a"] },
                        { value: ["+", "*"], options: ["plus", "asterisk"] },
                    ],
                    Hard: [
                        { value: ["æ", "œ"], options: ["lowercase AE", "lowercase OE"] },
                        { value: ["Ø", "0"], options: ["slashed O", "zero"] },
                        { value: ["ß", "B"], options: ["german double S", "uppercase b"] },
                        { value: ["‹", "<"], options: ["angle quotation mark", "less"] },
                        { value: ["-", "—"], options: ["hyphen", "emdash"] },
                    ],
                    Expert: [
                        { value: ["✓", "√"], options: ["check mark", "square root"] },
                        { value: ["×", "x"], options: ["multiply", "lowercase X"] },
                        { value: ["˚", "°"], options: ["ring", "degree"] },
                        { value: ["⁄", "/"], options: ["fraction", "slash"] },
                        { value: ["`", "'"], options: ["accent grave", "single quote"] },
                    ],
                },
            },
        },
        {
            name: "customize",
            description: `Customize Commit Mono to your liking before you download.`,
            content: {
                fonts: [
                    {
                        name: "Commit Mono",
                        cssName: "CommitMono",
                        id: "commit_mono",
                    },
                    {
                        name: "Fira Code",
                        cssName: "FiraCode",
                        id: "fira_code",
                    },
                    {
                        name: "JetBrains Mono",
                        cssName: "JetBrainsMono",
                        id: "jetbrains_mono",
                    },
                    {
                        name: "Source Code Pro",
                        cssName: "SourceCodePro",
                        id: "source_code_pro",
                    },
                    {
                        name: "Cascadia Code",
                        cssName: "CascadiaCode",
                        id: "cascadia_code",
                    },
                    {
                        name: "Consolas",
                        cssName: "Consolas",
                        id: "consolas",
                    },
                    {
                        name: "Menlo/Meslo",
                        cssName: "Menlo",
                        id: "menlo",
                    },
                ],
                weights: [
                    "200",
                    "225",
                    "250",
                    "275",
                    "300",
                    "325",
                    "350",
                    "375",
                    "400",
                    "425",
                    "450",
                    "475",
                    "500",
                    "525",
                    "550",
                    "575",
                    "600",
                    "625",
                    "650",
                    "675",
                    "700",
                ],
                features: [
                    {
                        type: "alternate",
                        name: "a",
                        label: "Alt. 'a'",
                        feature: "cv01",
                        on: false,
                        description: "Double storey |DEF| or single storey |ALT| lowercase 'a'.",
                        docsExample: "aáä",
                    },
                    {
                        type: "alternate",
                        name: "g",
                        label: "Alt. 'g'",
                        feature: "cv02",
                        on: false,
                        description: "Double storey |DEF| or single storey |ALT| lowercase 'g'.",
                        docsExample: "gğĝ",
                    },
                    {
                        type: "alternate",
                        name: "square",
                        label: "Square dots .:ij",
                        feature: "cv03",
                        on: false,
                        description: "Round |DEF| or square |ALT| dots in places of dots.",
                        docsExample: ".:!?iä",
                    },
                    {
                        type: "alternate",
                        name: "i",
                        label: "Alt. 'i'",
                        feature: "cv04",
                        on: false,
                        description: "Serif |DEF| or sans serif |ALT| lowercase 'i'.",
                        docsExample: "iíï",
                    },
                    {
                        type: "alternate",
                        name: "at",
                        label: "Standard @",
                        feature: "cv05",
                        on: false,
                        description: "Simplified |DEF| or traditional |ALT| at.",
                        docsExample: "@",
                    },
                    {
                        type: "alternate",
                        name: "six",
                        label: "Alt. '6', '9'",
                        feature: "cv06",
                        on: false,
                        description: "Closed |DEF| or open |ALT| terminal of 6 and 9.",
                        docsExample: "69",
                    },
                    {
                        type: "alternate",
                        name: "zero",
                        label: "Dotted 0",
                        feature: "cv07",
                        on: false,
                        description: "Slashed |DEF| or dotted |ALT| zero.",
                        docsExample: "0",
                    },
                    {
                        type: "alternate",
                        name: "slanted",
                        label: "Alt. italic 'aefgy'",
                        feature: "cv08",
                        on: false,
                        description:
                            "Slanted version |DEF| or italic version |ALT| of 'aefgy' in italic. Press I to view difference.",
                        docsExample: "aefgy",
                    },
                    {
                        type: "alternate",
                        name: "asterisk",
                        label: "Lifted *",
                        feature: "cv09",
                        on: false,
                        description: "Math/code asterisk |DEF| or small asterisk |ALT|.",
                        docsExample: "2*2",
                    },
                    {
                        type: "alternate",
                        name: "l",
                        label: "Alt. l",
                        feature: "cv10",
                        on: false,
                        description: "Rounded bottom |DEF| or serif bottom |ALT| lowercase 'l'.",
                        docsExample: "lĺŀ",
                    },
                    {
                        type: "alternate",
                        name: "one",
                        label: "Alt. 1",
                        feature: "cv11",
                        on: false,
                        description: "Straight top |DEF| or rounded top |ALT| '1'.",
                        docsExample: "1",
                    },
                    {
                        type: "feature",
                        name: "less_equal",
                        label: "Ligatures <= != === ",
                        feature: "ss01",
                        on: false,
                        description:
                            "No ligatures |OFF| or common sequences into a single symbol |ON|. Below is all supported. Works only with spaces on either side.",
                        docsExample: "i <= j  i >= k  i == l  i === m  i != n  i !== o",
                    },
                    {
                        type: "feature",
                        name: "arrows",
                        label: "Arrows >-> =>",
                        feature: "ss02",
                        on: false,
                        description:
                            "No arrows |OFF| or common arrow combination into connected arrows |ON|. Doesn’t make arrows with ~.",
                        docsExample: "-> => <==< >--> <==> <->",
                    },
                    {
                        type: "feature",
                        name: "case",
                        label: "Smart case (1:1) 2+3",
                        feature: "ss03",
                        on: true,
                        description:
                            "Normal casing |OFF| or automatically put symbols in uppercase if next to uppercase letters |ON|.",
                        docsExample: "H:  e:  H:o  H : H  H: o  H : o",
                    },
                    {
                        type: "feature",
                        name: "ellipsis",
                        label: "Symbol spacing ... <<",
                        feature: "ss04",
                        on: true,
                        description:
                            "No change |OFF| or squeeze 2 or 3 symbols closer together |ON|. Leaves 4 or more untouched. Only affects symbols: !?.:;/|<>",
                        docsExample: "... // <<< !?! /.. == ((( ....",
                    },
                    {
                        type: "feature",
                        name: "smartkerning",
                        label: "Smart kerning (immi)",
                        feature: "ss05",
                        on: true,
                        description:
                            "Normal monospace |OFF| or intelligently place letters in better spacing positions for easier reading |ON|.",
                        docsExample: "moi mio imo normal",
                    },
                ],
                languages: [
                    {
                        languageName: "JavaScript",
                        codeExample: `const isPalindromic = (number) => {
    if (number <= 1) {
        console.log("Usage: please input a non-negative integer");
        process.exit(1);
    }

    let reverse_number = 0, temp = number;
    while (temp > 0) {
        reverse_number = (reverse_number * 10) + (temp % 10);
        temp = Math.floor(temp / 10);
    }

    if (reverse_number == number)
        return true;
    else
        return false;

};

const input = process.argv[2];
let number = Number(input)

if (input !== '' && Number.isInteger(number) && number >= 0) {
    isPalindromic(input) ? console.log("true") : console.log("false");
} else {
    console.log("Usage: please input a non-negative integer")
}
`,
                    },
                    {
                        languageName: "TypeScript",
                        codeExample: `function fibonacci(num: number) {
    let n = Number(num)
    let elementOne: number = 0
    let elementTwo: number = 1
    let result: number = 0

    for (let i: number = 1; i <= n; i++) {
        result = elementOne + elementTwo
        elementOne = elementTwo
        elementTwo = result
        console.log(i + ": " + elementOne)
    }
}

let num_str = process.argv.length >= 3 ? process.argv[2] : ""
let num: number = parseInt(num_str)
if (isNaN(num)) {
    console.log("Usage: please input the count of fibonacci numbers to output")
    process.exit(0)
}

fibonacci(num)
`,
                    },
                    {
                        languageName: "HTML/CSS",
                        codeExample: `<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <style>
            @font-face {
                font-family: "Commit Mono";
                src: url("/fonts/CommitMono.woff2");
                font-weight: 400;
            }
            :root {
                --grey: #aaa;
            }
            button#grey::before {
                content: "01";
                font-style: italic;
                font-size: 2rem;
                color: var(--grey);
            }
        </style>
    </head>
    <body>
        <button id="grey">Commit Mono</button>
    </body>
</html>
`,
                    },
                    {
                        languageName: "Rust",
                        codeExample: `// Requirement     https://sample-programs.therenegadecoder.com/projects/prime-number/
// Accept a number on command line and print if it is Composite or Prime
// Works till  39 digits, ...

use std::env::args;
use std::process::exit;
use std::str::FromStr;

fn usage() -> ! {
    println!("Usage: please input a non-negative integer");
    exit(0);
}

fn parse_int<T: FromStr>(s: &str) -> Result<T, <T as FromStr>::Err> {
    s.trim().parse::<T>()
}

fn main() {
    let mut args = args().skip(1);

    // Exit if 1st command-line argument not an positive integer
    let input_num: u128 = args
        .next()
        .and_then(|s| parse_int(&s).ok())
        .unwrap_or_else(|| usage());

    if input_num < 2 || (input_num != 2 && input_num % 2 == 0) {
        println!("Composite");
        exit(0);
    }

    let mut n = 3u128;
    while n * n <= input_num {
        if input_num % n == 0 {
            println!("Composite");
            exit(0);
        }
        n += 2;
    }
    println!("Prime");
}
`,
                    },
                    {
                        languageName: "Python",
                        codeExample: `import sys
from math import sqrt, ceil


def is_prime(x):
    if (x % 2 == 0 and x is not 2) or (x == 1):
        return False
    return not bool([n for n in range(3, int(ceil(sqrt(x))+1)) if x % n == 0])


def exit_with_error():
    print('Usage: please input a non-negative integer')
    sys.exit(1)


def main(args):
    try:
        x = int(args[0])
        if x < 0:
            exit_with_error()
        print("Prime" if is_prime(x) else "Composite")
    except (IndexError, ValueError):
        exit_with_error()


if __name__ == "__main__":
    main(sys.argv[1:])
`,
                    },
                    {
                        languageName: "C++",
                        codeExample: `#include <iostream>
#include <stdlib.h>
#include <string.h>

using namespace std;

int main(int argc, char **argv)
{
    if (argc == 1)
    {
        cout << "Usage: please input a non-negative integer\\n";
        return 1;
    }
    string tmp = argv[1];
    if (argc == 1 || argv[1][0] == '\\0' || (atoi(argv[1]) == 0 && strcmp(argv[1], "0") != 0) || atoi(argv[1]) < 0 || tmp.find(".") != string::npos)
    {
        cout << "Usage: please input a non-negative integer\\n";
    }
    else
    {
        int input = atoi(argv[1]);
        if (input == 0 || input == 1)
        {
            cout << "composite\\n";
            return 0;
        }
        for (int i = 2; i < input; ++i)
        {
            if (input % i == 0)
            {
                cout << "composite\\n";
                return 0;
            }
        }
        cout << "Prime\\n";
    }

    return 0;
}
`,
                    },
                    {
                        languageName: "Kotlin",
                        codeExample: `fun main(args: Array<String>)
{
    if (args.isNullOrEmpty() || args[0].isBlank() || args[0].toIntOrNull()?.takeIf { it >= 0 } == null) {
        println("Usage: please input a non-negative integer")
        return
    }

    val num = args[0].toInt()
    if(num>1)
    {
        for(i in 2 until num)
        {
            if(num%i == 0)
            {
                println("Composite")
                return
            }
        }
        println("Prime")
    }
    else
    {
        println("Composite")
    }
}
`,
                    },
                    {
                        languageName: "Java",
                        codeExample: `class PrimeNumberException extends Exception {
}

public class PrimeNumber {

    public static boolean isPrime(int number) {
        if ((number % 2 == 0 && number != 2) || number == 1) {
            return false;
        }

        boolean foundFactor = false;
        for (int n = 3; n <= (int) Math.ceil(Math.sqrt(number)); ++n) {
            if ((number % n) == 0) {
                foundFactor = true;
                break;
            }
        }
        return !foundFactor;
    }

    public static void main(String[] args) {
        try {

            if (args.length < 1 || args[0].indexOf('-') != -1) {
                throw new PrimeNumberException();
            }

            if (isPrime(Integer.valueOf(args[0]))) {
                System.out.println("Prime");

            } else {
                System.out.println("Composite");
            }

        } catch (NumberFormatException | PrimeNumberException e) {
            System.err.println("Usage: please input a non-negative integer");
        }
    }
}
`,
                    },
                    {
                        languageName: "Ruby",
                        codeExample: `ROMAN_VALUES = { "I": 1, "V": 5, "X": 10, "L": 50, "C": 100, "D": 500, "M": 1000 }

def roman_valid?(roman_numbers)
    return false if roman_numbers.any? { |roman_number| !ROMAN_VALUES.keys.include?(roman_number.to_sym) }
    return false if roman_numbers.join.include?('MMMM')

    counter_numbers = roman_numbers.tally # Only on ruby 2.7+
    unless counter_numbers['M'].nil?
        return false if counter_numbers['M'] > 4
    end

    counter_numbers.reject { |k| k == 'M' }.all? { |(_, counter)| counter <= 3 }
end

def roman_to_decimal(full_roman_number)
    return 'Usage: please provide a string of roman numerals' if full_roman_number.nil?
    return 0 if full_roman_number.empty?

    roman_numbers = full_roman_number.upcase.split('')
    return 'Error: invalid string of roman numerals' unless roman_valid?(roman_numbers)

    total = 0

    roman_numbers.each_with_index do |roman_number, index|
        current_value = ROMAN_VALUES[roman_number.to_sym]
        next_value = ROMAN_VALUES[roman_numbers[index+1]&.to_sym] || 0

        if (current_value >= next_value)
            total += current_value
        else
            total -= current_value
        end
    end

    total
end

print(roman_to_decimal(ARGV[0]))
`,
                    },
                    {
                        languageName: "PHP",
                        codeExample: `<?php

/**
 * Function to determine if a number if prime.
 * @param int positive integer.
 * @return True if the number is prime, False otherwise.
 */
function is_prime($num)
{
    if (($num % 2 == 0 && $num != 2) || ($num == 1)) {
        return false;
    }

    $found_factor = false;
    for ($n = 3; $n <= intval(ceil(sqrt($num))); ++$n) {
        if (($num % $n) == 0) {
            $found_factor = true;
            break;
        }
    }

    return !$found_factor;
}

// Check argument
if ($argc < 2 || !is_numeric($argv[1]) || strpos($argv[1], '.') !== false || strpos($argv[1], '-') !== false) {
    echo "Usage: please input a non-negative integer\n";
    exit(1);
}

// Convert the string
if (is_prime(intval($argv[1]))) {
    echo "Prime\n";

} else {
    echo "Composite\n";
}

exit(0);
`,
                    },
                    {
                        languageName: "Fortran",
                        codeExample: `! upcase and to_upper didn't work,
! had to resort to check ASCII value of first letter & then
! subtract 32 from it, ...
program capitalize
character(len=100) :: cmd
character(len=1) :: firstletter
character(len=:), allocatable :: printoutput

! Anything not equal to single argument, Print Error
IF(COMMAND_ARGUMENT_COUNT().NE.1)THEN
    write(*,'(g0.8)')"Usage: please provide a string"
    STOP
ENDIF

CALL GET_COMMAND_ARGUMENT(1,cmd)
if (cmd == "") then
    write(*,'(g0.8)')"Usage: please provide a string"
    STOP
endif
! Get first letter
    firstletter = cmd(1:1)
    ! Check if first letter is between ASCII Value of a and z
    if (iachar(firstletter)>= iachar("a") .and. iachar(firstletter)<=iachar("z") ) then
    ! Subtract 32 from ASCII Value, to convert it to respective capital letter
        firstletter = achar(iachar(firstletter)-32)
! Overwrite the first letter
        cmd(1:1) = firstletter
    end if
        printoutput = adjustl(trim(cmd))
        write(*,'(g0.8)')printoutput
end program capitalize
`,
                    },
                    {
                        languageName: "Code Tests",
                        codeExample: `Focus, then press ENTER to edit

Hello world           print("Hello, World!")
Pangram               The quick brown fox jumps over a lazy dog
                      THE QUICK BROWN FOX JUMPS OVER A LAZY DOG
Confusable chars      ,. ;: |! Il1 2Z 5S 38B 0OQD
Vertical alignment    H=H x=x += -= <= >= ~= *= ^= |= %= &= ->
ASCII                  !"#$%&'()*+,-./
                      0123456789:;<=>?
                      @ABCDEFGHIJKLMNO
                      PQRSTUVWXYZ[\\]^_
                      ${"`"}abcdefghijklmno
                      pqrstuvwxyz{|}~
Code symbols          ,. "" '' ${"``"}
                      :;| \\/ [] () {}
                      * - + <>
Distinction test      o0O s5S 9gq z2Z !|l1Iij {([|])} .,;: ${"``"}''""
                      a@#* vVuUwW <>;^°=-~ öÖüÜäÄßµ \/\/ -- == __
                      0123456789 &-+@ for (int i=0; i<=j; ++i) {}








`,
                    },
                ],
                letterSpacings: {
                    min: -10,
                    max: 10,
                    step: 1,
                    value: 0,
                },
                lineHeights: {
                    min: 0.9,
                    max: 1.8,
                    step: 0.05,
                    value: 1,
                },
            },
        },
        {
            name: "install",
            description: "A short guide for how to install and enable your shiny new version of Commit Mono.",
            content: {},
        },
        {
            name: "docs",
            description: `Discover the docs of Commit Mono.

To file an issue or add improvements go to <a href="https://github.com/eigilnikolajsen/commit-mono/issues" tabindex="0" target="_blank" class="download_button">GitHub</a>.
To ask a question or just say hi, contact me at: <a href="mailto:hello@commitmono.com" tabindex="0" target="_blank" class="download_button">hello@commitmono.com</a>.
To support the project directly <a href="https://www.buymeacoffee.com/eigilnikolajsen" tabindex="0" target="_blank" class="download_button">buy me a coffee</a>.`,
            content: {
                charset: ` !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_${"`"}abcdefghijklmnopqrstuvwxyz{|}~ ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶·¸¹º»¼½¾¿ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖ×ØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõö÷øùúûüýþÿĀāĂăĄąĆćĈĉĊċČčĎďĐđĒēĔĕĖėĘęĚěĜĝĞğĠġĢģĤĥĦħĨĩĪīĬĭĮįİıĲĳĴĵĶķĸĹĺĻļĽľĿŀŁłŃńŅņŇňŉŊŋŌōŎŏŐőŒœŔŕŖŗŘřŚśŜŝŞşŠšŢţŤťŦŧŨũŪūŬŭŮůŰűŲųŴŵŶŷŸŹźŻżŽžſƒǺǻǼǽǾǿȘșȚțȷˆˇˉ˘˙˚˛˜˝̦̀́̈̊΄΅ΆΈΉΊΌΎΏΐΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩΪΫάέήίΰαβγδεζηθικλμνξοπρςστυφχψωϊϋόύώϕẀẁẂẃẄẅỲỳ‐‑‒–—―‖‗‘’‚‛“”„†‡•…‰′″‹›‼‾⁄⁊⁰⁴⁵⁶⁷⁸⁹⁺⁻⁼⁽⁾ⁿ₀₁₂₃₄₅₆₇₈₉₊₋₌₍₎₣₤₧€℅ℓ№™Ω℮⅓⅔⅕⅖⅗⅘⅙⅚⅛⅜⅝⅞⅟↊↋←↑→↓↔↕↨↹⇒⇞⇟⇤⇥⇧⇨⇪∀∂∃∄∅∆∇∈∉∊∋∌∍∎∏∑−∕∗∙√∞∟∧∨∩∪∫∴∵∶∷≁≂≃≄≅≆≇≈≉≊≋≠≡≢≤≥⊂⊃⊄⊅⊆⊇⊈⊉⊊⊋⊸⋅⋮⋯⋱⌂⌘⌠⌡⌤⌥⌦⌨⌫⎇⎋⎛⎜⎝⎞⎟⎠⎡⎢⎣⎤⎥⎦⎧⎨⎩⎪⎫⎬⎭⏎⏻⏼⏽⏾␀␁␂␃␄␅␆␇␈␉␊␋␌␍␎␏␐␑␒␓␔␕␖␗␘␙␚␛␜␝␞␟␠␡␢␣␤␥␦─━│┃┄┅┆┇┈┉┊┋┌┍┎┏┐┑┒┓└┕┖┗┘┙┚┛├┝┞┟┠┡┢┣┤┥┦┧┨┩┪┫┬┭┮┯┰┱┲┳┴┵┶┷┸┹┺┻┼┽┾┿╀╁╂╃╄╅╆╇╈╉╊╋╌╍╎╏═║╒╓╔╕╖╗╘╙╚╛╜╝╞╟╠╡╢╣╤╥╦╧╨╩╪╫╬╭╮╯╰╱╲╳╴╵╶╷╸╹╺╻╼╽╾╿▀▁▂▃▄▅▆▇█▉▊▋▌▍▎▏▐░▒▓▔▕▖▗▘▙▚▛▜▝▞▟■□▢▣▤▥▦▧▨▩▪▫▬▭▮▯▲▶▼◀◄◆◇◉◊○◎●◐◑◒◓◕◖◗◙◚◛◜◝◞◟◠◡◢◣◤◥◧◨◩◪◫◯◰◱◲◳◴◵◶◷★✓✔✕⟦⟧⤙⤚⤛⤜⦇⦈⭘﻿�`,
                supportedLanguages: [
                    "Afrikaans",
                    "Albanian",
                    "Asu",
                    "Basque",
                    "Bemba",
                    "Bena",
                    "Breton",
                    "Catalan",
                    "Chiga",
                    "Colognian",
                    "Cornish",
                    "Croatian",
                    "Czech",
                    "Danish",
                    "Dutch",
                    "Embu",
                    "English",
                    "Esperanto",
                    "Estonian",
                    "Faroese",
                    "Filipino",
                    "Finnish",
                    "French",
                    "Friulian",
                    "Galician",
                    "Ganda",
                    "German",
                    "Greek",
                    "Gusii",
                    "Hungarian",
                    "Icelandic",
                    "Inari Sami",
                    "Indonesian",
                    "Irish",
                    "Italian",
                    "Jola-Fonyi",
                    "Kabuverdianu",
                    "Kalaallisut",
                    "Kalenjin",
                    "Kamba",
                    "Kikuyu",
                    "Kinyarwanda",
                    "Latvian",
                    "Lithuanian",
                    "Lower Sorbian",
                    "Luo",
                    "Luxembourgish",
                    "Luyia",
                    "Machame",
                    "Makhuwa-Meetto",
                    "Makonde",
                    "Malagasy",
                    "Maltese",
                    "Manx",
                    "Meru",
                    "Morisyen",
                    "Northern Sami",
                    "North Ndebele",
                    "Norwegian Bokmål",
                    "Norwegian Nynorsk",
                    "Nyankole",
                    "Oromo",
                    "Polish",
                    "Portuguese",
                    "Quechua",
                    "Romanian",
                    "Romansh",
                    "Rombo",
                    "Rundi",
                    "Rwa",
                    "Samburu",
                    "Sango",
                    "Sangu",
                    "Scottish Gaelic",
                    "Sena",
                    "Serbian",
                    "Shambala",
                    "Shona",
                    "Slovak",
                    "Soga",
                    "Somali",
                    "Spanish",
                    "Swahili",
                    "Swedish",
                    "Swiss German",
                    "Taita",
                    "Teso",
                    "Turkish",
                    "Upper Sorbian",
                    "Uzbek (Latin)",
                    "Volapük",
                    "Vunjo",
                    "Walser",
                    "Welsh",
                    "Western Frisian",
                    "Zulu",
                ],
            },
        },
        {
            name: "about",
            description: `Commit Mono is a project by Eigil Nikolajsen. Eigil is a creative developer and designer from Denmark with a particular interest in type design. He holds a bachelor degree in Interactive Design from the Danish School of Media and Journalism in 2023.
<a href="https://www.buymeacoffee.com/eigilnikolajsen" tabindex="0" target="_blank" class="button_link">Support Commit Mono directly</a>`,
            content: {},
        },
    ],
}
