# Math typesetting

EME uses [KaTex](https://khan.github.io/KaTeX/) to render math symbols.
You can write $\frac{inline}{expressions}$ by using single `$`.
For a block, use double `$$`:
$$
\frac{this}{a} \frac{is}{block}
$$

## Symbols

This list of symbols is copied from [here](http://web.ift.uib.no/Teori/KURS/WRK/TeX/symALL.html).

### Greek Letters

$$
\alpha               \theta               o                  \tau          
\beta                \vartheta           \pi                 \upsilon      
\gamma               \gamma              \varpi              \phi          
\delta               \kappa              \rho                \varphi       
\epsilon             \lambda             \varrho             \chi          
\varepsilon          \mu                 \sigma              \psi          
\zeta                \nu                 \varsigma           \omega        
\eta                 \xi
$$

$$
\Gamma               \Lambda             \Sigma              \Psi          
\Delta               \Xi                 \Upsilon            \Omega        
\Theta               \Pi                 \Phi
$$

### Binary Operation Symbols

$$
\pm                  \cap                \diamond                    \oplus      
\mp                  \cup                \bigtriangleup              \ominus     
\times               \uplus              \bigtriangledown            \otimes     
\div                 \sqcap              \triangleleft               \oslash     
\ast                 \sqcup              \triangleright              \odot       
\star                \vee                \lhd                        \bigcirc    
\circ                \wedge              \rhd                        \dagger     
\bullet              \setminus           \unlhd                      \ddagger    
\cdot                \wr                 \unrhd                      \amalg      
+                    -
$$

### Relation Symbols

$$
\leq                 \geq                \equiv              \models       
\prec                \succ               \sim                \perp         
\preceq              \succeq             \simeq              \mid          
\ll                  \gg                 \asymp              \parallel     
\subset              \supset             \approx             \bowtie       
\subseteq            \supseteq           \cong               \Join     
\sqsubset            \sqsupset           \neq                \smile        
\sqsubseteq          \sqsupseteq         \doteq              \frown        
\in                  \ni                 \propto             =             
\vdash               \dashv              <                   >             
:
$$

### Punctuation Symbols

$$
,            ;           \colon              \ldotp              \cdotp
$$

### Arrow Symbols

$$
\leftarrow                   \longleftarrow              \uparrow      
\Leftarrow                   \Longleftarrow              \Uparrow      
\rightarrow                  \longrightarrow             \downarrow    
\Rightarrow                  \Longrightarrow             \Downarrow    
\leftrightarrow              \longleftrightarrow         \updownarrow  
\Leftrightarrow              \Longleftrightarrow         \Updownarrow  
\mapsto                      \longmapsto                 \nearrow      
\hookleftarrow               \hookrightarrow             \searrow      
\leftharpoonup               \rightharpoonup             \swarrow      
\leftharpoondown             \rightharpoondown           \nwarrow      
\rightleftharpoons           \leadsto
$$

### Miscellaneous Symbols

$$
\ldots               \cdots              \vdots              \ddots        
\aleph               \prime              \forall             \infty        
\hbar                \emptyset           \exists             \Box      
\imath               \nabla              \neg                \Diamond  
\jmath               \surd               \flat               \triangle     
\ell                 \top                \natural            \clubsuit     
\wp                  \bot                \sharp              \diamondsuit  
\Re                  \|                  \backslash          \heartsuit    
\Im                  \angle              \partial            \spadesuit    
\mho                 .                   |
$$

### Variable-sized Symbols

$$
\sum                 \bigcap             \bigodot      
\prod                \bigcup             \bigotimes    
\coprod              \bigsqcup           \bigoplus     
\int                 \bigvee             \biguplus     
\oint                \bigwedge
$$

### Log-like Symbols

$$
\arccos     \cos       \csc      \exp      \ker         \limsup      \min      \sinh  
\arcsin     \cosh      \deg      \gcd      \lg          \ln	      \Pr       \sup
$$
$$
\arctan     \cot       \det      \hom      \lim         \log	      \sec      \tan   
\arg        \coth      \dim      \inf      \liminf      \max	      \sin      \tanh
$$

### Delimiters

$$
(                    )                   \uparrow            \Uparrow      
[                    ]                   \downarrow          \Downarrow    
\{                   \}                  \updownarrow        \Updownarrow  
\lfloor              \rfloor             \lceil              \rceil        
\langle              \rangle             /                   \backslash    
|                    \|
$$

### Large Delimiters

$$
\rmoustache        \lmoustache         \rgroup            \lgroup 
$$

### Math mode accents

$$
\hat{a}            \acute{a}         \bar{a}           \dot{a}           \breve{a} 
\check{a}          \grave{a}         \vec{a}           \ddot{a}          \tilde{a}
$$

### Some other constructions

$$
\sqrt{abc}         \sqrt[n]{abc}     \frac{abc}{xyz}   \underline{abc}   \overline{abc}  
$$
