namespace DotNet.Sdk.Extensions.Tests.Polly.Http.Timeout.Auxiliary;

public class TimeoutPolicyExecutor
{
    private readonly HttpClient _httpClient;
    private readonly TimeoutOptions _timeoutOptions;
    private readonly TestHttpMessageHandler _testHttpMessageHandler;

    public TimeoutPolicyExecutor(
        HttpClient httpClient,
        TimeoutOptions timeoutOptions,
        TestHttpMessageHandler testHttpMessageHandler)
    {
        _httpClient = httpClient;
        _timeoutOptions = timeoutOptions;
        _testHttpMessageHandler = testHttpMessageHandler;
    }

    public Task<HttpResponseMessage> TriggerTimeoutPolicyAsync()
    {
        const string requestPath = "/timeout";
        var timeout = TimeSpan.FromSeconds(_timeoutOptions.TimeoutInSecs + 2);
        _testHttpMessageHandler.HandleTimeout(requestPath, timeout);
        return _httpClient.GetAsync(requestPath);
    }
}
