# dotnet-sdk-extensions

## Description

This package provides extensions to help build .NET applications, using .NET 6.0 or higher.

The extensions provided by this package are:

* [Using `T` options classes instead of `IOptions<T>`](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/configuration/options-without-IOptions.md)
* Extending [Polly](https://github.com/App-vNext/Polly)
  * [Circuit breaker checker policy](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/circuit-breaker-checker-policy.md)
  * [Add a timeout policy to an HttpClient](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/httpclient-with-timeout-policy.md)
  * [Add a retry policy to an HttpClient](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/httpclient-with-retry-policy.md)
  * [Add a circuit breaker policy to an HttpClient](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/httpclient-with-circuit-breaker-policy.md)
  * [Add a fallback policy to an HttpClient](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/httpclient-with-fallback-policy.md)
  * [Add a set of resilience policies to an HttpClient](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/httpclient-with-resilience-policies.md)
  * [Extending the policy options validation](https://github.com/edumserrano/dotnet-sdk-extensions/blob/dotnet-sdk-extensions-3.0.2/docs/polly/extending-policy-options-validation.md)

For more information on how to get started see the docs provided for each extension.

## Release Notes

You can find the release notes at: https://github.com/edumserrano/dotnet-sdk-extensions/releases.

## Feedback

If you'd like to contribute or leave feedback please open an issue on the [package's repo](https://github.com/edumserrano/dotnet-sdk-extensions).
