# pr-dependabot-auto-merge worflows

[![PR Dependabot auto merge](https://github.com/edumserrano/dotnet-sdk-extensions/actions/workflows/pr-dependabot-auto-merge.yml/badge.svg)](https://github.com/edumserrano/dotnet-sdk-extensions/actions/workflows/pr-dependabot-auto-merge.yml)

The purpose of [this workflow](/.github/workflows/pr-dependabot-auto-merge.yml) is to auto-merge pull requests generated by Dependabot.

This workflow is triggered once the [build-test-package workflow](/docs/dev-notes/workflows/build-test-package-workflow.md) completes but will only execute if it was triggered by the `dependabot[bot]` actor. The flow is as follows:

1) Pull request generated.
2) `build-test-package` workflow is triggered.
3) Once `build-test-package` workflow completes, this workflow is triggered.
4) If the actor **is not** `dependabot[bot]` then the workflow terminates. Else, it sets the pull request to auto-merge.
5) The pull request gets merged once all the required status checks pass.

Note that when this workflow is triggered, its actor will be the actor that triggered the `build-test-package` workflow.

The [Dependabot configuration file](/.github/dependabot.yml) contains additional configuration for Dependabot.

## Conditions for auto-merge

Note that for pull requests to automatically be merged the conditions described in [Enable Auto-Merge for PR in Github Action](https://github.com/cli/cli/discussions/3660) must be met.

## Deleting branches from Dependabot pull requests

To be able to delete branches using the flag `--delete-branch` from [gh pr merge](https://cli.github.com/manual/gh_pr_merge), a checkout of the repo is done before or else the command fails because GitHub's CLI tries to delete both the remote and local branch.

**Without** the checkout step the `gh pr merge` command successfully deletes the remote branch, but it **fails to delete the local branch** and the workflow fails.

## Ignored NuGets

On the [Dependabot configuration file](/.github/dependabot.yml) some NuGets are ignored because the project where they are used target multiple target frameworks and different target frameworks require different versions of the NuGet package.

Dependabot does not know that handle this well and as such the excluded NuGets needs to be manually updated for each target framework.

## Security considerations when setting up auto merge for Dependabot PRs

As per the [docs](https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/automating-dependabot-with-github-actions#responding-to-events):

> Dependabot is able to trigger GitHub Actions workflows on its pull requests and comments; however, due to ["GitHub Actions: Workflows triggered by Dependabot PRs will run with read-only permissions"](https://github.blog/changelog/2021-02-19-github-actions-workflows-triggered-by-dependabot-prs-will-run-with-read-only-permissions/), certain events are treated differently.
>
> For workflows initiated by Dependabot (github.actor == "dependabot[bot]") using the pull_request, pull_request_review, pull_request_review_comment, and push events, the following restrictions apply:
>
> - GITHUB_TOKEN has read-only permissions.
> - Secrets are inaccessible.
>

Given the above restrictions, the action to auto merge Dependabot PRs couldn't be done as part of the main `build-test-package` workflow without potentially introducing security vulnerabilities. Even if security wasn't an issue, the PRs from forked repos would fail when the workflow tried to set the auto-merge for the pull request because the `GITHUB_TOKEN` would only have read-only permissions.

With a separate `dependabot-auto-merge-pr` workflow which runs in a priviliged context, the above is not a problem.

For more information see:

- [Security considerations on GitHub workflows](/docs/dev-notes/workflows/security-considerations.md)
- [Security considerations on GitHub workflows regarding dotnet CLI](/docs/dev-notes/workflows/security-considerations-and-dotnet.md)

## Fetch Metadata Action

The [dependabot/fetch-metadata](https://github.com/dependabot/fetch-metadata) can be used to extract information about the dependencies being updated by a Dependabot generated PR. The output from that action could be stored as a workflow artifact if the information is required by a priviliged workflow.
