<p align = "center">
<img src ="https://edualgo.github.io/documentation/assets/images/eduAlgo.png" height = "200"><br>
<img src="https://img.shields.io/github/license/eduAlgo/eduAlgo?style=for-the-badge">&nbsp;<img src ="https://img.shields.io/github/languages/code-size/eduAlgo/eduAlgo?style=for-the-badge">&nbsp;<img src = "https://img.shields.io/github/contributors/eduAlgo/eduAlgo?style=for-the-badge">&nbsp;<img src ="https://img.shields.io/github/last-commit/eduAlgo/eduAlgo?style=for-the-badge">&nbsp;<img src="https://img.shields.io/pypi/wheel/eduAlgo?style=for-the-badge">
<img src = "https://img.shields.io/pypi/status/eduAlgo?style=for-the-badge">&nbsp;<img src ="https://img.shields.io/pypi/v/eduAlgo?style=for-the-badge&logo=PyPi">&nbsp;<img src ="https://img.shields.io/github/release-date/eduAlgo/eduAlgo?style=for-the-badge">
<p>

## Objective
A python package published at [PyPi](https://pypi.org/). The project can be viewed here => [PyPi - eduAlgo](https://pypi.org/project/eduAlgo/).
**Don't forget to create an ISSUE before making a PR and always make PR to this repo - [Main eduAlgo](https://github.com/edualgo/eduAlgo)**

## Stats

<img src="https://github.com/Abhijit2505/eduAlgo/blob/master/assets/eduAlgo-def.png">

[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/eduAlgo/eduAlgo/graphs/commit-activity)
[![PyPI format](https://img.shields.io/pypi/format/eduAlgo.svg)](https://pypi.python.org/pypi/eduAlgo/)
[![GitHub contributors](https://img.shields.io/github/contributors/Abhijit2505/eduAlgo.svg)](https://GitHub.com/eduAlgo/eduAlgo/graphs/contributors/)
                
                
[![Downloads](https://static.pepy.tech/personalized-badge/edualgo?period=total&units=international_system&left_color=black&right_color=orange&left_text=Downloads)](https://pepy.tech/project/edualgo)
[![Downloads](https://static.pepy.tech/personalized-badge/edualgo?period=month&units=international_system&left_color=black&right_color=orange&left_text=Downloads)](https://pepy.tech/project/edualgo)
[![Downloads](https://static.pepy.tech/personalized-badge/edualgo?period=week&units=international_system&left_color=black&right_color=orange&left_text=Downloads)](https://pepy.tech/project/edualgo)

[![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)](https://forthebadge.com)   [![forthebadge](https://forthebadge.com/images/badges/built-by-developers.svg)](https://forthebadge.com) [![forthebadge](https://forthebadge.com/images/badges/made-with-python.svg)](https://forthebadge.com)

## Aim Of The Package

This is a very simple python package made up with python script to study different algorithms for educational purposes. This package is currently under **planning** version and aims to achieve the following :-

* To put together all the available algorithms
* Help students with learning space and time complexity
* Visualizing Algorithms
* Getting resources, articles etc. to study about python and Algorithms
* Become a handy tool for the programmers while using different algorithms on daily basis

## Organization

This project is a part of the organization <a href="https://www.edualgoacademy.com">Edualgo Academy</a>.

> We are an opensource organization having a few open-sourced projects on github related to Data structures and Algorithms in Python, Flutter Development & Frontend Development.
chek the organization here - <a href="https://github.com/eduAlgo">eduAlgo</a>

## Documentation
The documentation for the included methods and their implementations can be found here => <a href = "https://edualgo.github.io/documentation/index.html">eduAlgo-Documentation</a>

## Algorithms Yet to Publish

* Searching Algorithms and Visualizations
* Sorting Algorithms and Visualizations
* Graph Algorithms and Visualizations
* Linked List Implementations and Vizualizations
* Tree Types, Vizualizations and Implementations

## Installation

Fast install:

    pip install eduAlgo

Example

```python

from edualgo import LinkedList as ll
llist1 = ll.linkedlist()
llist2 = ll.linkedlist()

arr1 = list(map(int,input().split()))
arr2 = list(map(int,input().split()))

for i in arr1:
    llist1.append(i)

for i in arr2:
    llist2.append(i)

sol = ll.list_algorithms()

llist3 = ll.linkedlist()
llist3.head = sol.mergeTwoLists(llist1.head,llist2.head)
llist3.printLL()
```
Input:

      1 2 3
      2 3 4

Output:

      1 2 2 3 3 4

## Communities/Hackathon/Conferences (In which the project was a part of)

<table border="2">
  <tr>
    <td>
      <img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/Foss%20Hack%202020.JPG" height="200"><br>
      <b>FOSS Hack - 2020 (12th & 13th September 2020)<b>
    </td>
    <td>
      <img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/PyconIndia-Full-lite.png" height="200"><br>
      <b>PyCon - 2020 Devsprint ( 04th & 05th October 2020)<b>
        </td>
        </tr>
      <tr>
    <td>
      <img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/haccktoberfest.png" height="200"><br>
      <b>Hacktoberfest 2020 (October 2020)</b>
    </td>
    <td>
      <img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/woc.png" height="200"><br>
      <b>Winter of Code - DSC, NSEC</b>
    </td>
  </tr>
  
  </table>


## Latest Winter Update (Package Demo)

<a href = "https://www.youtube.com/embed/ly_GYSBGL2g"><img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/winterupdate.PNG" height = "200"></a>

## Tutorials

<a href = "https://www.youtube.com/embed/XlOx62W4Nxg"><img src = "https://github.com/Abhijit2505/eduAlgo/blob/master/assets/tutorial1.PNG" height = "300"></a>


## License

This package is under **MIT License** copyright @<a href = "https://github.com/Abhijit2505">Abhijit Tripathy</a>. The production code can be checked at the *production* branch of this repository.

## Our sponsors

<table>
  <p>This project is supported by:</p>
  <tr>
    <td>
<p>
  <a href="https://www.digitalocean.com/">
    <img src="https://opensource.nyc3.cdn.digitaloceanspaces.com/attribution/assets/SVG/DO_Logo_horizontal_blue.svg" width="201px">
  </a>
</p>
    </td>
    <td>
      <p>
  <a href="https://www.discourse.org/">
    <img src="https://d11a6trkgmumsb.cloudfront.net/original/3X/1/0/101f03af29f12ea30e1226eb96a02c3ed2f6d2ef.png" width="201px">
  </a>
</p>
    </td>
    <td>
      <p>
  <a href="https://balsamiq.com/">
    <img src="https://balsamiq.com/assets/company/brandassets/balsamiq-logo-screen.png" width="201px">
  </a>
</p>
    </td>
    <td>
      <p>
  <a href="https://www.jetbrains.com/">
    <img src="https://github.com/Abhijit2505/eduAlgo/blob/master/assets/jetbrains-variant-4.png" width="201px">
  </a>
</p>
    </td>
    <td>
      <p>
  <a href="https://www.browserstack.com/">
    <img src="https://github.com/Abhijit2505/eduAlgo/blob/master/assets/brsstack-mod.png" width="201px">
  </a>
</p>
    </td>
  </tr>
  </table>

## About The Creator

<table>
    <tr>
        <td>
            <img src = "https://avatars.githubusercontent.com/u/52751963?s=460&u=60168fa0f71cca5b1d3d2e1ee11c47cbda8662c3&v=4" height = "100">
        </td>
            <td>
                <a href="https://github.com/Abhijit2505">Abhijit Tripathy</a></br>
    DSA Developer and Python Programmer
        </td>
        </tr>
    </table>

## Our contributors

<a href="https://github.com/edualgo/eduAlgo/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=edualgo/eduAlgo" />
</a>

Made with [contrib.rocks](https://contrib.rocks).
