# Tingshu (听舒)
> 让作者的声音直达听众 | Bringing the author's voice directly to you

[![GitHub stars](https://img.shields.io/github/stars/echonoshy/tingshu?style=social)](https://github.com/echonoshy/tingshu/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/echonoshy/tingshu?style=social)](https://github.com/echonoshy/tingshu/network/members)
[![GitHub watchers](https://img.shields.io/github/watchers/echonoshy/tingshu?style=social)](https://github.com/echonoshy/tingshu/watchers)
[![GitHub repo size](https://img.shields.io/github/repo-size/echonoshy/tingshu)](https://github.com/echonoshy/tingshu)
[![GitHub language count](https://img.shields.io/github/languages/count/echonoshy/tingshu)](https://github.com/echonoshy/tingshu)
[![GitHub top language](https://img.shields.io/github/languages/top/echonoshy/tingshu)](https://github.com/echonoshy/tingshu)
[![GitHub last commit](https://img.shields.io/github/last-commit/echonoshy/tingshu?color=red)](https://github.com/echonoshy/tingshu/commits/main)

## 项目预览 | Preview

[点击进入项目主页｜Home](https://echonoshy.github.io/tingshu/web)

![Web Interface Preview](assets/web-view.jpg)

## 快速开始 | Quick Start

[点击这里观看视频](https://youtu.be/TdCrbDvICbw)


1. 安装环境 | Install Environment
```bash
./scripts/install.sh
```

2. 下载模型权重 | Download Model Weights
```bash
./scripts/download_weights.sh
```

3. 启动 Web UI | Run Web Interface
```bash
./scripts/run_gradio.sh
```

4. 生成前端音频数据 | Generate Audio Data
```bash
./scripts/generate_web_data.sh
```

## 项目优化 ｜ TODO
- [ ] 1. 使用新方案替代tts方式生成的录音缺乏情感，顿挫，听感不好问题。     
      Replace the TTS-generated recordings to address issues of lacking emotion, intonation, and poor listening experience.  

- [ ] 2. 更新web ui, 替换静态加载模式    
      Update web ui and switch from static loading mode. 

- [ ] 3. 增加英文版自传数据内容    
      Add autobiographical content in the English version.

- [ ] 4. 适当增加背景音乐内容、音效      
      Appropriately enhance background music and sound effects. 

## 免责声明 | Disclaimer

本项目仅供学习和研究使用。使用者须遵守当地的法律法规，包括但不限于 DMCA 相关法律。我们不对任何非法使用承担责任。

This project is for research and learning purposes only. Users must comply with local laws and regulations, including but not limited to DMCA-related laws. We do not take any responsibility for illegal usage.

## 技术鸣谢 | Credits

本项目基于以下开源项目构建：

- [VITS2](https://github.com/daniilrobnikov/vits2)
- [Bert-VITS2](https://github.com/fishaudio/Bert-VITS2)
- [GPT VITS](https://github.com/innnky/gpt-vits)
- [GPT-SoVITS](https://github.com/RVC-Boss/GPT-SoVITS)
- [Fish Speech](https://github.com/fishaudio/fish-speech)

