import React from "react";

export const appleSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 15 18">
    <path
      fill="#fff"
      fillRule="evenodd"
      d="M10.952 0c-.909.038-2.01.603-2.661 1.363-.586.675-1.097 1.753-.96 2.786 1.015.079 2.049-.514 2.68-1.274.63-.762 1.057-1.82.94-2.875zm-.257 17.976c1.23-.023 2.01-1.113 2.764-2.21.826-1.203 1.19-2.368 1.245-2.542l.006-.02-.004-.001c-.118-.048-2.397-.971-2.42-3.638-.022-2.203 1.742-3.299 1.936-3.42l.014-.008c-1.061-1.547-2.714-1.759-3.303-1.783-.86-.086-1.694.241-2.376.509-.434.17-.805.316-1.083.316-.308 0-.69-.151-1.119-.32-.56-.222-1.201-.476-1.863-.464-1.532.023-2.946.889-3.735 2.257-1.594 2.754-.409 6.836 1.144 9.07.76 1.092 1.663 2.321 2.851 2.277.531-.021.909-.181 1.3-.347.45-.192.919-.39 1.66-.39.707 0 1.154.192 1.584.378.411.177.807.347 1.399.336z"
      clipRule="evenodd"
    />
  </svg>
);

export const googleSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 15 16">
    <path
      fill="#fff"
      fillRule="evenodd"
      d="M0 1.096v13.81c0 .48.278.896.682 1.094l7.99-8.002L.686 0A1.219 1.219 0 0 0 0 1.096zm2.473 14.49l8.734-5.05-1.846-1.848-6.888 6.897zm11.449-8.553a1.217 1.217 0 0 1 .013 1.926L12.08 10.03l-2.03-2.033 2.028-2.031 1.844 1.066zm-2.716-1.57L2.478.416 9.36 7.309l1.845-1.847z"
      clipRule="evenodd"
    />
  </svg>
);

export const desktopSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 16">
    <path
      fill="#fff"
      d="M14 1.333H2c-.733 0-1.333.6-1.333 1.334v8C.667 11.4 1.267 12 2 12h4.667v1.333H5.333v1.334h5.334v-1.334H9.333V12H14c.733 0 1.333-.6 1.333-1.333v-8c0-.734-.6-1.334-1.333-1.334zm0 9.334H2v-8h12v8z"
    />
  </svg>
);

export const blogSvg = (
  <svg viewBox="0 0 13 15">
    <path
      d="M6.505 8.14485C7.22875 8.1061 8.28875 7.90235 9.1175 7.43985C9.71875 6.5161 10.1163 5.76235 10.5075 4.93985C9.97 4.97985 9.35 4.93423 8.7975 4.77923C9.465 4.66485 10.3025 4.4261 10.9362 4.01923C11.7206 2.90423 12.3019 1.10735 12.5 0.00110219C10.7037 -0.0288978 9.02125 0.557352 7.88375 1.2911C7.5 1.7286 7.1675 2.78423 7.08875 3.34298C6.91563 2.93923 6.78938 2.29298 6.9375 1.75423C6.02625 2.2336 5.22938 2.7811 4.32688 3.54173C3.87688 4.49673 3.80562 5.59798 3.84687 6.21423C3.6025 5.8686 3.275 5.19548 3.32063 4.4586C1.70188 6.0236 0.585 8.0736 1.64438 10.2861C2.81875 9.07298 4.16875 7.92173 4.99062 7.38673C3.09312 9.55798 1.32437 12.4161 0 14.9999L1.565 14.5086C2.2425 13.2717 2.85187 12.2061 3.39812 11.443C5.41625 11.7074 7.20813 10.088 8.41562 8.4461C7.93438 8.56485 7.01188 8.40985 6.505 8.14485Z"
      fill="currentColor"
    />
  </svg>
);

export const newsSvg = (
  <svg viewBox="0 0 15 13">
    <path
      d="M4.375 8.75H12.5V9.375H4.375V8.75ZM12.5 6.875H4.375V7.5H12.5V6.875ZM12.5 3.125H9.375V3.75H12.5V3.125ZM12.5 5H9.375V5.625H12.5V5ZM1.875 0V10.7494C1.875 11.2312 1.25 11.2312 1.25 10.7494V1.25H0V11.2375C0 11.9344 0.565625 12.5 1.2625 12.5H13.7362C14.4344 12.5 15 11.935 15 11.2375V0H1.875ZM13.75 10.625H3.125V1.25H13.75V10.625ZM8.125 3.125H4.375V5.625H8.125V3.125Z"
      fill="currentColor"
    />
  </svg>
);

export const mailSvg = (
  <svg viewBox="0 0 15 12">
    <path
      d="M0 0V11.25H15V0H0ZM13.4487 1.25L7.5 6.07063L1.55125 1.25H13.4487ZM1.25 10V2.61438L7.5 7.67937L13.75 2.61438V10H1.25Z"
      fill="currentColor"
    />
  </svg>
);

export const twitterSvg = (
  <svg viewBox="0 0 15 13">
    <path
      d="M15 1.44313C14.4481 1.68813 13.855 1.85312 13.2325 1.9275C13.8681 1.54687 14.3562 0.94375 14.5856 0.225C13.9913 0.5775 13.3325 0.83375 12.6312 0.971875C12.0706 0.37375 11.27 0 10.385 0C8.39812 0 6.93813 1.85375 7.38688 3.77813C4.83 3.65 2.5625 2.425 1.04437 0.563125C0.238125 1.94625 0.62625 3.75562 1.99625 4.67187C1.4925 4.65562 1.0175 4.5175 0.603125 4.28688C0.569375 5.7125 1.59125 7.04625 3.07125 7.34312C2.63812 7.46062 2.16375 7.48813 1.68125 7.39563C2.0725 8.61812 3.20875 9.5075 4.55625 9.5325C3.2625 10.5469 1.6325 11 0 10.8075C1.36187 11.6806 2.98 12.19 4.7175 12.19C10.4312 12.19 13.6594 7.36438 13.4644 3.03625C14.0656 2.60187 14.5875 2.06 15 1.44313Z"
      fill="currentColor"
    />
  </svg>
);

export const githubSvg = (
  <svg viewBox="0 0 15 15">
    <path
      d="M13.9939 3.73534C13.3233 2.58623 12.4135 1.67647 11.2645 1.00587C10.1153 0.335233 8.86077 0 7.49993 0C6.13927 0 4.88429 0.335335 3.73534 1.00587C2.58623 1.67644 1.67654 2.58623 1.00587 3.73534C0.335301 4.88443 0 6.13923 0 7.49973C0 9.13399 0.476803 10.6036 1.43065 11.9088C2.38439 13.2142 3.61648 14.1174 5.12683 14.6187C5.30264 14.6513 5.43278 14.6284 5.5174 14.5504C5.60206 14.4724 5.64433 14.3746 5.64433 14.2576C5.64433 14.238 5.64266 14.0623 5.63941 13.7302C5.63606 13.3982 5.63448 13.1085 5.63448 12.8613L5.40987 12.9001C5.26665 12.9264 5.08599 12.9375 4.86787 12.9343C4.64985 12.9313 4.42353 12.9084 4.1892 12.8659C3.95476 12.8238 3.73671 12.7262 3.53487 12.5732C3.33314 12.4202 3.18993 12.2199 3.10527 11.9727L3.00762 11.748C2.94253 11.5984 2.84006 11.4322 2.70006 11.25C2.56006 11.0677 2.41849 10.9441 2.27528 10.879L2.20691 10.83C2.16135 10.7975 2.11907 10.7583 2.07998 10.7127C2.04092 10.6672 2.01167 10.6217 1.99214 10.576C1.97258 10.5304 1.98879 10.4929 2.04095 10.4635C2.09311 10.4342 2.18738 10.4199 2.32416 10.4199L2.51939 10.4491C2.64961 10.4752 2.81067 10.5531 3.0028 10.6834C3.19482 10.8136 3.35267 10.9828 3.47639 11.1911C3.6262 11.458 3.80669 11.6615 4.01838 11.8015C4.2299 11.9415 4.44316 12.0114 4.65796 12.0114C4.87276 12.0114 5.05828 11.9951 5.2146 11.9627C5.37074 11.9301 5.51723 11.8812 5.65401 11.8161C5.7126 11.3798 5.87213 11.0445 6.13246 10.8102C5.76141 10.7712 5.42782 10.7125 5.13151 10.6344C4.83538 10.5562 4.52935 10.4293 4.21365 10.2533C3.89778 10.0776 3.63574 9.85946 3.42747 9.59916C3.21917 9.33874 3.04822 8.99683 2.91486 8.57376C2.78143 8.15053 2.7147 7.6623 2.7147 7.10895C2.7147 6.32106 2.97191 5.65059 3.48624 5.09717C3.2453 4.50483 3.26805 3.84079 3.55454 3.10514C3.74335 3.04648 4.02334 3.0905 4.39439 3.23692C4.7655 3.38342 5.03721 3.50891 5.20981 3.61296C5.3824 3.71698 5.52069 3.80512 5.62487 3.87661C6.23045 3.7074 6.85539 3.62278 7.49986 3.62278C8.14433 3.62278 8.76941 3.7074 9.37503 3.87661L9.74611 3.64234C9.99986 3.48603 10.2995 3.34279 10.6444 3.21257C10.9894 3.08242 11.2533 3.04658 11.4356 3.10524C11.7285 3.84093 11.7546 4.50493 11.5136 5.09728C12.0279 5.6507 12.2852 6.32133 12.2852 7.10905C12.2852 7.6624 12.2182 8.15217 12.085 8.57866C11.9516 9.00521 11.7792 9.34677 11.5677 9.60406C11.3559 9.8613 11.0922 10.0778 10.7765 10.2535C10.4607 10.4293 10.1546 10.5562 9.85847 10.6343C9.56219 10.7125 9.2286 10.7713 8.85756 10.8104C9.19597 11.1032 9.36521 11.5655 9.36521 12.197V14.2573C9.36521 14.3743 9.40591 14.4721 9.48739 14.5502C9.56876 14.6281 9.69726 14.6511 9.87307 14.6184C11.3836 14.1172 12.6157 13.2139 13.5694 11.9085C14.523 10.6033 15 9.13372 15 7.49945C14.9997 6.13913 14.6642 4.88443 13.9939 3.73534Z"
      fill="currentColor"
    />
  </svg>
);

export const telegramSvg = (
  <svg viewBox="0 0 16 16">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M8 0.5C3.85875 0.5 0.5 3.8575 0.5 8C0.5 12.1419 3.85875 15.5 8 15.5C12.1419 15.5 15.5 12.1419 15.5 8C15.5 3.8575 12.1419 0.5 8 0.5ZM10.015 11.6694C10.1325 11.7525 10.2837 11.7731 10.4187 11.7225C10.5531 11.6712 10.6525 11.5556 10.6825 11.4156C10.9994 9.92688 11.7681 6.15812 12.0562 4.80438C12.0781 4.70188 12.0419 4.59562 11.9619 4.5275C11.8813 4.45937 11.77 4.44 11.6713 4.47625C10.1425 5.0425 5.43437 6.80875 3.51 7.52063C3.38812 7.56625 3.30875 7.68313 3.3125 7.8125C3.31687 7.94125 3.40375 8.05313 3.52875 8.09063C4.39188 8.34875 5.52437 8.70813 5.52437 8.70813C5.52437 8.70813 6.05375 10.3069 6.32937 11.1194C6.36437 11.2219 6.44438 11.3019 6.54938 11.3294C6.655 11.3569 6.76687 11.3281 6.84562 11.2537C7.28875 10.8356 7.97375 10.1888 7.97375 10.1888C7.97375 10.1888 9.27625 11.1431 10.015 11.6694ZM6.00062 8.50562L6.61312 10.525L6.74937 9.24625C6.74937 9.24625 9.11375 7.11312 10.4625 5.8975C10.5019 5.86187 10.5069 5.80188 10.4744 5.76C10.4419 5.71813 10.3819 5.70812 10.3375 5.73687C8.775 6.73438 6.00062 8.50562 6.00062 8.50562Z"
      fill="currentColor"
    />
  </svg>
);

export const discordSvg = (
  <svg viewBox="0 0 15 11">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M11.0702 10.7878C13.9084 10.6979 15 8.83572 15 8.83572C15 4.70045 13.1507 1.34857 13.1507 1.34857C11.3014 -0.0384204 9.54195 0.000106722 9.54195 0.000106722L9.36216 0.205586C11.5454 0.873394 12.5599 1.83658 12.5599 1.83658C11.2243 1.10456 9.91438 0.74497 8.69435 0.603703C7.76969 0.500963 6.88356 0.526648 6.10017 0.629387L5.88185 0.655073C5.43236 0.6936 4.34075 0.860552 2.96661 1.46415C2.49144 1.68247 2.2089 1.83658 2.2089 1.83658C2.2089 1.83658 3.27483 0.822025 5.58647 0.154216L5.45805 0.000106722C5.45805 0.000106722 3.69863 -0.0384204 1.84931 1.34857C1.84931 1.34857 0 4.70045 0 8.83572C0 8.83572 1.07877 10.6979 3.91695 10.7878C3.91695 10.7878 4.39212 10.2099 4.7774 9.72185C3.1464 9.23384 2.52997 8.20644 2.52997 8.20644L2.88955 8.42476L2.94092 8.46329L2.99122 8.49219L3.00621 8.49861L3.05651 8.5275C3.37757 8.7073 3.69863 8.84857 3.99401 8.96415C4.52055 9.16963 5.14983 9.37511 5.88185 9.51638C6.84503 9.69617 7.97517 9.76038 9.20805 9.52922C9.81164 9.42648 10.4281 9.24668 11.0702 8.97699C11.5197 8.81004 12.0205 8.56603 12.5471 8.21929C12.5471 8.21929 11.905 9.27237 10.2226 9.74754C10.6079 10.2356 11.0702 10.7878 11.0702 10.7878ZM5.09846 4.79035C4.36644 4.79035 3.78853 5.43247 3.78853 6.21586C3.78853 6.99925 4.37928 7.64137 5.09846 7.64137C5.83048 7.64137 6.40839 6.99925 6.40839 6.21586C6.42123 5.43247 5.83048 4.79035 5.09846 4.79035ZM9.78596 4.79035C9.05394 4.79035 8.47603 5.43247 8.47603 6.21586C8.47603 6.99925 9.06678 7.64137 9.78596 7.64137C10.518 7.64137 11.0959 6.99925 11.0959 6.21586C11.0959 5.43247 10.518 4.79035 9.78596 4.79035Z"
      fill="currentColor"
    />
  </svg>
);

export const informationSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13,9H11V7H13M13,17H11V11H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"
    />
  </svg>
);

export const informationVariantSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13.5,4A1.5,1.5 0 0,0 12,5.5A1.5,1.5 0 0,0 13.5,7A1.5,1.5 0 0,0 15,5.5A1.5,1.5 0 0,0 13.5,4M13.14,8.77C11.95,8.87 8.7,11.46 8.7,11.46C8.5,11.61 8.56,11.6 8.72,11.88C8.88,12.15 8.86,12.17 9.05,12.04C9.25,11.91 9.58,11.7 10.13,11.36C12.25,10 10.47,13.14 9.56,18.43C9.2,21.05 11.56,19.7 12.17,19.3C12.77,18.91 14.38,17.8 14.54,17.69C14.76,17.54 14.6,17.42 14.43,17.17C14.31,17 14.19,17.12 14.19,17.12C13.54,17.55 12.35,18.45 12.19,17.88C12,17.31 13.22,13.4 13.89,10.71C14,10.07 14.3,8.67 13.14,8.77Z"
    />
  </svg>
);

export const informationOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M11,9H13V7H11M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M11,17H13V11H11V17Z"
    />
  </svg>
);

export const transferOutlineSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
    <path
      fill="currentColor"
      d="M511.6 36.86l-64 415.1c-1.5 9.734-7.375 18.22-15.97 23.05c-4.844 2.719-10.27 4.097-15.68 4.097c-4.188 0-8.319-.8154-12.29-2.472l-122.6-51.1l-50.86 76.29C226.3 508.5 219.8 512 212.8 512C201.3 512 192 502.7 192 491.2v-96.18c0-7.115 2.372-14.03 6.742-19.64L416 96l-293.7 264.3L19.69 317.5C8.438 312.8 .8125 302.2 .0625 289.1s5.469-23.72 16.06-29.77l448-255.1c10.69-6.109 23.88-5.547 34 1.406S513.5 24.72 511.6 36.86z"
    />
  </svg>
);

export const lockOutlineSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 550 512"
    style={{ display: "flex", justifyContent: "center", alignItems: "center", textAlign: "center" }}
  >
    <path
      fill="currentColor"
      d="M80 192V144C80 64.47 144.5 0 224 0C303.5 0 368 64.47 368 144V192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80zM144 192H304V144C304 99.82 268.2 64 224 64C179.8 64 144 99.82 144 144V192z"
    />
  </svg>
);

export const unlockOutlineSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
    <path
      fill="currentColor"
      d="M144 192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80V144C80 64.47 144.5 0 224 0C281.5 0 331 33.69 354.1 82.27C361.7 98.23 354.9 117.3 338.1 124.9C322.1 132.5 303.9 125.7 296.3 109.7C283.4 82.63 255.9 64 224 64C179.8 64 144 99.82 144 144L144 192z"
    />
  </svg>
);

export const delegateOutlineSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
    <path
      fill="currentColor"
      d="M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM382.6 254.6c-12.5 12.5-32.75 12.5-45.25 0L288 205.3V384c0 17.69-14.33 32-32 32s-32-14.31-32-32V205.3L174.6 254.6c-12.5 12.5-32.75 12.5-45.25 0s-12.5-32.75 0-45.25l103.1-103.1C241.3 97.4 251.1 96 256 96c4.881 0 14.65 1.391 22.65 9.398l103.1 103.1C395.1 221.9 395.1 242.1 382.6 254.6z"
    />
  </svg>
);

export const undelegateOutlineSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
    <path
      fill="currentColor"
      d="M256 0C114.6 0 0 114.6 0 256c0 141.4 114.6 256 256 256s256-114.6 256-256C512 114.6 397.4 0 256 0zM382.6 302.6l-103.1 103.1C270.7 414.6 260.9 416 256 416c-4.881 0-14.65-1.391-22.65-9.398L129.4 302.6c-12.5-12.5-12.5-32.75 0-45.25s32.75-12.5 45.25 0L224 306.8V128c0-17.69 14.33-32 32-32s32 14.31 32 32v178.8l49.38-49.38c12.5-12.5 32.75-12.5 45.25 0S395.1 290.1 382.6 302.6z"
    />
  </svg>
);

export const earthSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17.9,17.39C17.64,16.59 16.89,16 16,16H15V13A1,1 0 0,0 14,12H8V10H10A1,1 0 0,0 11,9V7H13A2,2 0 0,0 15,5V4.59C17.93,5.77 20,8.64 20,12C20,14.08 19.2,15.97 17.9,17.39M11,19.93C7.05,19.44 4,16.08 4,12C4,11.38 4.08,10.78 4.21,10.21L9,15V16A2,2 0 0,0 11,18M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"
    />
  </svg>
);

export const brightnessSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,18V6A6,6 0 0,1 18,12A6,6 0 0,1 12,18M20,15.31L23.31,12L20,8.69V4H15.31L12,0.69L8.69,4H4V8.69L0.69,12L4,15.31V20H8.69L12,23.31L15.31,20H20V15.31Z"
    />
  </svg>
);

export const magnifySvg = (
  <svg viewBox="0 0 24 24" width={16} height={16}>
    <path
      fill="currentColor"
      d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z"
    />
  </svg>
);

export const magnifyResponsibleSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z"
    />
  </svg>
);

export const closeSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"
    />
  </svg>
);

export const articleSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="1"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M14 2H6a2 2 0 0 0-2 2v16c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V8l-6-6z" />
    <path d="M14 3v5h5M16 13H8M16 17H8M10 9H8" />
  </svg>
);

export const repeatSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17,17H7V14L3,18L7,22V19H19V13H17M7,7H17V10L21,6L17,2V5H5V11H7V7Z"
    />
  </svg>
);

export const chevronUpSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M7.41,15.41L12,10.83L16.59,15.41L18,14L12,8L6,14L7.41,15.41Z" />
  </svg>
);

export const chevronUpSvgForVote = (
  <svg viewBox="6 8 12 7.41" className="vote-svg">
    <path fill="currentColor" d="M7.41,15.41L12,10.83L16.59,15.41L18,14L12,8L6,14L7.41,15.41Z" />
  </svg>
);

export const chevronUpSvgForSlider = (
  <svg viewBox="6 8 12 7.41" className="slider-svg-up">
    <path fill="currentColor" d="M7.41,15.41L12,10.83L16.59,15.41L18,14L12,8L6,14L7.41,15.41Z" />
  </svg>
);

export const chevronDownSvgForSlider = (
  <svg viewBox="6 8.59 12 7.41" className="slider-svg-down">
    <path d="M0 0h24v24H0V0z" fill="none" />
    <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z" fill="currentColor" />
  </svg>
);

export const peopleSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M16 17V19H2V17S2 13 9 13 16 17 16 17M12.5 7.5A3.5 3.5 0 1 0 9 11A3.5 3.5 0 0 0 12.5 7.5M15.94 13A5.32 5.32 0 0 1 18 17V19H22V17S22 13.37 15.94 13M15 4A3.39 3.39 0 0 0 13.07 4.59A5 5 0 0 1 13.07 10.41A3.39 3.39 0 0 0 15 11A3.5 3.5 0 0 0 15 4Z"
    />
  </svg>
);

export const heartSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314z"
    />
  </svg>
);

export const personFavoriteSvg = (
  <svg width="24" height="24" viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M15,14C12.3,14 7,15.3 7,18V20H23V18C23,15.3 17.7,14 15,14M15,12A4,4 0 0,0 19,8A4,4 0 0,0 15,4A4,4 0 0,0 11,8A4,4 0 0,0 15,12M5,15L4.4,14.5C2.4,12.6 1,11.4 1,9.9C1,8.7 2,7.7 3.2,7.7C3.9,7.7 4.6,8 5,8.5C5.4,8 6.1,7.7 6.8,7.7C8,7.7 9,8.6 9,9.9C9,11.4 7.6,12.6 5.6,14.5L5,15Z"
    />
  </svg>
);

export const personFavoriteOutlineSvg = (
  <svg width="24" height="24" viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M5,15L4.4,14.5C2.4,12.6 1,11.4 1,9.9C1,8.7 2,7.7 3.2,7.7C3.9,7.7 4.6,8 5,8.5C5.4,8 6.1,7.7 6.8,7.7C8,7.7 9,8.6 9,9.9C9,11.4 7.6,12.6 5.6,14.5L5,15M15,4A4,4 0 0,0 11,8A4,4 0 0,0 15,12A4,4 0 0,0 19,8A4,4 0 0,0 15,4M15,10.1A2.1,2.1 0 0,1 12.9,8A2.1,2.1 0 0,1 15,5.9C16.16,5.9 17.1,6.84 17.1,8C17.1,9.16 16.16,10.1 15,10.1M15,13C12.33,13 7,14.33 7,17V20H23V17C23,14.33 17.67,13 15,13M21.1,18.1H8.9V17C8.9,16.36 12,14.9 15,14.9C17.97,14.9 21.1,16.36 21.1,17V18.1Z"
    />
  </svg>
);

export const commentSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M18,8H6V6H18V8M18,11H6V9H18V11M18,14H6V12H18V14M22,4A2,2 0 0,0 20,2H4A2,2 0 0,0 2,4V16A2,2 0 0,0 4,18H18L22,22V4Z"
    />
  </svg>
);

export const menuDownSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M7,10L12,15L17,10H7Z" />
  </svg>
);

export const viewModuleSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M16,5V11H21V5M10,11H15V5H10M16,18H21V12H16M10,18H15V12H10M4,18H9V12H4M4,11H9V5H4V11Z"
    />
  </svg>
);

export const accountGroupSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,5.5A3.5,3.5 0 0,1 15.5,9A3.5,3.5 0 0,1 12,12.5A3.5,3.5 0 0,1 8.5,9A3.5,3.5 0 0,1 12,5.5M5,8C5.56,8 6.08,8.15 6.53,8.42C6.38,9.85 6.8,11.27 7.66,12.38C7.16,13.34 6.16,14 5,14A3,3 0 0,1 2,11A3,3 0 0,1 5,8M19,8A3,3 0 0,1 22,11A3,3 0 0,1 19,14C17.84,14 16.84,13.34 16.34,12.38C17.2,11.27 17.62,9.85 17.47,8.42C17.92,8.15 18.44,8 19,8M5.5,18.25C5.5,16.18 8.41,14.5 12,14.5C15.59,14.5 18.5,16.18 18.5,18.25V20H5.5V18.25M0,20V18.5C0,17.11 1.89,15.94 4.45,15.6C3.86,16.28 3.5,17.22 3.5,18.25V20H0M24,20H20.5V18.25C20.5,17.22 20.14,16.28 19.55,15.6C22.11,15.94 24,17.11 24,18.5V20Z"
    />
  </svg>
);

export const formatListBulledttedSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M7,5H21V7H7V5M7,13V11H21V13H7M4,4.5A1.5,1.5 0 0,1 5.5,6A1.5,1.5 0 0,1 4,7.5A1.5,1.5 0 0,1 2.5,6A1.5,1.5 0 0,1 4,4.5M4,10.5A1.5,1.5 0 0,1 5.5,12A1.5,1.5 0 0,1 4,13.5A1.5,1.5 0 0,1 2.5,12A1.5,1.5 0 0,1 4,10.5M7,19V17H21V19H7M4,16.5A1.5,1.5 0 0,1 5.5,18A1.5,1.5 0 0,1 4,19.5A1.5,1.5 0 0,1 2.5,18A1.5,1.5 0 0,1 4,16.5Z"
    />
  </svg>
);

export const accountMultipleSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M16 17V19H2V17S2 13 9 13 16 17 16 17M12.5 7.5A3.5 3.5 0 1 0 9 11A3.5 3.5 0 0 0 12.5 7.5M15.94 13A5.32 5.32 0 0 1 18 17V19H22V17S22 13.37 15.94 13M15 4A3.39 3.39 0 0 0 13.07 4.59A5 5 0 0 1 13.07 10.41A3.39 3.39 0 0 0 15 11A3.5 3.5 0 0 0 15 4Z"
    />
  </svg>
);

export const nearMeSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M21,3L3,10.53V11.5L9.84,14.16L12.5,21H13.46L21,3Z" />
  </svg>
);

export const calendarRangeSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M9,10H7V12H9V10M13,10H11V12H13V10M17,10H15V12H17V10M19,3H18V1H16V3H8V1H6V3H5C3.89,3 3,3.9 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3M19,19H5V8H19V19Z"
    />
  </svg>
);

export const rssSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M6.18,15.64A2.18,2.18 0 0,1 8.36,17.82C8.36,19 7.38,20 6.18,20C5,20 4,19 4,17.82A2.18,2.18 0 0,1 6.18,15.64M4,4.44A15.56,15.56 0 0,1 19.56,20H16.73A12.73,12.73 0 0,0 4,7.27V4.44M4,10.1A9.9,9.9 0 0,1 13.9,20H11.07A7.07,7.07 0 0,0 4,12.93V10.1Z"
    />
  </svg>
);

export const ticketSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M15.58,16.8L12,14.5L8.42,16.8L9.5,12.68L6.21,10L10.46,9.74L12,5.8L13.54,9.74L17.79,10L14.5,12.68M20,12C20,10.89 20.9,10 22,10V6C22,4.89 21.1,4 20,4H4A2,2 0 0,0 2,6V10C3.11,10 4,10.9 4,12A2,2 0 0,1 2,14V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V14A2,2 0 0,1 20,12Z"
    />
  </svg>
);

export const compareHorizontalSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M9 14H2V16H9V19L13 15L9 11V14M15 13V10H22V8H15V5L11 9L15 13Z" />
  </svg>
);

export const cashSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M3,6H21V18H3V6M12,9A3,3 0 0,1 15,12A3,3 0 0,1 12,15A3,3 0 0,1 9,12A3,3 0 0,1 12,9M7,8A2,2 0 0,1 5,10V14A2,2 0 0,1 7,16H17A2,2 0 0,1 19,14V10A2,2 0 0,1 17,8H7Z"
    />
  </svg>
);

export const reOrderHorizontalSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M3,15H21V13H3V15M3,19H21V17H3V19M3,11H21V9H3V11M3,5V7H21V5H3Z" />
  </svg>
);

export const redditSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M2.204 14.049c-.06.276-.091.56-.091.847 0 3.443 4.402 6.249 9.814 6.249 5.41 0 9.812-2.804 9.812-6.249 0-.274-.029-.546-.082-.809l-.015-.032c-.021-.055-.029-.11-.029-.165-.302-1.175-1.117-2.241-2.296-3.103-.045-.016-.088-.039-.126-.07-.026-.02-.045-.042-.067-.064-1.792-1.234-4.356-2.008-7.196-2.008-2.815 0-5.354.759-7.146 1.971-.014.018-.029.033-.049.049-.039.033-.084.06-.13.075-1.206.862-2.042 1.937-2.354 3.123 0 .058-.014.114-.037.171l-.008.015zm9.773 5.441c-1.794 0-3.057-.389-3.863-1.197-.173-.174-.173-.457 0-.632.176-.165.46-.165.635 0 .63.629 1.685.943 3.228.943 1.542 0 2.591-.3 3.219-.929.165-.164.45-.164.629 0 .165.18.165.465 0 .645-.809.808-2.065 1.198-3.862 1.198l.014-.028zm-3.606-7.573c-.914 0-1.677.765-1.677 1.677 0 .91.763 1.65 1.677 1.65s1.651-.74 1.651-1.65c0-.912-.739-1.677-1.651-1.677zm7.233 0c-.914 0-1.678.765-1.678 1.677 0 .91.764 1.65 1.678 1.65s1.651-.74 1.651-1.65c0-.912-.739-1.677-1.651-1.677zm4.548-1.595c1.037.833 1.8 1.821 2.189 2.904.45-.336.719-.864.719-1.449 0-1.002-.815-1.816-1.818-1.816-.399 0-.778.129-1.09.363v-.002zM2.711 9.963c-1.003 0-1.817.816-1.817 1.818 0 .543.239 1.048.644 1.389.401-1.079 1.172-2.053 2.213-2.876-.302-.21-.663-.329-1.039-.329v-.002zm9.217 12.079c-5.906 0-10.709-3.205-10.709-7.142 0-.275.023-.544.068-.809C.494 13.598 0 12.729 0 11.777c0-1.496 1.227-2.713 2.725-2.713.674 0 1.303.246 1.797.682 1.856-1.191 4.357-1.941 7.112-1.992l1.812-5.524.404.095s.016 0 .016.002l4.223.993c.344-.798 1.138-1.36 2.065-1.36 1.229 0 2.231 1.004 2.231 2.234 0 1.232-1.003 2.234-2.231 2.234s-2.23-1.004-2.23-2.23l-3.851-.912-1.467 4.477c2.65.105 5.047.854 6.844 2.021.494-.464 1.144-.719 1.833-.719 1.498 0 2.718 1.213 2.718 2.711 0 .987-.54 1.886-1.378 2.365.029.255.059.494.059.749-.015 3.938-4.806 7.143-10.72 7.143l-.034.009zm8.179-19.187c-.74 0-1.34.599-1.34 1.338 0 .738.6 1.34 1.34 1.34.732 0 1.33-.6 1.33-1.334 0-.733-.598-1.332-1.347-1.332l.017-.012z"
    />
  </svg>
);

export const facebookSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M22.676 0H1.324C.593 0 0 .593 0 1.324v21.352C0 23.408.593 24 1.324 24h11.494v-9.294H9.689v-3.621h3.129V8.41c0-3.099 1.894-4.785 4.659-4.785 1.325 0 2.464.097 2.796.141v3.24h-1.921c-1.5 0-1.792.721-1.792 1.771v2.311h3.584l-.465 3.63H16.56V24h6.115c.733 0 1.325-.592 1.325-1.324V1.324C24 .593 23.408 0 22.676 0"
    />
  </svg>
);

export const timeSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12 20C16.4 20 20 16.4 20 12S16.4 4 12 4 4 7.6 4 12 7.6 20 12 20M12 2C17.5 2 22 6.5 22 12S17.5 22 12 22C6.5 22 2 17.5 2 12C2 6.5 6.5 2 12 2M17 13.9L16.3 15.2L11 12.3V7H12.5V11.4L17 13.9Z"
    />
  </svg>
);

export const pinSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M16,12V4H17V2H7V4H8V12L6,14V16H11.2V22H12.8V16H18V14L16,12Z" />
  </svg>
);

export const pencilOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M14.06,9L15,9.94L5.92,19H5V18.08L14.06,9M17.66,3C17.41,3 17.15,3.1 16.96,3.29L15.13,5.12L18.88,8.87L20.71,7.04C21.1,6.65 21.1,6 20.71,5.63L18.37,3.29C18.17,3.09 17.92,3 17.66,3M14.06,6.19L3,17.25V21H6.75L17.81,9.94L14.06,6.19Z"
    />
  </svg>
);

export const cloneOutlineSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2.5"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <rect x="9" y="9" width="13" height="13" rx="2" ry="2" />
    <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" />
  </svg>
);

export const formatBoldSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13.5,15.5H10V12.5H13.5A1.5,1.5 0 0,1 15,14A1.5,1.5 0 0,1 13.5,15.5M10,6.5H13A1.5,1.5 0 0,1 14.5,8A1.5,1.5 0 0,1 13,9.5H10M15.6,10.79C16.57,10.11 17.25,9 17.25,8C17.25,5.74 15.5,4 13.25,4H7V18H14.04C16.14,18 17.75,16.3 17.75,14.21C17.75,12.69 16.89,11.39 15.6,10.79Z"
    />
  </svg>
);

export const formatItalicSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M10,4V7H12.21L8.79,15H6V18H14V15H11.79L15.21,7H18V4H10Z" />
  </svg>
);

export const formatTitleSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M5,4V7H10.5V19H13.5V7H19V4H5Z" />
  </svg>
);

export const codeTagsSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M14.6,16.6L19.2,12L14.6,7.4L16,6L22,12L16,18L14.6,16.6M9.4,16.6L4.8,12L9.4,7.4L8,6L2,12L8,18L9.4,16.6Z"
    />
  </svg>
);

export const formatQuoteCloseSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M14,17H17L19,13V7H13V13H16M6,17H9L11,13V7H5V13H8L6,17Z" />
  </svg>
);

export const formatListNumberedSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M7,13V11H21V13H7M7,19V17H21V19H7M7,7V5H21V7H7M3,8V5H2V4H4V8H3M2,17V16H5V20H2V19H4V18.5H3V17.5H4V17H2M4.25,10A0.75,0.75 0 0,1 5,10.75C5,10.95 4.92,11.14 4.79,11.27L3.12,13H5V14H2V13.08L4,11H2V10H4.25Z"
    />
  </svg>
);

export const formatListBulletedSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M7,5H21V7H7V5M7,13V11H21V13H7M4,4.5A1.5,1.5 0 0,1 5.5,6A1.5,1.5 0 0,1 4,7.5A1.5,1.5 0 0,1 2.5,6A1.5,1.5 0 0,1 4,4.5M4,10.5A1.5,1.5 0 0,1 5.5,12A1.5,1.5 0 0,1 4,13.5A1.5,1.5 0 0,1 2.5,12A1.5,1.5 0 0,1 4,10.5M7,19V17H21V19H7M4,16.5A1.5,1.5 0 0,1 5.5,18A1.5,1.5 0 0,1 4,19.5A1.5,1.5 0 0,1 2.5,18A1.5,1.5 0 0,1 4,16.5Z"
    />
  </svg>
);

export const linkSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M3.9,12C3.9,10.29 5.29,8.9 7,8.9H11V7H7A5,5 0 0,0 2,12A5,5 0 0,0 7,17H11V15.1H7C5.29,15.1 3.9,13.71 3.9,12M8,13H16V11H8V13M17,7H13V8.9H17C18.71,8.9 20.1,10.29 20.1,12C20.1,13.71 18.71,15.1 17,15.1H13V17H17A5,5 0 0,0 22,12A5,5 0 0,0 17,7Z"
    />
  </svg>
);

export const imageSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M8.5,13.5L11,16.5L14.5,12L19,18H5M21,19V5C21,3.89 20.1,3 19,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19Z"
    />
  </svg>
);

export const gridSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M10,4V8H14V4H10M16,4V8H20V4H16M16,10V14H20V10H16M16,16V20H20V16H16M14,20V16H10V20H14M8,20V16H4V20H8M8,14V10H4V14H8M8,8V4H4V8H8M10,14H14V10H10V14M4,2H20A2,2 0 0,1 22,4V20A2,2 0 0,1 20,22H4C2.92,22 2,21.1 2,20V4A2,2 0 0,1 4,2Z"
    />
  </svg>
);

export const emoticonHappyOutlineSvg = (
  <svg viewBox="0 0 24 24" fill="currentColor">
    <path d="M20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12M22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2A10,10 0 0,1 22,12M10,9.5C10,10.3 9.3,11 8.5,11C7.7,11 7,10.3 7,9.5C7,8.7 7.7,8 8.5,8C9.3,8 10,8.7 10,9.5M17,9.5C17,10.3 16.3,11 15.5,11C14.7,11 14,10.3 14,9.5C14,8.7 14.7,8 15.5,8C16.3,8 17,8.7 17,9.5M12,17.23C10.25,17.23 8.71,16.5 7.81,15.42L9.23,14C9.68,14.72 10.75,15.23 12,15.23C13.25,15.23 14.32,14.72 14.77,14L16.19,15.42C15.29,16.5 13.75,17.23 12,17.23Z" />
  </svg>
);

export const poundSvg = (
  <svg width={16} height={16} viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M5.41,21L6.12,17H2.12L2.47,15H6.47L7.53,9H3.53L3.88,7H7.88L8.59,3H10.59L9.88,7H15.88L16.59,3H18.59L17.88,7H21.88L21.53,9H17.53L16.47,15H20.47L20.12,17H16.12L15.41,21H13.41L14.12,17H8.12L7.41,21H5.41M9.53,9L8.47,15H14.47L15.53,9H9.53Z"
    />
  </svg>
);

export const creditCardSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z"
    />
  </svg>
);

export const deleteForeverSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M6,19A2,2 0 0,0 8,21H16A2,2 0 0,0 18,19V7H6V19M8.46,11.88L9.87,10.47L12,12.59L14.12,10.47L15.53,11.88L13.41,14L15.53,16.12L14.12,17.53L12,15.41L9.88,17.53L8.47,16.12L10.59,14L8.46,11.88M15.5,4L14.5,3H9.5L8.5,4H5V6H19V4H15.5Z"
    />
  </svg>
);

export const checkSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z" />
  </svg>
);

export const alertCircleSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13,13H11V7H13M13,17H11V15H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"
    />
  </svg>
);

export const plusCircle = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17,13H13V17H11V13H7V11H11V7H13V11H17M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"
    />
  </svg>
);

export const arrowLeftSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M20,11V13H8L13.5,18.5L12.08,19.92L4.16,12L12.08,4.08L13.5,5.5L8,11H20Z"
    />
  </svg>
);

export const arrowRightSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M4,11V13H16L10.5,18.5L11.92,19.92L19.84,12L11.92,4.08L10.5,5.5L16,11H4Z"
    />
  </svg>
);

export const refreshSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z"
    />
  </svg>
);

export const keySvg = (
  <svg width="18" height="18" viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M7,14A2,2 0 0,1 5,12A2,2 0 0,1 7,10A2,2 0 0,1 9,12A2,2 0 0,1 7,14M12.65,10C11.83,7.67 9.61,6 7,6A6,6 0 0,0 1,12A6,6 0 0,0 7,18C9.61,18 11.83,16.33 12.65,14H17V18H21V14H23V10H12.65Z"
    />
  </svg>
);

export const bellSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
    <path d="M0 0h24v24H0V0z" fill="none" />
    <path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm6-6v-5c0-3.07-1.63-5.64-4.5-6.32V4c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v.68C7.64 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2zm-2 1H8v-6c0-2.48 1.51-4.5 4-4.5s4 2.02 4 4.5v6z" />
  </svg>
);

export const bellOffSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M20.84,22.73L18.11,20H3V19L5,17V11C5,9.86 5.29,8.73 5.83,7.72L1.11,3L2.39,1.73L22.11,21.46L20.84,22.73M19,15.8V11C19,7.9 16.97,5.17 14,4.29C14,4.19 14,4.1 14,4A2,2 0 0,0 12,2A2,2 0 0,0 10,4C10,4.1 10,4.19 10,4.29C9.39,4.47 8.8,4.74 8.26,5.09L19,15.8M12,23A2,2 0 0,0 14,21H10A2,2 0 0,0 12,23Z"
    />
  </svg>
);

export const bellCheckSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17.75 21.16L15 18.16L16.16 17L17.75 18.59L21.34 15L22.5 16.41L17.75 21.16M3 20V19L5 17V11C5 7.9 7.03 5.18 10 4.29V4C10 2.9 10.9 2 12 2C13.11 2 14 2.9 14 4V4.29C16.97 5.18 19 7.9 19 11V12.08L18 12C14.69 12 12 14.69 12 18C12 18.7 12.12 19.37 12.34 20H3M12 23C10.9 23 10 22.11 10 21H12.8C13.04 21.41 13.33 21.79 13.65 22.13C13.29 22.66 12.69 23 12 23Z"
    />
  </svg>
);

export const syncSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,18A6,6 0 0,1 6,12C6,11 6.25,10.03 6.7,9.2L5.24,7.74C4.46,8.97 4,10.43 4,12A8,8 0 0,0 12,20V23L16,19L12,15M12,4V1L8,5L12,9V6A6,6 0 0,1 18,12C18,13 17.75,13.97 17.3,14.8L18.76,16.26C19.54,15.03 20,13.57 20,12A8,8 0 0,0 12,4Z"
    />
  </svg>
);

export const contentSaveSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M15,9H5V5H15M12,19A3,3 0 0,1 9,16A3,3 0 0,1 12,13A3,3 0 0,1 15,16A3,3 0 0,1 12,19M17,3H5C3.89,3 3,3.9 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V7L17,3Z"
    />
  </svg>
);

export const contentLoadSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2.5"
    strokeLinecap="butt"
  >
    <path d="M21.5 2v6h-6M2.5 22v-6h6M2 11.5a10 10 0 0 1 18.8-4.3M22 12.5a10 10 0 0 1-18.8 4.2" />
  </svg>
);

export const bookmarkSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M17,3H7A2,2 0 0,0 5,5V21L12,18L19,21V5C19,3.89 18.1,3 17,3Z" />
  </svg>
);

export const bookmarkOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17,18L12,15.82L7,18V5H17M17,3H7A2,2 0 0,0 5,5V21L12,18L19,21V5C19,3.89 18.1,3 17,3Z"
    />
  </svg>
);

export const starSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,17.27L18.18,21L16.54,13.97L22,9.24L14.81,8.62L12,2L9.19,8.62L2,9.24L7.45,13.97L5.82,21L12,17.27Z"
    />
  </svg>
);

export const starOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,15.39L8.24,17.66L9.23,13.38L5.91,10.5L10.29,10.13L12,6.09L13.71,10.13L18.09,10.5L14.77,13.38L15.76,17.66M22,9.24L14.81,8.63L12,2L9.19,8.63L2,9.24L7.45,13.97L5.82,21L12,17.27L18.18,21L16.54,13.97L22,9.24Z"
    />
  </svg>
);

export const accountOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,6A2,2 0 0,0 10,8A2,2 0 0,0 12,10A2,2 0 0,0 14,8A2,2 0 0,0 12,6M12,13C14.67,13 20,14.33 20,17V20H4V17C4,14.33 9.33,13 12,13M12,14.9C9.03,14.9 5.9,16.36 5.9,17V18.1H18.1V17C18.1,16.36 14.97,14.9 12,14.9Z"
    />
  </svg>
);

export const userOutlineSvg = (
  <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
    <g clipPath="url(#clip0)">
      <path
        d="M8.8744 10.0522C3.88219 10.0522 1.13281 12.4139 1.13281 16.7023C1.13281 17.0373 1.40427 17.3087 1.7392 17.3087H16.0096C16.3445 17.3087 16.616 17.0373 16.616 16.7023C16.616 12.4142 13.8666 10.0522 8.8744 10.0522ZM2.36765 16.0959C2.60617 12.8896 4.79219 11.265 8.8744 11.265C12.9566 11.265 15.1427 12.8896 15.3814 16.0959H2.36765Z"
        fill="currentColor"
      />
      <path
        d="M8.87394 0.692871C6.58077 0.692871 4.85156 2.45686 4.85156 4.79592C4.85156 7.20348 6.65599 9.16192 8.87394 9.16192C11.0919 9.16192 12.8963 7.20348 12.8963 4.79611C12.8963 2.45686 11.1671 0.692871 8.87394 0.692871ZM8.87394 7.94934C7.32462 7.94934 6.06433 6.53482 6.06433 4.79611C6.06433 3.12127 7.24599 1.90564 8.87394 1.90564C10.4758 1.90564 11.6835 3.14814 11.6835 4.79611C11.6835 6.53482 10.4233 7.94934 8.87394 7.94934Z"
        fill="currentColor"
      />
    </g>
    <defs>
      <clipPath id="clip0">
        <rect
          width="17.343"
          height="17.343"
          fill="white"
          transform="translate(0.203125 0.328613)"
        />
      </clipPath>
    </defs>
  </svg>
);

export const checkAllSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M0.41,13.41L6,19L7.41,17.58L1.83,12M22.24,5.58L11.66,16.17L7.5,12L6.07,13.41L11.66,19L23.66,7M18,7L16.59,5.58L10.24,11.93L11.66,13.34L18,7Z"
    />
  </svg>
);

export const gpsSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,8A4,4 0 0,1 16,12A4,4 0 0,1 12,16A4,4 0 0,1 8,12A4,4 0 0,1 12,8M3.05,13H1V11H3.05C3.5,6.83 6.83,3.5 11,3.05V1H13V3.05C17.17,3.5 20.5,6.83 20.95,11H23V13H20.95C20.5,17.17 17.17,20.5 13,20.95V23H11V20.95C6.83,20.5 3.5,17.17 3.05,13M12,5A7,7 0 0,0 5,12A7,7 0 0,0 12,19A7,7 0 0,0 19,12A7,7 0 0,0 12,5Z"
    />
  </svg>
);

export const rocketSvg = (
  <svg width="16px" height="16px" viewBox="0 0 512 512" version="1.1">
    <path
      fill="currentColor"
      d="M494.41,0.783 C490.167,0.972 412.085,4.973 340.075,42.863 L469.135,171.923 C507.025,99.913 511.026,21.831 511.215,17.588 L511.999,0 L494.41,0.783 Z"
    />
    <path
      fill="currentColor"
      d="M452.007,200.344 L311.654,59.992 C300.094,67.958 289.001,76.981 278.762,87.221 L222.827,143.156 L95.071,121.623 L2.84217094e-14,216.694 L127.757,238.227 L120.544,245.44 C104.756,261.227 97.327,282.83 99.624,306.271 C101.563,326.056 110.338,345.785 125.187,364.038 L244.128,245.097 L266.903,267.872 L147.961,386.812 C166.213,401.661 185.943,410.436 205.728,412.375 C208.52,412.649 211.284,412.785 214.017,412.785 C234.229,412.785 252.652,405.362 266.558,391.455 L273.77,384.243 L295.303,512 L390.374,416.929 L368.842,289.171 L424.777,233.236 C435.018,222.997 444.042,211.905 452.007,200.344 Z M351.08,202.692 C345.322,208.451 337.757,211.33 330.194,211.33 C322.63,211.33 315.065,208.45 309.308,202.692 C297.79,191.175 297.79,172.436 309.308,160.918 C320.825,149.4 339.565,149.4 351.082,160.918 C362.598,172.436 362.598,191.175 351.08,202.692 Z"
    />
  </svg>
);

export const uploadSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M9,16V10H5L12,3L19,10H15V16H9M5,20V18H19V20H5Z" />
  </svg>
);

export const historySvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13.5,8H12V13L16.28,15.54L17,14.33L13.5,12.25V8M13,3A9,9 0 0,0 4,12H1L4.96,16.03L9,12H6A7,7 0 0,1 13,5A7,7 0 0,1 20,12A7,7 0 0,1 13,19C11.07,19 9.32,18.21 8.06,16.94L6.64,18.36C8.27,20 10.5,21 13,21A9,9 0 0,0 22,12A9,9 0 0,0 13,3"
    />
  </svg>
);

export const tagSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M5.5,7A1.5,1.5 0 0,1 4,5.5A1.5,1.5 0 0,1 5.5,4A1.5,1.5 0 0,1 7,5.5A1.5,1.5 0 0,1 5.5,7M21.41,11.58L12.41,2.58C12.05,2.22 11.55,2 11,2H4C2.89,2 2,2.89 2,4V11C2,11.55 2.22,12.05 2.59,12.41L11.58,21.41C11.95,21.77 12.45,22 13,22C13.55,22 14.05,21.77 14.41,21.41L21.41,14.41C21.78,14.05 22,13.55 22,13C22,12.44 21.77,11.94 21.41,11.58Z"
    />
  </svg>
);

export const scriptTextOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M15,20A1,1 0 0,0 16,19V4H8A1,1 0 0,0 7,5V16H5V5A3,3 0 0,1 8,2H19A3,3 0 0,1 22,5V6H20V5A1,1 0 0,0 19,4A1,1 0 0,0 18,5V9L18,19A3,3 0 0,1 15,22H5A3,3 0 0,1 2,19V18H13A2,2 0 0,0 15,20M9,6H14V8H9V6M9,10H14V12H9V10M9,14H14V16H9V14Z"
    />
  </svg>
);

export const menuSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z" />
  </svg>
);

export const dotsHorizontal = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M16,12A2,2 0 0,1 18,10A2,2 0 0,1 20,12A2,2 0 0,1 18,14A2,2 0 0,1 16,12M10,12A2,2 0 0,1 12,10A2,2 0 0,1 14,12A2,2 0 0,1 12,14A2,2 0 0,1 10,12M4,12A2,2 0 0,1 6,10A2,2 0 0,1 8,12A2,2 0 0,1 6,14A2,2 0 0,1 4,12Z"
    />
  </svg>
);

export const openInNewSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M14,3V5H17.59L7.76,14.83L9.17,16.24L19,6.41V10H21V3M19,19H5V5H12V3H5C3.89,3 3,3.9 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V12H19V19Z"
    />
  </svg>
);

export const paletteOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2C17.5,2 22,6 22,11A6,6 0 0,1 16,17H14.2C13.9,17 13.7,17.2 13.7,17.5C13.7,17.6 13.8,17.7 13.8,17.8C14.2,18.3 14.4,18.9 14.4,19.5C14.5,20.9 13.4,22 12,22M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C12.3,20 12.5,19.8 12.5,19.5C12.5,19.3 12.4,19.2 12.4,19.1C12,18.6 11.8,18.1 11.8,17.5C11.8,16.1 12.9,15 14.3,15H16A4,4 0 0,0 20,11C20,7.1 16.4,4 12,4M6.5,10C7.3,10 8,10.7 8,11.5C8,12.3 7.3,13 6.5,13C5.7,13 5,12.3 5,11.5C5,10.7 5.7,10 6.5,10M9.5,6C10.3,6 11,6.7 11,7.5C11,8.3 10.3,9 9.5,9C8.7,9 8,8.3 8,7.5C8,6.7 8.7,6 9.5,6M14.5,6C15.3,6 16,6.7 16,7.5C16,8.3 15.3,9 14.5,9C13.7,9 13,8.3 13,7.5C13,6.7 13.7,6 14.5,6M17.5,10C18.3,10 19,10.7 19,11.5C19,12.3 18.3,13 17.5,13C16.7,13 16,12.3 16,11.5C16,10.7 16.7,10 17.5,10Z"
    />
  </svg>
);

export const virusOutline = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12 .5C11.03 .5 10.25 1.28 10.25 2.25C10.25 2.84 10.55 3.37 11 3.68V5.08C10.1 5.21 9.26 5.5 8.5 5.94L7.39 4.35C7.58 3.83 7.53 3.23 7.19 2.75C6.84 2.26 6.3 2 5.75 2C5.4 2 5.05 2.1 4.75 2.32C3.96 2.87 3.76 3.96 4.32 4.75C4.66 5.24 5.2 5.5 5.75 5.5L6.93 7.18C6.5 7.61 6.16 8.09 5.87 8.62C5.67 8.54 5.46 8.5 5.25 8.5C4.8 8.5 4.35 8.67 4 9C3.33 9.7 3.33 10.8 4 11.5C4.29 11.77 4.64 11.92 5 12L5 12C5 12.54 5.07 13.06 5.18 13.56L3.87 13.91C3.56 13.65 3.16 13.5 2.75 13.5C2.6 13.5 2.44 13.5 2.29 13.56C1.36 13.81 .809 14.77 1.06 15.71C1.27 16.5 2 17 2.75 17C2.9 17 3.05 17 3.21 16.94C3.78 16.78 4.21 16.36 4.39 15.84L5.9 15.43C6.35 16.22 6.95 16.92 7.65 17.5L6.55 19.5C6 19.58 5.5 19.89 5.21 20.42C4.75 21.27 5.07 22.33 5.92 22.79C6.18 22.93 6.47 23 6.75 23C7.37 23 7.97 22.67 8.29 22.08C8.57 21.56 8.56 20.96 8.31 20.47L9.38 18.5C10.19 18.82 11.07 19 12 19C12.06 19 12.12 19 12.18 19C12.05 19.26 12 19.56 12 19.88C12.08 20.8 12.84 21.5 13.75 21.5C13.79 21.5 13.84 21.5 13.88 21.5C14.85 21.42 15.57 20.58 15.5 19.62C15.46 19.12 15.21 18.68 14.85 18.39C15.32 18.18 15.77 17.91 16.19 17.6L18.53 19.94C18.43 20.5 18.59 21.07 19 21.5C19.35 21.83 19.8 22 20.25 22S21.15 21.83 21.5 21.5C22.17 20.8 22.17 19.7 21.5 19C21.15 18.67 20.7 18.5 20.25 18.5C20.15 18.5 20.05 18.5 19.94 18.53L17.6 16.19C18.09 15.54 18.47 14.8 18.71 14H19.82C20.13 14.45 20.66 14.75 21.25 14.75C22.22 14.75 23 13.97 23 13S22.22 11.25 21.25 11.25C20.66 11.25 20.13 11.55 19.82 12H19C19 10.43 18.5 9 17.6 7.81L18.94 6.47C19.05 6.5 19.15 6.5 19.25 6.5C19.7 6.5 20.15 6.33 20.5 6C21.17 5.31 21.17 4.2 20.5 3.5C20.15 3.17 19.7 3 19.25 3S18.35 3.17 18 3.5C17.59 3.93 17.43 4.5 17.53 5.06L16.19 6.4C15.27 5.71 14.19 5.25 13 5.08V3.68C13.45 3.37 13.75 2.84 13.75 2.25C13.75 1.28 12.97 .5 12 .5M12 17C9.24 17 7 14.76 7 12S9.24 7 12 7 17 9.24 17 12 14.76 17 12 17M10.5 9C9.67 9 9 9.67 9 10.5S9.67 12 10.5 12 12 11.33 12 10.5 11.33 9 10.5 9M14 13C13.45 13 13 13.45 13 14C13 14.55 13.45 15 14 15C14.55 15 15 14.55 15 14C15 13.45 14.55 13 14 13Z"
    />
  </svg>
);

export const voteOutline = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M18,13L21,16V20C21,21.11 20.1,22 19,22H5C3.89,22 3,21.1 3,20V16L6,13H6.83L8.83,15H6.78L5,17H19L17.23,15H15.32L17.32,13H18M19,20V19H5V20H19M11.34,15L6.39,10.07C6,9.68 6,9.05 6.39,8.66L12.76,2.29C13.15,1.9 13.78,1.9 14.16,2.3L19.11,7.25C19.5,7.64 19.5,8.27 19.11,8.66L12.75,15C12.36,15.41 11.73,15.41 11.34,15M13.46,4.41L8.5,9.36L12.05,12.9L17,7.95L13.46,4.41Z"
    />
  </svg>
);

export const gamepadSquareOutline = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M21,6H3A2,2 0 0,0 1,8V16A2,2 0 0,0 3,18H21A2,2 0 0,0 23,16V8A2,2 0 0,0 21,6M21,16H3V8H21M6,15H8V13H10V11H8V9H6V11H4V13H6M14.5,12A1.5,1.5 0 0,1 16,13.5A1.5,1.5 0 0,1 14.5,15A1.5,1.5 0 0,1 13,13.5A1.5,1.5 0 0,1 14.5,12M18.5,9A1.5,1.5 0 0,1 20,10.5A1.5,1.5 0 0,1 18.5,12A1.5,1.5 0 0,1 17,10.5A1.5,1.5 0 0,1 18.5,9Z"
    />
  </svg>
);

export const financeSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M6,16.5L3,19.44V11H6M11,14.66L9.43,13.32L8,14.64V7H11M16,13L13,16V3H16M18.81,12.81L17,11H22V16L20.21,14.21L13,21.36L9.53,18.34L5.75,22H3L9.47,15.66L13,18.64"
    />
  </svg>
);

export const accountTieSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12 3C14.21 3 16 4.79 16 7S14.21 11 12 11 8 9.21 8 7 9.79 3 12 3M16 13.54C16 14.6 15.72 17.07 13.81 19.83L13 15L13.94 13.12C13.32 13.05 12.67 13 12 13S10.68 13.05 10.06 13.12L11 15L10.19 19.83C8.28 17.07 8 14.6 8 13.54C5.61 14.24 4 15.5 4 17V21H20V17C20 15.5 18.4 14.24 16 13.54Z"
    />
  </svg>
);

export const cameraSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M4,4H7L9,2H15L17,4H20A2,2 0 0,1 22,6V18A2,2 0 0,1 20,20H4A2,2 0 0,1 2,18V6A2,2 0 0,1 4,4M12,7A5,5 0 0,0 7,12A5,5 0 0,0 12,17A5,5 0 0,0 17,12A5,5 0 0,0 12,7M12,9A3,3 0 0,1 15,12A3,3 0 0,1 12,15A3,3 0 0,1 9,12A3,3 0 0,1 12,9Z"
    />
  </svg>
);

export const codeTags = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M14.6,16.6L19.2,12L14.6,7.4L16,6L22,12L16,18L14.6,16.6M9.4,16.6L4.8,12L9.4,7.4L8,6L2,12L8,18L9.4,16.6Z"
    />
  </svg>
);

export const televisionSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M21,17H3V5H21M21,3H3A2,2 0 0,0 1,5V17A2,2 0 0,0 3,19H8V21H16V19H21A2,2 0 0,0 23,17V5A2,2 0 0,0 21,3Z"
    />
  </svg>
);

export const bullHornSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,8H4A2,2 0 0,0 2,10V14A2,2 0 0,0 4,16H5V20A1,1 0 0,0 6,21H8A1,1 0 0,0 9,20V16H12L17,20V4L12,8M21.5,12C21.5,13.71 20.54,15.26 19,16V8C20.53,8.75 21.5,10.3 21.5,12Z"
    />
  </svg>
);

export const basketballSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M2.34,14.63C2.94,14.41 3.56,14.3 4.22,14.3C5.56,14.3 6.73,14.72 7.73,15.56L4.59,18.7C3.53,17.5 2.78,16.13 2.34,14.63M15.56,9.8C17.53,11.27 19.66,11.63 21.94,10.88C21.97,11.09 22,11.47 22,12C22,13.03 21.75,14.18 21.28,15.45C20.81,16.71 20.23,17.73 19.55,18.5L13.22,12.19L15.56,9.8M8.77,16.64C9.83,18.17 10.05,19.84 9.42,21.66C8,21.25 6.73,20.61 5.67,19.73L8.77,16.64M12.19,13.22L18.5,19.55C16.33,21.45 13.78,22.25 10.88,21.94C11.09,21.28 11.2,20.56 11.2,19.78C11.2,19.16 11.06,18.43 10.78,17.6C10.5,16.77 10.17,16.09 9.8,15.56L12.19,13.22M8.81,14.5C7.88,13.67 6.8,13.15 5.58,12.91C4.36,12.68 3.19,12.75 2.06,13.13C2.03,12.91 2,12.53 2,12C2,10.97 2.25,9.82 2.72,8.55C3.19,7.29 3.77,6.27 4.45,5.5L11.11,12.19L8.81,14.5M15.56,7.73C14.22,6.08 13.91,4.28 14.63,2.34C15.25,2.5 15.96,2.8 16.76,3.26C17.55,3.71 18.2,4.16 18.7,4.59L15.56,7.73M21.66,9.38C21.06,9.59 20.44,9.7 19.78,9.7C18.69,9.7 17.64,9.38 16.64,8.72L19.73,5.67C20.61,6.77 21.25,8 21.66,9.38M12.19,11.11L5.5,4.45C7.67,2.55 10.22,1.75 13.13,2.06C12.91,2.72 12.8,3.44 12.8,4.22C12.8,4.94 12.96,5.75 13.29,6.66C13.62,7.56 14,8.28 14.5,8.81L12.19,11.11Z"
    />
  </svg>
);

export const reactSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,10.11C13.03,10.11 13.87,10.95 13.87,12C13.87,13 13.03,13.85 12,13.85C10.97,13.85 10.13,13 10.13,12C10.13,10.95 10.97,10.11 12,10.11M7.37,20C8,20.38 9.38,19.8 10.97,18.3C10.45,17.71 9.94,17.07 9.46,16.4C8.64,16.32 7.83,16.2 7.06,16.04C6.55,18.18 6.74,19.65 7.37,20M8.08,14.26L7.79,13.75C7.68,14.04 7.57,14.33 7.5,14.61C7.77,14.67 8.07,14.72 8.38,14.77C8.28,14.6 8.18,14.43 8.08,14.26M14.62,13.5L15.43,12L14.62,10.5C14.32,9.97 14,9.5 13.71,9.03C13.17,9 12.6,9 12,9C11.4,9 10.83,9 10.29,9.03C10,9.5 9.68,9.97 9.38,10.5L8.57,12L9.38,13.5C9.68,14.03 10,14.5 10.29,14.97C10.83,15 11.4,15 12,15C12.6,15 13.17,15 13.71,14.97C14,14.5 14.32,14.03 14.62,13.5M12,6.78C11.81,7 11.61,7.23 11.41,7.5C11.61,7.5 11.8,7.5 12,7.5C12.2,7.5 12.39,7.5 12.59,7.5C12.39,7.23 12.19,7 12,6.78M12,17.22C12.19,17 12.39,16.77 12.59,16.5C12.39,16.5 12.2,16.5 12,16.5C11.8,16.5 11.61,16.5 11.41,16.5C11.61,16.77 11.81,17 12,17.22M16.62,4C16,3.62 14.62,4.2 13.03,5.7C13.55,6.29 14.06,6.93 14.54,7.6C15.36,7.68 16.17,7.8 16.94,7.96C17.45,5.82 17.26,4.35 16.62,4M15.92,9.74L16.21,10.25C16.32,9.96 16.43,9.67 16.5,9.39C16.23,9.33 15.93,9.28 15.62,9.23C15.72,9.4 15.82,9.57 15.92,9.74M17.37,2.69C18.84,3.53 19,5.74 18.38,8.32C20.92,9.07 22.75,10.31 22.75,12C22.75,13.69 20.92,14.93 18.38,15.68C19,18.26 18.84,20.47 17.37,21.31C15.91,22.15 13.92,21.19 12,19.36C10.08,21.19 8.09,22.15 6.62,21.31C5.16,20.47 5,18.26 5.62,15.68C3.08,14.93 1.25,13.69 1.25,12C1.25,10.31 3.08,9.07 5.62,8.32C5,5.74 5.16,3.53 6.62,2.69C8.09,1.85 10.08,2.81 12,4.64C13.92,2.81 15.91,1.85 17.37,2.69M17.08,12C17.42,12.75 17.72,13.5 17.97,14.26C20.07,13.63 21.25,12.73 21.25,12C21.25,11.27 20.07,10.37 17.97,9.74C17.72,10.5 17.42,11.25 17.08,12M6.92,12C6.58,11.25 6.28,10.5 6.03,9.74C3.93,10.37 2.75,11.27 2.75,12C2.75,12.73 3.93,13.63 6.03,14.26C6.28,13.5 6.58,12.75 6.92,12M15.92,14.26C15.82,14.43 15.72,14.6 15.62,14.77C15.93,14.72 16.23,14.67 16.5,14.61C16.43,14.33 16.32,14.04 16.21,13.75L15.92,14.26M13.03,18.3C14.62,19.8 16,20.38 16.62,20C17.26,19.65 17.45,18.18 16.94,16.04C16.17,16.2 15.36,16.32 14.54,16.4C14.06,17.07 13.55,17.71 13.03,18.3M8.08,9.74C8.18,9.57 8.28,9.4 8.38,9.23C8.07,9.28 7.77,9.33 7.5,9.39C7.57,9.67 7.68,9.96 7.79,10.25L8.08,9.74M10.97,5.7C9.38,4.2 8,3.62 7.37,4C6.74,4.35 6.55,5.82 7.06,7.96C7.83,7.8 8.64,7.68 9.46,7.6C9.94,6.93 10.45,6.29 10.97,5.7Z"
    />
  </svg>
);

export const spaSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M15.5,9.63C15.31,6.84 14.18,4.12 12.06,2C9.92,4.14 8.74,6.86 8.5,9.63C9.79,10.31 10.97,11.19 12,12.26C13.03,11.2 14.21,10.32 15.5,9.63M12,15.45C9.85,12.17 6.18,10 2,10C2,20 11.32,21.89 12,22C12.68,21.88 22,20 22,10C17.82,10 14.15,12.17 12,15.45Z"
    />
  </svg>
);

export const walletTravelSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M20,14H4V8H7V10H9V8H15V10H17V8H20M20,19H4V17H20M9,4H15V6H9M20,6H17V4C17,2.89 16.11,2 15,2H9C7.89,2 7,2.89 7,4V6H4C2.89,6 2,6.89 2,8V19C2,20.11 2.89,21 4,21H20C21.11,21 22,20.11 22,19V8C22,6.89 21.11,6 20,6Z"
    />
  </svg>
);

export const hiveSvg = (
  <svg viewBox="0 0 512 512">
    <path
      fill="currentColor"
      d="M260.353,254.878,131.538,33.1a2.208,2.208,0,0,0-3.829.009L.3,254.887A2.234,2.234,0,0,0,.3,257.122L129.116,478.9a2.208,2.208,0,0,0,3.83-.009L260.358,257.113A2.239,2.239,0,0,0,260.353,254.878Zm39.078-25.713a2.19,2.19,0,0,0,1.9,1.111h66.509a2.226,2.226,0,0,0,1.9-3.341L259.115,33.111a2.187,2.187,0,0,0-1.9-1.111H190.707a2.226,2.226,0,0,0-1.9,3.341ZM511.7,254.886,384.9,33.112A2.2,2.2,0,0,0,382.99,32h-66.6a2.226,2.226,0,0,0-1.906,3.34L440.652,256,314.481,476.66a2.226,2.226,0,0,0,1.906,3.34h66.6a2.2,2.2,0,0,0,1.906-1.112L511.7,257.114A2.243,2.243,0,0,0,511.7,254.886ZM366.016,284.917H299.508a2.187,2.187,0,0,0-1.9,1.111l-108.8,190.631a2.226,2.226,0,0,0,1.9,3.341h66.509a2.187,2.187,0,0,0,1.9-1.111l108.8-190.631A2.226,2.226,0,0,0,366.016,284.917Z"
    />
  </svg>
);

export const hiveEngineSvg = (
  <svg viewBox="0 0 512 512">
    <path
      fill="currentColor"
      d="M 226.63385,494.21287 A 38.3444,37.175214 0 0 0 153.83361,475.22554 257.02086,249.18385 0 0 1 103.53493,447.0743 38.334092,37.165221 0 0 0 50.192923,395.44372 253.78942,246.05095 0 0 1 21.179508,346.66625 38.3444,37.175214 0 0 0 1.66458,276.06583 a 254.27646,246.52314 0 0 1 0,-56.32245 38.334092,37.165221 0 0 0 19.576775,-70.59294 256.99767,249.16137 0 0 1 29.034029,-48.77497 38.3444,37.175214 0 0 0 53.256966,-51.73051 254.23523,246.48315 0 0 1 50.30899,-28.111257 38.3444,37.175214 0 0 0 72.83374,-18.9198855 254.18884,246.43819 0 0 1 58.08353,0 38.334092,37.165221 0 0 0 72.78993,18.9873395 257.52851,249.67603 0 0 1 50.29867,28.143736 38.3444,37.175214 0 0 0 53.35748,51.630577 254.03681,246.29078 0 0 1 28.99538,48.79496 38.3444,37.175214 0 0 0 19.51235,70.59293 253.70438,245.9685 0 0 1 0,56.35244 38.334092,37.165221 0 0 0 -19.58451,70.57044 257.22186,249.37873 0 0 1 -29.0366,48.76749 38.3444,37.175214 0 0 0 -53.25697,51.7305 253.44927,245.72117 0 0 1 -50.3296,28.11126 38.3444,37.175214 0 0 0 -72.81055,18.91989 252.9545,245.24149 0 0 1 -58.07322,0 z M 63.98196,247.91459 A 191.72201,185.87607 0 1 0 255.70396,62.03853 191.72201,185.87607 0 0 0 63.98196,247.91459 Z M 192.92274,388.54083 353.40745,282.97622 256.9383,212.2159 328.06098,111.68043 A 158.05726,153.23783 0 0 1 192.92274,388.54083 Z M 112.80407,182.5157 A 158.05984,153.24032 0 0 1 319.96175,107.90295 L 159.19101,213.45507 256.30438,282.98621 185.06832,384.9932 A 158.05984,153.24032 0 0 1 112.80407,182.5157 Z"
    />
  </svg>
);

export const spkSvg = (
  <svg viewBox="0 0 512 512">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M508.297 4.47022L426.843 94.3876L512 207.049L432.661 208.107L382.942 140.933L367.603 155.743V208.107H299.901V144.107C299.901 144.107 291.967 150.454 279.273 153.627C266.579 156.801 253.355 156.801 253.355 156.801H213.686V208.107H145.455V199.644C145.455 199.644 131.702 212.338 90.4463 212.867C49.1901 213.396 0 190.652 0 190.652L23.2727 141.462C23.2727 141.462 62.9421 161.561 90.4463 159.446C117.95 157.33 114.777 148.867 114.777 148.867C114.777 138.25 96.648 134.663 73.3864 130.06C68.8348 129.159 64.0868 128.22 59.2397 127.181C29.6198 120.834 4.2314 107.237 4.2314 68.4702C4.2314 -13.5133 123.769 0.23893 131.702 1.8257C139.636 3.41246 143.868 4.47022 143.868 4.47022H253.355C253.355 4.47022 263.405 4.47022 279.802 8.70172C296.198 12.9332 299.901 18.7512 299.901 18.7512V4.47022H367.603V75.8752L435.306 4.47022H508.297ZM145.455 64.2389V91.2141C145.455 91.2141 126.942 85.3959 110.545 80.6356C106.006 79.3176 100.979 78.405 96.0835 77.5162C83.2978 75.195 71.405 73.0359 71.405 64.2389C71.405 52.0736 92.0331 51.0158 107.901 52.6025C123.769 54.1893 145.455 64.2389 145.455 64.2389ZM214.215 57.8918V104.966H246.479C259.438 101.925 266.05 92.8009 266.05 81.1645C266.05 71.6041 261.818 61.0654 246.479 57.8918H214.215Z"
      fill="currentColor"
    />
  </svg>
);

export const translateSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12.87,15.07L10.33,12.56L10.36,12.53C12.1,10.59 13.34,8.36 14.07,6H17V4H10V2H8V4H1V6H12.17C11.5,7.92 10.44,9.75 9,11.35C8.07,10.32 7.3,9.19 6.69,8H4.69C5.42,9.63 6.42,11.17 7.67,12.56L2.58,17.58L4,19L9,14L12.11,17.11L12.87,15.07M18.5,10H16.5L12,22H14L15.12,19H19.87L21,22H23L18.5,10M15.88,17L17.5,12.67L19.12,17H15.88Z"
    />
  </svg>
);

export const plusSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M19,13H13V19H11V13H5V11H11V5H13V11H19V13Z" />
  </svg>
);

export const textBoxOutline = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M5,3C3.89,3 3,3.89 3,5V19C3,20.11 3.89,21 5,21H19C20.11,21 21,20.11 21,19V5C21,3.89 20.11,3 19,3H5M5,5H19V19H5V5M7,7V9H17V7H7M7,11V13H17V11H7M7,15V17H14V15H7Z"
    />
  </svg>
);

export const textShortSvg = (
  <svg viewBox="0 0 24 24">
    <path fill="currentColor" d="M4,9H20V11H4V9M4,13H14V15H4V13Z" />
  </svg>
);

export const giftOutlineSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M22,12V20A2,2 0 0,1 20,22H4A2,2 0 0,1 2,20V12A1,1 0 0,1 1,11V8A2,2 0 0,1 3,6H6.17C6.06,5.69 6,5.35 6,5A3,3 0 0,1 9,2C10,2 10.88,2.5 11.43,3.24V3.23L12,4L12.57,3.23V3.24C13.12,2.5 14,2 15,2A3,3 0 0,1 18,5C18,5.35 17.94,5.69 17.83,6H21A2,2 0 0,1 23,8V11A1,1 0 0,1 22,12M4,20H11V12H4V20M20,20V12H13V20H20M9,4A1,1 0 0,0 8,5A1,1 0 0,0 9,6A1,1 0 0,0 10,5A1,1 0 0,0 9,4M15,4A1,1 0 0,0 14,5A1,1 0 0,0 15,6A1,1 0 0,0 16,5A1,1 0 0,0 15,4M3,8V10H11V8H3M13,8V10H21V8H13Z"
    />
  </svg>
);

export const pickAxeSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M14.79,10.62L3.5,21.9L2.1,20.5L13.38,9.21L14.79,10.62M19.27,7.73L19.86,7.14L19.07,6.35L19.71,5.71L18.29,4.29L17.65,4.93L16.86,4.14L16.27,4.73C14.53,3.31 12.57,2.17 10.47,1.37L9.64,3.16C11.39,4.08 13,5.19 14.5,6.5L14,7L17,10L17.5,9.5C18.81,11 19.92,12.61 20.84,14.36L22.63,13.53C21.83,11.43 20.69,9.47 19.27,7.73Z"
    />
  </svg>
);

export const cashMultiple = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M5,6H23V18H5V6M14,9A3,3 0 0,1 17,12A3,3 0 0,1 14,15A3,3 0 0,1 11,12A3,3 0 0,1 14,9M9,8A2,2 0 0,1 7,10V14A2,2 0 0,1 9,16H19A2,2 0 0,1 21,14V10A2,2 0 0,1 19,8H9M1,10H3V20H19V22H1V10Z"
    />
  </svg>
);

export const shuffleVariantSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M17,3L22.25,7.5L17,12L22.25,16.5L17,21V18H14.26L11.44,15.18L13.56,13.06L15.5,15H17V12L17,9H15.5L6.5,18H2V15H5.26L14.26,6H17V3M2,6H6.5L9.32,8.82L7.2,10.94L5.26,9H2V6Z"
    />
  </svg>
);

export const shareVariantSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M18,16.08C17.24,16.08 16.56,16.38 16.04,16.85L8.91,12.7C8.96,12.47 9,12.24 9,12C9,11.76 8.96,11.53 8.91,11.3L15.96,7.19C16.5,7.69 17.21,8 18,8A3,3 0 0,0 21,5A3,3 0 0,0 18,2A3,3 0 0,0 15,5C15,5.24 15.04,5.47 15.09,5.7L8.04,9.81C7.5,9.31 6.79,9 6,9A3,3 0 0,0 3,12A3,3 0 0,0 6,15C6.79,15 7.5,14.69 8.04,14.19L15.16,18.34C15.11,18.55 15.08,18.77 15.08,19C15.08,20.61 16.39,21.91 18,21.91C19.61,21.91 20.92,20.61 20.92,19A2.92,2.92 0 0,0 18,16.08Z"
    />
  </svg>
);

export const linkVariantSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M10.59,13.41C11,13.8 11,14.44 10.59,14.83C10.2,15.22 9.56,15.22 9.17,14.83C7.22,12.88 7.22,9.71 9.17,7.76V7.76L12.71,4.22C14.66,2.27 17.83,2.27 19.78,4.22C21.73,6.17 21.73,9.34 19.78,11.29L18.29,12.78C18.3,11.96 18.17,11.14 17.89,10.36L18.36,9.88C19.54,8.71 19.54,6.81 18.36,5.64C17.19,4.46 15.29,4.46 14.12,5.64L10.59,9.17C9.41,10.34 9.41,12.24 10.59,13.41M13.41,9.17C13.8,8.78 14.44,8.78 14.83,9.17C16.78,11.12 16.78,14.29 14.83,16.24V16.24L11.29,19.78C9.34,21.73 6.17,21.73 4.22,19.78C2.27,17.83 2.27,14.66 4.22,12.71L5.71,11.22C5.7,12.04 5.83,12.86 6.11,13.65L5.64,14.12C4.46,15.29 4.46,17.19 5.64,18.36C6.81,19.54 8.71,19.54 9.88,18.36L13.41,14.83C14.59,13.66 14.59,11.76 13.41,10.59C13,10.2 13,9.56 13.41,9.17Z"
    />
  </svg>
);

export const volumeOffSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M12,4L9.91,6.09L12,8.18M4.27,3L3,4.27L7.73,9H3V15H7L12,20V13.27L16.25,17.53C15.58,18.04 14.83,18.46 14,18.7V20.77C15.38,20.45 16.63,19.82 17.68,18.96L19.73,21L21,19.73L12,10.73M19,12C19,12.94 18.8,13.82 18.46,14.64L19.97,16.15C20.62,14.91 21,13.5 21,12C21,7.72 18,4.14 14,3.23V5.29C16.89,6.15 19,8.83 19,12M16.5,12C16.5,10.23 15.5,8.71 14,7.97V10.18L16.45,12.63C16.5,12.43 16.5,12.21 16.5,12Z"
    />
  </svg>
);

export const rocketLaunchSvg = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M13.13 22.19L11.5 18.36C13.07 17.78 14.54 17 15.9 16.09L13.13 22.19M5.64 12.5L1.81 10.87L7.91 8.1C7 9.46 6.22 10.93 5.64 12.5M21.61 2.39C21.61 2.39 16.66 .269 11 5.93C8.81 8.12 7.5 10.53 6.65 12.64C6.37 13.39 6.56 14.21 7.11 14.77L9.24 16.89C9.79 17.45 10.61 17.63 11.36 17.35C13.5 16.53 15.88 15.19 18.07 13C23.73 7.34 21.61 2.39 21.61 2.39M14.54 9.46C13.76 8.68 13.76 7.41 14.54 6.63S16.59 5.85 17.37 6.63C18.14 7.41 18.15 8.68 17.37 9.46C16.59 10.24 15.32 10.24 14.54 9.46M8.88 16.53L7.47 15.12L8.88 16.53M6.24 22L9.88 18.36C9.54 18.27 9.21 18.12 8.91 17.91L4.83 22H6.24M2 22H3.41L8.18 17.24L6.76 15.83L2 20.59V22M2 19.17L6.09 15.09C5.88 14.79 5.73 14.47 5.64 14.12L2 17.76V19.17Z"
    />
  </svg>
);

export const scrollDown = (
  <svg width="34" height="36" viewBox="0 0 34 36" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M1.89648 19.2549L16.9995 34.3579L32.1025 19.2549"
      stroke="white"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M1.89648 1.16113L16.9995 16.2642L32.1025 1.16113"
      stroke="white"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const copyContent = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    height="24px"
    viewBox="0 0 24 24"
    width="24px"
    fill="currentColor"
  >
    <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z" />
  </svg>
);

export const eyeSvg = (
  <svg fill="currentColor" viewBox="0 0 16 16">
    <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z" />
    <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z" />
  </svg>
);
export const eyeBoldSvg = (
  <svg width="19" height="13" viewBox="0 0 19 13" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M18.9407 6.10515C18.7825 5.8679 15.461 0.173828 9.52965 0.173828C3.59832 0.173828 0.276817 5.8679 0.118636 6.10515C-0.0395453 6.34241 -0.0395453 6.65873 0.118636 6.89599C0.276817 7.13324 3.59836 12.8273 9.52968 12.8273C15.461 12.8273 18.7826 7.13324 18.9407 6.89599C19.0198 6.65873 19.0198 6.34241 18.9407 6.10515ZM9.52968 10.4548C7.3153 10.4548 5.57545 8.71494 5.57545 6.50059C5.57545 4.28624 7.3153 2.54636 9.52968 2.54636C11.7441 2.54636 13.4839 4.2862 13.4839 6.50059C13.4839 8.71497 11.744 10.4548 9.52968 10.4548Z"
      fill="#788187"
    />
    <path
      d="M9.53074 4.12793C8.18629 4.12793 7.1582 5.15601 7.1582 6.50046C7.1582 7.84491 8.18629 8.87299 9.53074 8.87299C10.8752 8.87299 11.9033 7.84491 11.9033 6.50046C11.9033 5.15601 10.8751 4.12793 9.53074 4.12793ZM10.3216 6.50046C9.84706 6.50046 9.53074 6.18414 9.53074 5.70963C9.53074 5.23512 9.84706 4.9188 10.3216 4.9188C10.7961 4.9188 11.1124 5.23512 11.1124 5.70963C11.1124 6.1841 10.7961 6.50046 10.3216 6.50046Z"
      fill="#788187"
    />
  </svg>
);

export const exchangeSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path d="M0 5a5.002 5.002 0 0 0 4.027 4.905 6.46 6.46 0 0 1 .544-2.073C3.695 7.536 3.132 6.864 3 5.91h-.5v-.426h.466V5.05c0-.046 0-.093.004-.135H2.5v-.427h.511C3.236 3.24 4.213 2.5 5.681 2.5c.316 0 .59.031.819.085v.733a3.46 3.46 0 0 0-.815-.082c-.919 0-1.538.466-1.734 1.252h1.917v.427h-1.98c-.003.046-.003.097-.003.147v.422h1.983v.427H3.93c.118.602.468 1.03 1.005 1.229a6.5 6.5 0 0 1 4.97-3.113A5.002 5.002 0 0 0 0 5zm16 5.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0zm-7.75 1.322c.069.835.746 1.485 1.964 1.562V14h.54v-.62c1.259-.086 1.996-.74 1.996-1.69 0-.865-.563-1.31-1.57-1.54l-.426-.1V8.374c.54.06.884.347.966.745h.948c-.07-.804-.779-1.433-1.914-1.502V7h-.54v.629c-1.076.103-1.808.732-1.808 1.622 0 .787.544 1.288 1.45 1.493l.358.085v1.78c-.554-.08-.92-.376-1.003-.787H8.25zm1.96-1.895c-.532-.12-.82-.364-.82-.732 0-.41.311-.719.824-.809v1.54h-.005zm.622 1.044c.645.145.943.38.943.796 0 .474-.37.8-1.02.86v-1.674l.077.018z" />
  </svg>
);

export const cashCoinSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M11 15a4 4 0 1 0 0-8 4 4 0 0 0 0 8zm5-4a5 5 0 1 1-10 0 5 5 0 0 1 10 0z"
    />
    <path d="M9.438 11.944c.047.596.518 1.06 1.363 1.116v.44h.375v-.443c.875-.061 1.386-.529 1.386-1.207 0-.618-.39-.936-1.09-1.1l-.296-.07v-1.2c.376.043.614.248.671.532h.658c-.047-.575-.54-1.024-1.329-1.073V8.5h-.375v.45c-.747.073-1.255.522-1.255 1.158 0 .562.378.92 1.007 1.066l.248.061v1.272c-.384-.058-.639-.27-.696-.563h-.668zm1.36-1.354c-.369-.085-.569-.26-.569-.522 0-.294.216-.514.572-.578v1.1h-.003zm.432.746c.449.104.655.272.655.569 0 .339-.257.571-.709.614v-1.195l.054.012z" />
    <path d="M1 0a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h4.083c.058-.344.145-.678.258-1H3a2 2 0 0 0-2-2V3a2 2 0 0 0 2-2h10a2 2 0 0 0 2 2v3.528c.38.34.717.728 1 1.154V1a1 1 0 0 0-1-1H1z" />
    <path d="M9.998 5.083 10 5a2 2 0 1 0-3.132 1.65 5.982 5.982 0 0 1 3.13-1.567z" />
  </svg>
);

export const powerDownSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M3.5 6a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 .5.5h9a.5.5 0 0 0 .5-.5v-8a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1 0-1h2A1.5 1.5 0 0 1 14 6.5v8a1.5 1.5 0 0 1-1.5 1.5h-9A1.5 1.5 0 0 1 2 14.5v-8A1.5 1.5 0 0 1 3.5 5h2a.5.5 0 0 1 0 1h-2z"
    />
    <path
      fillRule="evenodd"
      d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"
    />
  </svg>
);

export const powerUpSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M3.5 10a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 .5.5v8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 0 0 1h2A1.5 1.5 0 0 0 14 9.5v-8A1.5 1.5 0 0 0 12.5 0h-9A1.5 1.5 0 0 0 2 1.5v8A1.5 1.5 0 0 0 3.5 11h2a.5.5 0 0 0 0-1h-2z"
    />
    <path
      fillRule="evenodd"
      d="M7.646 4.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V14.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3z"
    />
  </svg>
);

export const starsSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path d="M7.657 6.247c.11-.33.576-.33.686 0l.645 1.937a2.89 2.89 0 0 0 1.829 1.828l1.936.645c.33.11.33.576 0 .686l-1.937.645a2.89 2.89 0 0 0-1.828 1.829l-.645 1.936a.361.361 0 0 1-.686 0l-.645-1.937a2.89 2.89 0 0 0-1.828-1.828l-1.937-.645a.361.361 0 0 1 0-.686l1.937-.645a2.89 2.89 0 0 0 1.828-1.828l.645-1.937zM3.794 1.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387A1.734 1.734 0 0 0 4.593 5.69l-.387 1.162a.217.217 0 0 1-.412 0L3.407 5.69A1.734 1.734 0 0 0 2.31 4.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387A1.734 1.734 0 0 0 3.407 2.31l.387-1.162zM10.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732L9.1 2.137a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L10.863.1z" />
  </svg>
);

export const moonSvg = (
  <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M16.5982 9.10563C16.4244 9.06459 16.2506 9.10563 16.0985 9.20822C15.5336 9.65964 14.8819 10.029 14.1649 10.2752C13.4914 10.5214 12.7528 10.6446 11.9707 10.6446C10.2109 10.6446 8.60323 9.96742 7.45179 8.87992C6.30035 7.79241 5.58341 6.27401 5.58341 4.61197C5.58341 3.91433 5.71376 3.2372 5.93102 2.62163C6.17 1.96503 6.5176 1.36998 6.97383 0.857004C7.16936 0.631295 7.12591 0.302991 6.88693 0.118321C6.73486 0.0157259 6.56105 -0.0253121 6.38725 0.0157259C4.5406 0.487662 2.93292 1.53413 1.78148 2.92942C0.673485 4.30419 0 6.00726 0 7.87449C0 10.1111 0.955915 12.1424 2.52014 13.6198C4.08436 15.0972 6.23517 16 8.60323 16C10.602 16 12.4486 15.3434 13.9259 14.2559C15.425 13.1479 16.5113 11.5679 16.9675 9.76223C17.0761 9.45445 16.9023 9.16718 16.5982 9.10563ZM13.2742 13.3941C12.0141 14.338 10.4064 14.9125 8.64668 14.9125C6.58278 14.9125 4.7144 14.1123 3.36743 12.8401C2.02046 11.5679 1.17317 9.80327 1.17317 7.85397C1.17317 6.23297 1.73803 4.75561 2.71567 3.56551C3.38915 2.74475 4.23644 2.06762 5.21408 1.59569C5.10545 1.82139 4.99683 2.0471 4.90993 2.29333C4.6275 3.03201 4.49715 3.81173 4.49715 4.63249C4.49715 6.58179 5.34443 8.36695 6.6914 9.63912C8.03837 10.9113 9.92848 11.7115 11.9924 11.7115C12.9049 11.7115 13.7739 11.5679 14.5777 11.2806C14.8601 11.178 15.1426 11.0754 15.4033 10.9523C14.8819 11.8962 14.1649 12.7375 13.2742 13.3941Z"
      fill="black"
    />
  </svg>
);

export const globeSvg = (
  <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M9.875 0.53125C14.8374 0.53125 18.875 4.56888 18.875 9.53125C18.875 14.4936 14.8374 18.5312 9.875 18.5312C4.91263 18.5312 0.875 14.4936 0.875 9.53125C0.875 4.56888 4.91263 0.53125 9.875 0.53125ZM3.503 4.92213C4.47275 5.30688 5.4695 5.61175 6.49212 5.812C6.92638 4.38212 7.616 3.013 8.56325 1.77437C6.48875 2.12538 4.691 3.28525 3.503 4.92213ZM7.328 11.9838C9.01775 11.752 10.7334 11.752 12.4231 11.9838C12.7696 10.3705 12.7708 8.701 12.4254 7.08663C11.5861 7.20138 10.7379 7.28125 9.875 7.28125C9.01213 7.28125 8.165 7.20138 7.32575 7.08663C6.98038 8.701 6.9815 10.3705 7.328 11.9838ZM7.61938 5.98637C9.11675 6.17987 10.6344 6.17987 12.1318 5.98637C11.6705 4.53963 10.9167 3.16825 9.875 1.95325C8.83325 3.16825 8.08062 4.53963 7.61938 5.98637ZM11.189 1.77437C12.1363 3.013 12.8247 4.38212 13.259 5.812C14.2805 5.61175 15.2773 5.30688 16.247 4.92213C15.0601 3.28525 13.2624 2.12538 11.189 1.77437ZM17.75 9.53125C17.75 8.2195 17.4226 6.98425 16.8534 5.89525C15.7779 6.33738 14.6743 6.685 13.5391 6.91337C13.9002 8.6425 13.9002 10.4279 13.538 12.1581C14.672 12.3842 15.7801 12.7296 16.8534 13.1706C17.4226 12.0794 17.75 10.8441 17.75 9.53125ZM16.247 14.1404C15.2773 13.7556 14.2805 13.4507 13.259 13.2505C12.8247 14.6804 12.1351 16.0495 11.1879 17.2881C13.2624 16.9371 15.0601 15.7773 16.247 14.1404ZM12.1306 13.0761C10.6344 12.8826 9.11675 12.8826 7.61938 13.0761C8.08062 14.5229 8.83438 15.8942 9.875 17.1092C10.9167 15.8942 11.6694 14.5229 12.1306 13.0761ZM8.56325 17.2881C7.616 16.0495 6.92638 14.6804 6.49212 13.2505C5.47062 13.4507 4.47275 13.7568 3.503 14.1404C4.691 15.7773 6.48875 16.9371 8.56325 17.2881ZM6.21313 12.1559C5.85087 10.4268 5.84975 8.64137 6.212 6.91225C5.07688 6.68388 3.97213 6.33738 2.89662 5.89412C2.32738 6.98425 2 8.2195 2 9.53125C2 10.8441 2.32738 12.0794 2.89662 13.1684C3.96988 12.7285 5.078 12.3831 6.21313 12.1559Z"
      fill="currentColor"
    />
  </svg>
);

export const walletSvg = (
  <svg width="20" height="15" viewBox="0 0 20 15" fill="none" xmlns="http://www.w3.org/2000/svg">
    <rect x="0.703125" y="1.3623" width="18.3451" height="12.3505" rx="1.5" stroke="currentColor" />
    <path
      d="M1.85352 4.93359L17.8971 4.93359"
      stroke="currentColor"
      strokeWidth="3"
      strokeLinecap="square"
      strokeLinejoin="round"
    />
  </svg>
);

export const notificationSvg = (
  <svg width="17" height="21" viewBox="0 0 17 21" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M16.4616 16.4474C16.4028 16.4092 15.9603 16.0993 15.5173 15.1616C14.7037 13.4396 14.5329 11.0139 14.5329 9.28223C14.5329 9.27469 14.5327 9.26723 14.5325 9.25973C14.5236 6.97109 13.1532 4.9982 11.1921 4.11301V2.75922C11.1921 1.5307 10.1943 0.53125 8.96777 0.53125H8.78343C7.55695 0.53125 6.55913 1.5307 6.55913 2.75922V4.11293C4.59148 5.00098 3.21831 6.98394 3.21831 9.28223C3.21831 11.0139 3.04753 13.4396 2.2339 15.1616C1.79089 16.0992 1.34843 16.4092 1.2896 16.4474C1.04187 16.562 0.919721 16.8269 0.976713 17.0953C1.03425 17.3663 1.28761 17.5532 1.56429 17.5532H5.8591C5.88308 19.1993 7.2266 20.5312 8.87562 20.5312C10.5246 20.5312 11.8682 19.1993 11.8921 17.5532H16.1869C16.4636 17.5532 16.717 17.3663 16.7745 17.0953C16.8314 16.8269 16.7093 16.562 16.4616 16.4474ZM7.73105 2.75922C7.73105 2.17793 8.20316 1.70504 8.78347 1.70504H8.96781C9.54812 1.70504 10.0202 2.17793 10.0202 2.75922V3.73254C9.65038 3.65609 9.26753 3.61586 8.87546 3.61586C8.48351 3.61586 8.10078 3.65605 7.73109 3.73242V2.75922H7.73105ZM8.87562 19.3575C7.87277 19.3575 7.05476 18.5521 7.03097 17.5532H10.7202C10.6965 18.5521 9.87847 19.3575 8.87562 19.3575ZM11.235 16.3794C11.2349 16.3794 2.89964 16.3794 2.89964 16.3794C3.00101 16.2214 3.10417 16.0425 3.20671 15.8404C3.99203 14.2918 4.39023 12.0854 4.39023 9.28223C4.39023 6.805 6.4023 4.78965 8.87542 4.78965C11.3485 4.78965 13.3606 6.805 13.3606 9.28418C13.3606 9.29141 13.3607 9.29859 13.361 9.30578C13.3632 12.0977 13.7614 14.2962 14.5445 15.8404C14.6471 16.0426 14.7503 16.2214 14.8516 16.3794H11.235Z"
      fill="currentColor"
    />
  </svg>
);

export const downArrowSvg = (
  <svg width="13" height="8" viewBox="0 0 13 8" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M11.623 1.40576L6.43483 6.59398L1.24661 1.40576"
      stroke="currentColor"
      strokeLinecap="square"
    />
  </svg>
);

export const upArrowSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" width="13" height="8" viewBox="0 0 13 8" fill="none">
    <path
      d="M11.623 6.59424L6.43483 1.40602L1.24661 6.59424"
      stroke="currentColor"
      strokeLinecap="square"
    />
  </svg>
);

export const sunSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
    <g clipPath="url(#clip0)">
      <path
        d="M9.99889 16.6946C9.62198 16.6946 9.31641 17.0002 9.31641 17.3771V19.3175C9.31641 19.6944 9.62198 20 9.99889 20C10.3759 20 10.6814 19.6944 10.6814 19.3175V17.3771C10.6814 17.0001 10.3758 16.6946 9.99889 16.6946Z"
        fill="#A6ACAF"
      />
      <path
        d="M9.99889 3.30582C10.3759 3.30582 10.6814 3.00025 10.6814 2.62334V0.682726C10.6814 0.305814 10.3759 0.000244141 9.99889 0.000244141C9.62198 0.000244141 9.31641 0.305814 9.31641 0.682726V2.62334C9.31641 3.00025 9.62198 3.30582 9.99889 3.30582Z"
        fill="#A6ACAF"
      />
      <path
        d="M4.30116 14.7337L2.92855 16.1055C2.66193 16.372 2.66184 16.8041 2.92828 17.0707C3.06159 17.204 3.23631 17.2707 3.41102 17.2707C3.58565 17.2707 3.76018 17.2041 3.89349 17.0709L5.2661 15.6991C5.53272 15.4326 5.53281 15.0005 5.26637 14.7339C4.99975 14.4673 4.56769 14.4673 4.30116 14.7337Z"
        fill="#A6ACAF"
      />
      <path
        d="M15.2156 5.46545C15.3903 5.46545 15.5649 5.39884 15.6982 5.26562L17.0706 3.89374C17.3372 3.62721 17.3372 3.19515 17.0708 2.92853C16.8043 2.66191 16.3722 2.66181 16.1056 2.92844L14.7332 4.30032C14.4666 4.56676 14.4665 4.99891 14.733 5.26544C14.8662 5.39884 15.0409 5.46545 15.2156 5.46545Z"
        fill="#A6ACAF"
      />
      <path
        d="M3.3054 10.0003C3.3054 9.62344 2.99983 9.31787 2.62292 9.31787H0.682482C0.30557 9.31787 0 9.62344 0 10.0003C0 10.3773 0.30557 10.6828 0.682482 10.6828H2.62292C2.99983 10.6828 3.3054 10.3773 3.3054 10.0003Z"
        fill="#A6ACAF"
      />
      <path
        d="M19.3172 9.31787H17.3758C16.9988 9.31787 16.6934 9.62344 16.6934 10.0003C16.6934 10.3773 16.9988 10.6828 17.3758 10.6828H19.3172C19.6942 10.6828 19.9997 10.3773 19.9997 10.0003C19.9997 9.62353 19.6942 9.31787 19.3172 9.31787Z"
        fill="#A6ACAF"
      />
      <path
        d="M4.30225 5.26551C4.43547 5.39873 4.61018 5.46534 4.78481 5.46534C4.95943 5.46534 5.13415 5.39873 5.26737 5.26551C5.5339 4.99898 5.5339 4.56683 5.26737 4.3003L3.89549 2.92842C3.62896 2.66188 3.19681 2.66188 2.93037 2.92842C2.66384 3.19495 2.66384 3.6271 2.93037 3.89354L4.30225 5.26551Z"
        fill="#A6ACAF"
      />
      <path
        d="M15.6984 14.7327C15.4319 14.4661 14.9997 14.466 14.7332 14.7326C14.4666 14.9991 14.4666 15.4312 14.7331 15.6977L16.1048 17.0696C16.2381 17.2029 16.4127 17.2695 16.5874 17.2695C16.7621 17.2695 16.9368 17.2029 17.07 17.0697C17.3366 16.8031 17.3366 16.371 17.0701 16.1045L15.6984 14.7327Z"
        fill="#A6ACAF"
      />
      <path
        d="M9.9993 5.00024C7.07036 5.00024 5 7.07201 5 10.0011C5 12.9302 7.07036 15.0002 9.9993 15.0002C12.9285 15.0002 15 12.9302 15 10.0011C15 7.07201 12.9284 5.00024 9.9993 5.00024ZM9.9993 13.9482C7.823 13.9482 6.05246 12.1775 6.05246 10.0011C6.05246 7.82465 7.823 6.05393 9.9993 6.05393C12.1759 6.05393 13.9466 7.82465 13.9466 10.0011C13.9466 12.1775 12.1759 13.9482 9.9993 13.9482Z"
        fill="#A6ACAF"
      />
    </g>
    <defs>
      <clipPath id="clip0">
        <rect width="20" height="20" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const quotes = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    version="1.1"
    id="Capa_1"
    x="0px"
    y="0px"
    width="95.333px"
    height="95.332px"
    viewBox="0 0 95.333 95.332"
  >
    <g>
      <g>
        <path d="M30.512,43.939c-2.348-0.676-4.696-1.019-6.98-1.019c-3.527,0-6.47,0.806-8.752,1.793    c2.2-8.054,7.485-21.951,18.013-23.516c0.975-0.145,1.774-0.85,2.04-1.799l2.301-8.23c0.194-0.696,0.079-1.441-0.318-2.045    s-1.035-1.007-1.75-1.105c-0.777-0.106-1.569-0.16-2.354-0.16c-12.637,0-25.152,13.19-30.433,32.076    c-3.1,11.08-4.009,27.738,3.627,38.223c4.273,5.867,10.507,9,18.529,9.313c0.033,0.001,0.065,0.002,0.098,0.002    c9.898,0,18.675-6.666,21.345-16.209c1.595-5.705,0.874-11.688-2.032-16.851C40.971,49.307,36.236,45.586,30.512,43.939z" />
        <path d="M92.471,54.413c-2.875-5.106-7.61-8.827-13.334-10.474c-2.348-0.676-4.696-1.019-6.979-1.019    c-3.527,0-6.471,0.806-8.753,1.793c2.2-8.054,7.485-21.951,18.014-23.516c0.975-0.145,1.773-0.85,2.04-1.799l2.301-8.23    c0.194-0.696,0.079-1.441-0.318-2.045c-0.396-0.604-1.034-1.007-1.75-1.105c-0.776-0.106-1.568-0.16-2.354-0.16    c-12.637,0-25.152,13.19-30.434,32.076c-3.099,11.08-4.008,27.738,3.629,38.225c4.272,5.866,10.507,9,18.528,9.312    c0.033,0.001,0.065,0.002,0.099,0.002c9.897,0,18.675-6.666,21.345-16.209C96.098,65.559,95.376,59.575,92.471,54.413z" />
      </g>
    </g>
  </svg>
);

export const viewStackedSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    className="bi bi-view-stacked"
    viewBox="0 0 16 16"
  >
    <path d="M3 0h10a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2zm0 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H3zm0 8h10a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2zm0 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1H3z" />
  </svg>
);

export const gridView = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    className="bi bi-grid"
    viewBox="0 0 16 16"
  >
    <path d="M1 2.5A1.5 1.5 0 0 1 2.5 1h3A1.5 1.5 0 0 1 7 2.5v3A1.5 1.5 0 0 1 5.5 7h-3A1.5 1.5 0 0 1 1 5.5v-3zM2.5 2a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 1h3A1.5 1.5 0 0 1 15 2.5v3A1.5 1.5 0 0 1 13.5 7h-3A1.5 1.5 0 0 1 9 5.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zM1 10.5A1.5 1.5 0 0 1 2.5 9h3A1.5 1.5 0 0 1 7 10.5v3A1.5 1.5 0 0 1 5.5 15h-3A1.5 1.5 0 0 1 1 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 9h3a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3z" />
  </svg>
);

export const listView = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    className="bi bi-list"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M2.5 12a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5zm0-4a.5.5 0 0 1 .5-.5h10a.5.5 0 0 1 0 1H3a.5.5 0 0 1-.5-.5z"
    />
  </svg>
);

export const burger = (
  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="19" viewBox="0 0 22 19" fill="none">
    <rect width="22" height="5" fill="white" />
    <rect y="7" width="22" height="5" fill="white" />
    <rect y="14" width="22" height="5" fill="white" />
  </svg>
);

export const grid = (
  <svg xmlns="http://www.w3.org/2000/svg" width="14" height="18" viewBox="0 0 14 18" fill="none">
    <rect width="6" height="8" fill="white" />
    <rect x="8" width="6" height="8" fill="white" />
    <rect y="10" width="6" height="8" fill="white" />
    <rect x="8" y="10" width="6" height="8" fill="white" />
  </svg>
);

export const magnify = (
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
    <path
      d="M8.72857 0C11.0114 0 13.2943 0.939999 14.9057 2.55143C16.5171 4.16286 17.4571 6.44571 17.4571 8.72857C17.4571 10.8771 16.6514 12.8914 15.3086 14.3686L15.7114 14.7714H16.7857L23.5 21.4857L21.4857 23.5L14.7714 16.7857V15.7114L14.3686 15.3086C12.8914 16.6514 10.8771 17.4571 8.72857 17.4571C6.44571 17.4571 4.16286 16.5171 2.55143 14.9057C0.939999 13.2943 0 11.0114 0 8.72857C0 6.44571 0.939999 4.16286 2.55143 2.55143C4.16286 0.939999 6.44571 0 8.72857 0ZM8.72857 2.68571C5.37143 2.68571 2.68571 5.37143 2.68571 8.72857C2.68571 12.0857 5.37143 14.7714 8.72857 14.7714C12.0857 14.7714 14.7714 12.0857 14.7714 8.72857C14.7714 5.37143 12.0857 2.68571 8.72857 2.68571Z"
      fill="white"
    />
  </svg>
);

export const hot = (
  <svg xmlns="http://www.w3.org/2000/svg" width="19" height="24" viewBox="0 0 19 24" fill="none">
    <path
      id="hot"
      d="M17.0849 13.3817C16.2279 11.9862 15.7907 10.9391 15.6741 9.19675C15.5869 7.89467 16.0751 6.39106 16.0751 6.39106C15.47 6.8429 15.4633 6.7945 15.0638 7.16458C12.9847 9.09115 12.4414 11.0192 12.3779 11.2685C12.3735 11.2862 12.371 11.2964 12.371 11.2964L12.3779 11.2685C12.3779 11.2685 14.0029 4.14113 9.47925 0.822163C9.10384 0.546802 8.23792 0 8.23792 0C8.23792 0 10.4839 6.17314 6.46262 9.83531C5.67113 6.21362 1.49259 6.16906 1.49259 6.16906C1.49259 6.16906 1.81369 7.4309 1.86529 7.72938C2.54247 11.6653 0.466897 12.9108 0.0453175 16.6316C0.0934123 16.2045 0.0742884 16.3745 0.0450319 16.6339L0.0447465 16.6367L0.0448893 16.6354L0.0446039 16.6385C-0.284425 19.5594 1.25221 22.3913 3.16002 23.9177C3.16002 23.4257 2.77696 21.3274 3.15832 20.3253C3.73126 19.1703 4.00835 18.7673 3.88406 17.4547C3.69781 15.9504 3.22141 14.843 3.22141 14.843C3.70794 14.843 4.97646 15.8844 5.25269 16.1403C6.42116 17.223 6.88834 18.3065 7.04611 18.7673C7.05139 18.7637 7.05682 18.7602 7.06252 18.7567C6.86322 17.7481 6.30143 13.8179 9.11597 11.7528C9.3755 11.5627 9.97462 11.1844 9.97462 11.1844C9.97462 11.1844 8.38078 15.0916 11.8897 18.2653C11.8114 16.9664 12.2533 15.7671 13.0804 14.843C13.5298 14.3414 14.3395 14.1004 14.3395 14.1004C14.3395 14.1004 14.1171 14.9738 14.0816 15.18C13.6131 17.9035 15.6524 20.0212 15.2167 22.6009C15.135 23.0844 15.018 23.5537 14.8548 24H15.0496C16.084 23.3807 17.044 22.5754 17.7014 21.4703C19.1973 18.9561 18.525 15.7267 17.0849 13.3817Z"
    />
  </svg>
);

export const person = (
  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
    <path
      d="M9 11.25C5.99625 11.25 0 12.7463 0 15.75V18H18V15.75C18 12.7463 12.0037 11.25 9 11.25ZM9 9C10.1935 9 11.3381 8.52589 12.182 7.68198C13.0259 6.83807 13.5 5.69347 13.5 4.5C13.5 3.30653 13.0259 2.16193 12.182 1.31802C11.3381 0.474106 10.1935 0 9 0C7.80653 0 6.66193 0.474106 5.81802 1.31802C4.97411 2.16193 4.5 3.30653 4.5 4.5C4.5 5.69347 4.97411 6.83807 5.81802 7.68198C6.66193 8.52589 7.80653 9 9 9Z"
      fill="white"
    />
  </svg>
);

export const communities = (
  <svg xmlns="http://www.w3.org/2000/svg" width="27" height="17" viewBox="0 0 27 17" fill="none">
    <path
      d="M13.9597 0.595703C14.9686 0.595703 15.9361 0.996465 16.6495 1.70982C17.3628 2.42318 17.7636 3.39071 17.7636 4.39955C17.7636 5.40839 17.3628 6.37591 16.6495 7.08927C15.9361 7.80263 14.9686 8.20339 13.9597 8.20339C12.9509 8.20339 11.9834 7.80263 11.27 7.08927C10.5566 6.37591 10.1559 5.40839 10.1559 4.39955C10.1559 3.39071 10.5566 2.42318 11.27 1.70982C11.9834 0.996465 12.9509 0.595703 13.9597 0.595703ZM6.35203 3.31274C6.96065 3.31274 7.52579 3.47576 8.01486 3.7692C7.85184 5.32334 8.3083 6.86661 9.24296 8.07298C8.69955 9.11632 7.61274 9.83361 6.35203 9.83361C5.48731 9.83361 4.65801 9.49011 4.04656 8.87865C3.4351 8.2672 3.09159 7.4379 3.09159 6.57317C3.09159 5.70845 3.4351 4.87915 4.04656 4.2677C4.65801 3.65624 5.48731 3.31274 6.35203 3.31274ZM21.5674 3.31274C22.4321 3.31274 23.2614 3.65624 23.8729 4.2677C24.4843 4.87915 24.8279 5.70845 24.8279 6.57317C24.8279 7.4379 24.4843 8.2672 23.8729 8.87865C23.2614 9.49011 22.4321 9.83361 21.5674 9.83361C20.3067 9.83361 19.2199 9.11632 18.6765 8.07298C19.6112 6.86661 20.0676 5.32334 19.9046 3.7692C20.3937 3.47576 20.9588 3.31274 21.5674 3.31274ZM6.89544 14.4526C6.89544 12.2029 10.0581 10.377 13.9597 10.377C17.8614 10.377 21.024 12.2029 21.024 14.4526V16.3545H6.89544V14.4526ZM0.917969 16.3545V14.7243C0.917969 13.2136 2.97205 11.942 5.75429 11.5725C5.11307 12.3115 4.72181 13.3332 4.72181 14.4526V16.3545H0.917969ZM27.0015 16.3545H23.1976V14.4526C23.1976 13.3332 22.8064 12.3115 22.1652 11.5725C24.9474 11.942 27.0015 13.2136 27.0015 14.7243V16.3545Z"
      fill="white"
    />
  </svg>
);

export const tags = (
  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="23" viewBox="0 0 18 23" fill="none">
    <path
      d="M3.24654 23L7.1466 0.643779H9.92577L6.02571 23H3.24654ZM9.0045 23L12.9199 0.643779H15.6991L11.7837 23H9.0045ZM17.9869 9.62619H2.00282V7.03127H17.9869V9.62619ZM16.82 16.7046H0.851231V14.1251H16.82V16.7046Z"
      fill="white"
    />
  </svg>
);

export const notifications = (
  <svg xmlns="http://www.w3.org/2000/svg" width="17" height="21" viewBox="0 0 17 21" fill="none">
    <path
      d="M5.26953 19.1792C5.74341 20.2506 6.81586 21.0004 8.06069 21.0004C9.30553 21.0004 10.3779 20.2506 10.8519 19.1792H5.26953Z"
      fill="white"
    />
    <path
      d="M8.05664 2.74169C8.8781 2.74169 9.66686 2.88663 10.3988 3.15199V3.06183C10.3988 1.82181 9.39001 0.812988 8.15004 0.812988H7.96367C6.72366 0.812988 5.71484 1.82181 5.71484 3.06183V3.15084C6.44642 2.88628 7.23494 2.74169 8.05664 2.74169Z"
      fill="white"
    />
    <path
      d="M15.4505 17.9942H0.666616C0.386923 17.9942 0.130729 17.8055 0.0725551 17.5319C0.0149736 17.261 0.13843 16.9937 0.388898 16.878C0.448336 16.8394 0.895718 16.5266 1.34361 15.5801C2.16622 13.842 2.33889 11.3936 2.33889 9.64572C2.33889 6.49196 4.90466 3.92627 8.05838 3.92627C11.2046 3.92627 13.7657 6.4796 13.7778 9.62301C13.7781 9.63055 13.7783 9.63813 13.7783 9.64572C13.7783 11.3936 13.9509 13.842 14.7735 15.5801C15.2214 16.5266 15.6688 16.8395 15.7282 16.878C15.9787 16.9937 16.1022 17.261 16.0446 17.5319C15.9864 17.8055 15.7303 17.9942 15.4505 17.9942ZM15.7349 16.8821H15.7353H15.7349Z"
      fill="white"
    />
  </svg>
);

export const wallet = (
  <svg xmlns="http://www.w3.org/2000/svg" width="23" height="16" viewBox="0 0 23 16" fill="none">
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M0.00177193 2.40606V2.56612C0.00177193 2.68475 0.097971 2.78095 0.216599 2.78095H21.7852C21.9038 2.78095 22 2.68475 22 2.56612V2.40606C22 1.07723 20.9228 0 19.5939 0H2.40783C1.079 0 0.00177193 1.07723 0.00177193 2.40606ZM22 12.7177V6.37059C22 6.25196 21.7852 6.15576 21.7852 6.15576H0.216599C0.097971 6.15576 0.00177193 6.25196 0.00177193 6.37059V12.7177C0.00177193 14.0465 1.079 15.1237 2.40783 15.1237H19.5939C20.9228 15.1237 22 14.0465 22 12.7177ZM17.1879 11.6865C16.8082 11.6865 16.5004 11.3787 16.5004 10.999V10.3116C16.5004 9.93196 16.8082 9.62415 17.1879 9.62415H17.8753C18.255 9.62415 18.5628 9.93196 18.5628 10.3116V10.999C18.5628 11.3787 18.255 11.6865 17.8753 11.6865H17.1879Z"
      fill="white"
    />
    <rect x="16" y="9" width="5" height="4" fill="white" />
  </svg>
);

export const upvote = (
  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
    <circle cx="9" cy="9" r="8.5" stroke="#357CE6" />
    <path
      d="M8.6447 7.55778L5.94039 10.289L5.70288 10.0486L9 6.71141L12.2971 10.0486L12.0596 10.289L9.3553 7.55778L9 7.19895L8.6447 7.55778Z"
      stroke="#357CE6"
    />
  </svg>
);

export const gifIcon = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="18"
    height="18"
    fill="currentColor"
    viewBox="0 0 16 16"
    strokeWidth="2"
  >
    <path
      fillRule="evenodd"
      d="M14 4.5V14a2 2 0 0 1-2 2H9v-1h3a1 1 0 0 0 1-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5L14 4.5ZM3.278 13.124a1.403 1.403 0 0 0-.14-.492 1.317 1.317 0 0 0-.314-.407 1.447 1.447 0 0 0-.48-.275 1.88 1.88 0 0 0-.636-.1c-.361 0-.67.076-.926.229a1.48 1.48 0 0 0-.583.632 2.136 2.136 0 0 0-.199.95v.506c0 .272.035.52.105.745.07.224.177.417.32.58.142.162.32.288.533.377.215.088.466.132.753.132.268 0 .5-.037.697-.111a1.29 1.29 0 0 0 .788-.77c.065-.174.097-.358.097-.551v-.797H1.717v.589h.823v.255c0 .132-.03.254-.09.363a.67.67 0 0 1-.273.264.967.967 0 0 1-.457.096.87.87 0 0 1-.519-.146.881.881 0 0 1-.305-.413 1.785 1.785 0 0 1-.096-.615v-.499c0-.365.078-.648.234-.85.158-.2.38-.301.665-.301a.96.96 0 0 1 .3.044c.09.03.17.071.236.126a.689.689 0 0 1 .17.19.797.797 0 0 1 .097.25h.776Zm1.353 2.801v-3.999H3.84v4h.79Zm1.493-1.59v1.59h-.791v-3.999H7.88v.653H6.124v1.117h1.605v.638H6.124Z"
    />
  </svg>
);

export const settingsSvg = (
  <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M0.676401 9.20887L1.72499 9.2154C1.88179 10.0223 2.19212 10.8062 2.66251 11.5184L1.91772 12.2566C1.64986 12.5212 1.64986 12.9492 1.91119 13.217L2.71478 14.0304C2.97937 14.2983 3.4073 14.2983 3.67517 14.0369L4.41996 13.2987C5.12555 13.7756 5.90627 14.099 6.71313 14.2623L6.7066 15.3109C6.70333 15.6866 7.00713 15.9904 7.38279 15.9937L8.52611 16.0002C8.90177 16.0035 9.20557 15.6997 9.20884 15.324L9.21537 14.2754C10.0222 14.1186 10.8062 13.8083 11.5183 13.3379L12.2566 14.0827C12.5212 14.3505 12.9491 14.3505 13.217 14.0892L14.0304 13.2856C14.2982 13.021 14.2982 12.5931 14.0369 12.3252L13.2987 11.5804C13.7756 10.8748 14.099 10.0941 14.2623 9.28726L15.3109 9.2938C15.6866 9.29707 15.9904 8.99327 15.9936 8.61761L16.0002 7.47429C16.0034 7.09862 15.6996 6.79483 15.324 6.79156L14.2754 6.78503C14.1186 5.97817 13.8082 5.19418 13.3379 4.48205L14.0826 3.7438C14.3505 3.4792 14.3505 3.05127 14.0892 2.78341L13.2856 1.97002C13.021 1.70215 12.5931 1.70215 12.3252 1.96348L11.5804 2.70174C10.8748 2.22481 10.0941 1.90142 9.28723 1.73809L9.29377 0.689498C9.29703 0.313836 8.99324 0.0100396 8.61758 0.00677298L7.47426 0.000239722C7.09859 -0.00302691 6.7948 0.30077 6.79153 0.676432L6.78173 1.72502C5.97161 1.88182 5.18762 2.19215 4.47876 2.66254L3.7405 1.91775C3.4759 1.64989 3.04797 1.64989 2.78011 1.91122L1.96999 2.71481C1.70212 2.97941 1.70212 3.40733 1.96345 3.6752L2.70171 4.41999C2.22478 5.12558 1.90139 5.9063 1.73806 6.71316L0.689468 6.70663C0.313806 6.70336 0.0100091 7.00716 0.00674246 7.38282L0.000209205 8.52614C-0.00305742 8.89854 0.300739 9.2056 0.676401 9.20887ZM5.85727 5.83444C7.05286 4.65192 8.97691 4.66172 10.1594 5.85731C11.3419 7.05289 11.3321 8.97694 10.1366 10.1595C8.94097 11.342 7.01693 11.3322 5.83441 10.1366C4.65189 8.941 4.66169 7.01696 5.85727 5.83444Z"
      fill="currentColor"
    />
  </svg>
);

export const externalLink = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M8.636 3.5a.5.5 0 0 0-.5-.5H1.5A1.5 1.5 0 0 0 0 4.5v10A1.5 1.5 0 0 0 1.5 16h10a1.5 1.5 0 0 0 1.5-1.5V7.864a.5.5 0 0 0-1 0V14.5a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5v-10a.5.5 0 0 1 .5-.5h6.636a.5.5 0 0 0 .5-.5z"
    />
    <path
      fillRule="evenodd"
      d="M16 .5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h3.793L6.146 9.146a.5.5 0 1 0 .708.708L15 1.707V5.5a.5.5 0 0 0 1 0v-5z"
    />
  </svg>
);

export const sortSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="20"
    height="20"
    color="#357ce6"
    fill="currentColor"
    className="bi bi-sort-down-alt"
    viewBox="0 0 16 16"
  >
    <path d="M3.5 3.5a.5.5 0 0 0-1 0v8.793l-1.146-1.147a.5.5 0 0 0-.708.708l2 1.999.007.007a.497.497 0 0 0 .7-.006l2-2a.5.5 0 0 0-.707-.708L3.5 12.293V3.5zm4 .5a.5.5 0 0 1 0-1h1a.5.5 0 0 1 0 1h-1zm0 3a.5.5 0 0 1 0-1h3a.5.5 0 0 1 0 1h-3zm0 3a.5.5 0 0 1 0-1h5a.5.5 0 0 1 0 1h-5zM7 12.5a.5.5 0 0 0 .5.5h7a.5.5 0 0 0 0-1h-7a.5.5 0 0 0-.5.5z" />
  </svg>
);

export const swapSvg = (
  <svg
    width="18"
    height="28"
    viewBox="0 0 18 19"
    fill="currentColor"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      className="swap-arrow-down"
      d="M12.4994 1.49942L12.4994 14.4994L11.2994 12.8994C11.2206 12.7944 11.1219 12.7059 11.0089 12.6389C10.8959 12.572 10.7708 12.528 10.6408 12.5095C10.5108 12.4909 10.3784 12.4981 10.2512 12.5307C10.124 12.5633 10.0045 12.6206 9.89941 12.6994C9.77522 12.7926 9.67441 12.9134 9.60499 13.0522C9.53556 13.1911 9.49941 13.3442 9.49941 13.4994C9.49941 13.7158 9.56959 13.9263 9.69941 14.0994L12.6994 18.0994C12.7927 18.2217 12.913 18.3209 13.0509 18.3891C13.1888 18.4573 13.3406 18.4928 13.4944 18.4928C13.6483 18.4928 13.8 18.4573 13.9379 18.3891C14.0758 18.3209 14.1961 18.2217 14.2894 18.0994L17.2894 14.2394C17.4525 14.0299 17.5257 13.7642 17.4929 13.5007C17.4601 13.2372 17.3239 12.9975 17.1144 12.8344C16.9049 12.6713 16.6392 12.5981 16.3757 12.6309C16.1122 12.6638 15.8725 12.7999 15.7094 13.0094L14.4994 14.5794L14.4994 1.49942C14.4994 1.2342 14.3941 0.97985 14.2065 0.792313C14.019 0.604777 13.7646 0.49942 13.4994 0.49942C13.2342 0.49942 12.9798 0.604777 12.7923 0.792313C12.6048 0.979849 12.4994 1.2342 12.4994 1.49942V1.49942Z"
    />
    <path
      className="swap-arrow-up"
      d="M5.49942 17.4994L5.49942 4.49943L6.69942 6.09943C6.85855 6.31161 7.09544 6.45187 7.35799 6.48938C7.62055 6.52689 7.88724 6.45856 8.09942 6.29943C8.31159 6.1403 8.45186 5.90341 8.48937 5.64085C8.52687 5.3783 8.45855 5.11161 8.29942 4.89943L5.29942 0.899433C5.20609 0.777126 5.08581 0.678001 4.94792 0.60977C4.81003 0.541539 4.65826 0.506042 4.50442 0.506042C4.35057 0.506042 4.1988 0.541539 4.06091 0.60977C3.92303 0.678001 3.80274 0.777126 3.70942 0.899433L0.709415 4.75943C0.573948 4.93398 0.500104 5.14848 0.499416 5.36943C0.499783 5.52215 0.535124 5.67276 0.602728 5.8097C0.670331 5.94664 0.768401 6.06627 0.889415 6.15943C1.09789 6.32182 1.36216 6.3951 1.62449 6.36325C1.88681 6.33139 2.12587 6.197 2.28942 5.98943L3.49942 4.41943L3.49942 17.4994C3.49942 17.7646 3.60477 18.019 3.79231 18.2065C3.97984 18.3941 4.2342 18.4994 4.49942 18.4994C4.76463 18.4994 5.01899 18.3941 5.20652 18.2065C5.39406 18.019 5.49942 17.7646 5.49942 17.4994Z"
    />
  </svg>
);

export const hsLogoSvg = (
  <svg width="16" height="18" viewBox="0 0 65 75" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M57.4774 40.1845V26.6067H0.144043V0.685791H64.144V13.6462H57.4774V7.16602H6.81071V20.1265H64.144V41.2196C64.0363 51.5228 58.1035 59.9743 48.2911 66.6987C44.8255 69.0737 41.1078 71.0633 37.3811 72.6845C36.0675 73.256 34.8427 73.7417 33.7381 74.1431C33.0572 74.3906 32.513 74.5727 32.2704 74.6463L32.1405 74.6858L32.0108 74.6458C31.739 74.5621 31.2245 74.3898 30.5455 74.1429C29.4408 73.7412 28.2165 73.2556 26.9034 72.6842C23.1772 71.0627 19.4603 69.0733 15.9952 66.6984C6.27684 60.0376 0.365082 51.6825 0.150114 41.5112H0.144043V33.0869H6.81071V40.1845C6.81071 47.9967 11.0121 54.5315 18.2191 59.8741C20.8805 61.847 23.8111 63.5472 26.8494 64.9836C28.8637 65.9358 30.6774 66.6589 32.1449 67.1623C33.6109 66.6596 35.4255 65.9362 37.4399 64.9839C40.478 63.5476 43.4086 61.8474 46.0699 59.8744C53.2768 54.5317 57.4774 47.9967 57.4774 40.1845Z"
      fill="currentColor"
    />
  </svg>
);

export const kcLogoSvg = (
  <svg width="20px" height="16px" viewBox="0 0 134 113" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M122.449483,22.7760145 C121.693871,22.1068511 120.904861,21.4763773 120.085483,20.8870145 C117.517666,19.0103484 114.680515,17.5332763 111.670483,16.5060145 L111.570483,16.4720145 C99.311084,12.3100522 85.7516656,15.937873 77.2084444,25.6655739 C68.6652232,35.3932748 66.8184889,49.3076014 72.5284829,60.9270145 L70.6784829,63.0270145 L44.8304829,92.3880145 C41.7391475,95.892757 40.917375,100.85367 42.7134829,105.168014 C43.4268157,106.885087 44.5262664,108.414668 45.9264829,109.638014 C48.3630738,111.77965 51.5509197,112.865119 54.7881419,112.655431 C58.0253641,112.445743 61.0465385,110.95809 63.1864829,108.520014 C63.2474829,108.453014 63.3154829,108.380014 63.3704829,108.308014 L63.3704829,108.308014 C66.4213795,110.816733 70.902251,110.498172 73.567549,107.583069 C76.232847,104.667966 76.1497661,100.176553 73.3784829,97.3620145 L73.1604829,97.2000145 C73.0994829,97.1550145 73.0434829,97.1000145 72.9924829,97.0600145 C72.9414829,97.0200145 72.7524829,96.8310145 72.6404829,96.7140145 C70.9687315,94.9184683 71.0053217,92.1254865 72.7235376,90.3743516 C74.4417534,88.6232167 77.2335379,88.5336352 79.0604829,90.1710145 L79.2164829,90.3160145 L79.2504829,90.2820145 C82.3429909,92.8117542 86.8827586,92.4412057 89.5240972,89.4434533 C92.1654358,86.4457009 91.9614548,81.8954055 89.0624829,79.1460145 L90.8954829,77.0620145 C105.3553,82.0397097 121.316518,76.0948714 128.997028,62.8708961 C136.677539,49.6469209 133.932176,32.8372644 122.443483,22.7440145 L122.449483,22.7760145 Z M115.470483,48.8710145 C114.524897,49.9582097 113.388558,50.8634171 112.117483,51.5420145 C106.638447,54.4882281 99.8167039,52.7666501 96.3917987,47.5733815 C92.9668934,42.3801129 94.0708272,35.4316357 98.9366197,31.5555452 C103.802412,27.6794546 110.821819,28.1568782 115.117965,32.6561162 C119.414111,37.1553543 119.567032,44.1893161 115.470483,48.8710145 L115.470483,48.8710145 Z"
      id="Shape"
      fill="#FFFFFF"
    />
    <path
      d="M48.3614829,62.9900145 C52.176747,61.7311185 54.2954154,57.6627254 53.1394829,53.8150145 L55.7654829,52.9380145 C59.2966355,57.0172981 63.799461,60.1402477 68.8574829,62.0180145 C58.727091,51.1660652 57.3834477,34.7744026 65.6113916,22.4175996 C73.8393355,10.0607965 89.4812432,4.97919217 103.400483,10.1410145 C94.7071654,0.853230051 81.3405046,-2.40795448 69.3465631,1.83257318 C57.3526215,6.07310083 49.0061596,17.0110859 48.0824829,29.6990145 L45.4284829,30.5760145 L8.26948294,42.9200145 C1.92385374,45.0931317 -1.48677555,51.9723797 0.625160453,58.3386325 C2.73709646,64.7048853 9.58319639,68.1815736 15.9694829,66.1310145 L16.2374829,66.0420145 L16.2374829,66.0420145 C17.6114392,69.7413028 21.6387547,71.7199079 25.4065332,70.5467345 C29.1743116,69.3735611 31.366483,65.4583941 30.3974829,61.6330145 C30.3584829,61.5550145 30.3244829,61.4650145 30.2914829,61.3820145 C30.2608371,61.3178242 30.2363928,61.2508534 30.2184829,61.1820145 C30.1624829,61.0200145 30.1234829,60.8580145 30.0844829,60.7010145 C29.5957328,58.3266267 31.036424,55.9811998 33.3752597,55.3436721 C35.7140954,54.7061443 38.1457161,55.9960433 38.9294829,58.2900145 C38.9420374,58.3610724 38.9624979,58.4305037 38.9904829,58.4970145 L39.0354829,58.4970145 C40.4160353,62.2716765 44.5491662,64.2629007 48.3614829,62.9900145 Z"
      id="Path"
      fill="#E31337"
    />
  </svg>
);

export const priceDownSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 24 24"
    strokeWidth={1.5}
    stroke="currentColor"
    className="w-6 h-6"
    width="20"
    height="20"
  >
    <path
      strokeLinecap="round"
      strokeLinejoin="round"
      d="M2.25 6L9 12.75l4.286-4.286a11.948 11.948 0 014.306 6.43l.776 2.898m0 0l3.182-5.511m-3.182 5.51l-5.511-3.181"
    />
  </svg>
);

export const priceUpSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    fill="none"
    viewBox="0 0 24 24"
    strokeWidth={1.5}
    stroke="currentColor"
    className="w-6 h-6"
    width="20"
    height="20"
  >
    <path
      strokeLinecap="round"
      strokeLinejoin="round"
      d="M2.25 18L9 11.25l4.306 4.307a11.95 11.95 0 015.814-5.519l2.74-1.22m0 0l-5.94-2.28m5.94 2.28l-2.28 5.941"
    />
  </svg>
);

export const rawContentSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="23"
    height="23"
    viewBox="0 0 24 24"
    fill="none"
    stroke="#788187"
    strokeWidth="2"
    strokeLinecap="round"
    strokeLinejoin="round"
  >
    <polyline points="16 18 22 12 16 6" />
    <polyline points="8 6 2 12 8 18" />
  </svg>
);
export const allStakeSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
    <path d="M4 4h7v7H4V4z" fill="#F6465D" />
    <path d="M4 13h7v7H4v-7z" fill="#0ECB81" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13 4h7v4h-7V4zm0 6h7v4h-7v-4zm7 6h-7v4h7v-4z"
      fill="currentColor"
    />
  </svg>
);

export const buyStakeSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
    <path d="M4 4h7v16H4V4z" fill="#0ECB81" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13 4h7v4h-7V4zm0 6h7v4h-7v-4zm7 6h-7v4h7v-4z"
      fill="currentColor"
    />
  </svg>
);

export const sellStakeSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
    <path d="M4 4h7v16H4V4z" fill="#F6465D" />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M13 4h7v4h-7V4zm0 6h7v4h-7v-4zm7 6h-7v4h7v-4z"
      fill="currentColor"
    />
  </svg>
);

export const kebabMenuSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <circle cx="12" cy="12" r="1" />
    <circle cx="12" cy="5" r="1" />
    <circle cx="12" cy="19" r="1" />
  </svg>
);

export const revokeSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    stroke="#357ce6"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <circle cx="12" cy="12" r="10" />
    <line x1="15" y1="9" x2="9" y2="15" />
    <line x1="9" y1="9" x2="15" y2="15" />
  </svg>
);

export const helpIconSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="1"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <circle cx="12" cy="12" r="10" />
    <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3" />
    <line x1="12" y1="17" x2="12.01" y2="17" />
  </svg>
);

export const copyOutlinSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="30"
    height="30"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <rect x="9" y="9" width="13" height="13" rx="2" ry="2" />
    <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" />
  </svg>
);

export const kebabMenuHorizontalSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="30"
    height="30"
    viewBox="0 0 24 24"
    fill="none"
    stroke="#357ce6"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <circle cx="12" cy="12" r="1" />
    <circle cx="19" cy="12" r="1" />
    <circle cx="5" cy="12" r="1" />
  </svg>
);

export const keyOutlineSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 24 24"
    stroke="#357ce6"
    width="30"
    height="30"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
    fill="none"
  >
    <path d="M7,14A2,2 0 0,1 5,12A2,2 0 0,1 7,10A2,2 0 0,1 9,12A2,2 0 0,1 7,14M12.65,10C11.83,7.67 9.61,6 7,6A6,6 0 0,0 1,12A6,6 0 0,0 7,18C9.61,18 11.83,16.33 12.65,14H17V18H21V14H23V10H12.65Z" />
    <circle cx="12" cy="12" r="1" />
    <circle cx="19" cy="12" r="1" />
    <circle cx="5" cy="12" r="1" />
  </svg>
);

export const linkedinSvg = (
  <svg viewBox="0 0 15 15">
    <path
      d="M 0 0 L 0 15 L 15 15 L 15 0 Z M 4.664062 12.460938 L 2.441406 12.460938 L 2.441406 5.765625 L 4.664062 5.765625 Z M 3.554688 4.851562 L 3.539062 4.851562 C 2.792969 4.851562 2.308594 4.339844 2.308594 3.695312 C 2.308594 3.039062 2.804688 2.539062 3.566406 2.539062 C 4.328125 2.539062 4.796875 3.039062 4.8125 3.695312 C 4.8125 4.339844 4.328125 4.851562 3.554688 4.851562 Z M 12.691406 12.460938 L 10.464844 12.460938 L 10.464844 8.878906 C 10.464844 7.980469 10.144531 7.367188 9.339844 7.367188 C 8.722656 7.367188 8.359375 7.777344 8.195312 8.179688 C 8.136719 8.324219 8.125 8.523438 8.125 8.722656 L 8.125 12.460938 L 5.898438 12.460938 C 5.898438 12.460938 5.925781 6.394531 5.898438 5.765625 L 8.125 5.765625 L 8.125 6.714844 C 8.417969 6.257812 8.945312 5.609375 10.128906 5.609375 C 11.59375 5.609375 12.691406 6.566406 12.691406 8.621094 Z M 12.691406 12.460938 "
      fill="currentColor"
    />
  </svg>
);

export const downloadSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    fill="currentColor"
    className="bi bi-download"
    viewBox="0 0 16 16"
  >
    <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z" />
    <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z" />
  </svg>
);

export const regenerateSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M21.5 2v6h-6M2.5 22v-6h6M2 11.5a10 10 0 0 1 18.8-4.3M22 12.5a10 10 0 0 1-18.8 4.2" />
  </svg>
);

export const playListAddCheck = (
  <svg viewBox="0 0 24 24">
    <path
      fill="currentColor"
      d="M3 10h11v2H3zm0-4h11v2H3zm0 8h7v2H3zm17.59-2.07-4.25 4.24-2.12-2.12-1.41 1.41L16.34 19 22 13.34z"
    />
  </svg>
);

export const dragSvg = (
  <svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M14 5V19M5 14L3 12L5 10M19 14L21 12L19 10M10 5L10 19"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const addMessageSvg = (
  <svg viewBox="0 0 24 24" fill="none">
    <path
      opacity="0.4"
      d="M16 2H8C4 2 2 4 2 8V21C2 21.55 2.45 22 3 22H16C20 22 22 20 22 16V8C22 4 20 2 16 2Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M8.5 12H15.5"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeMiterlimit="10"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M12 15.5V8.5"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeMiterlimit="10"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const expandArrow = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="30"
    height="30"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="1.5"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M6 9l6 6 6-6" />
  </svg>
);

export const arrowBackSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M19 12H6M12 5l-7 7 7 7" />
  </svg>
);

export const messageSendSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    viewBox="0 0 24 24"
    strokeWidth="2"
    stroke="currentColor"
    fill="none"
    strokeLinecap="round"
    strokeLinejoin="round"
  >
    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
    <path d="M10 14l11 -11" />
    <path d="M21 3l-6.5 18a.55 .55 0 0 1 -1 0l-3.5 -7l-7 -3.5a.55 .55 0 0 1 0 -1l18 -6.5" />
  </svg>
);

export const chatBoxImageSvg = (
  <svg width={20} height={20} viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M21.6809 16.9601L18.5509 9.65013C17.4909 7.17013 15.5409 7.07013 14.2309 9.43013L12.3409 12.8401C11.3809 14.5701 9.5909 14.7201 8.3509 13.1701L8.1309 12.8901C6.8409 11.2701 5.0209 11.4701 4.0909 13.3201L2.3709 16.7701C1.1609 19.1701 2.9109 22.0001 5.5909 22.0001H18.3509C20.9509 22.0001 22.7009 19.3501 21.6809 16.9601Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M6.9707 8C8.62756 8 9.9707 6.65685 9.9707 5C9.9707 3.34315 8.62756 2 6.9707 2C5.31385 2 3.9707 3.34315 3.9707 5C3.9707 6.65685 5.31385 8 6.9707 8Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const chatLeaveSvg = (
  <svg
    fill="none"
    stroke="currentColor"
    strokeWidth="1.5"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    aria-hidden="true"
  >
    <path
      strokeLinecap="round"
      strokeLinejoin="round"
      d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75"
    />
  </svg>
);

export const videoSvg = (
  <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M16 10L18.5768 8.45392C19.3699 7.97803 19.7665 7.74009 20.0928 7.77051C20.3773 7.79703 20.6369 7.944 20.806 8.17433C21 8.43848 21 8.90095 21 9.8259V14.1741C21 15.099 21 15.5615 20.806 15.8257C20.6369 16.056 20.3773 16.203 20.0928 16.2295C19.7665 16.2599 19.3699 16.022 18.5768 15.5461L16 14M6.2 18H12.8C13.9201 18 14.4802 18 14.908 17.782C15.2843 17.5903 15.5903 17.2843 15.782 16.908C16 16.4802 16 15.9201 16 14.8V9.2C16 8.0799 16 7.51984 15.782 7.09202C15.5903 6.71569 15.2843 6.40973 14.908 6.21799C14.4802 6 13.9201 6 12.8 6H6.2C5.0799 6 4.51984 6 4.09202 6.21799C3.71569 6.40973 3.40973 6.71569 3.21799 7.09202C3 7.51984 3 8.07989 3 9.2V14.8C3 15.9201 3 16.4802 3.21799 16.908C3.40973 17.2843 3.71569 17.5903 4.09202 17.782C4.51984 18 5.07989 18 6.2 18Z"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const editSVG = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <polygon points="16 3 21 8 8 21 3 21 3 16 16 3" />
  </svg>
);

export const hideSvg = (
  <svg
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    aria-hidden="true"
    width={16}
    height={16}
  >
    <path
      strokeLinecap="round"
      strokeLinejoin="round"
      d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88"
    />
  </svg>
);

export const removeUserSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" />
    <circle cx="8.5" cy="7" r="4" />
    <line x1="18" y1="8" x2="23" y2="13" />
    <line x1="23" y1="8" x2="18" y2="13" />
  </svg>
);

export const resendMessageSvg = (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="16" height="16">
    <path d="M19.0003 10.0003L19.0004 19.0002L17.0004 19.0002L17.0003 12.0003L6.82845 12.0002L10.7782 15.9499L9.36396 17.3642L3 11.0002L9.36396 4.63623L10.7782 6.05044L6.8284 10.0002L19.0003 10.0003Z" />
  </svg>
);

export const failedMessageSvg = (
  <svg width={16} viewBox="0 0 24 24">
    <path
      fill="#e05e5e"
      d="M13,13H11V7H13M13,17H11V15H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"
    />
  </svg>
);

export const chatKeySvg = (
  <svg
    fill="none"
    stroke="currentColor"
    strokeWidth="1.5"
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
    aria-hidden="true"
  >
    <path
      strokeLinecap="round"
      strokeLinejoin="round"
      d="M15.75 5.25a3 3 0 013 3m3 0a6 6 0 01-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1121.75 8.25z"
    />
  </svg>
);
export const uploadSvgV = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="24"
    height="24"
    fill="currentColor"
    className="bi bi-cloud-arrow-up"
    viewBox="0 0 16 16"
  >
    <path
      fillRule="evenodd"
      d="M7.646 5.146a.5.5 0 0 1 .708 0l2 2a.5.5 0 0 1-.708.708L8.5 6.707V10.5a.5.5 0 0 1-1 0V6.707L6.354 7.854a.5.5 0 1 1-.708-.708l2-2z"
    />
    <path d="M4.406 3.342A5.53 5.53 0 0 1 8 2c2.69 0 4.923 2 5.166 4.579C14.758 6.804 16 8.137 16 9.773 16 11.569 14.502 13 12.687 13H3.781C1.708 13 0 11.366 0 9.318c0-1.763 1.266-3.223 2.942-3.593.143-.863.698-1.723 1.464-2.383zm.653.757c-.757.653-1.153 1.44-1.153 2.056v.448l-.445.049C2.064 6.805 1 7.952 1 9.318 1 10.785 2.23 12 3.781 12h8.906C13.98 12 15 10.988 15 9.773c0-1.216-1.02-2.228-2.313-2.228h-.5v-.5C12.188 4.825 10.328 3 8 3a4.53 4.53 0 0 0-2.941 1.1z" />
  </svg>
);

export const recordVideoSvg = (
  <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M18.5002 12C18.5002 13.3807 17.381 14.5 16.0002 14.5C14.6195 14.5 13.5002 13.3807 13.5002 12C13.5002 10.6193 14.6195 9.5 16.0002 9.5C17.381 9.5 18.5002 10.6193 18.5002 12Z"
      stroke="currentColor"
      strokeWidth="1.5"
    />
    <path
      d="M10.5 12C10.5 13.3807 9.38071 14.5 8 14.5C6.61929 14.5 5.5 13.3807 5.5 12C5.5 10.6193 6.61929 9.5 8 9.5C9.38071 9.5 10.5 10.6193 10.5 12Z"
      stroke="currentColor"
      strokeWidth="1.5"
    />
    <path d="M8 14.5H16" stroke="#1C274C" strokeWidth="1.5" strokeLinecap="round" />
    <path
      d="M7 3.33782C8.47087 2.48697 10.1786 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 10.1786 2.48697 8.47087 3.33782 7"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
    />
  </svg>
);

export const circleSvg = (
  <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    <circle r="12" cx="12" cy="12" fill="currentColor" />
  </svg>
);

export const rectSvg = (
  <svg width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
    <rect x={6} y={6} fill="currentColor" width={12} height={12} />
  </svg>
);

export const switchCameraSvg = (
  <svg
    width="24"
    height="24"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="round"
    strokeLinejoin="round"
  >
    <path d="M11 19H4a2 2 0 01-2-2V7a2 2 0 012-2h5" />
    <path d="M13 5h7a2 2 0 012 2v10a2 2 0 01-2 2h-5" />
    <circle cx="12" cy="12" r="3" />
    <path d="M18 22l-3-3 3-3" />
    <path d="M6 2l3 3-3 3" />
  </svg>
);

export const chatSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="21"
    height="21"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z" />
  </svg>
);

export const messangerSvg = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="20"
    height="20"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z" />
  </svg>
);

export const extendedView = (
  <svg viewBox="0 0 24 24" fill="none">
    <path
      d="M17.98 10.79V14.79C17.98 15.05 17.97 15.3 17.94 15.54C17.71 18.24 16.12 19.58 13.19 19.58H12.79C12.54 19.58 12.3 19.7 12.15 19.9L10.95 21.5C10.42 22.21 9.56 22.21 9.03 21.5L7.82999 19.9C7.69999 19.73 7.41 19.58 7.19 19.58H6.79001C3.60001 19.58 2 18.79 2 14.79V10.79C2 7.86001 3.35001 6.27001 6.04001 6.04001C6.28001 6.01001 6.53001 6 6.79001 6H13.19C16.38 6 17.98 7.60001 17.98 10.79Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeMiterlimit="10"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M21.9791 6.79001V10.79C21.9791 13.73 20.6291 15.31 17.9391 15.54C17.9691 15.3 17.9791 15.05 17.9791 14.79V10.79C17.9791 7.60001 16.3791 6 13.1891 6H6.78906C6.52906 6 6.27906 6.01001 6.03906 6.04001C6.26906 3.35001 7.85906 2 10.7891 2H17.1891C20.3791 2 21.9791 3.60001 21.9791 6.79001Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeMiterlimit="10"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M13.4955 13.25H13.5045"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M9.9955 13.25H10.0045"
      stroke="#292D32"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M6.4955 13.25H6.5045"
      stroke="#292D32"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const expandSideBar = (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width="30"
    height="30"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    strokeLinecap="square"
    strokeLinejoin="round"
  >
    <path d="M15 18l-6-6 6-6" />
  </svg>
);

export const duotoneRefreshSvg = (
  <svg viewBox="0 0 24 24" fill="none">
    <path
      d="M2 12C2 6.48 6.44 2 12 2C18.67 2 22 7.56 22 7.56M22 7.56V2.56M22 7.56H17.56"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M21.89 12C21.89 17.52 17.41 22 11.89 22C6.37 22 3 16.44 3 16.44M3 16.44H7.52M3 16.44V21.44"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const attachFileSvg = (
  <svg
    style={{ minWidth: "24px" }}
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M12.2009 11.8002L10.7908 13.2102C10.0108 13.9902 10.0108 15.2602 10.7908 16.0402C11.5708 16.8202 12.8408 16.8202 13.6208 16.0402L15.8409 13.8202C17.4009 12.2602 17.4009 9.73023 15.8409 8.16023C14.2809 6.60023 11.7508 6.60023 10.1808 8.16023L7.76086 10.5802C6.42086 11.9202 6.42086 14.0902 7.76086 15.4302"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M9 22H15C20 22 22 20 22 15V9C22 4 20 2 15 2H9C4 2 2 4 2 9V15C2 20 4 22 9 22Z"
      opacity="0.4"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);

export const savedMessagesSvg = (
  <svg width={16} height={16} viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M12.89 5.87988H5.10999C3.39999 5.87988 2 7.27987 2 8.98987V20.3499C2 21.7999 3.04 22.4199 4.31 21.7099L8.23999 19.5199C8.65999 19.2899 9.34 19.2899 9.75 19.5199L13.68 21.7099C14.95 22.4199 15.99 21.7999 15.99 20.3499V8.98987C16 7.27987 14.6 5.87988 12.89 5.87988Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M16 8.98987V20.3499C16 21.7999 14.96 22.4099 13.69 21.7099L9.76001 19.5199C9.34001 19.2899 8.65999 19.2899 8.23999 19.5199L4.31 21.7099C3.04 22.4099 2 21.7999 2 20.3499V8.98987C2 7.27987 3.39999 5.87988 5.10999 5.87988H12.89C14.6 5.87988 16 7.27987 16 8.98987Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      opacity="0.4"
      d="M22 5.10999V16.47C22 17.92 20.96 18.53 19.69 17.83L16 15.77V8.98999C16 7.27999 14.6 5.88 12.89 5.88H8V5.10999C8 3.39999 9.39999 2 11.11 2H18.89C20.6 2 22 3.39999 22 5.10999Z"
      stroke="currentColor"
      strokeWidth="1.5"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);
