import React, { Component } from "react";

/**
 * Component that alerts if you click outside of it
 */

interface Props {
  children: any;
  onClickAway: () => void;
  className?: string;
}
export default class ClickAwayListener extends Component<Props> {
  wrapperRef: any;
  constructor(props: Props) {
    super(props);
    this.setWrapperRef = this.setWrapperRef.bind(this);
    this.handleClickOutside = this.handleClickOutside.bind(this);
  }

  componentDidMount() {
    document.addEventListener("mousedown", this.handleClickOutside);
  }

  componentWillUnmount() {
    document.removeEventListener("mousedown", this.handleClickOutside);
  }

  /**
   * Set the wrapper ref
   */
  setWrapperRef(node: any) {
    this.wrapperRef = node;
  }

  /**
   * Alert if clicked on outside of element
   */
  handleClickOutside(event: any) {
    if (this.wrapperRef && !this.wrapperRef.contains(event.target)) {
      this.props.onClickAway();
    }
  }

  render() {
    return (
      <div ref={this.setWrapperRef} className={this.props.className}>
        {this.props.children}
      </div>
    );
  }
}
