// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file externalCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EXTERNALCDRAUX_HPP
#define FAST_DDS_GENERATED__EXTERNALCDRAUX_HPP

#include "external.hpp"

constexpr uint32_t ulong_external_max_cdr_typesize {8UL};
constexpr uint32_t ulong_external_max_key_cdr_typesize {0UL};

constexpr uint32_t ushort_external_max_cdr_typesize {6UL};
constexpr uint32_t ushort_external_max_key_cdr_typesize {0UL};

constexpr uint32_t char_external_max_cdr_typesize {5UL};
constexpr uint32_t char_external_max_key_cdr_typesize {0UL};

constexpr uint32_t struct_external_max_cdr_typesize {16UL};
constexpr uint32_t struct_external_max_key_cdr_typesize {0UL};

constexpr uint32_t ulonglong_external_max_cdr_typesize {16UL};
constexpr uint32_t ulonglong_external_max_key_cdr_typesize {0UL};

constexpr uint32_t struct_external_optional_max_cdr_typesize {28UL};
constexpr uint32_t struct_external_optional_max_key_cdr_typesize {0UL};

constexpr uint32_t short_external_max_cdr_typesize {6UL};
constexpr uint32_t short_external_max_key_cdr_typesize {0UL};

constexpr uint32_t octet_external_max_cdr_typesize {5UL};
constexpr uint32_t octet_external_max_key_cdr_typesize {0UL};

constexpr uint32_t array_short_external_max_cdr_typesize {24UL};
constexpr uint32_t array_short_external_max_key_cdr_typesize {0UL};

constexpr uint32_t long_external_max_cdr_typesize {8UL};
constexpr uint32_t long_external_max_key_cdr_typesize {0UL};

constexpr uint32_t boolean_external_max_cdr_typesize {5UL};
constexpr uint32_t boolean_external_max_key_cdr_typesize {0UL};

constexpr uint32_t wchar_external_max_cdr_typesize {6UL};
constexpr uint32_t wchar_external_max_key_cdr_typesize {0UL};

constexpr uint32_t string_unbounded_external_max_cdr_typesize {264UL};
constexpr uint32_t string_unbounded_external_max_key_cdr_typesize {0UL};

constexpr uint32_t ext_and_inner_struct_external_max_cdr_typesize {16UL};
constexpr uint32_t ext_and_inner_struct_external_max_key_cdr_typesize {0UL};

constexpr uint32_t longlong_external_max_cdr_typesize {16UL};
constexpr uint32_t longlong_external_max_key_cdr_typesize {0UL};

constexpr uint32_t longdouble_external_max_cdr_typesize {24UL};
constexpr uint32_t longdouble_external_max_key_cdr_typesize {0UL};

constexpr uint32_t sequence_short_external_max_cdr_typesize {8UL};
constexpr uint32_t sequence_short_external_max_key_cdr_typesize {0UL};


constexpr uint32_t recursive_test_1_max_cdr_typesize {24UL};
constexpr uint32_t recursive_test_1_max_key_cdr_typesize {0UL};

constexpr uint32_t recursive_test_2_max_cdr_typesize {28UL};
constexpr uint32_t recursive_test_2_max_key_cdr_typesize {0UL};



constexpr uint32_t recursive_union_container_max_cdr_typesize {20UL};
constexpr uint32_t recursive_union_container_max_key_cdr_typesize {0UL};

constexpr uint32_t map_short_external_max_cdr_typesize {8UL};
constexpr uint32_t map_short_external_max_key_cdr_typesize {0UL};




constexpr uint32_t double_external_max_cdr_typesize {16UL};
constexpr uint32_t double_external_max_key_cdr_typesize {0UL};



constexpr uint32_t ext_struct_external_max_cdr_typesize {16UL};
constexpr uint32_t ext_struct_external_max_key_cdr_typesize {0UL};




constexpr uint32_t float_external_max_cdr_typesize {8UL};
constexpr uint32_t float_external_max_key_cdr_typesize {0UL};

constexpr uint32_t string_bounded_external_max_cdr_typesize {17UL};
constexpr uint32_t string_bounded_external_max_key_cdr_typesize {0UL};




constexpr uint32_t recursive_structure_max_cdr_typesize {20UL};
constexpr uint32_t recursive_structure_max_key_cdr_typesize {0UL};



constexpr uint32_t InnerStructExternal_max_cdr_typesize {12UL};
constexpr uint32_t InnerStructExternal_max_key_cdr_typesize {0UL};


namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const short_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ushort_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const long_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ulong_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const longlong_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ulonglong_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const float_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const double_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const longdouble_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const boolean_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const octet_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const char_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const wchar_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const sequence_short_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const string_unbounded_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const string_bounded_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const map_short_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const array_short_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const struct_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const InnerStructExternal& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ext_struct_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ext_and_inner_struct_external& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const struct_external_optional& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const recursive_union_container& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const recursive_test_1& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const recursive_structure& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const recursive_test_2& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__EXTERNALCDRAUX_HPP

