// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file external.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EXTERNAL_HPP
#define FAST_DDS_GENERATED__EXTERNAL_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastcdr/exceptions/BadParamException.h>

#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(EXTERNAL_SOURCE)
#define EXTERNAL_DllAPI __declspec( dllexport )
#else
#define EXTERNAL_DllAPI __declspec( dllimport )
#endif // EXTERNAL_SOURCE
#else
#define EXTERNAL_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define EXTERNAL_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure short_external defined by the user in the IDL file.
 * @ingroup external
 */
class short_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport short_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~short_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object short_external that will be copied.
     */
    eProsima_user_DllExport short_external(
            const short_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object short_external that will be copied.
     */
    eProsima_user_DllExport short_external(
            short_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object short_external that will be copied.
     */
    eProsima_user_DllExport short_external& operator =(
            const short_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object short_external that will be copied.
     */
    eProsima_user_DllExport short_external& operator =(
            short_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x short_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const short_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x short_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const short_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<int16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<int16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<int16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<int16_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<int16_t> m_value;

};
/*!
 * @brief This class represents the structure ushort_external defined by the user in the IDL file.
 * @ingroup external
 */
class ushort_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ushort_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ushort_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ushort_external that will be copied.
     */
    eProsima_user_DllExport ushort_external(
            const ushort_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ushort_external that will be copied.
     */
    eProsima_user_DllExport ushort_external(
            ushort_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ushort_external that will be copied.
     */
    eProsima_user_DllExport ushort_external& operator =(
            const ushort_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ushort_external that will be copied.
     */
    eProsima_user_DllExport ushort_external& operator =(
            ushort_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ushort_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ushort_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<uint16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<uint16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<uint16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<uint16_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<uint16_t> m_value;

};
/*!
 * @brief This class represents the structure long_external defined by the user in the IDL file.
 * @ingroup external
 */
class long_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport long_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~long_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object long_external that will be copied.
     */
    eProsima_user_DllExport long_external(
            const long_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object long_external that will be copied.
     */
    eProsima_user_DllExport long_external(
            long_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object long_external that will be copied.
     */
    eProsima_user_DllExport long_external& operator =(
            const long_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object long_external that will be copied.
     */
    eProsima_user_DllExport long_external& operator =(
            long_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x long_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const long_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x long_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const long_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<int32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<int32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<int32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<int32_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<int32_t> m_value;

};
/*!
 * @brief This class represents the structure ulong_external defined by the user in the IDL file.
 * @ingroup external
 */
class ulong_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulong_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulong_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulong_external that will be copied.
     */
    eProsima_user_DllExport ulong_external(
            const ulong_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulong_external that will be copied.
     */
    eProsima_user_DllExport ulong_external(
            ulong_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulong_external that will be copied.
     */
    eProsima_user_DllExport ulong_external& operator =(
            const ulong_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulong_external that will be copied.
     */
    eProsima_user_DllExport ulong_external& operator =(
            ulong_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulong_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulong_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<uint32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<uint32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<uint32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<uint32_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<uint32_t> m_value;

};
/*!
 * @brief This class represents the structure longlong_external defined by the user in the IDL file.
 * @ingroup external
 */
class longlong_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longlong_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longlong_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longlong_external that will be copied.
     */
    eProsima_user_DllExport longlong_external(
            const longlong_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longlong_external that will be copied.
     */
    eProsima_user_DllExport longlong_external(
            longlong_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longlong_external that will be copied.
     */
    eProsima_user_DllExport longlong_external& operator =(
            const longlong_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longlong_external that will be copied.
     */
    eProsima_user_DllExport longlong_external& operator =(
            longlong_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longlong_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longlong_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<int64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<int64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<int64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<int64_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<int64_t> m_value;

};
/*!
 * @brief This class represents the structure ulonglong_external defined by the user in the IDL file.
 * @ingroup external
 */
class ulonglong_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulonglong_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulonglong_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulonglong_external that will be copied.
     */
    eProsima_user_DllExport ulonglong_external(
            const ulonglong_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulonglong_external that will be copied.
     */
    eProsima_user_DllExport ulonglong_external(
            ulonglong_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulonglong_external that will be copied.
     */
    eProsima_user_DllExport ulonglong_external& operator =(
            const ulonglong_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulonglong_external that will be copied.
     */
    eProsima_user_DllExport ulonglong_external& operator =(
            ulonglong_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulonglong_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulonglong_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<uint64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<uint64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<uint64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<uint64_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<uint64_t> m_value;

};
/*!
 * @brief This class represents the structure float_external defined by the user in the IDL file.
 * @ingroup external
 */
class float_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport float_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~float_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object float_external that will be copied.
     */
    eProsima_user_DllExport float_external(
            const float_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object float_external that will be copied.
     */
    eProsima_user_DllExport float_external(
            float_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object float_external that will be copied.
     */
    eProsima_user_DllExport float_external& operator =(
            const float_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object float_external that will be copied.
     */
    eProsima_user_DllExport float_external& operator =(
            float_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x float_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const float_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x float_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const float_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<float>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<float>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<float>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<float>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<float> m_value;

};
/*!
 * @brief This class represents the structure double_external defined by the user in the IDL file.
 * @ingroup external
 */
class double_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport double_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~double_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object double_external that will be copied.
     */
    eProsima_user_DllExport double_external(
            const double_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object double_external that will be copied.
     */
    eProsima_user_DllExport double_external(
            double_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object double_external that will be copied.
     */
    eProsima_user_DllExport double_external& operator =(
            const double_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object double_external that will be copied.
     */
    eProsima_user_DllExport double_external& operator =(
            double_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x double_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const double_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x double_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const double_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<double>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<double> m_value;

};
/*!
 * @brief This class represents the structure longdouble_external defined by the user in the IDL file.
 * @ingroup external
 */
class longdouble_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longdouble_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longdouble_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longdouble_external that will be copied.
     */
    eProsima_user_DllExport longdouble_external(
            const longdouble_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longdouble_external that will be copied.
     */
    eProsima_user_DllExport longdouble_external(
            longdouble_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longdouble_external that will be copied.
     */
    eProsima_user_DllExport longdouble_external& operator =(
            const longdouble_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longdouble_external that will be copied.
     */
    eProsima_user_DllExport longdouble_external& operator =(
            longdouble_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longdouble_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longdouble_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<long double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<long double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<long double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<long double>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<long double> m_value;

};
/*!
 * @brief This class represents the structure boolean_external defined by the user in the IDL file.
 * @ingroup external
 */
class boolean_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport boolean_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~boolean_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object boolean_external that will be copied.
     */
    eProsima_user_DllExport boolean_external(
            const boolean_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object boolean_external that will be copied.
     */
    eProsima_user_DllExport boolean_external(
            boolean_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object boolean_external that will be copied.
     */
    eProsima_user_DllExport boolean_external& operator =(
            const boolean_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object boolean_external that will be copied.
     */
    eProsima_user_DllExport boolean_external& operator =(
            boolean_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const boolean_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const boolean_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<bool>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<bool>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<bool>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<bool>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<bool> m_value;

};
/*!
 * @brief This class represents the structure octet_external defined by the user in the IDL file.
 * @ingroup external
 */
class octet_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport octet_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~octet_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object octet_external that will be copied.
     */
    eProsima_user_DllExport octet_external(
            const octet_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object octet_external that will be copied.
     */
    eProsima_user_DllExport octet_external(
            octet_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object octet_external that will be copied.
     */
    eProsima_user_DllExport octet_external& operator =(
            const octet_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object octet_external that will be copied.
     */
    eProsima_user_DllExport octet_external& operator =(
            octet_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const octet_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const octet_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<uint8_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<uint8_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<uint8_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<uint8_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<uint8_t> m_value;

};
/*!
 * @brief This class represents the structure char_external defined by the user in the IDL file.
 * @ingroup external
 */
class char_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport char_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~char_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object char_external that will be copied.
     */
    eProsima_user_DllExport char_external(
            const char_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object char_external that will be copied.
     */
    eProsima_user_DllExport char_external(
            char_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object char_external that will be copied.
     */
    eProsima_user_DllExport char_external& operator =(
            const char_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object char_external that will be copied.
     */
    eProsima_user_DllExport char_external& operator =(
            char_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x char_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const char_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x char_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const char_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<char>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<char>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<char>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<char>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<char> m_value;

};
/*!
 * @brief This class represents the structure wchar_external defined by the user in the IDL file.
 * @ingroup external
 */
class wchar_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport wchar_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~wchar_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object wchar_external that will be copied.
     */
    eProsima_user_DllExport wchar_external(
            const wchar_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object wchar_external that will be copied.
     */
    eProsima_user_DllExport wchar_external(
            wchar_external&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object wchar_external that will be copied.
     */
    eProsima_user_DllExport wchar_external& operator =(
            const wchar_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object wchar_external that will be copied.
     */
    eProsima_user_DllExport wchar_external& operator =(
            wchar_external&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const wchar_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const wchar_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<wchar_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<wchar_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<wchar_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<wchar_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<wchar_t> m_value;

};
/*!
 * @brief This class represents the structure sequence_short_external defined by the user in the IDL file.
 * @ingroup external
 */
class sequence_short_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport sequence_short_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~sequence_short_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object sequence_short_external that will be copied.
     */
    eProsima_user_DllExport sequence_short_external(
            const sequence_short_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object sequence_short_external that will be copied.
     */
    eProsima_user_DllExport sequence_short_external(
            sequence_short_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object sequence_short_external that will be copied.
     */
    eProsima_user_DllExport sequence_short_external& operator =(
            const sequence_short_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object sequence_short_external that will be copied.
     */
    eProsima_user_DllExport sequence_short_external& operator =(
            sequence_short_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const sequence_short_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const sequence_short_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<std::vector<int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<std::vector<int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<std::vector<int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<std::vector<int16_t>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<std::vector<int16_t>> m_value;

};
/*!
 * @brief This class represents the structure string_unbounded_external defined by the user in the IDL file.
 * @ingroup external
 */
class string_unbounded_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_unbounded_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_unbounded_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_unbounded_external that will be copied.
     */
    eProsima_user_DllExport string_unbounded_external(
            const string_unbounded_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_unbounded_external that will be copied.
     */
    eProsima_user_DllExport string_unbounded_external(
            string_unbounded_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_unbounded_external that will be copied.
     */
    eProsima_user_DllExport string_unbounded_external& operator =(
            const string_unbounded_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_unbounded_external that will be copied.
     */
    eProsima_user_DllExport string_unbounded_external& operator =(
            string_unbounded_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_unbounded_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_unbounded_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<std::string>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<std::string>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<std::string>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<std::string>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<std::string> m_value;

};
/*!
 * @brief This class represents the structure string_bounded_external defined by the user in the IDL file.
 * @ingroup external
 */
class string_bounded_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_bounded_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_bounded_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_bounded_external that will be copied.
     */
    eProsima_user_DllExport string_bounded_external(
            const string_bounded_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_bounded_external that will be copied.
     */
    eProsima_user_DllExport string_bounded_external(
            string_bounded_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_bounded_external that will be copied.
     */
    eProsima_user_DllExport string_bounded_external& operator =(
            const string_bounded_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_bounded_external that will be copied.
     */
    eProsima_user_DllExport string_bounded_external& operator =(
            string_bounded_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_bounded_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_bounded_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<eprosima::fastcdr::fixed_string<8>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<eprosima::fastcdr::fixed_string<8>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<eprosima::fastcdr::fixed_string<8>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<eprosima::fastcdr::fixed_string<8>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<eprosima::fastcdr::fixed_string<8>> m_value;

};
/*!
 * @brief This class represents the structure map_short_external defined by the user in the IDL file.
 * @ingroup external
 */
class map_short_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport map_short_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~map_short_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object map_short_external that will be copied.
     */
    eProsima_user_DllExport map_short_external(
            const map_short_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object map_short_external that will be copied.
     */
    eProsima_user_DllExport map_short_external(
            map_short_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object map_short_external that will be copied.
     */
    eProsima_user_DllExport map_short_external& operator =(
            const map_short_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object map_short_external that will be copied.
     */
    eProsima_user_DllExport map_short_external& operator =(
            map_short_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const map_short_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const map_short_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<std::map<int32_t, int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<std::map<int32_t, int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<std::map<int32_t, int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<std::map<int32_t, int16_t>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<std::map<int32_t, int16_t>> m_value;

};
/*!
 * @brief This class represents the structure array_short_external defined by the user in the IDL file.
 * @ingroup external
 */
class array_short_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport array_short_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~array_short_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object array_short_external that will be copied.
     */
    eProsima_user_DllExport array_short_external(
            const array_short_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object array_short_external that will be copied.
     */
    eProsima_user_DllExport array_short_external(
            array_short_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object array_short_external that will be copied.
     */
    eProsima_user_DllExport array_short_external& operator =(
            const array_short_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object array_short_external that will be copied.
     */
    eProsima_user_DllExport array_short_external& operator =(
            array_short_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const array_short_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const array_short_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<std::array<int16_t, 10>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<std::array<int16_t, 10>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<std::array<int16_t, 10>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<std::array<int16_t, 10>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<std::array<int16_t, 10>> m_value;

};
/*!
 * @brief This class represents the structure struct_external defined by the user in the IDL file.
 * @ingroup external
 */
class struct_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_external that will be copied.
     */
    eProsima_user_DllExport struct_external(
            const struct_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_external that will be copied.
     */
    eProsima_user_DllExport struct_external(
            struct_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_external that will be copied.
     */
    eProsima_user_DllExport struct_external& operator =(
            const struct_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_external that will be copied.
     */
    eProsima_user_DllExport struct_external& operator =(
            struct_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<InnerStructureHelper>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<InnerStructureHelper>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<InnerStructureHelper>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<InnerStructureHelper>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<InnerStructureHelper> m_value;

};
/*!
 * @brief This class represents the structure InnerStructExternal defined by the user in the IDL file.
 * @ingroup external
 */
class InnerStructExternal
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructExternal()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructExternal()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructExternal that will be copied.
     */
    eProsima_user_DllExport InnerStructExternal(
            const InnerStructExternal& x)
    {
                    m_s = x.m_s;

                    m_l = x.m_l;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructExternal that will be copied.
     */
    eProsima_user_DllExport InnerStructExternal(
            InnerStructExternal&& x) noexcept
    {
        m_s = x.m_s;
        m_l = x.m_l;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructExternal that will be copied.
     */
    eProsima_user_DllExport InnerStructExternal& operator =(
            const InnerStructExternal& x)
    {

                    m_s = x.m_s;

                    m_l = x.m_l;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructExternal that will be copied.
     */
    eProsima_user_DllExport InnerStructExternal& operator =(
            InnerStructExternal&& x) noexcept
    {

        m_s = x.m_s;
        m_l = x.m_l;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructExternal object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructExternal& x) const
    {
        return (m_s == x.m_s &&
           m_l == x.m_l);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructExternal object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructExternal& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function copies the value in member l
     * @param _l New value to be copied in member l
     */
    eProsima_user_DllExport void l(
            const eprosima::fastcdr::external<int32_t>& _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function moves the value in member l
     * @param _l New value to be moved in member l
     */
    eProsima_user_DllExport void l(
            eprosima::fastcdr::external<int32_t>&& _l)
    {
        m_l = std::move(_l);
    }

    /*!
     * @brief This function returns a constant reference to member l
     * @return Constant reference to member l
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<int32_t>& l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport eprosima::fastcdr::external<int32_t>& l()
    {
        return m_l;
    }



private:

    int16_t m_s{0};
    eprosima::fastcdr::external<int32_t> m_l;

};
/*!
 * @brief This class represents the structure ext_struct_external defined by the user in the IDL file.
 * @ingroup external
 */
class ext_struct_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ext_struct_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ext_struct_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ext_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_struct_external(
            const ext_struct_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ext_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_struct_external(
            ext_struct_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ext_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_struct_external& operator =(
            const ext_struct_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ext_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_struct_external& operator =(
            ext_struct_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ext_struct_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ext_struct_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ext_struct_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ext_struct_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const InnerStructExternal& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            InnerStructExternal&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const InnerStructExternal& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport InnerStructExternal& value()
    {
        return m_value;
    }



private:

    InnerStructExternal m_value;

};
/*!
 * @brief This class represents the structure ext_and_inner_struct_external defined by the user in the IDL file.
 * @ingroup external
 */
class ext_and_inner_struct_external
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ext_and_inner_struct_external()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ext_and_inner_struct_external()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ext_and_inner_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_and_inner_struct_external(
            const ext_and_inner_struct_external& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ext_and_inner_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_and_inner_struct_external(
            ext_and_inner_struct_external&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ext_and_inner_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_and_inner_struct_external& operator =(
            const ext_and_inner_struct_external& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ext_and_inner_struct_external that will be copied.
     */
    eProsima_user_DllExport ext_and_inner_struct_external& operator =(
            ext_and_inner_struct_external&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ext_and_inner_struct_external object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ext_and_inner_struct_external& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ext_and_inner_struct_external object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ext_and_inner_struct_external& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::external<InnerStructExternal>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::external<InnerStructExternal>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<InnerStructExternal>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::external<InnerStructExternal>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::external<InnerStructExternal> m_value;

};
/*!
 * @brief This class represents the structure struct_external_optional defined by the user in the IDL file.
 * @ingroup external
 */
class struct_external_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_external_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_external_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_external_optional that will be copied.
     */
    eProsima_user_DllExport struct_external_optional(
            const struct_external_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_external_optional that will be copied.
     */
    eProsima_user_DllExport struct_external_optional(
            struct_external_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_external_optional that will be copied.
     */
    eProsima_user_DllExport struct_external_optional& operator =(
            const struct_external_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_external_optional that will be copied.
     */
    eProsima_user_DllExport struct_external_optional& operator =(
            struct_external_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_external_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_external_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_external_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_external_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<eprosima::fastcdr::external<InnerStructureHelper>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<eprosima::fastcdr::external<InnerStructureHelper>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<eprosima::fastcdr::external<InnerStructureHelper>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<eprosima::fastcdr::external<InnerStructureHelper>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<eprosima::fastcdr::external<InnerStructureHelper>> m_value;

};
class recursive_union;

/*!
 * @brief This class represents the structure recursive_union_container defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_union_container
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_union_container()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_union_container()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_union_container that will be copied.
     */
    eProsima_user_DllExport recursive_union_container(
            const recursive_union_container& x)
    {
                    m_l = x.m_l;

                    m_ext = x.m_ext;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_union_container that will be copied.
     */
    eProsima_user_DllExport recursive_union_container(
            recursive_union_container&& x) noexcept
    {
        m_l = x.m_l;
        m_ext = std::move(x.m_ext);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_union_container that will be copied.
     */
    eProsima_user_DllExport recursive_union_container& operator =(
            const recursive_union_container& x)
    {

                    m_l = x.m_l;

                    m_ext = x.m_ext;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_union_container that will be copied.
     */
    eProsima_user_DllExport recursive_union_container& operator =(
            recursive_union_container&& x) noexcept
    {

        m_l = x.m_l;
        m_ext = std::move(x.m_ext);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_union_container object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_union_container& x) const
    {
        return (m_l == x.m_l &&
           m_ext == x.m_ext);
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_union_container object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_union_container& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     */
    eProsima_user_DllExport int32_t l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport int32_t& l()
    {
        return m_l;
    }


    /*!
     * @brief This function copies the value in member ext
     * @param _ext New value to be copied in member ext
     */
    eProsima_user_DllExport void ext(
            const eprosima::fastcdr::external<recursive_union>& _ext)
    {
        m_ext = _ext;
    }

    /*!
     * @brief This function moves the value in member ext
     * @param _ext New value to be moved in member ext
     */
    eProsima_user_DllExport void ext(
            eprosima::fastcdr::external<recursive_union>&& _ext)
    {
        m_ext = std::move(_ext);
    }

    /*!
     * @brief This function returns a constant reference to member ext
     * @return Constant reference to member ext
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<recursive_union>& ext() const
    {
        return m_ext;
    }

    /*!
     * @brief This function returns a reference to member ext
     * @return Reference to member ext
     */
    eProsima_user_DllExport eprosima::fastcdr::external<recursive_union>& ext()
    {
        return m_ext;
    }



private:

    int32_t m_l{0};
    eprosima::fastcdr::external<recursive_union> m_ext;

};
/*!
 * @brief This class represents the union recursive_union defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_union
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_union()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_union()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_union that will be copied.
     */
    eProsima_user_DllExport recursive_union(
            const recursive_union& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

                        case 0x00000002:
                            c_() = x.m_c;
                            break;

                        case 0x00000003:
                            s_() = x.m_s;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_union that will be copied.
     */
    eProsima_user_DllExport recursive_union(
            recursive_union&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

                        case 0x00000002:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000003:
                            s_() = std::move(x.m_s);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_union that will be copied.
     */
    eProsima_user_DllExport recursive_union& operator =(
            const recursive_union& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

                        case 0x00000002:
                            c_() = x.m_c;
                            break;

                        case 0x00000003:
                            s_() = x.m_s;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_union that will be copied.
     */
    eProsima_user_DllExport recursive_union& operator =(
            recursive_union&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

                        case 0x00000002:
                            c_() = std::move(x.m_c);
                            break;

                        case 0x00000003:
                            s_() = std::move(x.m_s);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_union object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_union& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_l == m_l);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_c == m_c);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_s == m_s);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_union object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_union& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 3:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        l_() = _l;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t l() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& l()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }


    /*!
     * @brief This function copies the value in member c
     * @param _c New value to be copied in member c
     */
    eProsima_user_DllExport void c(
            const recursive_union_container& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function moves the value in member c
     * @param _c New value to be moved in member c
     */
    eProsima_user_DllExport void c(
            recursive_union_container&& _c)
    {
        c_() = _c;
        m__d = 2;
    }

    /*!
     * @brief This function returns a constant reference to member c
     * @return Constant reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const recursive_union_container& c() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport recursive_union_container& c()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_c;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        s_() = _s;
        m__d = 3;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t s() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& s()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& l_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_l = {0};

                }

                return m_l;
            }

            recursive_union_container& c_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_c.~recursive_union_container();
                    };
                    new(&m_c) recursive_union_container();

                }

                return m_c;
            }

            int16_t& s_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = nullptr;
                    m_s = {0};

                }

                return m_s;
            }


    uint8_t m__d {127};

    union
    {
        int32_t m_l;
        recursive_union_container m_c;
        int16_t m_s;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure recursive_test_1 defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_test_1
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_test_1()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_test_1()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_test_1 that will be copied.
     */
    eProsima_user_DllExport recursive_test_1(
            const recursive_test_1& x)
    {
                    m_s = x.m_s;

                    m_u = x.m_u;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_test_1 that will be copied.
     */
    eProsima_user_DllExport recursive_test_1(
            recursive_test_1&& x) noexcept
    {
        m_s = x.m_s;
        m_u = std::move(x.m_u);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_test_1 that will be copied.
     */
    eProsima_user_DllExport recursive_test_1& operator =(
            const recursive_test_1& x)
    {

                    m_s = x.m_s;

                    m_u = x.m_u;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_test_1 that will be copied.
     */
    eProsima_user_DllExport recursive_test_1& operator =(
            recursive_test_1&& x) noexcept
    {

        m_s = x.m_s;
        m_u = std::move(x.m_u);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_test_1 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_test_1& x) const
    {
        return (m_s == x.m_s &&
           m_u == x.m_u);
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_test_1 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_test_1& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function copies the value in member u
     * @param _u New value to be copied in member u
     */
    eProsima_user_DllExport void u(
            const recursive_union& _u)
    {
        m_u = _u;
    }

    /*!
     * @brief This function moves the value in member u
     * @param _u New value to be moved in member u
     */
    eProsima_user_DllExport void u(
            recursive_union&& _u)
    {
        m_u = std::move(_u);
    }

    /*!
     * @brief This function returns a constant reference to member u
     * @return Constant reference to member u
     */
    eProsima_user_DllExport const recursive_union& u() const
    {
        return m_u;
    }

    /*!
     * @brief This function returns a reference to member u
     * @return Reference to member u
     */
    eProsima_user_DllExport recursive_union& u()
    {
        return m_u;
    }



private:

    int16_t m_s{0};
    recursive_union m_u;

};
class recursive_structure;

/*!
 * @brief This class represents the union recursive_structure_container defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_structure_container
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_structure_container()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_structure_container()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_structure_container that will be copied.
     */
    eProsima_user_DllExport recursive_structure_container(
            const recursive_structure_container& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

                        case 0x00000002:
                            ext_() = x.m_ext;
                            break;

                        case 0x00000003:
                            s_() = x.m_s;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_structure_container that will be copied.
     */
    eProsima_user_DllExport recursive_structure_container(
            recursive_structure_container&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

                        case 0x00000002:
                            ext_() = std::move(x.m_ext);
                            break;

                        case 0x00000003:
                            s_() = std::move(x.m_s);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_structure_container that will be copied.
     */
    eProsima_user_DllExport recursive_structure_container& operator =(
            const recursive_structure_container& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = x.m_l;
                            break;

                        case 0x00000002:
                            ext_() = x.m_ext;
                            break;

                        case 0x00000003:
                            s_() = x.m_s;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_structure_container that will be copied.
     */
    eProsima_user_DllExport recursive_structure_container& operator =(
            recursive_structure_container&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            l_() = std::move(x.m_l);
                            break;

                        case 0x00000002:
                            ext_() = std::move(x.m_ext);
                            break;

                        case 0x00000003:
                            s_() = std::move(x.m_s);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_structure_container object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_structure_container& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_l == m_l);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_ext == m_ext);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_s == m_s);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_structure_container object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_structure_container& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case 1:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 2:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case 3:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member l
     * @param _l New value for member l
     */
    eProsima_user_DllExport void l(
            int32_t _l)
    {
        l_() = _l;
        m__d = 1;
    }

    /*!
     * @brief This function returns the value of member l
     * @return Value of member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t l() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& l()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_l;
    }


    /*!
     * @brief This function copies the value in member ext
     * @param _ext New value to be copied in member ext
     */
    eProsima_user_DllExport void ext(
            const eprosima::fastcdr::external<recursive_structure>& _ext)
    {
        ext_() = _ext;
        m__d = 2;
    }

    /*!
     * @brief This function moves the value in member ext
     * @param _ext New value to be moved in member ext
     */
    eProsima_user_DllExport void ext(
            eprosima::fastcdr::external<recursive_structure>&& _ext)
    {
        ext_() = _ext;
        m__d = 2;
    }

    /*!
     * @brief This function returns a constant reference to member ext
     * @return Constant reference to member ext
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<recursive_structure>& ext() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_ext;
    }

    /*!
     * @brief This function returns a reference to member ext
     * @return Reference to member ext
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport eprosima::fastcdr::external<recursive_structure>& ext()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_ext;
    }


    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        s_() = _s;
        m__d = 3;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t s() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& s()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_s;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            int32_t& l_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_l = {0};

                }

                return m_l;
            }

            eprosima::fastcdr::external<recursive_structure>& ext_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_ext.~external();
                    };
                    new(&m_ext) eprosima::fastcdr::external<recursive_structure>();

                }

                return m_ext;
            }

            int16_t& s_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = nullptr;
                    m_s = {0};

                }

                return m_s;
            }


    uint8_t m__d {127};

    union
    {
        int32_t m_l;
        eprosima::fastcdr::external<recursive_structure> m_ext;
        int16_t m_s;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure recursive_structure defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_structure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_structure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_structure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_structure that will be copied.
     */
    eProsima_user_DllExport recursive_structure(
            const recursive_structure& x)
    {
                    m_s = x.m_s;

                    m_c = x.m_c;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_structure that will be copied.
     */
    eProsima_user_DllExport recursive_structure(
            recursive_structure&& x) noexcept
    {
        m_s = x.m_s;
        m_c = std::move(x.m_c);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_structure that will be copied.
     */
    eProsima_user_DllExport recursive_structure& operator =(
            const recursive_structure& x)
    {

                    m_s = x.m_s;

                    m_c = x.m_c;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_structure that will be copied.
     */
    eProsima_user_DllExport recursive_structure& operator =(
            recursive_structure&& x) noexcept
    {

        m_s = x.m_s;
        m_c = std::move(x.m_c);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_structure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_structure& x) const
    {
        return (m_s == x.m_s &&
           m_c == x.m_c);
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_structure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_structure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function copies the value in member c
     * @param _c New value to be copied in member c
     */
    eProsima_user_DllExport void c(
            const recursive_structure_container& _c)
    {
        m_c = _c;
    }

    /*!
     * @brief This function moves the value in member c
     * @param _c New value to be moved in member c
     */
    eProsima_user_DllExport void c(
            recursive_structure_container&& _c)
    {
        m_c = std::move(_c);
    }

    /*!
     * @brief This function returns a constant reference to member c
     * @return Constant reference to member c
     */
    eProsima_user_DllExport const recursive_structure_container& c() const
    {
        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     */
    eProsima_user_DllExport recursive_structure_container& c()
    {
        return m_c;
    }



private:

    int16_t m_s{0};
    recursive_structure_container m_c;

};
/*!
 * @brief This class represents the structure recursive_test_2 defined by the user in the IDL file.
 * @ingroup external
 */
class recursive_test_2
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport recursive_test_2()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~recursive_test_2()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object recursive_test_2 that will be copied.
     */
    eProsima_user_DllExport recursive_test_2(
            const recursive_test_2& x)
    {
                    m_o = x.m_o;

                    m_s = x.m_s;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object recursive_test_2 that will be copied.
     */
    eProsima_user_DllExport recursive_test_2(
            recursive_test_2&& x) noexcept
    {
        m_o = x.m_o;
        m_s = std::move(x.m_s);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object recursive_test_2 that will be copied.
     */
    eProsima_user_DllExport recursive_test_2& operator =(
            const recursive_test_2& x)
    {

                    m_o = x.m_o;

                    m_s = x.m_s;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object recursive_test_2 that will be copied.
     */
    eProsima_user_DllExport recursive_test_2& operator =(
            recursive_test_2&& x) noexcept
    {

        m_o = x.m_o;
        m_s = std::move(x.m_s);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_test_2 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const recursive_test_2& x) const
    {
        return (m_o == x.m_o &&
           m_s == x.m_s);
    }

    /*!
     * @brief Comparison operator.
     * @param x recursive_test_2 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const recursive_test_2& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member o
     * @param _o New value for member o
     */
    eProsima_user_DllExport void o(
            uint8_t _o)
    {
        m_o = _o;
    }

    /*!
     * @brief This function returns the value of member o
     * @return Value of member o
     */
    eProsima_user_DllExport uint8_t o() const
    {
        return m_o;
    }

    /*!
     * @brief This function returns a reference to member o
     * @return Reference to member o
     */
    eProsima_user_DllExport uint8_t& o()
    {
        return m_o;
    }


    /*!
     * @brief This function copies the value in member s
     * @param _s New value to be copied in member s
     */
    eProsima_user_DllExport void s(
            const recursive_structure& _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function moves the value in member s
     * @param _s New value to be moved in member s
     */
    eProsima_user_DllExport void s(
            recursive_structure&& _s)
    {
        m_s = std::move(_s);
    }

    /*!
     * @brief This function returns a constant reference to member s
     * @return Constant reference to member s
     */
    eProsima_user_DllExport const recursive_structure& s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport recursive_structure& s()
    {
        return m_s;
    }



private:

    uint8_t m_o{0};
    recursive_structure m_s;

};

#endif // _FAST_DDS_GENERATED_EXTERNAL_HPP_


