// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file annotations.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__ANNOTATIONS_HPP
#define FAST_DDS_GENERATED__ANNOTATIONS_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ANNOTATIONS_SOURCE)
#define ANNOTATIONS_DllAPI __declspec( dllexport )
#else
#define ANNOTATIONS_DllAPI __declspec( dllimport )
#endif // ANNOTATIONS_SOURCE
#else
#define ANNOTATIONS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ANNOTATIONS_DllAPI
#endif // _WIN32

namespace AnnotationTest {
    /*!
     * @brief This class represents the enumeration InnerEnumHelper defined by the user in the IDL file.
     * @ingroup annotations
     */
    enum class InnerEnumHelper : int32_t
    {
        ONE,
        TWO
    };

    typedef eprosima::fastcdr::fixed_string<inner_const_helper> Inner_alias_bounded_string_helper;


    const int16_t inner_const_helper = 10;

} // namespace AnnotationTest

/*!
 * @brief This class represents the structure AnnotatedStruct defined by the user in the IDL file.
 * @ingroup annotations
 */
class AnnotatedStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AnnotatedStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AnnotatedStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport AnnotatedStruct(
            const AnnotatedStruct& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport AnnotatedStruct(
            AnnotatedStruct&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport AnnotatedStruct& operator =(
            const AnnotatedStruct& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport AnnotatedStruct& operator =(
            AnnotatedStruct&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AnnotatedStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AnnotatedStruct& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x AnnotatedStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AnnotatedStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure EmptyAnnotatedStruct defined by the user in the IDL file.
 * @ingroup annotations
 */
class EmptyAnnotatedStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EmptyAnnotatedStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EmptyAnnotatedStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EmptyAnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport EmptyAnnotatedStruct(
            const EmptyAnnotatedStruct& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EmptyAnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport EmptyAnnotatedStruct(
            EmptyAnnotatedStruct&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EmptyAnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport EmptyAnnotatedStruct& operator =(
            const EmptyAnnotatedStruct& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EmptyAnnotatedStruct that will be copied.
     */
    eProsima_user_DllExport EmptyAnnotatedStruct& operator =(
            EmptyAnnotatedStruct&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EmptyAnnotatedStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EmptyAnnotatedStruct& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x EmptyAnnotatedStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EmptyAnnotatedStruct& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure BasicAnnotationsStruct defined by the user in the IDL file.
 * @ingroup annotations
 */
class BasicAnnotationsStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BasicAnnotationsStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BasicAnnotationsStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BasicAnnotationsStruct that will be copied.
     */
    eProsima_user_DllExport BasicAnnotationsStruct(
            const BasicAnnotationsStruct& x)
    {
                    m_basic_annotations_member = x.m_basic_annotations_member;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BasicAnnotationsStruct that will be copied.
     */
    eProsima_user_DllExport BasicAnnotationsStruct(
            BasicAnnotationsStruct&& x) noexcept
    {
        m_basic_annotations_member = x.m_basic_annotations_member;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BasicAnnotationsStruct that will be copied.
     */
    eProsima_user_DllExport BasicAnnotationsStruct& operator =(
            const BasicAnnotationsStruct& x)
    {

                    m_basic_annotations_member = x.m_basic_annotations_member;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BasicAnnotationsStruct that will be copied.
     */
    eProsima_user_DllExport BasicAnnotationsStruct& operator =(
            BasicAnnotationsStruct&& x) noexcept
    {

        m_basic_annotations_member = x.m_basic_annotations_member;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BasicAnnotationsStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BasicAnnotationsStruct& x) const
    {
        return (m_basic_annotations_member == x.m_basic_annotations_member);
    }

    /*!
     * @brief Comparison operator.
     * @param x BasicAnnotationsStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BasicAnnotationsStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member basic_annotations_member
     * @param _basic_annotations_member New value for member basic_annotations_member
     */
    eProsima_user_DllExport void basic_annotations_member(
            int16_t _basic_annotations_member)
    {
        m_basic_annotations_member = _basic_annotations_member;
    }

    /*!
     * @brief This function returns the value of member basic_annotations_member
     * @return Value of member basic_annotations_member
     */
    eProsima_user_DllExport int16_t basic_annotations_member() const
    {
        return m_basic_annotations_member;
    }

    /*!
     * @brief This function returns a reference to member basic_annotations_member
     * @return Reference to member basic_annotations_member
     */
    eProsima_user_DllExport int16_t& basic_annotations_member()
    {
        return m_basic_annotations_member;
    }



private:

    int16_t m_basic_annotations_member{0};

};

#endif // _FAST_DDS_GENERATED_ANNOTATIONS_HPP_


