# [.NET Microservices: Architecture for Containerized .NET Applications](index.md)
## [Introduction to Containers and Docker](container-docker-introduction/index.md)
### [What is Docker?](container-docker-introduction/docker-defined.md)
### [Docker terminology](container-docker-introduction/docker-terminology.md)
### [Docker containers, images, and registries](container-docker-introduction/docker-containers-images-registries.md)
## [Choosing Between NET Core and NET Framework for Docker Containers](net-core-net-framework-containers/index.md)
### [General guidance](net-core-net-framework-containers/general-guidance.md)
### [When to choose .NET Core for Docker containers](net-core-net-framework-containers/net-core-container-scenarios.md)
### [When to choose .NET Framework for Docker containers](net-core-net-framework-containers/net-framework-container-scenarios.md)
### [Decision table: .NET frameworks to use for Docker](net-core-net-framework-containers/container-framework-choice-factors.md)
### [What OS to target with .NET containers](net-core-net-framework-containers/net-container-os-targets.md)
### [Official .NET Docker images](net-core-net-framework-containers/official-net-docker-images.md)
## [Architecting Container and Microservice Based Applications](architect-microservice-container-applications/index.md)
### [Containerizing monolithic applications](architect-microservice-container-applications/containerize-monolithic-applications.md)
### [State and data in Docker applications](architect-microservice-container-applications/docker-application-state-data.md)
### [Service-oriented architecture ](architect-microservice-container-applications/service-oriented-architecture.md)
### [Microservices architecture](architect-microservice-container-applications/microservices-architecture.md)
### [Data sovereignty per microservice](architect-microservice-container-applications/data-sovereignty-per-microservice.md)
### [Logical architecture versus physical architecture](architect-microservice-container-applications/logical-versus-physical-architecture.md)
### [Challenges and solutions for distributed data management](architect-microservice-container-applications/distributed-data-management.md)
### [Identifying domain-model boundaries for each microservice](architect-microservice-container-applications/identify-microservice-domain-model-boundaries.md)
### [Communication between microservices](architect-microservice-container-applications/communication-between-microservices.md)
### [Asynchronous message-based communication](architect-microservice-container-applications/asynchronous-message-based-communication.md)
### [Creating, evolving, and versioning microservice APIs and contracts](architect-microservice-container-applications/maintain-microservice-apis.md)
### [Microservices addressability and the service registry](architect-microservice-container-applications/microservices-addressability-service-registry.md)
### [Creating composite UI based on microservices, including visual UI shape and layout generated by multiple microservices](architect-microservice-container-applications/microservice-based-composite-ui-shape-layout.md)
### [Resiliency and high availability in microservices](architect-microservice-container-applications/resilient-high-availability-microservices.md)
### [Orchestrating microservices and multi-container applications for high scalability and availability](architect-microservice-container-applications/scalable-available-multi-container-microservice-applications.md)
### [Using Azure Service Fabric](architect-microservice-container-applications/using-azure-service-fabric.md)
## [Development Process for Docker Based Applications](docker-application-development-process/index.md)
### [Development workflow for Docker apps](docker-application-development-process/docker-app-development-workflow.md)
## [Deploying Single Container Based NET Core Web Applications on Linux or Windows Nano Server Hosts](net-core-single-containers-linux-windows-server-hosts/index.md)
## [Migrating Legacy Monolithic NET Framework Applications to Windows Containers](containerize-net-framework-applications/index.md)
## [Designing and Developing Multi Container and Microservice Based NET Applications](multi-container-microservice-net-applications/index.md)
### [Designing a microservice-oriented application](multi-container-microservice-net-applications/microservice-application-design.md)
### [Creating a simple data-driven CRUD microservice](multi-container-microservice-net-applications/data-driven-crud-microservice.md)
### [Defining your multi-container application with docker-compose.yml](multi-container-microservice-net-applications/multi-container-applications-docker-compose.md)
### [Using a database server running as a container](multi-container-microservice-net-applications/database-server-container.md)
### [Implementing event-based communication between microservices (integration events)](multi-container-microservice-net-applications/integration-event-based-microservice-communications.md)
### [Implementing an event bus with RabbitMQ for the development or test environment](multi-container-microservice-net-applications/rabbitmq-event-bus-development-test-environment.md)
### [Subscribing to events](multi-container-microservice-net-applications/subscribe-events.md)
### [Testing ASP.NET Core services and web apps](multi-container-microservice-net-applications/test-aspnet-core-services-web-apps.md)
## [Tackling Business Complexity in a Microservice with DDD and CQRS Patterns](microservice-ddd-cqrs-patterns/index.md)
### [Applying simplified CQRS and DDD patterns in a microservice](microservice-ddd-cqrs-patterns/apply-simplified-microservice-cqrs-ddd-patterns.md)
### [Applying CQRS and CQS approaches in a DDD microservice in eShopOnContainers](microservice-ddd-cqrs-patterns/eshoponcontainers-cqrs-ddd-microservice.md)
### [Implementing reads/queries in a CQRS microservice](microservice-ddd-cqrs-patterns/cqrs-microservice-reads.md)
### [Designing a DDD-oriented microservice](microservice-ddd-cqrs-patterns/ddd-oriented-microservice.md)
### [Designing a microservice domain model](microservice-ddd-cqrs-patterns/microservice-domain-model.md)
### [Implementing a microservice domain model with .NET Core](microservice-ddd-cqrs-patterns/net-core-microservice-domain-model.md)
### [Seedwork (reusable base classes and interfaces for your domain model)](microservice-ddd-cqrs-patterns/seedwork-domain-model-base-classes-interfaces.md)
### [Implementing value objects](microservice-ddd-cqrs-patterns/implement-value-objects.md)
### [Using Enumeration classes instead of enum types](microservice-ddd-cqrs-patterns/enumeration-classes-over-enum-types.md)
### [Designing validations in the domain model layer](microservice-ddd-cqrs-patterns/domain-model-layer-validations.md)
### [Client-side validation (validation in the presentation layers)](microservice-ddd-cqrs-patterns/client-side-validation.md)
### [Domain events: design and implementation](microservice-ddd-cqrs-patterns/domain-events-design-implementation.md)
### [Designing the infrastructure persistence layer](microservice-ddd-cqrs-patterns/infrastructure-persistence-layer-design.md)
### [Implementing the infrastructure persistence layer with Entity Framework Core](microservice-ddd-cqrs-patterns/infrastructure-persistence-layer-implemenation-entity-framework-core.md)
### [Using NoSQL databases as a persistence infrastructure](microservice-ddd-cqrs-patterns/nosql-database-persistence-infrastructure.md)
### [Designing the microservice application layer and Web API](microservice-ddd-cqrs-patterns/microservice-application-layer-web-api-design.md)
### [Implementing the microservice application layer using the Web API](microservice-ddd-cqrs-patterns/microservice-application-layer-implementation-web-api.md)
## [Implementing Resilient Applications](implement-resilient-applications/index.md)
### [Handling partial failure](implement-resilient-applications/handle-partial-failure.md)
### [Strategies for handling partial failure](implement-resilient-applications/partial-failure-strategies.md)
### [Implementing retries with exponential backoff](implement-resilient-applications/implement-retries-exponential-backoff.md)
### [Implementing resilient Entity Framework Core SQL connections](implement-resilient-applications/implement-resilient-entity-framework-core-sql-connections.md)
### [Implementing custom HTTP call retries with exponential backoff](implement-resilient-applications/implement-custom-http-call-retries-exponential-backoff.md)
### [Implementing HTTP call retries with exponential backoff with Polly](implement-resilient-applications/implement-http-call-retries-exponential-backoff-polly.md)
### [Implementing the Circuit Breaker pattern](implement-resilient-applications/implement-circuit-breaker-pattern.md)
### [Health monitoring](implement-resilient-applications/monitor-app-health.md)
## [Securing NET Microservices and Web Applications](secure-net-microservices-web-applications/index.md)
### [About authorization in .NET microservices and web applications](secure-net-microservices-web-applications/authorization-net-microservices-web-applications.md)
### [Storing application secrets safely during development](secure-net-microservices-web-applications/developer-app-secrets-storage.md)
### [Using Azure Key Vault to protect secrets at production time](secure-net-microservices-web-applications/azure-key-vault-protects-secrets.md)
## [Key takeaways](key-takeaways.md)
