/**
 * psyche
 * (c) 2022 dragonwocky <thedragonring.bod@gmail.com> (https://dragonwocky.me/)
 * (https://github.com/dragonwocky/psyche) under the MIT license
 */

import type { ClientConfig } from "../../types.d.ts";
import { css } from "../util.ts";

const properties = (config: ClientConfig) => {
  const { darkMode } = config.theme,
    darkPrefix = darkMode === "class"
      ? ".dark psyche-search"
      : "@media (prefers-color-scheme: dark) { psyche-search",
    darkSuffix = darkMode === "class" ? "" : "}";

  /* deno-fmt-ignore */
  return css`psyche-search{--brand-accent:#ea596e;--font-sans:${config.theme.font.sans};--font-mono:${config.theme.font.mono};--theme-text:${config.theme.light.text};--theme-secondary:${config.theme.light.secondary};--theme-background:${config.theme.light.background};--theme-shadow:${config.theme.light.shadow};--theme-border:${config.theme.light.border};--theme-accent:${config.theme.light.accent};--theme-interactive:${config.theme.light.interactive};--theme-scrollbar:${config.theme.light.scrollbar};--theme-scrollbar-hover:${config.theme.light.scrollbarHover};--message-no-results-found:"${config.messages.noResultsFound.replace(/"/g,'\\"')}"}${darkPrefix}{--brand-accent:#f4abba;--theme-text:${config.theme.dark.text};--theme-secondary:${config.theme.dark.secondary};--theme-background:${config.theme.dark.background};--theme-shadow:${config.theme.dark.shadow};--theme-border:${config.theme.dark.border};--theme-accent:${config.theme.dark.accent};--theme-interactive:${config.theme.dark.interactive};--theme-scrollbar:${config.theme.dark.scrollbar};--theme-scrollbar-hover:${config.theme.dark.scrollbarHover};}${darkSuffix}`;
};

const scoped = (config: ClientConfig) => {
  /* deno-fmt-ignore */
  const squareScrollbar = css`::-webkit-scrollbar{width:.5rem}`,
    roundedScrollbar = css`::-webkit-scrollbar{width:.75rem;background:transparent}::-webkit-scrollbar-thumb{border:3px solid var(--theme-background);border-radius:.375rem}`,
    scrollbarStyle = config.theme.scrollbarStyle === "square" ? squareScrollbar : roundedScrollbar;

  /* deno-fmt-ignore */
  return scrollbarStyle + css`*{box-sizing:border-box;scrollbar-width:thin;scrollbar-color:var(--theme-scrollbar) transparent}::-webkit-scrollbar{background:transparent}::-webkit-scrollbar-thumb{background:var(--theme-scrollbar)}::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-hover)}.psyche-wrapper,.psyche-shadow,.psyche-bubble,.psyche-input,.psyche-input-clear,.psyche-input-icon,.psyche-result,.psyche-result-scroller:empty::after,.psyche-result-section,.psyche-footer,.psyche-hotkey kbd,.psyche-copyright a,::-webkit-scrollbar-thumb{transition:all 100ms ease 0s}.psyche-wrapper,.psyche-input,.psyche-input::placeholder{font-family:var(--font-sans)}.psyche-hotkey kbd{font-family:var(--font-mono)}.psyche-wrapper{font-size:1rem;top:0;left:0;right:0;width:100%;height:100%;position:fixed;padding:3.5rem 2rem;display:flex;justify-content:center;pointer-events:auto;opacity:1;z-index:99999}.psyche-wrapper-hidden{pointer-events:none;opacity:0}.psyche-shadow{top:0;left:0;right:0;width:100%;height:100%;position:fixed;background:var(--theme-shadow)}.psyche-bubble{z-index:1;width:100%;height:100%;max-width:36rem;max-height:36rem;display:flex;flex-direction:column;border-radius:.375rem;box-shadow:rgba(0,0,0,.1) 0 10px 15px -3px,rgba(0,0,0,.1) 0 4px 6px -4px;color:var(--theme-text);background:var(--theme-background)}.psyche-input-label{display:block;margin:.75rem;position:relative;font-size:1.125rem;line-height:1.75rem}.psyche-input{font-size:1em;appearance:none;display:block;width:100%;border:none;border-radius:.375rem;padding:.75rem 5.5rem .75rem 1rem;color:var(--theme-text);background:var(--theme-interactive);box-shadow:var(--theme-border) 0 0 0 2px}.psyche-input:focus{outline:none;box-shadow:var(--theme-accent) 0 0 0 2px}.psyche-input::-webkit-search-decoration,.psyche-input::-webkit-search-cancel-button,.psyche-input::-webkit-search-results-button,.psyche-input::-webkit-search-results-decoration{-webkit-appearance:none;appearance:none}.psyche-input-clear{cursor:pointer;width:3em;height:100%;position:absolute;right:3em;bottom:0;top:0;padding:.75em}.psyche-input-clear:hover{color:var(--theme-accent)}.psyche-input:placeholder-shown+.psyche-input-clear:not(:hover){opacity:0}.psyche-input-icon{width:3em;height:100%;position:absolute;right:0;bottom:0;top:0;padding:.75em;border-top-right-radius:.375rem;border-bottom-right-radius:.375rem;background:var(--theme-background)}.psyche-result-scroller{margin-top:.25rem;padding:0 .75rem .75rem;overflow-y:auto;overflow-wrap:break-word;scroll-behavior:smooth}.psyche-result-scroller:empty::after{content:var(--message-no-results-found);font-size:.875rem;line-height:1.25rem;color:var(--theme-secondary)}.psyche-result-list{padding:0;margin-block-start:0;margin-block-end:0;list-style:none}.psyche-result-section{position:-webkit-sticky;position:sticky;top:0;display:block;width:calc(100% + 4px);margin:0 -2px 2px -2px;padding-bottom:.5rem;color:var(--theme-accent);background:var(--theme-background)}.psyche-result{text-decoration:none;cursor:pointer;display:flex;align-items:center;width:100%;margin-bottom:1rem;padding:.75rem 1rem;border-radius:.375rem;color:var(--theme-text);background:var(--theme-interactive)}.psyche-result-icon{height:1.5rem;width:1.5rem;margin-right:1rem;flex-shrink:0;color:var(--theme-secondary)}.psyche-result-content{margin:0;font-weight:500;font-size:.875rem;line-height:1.25rem}.psyche-result-content mark{background:transparent;color:var(--theme-accent)}.psyche-result-desc{margin:0;font-weight:500;font-size:.75rem;line-height:1rem;color:var(--theme-secondary)}.psyche-result-highlight{background:transparent;color:var(--theme-accent)}.psyche-result:hover{background:var(--theme-accent)}.psyche-result:hover *{color:var(--theme-interactive)}.psyche-result:hover mark{text-decoration:underline}.psyche-result:focus{outline:none;box-shadow:var(--theme-accent) 0 0 0 2px}.psyche-footer{display:flex;font-size:.75rem;line-height:1.25rem;margin-top:auto;padding:.5rem .25rem;color:var(--theme-secondary);border-top:2px solid var(--theme-border)}.psyche-hotkey-list{display:flex;flex-wrap:wrap;margin:auto 0}.psyche-hotkey{margin:.5rem}.psyche-hotkey kbd{padding:.25rem;margin-right:.25rem;font-size:.65rem;line-height:1rem;border-radius:.375rem;box-shadow:rgba(0,0,0,.1) 0 1px 3px 0,rgba(0,0,0,.1) 0 1px 2px -1px;color:var(--theme-text);background:var(--theme-interactive);border:2px solid var(--theme-border)}.psyche-copyright{display:flex;flex-direction:column;align-items:end;padding:.5rem 0;margin:auto .5rem 0 auto}.psyche-copyright span{margin-bottom:-.1rem}.psyche-copyright a{display:inline-flex;align-items:center;text-decoration:none;color:var(--brand-accent)}.psyche-copyright svg{width:1.2rem;height:1.2rem;margin:0 .2rem;padding-top:.2rem}@media (max-width:640px){.psyche-wrapper{padding:1rem}.psyche-hotkey{display:none}.psyche-copyright{padding:0;flex-direction:row}}`;
};

export { properties, scoped };
