# Changelog

## v0.3.4 (2022-02-23)

## Fixed

- Replaced `requestIdleCallback` with `setTimeout` for Safari support.

## v0.3.3 (2022-01-30)

## Added

- `scroll-behaviour: smooth`

## v0.3.2 (2022-01-29)

### Changed

- Focused results are outlined to differentiate them from
  hovered results.

### Fixed

- `<mark></mark>` elements are styled according to the accent
  colour (the browser's built-in yellow highlight doesn't contrast
  well with other light colours).

## v0.3.1 (2022-01-28)

### Added

- Exported the `platformModifier` string for direct use
  (e.g. in search trigger labels).

### Removed

- Removed `{{platformModifier}}` tag replacement.

### Fixed

- Depend on the more reliable `site.url(<string> page.data.url)`
  for detecting Lume page URLs.

## v0.3.0 (2022-01-27)

### Added

- Adjusted and exposed the internal hotkey registration
  for use with a `platformModifier` property equivalent
  to the `{{platformModifier}}` tag.

### Changed

- Moved the Lume indexer's slugifer to the `indexers/shared.ts` file.
- Renamed the `{{modifier}}` tag to `{{platformModifier}}`.

### Fixed

- Slugifier no longer slices the last letter off
  slugs generated from headings without spaces.
- Modals close when results are clicked.
- Removed `console.log` debug statement.
- Gave `position:sticky` priority over `position:-webkit-sticky`.

## v0.2.0 (2022-01-26)

### Added

- Configuration options.
- Zoom-in-zoom-out modal open animation.
- Rounded scrollbar style.
- Footer copyright.
- `{{modifier}}` tag for platform-specific hotkeys
  (replaced with `⌘` on MacOS and `CTRL` on other platforms).
- Added `list` and `code` result types.

### Changed

- Component constructed on the client-side instead of during site generation.
- Scoped CSS styling instead of utility classes.
- More efficient search caching logic.
- Tweaked text sizing and positioning.

### Fixed

- Slugs generated by the Lume indexer no longer cut words in half.
- The Lume indexer uses Deno's import map to infer the current version of
  Lume and prevent dependeny conflicts on Lume updates.
- Empty `<mark></mark>` elements are no longer added to results.
  This occured when the search input was empty and only `{ type: "page" }`
  results were displayed, and would cause e.g. `&` to be displayed as `&amp;`.

## v0.1.0 (2021-12-31)

First version, hardcoded into the notion-enhancer website.

- Site indexing performed during the build process.
- Basic exact & fuzzy search logic.
- Interface contained within a toggleable modal and styled with utility classes.
- A desktop-only footer with a list of available navigation hotkeys.
