DROP TABLE IF EXISTS `douhao_ad`;
CREATE TABLE `douhao_ad` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `board_id` int(5) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `url` text NOT NULL,
  `content` text NOT NULL,
  `extimg` varchar(255) NOT NULL,
  `extval` varchar(200) NOT NULL,
  `desc` varchar(255) NOT NULL,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  `clicks` int(10) NOT NULL DEFAULT '0',
  `add_time` int(11) NOT NULL DEFAULT '0',
  `ordid` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `board_id` (`board_id`),
  KEY `type` (`type`),
  KEY `start_time` (`start_time`),
  KEY `end_time` (`end_time`),
  KEY `ordid` (`ordid`),
  KEY `status` (`status`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_adboard`;
CREATE TABLE `douhao_adboard` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `tpl` varchar(20) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_admin`;
CREATE TABLE `douhao_admin` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(32) NOT NULL,
  `role_id` smallint(5) NOT NULL,
  `last_ip` varchar(15) DEFAULT NULL,
  `last_time` int(10) DEFAULT '0',
  `email` varchar(50) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_name` (`username`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_admin_auth`;
CREATE TABLE `douhao_admin_auth` (
  `role_id` tinyint(3) NOT NULL,
  `menu_id` smallint(6) NOT NULL,
  KEY `role_id` (`role_id`,`menu_id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_admin_role`;
CREATE TABLE `douhao_admin_role` (
  `id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `ordid` tinyint(3) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_article`;
CREATE TABLE `douhao_article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mid` varchar(16) NOT NULL,
  `cate_id` int(10) NOT NULL,
  `title` varchar(255) NOT NULL,  
  `mpic` VARCHAR(255) NULL DEFAULT NULL,
  `intro` text,
  `author` varchar(50) DEFAULT NULL COMMENT '作者',  
  `add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '发布状态：1发布 2待审',
  `tui` tinyint(1) DEFAULT '0',
  `hits` int(11) DEFAULT '0' COMMENT 'wen展示数',
  `push` tinyint(1) NOT NULL DEFAULT '0' COMMENT '推送状态',
  `fabu` tinyint(1) DEFAULT '0',
  `doc_id` varchar(255) DEFAULT NULL,
  `doc_id_2` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`),
  UNIQUE KEY `mid` (`mid`),  
  KEY `status` (`status`,`fabu`,`tui`),
  KEY `cate_id` (`cate_id`,`status`,`fabu`),
  KEY `mpic` (`mpic`,`status`,`fabu`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_article_1`;
CREATE TABLE `douhao_article_1` (
  `vid` int(11) unsigned NOT NULL,  
  `info` text NOT NULL,
  PRIMARY KEY (`vid`),
  UNIQUE KEY `vid` (`vid`)  
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_article_cate`;
CREATE TABLE `douhao_article_cate` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `ename` varchar(100) DEFAULT NULL,
  `ordid` smallint(4) unsigned NOT NULL DEFAULT '255',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `peitu` tinyint(1) NOT NULL DEFAULT '0',
  `seo_title` VARCHAR(255) NULL, 
  `seo_keys` VARCHAR(255) NULL, 
  `seo_desc` TEXT NULL,
  PRIMARY KEY (`id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_bdlist`;
CREATE TABLE `douhao_bdlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `aitxt` text COMMENT 'ai内容',
  `docid` varchar(100) DEFAULT '0' COMMENT 'AI生成ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未获取 1获取docid成功 2获取docid失败 3已获取内容',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_fabu_num`;
CREATE TABLE `douhao_fabu_num` (
  `date` varchar(100) NOT NULL,
  `num` int(11) NOT NULL DEFAULT '0'
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_klist`;
CREATE TABLE `douhao_klist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cate_id` int(10) NOT NULL,
  `title` varchar(200) NOT NULL,
  `bdtitle` text,
  `bdlist` text,
  `article_id` int(11) DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未采集 1已采集百度知道标题并生成docid 2采集百度知道失败 3已发布',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_ipban`;
CREATE TABLE `douhao_ipban` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `expires_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_ipay_log`;
CREATE TABLE `douhao_ipay_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `out_trade_no` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '自定义编号',
  `total_amount` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT '支付金额',
  `trade_no` varchar(64) CHARACTER SET utf8 NOT NULL COMMENT '订单号',
  `add_time` int(11) NOT NULL COMMENT '时间',
  `add_date` int(10) NOT NULL,
  `info` longtext CHARACTER SET utf8,
  `mod` varchar(20) CHARACTER SET utf8 NOT NULL,
  `openid` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `isalipay` tinyint(1) DEFAULT '0',
  `pass` tinyint(1) DEFAULT '1' COMMENT '是否支付成功',
  PRIMARY KEY (`id`),
  UNIQUE KEY `out_trade_no` (`out_trade_no`),
  UNIQUE KEY `trade_no` (`trade_no`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_link`;
CREATE TABLE `douhao_link` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `img` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `ordid` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_menu`;
CREATE TABLE `douhao_menu` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `pid` smallint(6) NOT NULL,
  `module_name` varchar(20) NOT NULL,
  `action_name` varchar(20) NOT NULL,
  `data` varchar(120) NOT NULL,
  `remark` varchar(255) NOT NULL,
  `often` tinyint(1) NOT NULL DEFAULT '0',
  `ordid` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `display` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `ordid` (`ordid`),
  KEY `often` (`often`),
  KEY `display` (`display`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_setting`;
CREATE TABLE `douhao_setting` (
  `name` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  KEY `name` (`name`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_tag`;
CREATE TABLE `douhao_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `k` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `k` (`k`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_up_log`;
CREATE TABLE `douhao_up_log` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `update_key` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `update_key` (`update_key`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_wpay_log`;
CREATE TABLE `douhao_wpay_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order` varchar(128) NOT NULL,
  `row` longtext NOT NULL,
  `add_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order` (`order`),
  KEY `add_time` (`add_time`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_plugin_log`;
CREATE TABLE `douhao_plugin_log` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `plugin_version` varchar(10) NOT NULL,
  `version` varchar(10) NOT NULL,
  `plugin_key` varchar(16) NOT NULL,
  `install_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plugin_key` (`plugin_key`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_plugin_up_log`;
CREATE TABLE `douhao_plugin_up_log` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `plugin_version` varchar(10) NOT NULL,
  `plugin_upkey` varchar(16) NOT NULL,
  `plugin_key` varchar(16) NOT NULL,
  `install_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plugin_upkey` (`plugin_upkey`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_theme_log`;
CREATE TABLE `douhao_theme_log` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `vna` varchar(100) NOT NULL,
  `version` varchar(10) NOT NULL,
  `theme_version` varchar(10) NOT NULL,
  `theme_key` varchar(16) NOT NULL,
  `install_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `theme_key` (`theme_key`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;

DROP TABLE IF EXISTS `douhao_theme_up_log`;
CREATE TABLE `douhao_theme_up_log` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `theme_version` varchar(10) NOT NULL,
  `theme_upkey` varchar(16) NOT NULL,
  `theme_key` varchar(16) NOT NULL,
  `install_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `theme_upkey` (`theme_upkey`)
) COLLATE='utf8_general_ci' ENGINE=MyISAM;