<?php
class articleModel extends RelationModel
{
    
    //自动验证
    protected $_validate = array(
        array('title', 'require', '{%article_title_empty}'),		
    );
	
	public function get_tag_by_title($title, $num=5){
        vendor('pscws4.pscws4', '', '.class.php');
        $pscws = new PSCWS4();
        $pscws->set_dict(FTX_DATA_PATH . 'scws/dict.utf8.xdb');
        $pscws->set_rule(FTX_DATA_PATH . 'scws/rules.utf8.ini');
        $pscws->set_ignore(true);
        $pscws->send_text($title);
        $words = $pscws->get_tops($num);
        $pscws->close();
        $tags = array();
        foreach ($words as $val) {
            $tags[] = $val['word'];
        }
        return $tags;
    }
	public function get_tag_by_titles($title){
		$title = mb_convert_encoding($title,'GBK','UTF-8');
        vendor('pscws3.pscws3', '', '.class.php');		
        $pscws = new pscws3();
        $pscws->set_dict(FTX_DATA_PATH . 'scws/dict.xdb');        
        $pscws->set_ignore_mark(true);	
		$pscws->set_autodis(true);
		$pscws->set_debug(false);		
		$words = $pscws->segment($title);
		$tags = array();
        foreach ($words as $val) {
			$val = mb_convert_encoding($val,'UTF-8','GBK');
            $tags[] = $val;
        }
		return $tags;
    }
	public function name_exists($rtitle, $id=0)
    {
        $pk = $this->getPk();
        $where = "rtitle='" . $rtitle . "'  AND ". $pk ."<>'" . $id . "'";
        $result = $this->where($where)->count($pk);
        if ($result) {
            return true;
        } else {
            return false;
        }
    }
	public function hits($id){
		$this->where(array('id'=>$id))->setInc('hits',1);
	}
	public function ajax_publish($item) {
        if ($this->where(array('title'=>$item['title']))->count()) {
           return 0;
        }         		
        $this->create($item);
        $item_id = $this->add();
        if ($item_id) {
            return $item_id;
        } else {
            return 0;
        }
    }
	
	public function xiufusql($sqlname){
		$config_file = CONF_PATH . 'db.php';
        $config = require $config_file;
		$sqlgradename = $config['DB_PREFIX'].$sqlname;
		$tagsql = M($sqlname);
		if(!$tagsql->getDbError()){
$sql = "REPAIR TABLE `".$sqlgradename."`;";        
        $result = $this->execute($sql);
        if($result ===false){
           return 0;	
        }else{
           return 1;	
        }
        }else{
           return 9999;	
		}
	}
	
    	
}