<?php
class article_cateAction extends BackendAction {
    public function _initialize() {
        parent::_initialize();
        $this->_mod = D('article_cate');
    }

    public function index() {
        $sort = $this->_request("sort", 'trim', 'ordid');
        $order = $this->_request("order", 'trim', 'DESC');
        $tree = new Tree();
        $tree->icon = array('│ ','├─ ','└─ ');
        $tree->nbsp = '&nbsp;&nbsp;&nbsp;';
        $result = $this->_mod->order($sort . ' ' . $order)->select();
        $array = array();
        foreach($result as $r) {          
            $r['str_status'] = '<img data-tdtype="toggle" data-id="'.$r['id'].'" data-field="status" data-value="'.$r['status'].'" src="__STATIC__/images/admin/toggle_' . ($r['status'] == 0 ? 'disabled' : 'enabled') . '.gif" />';
			$r['str_peitu'] = '<img data-tdtype="toggle" data-id="'.$r['id'].'" data-field="peitu" data-value="'.$r['peitu'].'" src="__STATIC__/images/admin/toggle_' . ($r['peitu'] == 0 ? 'disabled' : 'enabled') . '.gif" />';
            $r['str_manage'] = '<a href="javascript:;" class="J_showdialog" data-uri="'.U('article_cate/edit',array('id'=>$r['id'])).'" data-title="'.L('edit').' - '. $r['name'] .'" data-id="edit" data-width="480" data-height="90">'.L('edit').'</a> | <a href="javascript:;" data-acttype="ajax" class="J_confirmurl" data-uri="'.U('article_cate/delete',array('id'=>$r['id'])).'" data-msg="'.sprintf(L('confirm_delete_one'),$r['name']).'">'.L('delete').'</a>';
            $r['parentid_node'] = ($r['pid'])? ' class="child-of-node-'.$r['pid'].'"' : '';
            $array[] = $r;
        }
        $str  = "<tr id='node-\$id' \$parentid_node>
                <td align='center'><input type='checkbox' value='\$id' class='J_checkitem'></td>
				<td align='center'>\$id</td>
                <td align='center'>\$spacer<span data-tdtype='edit' data-field='name' data-id='\$id' class='tdedit'>\$name</span></td> 	
				<td align='center'>\$spacer<span data-tdtype='edit' data-field='ename' data-id='\$id' class='tdedit'>\$ename</span></td>
                <td align='center'><span data-tdtype='edit' data-field='ordid' data-id='\$id' class='tdedit'>\$ordid</span></td>
                <td align='center'>\$str_status</td>
				<td align='center'>\$str_peitu</td>
                <td align='center'>\$str_manage</td>
                </tr>";
        $tree->init($array);
        $list = $tree->get_tree(0, $str);
        $this->assign('list', $list);
        $big_menu = array(
            'title' => L('add_article_cate'),
            'iframe' => U('article_cate/add'),
            'id' => 'add',
            'width' => '480',
            'height' => '90'
        );
        $this->assign('big_menu', $big_menu);
        $this->assign('list_table', true);
        $this->display();
    }

    /**
     * 添加子菜单上级默认选中本栏目
     */
    public function _before_add() {
        
    }

    /**
     * 入库数据整理
     */
    protected function _before_insert($data = '') {
        //检测分类是否存在
        if($this->_mod->name_exists($data['name'], $data['id'])){
            $this->ajaxReturn(0, L('article_cate_already_exists'));
        }
		//检测分类拼音是否存在
        if($this->_mod->ename_exists($data['ename'], $data['id'])){
            $this->ajaxReturn(0, '拼音已存在');
        }
        $peitupath = "data/upload/peitu/".$data['ename']."/";
		$this->make_dir($peitupath);
		$txtpath = "data/upload/autotxt/".$data['id']."/";
		$this->make_dir($txtpath);		
        return $data;
    }
    
    /**
     * 修改提交对数据
     */
    protected function _before_update($data = '') {
        if ($this->_mod->name_exists($data['name'],  $data['id'])) {
            $this->ajaxReturn(0, L('article_cate_already_exists'));
        }
		if ($this->_mod->ename_exists($data['ename'],  $data['id'])) {
            $this->ajaxReturn(0, '拼音已存在');
        }
		$peitupath = "data/upload/peitu/".$data['ename']."/";
		$this->make_dir($peitupath);	
		$txtpath = "data/upload/autotxt/".$data['id']."/";
		$this->make_dir($txtpath);
        return $data;
    }
    
	
    public function make_dir($path)
    {
        if (!file_exists($path)) {
            $mk = @mkdir($path, 0777, true);
            @chmod($path, 0777, true);
        }
        return true;
    }

    public function ajax_getchilds() {
        $id = $this->_get('id', 'intval');
        $return = $this->_mod->field('id,name')->where(array('pid'=>$id))->select();
        if ($return) {
            $this->ajaxReturn(1, L('operation_success'), $return);
        } else {
            $this->ajaxReturn(0, L('operation_failure'));
        }
    }
}